<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Contributing Developer: Michael Pierce (mpdev.net)                     //
//                         Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( $user, $userid );

function get_userinfo( $authuser, $userid=0 )
 {
    global $Globals, $db_link;

    if ( $userid != 0 )
    {
        $query = "SELECT u.userid,u.username,u.email,u.password,u.usergroupid,u.timezoneoffset,s.sessionhash,u.salt,s.lastactivity,u.membergroupids FROM {$Globals['dprefix']}user u LEFT JOIN {$Globals['dprefix']}session s ON s.userid=u.userid WHERE u.userid=$userid";
    }
    else
    {
        $query = "SELECT userid,username,email,password,usergroupid,timezoneoffset,salt,lastactivity,membergroupids FROM {$Globals['dprefix']}user WHERE username='$authuser'";
    }

    $queryv = ppmysql_query($query, $db_link);
    $results = mysql_fetch_array($queryv);

    $mgroups = $results['usergroupid'];

    if ( $results['membergroupids'] )
    {
        $mgroups .= ",{$results['membergroupids']}";
    }

    $username = array(
                    $results['userid'],            // userid
                    $results['username'],          // username
                    $results['email'],             // email
                    $results['password'],          // password
                    null,                          // temppassword
                    $mgroups,                      // groups
                    $results['timezoneoffset'],    // timeoffset
                    $results['sessionhash'],       // session id
                    $results['salt'],              // password salt
                    $results['lastactivity']       // last activity
                 );

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers()
{
    global $Globals, $db_link;

    $queryv = ppmysql_query("SELECT data FROM {$Globals['dprefix']}datastore WHERE title = 'userstats'", $db_link);
    $results = mysql_fetch_array($queryv);
    $userstats = unserialize($results['data']);

    return( $userstats['numbermembers'] );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" )
{
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/member.php?u=$tuserid";
    $privatelink = "{$Globals['vbulletin']}/private.php?do=newpm&amp;u=$tuserid";
    $postreply = "<img src=\"{$Globals['idir']}/reply.gif\" border=\"0\" alt=\"Post A Reply\" />";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts()
{
    global $Globals, $db_link;

    $useropts= null;

    $queryv = ppmysql_query("SELECT userid,username FROM {$Globals['dprefix']}user ORDER BY username",$db_link);

    while ( list( $userid, $username ) = mysql_fetch_row($queryv) )
    {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 )
{
    global $Globals, $db_link, $User;

    if ( !$userid )
    {
        $usernum = $User['userid'];
    }
    else
    {
        $usernum = $userid;
    }

    if ( $type == "plus" )
    {
        $do_inc = "+1";
    }
    else
    {
        $do_inc = "-1";
    }

    $resulta = ppmysql_query("UPDATE {$Globals['dprefix']}user SET posts=posts$do_inc WHERE userid=$usernum",$db_link);

    return;
}


function get_profiledata( $cuserid )
{
    global $Globals, $db_link, $vboptions;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = $ctitle = $cposts = $chomepage = $postline = $hpage = $ugallery = null;
    $cuser = $Globals['pp_lang']['unreg'];
    $userprofile = array( "Anonymous","","","","","","","","","" );

    if ($cuserid != 0)
    {
        $query = "SELECT u.username,u.homepage,u.usertitle,u.posts,u.joindate,uf.field2,s.host,t.signature,sigpic.filename,u.sigpicrevision";

        if( $vboptions['avatarenabled'] )
        {
            $query .= ",avatar.avatarpath, NOT ISNULL(customavatar.". iif( VB35 == "on", "filedata", "avatardata" ) .") AS hascustomavatar,u.avatarrevision";
        }

        $query .= " FROM {$Globals['dprefix']}user u
            LEFT JOIN {$Globals['dprefix']}userfield uf ON uf.userid=u.userid
            LEFT JOIN {$Globals['dprefix']}session s ON s.userid=u.userid
            LEFT JOIN {$Globals['dprefix']}usertextfield t ON t.userid=u.userid
            LEFT JOIN {$Globals['dprefix']}sigpic AS sigpic ON sigpic.userid=u.userid
            LEFT JOIN {$Globals['dprefix']}sigparsed AS sigparsed ON sigparsed.userid=u.userid ";

        if( $vboptions['avatarenabled'] )
        {
            $query .= "LEFT JOIN {$Globals['dprefix']}avatar AS avatar ON (avatar.avatarid = u.avatarid)
                       LEFT JOIN {$Globals['dprefix']}customavatar AS customavatar ON (customavatar.userid = u.userid) ";
        }

        $query .= "WHERE u.userid=$cuserid LIMIT 1";
        $results = ppmysql_query($query,$db_link);

        if( $vboptions['avatarenabled'] )
        {
            list( $cuser, $chomepage, $ctitle, $cposts, $regdate, $clocation, $conline, $csig, $sigpicfile, $sigpicrev, $avpath, $hasav, $avrev ) = mysql_fetch_row($results);
        }
        else
        {
            list( $cuser, $chomepage, $ctitle, $cposts, $regdate, $clocation, $conline, $csig, $sigpicfile, $sigpicrev ) = mysql_fetch_row($results);
        }
        ppmysql_free_result( $results );

        if ( $chomepage )
        {
            $hpage = "<a href=\"$chomepage\" target=\"_blank\"><img src=\"{$Globals['idir']}/home.gif\" alt=\"Visit ".$cuser."'s homepage!\" border=\"0\" /></a>";
        }

        if ( $conline == "" )
        {
            $isonline = "<img src=\"{$Globals['idir']}/vb2off.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['offline']}\" align=\"middle\" /> ";
        }
        else
        {
            $isonline = "<img src=\"{$Globals['idir']}/vb2on.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['online']}\" align=\"middle\" /> ";
        }

        $userprofile = array (
                                $cuser,                   // Username
                                $chomepage,               // Homepage
                                $cposts,                  // Total Posts
                                $ctitle,                  // Title
                                $regdate,                 // Registered Date
                                $clocation,               // Location
                                $sigpicfile,               // SigPic File
                                $sigpicrev,                // SigPic Revision
                                null                      // Avatar
                             );

        if ( $hasav != "" )
        {
            if ( isset($avpath) ) 
            {
                $userprofile[6] = "<img src=\"{$Globals['vbulletin']}/$avpath\" border=\"0\" alt=\"\" />";   // Avatar
            }
            elseif ( $vboptions['usefileavatar'] && $hasav != "" && $avrev !=0 )
            {
                $userprofile[6] = "<img src=\"{$Globals['vbulletin']}/$vboptions[avatarurl]/avatar{$cuserid}_{$avrev}.gif\" border=\"0\" alt=\"\" />";   // Avatar
            }
            elseif ( $hasav == 1 )
            {
                $userprofile[6] = "<img src=\"{$Globals['vbulletin']}/image.php?u=$cuserid\" border=\"0\" alt=\"\" />";   // Avatar
            }
            else
            {
                $userprofile[6]= null;   // Avatar
            }
        }

        if ( $sigpicfile )
        {

             $queryz = ppmysql_query("SELECT value FROM {$Globals['dprefix']}setting WHERE varname = 'sigpicurl'",$db_link);
             list( $sigpicurl ) = mysql_fetch_row($queryz);
             $sigext = get_ext( $sigpicfile );


             if ( $vboptions['usefileavatar'] )
             {
                  $sigpic = "<br /><img src=\"{$Globals['vbulletin']}/{$sigpicurl}/sigpic{$cuserid}_{$sigpicrev}.gif\" alt=\"\" /><br />";
             }
             else
             {
                  $sigpic = "<br /><img src=\"{$Globals['vbulletin']}/image.php?type=sigpic&userid=$cuserid\" border=\"0\"><br />";
             }

             $csig = str_replace("[SIGPIC][/SIGPIC]", "$sigpic", $csig);

        }

        $userprofile[7] = $csig;  // Signature
    }

    $ugallery = "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $cuserid, 'username' => $cuser) ) . "\"><img alt=\"{$Globals['pp_lang']['visitgallery']}\" border=\"0\" src=\"{$Globals['idir']}/gallery.gif\" /></a>";

    $postline = "<a href=\"$profilelink\" target=\"_blank\"><img
        src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a> <a href=\"$privatelink\"><img
        src=\"{$Globals['idir']}/vb2sendpm.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['sendpm']}\" /></a>  $hpage
        <a href=\"{$Globals['vbulletin']}/search.php?s=&amp;action=finduser&amp;userid=$cuserid\"><img
        src=\"{$Globals['idir']}/vb2find.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['find']}\" /></a><!--PhotoPost, copyright All, Enthusiast, Inc.-->
        $ugallery
        </td>";

    return( $userprofile );
}

function setlogin( $password )
{
    global $Globals, $User, $db_link, $_SERVER;

    setcookie( "{$Globals['cookieprefix']}userid", "{$User['userid']}", time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    $dbpassword = md5(md5($password) . $User['salt']);
    $cookiepass = md5($dbpassword . $Globals['vblicense']);
    setcookie( "{$Globals['cookieprefix']}password", $cookiepass, time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    $session_id = md5( uniqid(microtime()) );
    setcookie("{$Globals['cookieprefix']}sessionhash","$session_id","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    $ipaddr = addslashes( findenv("REMOTE_ADDR") );
    $agent = findenv("HTTP_USER_AGENT");
    $browser = addslashes( substr($agent, 0, 50) ) ;
    $sesstime = time();
    $idhash = md5(time());

    ppmysql_query("DELETE FROM {$Globals['dprefix']}session WHERE userid='{$User['userid']}'", $db_link);
    ppmysql_query("INSERT INTO {$Globals['dprefix']}session (sessionhash, userid, host, idhash, lastactivity, useragent)
        VALUES ('$session_id',{$User['userid']},'$ipaddr','$idhash','$sesstime','$browser')", $db_link);

    return;
}


function logout()
{
    global $Globals, $User, $db_link;

    setcookie( "{$Globals['cookieprefix']}userid", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}password", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "sessionhash", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    if ( $User['userid'] > 0 )
    {
        ppmysql_query("DELETE FROM {$Globals['dprefix']}session WHERE userid='{$User['userid']}'",$db_link);
    }

    return;
}

function get_regcode()
{
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/register.php?action=signup\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode()
{
    global $Globals;

    $links[0] = "{$Globals['vbulletin']}/member.php?ppaction=lostpw";
    $links[1] = "{$Globals['vbulletin']}/register.php?action=signup";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" )
{
    global $Globals, $User, $password, $link, $db_link, $phoedit, $gologin, $up_k, $disk_k, $cedit;
    global $diskspace, $uploadsize, $usergroups, $vbuserid, $bbuserinfo, $vbulletin;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $cookuser = $Globals['cookieprefix']."userid";
    $cookhash = $Globals['cookieprefix']."sessionhash";
    $cookpass = $Globals['cookieprefix']."password";

    $$cookuser = $_COOKIE["$cookuser"];
    $$cookhash = $_COOKIE["$cookhash"];
    $$cookpass = $_COOKIE["$cookpass"];

    // Init some variables
    $User = array();
    $User['uploads'] = $User['userid'] = $User['adminedit'] = $User['moderator'] = $User['albums'] = $User['uploadlimit'] = 0;
    $User['nopost'] = $gologin = 1;

    // vB3.5 uses $vbulletin; use this in case we're integrated
    $vbuserid = ( isset($bbuserinfo['userid']) ? $bbuserinfo['userid'] : $vbulletin->userinfo['userid'] );

    $usergroups = $md5cookpass = null;
    $checkpass = $ueditpho = $ueditposts = $diskspace = $uploadsize = 0;

    if ( !$vbuserid )
    {
        if ( !$authuser )
        {
            if ( $$cookuser )
            {
                $cookuser = $$cookuser;
            }
            elseif ( $$cookhash )
            {
                $sessid = addslashes($$cookhash);

                $results = ppmysql_query("SELECT userid FROM {$Globals['dprefix']}session WHERE sessionhash='$sessid' LIMIT 1", $db_link);
                list( $cookuser ) = mysql_fetch_row($results);
            }

            $md5cookpass = $$cookpass;

            list( $userid, $username, $email, $dbpassword, $temppass, $usergroups, $offset, $sessionid, $salt, $lastactivity ) = get_userinfo( "", $cookuser );
        }
        else
        {
            $cookuser = addslashes($authuser);

            list( $userid, $username, $email, $dbpassword, $temppass, $usergroups, $offset, $sessionid, $salt, $lastactivity ) = get_userinfo( $cookuser );

            $md5cookpass = md5(md5(md5($password) . $salt) . $Globals['vblicense']);
        }

        $md5dbpass = md5( $dbpassword . $Globals['vblicense'] );

        // Check if session is valid
        if ( $$cookhash && ($sessionid == $$cookhash) )
        {
            $checkpass = 1;
        }
        elseif ( $dbpassword )
        {
            if ($md5dbpass == $md5cookpass)
            {
                $checkpass = 1;
            }

            // just to be sure, lets see if they have a temp pass for verification and do the same checks
            if ( $temppass && $checkpass != 1 )
            {
                if ( $md5cookpass == $temppass )
                {
                    $checkpass = 1;
                }
            }
        }
    }
    else
    {
        $checkpass = 1;
        list( $userid, $username, $email, $dbpassword, $temppass, $usergroups, $offset, $sessionid, $salt, $lastactivity ) = get_userinfo( "", $vbuserid );
    }

    $julian = time();
    $ipaddr = findenv("REMOTE_ADDR");
    $loc = addslashes( $_SERVER['REQUEST_URI'] );

    if ( $lastactivity != $julian )
    {
        if ( $userid > 0 )
        {
            ppmysql_query("UPDATE {$Globals['dprefix']}session SET lastactivity = '$julian' , location = '$loc' WHERE userid='$userid'",$db_link);
        }
        else
        {
            ppmysql_query("UPDATE {$Globals['dprefix']}session SET lastactivity = '$julian' , location = '$loc' WHERE host='$ipaddr'",$db_link);
        }
    }

    if ( $checkpass == 1 )
    {
        $gologin = $User['nopost'] = 0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['email'] = $email;
        $User['offset'] = $offset;
        $User['salt'] = $salt;
    }
    else
    {
        $usergroups = "1";
    }

    $vbgroups = explode( ",", $usergroups);
    $CatPerms = array();

    set_user_perms( $vbgroups );

    return( $gologin );
}

function import_user_groups()
{
    global $Globals, $db_link, $link;

    $resultcur = ppmysql_query("SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups", $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) )
    {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $readug = ppmysql_query("SELECT usergroupid,title,adminpermissions FROM {$Globals['dprefix']}usergroup",$db_link);
    $newGroups = array();

    while ( list($gid, $title, $cancontrol) = mysql_fetch_row( $readug ) )
    {
        if ( $cancontrol == 3)
        {
            $cancontrol = 1;
        }

        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) )
        {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  $cancontrol;
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }
    }

    foreach ($currentGroups as $currentGroup)
    {
        $gid = $currentGroup['groupid'];

        if ( !array_key_exists($gid, $newGroups))
        {
            unset($currentGroups[$gid]);
        }
    }

    $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}usergroups", $link);

    foreach ($currentGroups as $currentGroup)
    {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $setug = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign)
                  VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')", $link);
    }
}


function init_user_groups()
{
    global $link, $pp_db_prefix;

    $setup = mysql_query("CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM", $link);
    return($setup);
}


function convert_markups($markup)
{
    global $Globals, $vboptions, $bbcode_parser, $vbulletin;

    if ( VB3_ENHANCEDINT == "on" && function_exists('convert_url_to_bbcode') )
    {
        $vboptions['allowhtml'] = 1;
        $markup = fetch_censored_text($markup);
        $markup = convert_url_to_bbcode($markup);

        if ( VB35 == "off" )
        {
            $newmarkup = parse_bbcode($markup);
        }
        else
        {
            $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
            $newmarkup = $bbcode_parser->do_parse($markup);
        }

        $newmarkup = str_replace("\"images", "\"{$Globals['vbulletin']}/images", $newmarkup );

        return($newmarkup);
    }
    else
    {
        return ( ppconvert_markups($markup) );
    }
}

function get_forum_style()
{
    global $Globals;

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['dprefix']}users SET usergroupid='$usergroup' WHERE userid='$userid'", $db_link);
	}

    return;
}

//
// Style references
//

if ( $Globals['forumstyle'] == "yes" )
{
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "tborder";
    $Style['tablesurround']= null;
    $Style['tddetails'] = "alt1";
    $Style['tdbackground'] = "panelsurround";
    $Style['tdnothumbs'] = "tcat";
    $Style['menubar'] = "tcat";
    $Style['menubarnb']= null;
    $Style['catcolumn'] = "alt1Active";
    $Style['photocol'] = "alt1";
    $Style['commentscol'] = "alt2";
    $Style['lastphocol'] = "alt2";
    $Style['lastcommcol'] = "alt1";
    $Style['small'] = "smallfont";
    $Style['medium'] = "normal";
    $Style['large'] = "normal";
    $Style['welcome'] = "welcome";
    $Style['lighttable'] = "mysiwyg";
    $Style['alternatetable'] = "alt1";
    $Style['formboxes'] = "textarea";
    $Style['blockquote'] = "bginput";
}

if ( !$Globals['cookieprefix'] )
{
    $Globals['cookieprefix'] = "bb";
}

?>
