<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( $user, $userid );

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}users SET usergroupid='$usergroup' WHERE userid='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    if ( $userid != 0 ) $query = "SELECT userid,username,email,password,usergroupid,timezoneoffset FROM user WHERE userid=$userid";
    else $query = "SELECT userid,username,email,password,usergroupid,timezoneoffset FROM user WHERE username='$authuser'";

    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_array($queryv);

    $username[0] = $results['userid'];            // userid
    $username[1] = $results['username'];          // username
    $username[2] = $results['email'];             // email
    $username[3] = $results['password'];          // password
    $username[4] = "";                            // temppassword
    $username[5] = $results['usergroupid'];       // groups
    $username[6] = $results['timezoneoffset'];    // timeoffset
    $username[7] = "";                            // session id

    ppmysql_free_result($queryv);

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    $query = "SELECT COUNT(*) AS total FROM user";
    $queryv = ppmysql_query($query, $db_link);
    $results = mysql_fetch_array($queryv);

    return( intval($results['total']) );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/member.php?action=getinfo&amp;userid=$tuserid";
    $privatelink = "{$Globals['vbulletin']}/private.php?action=newmessage&amp;userid=$tuserid";
    $postreply = "<img src=\"{$Globals['vbulletin']}/images/reply.gif\" border=\"0\" alt=\"Post A Reply\" />";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";
    $query = "SELECT userid,username FROM user ORDER BY username";

    $queryv = ppmysql_query($query,$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }
    ppmysql_free_result($rows);

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) {
        $do_inc = "+1";
    }
    else {
        $do_inc = "-1";
    }

    $query = "UPDATE user SET posts=posts$do_inc WHERE userid=$usernum";
    $resulta = ppmysql_query($query,$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";
        $userprofile = array("Anonymous","","","","","","","","","");


    if ($cuserid != 0) {
        $query = "SELECT u.username,u.homepage,u.usertitle,u.posts,u.joindate,uf.field2,s.host,u.signature FROM user u
            LEFT JOIN userfield uf ON uf.userid=$cuserid
            LEFT JOIN session s ON s.userid=$cuserid
            WHERE u.userid=$cuserid LIMIT 1";
        $results = ppmysql_query($query,$db_link);
        list( $cuser, $chomepage, $ctitle, $cposts, $regdate, $clocation, $conline, $csig ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        if ( $chomepage != "" ) {
            $hpage = "<a href=\"$chomepage\" target=\"_blank\"><img
                src=\"{$Globals['vbulletin']}/images/home.gif\" alt=\"Visit ".$cuser."'s homepage!\" border=\"0\" /></a>";
        }

        if ($conline == "") {
            $isonline = "<img src=\"{$Globals['vbulletin']}/images/off.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['offline']}\" align=\"absmiddle\" /> ";
        }
        else {
            $isonline = "<img src=\"{$Globals['vbulletin']}/images/on.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['online']}\" align=\"absmiddle\" /> ";
        }

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = $clocation;               // Location
        $userprofile[6] = "<img src=\"{$Globals['vbulletin']}/avatar.php?userid=$cuserid\" border=\"0\">";  // Avatar
        $userprofile[7] = convert_markups(nl2br($csig));   // Signature
    }

    $ugallery = "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $cuserid, 'username' => $cuser) ) . "\"><img alt=\"{$Globals['pp_lang']['visitgallery']}\" border=\"0\" src=\"{$Globals['idir']}/gallery.gif\" /></a>";

    $postline = "<a href=\"$profilelink\" target=\"_blank\"><img
        src=\"{$Globals['vbulletin']}/images/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a> <a href=\"$privatelink\"><img
        src=\"{$Globals['vbulletin']}/images/sendpm.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['sendpm']}\" /></a>  $hpage
        <a href=\"{$Globals['vbulletin']}/search.php?s=&action=finduser&amp;userid=$cuserid\"><img
        src=\"{$Globals['vbulletin']}/images/find.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['find']}\" /></a><!--PhotoPost, copyright All, Enthusiast, Inc.-->
        <a href=\"{$Globals['vbulletin']}/member2.php?s=&action=addlist&amp;userlist=buddy&amp;userid=$cuserid\"><img
        src=\"{$Globals['vbulletin']}/images/buddy.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['addbuddy']}\" /></a> $ugallery
        </td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User;

    setcookie( "bbuserid", "{$User['userid']}", time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );
    $dbpassword = md5($password);
    setcookie( "bbpassword", $dbpassword, time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    return;
}


function logout() {
    global $Globals;

    setcookie( "bbuserid", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "bbpassword", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    return;
}

function get_regcode()
{
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/register.php?action=signup\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode()
{
    global $Globals;

    $links[0] = "{$Globals['vbulletin']}/member.php?ppaction=lostpw";
    $links[1] = "{$Globals['vbulletin']}/register.php?action=signup";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" )
{
    global $Globals, $User, $password, $link, $db_link;
    global $phoedit, $gologin;
    global $up_k, $disk_k, $cedit, $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $bbuserid = $_COOKIE["bbuserid"];
    $bbpassword = $_COOKIE["bbpassword"];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    if ( $authuser == "" )
    {
        $cookuser = $bbuserid;
        $md5cookpass = $bbpassword;
        list( $userid, $username, $email, $dbpassword, $temppass, $usergroup, $offset ) = get_userinfo( "", $cookuser );
    }
    else
    {
        $cookuser = addslashes($authuser);
        $md5cookpass = md5($password);
        list( $userid, $username, $email, $dbpassword, $temppass, $usergroup, $offset ) = get_userinfo( $cookuser );
    }

    if ($dbpassword != "")
    {
        if ($md5cookpass == "") $md5cookpass = $bbpassword;

        // early 2.0.3 versions need to uncomment the line below and comment out the line after it
        //$md5dbpass = md5($dbpassword);
        $md5dbpass = $dbpassword;

        if ($md5dbpass == $md5cookpass)
        {
            // user passed
            $gologin=0;
            $User['nopost'] = 0;
            $User['userid'] = $userid;
            $User['username'] = $username;
            $User['email'] = $email;
            $User['offset'] = $offset;
        }
    }
    else
    {
        // login for guests
        $usergroup = 1;
    }

    // groups less than 1 have no posting privledges..
    if ( $usergroup < 1 )
    {
        $User['nopost'] = 1;
    }

    $CatPerms = array();

    set_user_perms( array($usergroup) );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT usergroupid,title,cancontrolpanel FROM usergroup";
    $readug = ppmysql_query($query,$db_link);
    $newGroups = array();

    while ( list($gid, $title, $cancontrol) = mysql_fetch_row( $readug ) ) {
        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  $cancontrol;
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }

    }
    ppmysql_free_result( $readug );

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    $query = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
    $resulta = ppmysql_query($query, $link);

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $query="INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign) VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
        $setug = ppmysql_query($query,$link);
    }
}


function init_user_groups() {
    global $link, $pp_db_prefix;

    $query = "CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;";
    $setup = mysql_query($query,$link);

    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}

function get_forum_style()
{
    global $Globals;

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "tableborders";
    $Style['tablesurround'] = "";
    $Style['tddetails'] = "tddetails";
    $Style['tdbackground'] = "tdbackground";
    $Style['tdnothumbs'] = "tdnothumbs";
    $Style['menubar'] = "menubar";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "catcolumn";
    $Style['photocol'] = "photocol";
    $Style['commentscol'] = "commentscol";
    $Style['lastphocol'] = "lastphocol";
    $Style['lastcommcol'] = "lastcommcol";
    $Style['small'] = "small";
    $Style['medium'] = "medium";
    $Style['large'] = "large";
    $Style['welcome'] = "welcome";
    $Style['lighttable'] = "lighttable";
    $Style['alternatetable'] = "alternatetable";
    $Style['formboxes'] = "formboxes";
    $Style['blockquote'] = "blockquote";
}

?>
