<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $dbpassword, $vbgroups, $sessionid, $loginname, $fstyle, $offset, $md5temppass) = get_userinfo( $user, $userid );

if ( empty($Globals['dprefix']) ) $Globals['dprefix'] = "ubbt_";

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}USER_GROUPS SET GROUP_ID='$usergroup' WHERE USER_ID='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    if ( $userid ) {
        $query = "SELECT u.USER_ID,u.USER_DISPLAY_NAME,u.USER_REGISTRATION_EMAIL,u.USER_PASSWORD,u.USER_SESSION_ID,u.USER_LOGIN_NAME,p.USER_STYLE,p.USER_TIME_OFFSET,p.USER_TEMPORARY_PASSWORD FROM {$Globals['dprefix']}USERS u
    				     LEFT JOIN {$Globals['dprefix']}USER_PROFILE p ON p.user_id=u.user_id
						 WHERE u.user_id=$userid";
	}
    else {
        $tuser = addslashes( $authuser );
        $query = "SELECT u.USER_ID,u.USER_DISPLAY_NAME,u.USER_REGISTRATION_EMAIL,u.USER_PASSWORD,u.USER_SESSION_ID,u.USER_LOGIN_NAME,p.USER_STYLE,p.USER_TIME_OFFSET,p.USER_TEMPORARY_PASSWORD FROM {$Globals['dprefix']}USERS u
    				     LEFT JOIN {$Globals['dprefix']}USER_PROFILE p ON p.user_id=u.user_id
  						 WHERE u.user_login_name='$tuser'";
    }

    $queryv = ppmysql_query($query, $db_link);
    $results = mysql_fetch_array($queryv);

    $username[0] = $results['USER_ID'];       // userid
    $username[1] = $results['USER_DISPLAY_NAME'];     // username
    $username[2] = $results['USER_REGISTRATION_EMAIL'];        // email
    $username[3] = $results['USER_PASSWORD'];     // password
    $username[5] = $results['USER_SESSION_ID'];    // session id
    $username[6] = $results['USER_LOGIN_NAME'];     // loginname
    $username[7] = $results['USER_STYLE'];     // stylesheet
    $username[8] = $results['USER_TIME_OFFSET'];     // offset
    $username[9] = $results['USER_TEMPORARY_PASSWORD'];     // temporary pass
    ppmysql_free_result($queryv);

    if ( $username[0] )
    {
        $query = "SELECT GROUP_ID FROM {$Globals['dprefix']}USER_GROUPS WHERE USER_ID=" . $username[0];
        $result = ppmysql_query($query, $db_link);

        $vbgroups = array();
	    while(list($gid) = mysql_fetch_array($result)) {
            $vbgroups[] = $gid;
        }
    }

    ppmysql_free_result($result);

    $username[4] = $vbgroups;

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    $queryv = ppmysql_query("SELECT COUNT(*) FROM {$Globals['dprefix']}USERS", $db_link);
    $totalusers = mysql_result($queryv, 0);

    return( $totalusers-1 );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/ubbthreads.php?ubb=showprofile&User=$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    $queryv = ppmysql_query("SELECT USER_ID,USER_LOGIN_NAME FROM {$Globals['dprefix']}USERS ORDER BY USER_LOGIN_NAME",$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) $do_inc = "+1";
    else $do_inc = "-1";

    $resulta = ppmysql_query("UPDATE {$Globals['dprefix']}USER_PROFILE SET USER_TOTAL_POSTS=USER_TOTAL_POSTS$do_inc WHERE USER_ID=$usernum",$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";
    $userprofile = array("Anonymous","","","","","","","","","");

    if ($cuserid > 1)
    {
        $results = ppmysql_query("SELECT u.USER_DISPLAY_NAME,p.USER_HOMEPAGE,p.USER_TOTAL_POSTS,p.USER_TITLE,u.USER_REGISTERED_ON,p.USER_LOCATION,USER_AVATAR,USER_SIGNATURE,USER_AVATAR_WIDTH,USER_AVATAR_HEIGHT FROM {$Globals['dprefix']}USERS u
		    				      LEFT JOIN {$Globals['dprefix']}USER_PROFILE p ON p.USER_ID=u.USER_ID
								  WHERE u.USER_ID=$cuserid LIMIT 1", $db_link);

        list( $cuser, $chomepage, $cposts, $ctitle, $regdate, $uloc, $uavatar, $usig, $uavwidth, $uavheight ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>";

        $chomepage = str_replace("http://", "", $chomepage);
        if ($chomepage != "" ) {
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img src=\"{$Globals['idir']}/home.gif\" alt=\"{$Globals['pp_lang']['visithome']}\" border=\"0\" /></a>";
        }

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = $uloc;                    // Location
        $userprofile[6] = ( !empty($uavatar) && $uavatar != "http://" ? "<img src=\"$uavatar\" width=\"$uavwidth\" height=\"$uavheight\" />" : "" ); // Avatar
        $userprofile[7] = nl2br($usig); // Signature
    }

    $ugallery = "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $cuserid, 'username' => $cuser) ) . "\"><img alt=\"{$Globals['pp_lang']['visitgallery']}\" border=\"0\" src=\"{$Globals['idir']}/gallery.gif\" /></a>";
    $postline .= "$hpage<!--PhotoPost, copyright All, Enthusiast, Inc.-->$ugallery</td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link;

    setcookie( "{$Globals['cookieprefix']}ubbt_myid", "{$User['userid']}", time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );
    $db6password = md5("{$User['userid']}{$User['password']}");
    setcookie( "{$Globals['cookieprefix']}ubbt_key", $db6password, time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    srand((double)microtime()*1000000);
    $newsessionid = md5(rand(0,32767));
    $date = time()+($Globals['gmtoffset']*3600);
    setcookie("{$Globals['cookieprefix']}ubbt_mysess","$newsessionid","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    $result = ppmysql_query("UPDATE {$Globals['dprefix']}USERS SET USER_SESSION_ID='$newsessionid' WHERE USER_ID={$User['userid']}",$db_link);

    return;
}

function logout() {
    global $Globals;

    setcookie( "{$Globals['cookieprefix']}ubbt_myid", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}ubbt_mypass", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}ubbt_key", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}ubbt_mysess", "0", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    return;
}

function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/ubbthreads.php?ubb=newuser\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        $User['stylesheet'] = $Globals['threads'];
    }

    $links[0] = "{$Globals['vbulletin']}/ubbthreads.php?ubb=logout";
    $links[1] = "{$Globals['vbulletin']}/ubbthreads.php?ubb=newuser";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $postid, $phoedit, $gologin;
    global $up_k, $disk_k, $cedit, $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $cookuser = $Globals['cookieprefix']."ubbt_myid";
    $cookhash = $Globals['cookieprefix']."ubbt_mysess";
    $cookpass = $Globals['cookieprefix']."ubbt_key";

    $$cookuser = $_COOKIE["$cookuser"];
    $$cookhash = $_COOKIE["$cookhash"];
    $$cookpass = $_COOKIE["$cookpass"];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    // If we arent passing variables, set them to what was passed in the URL
    if ( $authuser == "" ) {
        // do this first, so we have a default
        //list( $userid, $username, $email, $dbpassword, $vbgroups, $sessionid, $loginname, $fstyle, $offset, $md5temppass) = get_userinfo( "", -1 );

        $ubbt_myid = $$cookuser;
        if ($ubbt_myid > 1) {
            list( $userid, $username, $email, $dbpassword, $vbgroups, $sessionid, $loginname, $fstyle, $offset, $md5temppass) = get_userinfo( "", $ubbt_myid );
        }
    }
    else {
        $cookuser = addslashes($authuser);
        $md5cookpass = md5($chkpassword);

        list( $userid, $username, $email, $dbpassword, $vbgroups, $sessionid, $loginname, $fstyle, $offset, $md5temppass) = get_userinfo( $cookuser );
    }

    // Check if session is valid
    if ( ($sessionid) && ($sessionid == $$cookhash) ) {
        $checkpass = 1;
    }

    if ($checkpass == 0 && $dbpassword) {
        if ($$cookpass) {
            $testpass = md5("{$userid}{$dbpassword}");
            if ( $testpass == $$cookpass ) $checkpass = 1;
        }
        else {
            if ( $md5cookpass == $dbpassword ) $checkpass = 1;
        }

        // just to be sure, lets see if they have a temp pass for verification and do the same checks
        if ( $md5temppass != "" && $checkpass != 1 ) {
            if ( $md5cookpass == $md5temppass ) $checkpass = 1;
        }
    }

    if ( $checkpass == 1 ) {
        $gologin=0; $User['nopost']=0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['login'] = $loginname;
        $User['email'] = $email;
        $User['offset'] = $offset;
        $User['password'] = $dbpassword;
        $User['stylesheet'] = $fstyle;

        $date = time()+($Globals['gmtoffset']*3600);

        $result = ppmysql_query("UPDATE {$Globals['dprefix']}USER_DATA SET user_last_visit_time=$date WHERE user_id={$User['userid']}", $db_link);
        ppmysql_free_result($result);
    }
    else {
        $vbgroups = array( 4 );
    }

    $CatPerms = array();
    set_user_perms( $vbgroups );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    $resultcur = ppmysql_query("SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups", $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $readug = ppmysql_query("SELECT GROUP_ID, GROUP_NAME FROM {$Globals['dprefix']}GROUPS", $db_link);
    $newGroups = array();

    while ( list($gid, $title) = mysql_fetch_row( $readug ) ) {
        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  ( $gid == 1 ? 1 : 0 );
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }

    }

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}usergroups", $link);

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign) VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$comments','$uplimit','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')", $link);
    }
}


function init_user_groups() {
    global $link, $pp_db_prefix;

    $setup = mysql_query("CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;", $link);
    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}

function get_forum_style()
{
    global $Globals, $User, $db_link;


    if ( $Globals['forumstyle'] == "yes" )
    {
	    if ( $User['stylesheet'] > 0 )
	    {
		    $queryv = ppmysql_query("SELECT STYLE_NAME,STYLE_EDITED_TIME FROM {$Globals['dprefix']}STYLES WHERE STYLE_ID={$User['stylesheet']}", $db_link);
		    list( $stylename, $styletime ) = mysql_fetch_row($queryv);
	    }
	    else
	    {
		    $queryv = ppmysql_query("SELECT STYLE_NAME,STYLE_EDITED_TIME FROM {$Globals['dprefix']}STYLES WHERE STYLE_NAME='{$Globals['threads']}'", $db_link);
		    list( $stylename, $styletime ) = mysql_fetch_row($queryv);
	    }

        return( "<link rel=\"stylesheet\" href=\"{$Globals['vbulletin']}/styles/{$stylename}_{$styletime}.css\" type=\"text/css\" />" );
    }

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "";
    $Style['tableborders'] = "t_inner";
    $Style['tablesurround'] = "t_outer";
    $Style['tddetails'] = "alt-1";
    $Style['tdbackground'] = "alt-2";
    $Style['tdnothumbs'] = "tdheader";
    $Style['menubar'] = "category";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "alt-2";
    $Style['photocol'] = "alt-1";
    $Style['commentscol'] = "alt-2";
    $Style['lastphocol'] = "alt-2";
    $Style['lastcommcol'] = "alt-1";
    $Style['small'] = "small";
    $Style['medium'] = "font-size: 10pt;";
    $Style['large'] = "font-size: 11pt;";
    $Style['welcome'] = "";
    $Style['lighttable'] = "alt-1";
    $Style['alternatetable'] = "alt-2";
    $Style['formboxes'] = "form-inline";
    $Style['blockquote'] = "ubbcode-body";
}

?>
