<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid, $fstyle ) = get_userinfo( $user, $userid );

if ( empty($Globals['dprefix']) ) $Globals['dprefix'] = "w3t_";

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}Users SET U_Groups='$usergroup' WHERE U_Number='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    if ( $userid != 0 ) $query = "SELECT U_Number,U_Username,U_Email,U_Password,U_Groups,U_TempPass,U_TimeOffset,U_SessionId, U_StyleSheet FROM {$Globals['dprefix']}Users WHERE U_Number=$userid";
    else {
        $tuser = addslashes( $authuser );
        $query = "SELECT U_Number,U_Username,U_Email,U_Password,U_Groups,U_TempPass,U_TimeOffset,U_SessionId, U_StyleSheet FROM {$Globals['dprefix']}Users WHERE U_UserName='$tuser'";
    }

    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_array($queryv);

    $username[0] = $results['U_Number'];       // userid
    $username[1] = $results['U_Username'];     // username
    $username[2] = $results['U_Email'];        // email
    $username[3] = $results['U_Password'];     // password
    $username[4] = $results['U_TempPass'];     // temppassword
    $username[5] = $results['U_Groups'];       // groups
    $username[6] = $results['U_TimeOffset'];   // timeoffset
    $username[7] = $results['U_SessionId'];    // session id
    $username[8] = $results['U_StyleSheet'];    // stylesheet

    ppmysql_free_result($queryv);

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    $queryv = ppmysql_query("SELECT C_Users FROM {$Globals['dprefix']}Cache", $db_link);
    list( $totalusers ) = mysql_fetch_row($queryv);

    return( $totalusers );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/showprofile.php?Cat=&amp;User=$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    $queryv = ppmysql_query("SELECT U_Number,U_Username FROM {$Globals['dprefix']}Users ORDER BY U_Username",$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) $do_inc = "+1";
    else $do_inc = "-1";

    $resulta = ppmysql_query("UPDATE {$Globals['dprefix']}Users SET U_Totalposts=U_Totalposts$do_inc WHERE U_Number=$usernum",$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";
    $userprofile = array("Anonymous","","","","","","","","","");

    if ($cuserid > 1) {
        $results = ppmysql_query("SELECT U_Username,U_Homepage,U_Totalposts,U_Title,U_Registered,U_Location,U_Picture,U_Signature,U_PicWidth,U_PicHeight FROM {$Globals['dprefix']}Users WHERE U_Number=$cuserid LIMIT 1",$db_link);
        list( $cuser, $chomepage, $cposts, $ctitle, $regdate, $uloc, $uavatar, $usig, $uavatarwid, $uavatarhei ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>";

        $chomepage = str_replace("http://", "", $chomepage);
        if ($chomepage != "" ) {
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img src=\"{$Globals['idir']}/home.gif\" alt=\"{$Globals['pp_lang']['visithome']}\" border=\"0\" /></a>";
        }

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = $uloc;                    // Location
        $userprofile[6] = ( !empty($uavatar) && $uavatar != "http://" ? "<img src=\"$uavatar\" height=\"$uavatarhei\" width=\"$uavatarwid\" />" : "" ); // Avatar
        $userprofile[7] = nl2br($usig); // Signature
    }

    $ugallery = "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $cuserid, 'username' => $cuser) ) . "\"><img alt=\"{$Globals['pp_lang']['visitgallery']}\" border=\"0\" src=\"{$Globals['idir']}/gallery.gif\" /></a>";
    $postline .= "$hpage<!--PhotoPost, copyright All, Enthusiast, Inc.-->$ugallery</td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link;

    setcookie( "{$Globals['cookieprefix']}w3t_myid", "{$User['userid']}", time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );
    $db6password = md5("{$User['userid']}{$User['password']}");
    setcookie( "{$Globals['cookieprefix']}w3t_key", $db6password, time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    srand((double)microtime()*1000000);
    $newsessionid = md5(rand(0,32767));
    $date = time()+($Globals['gmtoffset']*3600);
    setcookie("{$Globals['cookieprefix']}w3t_mysess","$newsessionid","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    $result = ppmysql_query("UPDATE {$Globals['dprefix']}Users SET U_SessionId='$newsessionid' WHERE U_Number={$User['userid']}",$db_link);

    return;
}

function logout() {
    global $Globals;

    setcookie( "{$Globals['cookieprefix']}w3t_myid", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}w3t_mypass", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}w3t_key", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}w3t_mysess", "0", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    return;
}

function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/newuser.php?Cat=\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        $User['stylesheet'] = $Globals['threads'];
    }

    $links[0] = "{$Globals['vbulletin']}/logout.php?Cat=";
    $links[1] = "{$Globals['vbulletin']}/newuser.php?Cat=";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $postid, $phoedit, $gologin;
    global $up_k, $disk_k, $cedit, $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $cookuser = $Globals['cookieprefix']."w3t_myid";
    $cookhash = $Globals['cookieprefix']."w3t_mysess";
    $cookpass = $Globals['cookieprefix']."w3t_key";

    $$cookuser = $_COOKIE["$cookuser"];
    $$cookhash = $_COOKIE["$cookhash"];
    $$cookpass = $_COOKIE["$cookpass"];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    // If we arent passing variables, set them to what was passed in the URL
    if ( $authuser == "" ) {
        // do this first, so we have a default
        //list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $offset, $sessionid ) = get_userinfo( "", -1 );

        $w3t_myid = $$cookuser;
        if ($w3t_myid > 1) {
            list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $offset, $sessionid, $fstyle ) = get_userinfo( "", $w3t_myid );
        }
    }
    else {
        $cookuser = addslashes($authuser);
        $md5cookpass = md5($chkpassword);

        list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroups, $offset, $sessionid, $fstyle ) = get_userinfo( $cookuser );
    }

    // Check if session is valid
    if ( ($sessionid) && ($sessionid == $$cookhash) ) {
        $checkpass = 1;
    }

    if ($checkpass == 0 && $dbpassword) {
        if ($$cookpass) {
            $testpass = md5("{$userid}{$dbpassword}");
            if ( $testpass == $$cookpass ) $checkpass = 1;
        }
        else {
            if ( $md5cookpass == $dbpassword ) $checkpass = 1;
        }

        // just to be sure, lets see if they have a temp pass for verification and do the same checks
        if ( $md5temppass != "" && $checkpass != 1 ) {
            if ( $md5cookpass == $md5temppass ) $checkpass = 1;
        }
    }

    if ( $checkpass == 1 ) {
        $ubbgroups = explode( "-", $usergroups);
        $gologin=0; $User['nopost']=0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['email'] = $email;
        $User['offset'] = $offset;
        $User['password'] = $dbpassword;
        $User['stylesheet'] = $fstyle;

        $date = time()+($Globals['gmtoffset']*3600);

        $result = ppmysql_query("UPDATE {$Globals['dprefix']}Users SET U_Laston=$date WHERE U_Number={$User['userid']}",$db_link);
        ppmysql_free_result($result);
    }
    else {
        // This assumes that G_Id for "Guests" is 4
        $ubbgroups = array( 4 );
    }

    $CatPerms = array();

    set_user_perms( $ubbgroups );

    // If they don't have a stylesheet pref we use the default
    if ( !$fstyle || $fstyle == "usedefault" || $User['userid'] == 0 ) {
        $User['stylesheet'] = $Globals['threads'];
    }

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    $resultcur = ppmysql_query("SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups", $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $readug = ppmysql_query("SELECT G_ID, G_Name FROM {$Globals['dprefix']}Groups", $db_link);
    $newGroups = array();

    while ( list($gid, $title) = mysql_fetch_row( $readug ) ) {
        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  ( $gid == 1 ? 1 : 0 );
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }

    }

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}usergroups", $link);

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign) VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$comments','$uplimit','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')", $link);
    }
}


function init_user_groups() {
    global $link, $pp_db_prefix;

    $setup = mysql_query("CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;", $link);
    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}

function get_forum_style()
{
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        return( "<link rel=\"stylesheet\" href=\"{$Globals['vbulletin']}/stylesheets/{$User['stylesheet']}.css\" type=\"text/css\" />" );
    }

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "tableborders";
    $Style['tablesurround'] = "tablesurround";
    $Style['tddetails'] = "lighttable";
    $Style['tdbackground'] = "darktable";
    $Style['tdnothumbs'] = "tdheader";
    $Style['menubar'] = "menubar";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "darktable";
    $Style['photocol'] = "lighttable";
    $Style['commentscol'] = "darktable";
    $Style['lastphocol'] = "darktable";
    $Style['lastcommcol'] = "lighttable";
    $Style['small'] = "small";
    $Style['medium'] = "font-size: 10pt;";
    $Style['large'] = "font-size: 11pt;";
    $Style['welcome'] = "welcome";
    $Style['lighttable'] = "lighttable";
    $Style['alternatetable'] = "darktable";
    $Style['formboxes'] = "formboxes";
    $Style['blockquote'] = "blockquote";
}

?>
