<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Chuck Scannell (http://www.omegatron.net)                      //
//                         Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( $user, $userid );

if (!function_exists('sha1'))
{
	function sha1($str)
	{
		// If we have mhash loaded in, use it instead!
		if (function_exists('mhash') && defined('MHASH_SHA1'))
			return bin2hex(mhash(MHASH_SHA1, $str));

		$nblk = (strlen($str) + 8 >> 6) + 1;
		$blks = array_pad(array(), $nblk * 16, 0);

		for ($i = 0; $i < strlen($str); $i++)
			$blks[$i >> 2] |= ord($str{$i}) << (24 - ($i % 4) * 8);

		$blks[$i >> 2] |= 0x80 << (24 - ($i % 4) * 8);

		return sha1_core($blks, strlen($str) * 8);
	}

	// This is the core SHA-1 calculation routine, used by sha1().
	function sha1_core($x, $len)
	{
		@$x[$len >> 5] |= 0x80 << (24 - $len % 32);
		$x[(($len + 64 >> 9) << 4) + 15] = $len;

		$w = array();
		$a = 1732584193;
		$b = -271733879;
		$c = -1732584194;
		$d = 271733878;
		$e = -1009589776;

		for ($i = 0, $n = count($x); $i < $n; $i += 16)
		{
			$olda = $a;
			$oldb = $b;
			$oldc = $c;
			$oldd = $d;
			$olde = $e;

			for ($j = 0; $j < 80; $j++)
			{
				if ($j < 16)
					$w[$j] = isset($x[$i + $j]) ? $x[$i + $j] : 0;
				else
					$w[$j] = sha1_rol($w[$j - 3] ^ $w[$j - 8] ^ $w[$j - 14] ^ $w[$j - 16], 1);

				$t = sha1_rol($a, 5) + sha1_ft($j, $b, $c, $d) + $e + $w[$j] + sha1_kt($j);
				$e = $d;
				$d = $c;
				$c = sha1_rol($b, 30);
				$b = $a;
				$a = $t;
			}

			$a += $olda;
			$b += $oldb;
			$c += $oldc;
			$d += $oldd;
			$e += $olde;
		}

		return sprintf('%08x%08x%08x%08x%08x', $a, $b, $c, $d, $e);
	}

	function sha1_ft($t, $b, $c, $d)
	{
		if ($t < 20)
			return ($b & $c) | ((~$b) & $d);
		if ($t < 40)
			return $b ^ $c ^ $d;
		if ($t < 60)
			return ($b & $c) | ($b & $d) | ($c & $d);

		return $b ^ $c ^ $d;
	}

	function sha1_kt($t)
	{
		return $t < 20 ? 1518500249 : ($t < 40 ? 1859775393 : ($t < 60 ? -1894007588 : -899497514));
	}

	function sha1_rol($num, $cnt)
	{
		// Unfortunately, PHP uses unsigned 32-bit longs only.  So we have to kludge it a bit.
		if ($num & 0x80000000)
			$a = ($num >> 1 & 0x7fffffff) >> (31 - $cnt);
		else
			$a = $num >> (32 - $cnt);

		return ($num << $cnt) | $a;
	}
}


function upgradesubscriber( $usergroup, $userid = 0 ) 
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}members SET ID_GROUP='$usergroup' WHERE ID_MEMBER='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}members";
        $stable = "{$Globals['dprefix']}log_online";
    }
    else {
        $utable = "smf_members";
        $stable = "smf_log_online";
    }


    if ( $userid != 0 ) {
        $query = "SELECT $utable.id_member,$utable.member_name,$utable.email_address,$utable.passwd,$utable.id_group,$utable.time_offset,$utable.id_theme,$utable.additional_groups,$utable.id_post_group,$stable.session,$utable.password_salt,$utable.real_name
            FROM $utable
            LEFT JOIN $stable ON $stable.ID_MEMBER='$userid'
            WHERE $utable.id_member='$userid'";
    }
    else {
        $query = "SELECT $utable.id_member,$utable.member_name,$utable.email_address,$utable.passwd,$utable.id_group,$utable.time_offset,$utable.id_theme,$utable.additional_groups,$utable.id_post_group,$utable.password_salt
            FROM $utable
            WHERE member_name='$authuser' OR real_name='$authuser'";
    }

    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_row($queryv);

    $username[0] = $results[0];     // userid
    $username[1] = $results[1];     // username
    $username[2] = $results[2];     // email
    $username[3] = $results[3];     // password
    $username[4] = "";              // temppassword
    $username[5] = $results[4];     // groups
    $username[6] = $results[5];     // timeoffset
    $username[7] = $results[6];     // stylesheet
    $username[8] = $results[7];     // additional groups
    $username[9] = $results[8];     // Post Groups
    $username[10] = $results[9];     // session
    $username[11] = $results[10];     // Password Salt
    $username[12] = $results[11];     // Real Name
    ppmysql_free_result($queryv);

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}members";
    }
    else {
        $utable = "smf_members";
    }

    $query = "SELECT * FROM $utable";

    $queryv = ppmysql_query($query, $db_link);
    $totalusers = mysql_num_rows($queryv);

    return( $totalusers );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/index.php?action=profile;u=$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}members";
    }
    else {
        $utable = "smf_members";
    }

    $query = "SELECT id,name FROM $utable ORDER BY member_name";

    $queryv = ppmysql_query($query,$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }
    ppmysql_free_result($rows);

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) {
        $do_inc = "+1";
    }
    else {
        $do_inc = "-1";
    }

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}members";
    }
    else {
        $utable = "smf_members";
    }

    $query = "UPDATE $utable SET posts=posts$do_inc WHERE id_member=$usernum";
    $resulta = ppmysql_query($query,$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = "";

    if ($cuserid != 0) {
        if ( !empty( $Globals['dprefix'] ) ) {
            $utable = "{$Globals['dprefix']}members";
        }
        else {
            $utable = "smf_members";
        }

        $query = "SELECT a.member_name,a.website_url,a.posts,a.usertitle,a.date_registered,a.location,a.avatar,a.signature,p.id_attach,p.filename,p.file_hash FROM $utable a
		  LEFT JOIN {$Globals['dprefix']}attachments p ON p.id_member=a.id_member
                  WHERE a.id_member=$cuserid LIMIT 1";
        $results = ppmysql_query($query,$db_link);
        list( $cuser, $chomepage, $cposts, $ctitle, $regdate, $clocation, $uavatar, $csig, $attachid, $file, $attachment ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>";

        $chomepage = str_replace("http://", "", $chomepage);
        if ($chomepage != "" ) {
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img src=\"{$Globals['idir']}/home.gif\" alt=\"{$Globals['pp_lang']['visithome']}\" border=\"0\" /></a>";
        }

        $result2 = ppmysql_query("SELECT value FROM {$Globals['dprefix']}settings WHERE variable='custom_avatar_url'",$db_link);
        list( $avatarurl ) = mysql_fetch_row($result2);
        $avcheck = substr($uavatar, 0, 4);

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = "$clocation";                  // Location

        if ($avcheck != "http" && $uavatar != "" ) {
            $userprofile[6] = "<img src=\"{$Globals['vbulletin']}/avatars/$uavatar\" />";  // Avatar
        }
        elseif ($avcheck == "http" && $uavatar != "" ) {
            $userprofile[6] = "<img src=\"$uavatar\" />";  // Avatar
        }
        elseif ($attachment != "" ) {
            $userprofile[6] = "<img src=\"{$Globals['vbulletin']}/index.php?action=dlattach;attach=$attachid;type=avatar\" />";  // Avatar
        }
        elseif ( $file != "" && $attachment == "" ) {
            $userprofile[6] = "<img src=\"$avatarurl/$file\" />";  // Avatar
        }
        else {
            $userprofile[6] = "";  // Avatar
        }

        $userprofile[7] = nl2br($csig); // Signature
    }

    $ugallery = "<a href=\"" . construct_newppurl( "showgallery.php", array('ppuser' => $cuserid, 'username' => $cuser) ) . "\"><img alt=\"{$Globals['pp_lang']['visitgallery']}\" border=\"0\" src=\"{$Globals['idir']}/gallery.gif\" /></a>";
    $postline .= "$hpage<!--PhotoPost, copyright All, Enthusiast, Inc.--></td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link, $_SERVER;

    $cookpass = sha1($User['password'] . $User['salt']);
    $data = serialize(empty($User['userid']) ? array(0, '', 0) : array($User['userid'], $cookpass, time() + $cookie_length, 2));
    setcookie( "{$Globals['smfcookie']}", $data, time()+31536000,"{$Globals['cookie_path']}", $Globals['domain_path'],0 );

$session_id = md5( uniqid(microtime()) );
setcookie("PHPSESSID","$session_id","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    $ipaddr = findenv("REMOTE_ADDR");
    $agent = findenv("HTTP_USER_AGENT");
    $browser = addslashes( substr($agent, 0, 50) ) ;
    $sesstime = time();

    if ( !empty( $Globals['dprefix'] ) ) {
        $stable = "{$Globals['dprefix']}log_online";
    }
    else {
        $stable = "smf_log_online";
    }

    $query = "DELETE FROM $stable WHERE id_member='{$User['userid']}'";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

	$query = "INSERT INTO $stable (session, logtime, id_member, ip, url)
	    VALUES ('$session_id',$sesstime,{$User['userid']},'$ipaddr','$browser')";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);
    return;
}

function logout() {
    global $Globals;

 setcookie( "{$Globals['smfcookie']}", "", time()+31536000,"{$Globals['cookie_path']}", $Globals['domain_path'],0 );
setcookie("PHPSESSID","","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    return;
}


function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/index.php?action=register\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals, $User, $db_link;

    if ( $Globals['forumstyle'] == "yes" )
    {
        $stylec = ppmysql_query("SELECT value FROM {$Globals['dprefix']}settings WHERE variable ='theme_default'",$db_link);
        list( $defaultstyle ) = mysql_fetch_row($stylec);

        $styled = ppmysql_query("SELECT value FROM {$Globals['dprefix']}themes WHERE variable ='theme_url' AND ID_THEME = '$defaultstyle'",$db_link);
        list( $finalstyle ) = mysql_fetch_row($styled);

        $User['stylesheet'] = $finalstyle;
    }

    $links[0] = "{$Globals['vbulletin']}/index.php?action=login";
    $links[1] = "{$Globals['vbulletin']}/index.php?action=logout";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $phoedit, $gologin, $bbuserid, $bbpassword;
    global $up_k, $disk_k, $cedit, $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;
    global $PHPSESSID, $cookiename;
    $PHPSESSID = $_COOKIE["PHPSESSID"];


    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    // This assumes that Id for "Guests" is 100
    $usergroup = 100;

    // If we arent passing variables, set them to what was passed in the URL
    if ( $authuser == "" ) {
        if ($_COOKIE[$Globals['smfcookie']]) {
            list ($ID_MEMBER, $ID_PASSWORD) = @unserialize(stripslashes($_COOKIE[$Globals['smfcookie']]));
            list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroup, $offset, $numstyle, $secondarygroups, $postgroups, $sessionid, $salt, $realname ) = get_userinfo( "", $ID_MEMBER );
        }
    }
    else {
        $finalpass = sha1(strtolower($authuser) . $chkpassword);
        $cookuser = addslashes($authuser);

        list( $userid, $username, $email, $dbpassword, $md5temppass, $usergroup, $offset, $numstyle, $secondarygroups, $postgroups, $salt, $realname ) = get_userinfo( $cookuser );
    }

    $lastpass = sha1($dbpassword . $salt);

    if ( ($PHPSESSID) && ($PHPSESSID == $sessionid) ) {
        $checkpass = 1;
    }
    elseif ($ID_PASSWORD) {
        if ($lastpass == $ID_PASSWORD) {
            $checkpass = 1;
        }
    }
    elseif ($dbpassword) {
        if ($dbpassword == $finalpass) {
            $checkpass = 1;
        }

        // just to be sure, lets see if they have a temp pass for verification and do the same checks
        if ( $md5temppass != "" && $checkpass != 1 ) {
            if ( $md5cookpass == $md5temppass ) $checkpass = 1;
        }
    }

    if ( !empty($Globals['dprefix']) ) {
        $ctable = "{$Globals['dprefix']}settings";
        $extable = "{$Globals['dprefix']}themes";
    }
    else {
        $ctable = "smf_settings";
        $extable = "smf_themes";
    }

    if ( $authuser == "" ) {

           $query = "SELECT value FROM $ctable
            WHERE variable ='theme_guests'";
            $stylec = ppmysql_query($query,$db_link);
            list( $gueststyle ) = mysql_fetch_row($stylec);
            ppmysql_free_result( $stylec );
    }

        // If they don't have a stylesheet pref we use the default
        if ( $User['userid'] != 0 ) {
           $query = "SELECT value FROM $ctable
            WHERE variable ='theme_default'";
            $stylec = ppmysql_query($query,$db_link);
            list( $userstyle ) = mysql_fetch_row($stylec);

            if ( $numstyle == "" || $numstyle == 0 ) {
                $numstyle = $userstyle;
            }
        }
        else {
            $numstyle = $gueststyle;
        }


           $query = "SELECT value FROM $extable
            WHERE variable ='theme_url' AND ID_THEME = '$numstyle'";
            $styled = ppmysql_query($query,$db_link);
            list( $finalstyle ) = mysql_fetch_row($styled);
            ppmysql_free_result( $styled );

		// If they don't have a stylesheet pref we use the default
		if ( $User['userid'] == 0 ) {
			$User['stylesheet'] = $finalstyle;
		}

    //print "($checkpass : $ID_MEMBER : $ID_PASSWORD : $lastpass : $finalpass ) $userid - $username - $email - $dbpassword - $md5temppass - ($usergroup) - $offset - $numstyle - $secondarygroups - $sessionid";
    //exit;

    if ( $checkpass == 1 ) {
        $gologin=0; $User['nopost']=0;
        $User['userid'] = $userid;

        if ( $realname != $username ) $User['username'] = $realname;
        else $User['username'] = $username;

        $User['email'] = $email;
        $User['offset'] = $offset;
        $User['password'] = $dbpassword;
        $User['salt'] = $salt;
        $User['stylesheet'] = $finalstyle;
    }

    if ($usergroup == 0) {
        $usergroup = 4;
    }
    elseif ( $usergroup == "" ) {
    // login for guests
         $usergroup = 100;
    }

    if ( !empty($secondarygroups)) {
        $usergroup = "$usergroup,$secondarygroups";
    }

    if ( !empty($postgroups)) {
        $usergroup = "$usergroup,$postgroups";
    }

    $vbgroups = explode( ",", $usergroup);

    $CatPerms = array();

    set_user_perms( $vbgroups );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    if ( !empty( $Globals['dprefix'] ) ) $gtable = "{$Globals['dprefix']}membergroups";
    else $gtable = "smf_membergroups";

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT id_group,group_name FROM $gtable";
    $readug = ppmysql_query($query,$db_link);
    $newGroups = array();

    while ( list($gid, $title ) = mysql_fetch_row( $readug ) ) {
        $newGroups[$gid] = $gid;
        if ( $gid == 1 ) {
        $cancontrol = 1;
       }
        else {
       $cancontrol = 0;
       }
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  $cancontrol;
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }
    }
    ppmysql_free_result( $readug );

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    $query = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
    $resulta = ppmysql_query($query, $link);


    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $query="INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign)
                VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
        $setug = ppmysql_query($query,$link);
    }

    $query="INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod) VALUES('100','Guests',0,0,0,0,0,0,0,0,0,0)";
    $setuk= ppmysql_query($query,$link);
}

function init_user_groups() {
    global $link, $pp_db_prefix;

    $query = "CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;";
    $setup = mysql_query($query,$link);

    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}


function get_forum_style()
{
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        return ( "<link rel=\"stylesheet\" href=\"{$User['stylesheet']}/css/index.css?\" type=\"text/css\" />" );
    }

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "tborder";
    $Style['tablesurround'] = "";
    $Style['tddetails'] = "windowbg";
    $Style['tdbackground'] = "windowbg2";
    $Style['tdnothumbs'] = "titlebg";
    $Style['menubar'] = "titlebg";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "windowbg2";
    $Style['photocol'] = "windowbg";
    $Style['commentscol'] = "windowbg";
    $Style['lastphocol'] = "windowbg";
    $Style['lastcommcol'] = "windowbg2";
    $Style['small'] = "smalltext";
    $Style['medium'] = "normaltext";
    $Style['large'] = "largetext";
    $Style['welcome'] = "normaltext";
    $Style['lighttable'] = "windowbg";
    $Style['alternatetable'] = "windowbg2";
    $Style['formboxes'] = "input";
    $Style['blockquote'] = "quote";
}

?>