<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid, $fstyle ) = get_userinfo( $user, $userid );

if ( $Globals['cookieprefix'] == "" ) $Globals['cookieprefix'] = "phpbb2mysql";

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}user_group SET group_id='$usergroup' WHERE user_id='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    if ( $userid != 0 ) $query = "SELECT {$Globals['dprefix']}users.user_id,{$Globals['dprefix']}users.username,{$Globals['dprefix']}users.user_email,{$Globals['dprefix']}users.user_password,{$Globals['dprefix']}users.user_level,{$Globals['dprefix']}users.user_timezone,{$Globals['dprefix']}themes.template_name FROM {$Globals['dprefix']}users
        LEFT JOIN {$Globals['dprefix']}themes ON {$Globals['dprefix']}users.user_style = {$Globals['dprefix']}themes.themes_id
        WHERE user_id='$userid'";
    else $query = "SELECT user_id,username,user_email,user_password,user_level,user_timezone FROM {$Globals['dprefix']}users WHERE username='$authuser'";

    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_array($queryv);

    $username[0] = $results['user_id'];           // userid
    $username[1] = $results['username'];          // username
    $username[2] = $results['user_email'];        // email
    $username[3] = $results['user_password'];     // password
    $username[4] = "";                            // temppassword
    $username[6] = $results['user_timezone'];     // timeoffset
    $username[7] = "";                            // session id
    $username[8] = $results['template_name'];     //stylesheet
    $username[9] = "";                            //session key
    ppmysql_free_result($queryv);

    if ( is_numeric($username[0]) ) $userid = $results['user_id'];
    else $userid = -1;

    $query = "SELECT {$Globals['dprefix']}user_group.group_id FROM {$Globals['dprefix']}user_group
        LEFT JOIN {$Globals['dprefix']}groups ON {$Globals['dprefix']}user_group.group_id = {$Globals['dprefix']}groups.group_id
        WHERE {$Globals['dprefix']}user_group.user_id=$userid
        AND {$Globals['dprefix']}user_group.user_pending=0
        AND {$Globals['dprefix']}groups.group_single_user=0";
    $result = ppmysql_query($query,$db_link);

    $ubbgroups = array();
    while ( $row = mysql_fetch_row($result) ) {
        array_push( $ubbgroups, $row[0] );
    }

    if ( $results['user_level'] == 1 ) {
        array_push( $ubbgroups, "2");
    }
    ppmysql_free_result($result);

    $username[5] = $ubbgroups;

    $query = "SELECT session_id FROM {$Globals['dprefix']}sessions WHERE session_user_id='$userid'";
    $result = ppmysql_query($query,$db_link);
    $results = mysql_fetch_array($result);
    $username[7] = $results[0];                   // session id
    ppmysql_free_result($result);

    $query = "SELECT key_id FROM {$Globals['dprefix']}sessions_keys WHERE user_id=$userid ORDER BY last_login DESC LIMIT 1";
    $result = ppmysql_query($query,$db_link);
    $results = mysql_fetch_array($result);
    $username[9] = $results[0];                   // session key
    ppmysql_free_result($result);

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    $query = "SELECT * FROM {$Globals['dprefix']}users";
    $queryv = ppmysql_query($query, $db_link);
    $totalusers = mysql_num_rows($queryv);

    return( $totalusers-1 );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/profile.php?mode=viewprofile&u=$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    $query = "SELECT user_id,username FROM {$Globals['dprefix']}users ORDER BY username";
    $queryv = ppmysql_query($query,$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }
    ppmysql_free_result($rows);

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) {
        $do_inc = "+1";
    }
    else {
        $do_inc = "-1";
    }

    $query = "UPDATE {$Globals['dprefix']}users SET user_posts=user_posts$do_inc WHERE user_id=$usernum";
    $resulta = ppmysql_query($query,$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";
        $userprofile = array("Anonymous","","","","","","","","","");


    if ($cuserid != 0) {
        if ( !empty( $Globals['dprefix'] ) ) {
            $utable = "{$Globals['dprefix']}users";
            $rtable = "{$Globals['dprefix']}ranks";
        }
        else {
            $utable = "users";
            $rtable = "ranks";
        }
        $query = "SELECT $utable.username,$utable.user_website,$utable.user_posts,$rtable.rank_title,$utable.user_regdate FROM ";
        $query .= "$utable LEFT JOIN $rtable ON $utable.user_rank = $rtable.rank_id WHERE $utable.user_id=$cuserid LIMIT 1";
        $results = ppmysql_query($query, $db_link);

        if ( $results ) {
            list( $cuser, $chomepage, $cposts, $ctitle, $regdate ) = mysql_fetch_row($results);
            ppmysql_free_result( $results );

            $userprofile[0] = $cuser;                   // Username
            $userprofile[1] = $chomepage;               // Homepage
            $userprofile[2] = $cposts;                  // Total Posts
            $userprofile[3] = $ctitle;                  // Title
            $userprofile[4] = $regdate;                 // Registered Date
            $userprofile[5] = "";                       // Location
            $userprofile[6] = "";                       // Avatar
            $userprofile[7] = "";                       // Signauture
        }

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img src=\"{$Globals['idir']}/profile.gif\"
            border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>
            $hpage<!--PhotoPost, copyright All, Enthusiast, Inc.-->
            $ugallery
            </td>";
    }

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link, $_SERVER;

    $dotquad_ip = findenv("REMOTE_ADDR");
    $ip_sep = explode('.', $dotquad_ip);
    $ipaddr = sprintf('%02x%02x%02x%02x', $ip_sep[0], $ip_sep[1], $ip_sep[2], $ip_sep[3]);


    $sesstime = time();
    $session_id = md5(uniqid($ipaddr));

    list($sec, $usec) = explode(' ', microtime());
    mt_srand(hexdec(substr($session_id, 0, 8)) + (float) $sec + ((float) $usec * 1000000));
    $auto_login_key = uniqid(mt_rand(), true);

    $sessiondata = array();
    $sessiondata['autologinid'] = $auto_login_key;
    $sessiondata['userid'] = $User['userid'];

    $query = "DELETE FROM {$Globals['dprefix']}sessions WHERE session_user_id={$User['userid']}";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    $query = "REPLACE INTO {$Globals['dprefix']}sessions (session_id,session_user_id,session_start,session_time,session_ip,session_page,session_logged_in)
        VALUES ('$session_id',{$User['userid']}, $sesstime, $sesstime, '$ipaddr', '0', '1')";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    $sql = "UPDATE {$Globals['dprefix']}users SET user_session_time = '$sesstime', user_session_page = '0', user_lastvisit = '$sesstime'
        WHERE user_id = {$User['userid']}";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    setcookie("{$Globals['cookieprefix']}_data", serialize($sessiondata), $sesstime + 31536000, "{$Globals['cookie_path']}", $Globals['domain_path'] );
    setcookie("{$Globals['cookieprefix']}_sid", $session_id, 0, "{$Globals['cookie_path']}", $Globals['domain_path'] );

    return;
}

function logout() {
    global $Globals, $User, $db_link;

    setcookie( "{$Globals['cookieprefix']}_data", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}_sid", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    $query = "DELETE FROM {$Globals['dprefix']}sessions WHERE session_user_id={$User['userid']}";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    return;
}


function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/profile.php?mode=register\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals, $User, $db_link;

    if ( $Globals['forumstyle'] == "yes" )
    {
        $styleb = ppmysql_query("SELECT config_value FROM {$Globals['dprefix']}config WHERE config_name='default_style'", $db_link);
        list( $styleid ) = mysql_fetch_row($styleb);

        $stylec = ppmysql_query("SELECT template_name FROM {$Globals['dprefix']}themes WHERE themes_id='$styleid'", $db_link);
        list( $defaultstyle ) = mysql_fetch_row($stylec);

        $User['stylesheet'] = $defaultstyle;
    }

    $links[0] = "{$Globals['vbulletin']}/profile.php?mode=sendpassword";
    $links[1] = "{$Globals['vbulletin']}/profile.php?mode=register";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $phoedit, $gologin, $bbuserid, $bbpassword;
    global $up_k, $disk_k, $cedit;
    global $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $cookuser = $Globals['cookieprefix']."_data";
    $cookhash = $Globals['cookieprefix']."_sid";

    $$cookuser = $_COOKIE["$cookuser"];
    $$cookhash = $_COOKIE["$cookhash"];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass=""; $ubbgroups = array();
    $sessionid = "";

    if ( !isset($$cookhash) ) $$cookhash = "0";

    if ( isset($$cookuser) ) {
        $cookie_data = unserialize(preg_replace("'\\\'", "", $$cookuser));
        $phpbb_userid = $cookie_data['userid'];
        $md5autologin = md5($cookie_data['autologinid']);
        if ( $phpbb_userid == "" ) $phpbb_userid = -1;
    }
    else {
        $phpbb_userid = -1;
    }

    if ( $authuser == "" ) {
        list( $userid, $username, $email, $dbpassword, $temppass, $ubbgroups, $offset, $sessionid, $fstyle, $session_key ) = get_userinfo( "", $phpbb_userid );
    }
    else {
        $phpbb_userid = addslashes($authuser);
        $md5cookpass = md5($chkpassword);
        list( $userid, $username, $email, $dbpassword, $temppass, $ubbgroups, $offset, $sessionid, $fstyle, $session_key ) = get_userinfo( $phpbb_userid );
    }

    if ( $authuser == "" ) {
            $query = "SELECT config_value FROM {$Globals['dprefix']}config WHERE config_name='default_style'";
            $styleb = ppmysql_query($query,$db_link);
            list( $styleid ) = mysql_fetch_row($styleb);
            ppmysql_free_result( $styleb );

            $query = "SELECT template_name FROM {$Globals['dprefix']}themes WHERE themes_id='$styleid'";
            $stylec = ppmysql_query($query,$db_link);
            list( $defaultstyle ) = mysql_fetch_row($stylec);
            ppmysql_free_result( $stylec );
    }

    // If they don't have a stylesheet pref we use the default
    if ( $User['userid'] == 0 ) {
        $User['stylesheet'] = $defaultstyle;
    }



    if ( $sessionid == $$cookhash ) $checkpass = 1;
    if ( ( $md5autologin == $session_key ) && ( $md5cookpass == $dbpassword ) ) $checkpass = 1;

    //print "($checkpass : $phpbb_userid : $md5autologin) $userid - $username - $email - $dbpassword - $temppass - $ubbgroups - $offset - $sessionid - $fstyle - $session_key";
    //exit;

    if ( ($checkpass == 1 || $dbpassword == $md5cookpass) && $userid != -1 ) {

        $gologin = 0;
        $User['nopost'] = 0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['email'] = $email;
        $User['offset'] = $offset;
        $User['stylesheet'] = $fstyle;

        if ($ubbgroups[0] == "") {
            $ubbgroups[0] = 3;
        }
    }
    else {
        // login for guests
        $ubbgroups = array( 1 );
    }

    $CatPerms = array();

    set_user_perms( $ubbgroups );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT group_id,group_name FROM {$Globals['dprefix']}groups WHERE group_type=2 OR group_single_user=0";
    $readug = ppmysql_query($query, $db_link);

    if ( !$readug ) {
        diewell("Error: Are you certain that your database prefix is set properly?<p>I cannot see your
            phpBB2 \"<b>{$Globals['dprefix']}groups</b>\" table.<p>The prefix setting adds characters to the front of phpBB2
            table names - please doublecheck this.");
    }

    $rcount = mysql_num_rows($readug);

    if ($rcount > 0) {
        while ( list( $gid, $title ) = mysql_fetch_row( $readug ) ) {
            $newGroups[$gid] = $gid;
            if ( !array_key_exists($gid,$currentGroups) ) {
                $currentGroups[$gid]['groupid'] = $gid;
                $currentGroups[$gid]['groupname'] = $title;
                $currentGroups[$gid]['cpaccess'] =  0;
                $currentGroups[$gid]['uploads'] =  0;
                $currentGroups[$gid]['comments'] = 0;
                $currentGroups[$gid]['diskspace'] =  0;
                $currentGroups[$gid]['uploadsize'] = 0;
                $currentGroups[$gid]['uplimit'] = 0;
                $currentGroups[$gid]['editpho'] =  0;
                $currentGroups[$gid]['editposts'] =  0;
                $currentGroups[$gid]['modaccess'] =  0;
                $currentGroups[$gid]['useralbums'] =  0;
                $currentGroups[$gid]['reqmod'] =  0;
                $currentGroups[$gid]['canassign'] =  0;
            }
        }

        foreach ($currentGroups as $currentGroup) {
            $gid = $currentGroup['groupid'];
            if ( !array_key_exists($gid, $newGroups)) {
                unset($currentGroups[$gid]);
            }
        }

        $deleteq = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
        $resultd = ppmysql_query($deleteq, $link);

        foreach ($currentGroups as $currentGroup) {
            $gid = $currentGroup['groupid'];
            $name = addslashes($currentGroup['groupname']);
            $cpaccess = $currentGroup['cpaccess'];
            $uploads = $currentGroup['uploads'];
            $comments = $currentGroup['comments'];
            $diskspace = $currentGroup['diskspace'];
            $uploadsize = $currentGroup['uploadsize'];
            $uploadlimit = $currentGroup['uplimit'];
            $editpho = $currentGroup['editpho'];
            $editposts = $currentGroup['editposts'];
            $modaccess = $currentGroup['modaccess'];
            $useralbums = $currentGroup['useralbums'];
            $reqmod = $currentGroup['reqmod'];
            $canassign = $currentGroup['canassign'];

            $query = "INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign)
                      VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
            $setug = ppmysql_query($query,$link);
        }
    }
    ppmysql_free_result( $readug );

	    $query = array();
		$query[] = "INSERT INTO {$Globals['pp_db_prefix']}usergroups VALUES ('1','Anonymous','','','','','',0,0,0,0,0,0,0)";
		$query[] = "INSERT INTO {$Globals['pp_db_prefix']}usergroups VALUES ('2','Admin',1,1,1,'','',1,1,1,1,0,0,0)";
		$query[] = "INSERT INTO {$Globals['pp_db_prefix']}usergroups VALUES ('3','Regular Users','',1,1,'','',1,1,0,1,0,0,0)";

	    for ( $x=0; $x < count($query); $x++) {
			$iquery = $query[$x];
			$setup = mysql_query($iquery, $link);
			if ( !$setup ) print "<b>Error: ".mysql_error()."</b><br />";
	    }
}

function init_user_groups() {
    global $Globals, $link;

    $query = array();
    $query[] = "CREATE TABLE {$Globals['pp_db_prefix']}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;";
    $query[] = "INSERT INTO {$Globals['pp_db_prefix']}usergroups VALUES ('1','Anonymous','','','','','','',0,0,0,0,0,0)";
    $query[] = "INSERT INTO {$Globals['pp_db_prefix']}usergroups VALUES ('2','Admin',1,1,1,'','','',1,1,1,1,0,1)";
    $query[] = "INSERT INTO {$Globals['pp_db_prefix']}usergroups VALUES ('3','Regular Users','',1,1,'','','',1,1,0,1,0,0)";

    for ( $x=0; $x < count($query); $x++) {
        $iquery = $query[$x];
        $setup = mysql_query($iquery, $link);
        if ( !$setup ) print "<b>Error: ".mysql_error()."</b><br />";
    }

}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}

function get_forum_style()
{
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        return( "<link rel=\"stylesheet\" href=\"{$Globals['vbulletin']}/templates/{$User['stylesheet']}/{$User['stylesheet']}.css\" type=\"text/css\" />" );
    }

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "mainmenu";
    $Style['tableborders'] = "forumline";
    $Style['tablesurround'] = "";
    $Style['tddetails'] = "row1";
    $Style['tdbackground'] = "row1";
    $Style['tdnothumbs'] = "catHead";
    $Style['menubar'] = "cat";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "row1";
    $Style['photocol'] = "row1";
    $Style['commentscol'] = "row1";
    $Style['lastphocol'] = "row1";
    $Style['lastcommcol'] = "row2";
    $Style['small'] = "gensmall";
    $Style['medium'] = "genmed";
    $Style['large'] = "gen";
    $Style['welcome'] = "cattitle";
    $Style['lighttable'] = "row1";
    $Style['alternatetable'] = "row2";
    $Style['formboxes'] = "textarea";
    $Style['blockquote'] = "quote";
}

?>
