<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( $user, $userid );

function mosGetParam( &$arr, $name, $def=null, $mask=0 ) {
    $return = null;
    if (isset( $arr[$name] )) {
        if (is_string( $arr[$name] )) {
            if (!($mask&_MOS_NOTRIM)) {
                $arr[$name] = trim( $arr[$name] );
            }
            if (!($mask&_MOS_ALLOWHTML)) {
                $arr[$name] = strip_tags( $arr[$name] );
            }
            if (!get_magic_quotes_gpc()) {
                $arr[$name] = addslashes( $arr[$name] );
            }
        }
        return $arr[$name];
    }
}

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
    	$resulta = ppmysql_query("UPDATE {$Globals['dprefix']}users SET gid='$usergroup' WHERE id='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}users";
        $stable = "{$Globals['dprefix']}session";
    }
    else {
        $utable = "mos_users";
        $stable = "mos_session";
    }

    if ( $userid != 0 ) {
        $query = "SELECT $utable.id,$utable.username,$utable.email,$utable.password,$utable.gid,$stable.session_id
            FROM $utable
            LEFT JOIN $stable ON $stable.userid=$userid
            WHERE $utable.id=$userid";
    }
    else {
        $query = "SELECT $utable.id,$utable.username,$utable.email,$utable.password,$utable.gid
            FROM $utable
            WHERE username='$authuser'";
    }
    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_row($queryv);

    $username[0] = $results[0];     // userid
    $username[1] = $results[1];     // username
    $username[2] = $results[2];     // email
    $username[3] = $results[3];     // password
    $username[4] = "";              // temppassword
    $username[5] = $results[4];     // groups
    $username[6] = $results[5];     // session id


    ppmysql_free_result($queryv);

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}users";
    }
    else {
        $utable = "mos_users";
    }

    $query = "SELECT COUNT(*) AS total FROM {$Globals['dprefix']}users";
    $queryv = ppmysql_query($query, $db_link);
    $results = mysql_fetch_array($queryv);

    return( intval($results['total']) );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['maindir']}/member.php?uid=$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}users";
    }
    else {
        $utable = "mos_users";
    }

    $query = "SELECT id,username FROM $utable ORDER BY username";

    $queryv = ppmysql_query($query,$db_link);
    while ( list( $userid, $username ) = mysql_fetch_row($queryv) ) {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }
    ppmysql_free_result($rows);

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ( $type == "plus" ) {
        $do_inc = "+1";
    }
    else {
        $do_inc = "-1";
    }


    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";

    if ($cuserid != 0) {
    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}users";
    }
    else {
        $utable = "mos_users";
    }


        $query = "SELECT $utable.username,$utable.usertype,$utable.registerDate FROM $utable WHERE $utable.id=$cuserid LIMIT 1";
        $results = ppmysql_query($query,$db_link);
        list( $cuser, $ctitle, $regdate ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img
            src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>";

       $regdate = strtotime($regdate);

        if ($chomepage != "" ) {
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img
                src=\"{$Globals['idir']}/www.gif\" alt=\"{$Globals['pp_lang']['visithome']}\" border=\"0\" /></a>";
        }

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $ctitle;                  // Title
        $userprofile[2] = $regdate;                 // Registered Date
    }

    $postline .= "$hpage<!--PhotoPost, copyright All, Enthusiast, Inc.--></td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link, $_SERVER;

 setcookie( "usercookie[username]", "{$User['username']}", time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    $dbpassword = md5($password);
setcookie( "usercookie[password]", $dbpassword, time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

$randnum = md5( uniqid( microtime(), 1 ) );
$session_id = md5( $randnum . $_SERVER['REMOTE_ADDR'] );
setcookie("sessioncookie","$session_id","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    $sesstime = time();

    if ( !empty($Globals['dprefix']) ) {
        $stable = "{$Globals['dprefix']}session";
    }
    else {
        $stable = "mos_session";
    }

    $query = "DELETE FROM $stable WHERE userid={$User['userid']}";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    $query = "INSERT INTO $stable (username, time, session_id, userid, gid)
              VALUES ('{$User['username']}',$sesstime,'$session_id',{$User['userid']},{$User['usergroup']})";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    return;
}

function logout() {
    global $Globals;

    setcookie( "usercookie[username]", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "usercookie[password]", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "sessioncookie","", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    return;
}


function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/index.php?option=com_registration&task=register\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals;

    $links[0] = "{$Globals['vbulletin']}/index.php?option=com_login";
    $links[1] = "{$Globals['vbulletin']}/index.php?option=com_registration&task=lostPassword";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $phoedit, $gologin;
    global $up_k, $usercomment, $useruploads, $disk_k, $cedit;
    global $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $usercookie = $_COOKIE["usercookie"];
    $sessioncookie = $_COOKIE["sessioncookie"];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0; $useruploads = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    // This assumes that Id for "Guests" is 28
    $usergroup = 28;

    // If we arent passing variables, set them to what was passed in the URL
    if ( $authuser == "" ) {

        $sessioncookie = mosGetParam( $_COOKIE, 'sessioncookie', null );
        $usercookie = mosGetParam( $_COOKIE, 'usercookie', null );
        $md5cookpass = $usercookie[password];

         if ($usercookie) {

    if ( !empty( $Globals['dprefix'] ) ) {
        $utable = "{$Globals['dprefix']}users";
    }
    else {
        $utable = "mos_users";
    }

        $query = "SELECT $utable.id FROM $utable
                  WHERE $utable.username='$usercookie[username]' LIMIT 1";
        $results = ppmysql_query($query,$db_link);
        list( $cookuser ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

            list( $userid, $username, $email, $md5dbpass, $md5temppass, $usergroup, $sessionid ) = get_userinfo( "" , $cookuser );
         }
    }
    else {
        $cookuser = addslashes($authuser);
        $md5cookpass = md5($chkpassword);

        list( $userid, $username, $email, $md5dbpass, $md5temppass, $usergroup) = get_userinfo( $cookuser );
    }


    // Check if session is valid
    if ( ($sessioncookie) && ($sessioncookie == $session_id) ) {
        $checkpass = 1;
    }
    elseif ($md5dbpass) {
        if ($md5dbpass == $md5cookpass) {
            $checkpass = 1;
        }

        if ( $usercookie[username]) {
            if ($md5dbpass == $md5cookpass) {
                $checkpass = 1;
            }
        }

        // just to be sure, lets see if they have a temp pass for verification and do the same checks
        if ( $md5temppass != "" && $checkpass != 1 ) {
            if ( $md5cookpass == $md5temppass ) $checkpass = 1;
        }
    }

    if ( !empty($Globals['dprefix']) ) {
        $ctable = "{$Globals['dprefix']}templates_menu";
    }
    else {
        $ctable = "mos_templates_menu";
    }

           $query = "SELECT template FROM $ctable
            WHERE menuid='0' AND client_id='0'";
            $stylec = ppmysql_query($query,$db_link);
            list( $defaultstyle ) = mysql_fetch_row($stylec);
            ppmysql_free_result( $stylec );

            $fstyle = $defaultstyle;

        // If they don't have a stylesheet pref we use the default
        if ( $User['userid'] == 0 ) {
            $User['stylesheet'] = $defaultstyle;
        }


    //print "($checkpass : $_COOKIE[usercookie[username]] : $_COOKIE[usercookie[password]] : $md5cookpass) $userid - $username - $email - $password - $md5temppass - ($usergroup) - $sessionid";
    //exit;

    if ( $checkpass == 1 ) {
        $gologin=0; $User['nopost']=0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['email'] = $email;
        $User['stylesheet'] = $fstyle;
        $User['password'] = $md5dbpass;
        $User['usergroup'] = $usergroup;
    }

    if( $usergroup == "" ) { $usergroup = "28"; }

    $vbgroups = explode( ",", $usergroup);
    $CatPerms = array();

    set_user_perms( $vbgroups );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    if ( !empty( $Globals['dprefix'] ) ) $gtable = "{$Globals['dprefix']}core_acl_aro_groups";
    else $gtable = "mos_core_acl_aro_groups";

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT group_id,name FROM $gtable WHERE name != 'ROOT'";
    $readug = ppmysql_query($query,$db_link);
    $newGroups = array();

    while ( list($gid, $title) = mysql_fetch_row( $readug ) ) {

        if ($gid == 25 || $gid == 24) $cancontrol=1;
        else $cancontrol=0;

        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  $cancontrol;
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }
    }
    ppmysql_free_result( $readug );

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    $query = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
    $resulta = ppmysql_query($query, $link);

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $query="INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign) VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
        $setug = ppmysql_query($query,$link);
    }
}

function init_user_groups() {
    global $link, $Globals;

    $query = "CREATE TABLE {$Globals['pp_db_prefix']}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;";
    $setup = mysql_query($query,$link);

    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}

function get_forum_style()
{
    global $Globals;

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "tableborders";
    $Style['tablesurround'] = "";
    $Style['tddetails'] = "tddetails";
    $Style['tdbackground'] = "tdbackground";
    $Style['tdnothumbs'] = "tdnothumbs";
    $Style['menubar'] = "menubar";
    $Style['menubarnb'] = "menubarnb";
    $Style['catcolumn'] = "catcolumn";
    $Style['photocol'] = "photocol";
    $Style['commentscol'] = "commentscol";
    $Style['lastphocol'] = "lastphocol";
    $Style['lastcommcol'] = "lastcommcol";
    $Style['small'] = "small";
    $Style['medium'] = "medium";
    $Style['large'] = "large";
    $Style['welcome'] = "welcome";
    $Style['lighttable'] = "lighttable";
    $Style['alternatetable'] = "alternatetable";
    $Style['formboxes'] = "formboxes";
    $Style['blockquote'] = "blockquote";
}

?>
