<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( $user, $userid );
function clean_value($val) {

    if ($val == "")
    {
        return "";
    }
    $val = str_replace( "&#032;"       , " "             , $val );
    $val = str_replace( "&"            , "&amp;"         , $val );
    $val = str_replace( "<!--"         , "&#60;&#33;--"  , $val );
    $val = str_replace( "-->"          , "--&#62;"       , $val );
    $val = preg_replace( "/<script/i"  , "&#60;script"   , $val );
    $val = str_replace( ">"            , "&gt;"          , $val );
    $val = str_replace( "<"            , "&lt;"          , $val );
    $val = str_replace( "\""           , "&quot;"        , $val );
    $val = preg_replace( "/\|/"        , "&#124;"        , $val );
    $val = preg_replace( "/\n/"        , "<br>"          , $val ); // Convert literal newlines
    $val = preg_replace( "/\\\$/"      , "&#036;"        , $val );
    $val = preg_replace( "/\r/"        , ""              , $val ); // Remove literal carriage returns
    $val = str_replace( "!"            , "&#33;"         , $val );
    $val = str_replace( "'"            , "&#39;"         , $val ); // IMPORTANT: It helps to increase sql query safety.
    $val = stripslashes($val);                                     // Swop PHP added backslashes
    $val = preg_replace( "/\\\/"       , "&#092;"        , $val ); // Swop user inputted backslashes
    return $val;
}

function upgradesubscriber( $usergroup, $userid = 0 )
{
    global $Globals, $db_link;

    if ( !empty($usergroup) && !empty($userid) )
    {
	    $resulta = ppmysql_query("UPDATE {$Globals['dprefix']}members SET mgroup='$usergroup' WHERE id='$userid'",$db_link);
    }

    return;
}

function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    $utable = "{$Globals['dprefix']}members";
    $stable = "{$Globals['dprefix']}sessions";

    if ( $userid != 0 ) {
        $query = "SELECT $utable.id,$utable.name,$utable.email,$utable.password,$utable.mgroup,$utable.time_offset,$stable.id
            FROM $utable
            LEFT JOIN $stable ON $stable.member_id=$userid
            WHERE $utable.id=$userid";
    }
    else {
        $tuser = clean_value($authuser);
        $query = "SELECT id,name,email,password,mgroup,time_offset,skin FROM $utable WHERE name='$tuser'";
    }

    $queryv = ppmysql_query($query,$db_link);
    $results = mysql_fetch_row($queryv);

    $username[0] = $results[0];     // userid
    $username[1] = $results[1];     // username
    $username[2] = $results[2];     // email
    $username[3] = $results[3];     // password
    $username[4] = "";              // temppassword
    $username[5] = $results[4];     // groups
    $username[6] = $results[5];     // timeoffset
    $username[7] = $results[6];     // session id
    $username[8] = $results[7];     // stylesheet

    ppmysql_free_result($queryv);

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    $query = "SELECT * FROM {$Globals['dprefix']}members";
    $queryv = ppmysql_query($query, $db_link);
    $totalusers = mysql_num_rows($queryv);

    return( $totalusers );
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = "{$Globals['vbulletin']}/index.php?act=Profile&MID=$tuserid";
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = null;

    $query = "SELECT id,name FROM {$Globals['dprefix']}members ORDER BY name";
    $queryv = ppmysql_query($query,$db_link);

    while ( list( $userid, $username ) = mysql_fetch_row($queryv) )
    {
        $useropts .= "<option value=\"$userid\">$username</option>";
    }
    ppmysql_free_result($rows);

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = (int)$userid;

    if ( $type == "plus" ) {
        $do_inc = "+1";
    }
    else {
        $do_inc = "-1";
    }

    $query = "UPDATE {$Globals['dprefix']}members SET posts=posts$do_inc WHERE id=$usernum";
    $resulta = ppmysql_query($query,$db_link);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";

    if ($cuserid != 0) {
        $query = "SELECT name,website,posts,title,joined FROM {$Globals['dprefix']}members WHERE id=$cuserid LIMIT 1";
        $results = ppmysql_query($query,$db_link);
        list( $cuser, $chomepage, $cposts, $ctitle, $tdate ) = mysql_fetch_row($results);
        ppmysql_free_result( $results );

        $postline = "<a href=\"$profilelink\" target=\"_blank\"><img
            src=\"{$Globals['idir']}/profile.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\" /></a>";

        $chomepage = str_replace("http://", "", $chomepage);

        if ($chomepage != "" ) {
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img
                src=\"{$Globals['idir']}/home.gif\" alt=\"{$Globals['pp_lang']['visithome']}\" border=\"0\" /></a>";
        }

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = "";                       // Location
        $userprofile[6] = "";                       // Avatar
        $userprofile[7] = "";                       // Signature
    }

    $postline .= "$hpage<!--PhotoPost, copyright All, Enthusiast, Inc.--></td>";

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User, $db_link, $_SERVER;

    setcookie( "{$Globals['cookieprefix']}member_id", "{$User['userid']}", time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );
    $dbpassword = md5($password);
    setcookie( "{$Globals['cookieprefix']}pass_hash", $dbpassword, time()+2592000,"{$Globals['cookie_path']}", $Globals['domain_path'] );

    $session_id = md5( uniqid(microtime()) );
    setcookie("{$Globals['cookieprefix']}session_id","$session_id","0","{$Globals['cookie_path']}", $Globals['domain_path'] );

    $ipaddr = findenv("REMOTE_ADDR");
    $agent = findenv("HTTP_USER_AGENT");
    $browser = addslashes( substr($agent, 0, 50) ) ;
    $sesstime = time();

    $query = "DELETE FROM {$Globals['dprefix']}sessions WHERE member_id={$User['userid']}";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    $query = "INSERT INTO $stable (id, member_name, member_id, running_time, member_group, ip_address, browser, login_type)
        VALUES ('$session_id','{$User['username']}',{$User['userid']},$sesstime,'{$User['usergroup']}','$ipaddr','$browser',0)";
    $result = ppmysql_query($query,$db_link);
    ppmysql_free_result($result);

    return;
}

function logout() {
    global $Globals;

    setcookie( "{$Globals['cookieprefix']}member_id", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}pass_hash", "", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );
    setcookie( "{$Globals['cookieprefix']}session_id","", time()-3600, $Globals['cookie_path'], $Globals['domain_path'] );

    return;
}


function get_regcode() {
    global $Globals;

    $regtext = " &middot; <a href=\"{$Globals['vbulletin']}/index.php?act=Reg&CODE=00\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals, $User, $db_link;

    if ( $Globals['forumstyle'] == "yes" )
    {
        $stylec = ppmysql_query("SELECT css_id FROM {$Globals['dprefix']}skins WHERE default_set='1'", $db_link);
        list( $defaultstyle ) = mysql_fetch_row($stylec);

        $User['stylesheet'] = $defaultstyle;
    }

    $links[0] = "{$Globals['vbulletin']}/index.php?s=$s&act=Login&CODE=03";
    $links[1] = "{$Globals['vbulletin']}/index.php?s=$s&act=Reg&CODE=00";

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $phoedit, $gologin, $bbuserid, $bbpassword;
    global $up_k, $disk_k, $cedit, $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    $session_id = $_COOKIE["session_id"];
    $pass_hash = $_COOKIE["pass_hash"];
    $member_id = $_COOKIE["member_id"];

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    // This assumes that Id for "Guests" is 2
    $usergroup = 2;

    // If we arent passing variables, set them to what was passed in the URL
    if ( $authuser == "" ) {
        $md5cookpass = $pass_hash;
        if (isset($member_id) && $member_id != 0) {
            list( $userid, $username, $email, $md5dbpass, $md5temppass, $usergroup, $offset, $sessionid,$fstyle ) = get_userinfo( "", $member_id );
        }
    }
    else {
        $cookuser = addslashes($authuser);
        $md5cookpass = md5(clean_value($chkpassword));

        list( $userid, $username, $email, $md5dbpass, $md5temppass, $usergroup, $offset, $sessionid, $fstyle) = get_userinfo( $cookuser );
    }

    // Check if session is valid
    if ( ($sessionid) && ($sessionid == $session_id) ) {
        $checkpass = 1;
    }
    elseif ($md5dbpass) {
        if ($md5dbpass == $md5cookpass) {
            $checkpass = 1;
        }

        // just to be sure, lets see if they have a temp pass for verification and do the same checks
        if ( $md5temppass != "" && $checkpass != 1 ) {
            if ( $md5cookpass == $md5temppass ) $checkpass = 1;
        }
    }

    if ( !empty($Globals['dprefix']) ) {
        $ctable = "{$Globals['dprefix']}skins";
    }
    else {
        $ctable = "ibf_skins";
    }
    if ( $authuser == "" ) {

           $query = "SELECT css_id FROM $ctable
            WHERE default_set='1'";
            $stylec = ppmysql_query($query,$db_link);
            list( $defaultstyle ) = mysql_fetch_row($stylec);
            ppmysql_free_result( $stylec );
    }

        // If they don't have a stylesheet pref we use the default
        if ( $fstyle == "" ) {
            $fstyle = $defaultstyle;
        }

        // If they don't have a stylesheet pref we use the default
        if ( $User['userid'] == 0 ) {
            $User['stylesheet'] = $defaultstyle;
        }

    //print "($checkpass : $member_id : $pass_hash : $md5cookpass) $userid - $username - $email - $md5dbpass - $md5temppass - ($usergroup) - $offset - $sessionid";
    //exit;

    if ( $checkpass == 1 ) {
        $gologin=0; $User['nopost']=0;
        $User['userid'] = $userid;
        $User['username'] = $username;
        $User['email'] = $email;
        $User['offset'] = $offset;
        $User['password'] = $md5dbpass;
        $User['stylesheet'] = $fstyle;
        $User['usergroup'] = $usergroup;
    }

    if( $usergroup == "" )
    {
        $usergroup = 2;
    }

    $CatPerms = array();

    set_user_perms( array($usergroup) );
    unset( $Globals['cats'] );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    if ( !empty( $Globals['dprefix'] ) ) $gtable = "{$Globals['dprefix']}groups";
    else $gtable = "ibf_groups";

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT g_id,g_title,g_access_cp FROM $gtable";
    $readug = ppmysql_query($query,$db_link);
    $newGroups = array();

    while ( list($gid, $title, $cancontrol) = mysql_fetch_row( $readug ) ) {
        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  $cancontrol;
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$groupid]['canassign'] =  0;
        }
    }
    ppmysql_free_result( $readug );

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    $query = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
    $resulta = ppmysql_query($query, $link);

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $query="INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign) VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
        $setug = ppmysql_query($query,$link);
    }
}

function init_user_groups() {
    global $link, $pp_db_prefix;

    $query = "CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;";
    $setup = mysql_query($query,$link);

    return($setup);
}



function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}


function get_forum_style()
{
    global $Globals, $User;

    if ( $Globals['forumstyle'] == "yes" )
    {
        return( "<link rel=\"stylesheet\" href=\"{$Globals['vbulletin']}/cache/css_{$User['stylesheet']}.css\" type=\"text/css\" />" );
    }

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "tableborder";
    $Style['tablesurround'] = "";
    $Style['tddetails'] = "row4";
    $Style['tdbackground'] = "darkrow3";
    $Style['tdnothumbs'] = "titlemedium";
    $Style['menubar'] = "maintitle";
    $Style['menubarnb'] = "";
    $Style['catcolumn'] = "row4";
    $Style['photocol'] = "row2";
    $Style['commentscol'] = "row2";
    $Style['lastphocol'] = "row2";
    $Style['lastcommcol'] = "row4";
    $Style['small'] = "desc";
    $Style['medium'] = "normalname";
    $Style['large'] = "font-size: 14pt;";
    $Style['welcome'] = "desc";
    $Style['lighttable'] = "row1";
    $Style['alternatetable'] = "row3";
    $Style['formboxes'] = "forminput";
    $Style['blockquote'] = "postcolor";
}

if ( empty($Globals['dprefix']) )
{
    $Globals['dprefix'] ="ibf_";
}

?>