<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

    // This is a library of glue routines to ease integration of third-party apps
    // with DCScript's DCForum+. Most of the code was taken directly from DCF+, and
    // as such is copyright (c) 1997-2002, DCScripts, a division of DC Business Solutions.
    // All Rights Reserved. Portions are copyright (c) 2002, Rick Buck (spyderbytes).
    //
    // Use of this code for any other purpose than to build integration between a fully
    // licensed copy of DCF+ and a fully licensed copy of a third-party application is
    // expressly forbidden and a violation of law.
    //
    // Modification history:
    // Library created - 11/13/2002 -rb
    // =====================================================================================

    // Set this constant to the full path to your dcsetup file -rb
    define("DCFP_AUTH_FULL_SETUP_PATH", "c:/Inetpub/wwwroot/dc/dcsetup.php");

    // Allow persistent db connections? Set this to false unless you know your server
    // is set up to benefit from persistent connections -rb
    // NOTE: DCF+ does NOT use persistent connections by default. As such, this is
    // hack behavior if set to true! -rb
    define("DCFP_AUTH_PERSISTENT_CONNECTIONS", false);

    // Set the two following constants to the empty string (that is, "") UNLESS you have a
    // hacked version of DCF+ that specifies a path and domain for cookies. Note that
    // DCF+ DOES NOT support these by default. Unless you've changed things in DCF+, don't
    // use these! -rb
    define("DCFP_AUTH_COOKIE_PATH", "/");
    define("DCFP_AUTH_COOKIE_DOMAIN", "192.168.1.100");

    // =====================================================================================
    // DO NOT EDIT BELOW HERE -rb
    // =====================================================================================
    require_once(DCFP_AUTH_FULL_SETUP_PATH);

    // Make sure we have a connection to the DCF+ db... -rb
    if(DCFP_AUTH_PERSISTENT_CONNECTIONS) {
        $dcfp_auth_dblink = mysql_pconnect(DB_HOST, DB_USERNAME, DB_PASSWORD)
            or die("Could not connect to the DCF+ database.");
    } else {
        $dcfp_auth_dblink = mysql_connect(DB_HOST, DB_USERNAME, DB_PASSWORD)
            or die("Could not connect to the DCF+ database.");
    }
    mysql_select_db(DB_NAME,$dcfp_auth_dblink);

    // we need this often enough to dereference -rb
    $dcfp_auth_cookie = $_COOKIE["dccookie"];

    function dcfp_auth_get_retrieve_password_url() {
        return ROOT_URL . "/dcboard.php?az=retrieve_password";
    }


    function dcfp_auth_get_register_url() {
        return ROOT_URL . "/dcboard.php?az=register";
    }


    function dcfp_auth_get_profile_url($userid) {
        return ROOT_URL . "/dcboard.php?az=user_profiles&u_id=$userid";
    }


    function dcfp_auth_get_edit_profile_url() {
        return ROOT_URL . "/dcboard.php?az=user&saz=change_profile";
    }


    function dcfp_auth_get_private_msg_url($userid) {
        return ROOT_URL . "/dcboard.php?az=send_mesg&u_id=$userid";
    }


    function dcfp_auth_get_add_buddy_url($userid) {
        return ROOT_URL . "/dcboard.php?az=add_buddy&u_id=$userid";
    }


    function dcfp_auth_get_email_url($userid) {
        return ROOT_URL . "/dcboard.php?az=send_email&u_id=$userid";
    }


    function dcfp_auth_increment_user_posts($userid) {
        $query = "UPDATE " . DB_USER . " SET num_posts=num_posts+1 WHERE id=$userid";
        dcfp_auth_query($query);
    }


    function dcfp_auth_decrement_user_posts($userid) {
        $query = "UPDATE " . DB_USER . " SET num_posts=num_posts-1 WHERE id=$userid";
        dcfp_auth_query($query);
    }


    function dcfp_auth_get_user_info($userid,$return_fields) {
        $field_str = implode(",", $return_fields);
        if ( is_numeric($userid) ) {
            $query = "SELECT $field_str FROM " . DB_USER . " WHERE id=$userid";
        }
        else {
            $tuserid = addslashes($userid);
            $query = "SELECT $field_str FROM " . DB_USER . " WHERE username='$tuserid'";
        }
        $result = dcfp_auth_query($query);
        $row = dcfp_auth_fetch_row($result);
        // build an associative array for caller's convenience -rb
        $return_array = array();
        for($i = 0; $i < sizeof($return_fields); $i++) {
            $return_array[$return_fields[$i]] = $row[$i];
        }
        return $return_array;
    }


    function dcfp_auth_get_db_link() {
        return $dcfp_auth_dblink;
    }


    function dcfp_auth_resolve_cookie($return_fields) {
        // if we have a cookie telling us who this is, resolve it and return the
        // requested fields from the DCF+ user table -rb
        global $dcfp_auth_cookie;

        if(isset($dcfp_auth_cookie)) {
            $cookie_str = base64_decode($dcfp_auth_cookie);
            $tmparr = explode('&',$cookie_str);
            while(list($key,$value) = each($tmparr)) {
                $kv_array = explode('=',$value);
                $cookie_array[$kv_array['0']] = $kv_array['1'];
            }

            // now check the DCF session table -rb
            // if there's a session corresponding to the cookie, user is
            // authentic; if not, we'll need a login before auth -rb
            $sid = $cookie_array[DC_SESSION_ID];
            $query = "SELECT u_id FROM " . DB_SESSION . " WHERE s_id = '$sid' LIMIT 1";
            $result = dcfp_auth_query($query);
            list($uid) = dcfp_auth_fetch_row($result);

            // if user is logged, should now have a user id for querying user table -rb
            if($uid) {    // session exists, user is authentic -rb
                $field_str = implode(",", $return_fields);
                $query = "SELECT $field_str FROM " . DB_USER . " WHERE id ='$uid' LIMIT 1";
                $result = dcfp_auth_query($query);
                $row = dcfp_auth_fetch_row($result);
                // build an associative array for caller's convenience -rb
                $return_array = array();
                for($i = 0; $i < sizeof($return_fields); $i++) {
                    $return_array[$return_fields[$i]] = $row[$i];
                }
                return $return_array;
            } else return false;
        } else return false;
    }


    function dcf_auth_user_by_uname($username,$password,$return_fields) {
        // Find the user with $username and authenticate $password, then return the
        // fields requested in $return_fields from the user table -rb

        // see if caller requested password and status fields; if not, temporarily
        // add them to $return_fields, since we need them -rb
        $added_fields = 0;
        if(! array_search("password", $return_fields)) {
            array_push($return_fields, "password");
            ++$added_fields;
        }
        if (! array_search("status", $return_fields)) {
            array_push($return_fields, "status");
            ++$added_fields;
        }

        // build query string from $return_fields array -rb
        $field_str = implode(",", $return_fields);

        $query = "SELECT $field_str FROM " . DB_USER . " WHERE username = '$username' LIMIT 1";
        $result = dcfp_auth_query($query);
        $row = dcfp_auth_fetch_row($result);

        $status_index = array_search("status", $return_fields);
        $pass_index = array_search("password", $return_fields);
        if($row[$status_index] == 'on') {
            $compare_pass = crypt($password,substr($row[$pass_index],0,2));
            if($row[$pass_index] == $compare_pass) {
                // build associative array and return it -rb
                $return_array = array();
                for($i = 0; $i < sizeof($return_fields) - $added_fields; $i++) {
                    $return_array[$return_fields[$i]] = $row[$i];
                }
                return $return_array;
            }    else return false;    // password wrong -rb
        } else return false;    // status is 'off' -rb

        // user not found -rb
        return false;
    }


    function dcfp_auth_do_logout() {
        // clean up the session table and remove the session cookie -rb
        global $dcfp_auth_cookie;
        global $dcfp_auth_dblink;

        // unzip the cookie -rb
        $cookie_array = array();
        $cookie_str = base64_decode($dcfp_auth_cookie);
        $temp_array = explode('&', $cookie_str);
        while(list($key,$value) = each($temp_array)) {
            $kv_array = explode('=', $value);
            $cookie_array[$kv_array['0']] = $kv_array['1'];
        }

        // clean up session table -rb
        $session_id = $cookie_array[DC_SESSION_ID];
        $session_key = $cookie_array[DC_SESSION_KEY];

        $query = "DELETE FROM " . DB_SESSION . " WHERE id = '$session_key' AND s_id = '$session_id'";
        dcfp_auth_query($query);

        // now just remove the cookie and exit -rb
        if (DCFP_AUTH_COOKIE_PATH != "" || DCFP_AUTH_COOKIE_DOMAIN != "") {
            setcookie(DC_COOKIE, "", time()-3600, DCFP_AUTH_COOKIE_PATH, DCFP_AUTH_COOKIE_DOMAIN);
        } else {
            setcookie(DC_COOKIE, "", time()-3600);
        }
    }


    function dcfp_auth_do_login($username) {
        // NOTE: This should ONLY be called AFTER the user has been authenticated
        // (e.g., with dcf_auth_user_by_uname()). This creates a session, stores
        // the necessary foo in the session table, then sets the session cookie
        // needed to represent an authentic user logged into DCF+. This login is
        // fully recoginized by DCF+ itself. -rb

        // first we have to create a session... -rb

        // we need the full row for this user for an upcoming add to the session table -rb
        // $username might still be raw form data from an authentication call; make
        // sure it doesn't have illegal characters -rb
        $username = dcfp_auth_escape_string($username);
        $query = "SELECT id,password,username,g_id,name,email,uh,uj,ut,uu,ue,ug,uv,status,
                last_date FROM " . DB_USER . " WHERE username = '$username' LIMIT 1";
        $result = dcfp_auth_query($query);
        list($uid,$pass,$user,$gid,$name,$email,$uh,$uj,$ut,$uu,$ue,$ug,$uv,$status, $last_date) = dcfp_auth_fetch_row($result);
        dcfp_auth_free_result($result);

        // if user has chosen manual timestamps in DCF+ -rb
        if ($uh == 'yes') {
               $query = "SELECT forum_id, UNIX_TIMESTAMP(date) AS date FROM " . DB_USER_TIME_MARK . " WHERE u_id = '$uid'";
               $result = dcfp_auth_query($query);
               // NOTE: changed David's algorithm here, since I was getting lost in it. ;)
               // Besides, if I'm not mistaken, this should be faster than iteravely building
               // then imploding a couple of arrays to get the final string -rb
               $time_mark = "";
               while(list($forum,$date) = dcfp_auth_fetch_row($result)) {
                  $time_mark .= $forum . '#' . $date . '^';
               }
               // strip the final (extraneous) carat -rb
               $time_mark = substr($time_mark,0,strlen($time_mark) - 1);
        }    // end time mark foo -rb

        // generate a random session id -rb
        // this is a direct copy of DC's method of doing it -rb
        $pid = getmypid();
        mt_srand(time());
        $rand = mt_rand(1,60000);
        $session = implode('', unpack("H*", pack("Nnn",time(),$pid,$rand)));

        $cookie_array = array();
        $cookie_array[DC_SESSION_ID] = $session;

        $query = "INSERT INTO " . DB_SESSION . " VALUES('', '$session', '$uid','$username',
                '$gid', '$name', '$email', '$ut', '$uu', '$uv', '$ue', '$ug', '$uh', '$uj', '',
                '$time_mark', NOW())";
        dcfp_auth_query($query);
        $session_key = mysql_insert_id();

        $cookie_array[DC_SESSION_KEY] = $session_key;

        $temp = array();
        $cookie_str = "";
        while(list($key,$value) = each($cookie_array)) {
            $cookie_str .= "$key=$value&";
        }
        $cookie_str = base64_encode(substr($cookie_str,0,strlen($cookie_str) - 1));

        // Set the cookie and go bye-bye -rb

        // If admin allows persistent cookies and user has elected to use the option -rb
        if($ue == 'yes' && dcfp_auth_get_setup_param(auth_allow_password_remembering) == 'yes') {
            $duration = 3600*24*COOKIE_DURATION;

            if (DCFP_AUTH_COOKIE_PATH != "" || DCFP_AUTH_COOKIE_DOMAIN != "") {
                setcookie(DC_COOKIE, $cookie_str, time()+$duration, DCFP_AUTH_COOKIE_PATH, DCFP_AUTH_COOKIE_DOMAIN);
            } else {
                setcookie(DC_COOKIE, $cookie_str, time()+$duration);
            }
        } else {    // cookie good for this session only -rb
            if (DCFP_AUTH_COOKIE_PATH != "" || DCFP_AUTH_COOKIE_DOMAIN != "") {
                setcookie(DC_COOKIE, $cookie_str, 0, DCFP_AUTH_COOKIE_PATH, DCFP_AUTH_COOKIE_DOMAIN);
            } else {
                setcookie(DC_COOKIE, $cookie_str);
            }
        }
    }


    function dcfp_auth_get_setup_param($param) {
        $query = "SELECT var_value FROM ". DB_SETUP . " WHERE var_key = '$param' LIMIT 1";
        $result = dcfp_auth_query($query);
        list($param_value) = dcfp_auth_fetch_row($result);
        return $param_value;
    }


    function dcfp_auth_count_users() {
        $query = "SELECT count(id) as users FROM " . DB_USER;
        $result = dcfp_auth_query($query);
        list($users) = mysql_fetch_row($result);
        return $users;
    }


    // mysql wrappers -rb
    function dcfp_auth_query($query) {
        global $dcfp_auth_dblink;

        $result = mysql_query($query, $dcfp_auth_dblink)
            or die("Error! The following SQL query failed: $query<br>");
        return $result;
    }

    function dcfp_auth_fetch_row($result) {
        return mysql_fetch_row($result);
    }

    function dcfp_auth_free_result($result) {
        mysql_free_result($result);
    }

    function dcfp_auth_escape_string($string) {
        return mysql_escape_string($string);
    }

//
// PhotoPost functions
//

// this will return an array like:
// list( $userid, $username, $email, $password, $temppass, $groups, $offset, $sessionid ) = get_userinfo( $user, $userid );

function upgradesubscriber( $usergroup, $userid = 0 )
{
    // Not supported
}


function get_userinfo( $authuser, $userid=0 ) {
    global $Globals, $db_link;

    $return_fields = array("id","username","email");
    if ( $userid != 0 ) {
        $user_info = dcfp_auth_get_user_info($userid,$return_fields);
    }
    else {
        $user_info = dcfp_auth_get_user_info($authuser,$return_fields);
    }
    $username[0] = $user_info['id'];
    $username[1] = $user_info['username'];
    $username[2] = $user_info['email'];

    return $username;
}

//
// For each BB, get the total number of users
//

function get_totalusers() {
    global $Globals, $db_link;

    return dcfp_auth_count_users();
}

//
// For each BB, get the link to the profile page for that user
//

function get_profilelink( $tuserid, $tusername="" ) {
    global $Globals, $db_link, $postreply, $privatelink;

    $profilelink = dcfp_auth_get_profile_url($tuserid);
    $postreply = "<span class=\"{$Style['medium']}\"><b>{$Globals['pp_lang']['postreply']}</b></span>";

    return( $profilelink );
}

//
// Get a list of users and ids as an option list
//

function useropts() {
    global $Globals, $db_link;

    $useropts = "";

    return( $useropts );
}

//
// Increment or decrement the user post in the users database
//

function inc_user_posts( $type = "plus", $userid = 0 ) {
    global $Globals, $db_link, $User;

    if ( $userid == 0 ) $usernum = $User['userid'];
    else $usernum = $userid;

    if ($type == "plus") dcfp_auth_increment_user_posts($usernum);
    else dcfp_auth_decrement_user_posts($usernum);

    return;
}


function get_profiledata( $cuserid ) {
    global $Globals, $db_link;
    global $cuser, $clocation, $ctitle, $cposts, $regdate, $ugallery, $isonline, $hpage, $postline, $profilelink, $privatelink;

    $regdate = ""; $ctitle = ""; $cposts = ""; $chomepage = ""; $cuser = $Globals['pp_lang']['unreg']; $postline = "";
    $hpage = ""; $ugallery="";
        $userprofile = array("Anonymous","","","","","","","","","");


    $postline = "";
    if ( $cuserid > 0 ) {
        $query = "SELECT id,username,ph,num_posts,UNIX_TIMESTAMP(reg_date) AS date,pe,pf,pg,uc,ub,ua,pb,pa,pc FROM " . DB_USER . " WHERE id=$cuserid LIMIT 1";

        $results = dcfp_auth_query($query);
        list($cuid,$cuser,$chomepage,$cposts,$tdate,$tcity,$tstate,$tcountry,$allow_email,$allow_pm,$hide_profile,$aolim,$icq,$avatar_url) = mysql_fetch_row($results);
        ppmysql_free_result($results);

        if ($tcity != "" || $tstate != "" || $tcountry != "") {
            $clocation = "$tcity $tstate $tcountry";
        }

        if ($chomepage != "" ) {
            $chomepage = str_replace("http://", "", $chomepage);
            $hpage = "<a href=\"http://$chomepage\" target=\"_blank\"><img src=\"".$Globals{'idir'}."/home.gif\" alt=\"{$Globals['pp_lang']['visithome']}\"border=\"0\"></a>";
        }

        if ($allow_email == 'yes' || $allow_disable_email == 'no') {
            $postline .= "<a href=\"" . dcfp_auth_get_email_url($cuid) . "\" target=\"_blank\"><img src=\"" . ROOT_URL .
                "/images/email.gif\" border=\"0\" alt=\"Click to send email to $cuser\"></a> ";
        }

        if ($allow_pm == 'yes' || $allow_disable_inbox == 'no') {
            $postline .= "<a href=\"" . dcfp_auth_get_private_msg_url($cuid) . "\" target=\"_blank\"><img
                src=\"" . ROOT_URL . "/images/mesg.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['sendpm']}\"></a> ";
        }

        if ($hide_profile == 'no' || $allow_disable_profile == 'no') {
            $postline .= "<a href=\"" . dcfp_auth_get_profile_url($cuid) . "\" target=\"_blank\"><img
                src=\"" . ROOT_URL . "/images/profile_small.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['seeprofile']}\"></a> ";
        }

        $postline .= "<a href=\"" . dcfp_auth_get_add_buddy_url($cuid) . "\" target=\"_blank\"><img
            src=\"" . ROOT_URL . "/images/mesg_add_buddy.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['addbuddy']}\"></a> ";

        if ($aolim && $aolim != "") {
            $postline .= "<a href=\"aim:goim?screenname=$aolim&message=Are+you+there?\"><img
                src=\"" . ROOT_URL . "/images/aolim.gif\" alt=\"Click to send message via AOL IM\" border=\"0\"></a> ";
        }

        if ($icq && $icq != "") {
            $postline .= "<a href=\"javascript:makeRemote('" . DCF . "?az=icq&user=$author_id')\" target=\"_blank\"><img
                src=\"http://web.icq.com/whitepages/online?icq=$icq&img=5\" alt=\"Click to send message via ICQ\" width=\"18\" height=\"18\" border=\"0\"></a> ";
        }

        // including home page in posts is not standard DCF+ -rb
        $postline .= $hpage;

        $userprofile[0] = $cuser;                   // Username
        $userprofile[1] = $chomepage;               // Homepage
        $userprofile[2] = $cposts;                  // Total Posts
        $userprofile[3] = $ctitle;                  // Title
        $userprofile[4] = $regdate;                 // Registered Date
        $userprofile[5] = $clocation;               // Location
        $userprofile[6] = "";                       // Avatar
        $userprofile[7] = "";                       // Signature
    }

    return( $userprofile );
}

function setlogin( $password ) {
    global $Globals, $User;

    dcfp_auth_do_login($User['username']);

    return;
}

function logout() {
    global $Globals;

    dcfp_auth_do_logout();

    return;
}

function get_regcode() {
    global $Globals;

    $regtext = " &middot; <A href=\"" . dcfp_auth_get_register_url() . "\">{$Globals['pp_lang']['register']}</a>";

    return($regtext);
}

function get_logincode() {
    global $Globals;

    $links[0] = dcfp_auth_get_retrieve_password_url();
    $links[1] = dcfp_auth_get_register_url();

    return($links);
}

function authenticate( $authuser="", $chkpassword="" ) {
    global $Globals, $User, $password, $link, $db_link;
    global $phoedit, $gologin, $bbuserid, $bbpassword;
    global $up_k, $disk_k, $cedit;
    global $usergroup;
    global $CatPerms, $ueditpho, $ueditposts, $exclude_cat;

    // Init some variables
    $User = array();
    $User['uploads'] = 0;
    $User['userid'] = 0;
    $User['nopost'] = 1;
    $User['adminedit'] = 0;
    $User['moderator'] = 0;
    $User['albums'] = 0;
    $User['uploadlimit'] = 0;

    $gologin = 1; $usergroup = 0; $checkpass = 0;
    $ueditpho = 0; $ueditposts = 0;
    $diskspace = 0; $uploadsize = 0;
    $md5cookpass="";

    $sh_dcf_authentic = false;    // assume the worst -rb
    $User['nopost'] = 1;    // we'll change if authentic -rb

    if ($authuser == "") { // need to resolve a cookie (if it exists) to determine status -rb
        // what info do we want back from the DCF+ user table? -rb
        $sh_return_fields = array("id", "username", "email", "ut", "g_id", "status");
        $sh_result = dcfp_auth_resolve_cookie($sh_return_fields);
        if ($sh_result) {    // found a user with an active session -rb
            // don't authenticate a user whose status is set to 'off'! -rb
            if ($sh_result['status'] == 'on') {
                $sh_dcf_authentic = true;
            }
        }
    } else {    // find $authuser and authenticate $password -rb
        // what info do we want back from the DCF+ user table? -rb
        $sh_return_fields = array("id", "username", "email", "ut", "g_id", "status");
        $sh_result = dcf_auth_user_by_uname($authuser, $password, $sh_return_fields);
        if($sh_result) {    // user exists, status is 'on' -rb
            $sh_dcf_authentic = true;
        }
    }

    if ($sh_dcf_authentic) {    // we gots us a real live bona fide user -rb
        $gologin = 0;
        $User['nopost'] = 0;
        $usergroup = $sh_result['g_id'];
        $User['userid'] = $sh_result['id'];
        $User['username'] = $sh_result['username'];
        $User['email'] = $sh_result['email'];
        //$User['offset'] = $sh_result['ut'];
        $User['offset'] = 0;
    }
    else
    {
        $usergroup = 3;    // not logged in, use Unregistered group for guest access -rb
    }

    $CatPerms = array();

    set_user_perms( array($usergroup) );

    return( $gologin );
}

function import_user_groups() {
    global $Globals, $db_link, $link;

    $query = "SELECT groupid, groupname, cpaccess, uploads, comments, diskspace, uploadsize, uplimit, editpho, editposts, modaccess, useralbums, reqmod, canassign FROM {$Globals['pp_db_prefix']}usergroups";
    $resultcur = ppmysql_query($query, $link);
    $currentGroups = array();

    while ( list($groupid, $groupname, $cpaccess, $uploads, $comments, $diskspace, $uploadsize, $uplimit, $editpho, $editposts, $modaccess, $useralbums, $reqmod, $canassign) = mysql_fetch_row( $resultcur ) ) {
        $currentGroups[$groupid]['groupid'] = $groupid;
        $currentGroups[$groupid]['groupname'] = $groupname;
        $currentGroups[$groupid]['cpaccess'] =  $cpaccess;
        $currentGroups[$groupid]['uploads'] =  $uploads;
        $currentGroups[$groupid]['comments'] =  $comments;
        $currentGroups[$groupid]['diskspace'] =  $diskspace;
        $currentGroups[$groupid]['uploadsize'] =  $uploadsize;
        $currentGroups[$groupid]['uplimit'] =  $uplimit;
        $currentGroups[$groupid]['editpho'] =  $editpho;
        $currentGroups[$groupid]['editposts'] =  $editposts;
        $currentGroups[$groupid]['modaccess'] =  $modaccess;
        $currentGroups[$groupid]['useralbums'] =  $useralbums;
        $currentGroups[$groupid]['reqmod'] =  $reqmod;
        $currentGroups[$groupid]['canassign'] =  $canassign;
    }

    $query = "SELECT id,name FROM dcgroup";
    $readug = ppmysql_query($query,$db_link);
    $newGroups = array();

    while ( list($gid, $title) = mysql_fetch_row( $readug ) ) {
        $newGroups[$gid] = $gid;
        if ( !array_key_exists($gid,$currentGroups) ) {
            $currentGroups[$gid]['groupid'] = $gid;
            $currentGroups[$gid]['groupname'] = $title;
            $currentGroups[$gid]['cpaccess'] =  ( $title == "administrator" ? 1 : 0 );
            $currentGroups[$gid]['uploads'] =  0;
            $currentGroups[$gid]['comments'] = 0;
            $currentGroups[$gid]['diskspace'] =  0;
            $currentGroups[$gid]['uploadsize'] = 0;
            $currentGroups[$gid]['uplimit'] = 0;
            $currentGroups[$gid]['editpho'] =  0;
            $currentGroups[$gid]['editposts'] =  0;
            $currentGroups[$gid]['modaccess'] =  0;
            $currentGroups[$gid]['useralbums'] =  0;
            $currentGroups[$gid]['reqmod'] =  0;
            $currentGroups[$gid]['canassign'] =  0;
        }

    }
    ppmysql_free_result( $readug );

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        if ( !array_key_exists($gid, $newGroups)) {
            unset($currentGroups[$gid]);
        }
    }

    $query = "DELETE FROM {$Globals['pp_db_prefix']}usergroups";
    $resulta = ppmysql_query($query, $link);

    foreach ($currentGroups as $currentGroup) {
        $gid = $currentGroup['groupid'];
        $name = addslashes($currentGroup['groupname']);
        $cpaccess = $currentGroup['cpaccess'];
        $uploads = $currentGroup['uploads'];
        $comments =    $currentGroup['comments'];
        $diskspace = $currentGroup['diskspace'];
        $uploadsize = $currentGroup['uploadsize'];
        $uploadlimit = $currentGroup['uplimit'];
        $editpho = $currentGroup['editpho'];
        $editposts = $currentGroup['editposts'];
        $modaccess = $currentGroup['modaccess'];
        $useralbums = $currentGroup['useralbums'];
        $reqmod = $currentGroup['reqmod'];
        $canassign = $currentGroup['canassign'];

        $query = "INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,modaccess,cpaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign) VALUES('$gid','$name','$modaccess','$cpaccess','$uploads','$uplimit','$comments','$diskspace','$uploadsize','$editpho','$editposts','$useralbums','$reqmod','$canassign')";
        $setug = ppmysql_query($query,$link);
    }
}


function init_user_groups() {
    global $link, $pp_db_prefix;

    $query = "CREATE TABLE {$pp_db_prefix}usergroups (groupid int(5) NOT NULL auto_increment, groupname varchar(50) NOT NULL default '', cpaccess smallint(3) NOT NULL default '0', modaccess smallint(3) NOT NULL default '0', uploads smallint(3) NOT NULL default '1', comments smallint(3) NOT NULL default '1', diskspace int(10) default NULL, uploadsize int(10) default NULL, uplimit INT(5) DEFAULT '0' NOT NULL, editpho int(3) NOT NULL default '0', editposts int(3) NOT NULL default '0', useralbums int(3) NOT NULL default '0',reqmod INT(3) DEFAULT '0' NOT NULL, canassign INT(3) DEFAULT '0' NOT NULL, PRIMARY KEY (groupid)) TYPE=MyISAM;";
    $setup = mysql_query($query,$link);

    return($setup);
}


function convert_markups($markup)
{
    global $Globals;

    return ( ppconvert_markups($markup) );
}

function get_forum_style()
{
    global $Globals;

    return( "<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />" );
}


//
// Style references
//

if ( $Globals['forumstyle'] == "yes" ) {
    $Style['onbody'] = "onbody";
    $Style['tableborders'] = "tableborders";
    $Style['tablesurround'] = "";
    $Style['tddetails'] = "tddetails";
    $Style['tdbackground'] = "tdbackground";
    $Style['tdnothumbs'] = "tdnothumbs";
    $Style['menubar'] = "menubar";
    $Style['menubarnb'] = "menubarnb";
    $Style['catcolumn'] = "catcolumn";
    $Style['photocol'] = "photocol";
    $Style['commentscol'] = "commentscol";
    $Style['lastphocol'] = "lastphocol";
    $Style['lastcommcol'] = "lastcommcol";
    $Style['small'] = "small";
    $Style['medium'] = "medium";
    $Style['large'] = "large";
    $Style['welcome'] = "welcome";
    $Style['lighttable'] = "lighttable";
    $Style['alternatetable'] = "alternatetable";
    $Style['formboxes'] = "formboxes";
    $Style['blockquote'] = "blockquote";
}

?>
