<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2006, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "pprss" );

require "pp-inc.php";

typecast($_REQUEST, array('type' => STRING, 'cat' => INT, 'ppuser' => INT));

authenticate();

$thisdate = date( "r" );

echo<<<PPPRINT
<?xml version="1.0" encoding="ISO-8859-1" ?>

<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">
    <channel>
        <title>{$Globals['webname']}</title>
        <description></description>
        <language>en-us</language>
        <link>{$Globals['maindir']}</link>
        <lastBuildDate>$thisdate</lastBuildDate>
        <generator>PhotoPost Pro 7.0</generator>
        <ttl>60</ttl>\n
PPPRINT;

//$rss->feedURL = $Globals['maindir'].$PHP_SELF;

$catcache = array();

if ( $ppuser )
{
    $cats = "WHERE userid=$ppuser AND approved = 1";
}
else
{
    if ( $cat )
    {
        list( $children ) = ppmysql_query_onerow("SELECT children FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat LIMIT 1", $link);

        if ( $children )
        {
            $cat = "$cat,$children";
        }

        $cats = "WHERE cat IN ($cat) AND approved = 1";
    }
    else
    {
        $cats = "WHERE approved = 1";
    }
}

$res = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}photos $cats ORDER BY date DESC LIMIT 50", $link);
while ($data = mysql_fetch_array($res))
{
    $thiscat = $data['cat'];
    if( $data['storecat'] != 0 ) $data['cat'] = $data['storecat'];
    if ( $data['cattype'] == "a" ) $CatPerms['ugview'][$thiscat] = $CatPerms['ugview'][500];

        if ( $CatPerms['ugview'][$thiscat] == 0 )
        {
            if ( $catcache[$thiscat] == "" )
            {
                $catcache[$thiscat] = is_image_private( $data['cat'] );
            }

            if ( $catcache[$thiscat] == "no" )
            {
                // Add description?
                if ( !empty($data['description']) ) $data['description'] = "<br /><br />{$Globals['pp_lang']['desc']}: ". $data['description'];

                // Get the thumbnail
                $thumb = get_imagethumb( $data['bigimage'], $data['cat'], $data['userid'], 1 );
                $thumb = "<a href=\"". construct_newppurl( "showphoto.php", array( 'photo' => $data['id'], 'title' => $data['title'], 'cat' => $data['cat']) ) ."\">$thumb</a>";

                // Add comments indicator?
                if ( $data['numcom'] > 1 ) $data['description'] .= "<br /><br />{$data['numcom']} {$Globals['pp_lang']['littlecom']}";
                elseif ( $data['numcom'] ) $data['description'] .= "<br /><br />{$data['numcom']} {$Globals['pp_lang']['comsing']}";

                $title = htmlspecialchars( $data['title'] );
                $pholink = construct_newppurl( "showphoto.php", array('photo' => $data['id'], 'title' => $data['title'], 'cat' => $data['cat']) );

                $desc = htmlspecialchars( "$thumb<br /><br />{$Globals['pp_lang']['by']}: {$data['user']}{$data['description']}" );
                $user = htmlspecialchars( $data['user'] );
                $date = htmlspecialchars( date('r',$data['date']) );

echo<<<PPPRINT
        <item>
            <title>{$title}</title>
            <link>{$pholink}</link>
            <description>{$desc}</description>
            <author>{$user}</author>
            <pubDate>{$date}</pubDate>
        </item>\n
PPPRINT;
            }
        }
}

echo<<<PPPRINT
    <atom:link href="{$Globals['maindir']}/external.php?type=RSS2" rel="self" type="application/rss+xml" />
    </channel>
</rss>
PPPRINT;

?>
