<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "editphoto" );
require "pp-inc.php";
require "{$Globals['PP_PATH']}/image-inc.php";

typecast_wc('custom', STRING);

typecast($_REQUEST, array('phoedit' => INT, 'approve' => INT, 'nocache' => INT, 'stick' => INT, 'unstick' => INT,
                          'hide' => INT, 'unhide' => INT, 'uncat' => INT, 'makecat' => INT,
                          'open' => INT, 'close' => INT));
typecast($_POST, array('rating' => INT,'newowner' => STRING, 'title' => STRING, 'keywords' => STRING,
                       'desc' => STRING, 'extra1' => STRING, 'extra2' => STRING, 'extra3' => STRING,
                       'extra4' => STRING, 'extra5' => STRING, 'extra6' => STRING, 'origcat' => INT,
                       'category' => INT, 'copycat' => INT, 'edit' => STRING, 'delete' => STRING,
                       'checklist' => STRING, 'mature' => STRING));

if ( !isset($edit) )
{
    $edit = "no";
}

if ( !isset($delete) )
{
    $delete = null;
}

list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

// if we're editing a photo, check to see that the user is either an admin/mod or the post owner ###

if ( $gologin == 1 )
{
    login( "{$Globals['maindir']}/editphoto.php?phoedit=$phoedit" );
    exit;
}

if ( $phoedit > 0 )
{
    $result = ppmysql_query("SELECT userid FROM {$Globals['pp_db_prefix']}photos WHERE id=$phoedit LIMIT 1", $link);
    list( $echeck ) = mysql_fetch_row($result);

    if ($User['adminedit'] == 0)
    {
        if ($User['userid'] != $echeck)
        {
            $User['nopost'] = 1;
        }
    }
}

if ( ($User['nopost'] == 1 || $ueditpho == 0) && !($User['adminedit'] == 1 || $User['moderator'] == 1) )
{
    forward( "showphoto.php?photo=$phoedit", $Globals['pp_lang']['noperm'] );
    exit;
}

if ( isset($stick) )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET disporder=1 WHERE id=$stick", $link);
        forward( "showphoto.php?photo=$stick", $Globals['pp_lang']['stuck'] );
        exit;
    }
    else
    {
        diewell( $Globals['pp_lang']['adminreq'] );
    }
}

if ( isset($unstick) )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET disporder=99999 WHERE id=$unstick", $link);
        forward( "showphoto.php?photo=$unstick", $Globals['pp_lang']['unstuck'] );
        exit;
    }
    else
    {
        diewell( $Globals['pp_lang']['adminreq'] );
    }
}

if ( isset($uncat) )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET thumbnail=0 WHERE id=$uncat", $link);

        // Let's update the category cache
        update_catcache();

        forward( "showphoto.php?photo=$phoedit", $Globals['pp_lang']['untagged'] );
        exit;
    }
    else
    {
        diewell( $Globals['pp_lang']['adminreq'] );
    }
}

if ( isset($makecat) )
{
    if ( $User['adminedit'] == 1 )
    {
        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET thumbnail=$phoedit WHERE id=$makecat", $link);

        // Let's update the category cache
        update_catcache();

        forward( "showphoto.php?photo=$phoedit", $Globals['pp_lang']['tagged'] );
        exit;
    }
    else
    {
        diewell( $Globals['pp_lang']['adminreq'] );
    }
}

if ( $phoedit == 0 )
{
    diewell( $Globals['pp_lang']['badcall'] );
}

if ( $edit != "yes" )
{
    topmenu();

    $resulta = ppmysql_query("SELECT user,cat,storecat,storeid,title,description,ismature,keywords,bigimage,approved,userid,allowprint,extra1,extra2,extra3,extra4,extra5,extra6 FROM {$Globals['pp_db_prefix']}photos WHERE id=$phoedit LIMIT 1", $link);
    list( $imgowner, $pcat, $storecat, $storeid, $ptitle, $pdesc, $pmature, $pkeywords, $bigimage, $approved, $theuser, $allowprint,
          $extra1, $extra2, $extra3, $extra4, $extra5, $extra6 ) = mysql_fetch_row($resulta);

    // Look for copies
    $resultb = ppmysql_query("SELECT p.id,p.cat,c.catname FROM {$Globals['pp_db_prefix']}photos p
              LEFT JOIN {$Globals['pp_db_prefix']}categories c ON c.id=p.cat
              WHERE p.storeid=$phoedit OR p.id=$storeid", $link);

    $copycats = array();
    while ( list( $exid, $excat, $excatname ) = mysql_fetch_row($resultb) )
    {
        $copycats[] .= "<a href=\"{$Globals['maindir']}/editphoto.php?phoedit=$exid\" target=\"_blank\">$excatname</a>";
    }

    // Back to the rest
    $ptitle = str_replace( "\"", "&quot;", $ptitle);
    $pdesc = str_replace( "\"", "&quot;", $pdesc);
    $pkeywords = str_replace( "\"", "&quot;", $pkeywords);
    $extra1 = str_replace( "\"", "&quot;", $extra1);
    $extra2 = str_replace( "\"", "&quot;", $extra2);
    $extra3 = str_replace( "\"", "&quot;", $extra3);
    $extra4 = str_replace( "\"", "&quot;", $extra4);
    $extra5 = str_replace( "\"", "&quot;", $extra5);
    $extra6 = str_replace( "\"", "&quot;", $extra6);

    if ( $storecat == 0 )
    {
        $storecat = $pcat;
    }

    $imgtag = get_imagethumb( $bigimage, $storecat, $theuser, $approved, 1 );

    $resulta = ppmysql_query("SELECT catname,cattype,theme,extra1,extra2,extra3,extra4,extra5,extra6,numextra FROM {$Globals['pp_db_prefix']}categories WHERE id='".intval($pcat)."'", $link);
    list( $thecatname, $cattype, $cattheme, $Globals['extra1name'], $Globals['extra2name'], $Globals['extra3name'], $Globals['extra4name'], $Globals['extra5name'], $Globals['extra6name'], $numextra ) = mysql_fetch_row($resulta);

    if ( $cattheme != "" )
    {
        $Globals['theme'] = $cattheme;

        if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
        {
            $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
        }
    }

    $ismod = ( $User['adminedit'] == 1 ? true : false );
    if ( $User['moderator'] == 1 )
    {
        $ismod = is_moderator($pcat);
    }

    // Grab custom fields
    $extraprompts = array();
    if ( $numextra > 0 )
    {
        $catextras = ppmysql_query("SELECT e.id,e.fieldname,e.fieldtype,e.fieldoptions,p.selection FROM {$Globals['pp_db_prefix']}extrafields e
                   LEFT JOIN {$Globals['pp_db_prefix']}photoextras p ON (p.extraid=e.id AND p.photo=$phoedit)
                   WHERE e.cat=$pcat", $link);

        $x = 0;
        $numcustom = 0;
        $checklist = null;

        while ( list($exid, $exname, $extype, $exoptions, $extrasel) = mysql_fetch_row($catextras) )
        {
            $extraprompts['name'][$x] = $exname;

            if ( $extype == "t" )
            {
                $extraprompts['options'][$x] = "<input type=\"text\" name=\"custom_$exid\" value=\"$extrasel\" size=\"20\">";
                $x++;
            }
            elseif ( $extype == "c" )
            {
                $exselection = null;
                $exselects = explode("||", $exoptions );
                $exmysel = explode(",", $extrasel );

                $y = 0;
                foreach( $exselects as $exextra )
                {
                    $checked = null;
                    if ( $extrasel != null && in_array($y, $exmysel) )
                    {
                        // This is one they selected
                        $checked = "checked=\"checked\"";
                    }

                    $exselection .= "<input type=\"checkbox\" name=\"custom_{$exid}_{$y}\" $checked> $exextra<br />";
                    $y++;
                }

                $extraprompts['options'][$x] = $exselection;
                $checklist .= ( $checklist == null ? "$exid" : ",$exid" );
                $x++;
            }
            elseif ( $extype == "r" )
            {
                $exprompt = null;
                $exarray = explode("||", $exoptions );

                foreach( $exarray as $exextra )
                {
                    if ( $exextra ) {
                        $checked = null;

                        if ( $exextra == $extrasel )
                        {
                            $checked = "checked=\"checked\"";
                        }
                        $exprompt .= "<input type=\"radio\" name=\"custom_$exid\" value=\"$exextra\" $checked> $exextra<br />";
                    }
                }

                $extraprompts['options'][$x] = $exprompt;
                $x++;
            }
            elseif ( $extype == "d" )
            {
                $exprompt = "<select name=\"custom_$exid\">";
                $exarray = explode("||", $exoptions );

                foreach( $exarray as $exextra )
                {
                    if ( $exextra )
                    {
                        $checked = null;
                        if ( $exextra == $extrasel )
                        {
                            $checked = "selected=\"selected\"";
                        }
                        $exprompt .= "<option value=\"$exextra\" $checked>$exextra</option>";
                    }
                }
                $exprompt .= "</select>";

                $extraprompts['options'][$x] = $exprompt;
                $x++;
            }
        }
        $numcustom = $x;
    }

    printheader( $pcat, $Globals['pp_lang']['editphoto'] );

    childsub($pcat, $cattype);
    $childnav = "<span class=\"{$Style['small']}\"><a href=\"{$Globals['maindir']}/index.php\">{$Globals['pp_lang']['home']}</a> $childnav</span>";

    // One blank for copy
    $selected = 0;
    catmoveopt(0);
    $catcopy = $catoptions;
    $catoptions = null;

    // One with selected for move
    $selected = $pcat;
    catmoveopt(0);

    if ( $allowprint == "yes" )
    {
        $allowselect = "<option selected=\"selected\">yes</option><option>no</option>";
    }
    else
    {
        $allowselect = "<option>yes</option><option selected=\"selected\">no</option>";
    }

    if ( $pmature == 0 )
    {
        $maturesel = "<option selected=\"selected\" value=\"no\">{$Globals['pp_lang']['no']}</option><option value=\"yes\">{$Globals['pp_lang']['yes']}</option>";
    }
    else
    {
        $maturesel = "<option value=\"no\">{$Globals['pp_lang']['no']}</option><option selected=\"selected\" value=\"yes\">{$Globals['pp_lang']['yes']}</option>";
    }

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/editphoto.tmpl" );

    printfooter();
}
else
{
    // do the edit, make sure the user has permission to edit
    if ( $delete == "delete" )
    {
        $resulta = ppmysql_query("SELECT userid,cat,storecat,storeid,bigimage,medsize,title FROM {$Globals['pp_db_prefix']}photos WHERE id=$phoedit", $link);

        if ( !$resulta )
        {
            diewell( "$photo: {$Globals['pp_lang']['nophoto']}" );
        }

        list( $puserid, $thecat, $storecat, $storeid, $filename, $medsize, $ptitle ) = mysql_fetch_row($resulta);
        ppmysql_free_result( $resulta );

        $ismod = ( $User['adminedit'] == 1 ? true : false );
        if ( $User['moderator'] == 1 )
        {
            $ismod = is_moderator($thecat);
        }

        if ( ($User['userid'] == $puserid && $Globals['userdel'] == "yes") || $ismod )
        {
            if ( !is_numeric($phoedit) )
            {
                diewell( $Globals['pp_lang']['malformed'] );
            }

            // if an original, then we have to move it to another cat and update those copies
            // count number of "copies"
            $result2a = ppmysql_query("SELECT id,cat FROM {$Globals['pp_db_prefix']}photos WHERE storeid=$phoedit", $link);

            // if any, then we need to move this image to one of the copies
            if ( mysql_num_rows($result2a) > 0 )
            {
                if ( $storecat == 0 )
                {
                    // move the image to the next cat
                    list( $nextid, $nextcat ) = mysql_fetch_row($result2a);

                    // move the phyiscal file if an original
                    move_image( $thecat, $nextcat, $puserid, $filename );

                    // update all copies to point to new location and make this one the new pointer
                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=$nextcat,storeid=$nextid WHERE storeid=$phoedit", $link);
                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=0,storeid=0 WHERE id=$nextid", $link);
                }
            }
            else
            {
                // if none, just remove the image
                remove_all_files( $filename, $medsize, $puserid, $thecat );
            }

            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$phoedit", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE photo=$phoedit", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$phoedit", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$phoedit", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photoextras WHERE photo=$phoedit", $link);
            adminlog( "Photo Deleted: $filename (#$phoedit) $ptitle" );

            upgradecategories($thecat);

            if ( $nextcat )
            {
                upgradecategories($nextcat);
            }

            // Force refresh of cache
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

            if ($Globals['ppostcount'] == "yes" && $puserid > 0)
            {
                inc_user_posts( "minus", $puserid );
            }

            // Update if last photo is set to this photo
            $resulta = ppmysql_query("SELECT lastphoto FROM {$pp_db_prefix}users WHERE userid=$puserid LIMIT 1", $link);
            list( $lastphoto ) = mysql_fetch_row($resulta);

            if ( $lastphoto == $phoedit )
            {
                ppmysql_query("UPDATE {$pp_db_prefix}users SET lastphoto=0,lastdate=0 WHERE userid=$puserid LIMIT 1", $link);
                $resultb = ppmysql_query("SELECT id,date FROM {$pp_db_prefix}photos WHERE userid=$puserid ORDER BY date DESC LIMIT 1", $link);

                while ( list($pid, $pdate) = mysql_fetch_row($resultb) )
                {
                    if ( $pid )
                    {
                        ppmysql_query("UPDATE {$pp_db_prefix}users SET lastphoto=$pid,lastdate=$pdate WHERE userid=$puserid", $link);
                    }
                }
            }

            if ( $Globals['useemail'] == "yes" && ($User['userid'] != $puserid) )
            {
                admin_email( 'delete', $phoedit, $puserid, $ptitle );
            }

            forward("showgallery.php?cat=$thecat", $Globals['pp_lang']['deleted']);
        }
        else
        {
            diewell( $Globals['pp_lang']['noaction'] );
        }
    }
    else
    {
        if ( isset($_FILES['theimage']['name'][0]) )
        {
            if ( !empty($_FILES['theimage']['name'][0]) )
            {
                $realname = $_FILES['theimage']['name'][0];
                $realname = fixfilenames( $realname );
                $theext   = get_ext( $realname );

                $resulta = ppmysql_query("SELECT userid,cat,storecat,storeid,bigimage,medsize FROM {$Globals['pp_db_prefix']}photos WHERE id=$phoedit", $link);
                list( $ouserid, $ocategory, $storecat, $storeid, $ofilename, $omedsize ) = mysql_fetch_row($resulta);
                ppmysql_free_result( $resulta );

                if ( $storecat == 0 )
                {
                    $storecat = $ocategory;
                }

                $User['userid'] = $ouserid;
                $upuserid = $ouserid;
                $filepath = "{$Globals['origfull']}$category/$ofilename";

    	        // $disk_k is set in forum file and is their max upload specs
    	        $disk_k = ($disk_k * 1024);
    	        $up_k = ($up_k * 1024);

    	        $filesize = $_FILES['theimage']['size'][0];
    	        $diskbytes = $disk_k - ($diskuse + $filesize);

    	        if ( $filesize > $up_k && $up_k != 0 )
       	        {
    	            diewell( "$realname ({$Globals['pp_lang']['exfiles']})" );
    	        }

                if ( is_multimedia($ofilename) )
                {
                    $dst_file = handleupload();
                    $thumbsize = create_thumb( "", $dst_file, $category, $ofilename );
                    unlink( $dst_file );
                }
                else {
                    if ( is_image($ofilename) )
                    {
                        remove_all_files( $ofilename, $omedsize, $ouserid, $storecat );
                        handleupload( "data", 0, $ofilename );

                        if ( $wasuploaded == "no" )
                        {
                            diewell("{$Globals['pp_lang']['notype']}");
                        }

                        $thumbsize = create_thumb( $ofilename, $filepath, $category );
                        process_image( $ofilename, $filepath, $category, 0, $phoedit );
                    }
                }
            }
        }

        // New Owner?
        if ( $User['adminedit'] == 1 )
        {
            $resulta = ppmysql_query("SELECT user,cat,storecat,storeid,bigimage,userid FROM {$Globals['pp_db_prefix']}photos WHERE id=$phoedit LIMIT 1", $link);
            list( $imgowner, $pcat, $storecat, $storeid, $bigimage, $theuser ) = mysql_fetch_row($resulta);

            if ( isset($newowner) && !empty($newowner) && ($imgowner != $newowner) )
            {
                list( $newuserid, $newname, $tmail ) = get_userinfo($newowner);
                if ( empty($newuserid) )
                {
                    diewell( "$newowner: Unable to find this user. Please check spelling." );
                }

                // Got a new user; now change the owner.
                $imgowner = $newname;
                $theuser = $newuserid;
                $newname = addslashes($newname);
                $result = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET user='$newname',userid='$newuserid' WHERE id=$phoedit", $link);
            }
        }

        $moderate = ( $User['usemod'] == 0 ? 1 : 0 );
        $ismature = ( $mature == "yes" ? 1 : 0 );

        $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET title='$title',keywords='$keywords',description='$desc',ismature=$ismature,allowprint='$allowprint',
            extra1='$extra1',extra2='$extra2',extra3='$extra3',extra4='$extra4',extra5='$extra5',extra6='$extra6',approved='$moderate' WHERE id=$phoedit", $link);

        if ( $origcat != $category && !empty($category) )
        {
            if ( $storecat == 0 )
            {
                move_image_cat( $phoedit, $category, "no" );
                $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=$category WHERE storeid=$phoedit", $link);
            }
            else
            {
                $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET cat='$category' WHERE id=$phoedit", $link);

                upgradecategories($category);
                upgradecategories($origcat);
            }
        }

        if ( $copycat > 0 && $Globals['optcats'] == "yes" )
        {
            // User wants to create a copy
            $resulta = ppmysql_query("SELECT cat,storecat,storeid,title,description,keywords,bigimage,width,height,filesize,medwidth,medheight,medsize,date,
                             approved,userid,user,allowprint,extra1,extra2,extra3,extra4,extra5,extra6,watermarked FROM {$Globals['pp_db_prefix']}photos WHERE id=$phoedit LIMIT 1", $link);
            list( $pcat, $storecat, $storeid, $ptitle, $pdesc, $pkeywords, $bigimage, $width, $height, $filesize, $medw, $medh, $meds, $jdate,
                  $approved, $theuser, $thename, $allowprint, $extra1, $extra2, $extra3, $extra4, $extra5, $extra6, $watermarked ) = mysql_fetch_row($resulta);

            $ipaddr = findenv("REMOTE_ADDR");
            if ( $storeid == 0 ) {
                $storeid = $phoedit;
            }

            if ( $storecat == 0 )
            {
                $storecat = $pcat;
            }

            $ptitle = addslashes($ptitle);
            $pdesc = addslashes($pdesc);
            $pkeywords = addslashes($pkeywords);
            $extra1 = addslashes($extra1);
            $extra2 = addslashes($extra2);
            $extra3 = addslashes($extra3);
            $extra4 = addslashes($extra4);
            $extra5 = addslashes($extra5);
            $extra6 = addslashes($extra6);

            ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photos (id,user,userid,cat,storecat,storeid,date,title,description,keywords,bigimage,width,height,
                                filesize,medwidth,medheight,medsize,approved,watermarked,allowprint,extra1,extra2,
                                extra3,extra4,extra5,extra6,ipaddress)
                           VALUES (NULL,'$thename', $theuser, $copycat, '$storecat', '$storeid', $jdate, '$ptitle',
                                '$pdesc', '$pkeywords', '$bigimage', $width, $height, $filesize, $medw,
                                $medh, $meds, $moderate, '$watermarked','$allowprint','$extra1','$extra2',
                                '$extra3','$extra4','$extra5','$extra6','$ipaddr')", $link);

            $result3b = ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}categories SET photos=(photos+1) WHERE id=$copycat", $link );
        }

        $resulta = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}photoextras WHERE photo=$phoedit", $link);
        list( $phoextracount ) = mysql_fetch_row($resulta);

        // Process all the custom variables for this image
        $checkbx = array();
        $is_checkboxes = false;

        foreach( $_POST as $id=>$setting )
        {
            if ( strstr($id, "custom") )
            {
                $iscustom = true;
                $exeach = explode( "_", $id );

                if ( count($exeach) == 3 )
                {
                    // Unique to checkboxes which have three parameters and must be cached
                    $extid = $exeach[1];
                    $extck = $exeach[2];

                    $checkbx[$extid][] = $extck;
                    $is_checkboxes = true;

	                if ( isset($checkbx[$extid]) )
	                {
	                    $flatbox = implode( ",", $checkbx[$extid] );
	                    $flatbox = addslashes($flatbox);

	                    if ( $phoextracount > 0 )
	                    {
	                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photoextras SET selection='$flatbox' WHERE extraid=$extid AND photo=$phoedit", $link);
	                    }
	                    else
	                    {
	                        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoextras (id,photo,extraid,selection) VALUES(NULL,$phoedit,$extid,'$flatbox')", $link);
	                    }
	                }
	                else
	                {
	                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photoextras SET selection='' WHERE extraid=$extid AND photo=$phoedit", $link);
	                }
                }
                else
                {
                    // Everyone else
                    $extid = $exeach[1];
                    $setting = addslashes($setting);

                    if ( $phoextracount > 0 )
                    {
                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photoextras SET selection='$setting' WHERE extraid='$extid' AND photo=$phoedit", $link);
                    }
                    else
                    {
                        ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoextras (id,photo,extraid,selection) VALUES(NULL,$phoedit,$extid,'$setting')", $link);
                    }
                }
            }
        }

        forward( "showphoto.php?photo=$phoedit&nocache=1", $Globals['pp_lang']['success'] );
    }
}

?>
