<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "ecard" );
require "pp-inc.php";

if ($Globals['enablecard'] == "no") {
    diewell($Globals['pp_lang']['ecdisabled']);
}

typecast($_REQUEST, array('inputphoto' => INT, 'ecard' => INT, 'view' => STRING));
typecast($_POST, array('photoid' => INT, 'send' => STRING,'preview' => STRING,'rname' => STRING,
                       'remail' => STRING,'subject' => STRING,'message' => STRING,'fromname' => STRING,
                       'fromemail' => STRING,'touser' => STRING,'backcolor' => STRING,'bordcolor' => STRING,
                       'fontcolor' => STRING,'pickfont' => STRING,'layout' => STRING,'return' => INT));

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( isset($ecard) )
{
    if ($Globals['cardreg'] == "yes")
    {
        if ( $gologin == 1 )
        {
            login( "{$Globals['maindir']}/ecard.php?ecard=$ecard" );
            exit;
        }
    }
}

if ( isset( $view ) )
{
    $cnum = explode( "-", $view );
    $checkid = (int)$cnum[0];
    $checkdate = (int)$cnum[1];

    $resulta = ppmysql_query("SELECT id,fromname,toname,subject,message,date,photoid,backcolor,bordcolor,fontcolor,pickfont,layout,returnr,readdate FROM {$Globals['pp_db_prefix']}ecards WHERE date=$checkdate LIMIT 1", $link);
    list( $cardid, $fromname, $toname, $subject, $message, $carddate, $photoid, $backcolor, $bordcolor, $fontcolor, $pickfont, $layout, $returnr, $readdate) = mysql_fetch_row($resulta);

    if ( $photoid != $checkid )
    {
        diewell( $Globals['pp_lang']['nophoto'] );
    }

    $inputphoto = $photoid;
}
else
{
    $inputphoto = $ecard;
}

if ( $inputphoto == 0 )
{
    diewell( $Globals['pp_lang']['nophoto'] );
}

if ( $send != "yes" || isset($preview) )
{
    $rows = ppmysql_query("SELECT id,user,userid,cat,storecat,date,title,description,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved FROM {$Globals['pp_db_prefix']}photos WHERE id=$inputphoto LIMIT 1", $link);
    list( $id, $user, $iuserid, $cat, $storecat, $date, $title, $desc, $keywords, $bigimage, $width, $height, $filesize, $views, $medwidth, $medheight, $medsize, $approved ) = mysql_fetch_row($rows);

    $filename = get_filename( $bigimage );

    if ( $storecat == 0 )
    {
        $storecat = $cat;
    }

    if ( $approved == 1 )
    {
        if ( $medsize > 0 )
        {
            if ( $size != "big" )
            {
                $dispmed = "1";
                $altlink = "<div align=\"center\"><span class=\"{$Style['medium']}\"><b>
                    <a href=\"{$Globals['maindir']}/showphoto.php?photo=$inputphoto&amp;size=big\">{$Globals['pp_lang']['larger']}</a></b></span></div><br />";
            }
            else
            {
                $altlink = "<div align=\"center\"><span class=\"{$Style['medium']}\"><b><a
                    href=\"{$Globals['maindir']}/showphoto.php?photo=$inputphoto\">{$Globals['pp_lang']['smaller']}</a></b></span></div><br />";
            }
        }

        if ( $Globals['bigsave'] == "yes" )
        {
            if ( $dispmed == 1 )
            {
                if ( $Globals['onthefly'] == 1 )
                {
                    $imgdisp = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$inputphoto&amp;size=big\"><img
                        width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['maindir']}/watermark.php?file=$storecat/medium/$bigimage&amp;sort=$sort\" border=\"0\" alt=\"\" /></a>";
                }
                else
                {
                    $imgdisp = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$inputphoto&amp;size=big\"><img
                        width=\"$medwidth\" height=\"$medheight\" src=\"{$Globals['datadir']}/$storecat/medium/$bigimage\" border=\"0\" alt=\"\" /></a>";
                }
            }
            else
            {
                if ( is_multimedia($bigimage) == 1 )
                {
                     $mmthumb = "{$Globals['datadir']}/$storecat/thumbs/$filename.jpg";
                     $dirthumb = "{$Globals['datafull']}/$storecat/thumbs/$filename.jpg";

                     if ( !file_exists($dirthumb) )
                     {
                        $mmthumb = "{$Globals['idir']}/video.gif";
                    }

                     $imgdisp = "<a href=\"{$Globals['datadir']}/$storecat/$bigimage\"><img src=\"$mmthumb\" border=\"0\" alt=\"\" /></a>
                        <br /><span class=\"{$Style['small']}\">{$Globals['pp_lang']['video']}</span>";
                }
                else
                {
                    if ( $filesize > 0 )
                    {
                        if ( $Globals['onthefly'] == 1 )
                        {
                            $imgdisp = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$inputphoto\">
                                <img width=\"$width\" height=\"$height\" src=\"{$Globals['maindir']}/watermark.php?file=$storecat/$bigimage\" border=\"0\" alt=\"$filename\" /></a>";
                        }
                        else
                        {
                            $imgdisp = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$inputphoto\">
                                <img width=\"$width\" height=\"$height\" src=\"{$Globals['origdir']}/$storecat/$bigimage\" border=\"0\" alt=\"$filename\" /></a>";
                        }
                    }
                    else
                    {
                        $imgdisp = "<img src=\"{$Globals['datadir']}/$storecat/thumbs/$bigimage\" border=\"0\" alt=\"\" />";
                    }
                }
            }
        }
        else
        {
            $imgdisp = "<img src=\"{$Globals['origdir']}/$storecat/thumbs/$bigimage\" border=\"0\" alt=\"\" />";
        }
    }
    else
    {
        $imgdisp = "<img width=\"100\" height=\"75\" src=\"{$Globals['idir']}/ipending.gif\" border=\"0\" alt=\"{$Globals['pp_lang']['awaiting']}\">";
    }

    $navtext = ( !isset( $view ) ? $Globals['pp_lang']['send'] : $Globals['pp_lang']['view'] );

    // User wants a return receipt
    if ( ($returnr > 0 && $readdate == 0) && $User['userid'] != $returnr )
    {
        list( $getid, $usernm, $useremail ) = get_userinfo("", $returnr);
        $thiscard = "$photoid-$carddate";

        include "{$Globals['PP_PATH']}/languages/$pplang.php";

        $email_from = "From: {$Globals['adminemail']}";
        $rrletter = $Globals['pp_lang']['returnrec'];
        $rrsubject = $Globals['pp_lang']['returnsub'];
        $rrletter = stripslashes($rrletter);

        mail( $useremail, $rrsubject, $rrletter, $email_from );

        $julian = time();
        $retq = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}ecards SET readdate=$julian WHERE id=$cardid", $link);
    }

    topmenu();

    $cattype = $CatPerms['cattype'][$cat];
    childsub($cat, $cattype);

    $childnav = "<span class=\"{$Style['small']}\"><a href=\"{$Globals['maindir']}/index.php\">{$Globals['pp_lang']['home']}</a> $childnav</span>";

    printheader( $cat, $Globals['pp_lang']['ecard'] );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );

    if ( !isset($view) )
    {
        if ( isset($preview) )
        {
            if ( !isset($fromname) )
            {
                list( $fromid, $fromname, $fromemail ) = get_userinfo("", $User['userid']);
            }

            if ( $touser )
            {
                list( $toid, $greetuser, $toemail ) = get_userinfo($touser);
                if ( $greetuser == "" ) $greetuser = "$touser <b>({$Globals['pp_lang']['usernotfound']})</b>";
            }
            else
            {
                $greetuser = $rname;
            }

            if ( $layout == "toright" )
            {
                include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/ecard-right.tmpl" );
            }
            else
            {
                include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/ecard-bottom.tmpl" );
            }
        }

        include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/ecard.tmpl" );
    }
    else
    {
        list( $toid, $greetuser, $toemail ) = get_userinfo($toname);

        if ( !$greetuser )
        {
            $greetuser = $toname;
        }

        $message = convert_returns($message);

        if ( $layout == "toright" )
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/ecard-right.tmpl" );
        }
        else
        {
            include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/ecard-bottom.tmpl" );
        }
    }

    printfooter();
    exit;
}

if ( $send == "yes" )
{
    // send the e-card, store the data in the db, forward the user ###

    $rname   = preg_replace( "/<(?:[^>'\"]*|(['\"]).*?\1)*>/e", "", $rname);
    $remail  = preg_replace( "/<(?:[^>'\"]*|(['\"]).*?\1)*>/e", "", $remail);
    $subject = preg_replace( "/<(?:[^>'\"]*|(['\"]).*?\1)*>/e", "", $subject);
    $message = preg_replace( "/<(?:[^>'\"]*|(['\"]).*?\1)*>/e", "", $message);

    $julian = time();

    if ( !$remail )
    {
        if ( !$touser )
        {
            $error .= "<li>{$Globals['pp_lang']['noemail']}";
        }
    }

    if ( !$message )
    {
        $error .= "<li>{$Globals['pp_lang']['blank']}";
    }

    if ( isset($fromname) )
    {
        $fromemail = preg_replace( "/<(?:[^>'\"]*|(['\"]).*?\1)*>/e", "", $fromemail);
        $fromname  = preg_replace( "/<(?:[^>'\"]*|(['\"]).*?\1)*>/e", "", $fromname);

        $yemail = $fromemail;
        $yname = $fromname;
    }
    else
    {
        list( $yid, $yname, $yemail ) = get_userinfo("", $User['userid']);
    }

    if ( $error )
    {
        diewell( $error );
    }

    if ( $touser )
    {
        if ( $rname )
        {
            $rname = $touser;
        }

        list( $toid, $towhom, $remail ) = get_userinfo($touser);

        if ( empty($remail) )
        {
            diewell( $Globals['pp_lang']['badname'] );
        }
    }

    $return = ( isset($return) ? $User['userid'] : 0 );
    $resulta = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}ecards (id,fromname,toname,subject,message,photoid,date,backcolor,bordcolor,fontcolor,pickfont,layout,returnr) VALUES(NULL,'$yname','$rname','$subject','$message',$photoid,$julian,'$backcolor','$bordcolor','$fontcolor','$pickfont','$layout', '$return')", $link);
    $cardid = "$photoid-$julian";

    if ( !$rname )
    {
        $rname = $Globals['pp_lang']['hello'];
    }

    if ( !$yemail )
    {
        $yemail = $Globals['adminemail'];
    }

    include("{$Globals['PP_PATH']}/languages/$pplang.php");

    $letter = $Globals['pp_lang']['ecardsent'];
    $subject = $Globals['pp_lang']['ecardsub'];
    $from_email = "From: $yemail";

    mail( $remail, $subject, $letter, $from_email );

    forward("showphoto.php?photo=$photoid", $Globals['pp_lang']['cardsent']);
}

?>
