<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "comments" );
require "pp-inc.php";

typecast($_REQUEST, array('notify' => STRING, 'photo' => INT, 'cedit' => INT, 'notifyid' => INT));

if ( VB3_ENHANCEDINT == "on" && VB3_COMMWYSIWYG == "on" && isset($_POST['photo']) )
{
    typecast($_POST, array('rating' => INT, 'comid' => INT, 'delete' => STRING, 'post' => STRING, 'cap' => STRING, 'rpass' => STRING));

    unset($message);

    if ( VB35 == "on" )
    {
       	$vbulletin->input->clean_array_gpc('p', array('wysiwyg' => TYPE_BOOL, 'message' => TYPE_STR));

    	if ($vbulletin->GPC['wysiwyg'])
    	{
    		require_once(DIR . '/includes/functions_wysiwyg.php');
    		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
    	}
    	else
    	{
    		$message = &$vbulletin->GPC['message'];
    	}
    }
    elseif ( isset($_POST['WYSIWYG_HTML']) )
    {
        require_once('./includes/functions_wysiwyg.php');
        $message = trim(convert_wysiwyg_html_to_bbcode($_POST['WYSIWYG_HTML'], 0));
    }
    else
    {
        $message = $_POST['message'];
    }

    $message = addslashes(htmlspecialchars(trim($message)));
}
else
{
    typecast($_POST, array('message' => STRING, 'rating' => INT, 'comid' => INT, 'delete' => STRING, 'post' => STRING, 'cap' => STRING, 'rpass' => STRING));
}

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( empty($photo) )
{
    diewell( $Globals['pp_lang']['invalid'] );
}

$resulta = ppmysql_query("SELECT cat,userid,title,bigimage,approved,storecat,storeid,allowrate,allowcoms FROM {$Globals['pp_db_prefix']}photos WHERE id=$photo", $link);
list( $thiscat, $theuser, $gettitle, $bigimage, $approved, $storecat, $storeid, $allowrate, $allowcoms ) = mysql_fetch_row($resulta);
ppmysql_free_result($resulta);

if ( empty($thiscat) )
{
    diewell( $Globals['pp_lang']['nophotos'] );
}

if ( !empty($message) && ($Globals['allowpost'] == "no" || ($CatPerms['ugpost'][$thiscat] == 1 || $allowcoms != 1)) )
{
    diewell($Globals['pp_lang']['nocom']);
}

if ( $storecat == 0 )
{
    $storecat = $thiscat;
}

$ismod = ( $User['adminedit'] == 1 ? true : false );

if ( $User['moderator'] == 1 )
{
    $ismod = is_moderator($thiscat);
}

$ctitleq = ppmysql_query("SELECT id,catname,thumbs,cattype,parent,password,theme,ratingtype,ugnopost,ugnovote FROM {$Globals['pp_db_prefix']}categories WHERE id=$thiscat", $link);
list( $catid, $thecatname, $catthumbs, $cattype, $catparent, $thiscatpass, $cattheme, $ratingtype, $ugnopost, $ugnovote ) = mysql_fetch_row($ctitleq);

// We need these permissions here
$CatPerms['ugpost'][$thiscat] = $CatPerms['ugvote'][$thiscat] = 1;

foreach( $User['usergroups'] AS $usergroup )
{
    $allnopost = explode( ",", $ugnopost );
    if ( !in_array( $usergroup, $allnopost ) )
    {
        $CatPerms['ugpost'][$thiscat] = 0;
    }

    $allnovote = explode( ",", $ugnopost );
    if ( !in_array( $usergroup, $allnovote ) )
    {
        $CatPerms['ugvote'][$thiscat] = 0;
    }
}

if ( $cattheme && $Globals['forumstyle'] == "no" )
{
    $Globals['theme'] = $cattheme;

    if ( is_dir( "{$Globals['PP_PATH']}/stylesheets/{$Globals['theme']}" ) )
    {
        $Globals['idir'] = "{$Globals['maindir']}/stylesheets/{$Globals['theme']}";
    }
}

if ( ($CatPerms['ugpost'][$thiscat] == 1 && $CatPerms['ugvote'][$thiscat] == 1) || $User['comments'] == 0 )
{
     diewell( $Globals['pp_lang']['nopostedit'] );
}

$julian = time();

if ( !isset($_POST['post']) )
{
    $erating = $ecomments = null;

    if ( $cedit > 0 )
    {
        $resulta = ppmysql_query("SELECT cat,date,userid,username,rating,comment FROM {$Globals['pp_db_prefix']}comments WHERE id=$cedit LIMIT 1", $link);
        list( $comcat, $comdate, $cuserid, $cusername, $erating, $ecomments ) = mysql_fetch_row($resulta);

        if ( $Globals['comtimeout'] > 0 && !$ismod )
        {
            $timediff = $julian - $comdate;

            if ( $timediff > $Globals['comtimeout'] )
            {
                diewell( $Globals['pp_lang']['comexpire'] );
                exit;
            }
        }

        if ( VB3_ENHANCEDINT == "on" )
        {
            $ecomments = un_htmlspecialchars($ecomments);
        }

        $ecomments = str_replace( "\"", "&quot;", $ecomments);

        if ( ($User['userid'] != $cuserid || $User['userid'] < 1) && ($User['adminedit'] != 1 && !$ismod) )
        {
            diewell( $Globals['pp_lang']['noedit'] );
        }
    }
    else
    {
        $cusername = $User['username'];
    }

    topmenu();

    printheader( $thiscat, $Globals['pp_lang']['addcomment'] );

    if ( ($Globals['allowrate'] == "yes" && $ratingtype == 0 && $CatPerms['ugvote'][$thiscat] == 0) && $User['userid'] != $theuser && $allowrate == 1 )
    {
        // Did they already rate?
        $resultb = ppmysql_query("SELECT id, rating FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo AND userid='{$User['userid']}' AND rating > 0", $link);

        $alreadyrated = 0;
        while( list( $rateid, $checkrating ) = mysql_fetch_row($resultb) )
        {
            if ( $rateid != $cedit )
            {
                $alreadyrated = 1;
                $ratedisplay = "<span class=\"{$Style['small']}\">{$Globals['pp_lang']['rated']} $checkrating</span>";
                break;
            }
        }

        if ( $alreadyrated == 0 )
        {
            $rate_code = get_rate_code(0, $erating);
        }
    }

    $imgtag = get_imagethumb( $bigimage, $storecat, $theuser, $approved );

    if ( VB3_ENHANCEDINT == "on" && VB35 == "on" )
    {
    	if ( VB3_COMMWYSIWYG == "on" )
    	{
    	    $show['wysiwyg'] = is_wysiwyg_compatible();
    	}
    	else
    	{
    	    $show['wysiwyg'] = 0;
    	}

        if ( VB40 == "off" )
        {
	        $istyles_js = construct_editor_styles_js();
        }
    	$showsig = 1;
		$qrpostid = 'whocares';

    	$editorid = construct_edit_toolbar($ecomments, 0, 0, 1, 1, false);

        $messagearea = str_replace( "\"client", "\"". $vbulletin->options['bburl'] ."/client", $messagearea );
        $messagearea = str_replace( "\"images", "\"". $vbulletin->options['bburl'] ."/images", $messagearea );
        $messagearea = str_replace( "'images", "'". $vbulletin->options['bburl'] ."/images", $messagearea );
        $messagearea = str_replace( "&quot;images", "&quot;". $vbulletin->options['bburl'] ."/images", $messagearea );

    	$messagearea = "
    		<script type=\"text/javascript\">
    		<!--
    			var threaded_mode = 0;
    			var require_click = 0;
    			var is_last_page = 1;
    			var ajax_last_post = 0;
    		// -->
    		</script>
    		$messagearea
    	";
    }
    else
    {
        $messagearea = str_replace( "{ppcode}", $ecomments, $messagearea );
    }

    $newid = 0;
    if ( $User['userid'] < 1 )
    {
        if ( $Globals['usecaptcha'] == "yes" )
        {
            // Let's generate a totally random string using md5
            $md5 = md5(rand(0,999));

            // We don't need a 32 character long string so we trim it down to 5
            $pass = substr($md5, 10, 5);

            $r = ppmysql_query( "INSERT INTO {$Globals['pp_db_prefix']}captcha (id,code) VALUES (NULL,'$pass')", $link );
            $newid = mysql_insert_id($link);

            if ( !$newid )
            {
                diewell( $Globals['pp_lang']['caperror'] );
            }
        }
    }

    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/comments.tmpl" );

    printfooter();

    exit;
}
else
{
    // Process posting
    // First thing we do is make sure they can vote and its a valid vote
    if ( $CatPerms['ugvote'][$thiscat] == 1 || $rating > 10 || $rating < 1 )
    {
        $rating = 0;
    }

    // Next we make sure they can post and its a valid post
    if ( !isset($message) || $User['comments'] == 0 )
    {
        $message = null;
    }

    if ( !isset($delete) )
    {
        $delete = "no";
    }

    // Check CAPTCHA if we have it (only for comments, allow unreg voted if unreg allowed to vote)
    if ( $Globals['usecaptcha'] == "yes" && $User['userid'] < 1 && strlen($message) > 0 )
    {
        // Verify captcha for unregistered users
        if ( $cap > 0 )
        {
            $q = ppmysql_query( "SELECT code FROM {$Globals['pp_db_prefix']}captcha WHERE id=$cap LIMIT 1", $link );
            list( $pass ) = mysql_fetch_row($q);

            if ( strtolower($rpass) != $pass )
            {
                diewell( $Globals['pp_lang']['keyinvalid'] );
            }
        }
        else
        {
            diewell( $Globals['pp_lang']['noverif'] );
        }
    }

    // Assuming all the above fail (or they dont fill anything in), we bail
    if ( (!$message && $rating == 0) && $delete == "no" )
    {
        diewell( $Globals['pp_lang']['nofill'] );
    }

    // Okay, we got something, lets process it.
    if ( $post == "new" )
    {
        $noinsert = 0;

        if ( $User['userid'] > 0 )
        {
            $resultb = ppmysql_query("SELECT comment,rating FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo AND userid='{$User['userid']}'", $link);
            while( list( $checkdup, $checkrating ) = mysql_fetch_row($resultb) )
            {
                if ( $checkdup == $message )
                {
                    $noinsert = 1;
                }

                if ( $checkrating > 0 && $rating > 0 )
                {
                    $noinsert = 2;
                }
            }
        }

        if ( $noinsert != 0 )
        {
            if ( $noinsert == 1 )
            {
                diewell( $Globals['pp_lang']['dupe'] );
            }
            else
            {
                diewell( $Globals['pp_lang']['duperating'] );
            }
        }

        if ( $Globals['ipcache'] > 0 && $User['userid'] == 0 )
        {
            $ipaddress = findenv("REMOTE_ADDR");
            $result = ppmysql_query("SELECT userid,date,photo FROM {$Globals['pp_db_prefix']}ipcache WHERE ipaddr='$ipaddress' AND type='vote' AND photo=$photo LIMIT 1", $link);
            $numfound = mysql_num_rows($result);

            if ( $numfound > 0 )
            {
                list( $userid, $lastdate, $photo ) = mysql_fetch_row($result);
                $timeout = $julian - ($Globals['ipcache'] * 3600);

                if ( $lastdate < $timeout )
                {
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}ipcache WHERE date < $timeout", $link);
                }
                else
                {
                    if ( $rating != 0 )
                    {
                        diewell( $Globals['pp_lang']['every1'] );
                    }
                }
            }
            else
            {
                ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}ipcache (userid,ipaddr,date,type,photo) VALUES ('{$User['userid']}', '$ipaddress', '$julian', 'vote', $photo)", $link);
            }
        }

        include "{$Globals['PP_PATH']}/languages/$pplang.php";

        if ( $Globals['usenotify'] == "yes" && $theuser != $User['userid'] && $message )
        {
            $resultc = ppmysql_query("SELECT id,userid FROM {$Globals['pp_db_prefix']}notify WHERE photo=$photo", $link);

            if ( $resultc )
            {
                while( list( $getuserid, $notify_user ) = mysql_fetch_row($resultc) )
                {
                    list( $getid, $usernm, $useremail ) = get_userinfo("", $notify_user);
                    include "{$Globals['PP_PATH']}/languages/$pplang.php";

                    $email_from = "From: {$Globals['adminemail']}";
                    $letter = $Globals['pp_lang']['emailreply'];
                    $subject = $Globals['pp_lang']['ereplysub'];

                    $letter = stripslashes($letter);

                    mail( $useremail, $subject, $letter, $email_from );
                }
            }
        }

        if ( $Globals['notifyadmin'] == "yes" && $message )
        {
            $email_from = "From: {$Globals['adminemail']}";
            $useremail = $Globals['adminemail'];

            $letter = $Globals['pp_lang']['eadmreply'];
            $subject = $Globals['pp_lang']['eadmrsub'];
            $letter = stripslashes($letter);

            mail( $useremail, $subject, $letter, $email_from );
        }

        $username = addslashes( $User['username'] );

        if ( $User['usemod'] == 0 )
        {
            $moderate = 1;
        }
        else
        {
            $moderate = 0;
        }

        $ipaddr = findenv("REMOTE_ADDR");
        $resulta = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}comments (id,username,userid,date,rating,comment,photo,cat,approved,ipaddress) values(NULL,'$username','{$User['userid']}',$julian,$rating,'$message',$photo,$thiscat,'$moderate','$ipaddr')", $link);
        $lastpostid = mysql_insert_id( $link );

        // We only increment post counts if we are tracking them and we view ratings only
        if ( $Globals['cpostcount'] == "yes" )
        {
            if ( ($Globals['dispempty'] == "no" && $message) || $Globals['dispempty'] == "yes" )
            {
                inc_user_posts();
            }
        }

        if ( $Globals['dispempty'] == "yes" || ($Globals['dispempty'] == "no" && $message) )
        {
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET posts=(posts+1),lastpost='$lastpostid' WHERE id=$thiscat", $link);
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET lastpost=$julian,numcom=(numcom+1),lastposter='$username',lastpid='$lastpostid' WHERE id=$photo", $link);
            upgradecategories($thiscat);
        }

        // Send a message
        if ( !$message && $rating )
        {
            // Just a rating
            $msgtext = get_string( "ratemsg", "<a href=\"". construct_newppurl( "member.php", array('uid' => $User['userid'], 'username' => $User['username']) ) ."\">{$User['username']}</a>", "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$photo\">$gettitle</a>", $rating );
            send_ppmsg( $theuser, $msgtext, $photo, 'c' );
        }
        elseif ( $message )
        {
            // Added a comment
            $msgtext = get_string( "commentmsg", "<a href=\"". construct_newppurl( "member.php", array('uid' => $User['userid'], 'username' => $User['username']) ) ."\">{$User['username']}</a>", "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$photo\">$gettitle</a>" );
            send_ppmsg( $theuser, $msgtext, $photo, 'c' );
        }
    }
    else
    {
        if ( $delete == "yes" )
        {
            if ( !is_numeric($comid) )
            {
                diewell( $Globals['pp_lang']['malformed'] );
            }

            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE id=$comid", $link);

            if ( $Globals['cpostcount'] == "yes" && $message )
            {
                inc_user_posts( "minus" );
            }

            adminlog( "Comment Deleted: $comid ($message)" );

            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET posts=posts-1 WHERE id=$thiscat", $link);

            // Get the last comment data
            if ( $Globals['dispempty'] == "yes" )
            {
                $querya = "SELECT id,username,date FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo ORDER BY date DESC";
            }
            else
            {
                $querya = "SELECT id,username,date FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo AND LENGTH(comment) > 0 ORDER BY date DESC";
            }

            $queryz = ppmysql_query($querya, $link);
            list( $lastid, $lastposter, $lastdate ) = mysql_fetch_row($queryz);
            $comcount = mysql_num_rows($queryz);

            if ( $comcount > 0 )
            {
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET numcom=$comcount, lastposter='".addslashes($lastposter)."', lastpost='$lastdate', lastpid='$lastid' WHERE id=$photo", $link);
            }
            else
            {
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET numcom=0, lastposter='', lastpost=0, lastpid=0 WHERE id=$photo", $link);
            }

            upgradecategories($thiscat);
        }
        else
        {
            $resulta = ppmysql_query("SELECT cat,date FROM {$Globals['pp_db_prefix']}comments WHERE id=$comid LIMIT 1", $link);
            list( $comcat, $comdate ) = mysql_fetch_row($resulta);

            if ( $Globals['comtimeout'] > 0 && !$ismod )
            {
                $timediff = $julian - $comdate;

                if ( $timediff > $Globals['comtimeout'] )
                {
                    diewell( $Globals['pp_lang']['comexpire'] );
                    exit;
                }
            }

            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}comments SET rating=$rating, comment='$message' WHERE id=$comid", $link);
        }
    }

    if ( $ratingtype == 0 )
    {
        // recalc the rating
        calc_rating( $photo );
    }

    // Let's update the category cache
    update_catcache();

    forward( "showphoto.php?photo=$photo", $Globals['pp_lang']['posteditsuccess'] );
}

?>