<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////


include "pp-inc.php";

function create_image( $recid )
{
    global $Globals, $link;

    $q = ppmysql_query( "SELECT code FROM {$Globals['pp_db_prefix']}captcha WHERE id=$recid LIMIT 1", $link );
    list( $pass ) = mysql_fetch_row($q);

    if ( !$pass )
    {
        exit;
    }

    //Set the image width and height
    $width = 150;
    $height = 35;

    //Create the image resource
    $image = ImageCreate($width, $height);

    //We are making three colors, white, black and gray
    $white = ImageColorAllocate($image, 255, 255, 255);
    $black = ImageColorAllocate($image, 0, 0, 0);
    $grey = ImageColorAllocate($image, 204, 204, 204);

	// Pick a random color
	$r = mt_rand(50, 200);
	$b = mt_rand(50, 200);
	$g = mt_rand(50, 200);
    $fillcolor = ImageColorAllocate($image, $r, $g, $b);

	// Pick a Shape
	$x1 = mt_rand(0, $width);
	$y1 = mt_rand(0, $height);
	$x2 = mt_rand(0, $width);
	$y2 = mt_rand(0, $height);
	$start = mt_rand(0, 360);
	$end = mt_rand(0, 360);

    //if ( mt_rand(0,100) < 50 )
    //    $red = ImageColorAllocate($image, 204, 0, 0);
    //else
    //    $red = ImageColorAllocate($image, 0, 0, 204);

    //Make the background black
    ImageFill($image, 0, 0, $fillcolor);

	imageantialias($image, true);
	// Stroke Width, 2 or 3
	imagesetthickness($image, mt_rand(2, 3));
	// Pick a random color
	$shapecolor = imagecolorallocate($image, mt_rand(50, 200), mt_rand(50, 200), mt_rand(50, 200));

	switch(mt_rand(1, 4))
	{
		case 1:
			imagearc($image, $x1, $y1, $x2, $y2, $start, $end, $shapecolor);
			break;
		case 2:
			imageellipse($image, $x1, $y1, $x2, $y2, $shapecolor);
			break;
		case 3:
			imageline($image, $x1, $y1, $x2, $y2, $shapecolor);
			break;
		case 4:
			imagepolygon($image, array(
				$x1, $y1,
				$x2, $y2,
				mt_rand(0, $width), mt_rand(0, $height),
				mt_rand(0, $width), mt_rand(0, $height),
				),
				4, $shapecolor
			);
			break;
	}

	$x = mt_rand(15, 100);
	$y = mt_rand(15, 25);
	$pointsize =  mt_rand(11, 13);
    $textangle = 0;
	$slant = mt_rand(-5, 5);

    //Add randomly generated string in white to the image
    //ImageString($image, 6, $y, 6, $pass, $white);
    imagettftext($image, $pointsize, $slant, $x, $y, $white, "{$Globals['PP_PATH']}/images/serifab.ttf", $pass);

    //Throw in some lines to make it a little bit harder for any bots to break
    ImageRectangle($image,0,0,$width-1,$height-1,$black);
    //imageline($image, 0, $height/2, $width, $height/2, $grey);
    //imageline($image, $width/2, 0, $width/2, $height, $grey);

    //Tell the browser what kind of file is come in
    header("Content-Type: image/jpeg");

    //Output the newly created image in jpeg format
    ImageJpeg($image);

    //Free up resources
    ImageDestroy($image);
}

$recid = $_GET['c'];

if ( !$recid )
{
    exit;
}

create_image( $recid );

?>