<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

ini_set("max_execution_time", 0);

define( 'THIS_SCRIPT', "bulkupload" );
require "pp-inc.php";
require "{$Globals['PP_PATH']}/image-inc.php";

typecast_wc('add', STRING);
typecast_wc('cat', STRING);
typecast_wc('title', STRING);
typecast_wc('desc', STRING);
typecast_wc('key', STRING);
typecast_wc('imgname', STRING);
typecast_wc('extra1-', STRING);
typecast_wc('extra2-', STRING);
typecast_wc('extra3-', STRING);
typecast_wc('extra4-', STRING);
typecast_wc('extra5-', STRING);
typecast_wc('extra6-', STRING);
typecast_wc('catwo', STRING);
typecast_wc('cathree', STRING);

typecast($_REQUEST, array('numprocess' => INT, 'deftitle' => STRING, 'defdesc' => STRING, 'defcat' => INT,
                          'updir' => STRING, 'donotdelete' => STRING, 'dthumbs' => STRING, 'ppaction' => STRING,
                          'upuser' => STRING, 'notify' => STRING, 'defkeywords' => STRING, 'processall' => STRING,
                          'skipwater' => STRING, 'do' => STRING, 'photopath' => STRING, 'thecount' => INT,
                          'rating' => STRING, 'comments' => STRING, 'mature' => STRING));

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

$adminexclude = 0;
if ( $Globals['adminexclude'] == "yes" && $User['adminedit'] == 1 )
{
    $adminexclude = 1;
}

if ( $User['adminedit'] == 0 )
{
    if ( $Globals['allowup'] == "no" )
    {
        diewell( $Globals['pp_lang']['noupload'] );
    }
}

$qenv = findenv( "QUERY_STRING" );
if ( ( $User['uploads'] == 0 && $gologin == 1 ) || $querystring == "gologin" )
{
    login( "{$Globals['maindir']}/uploadphoto.php" );
    exit;
}

if ( $gologin == 1 )
{
    if ( $User['uploads'] == 0 )
    {
        diewell($Globals['pp_lang']['noupload']);
    }

    if ( $User['uploads'] == 2 )
    {
        diewell($Globals['pp_lang']['noverify']);
    }
}

// Setup some defaults
if ( !isset($updir) )
{
    $updir  = null;
}

if ( !isset($donotdelete) )
{
    $donotdelete = null;
}

if ( $User['adminedit'] == 0 || !$dthumbs )
{
    $dthumbs = "yes";
}

if ( !$defcat )
{
    $defcat = 500;
}

if ( $numprocess < 10 )
{
    $numprocess = 10;
}

// Klude, we have to process all files at once when doing donotdelete otherwise we'd process the same files over and over
if ( $donotdelete == "donotdelete" )
{
    $numprocess = 10000;
}

topmenu();

$inpath = "{$Globals['zipuploaddir']}/{$User['userid']}";

if ( $User['adminedit'] == 1 )
{
    $upuserid = $User['userid'];

    if ( isset($upuser) && !empty($upuser) )
    {
        list( $upuserid, $tusername, $tmail ) = get_userinfo($upuser);
        if ( empty($upuserid) )
        {
            diewell( "$upuser: Unable to find this user. Please check spelling." );
        }
    }

    if ( !empty($updir) )
    {
        $inpath = $updir;

        if ( !is_dir($updir) )
        {
            diewell( "Cannot find the directory: $updir" );
        }
    }

    check_user_dir( $upuserid );
}
else
{
    $upuserid = $User['userid'];
}

$openpath = $inpath;

$resulta = ppmysql_query("SELECT SUM(filesize) AS fsize FROM {$Globals['pp_db_prefix']}photos WHERE userid=$upuserid AND storecat=0", $link);
list( $diskuse ) = mysql_fetch_row($resulta);

// $disk_k is set in forum file and is their max upload specs
$disk_k = ($disk_k * 1024);
$up_k = ($up_k * 1024);
$overlimit=0;
$overfiles = null;

//
// skip previews entirely and just process all the images
//

if ( $ppaction == "addphotos" && $processall == "processall" )
{
    $photocount = 0;

    if ( $handle = opendir($openpath) )
    {
        $dirnames = array();
        while ( $realname = readdir($handle) )
        {
            $dirnames[] = $realname;
        }
        closedir($handle);

        sort($dirnames);

        foreach ( $dirnames AS $realname )
        {
            $filein = "{$inpath}/$realname";

            if ( $realname != "." && $realname != ".." && is_file($filein) )
            {
                $title = un_htmlspecialchars($deftitle);
                $desc = un_htmlspecialchars($defdesc);
                $keywords = $defkeywords;

                $chkrealname  = fixfilenames($realname);

                if ( strcmp($chkrealname, $realname) != 0 )
                {
                    $newfile = "{$inpath}/$chkrealname";
                    @rename($filein, $newfile);
                    $realname = $chkrealname;
                    $filein = $newfile;
                }

                $theext = get_ext($realname);
                $catq = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE bigimage='$realname'", $link);
                $imgchk = mysql_num_rows($catq);

                if ( $imgchk != 0 )
                {
                    // Image is a duplicate
                    $filenoext = get_filename( $realname );
                    $theext = get_ext( $realname );

                    $x = 0;
                    while ( $imgchk != 0 )
                    {
                        $x++;
                        $newfile = "$filenoext$x$theext";
                        $newfilepath = "{$inpath}/$newfile";

                        $catq = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE bigimage='$newfile'", $link);
                        $imgchk = mysql_num_rows($catq);

                        if ( $imgchk == 0 )
                        {
                            @rename($filein, $newfilepath);
                            $realname = $newfile;
                            $filein = $newfilepath;
                        }
                    }
                }

                $filepath = "{$Globals['origfull']}$defcat/$realname";
                copy( $filein, $filepath );
                @chmod ($filepath, 0666);

                if ( $photocount > 0 )
                {
                    echo "<br />Processing $realname... ";
                }
                @flush();

                if ( is_multimedia( $filepath ) )
                {
                    process_image( $realname, $filepath, $defcat, 1 );
                }
                elseif ( is_image( $filepath ) )
                {
                    // Open image, write out thumb, fullsize, and medium as needed
                    create_thumb( $realname, $filepath, $defcat );
                    process_image( $realname, $filepath, $defcat );
                }
                else
                {
                    echo "ERROR! unknown file type $filepath<br />";
                    unlink( $filepath );
                }

                // Delete thumb and image from temp dir
                if ( file_exists( $filein ) )
                {
                    @unlink ($filein);
                }

                $photocount++;

                if ( $photocount == $numprocess )
                {
                    $upuser = urlencode(stripslashes(un_htmlspecialchars($upuser)));
                    $deftitle = urlencode(stripslashes(un_htmlspecialchars($deftitle)));
                    $defdesc = urlencode(stripslashes(un_htmlspecialchars($defdesc)));
                    $updir = urlencode(stripslashes(un_htmlspecialchars($updir)));
                    $defkeywords = urlencode(stripslashes(un_htmlspecialchars($keywords)));

                    $fwdlink = "bulkupload.php?ppaction=addphotos&do=preview&upuser=$upuser&notify=$notify&rating=$rating&comments=$comments&deftitle=$deftitle&defdesc=$defdesc&defcat=$defcat&defkeywords=$defkeywords&numprocess=$numprocess&processall=$processall&dthumbs=$dthumbs";

                    echo "<br />{$Globals['pp_lang']['preppro']} $numprocess {$Globals['pp_lang']['images']}; <a href=\"{$Globals['maindir']}/$fwdlink\">{$Globals['pp_lang']['click']}</a> {$Globals['pp_lang']['notrefresh']}";
                    echo "<script language=\"javascript\">window.location=\"$fwdlink\";</script>";
                    exit;
                }
            }
        }
    }

    if ( $defcat == 500 )
    {
        // Force refresh of cache
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

        forward( "showgallery.php?cat=500&ppuser={$User['userid']}", $Globals['pp_lang']['processing'] );
    }
    else
    {
        // Force refresh of cache
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

        forward( "showgallery.php?cat=$defcat", $Globals['pp_lang']['processing'] );
    }
}

if ( $ppaction == "addphotos" )
{
    if ( $do == "process" )
    {
        $totalphotos = $thecount;

        if ( isset($skipwater) ) {
            $Globals['annotate'] = "no";
        }

        for ( $i = 1; $i <= $totalphotos; $i++ )
        {
            $addk = "add$i";
            $catkey = "cat$i";
            $titlekey = "title$i";
            $desckey = "desc$i";
            $keykey = "key$i";
            $imgkey = "imgname$i";
            $ex1key = "extra1-$i";
            $ex2key = "extra2-$i";
            $ex3key = "extra3-$i";
            $ex4key = "extra4-$i";
            $ex5key = "extra5-$i";
            $ex6key = "extra6-$i";
            $opt1key = "catwo$i";
            $opt2key = "cathree$i";

            $imgname = ${$imgkey};
            $category = ${$catkey};
            $title = ${$titlekey};
            $desc = ${$desckey};
            $keywords = ${$keykey};
            $addkey = ${$addk};
            $extra1 = ${$ex1key};
            $extra2 = ${$ex2key};
            $extra3 = ${$ex3key};
            $extra4 = ${$ex4key};
            $extra5 = ${$ex5key};
            $extra6 = ${$ex6key};
            $optone = ${$opt1key};
            $opttwo = ${$opt2key};

            $filein = "$inpath/$imgname";

            // Skip files being uploaded to a bad category
            if ( $category == "notcat" )
            {
                continue;
            }

            if ( $addkey == 1 )
            {
                $imgname = fixfilenames($imgname);
                $filepath = "{$Globals['origfull']}$category/$imgname";
                @copy( $filein, $filepath );
                @chmod ($filepath, 0666);

                if ( is_multimedia($imgname) )
                {
                    $realname  = null;
                    $theimage[$i] = $_FILES['theimage']['name'][$i];

                    if ( $theimage[$i] != "" )
                    {
                        $dst_file = handleupload( "data", $i );
                        create_thumb( $realname, $dst_file, $category, $imgname );
                        unlink( $dst_file );
                    }

                    $photoid = process_image( $imgname, $filepath, $category, 1 );
                }
                elseif ( is_image( $imgname ) )
                {
                    // Open image, write out thumb, fullsize, and medium as needed
                    create_thumb( $imgname, $filepath, $category );
                    $photoid = process_image( $imgname, $filepath, $category );
                }
                else
                {
                    @unlink( $filepath );
                }

                // Process all the custom variables for this image
                $thesevars = "custom-$i";
                $checkbx = array();
                $is_checkboxes = false;
                $exprocessed = array();

                foreach( $_POST as $id => $setting )
                {
                    if ( strstr($id, $thesevars) )
                    {
                        $iscustom = true;
                        $exeach = explode( "_", $id );
                        $setting = un_htmlspecialchars( $setting );

                        if ( count($exeach) == 3 )
                        {
                            // Unique to checkboxes which have three parameters and must be cached
                            $extid = $exeach[1];
                            $extck = $exeach[2];

                            $checkbx[$extid][] = $extck;
                            $is_checkboxes = true;
                        }
                        else
                        {
                            // Everyone else
                            $extid = $exeach[1];
                            ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoextras (id,photo,extraid,selection) VALUES(NULL,$photoid,$extid,'$setting')", $link);
                        }

                        $exprocessed[] = $extid;
                    }
                }

                // Checkboxes require a special formatting
                if ( $is_checkboxes )
                {
                    // Update checkboxes
                    foreach( $checkbx as $extid=>$setting )
                    {
                        $flatbox = implode( ",", $setting );

                        if ( !empty( $flatbox ) )
                        {
                            ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}photoextras (id,photo,extraid,selection) VALUES(NULL,$photoid,$extid,'$flatbox')", $link);
                        }
                    }
                }

                // Now insert NULLS for any missing custom fields (need the placeholders)
                $exquery = "SELECT id,fieldname,fieldtype,fieldoptions FROM {$Globals['pp_db_prefix']}extrafields WHERE cat=$defcat";
                $catextras = ppmysql_query($exquery, $link);

                while ( list($exid, $exname, $extype, $exoptions) = mysql_fetch_row($catextras) )
                {
                    if ( !in_array( $exid, $exprocessed ) )
                    {
                        $exquery2 = "INSERT INTO {$Globals['pp_db_prefix']}photoextras (id,photo,extraid,selection) VALUES(NULL,$photoid,$exid,NULL)";
                        $resulta = ppmysql_query($exquery2, $link);
                    }
                }

                // Delete thumb and image from temp dir
                if ( file_exists( $filein ) && $donotdelete != "donotdelete" )
                {
                    @unlink ($filein);
                }
            }
            else
            {
                // Delete the image and thumb from temp dir
                if ( file_exists( $filein ) && $donotdelete != "donotdelete" )
                {
                    @unlink ($filein);
                }

                $tfile = "{$Globals['datafull']}$category/thumbs/$imgname";

                if ( file_exists( $tfile ) )
                {
                    @unlink ($tfile);
                }
            }
        }

        $maxq = ppmysql_query("SELECT maximages FROM {$Globals['pp_db_prefix']}categories WHERE id=$defcat", $link);
        list ( $maximages ) = mysql_fetch_row($maxq);

        if ( $maximages > 0 )
        {
            // This category has a limit on the number of photos, so we need to check if there are too many

            $resulta = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}photos WHERE cat=$defcat", $link);
            list( $numimages ) = mysql_fetch_row($resulta);

            if ( $numimages > $maximages )
            {
                // Yep, too many images, lets remove the excess
                $extras = $numimages - $maximages;
                $numimages++;

                $resultb = ppmysql_query("SELECT id,userid,bigimage,medsize FROM {$Globals['pp_db_prefix']}photos WHERE cat=$defcat ORDER BY date DESC LIMIT $maximages,$extras", $link);
                while ( list( $pid, $uid, $bigimage, $medsize ) = mysql_fetch_row($resultb) )
                {
                    remove_all_files( $bigimage, $medsize, $uid, $defcat );
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE photo=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$pid", $link);
                }

                upgradecategories($defcat);
            }
        }

        // Force refresh of cache
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

        $upuser = urlencode(stripslashes(un_htmlspecialchars($upuser)));
        $deftitle = urlencode(stripslashes(un_htmlspecialchars($deftitle)));
        $defdesc = urlencode(stripslashes(un_htmlspecialchars($defdesc)));
        $updir = urlencode(stripslashes(un_htmlspecialchars($updir)));
        $defkeywords = urlencode(stripslashes(un_htmlspecialchars($keywords)));

        forward( "bulkupload.php?ppaction=addphotos&do=preview&thecount=$totalphotos&upuser=$upuser&notify=$notify&rating=$rating&comments=$comments&defcat=$defcat&deftitle=$deftitle&defdesc=$defdesc&defkeywords=$defkeywords&numprocess=$numprocess&updir=$updir&dthumbs=$dthumbs", $Globals['pp_lang']['processing'] );
    }

    $uploadchk = 0;

    if ( $User['uploadlimit'] > 0 )
    {
        $upload = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}photos WHERE storecat=0 AND userid={$User['userid']} AND date > UNIX_TIMESTAMP( DATE_SUB(NOW(), INTERVAL 24 HOUR) )", $link);
        list( $uploadchk ) = mysql_fetch_row($upload);
    }

    if ( $do == "preview" )
    {
        // Get dir listing, thumbs, w/checkboxes
        if ( $numprocess == 10 )
        {
            $numopts = "<option value=\"10\" selected=\"selected\">10</option>";
        }
        else
        {
            $numopts = "<option value=\"10\">10</option>";
        }

        if ( $numprocess == 25 )
        {
            $numopts .= "<option value=\"25\" selected=\"selected\">25</option>";
        }
        else
        {
            $numopts .= "<option value=\"25\">25</option>";
        }

        if ( $numprocess == 50 )
        {
            $numopts .= "<option value=\"50\" selected=\"selected\">50</option>";
        }
        else
        {
            $numopts .= "<option value=\"50\">50</option>";
        }

        if ( $numprocess == 100 )
        {
            $numopts .= "<option value=\"100\" selected=\"selected\">100</option>";
        }
        else
        {
            $numopts .= "<option value=\"100\">100</option>";
        }

        $photocount = 1;
        $defcatname  = null;

        $catq = ppmysql_query("SELECT catname,extra1,extra2,extra3,extra4,extra5,extra6,numextra FROM {$Globals['pp_db_prefix']}categories WHERE id=$defcat", $link);
        list ( $defcatname, $Globals['extra1name'], $Globals['extra2name'], $Globals['extra3name'], $Globals['extra4name'], $Globals['extra5name'], $Globals['extra6name'], $numextra ) = mysql_fetch_row($catq);

        if ( $Globals['optcats'] == "yes" )
        {
            $selected = 0;
            catmoveopt(0);
            $catoptions2 = $catoptions;
            $catoptions  = null;
        }

        $selected = $defcat;
        catmoveopt(0);

        $title = stripslashes($deftitle);
        $desc = stripslashes($defdesc);
        $keywords = stripslashes($defkeywords);

        $extraprompts = array();
        $numcustom = 0;

        if ( $numextra > 0 )
        {
            $catextras = ppmysql_query("SELECT id,fieldname,fieldtype,fieldoptions FROM {$Globals['pp_db_prefix']}extrafields WHERE cat=$defcat", $link);
            $x = 0;

            while ( list($exid, $exname, $extype, $exoptions) = mysql_fetch_row($catextras) )
            {
                $extraprompts['name'][$x] = $exname;

                if ( $extype == "t" )
                {
                    $extraprompts['options'][$x] = "<input type=\"text\" name=\"custom-%%insertid%%_$exid\" value=\"$exoptions\" size=\"20\">";
                    $x++;
                }
                elseif ( $extype == "c" )
                {
                    $exprompt  = null;
                    $exarray = explode("||", $exoptions );

                    $y = 0;
                    foreach( $exarray as $exextra )
                    {
                        if ( $exextra )
                        {
                            $exprompt .= "<input type=\"checkbox\" name=\"custom-%%insertid%%_{$exid}_{$y}\" value=\"1\"> $exextra<br />";
                            $y++;
                        }
                    }

                    $extraprompts['options'][$x] = $exprompt;
                    $x++;
                }
                elseif ( $extype == "r" )
                {
                    $exprompt  = null;
                    $exarray = explode("||", $exoptions );

                    foreach( $exarray as $exextra )
                    {
                        if ( $exextra )
                        {
                            $exprompt .= "<input type=\"radio\" name=\"custom-%%insertid%%_$exid\" value=\"$exextra\"> $exextra<br />";
                        }
                    }

                    $extraprompts['options'][$x] = $exprompt;
                    $x++;
                }
                elseif ( $extype == "d" )
                {
                    $exprompt = "<select name=\"custom-%%insertid%%_$exid\">";
                    $exarray = explode("||", $exoptions );

                    foreach( $exarray as $exextra )
                    {
                        if ( $exextra )
                        {
                            $exprompt .= "<option value=\"$exextra\">$exextra</option>";
                        }
                    }
                    $exprompt .= "</select>";

                    $extraprompts['options'][$x] = $exprompt;
                    $x++;
                }
            }
            ppmysql_free_result( $catextras );

            $numcustom = $x;
        }

        if ( $handle = opendir( $inpath ) )
        {
            $dirnames = array();
            while ( $realname = readdir($handle) )
            {
                $dirnames[] = $realname;
            }
            closedir($handle);

            sort($dirnames);

            foreach ( $dirnames AS $realname )
            {
                if (( $realname != ".") && ( $realname != ".." ) )
                {
                    $filepath = "$inpath/$realname";
                    if ( !is_image($realname) && !is_multimedia($realname) )
                    {
                        @unlink( $filepath);
                        continue;
                    }

                    $chkrealname  = fixfilenames($realname);

                    if ( strcmp($chkrealname, $realname) != 0 )
                    {
                        $newfile = "{$inpath}/$chkrealname";
                        @rename($filepath, $newfile);
                        $realname = $chkrealname;
                        $filepath = $newfile;
                    }

                    $theext = get_ext($realname);
                    $filesize = filesize( $filepath );
                    $diskbytes = $disk_k - ($diskuse + $filesize);

                    if ( is_image($realname) )
                    {
                        $limit_check = $up_k;
                    }
                    else
                    {
                        $limit_check = ($Globals['mmuploadsize'] * 1024);
                    }

                    if ( $filesize > $limit_check && $limit_check != 0 )
                    {
                        $overlimit++;
                        if ( $overfiles )
                        {
                            $overfiles .= ", ";
                        }

                        $overfiles .= "$realname ({$Globals['pp_lang']['exfiles']})";
                        unlink( $filepath );
                    }
                    elseif ( $diskbytes < 0 && $disk_k != 0 )
                    {
                        $overlimit++;
                        if ( $overfiles )
                        {
                            $overfiles .= ", ";
                        }

                        $overfiles .= "$realname ({$Globals['pp_lang']['exspace']})";
                        unlink( $filepath );
                    }
                    else
                    {
                        if ( $User['uploadlimit'] > 0 )
                        {
                            if ( $uploadchk >= $User['uploadlimit'] )
                            {
                                $overlimit++;
                                if ( $overfiles ) {
                                    $overfiles .= ", ";
                                }

                                $overfiles .= "$realname ({$Globals['pp_lang']['dailyuplimit']})";
                                unlink( $filepath );
                                continue;
                            }
                            $uploadchk++;
                        }

                        $catq = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE bigimage='$realname'", $link);
                        $imgchk = mysql_num_rows($catq);

                        if ( $imgchk != 0 )
                        {
                            // Image is a duplicate
                            $filenoext = get_filename( $realname );
                            $theext = get_ext( $realname );

                            $x = 0;
                            while ( $imgchk != 0 )
                            {
                                $x++;
                                $newfile = "$filenoext$x$theext";
                                $newfilepath = "{$inpath}/$newfile";

                                $catq = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE bigimage='$newfile'", $link);
                                $imgchk = mysql_num_rows($catq);

                                if ( $imgchk == 0 )
                                {
                                    @rename($filepath, $newfilepath);
                                    $realname = $newfile;
                                    $filepath = $newfilepath;
                                }
                            }
                        }

                        $diskuse += $filesize;
                        $thumb[$photocount]  = null;
                        $size[$photocount] = $filesize;
                        $bulkname[$photocount] = $realname;

                        if ( is_image($realname) && $photocount <= $numprocess && $size[$photocount] > 0 )
                        {
                            create_thumb( $realname, $filepath, $defcat );
                            if ( $dthumbs == "yes" )
                            {
                                $thumb[$photocount] = "<a target=\"_blank\" href=\"{$Globals['zipuploadurl']}/{$User['userid']}/$realname\"><img border=\"0\" src=\"{$Globals['datadir']}/$defcat/thumbs/$realname\"></a><br />";
                            }

                            $photocount++;
                        }
                        elseif ( is_multimedia($realname) && $photocount <= $numprocess && $size[$photocount] > 0)
                        {
                            if ( $dthumbs == "yes" )
                            {
                                $thumb[$photocount] = "<a target=\"_blank\" href=\"{$Globals['zipuploadurl']}/{$User['userid']}/$realname\"><img border=\"0\" src=\"{$Globals['idir']}/video.gif\"></a><br />";
                            }

                            $photocount++;
                        }
                    }
                }
            }
        }
    }

    // There were errors...
    if ( !empty($overfiles) )
    {
        diewell($overfiles);
    }

    // Keep on rollin'
    if( isset($skipwater) )
    {
        $skipwater = "<input name=\"skipwater\" value=\"true\" type=\"hidden\">";
    }

    // we dont count the last one since its always empty
    $photocount--;

    include( "{$Globals['PP_PATH']}/languages/$pplang.php" );    // extra time to get variables filled in

    if ( $photocount < 1 )
    {
        if ( $defcat == 500 )
        {
            // Force refresh of cache
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

            forward( "showgallery.php?cat=500&ppuser={$User['userid']}", $Globals['pp_lang']['upsuccess'] );
        }
        else
        {
            // Force refresh of cache
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

            forward( "showgallery.php?cat=$defcat", $Globals['pp_lang']['upsuccess'] );
        }
    }

    if ( $defcat == 500 )
    {
        $retlink = construct_newppurl( "showgallery.php", array('ppuser' => $User['userid'], 'username' => $User['username'] ) );

    }
    else
    {
        $retlink = construct_newppurl( "showgallery.php", array('cat' => $defcat) );
    }

    // Cleanup for bulkupload form
    $title = un_htmlspecialchars(stripslashes($deftitle));
    $desc = un_htmlspecialchars(stripslashes($defdesc));
    $keywords = htmlspecialchars(stripslashes($defkeywords));

    // Force refresh of cache
    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

    printheader( 0, $Globals['pp_lang']['bulkuploads'] );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
    include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/bulkupload.tmpl" );
    printfooter();
}

?>