<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "member" );
require "pp-inc.php";

if ( $Globals['vbversion'] != "photopost" )
{
    header( "Location: {$Globals['maindir']}/index.php" );
    exit;
}

typecast($_REQUEST, array('msg' => INT, 'delete' => INT, 'edit' => INT));
typecast($_POST, array('post' => STRING, 'subject' => STRING, 'message' => STRING, 'inreplyto' => INT, 'msgid' => INT));

authenticate();

if ( $Globals['ppboards'] == "closed" && $User['adminedit'] != 1 )
{
    diewell( $Globals['closedmsg'] );
}

if ( $delete )
{
    list( $dm, $rto ) = ppmysql_query_onerow("SELECT userid,replyto FROM {$Globals['pp_db_prefix']}board WHERE msgid=$delete LIMIT 1", $link);

    if ( $dm && (($User['userid'] == $dm && $User['comments'] == 1) || $User['adminedit'] == 1) )
    {
        // Making sure this can be removed, delete any message and replies
        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}board WHERE msgid=$delete OR replyto=$delete", $link);
    }

    list( $newcount ) = ppmysql_query_onerow("SELECT count(*) FROM {$Globals['pp_db_prefix']}board WHERE replyto=$rto", $link);

    if ( $newcount )
    {
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}board SET replies=$newcount WHERE msgid=$rto", $link);
    }

    header( "Location: ". construct_newppurl( "board.php" ) );
    exit;
}

$julian = time();

if ( $edit )
{
    // They want to edit a message
    if ( !$User['userid'] )
    {
        // Not suppose to be here!
        diewell( $Globals['pp_lang']['notloggedin'] );
    }

    if ( $User['comments'] == 0 && $User['adminedit'] != 1 )
    {
        diewell( $Globals['pp_lang']['nopostedit'] );
    }

    if ( $msgid )
    {
        if ( !$message )
        {
            diewell( $Globals['pp_lang']['entermsg'] );
        }

        if ( !$subject )
        {
            $subject = strftime( "%B %d %I:%m%p", $julian );
        }

        // Post a reply
        ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}board SET subject='$subject',message='$message',updateuser={$User['userid']},updated=$julian WHERE msgid=$msgid LIMIT 1", $link );

        header( "Location: ". construct_newppurl( "board.php", array('msg' => $msgid, 'subject' => $subject) ) );
        exit;
    }

    $msgs = ppmysql_query_one("SELECT * FROM {$Globals['pp_db_prefix']}board WHERE msgid=$edit LIMIT 1", $link);

    if ( !$msgs['msgid'] )
    {
        diewell( "Unable to find message to edit." );
    }

    if ( $msgs['userid'] != $User['userid'] && $User['adminedit'] != 1 )
    {
        diewell( $Globals['pp_lang']['msgeperm'] );
    }

    $what = "editpost";
}

if ( $post == "new" || $post == "reply" )
{
    if ( !$User['userid'] )
    {
        // Not suppose to be here!
        diewell( $Globals['pp_lang']['notloggedin'] );
    }

    $ipaddr = findenv("REMOTE_ADDR");

    if ( $post == "new" )
    {
        if ( !$subject || !$message )
        {
            diewell( $Globals['pp_lang']['entersub'] );
        }

        // Post a new message
        ppmysql_query( "INSERT INTO {$Globals['pp_db_prefix']}board (msgid,date,lastdate,userid,subject,message,ipaddr)
                                 VALUES ( NULL, $julian, $julian, {$User['userid']}, '$subject', '$message', '$ipaddr')", $link );
        $newmsg = mysql_insert_id();

        // Notify any buddies
        $rb = ppmysql_query("SELECT userid FROM {$Globals['pp_db_prefix']}buddies WHERE buddy={$User['userid']}", $link);
        while ( list($nuserid) = mysql_fetch_row($rb) )
        {
            $msgtext = get_string( "postmsg", $User['username'], "<a href=\"". construct_newppurl( "board.php", array('msg' => $newmsg, 'subject' => $subject) ) ."\">$subject</a>" );
            send_ppmsg( $nuserid, $msgtext, $User['userid'], 'c' );
        }

        header( "Location: ". construct_newppurl( "board.php", array('msg' => $newmsg, 'subject' => $subject) ) );
        exit;
    }
    elseif ( $inreplyto )
    {
        if ( !$message )
        {
            diewell( $Globals['pp_lang']['entermsg'] );
        }

        if ( !$subject )
        {
            $subject = strftime( "%B %d %I:%m%p", $julian );
        }

        // Post a reply
        ppmysql_query( "INSERT INTO {$Globals['pp_db_prefix']}board (msgid,date,userid,subject,message,replyto,ipaddr)
                                 VALUES ( NULL, $julian, {$User['userid']}, '$subject', '$message', $inreplyto, '$ipaddr')", $link );
        $lastmsg = mysql_insert_id();

        $luser = addslashes($User['username']);

        ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}board SET replies=(replies+1), lastmsg=$lastmsg,
                                 lastdate=$julian, lastuser={$User['userid']}, lastusername='$luser'
                                 WHERE msgid=$inreplyto LIMIT 1", $link );

        // Notify any buddies
        $rb = ppmysql_query("SELECT userid FROM {$Globals['pp_db_prefix']}buddies WHERE buddy={$User['userid']}", $link);
        while ( list($nuserid) = mysql_fetch_row($rb) )
        {
            $msgtext = get_string( "postmsg", $User['username'], "<a href=\"". construct_newppurl( "board.php", array('msg' => $inreplyto, 'subject' => $subject) ) ."\">$subject</a>" );
            send_ppmsg( $nuserid, $msgtext, $User['userid'], 'c' );
        }

        inc_user_posts();

        header( "Location: ". construct_newppurl( "board.php", array('msg' => $inreplyto, 'subject' => $subject) ) );
        exit;
    }
}

$homelink = construct_newppurl( "board.php" );

if ( $msg )
{
    // They want to view a message, not the list

    $x = 0;
    $messages = array();

    $msgs = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}board WHERE msgid=$msg OR replyto=$msg ORDER BY date ASC", $link);
    while ( $mess = mysql_fetch_assoc($msgs) )
    {
        $messages[$x]['msgid'] = $mess['msgid'];
        $messages[$x]['date'] = strftime( "%B %d %I:%m%p", $mess['date']);
        $messages[$x]['userid'] = $mess['userid'];
        $messages[$x]['message'] = convert_returns(convert_markups($mess['message']));
        $messages[$x]['subject'] = $mess['subject'];
        $messages[$x]['replies'] = $mess['replies'];
        $messages[$x]['views'] = $mess['views'];
        $messages[$x]['ipaddr'] = $mess['ipaddr'];
        $messages[$x]['category'] = $mess['category'];
        $messages[$x]['lastmsg'] = $mess['lastmsg'];

        $profilelink = get_profilelink( $mess['userid'], $mess['username'] );

        // call get_profiledata to get all the links possible
        unset($cuname, $cuhomep, $cuposts, $cutitle, $cureg, $culoc, $cuavatar, $usig);
        list( $cuname, $cuhomep, $cuposts, $cutitle, $cureg, $culoc, $cuavatar, $usig ) = get_profiledata( $mess['userid'] );

        $messages[$x]['user'] = "<a href=\"". construct_newppurl( "member.php", array('uid' => $mess['userid'], 'username' => $cuname) ) ."\">$cuname</a>";

        if ( $cutitle )
        {
            $messages[$x]['user'] .= "<br />$cutitle<br />";
        }

        if ( $cuavatar && $Globals['showavatar'] == "yes" )
        {
            $messages[$x]['user'] .= "<br />$cuavatar";
        }

        if ( $usig && $Globals['showsigs'] == "yes" )
        {
            $usigline = convert_markups($usig);
            $messages[$x]['message'] .= "<br /><br />------------------------------<br />$usigline";
        }

        if ( $mess['updated'] )
        {
            list( , $who ) = get_userinfo( null, $mess['updateuser'] );
            $messages[$x]['message'] .= "<br /><br /><i>{$Globals['pp_lang']['editby']} $who {$Globals['pp_lang']['on']} ". strftime( "%B %d, %Y at %I:%m%p", $mess['updated']). "</i>";
        }

        $x++;
    }

    ppmysql_query( "UPDATE {$Globals['pp_db_prefix']}board SET views=(views+1) WHERE msgid=$msg LIMIT 1", $link );
    $what = "thread";
}
elseif ( !$what )
{
    $orecs = ppmysql_query("SELECT userid,uid FROM {$Globals['pp_db_prefix']}iponline WHERE what='board'", $link);
    $numrows = mysql_num_rows($orecs);

    if ( $numrows == 1 )
    {
        $Globals['pp_lang']['numviewers'] = $Globals['pp_lang']['noviewers'];
    }
    else
    {
        $Globals['pp_lang']['numviewers'] = get_string( 'numviewers', $numrows );
    }

    $onlineusers = null;
    $guests = 0;

    if ( $numrows > 1 )
    {
        while( $rows = mysql_fetch_assoc($orecs) )
        {
            if ( $rows['uid'] == 0 )
            {
                $guests++;
            }
            else
            {
                $onlineusers .= ($onlineusers ? ", " : "" ). "<a href\"". construct_newppurl( "member.php", array('uid' => $rows['uid'], 'username' => $rows['userid']) ) ."\">{$rows['userid']}</a>";
            }
        }

        if ( $guests )
        {
            $onlineusers .= ($onlineusers ? " {$Globals['pp_lang']['and']} " : "" ). "$guests " . strtolower($Globals['pp_lang']['guests']);
        }
    }

    // Show the board
    $x = 0;
    $messages = array();

    $msgs = ppmysql_query("SELECT b.*,u.username FROM {$Globals['pp_db_prefix']}board b
                                         LEFT JOIN {$Globals['pp_db_prefix']}users u ON (u.userid=b.userid)
                                         ORDER BY lastdate DESC", $link);

    while ( $mess = mysql_fetch_assoc($msgs) )
    {
        if ( $mess['replyto'] == 0 )
        {
            $messages[$x]['msgid'] = $mess['msgid'];
            $messages[$x]['date'] = strftime( "%B %d %I:%m%p", $mess[date]);
            $messages[$x]['date'] .= "<br />by <a href=\"". construct_newppurl( "member.php", array('uid' => $mess['userid'], 'username' => $mess['username']) ) ."\">{$mess['username']}</a>";
            $messages[$x]['userid'] = $mess['userid'];

            // Mouseover preview?
            $messages[$x]['message'] = substr(convert_markups($mess['message']),0,120);

            $messages[$x]['subject'] = $mess['subject'];
            $messages[$x]['replies'] = $mess['replies'];
            $messages[$x]['views'] = $mess['views'];
            $messages[$x]['ipaddr'] = $mess['ipaddr'];
            $messages[$x]['category'] = $mess['category'];
            $messages[$x]['link'] = construct_newppurl( "board.php", array('msg' => $mess['msgid'], 'subject' => $mess['subject']) );

            if ( $mess['lastmsg'] )
            {
                $messages[$x]['date'] = strftime( "%B %d %I:%m%p", $mess['lastdate']);
                $messages[$x]['date'] .= "<br />{$Globals['pp_lang']['by']} <a href=\"". construct_newppurl( "member.php", array('uid' => $mess['lastuser'], 'username' => $mess['lastusername']) ) ."\">{$mess['lastusername']}</a>";
                $messages[$x]['userid'] = $mess['lastuser'];
                $messages[$x]['user'] = $mess['lastusername'];
            }

            $x++;

            if ( $x == 50 )
            {
                break;
            }
        }
    }

    $what = "board";
}

printheader( 0, $Globals['pp_lang']['messageboard'] );
topmenu();

include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/menubar.tmpl" );
include( "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/$what.tmpl" );

printfooter();

?>
