<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "admphoto" );
require "pp-inc.php";
require "{$Globals['PP_PATH']}/image-inc.php";

typecast($_REQUEST, array('dowhat' => STRING, 'ppaction' => STRING, 'pid' => INT));
typecast($_POST, array('pdelete' => STRING, 'thecat' => INT, 'page' => INT, 'sort' => INT, 'puserid' => INT,
                       'catmove' => INT, 'origcat' => INT));

if ( empty($pid) )
{
    diewell( $Globals['pp_lang']['malform'] );
}

authenticate();

if ( isset($Globals['ppboards']) && $User['adminedit'] != 1 )
{
    if ( $Globals['ppboards'] == "closed" )
    {
        diewell( $Globals['closedmsg'] );
    }
}

// if we're editing a photo, check to see that the user is either an admin/mod or the post owner ###

if ( $gologin == 1 )
{
    login( "{$Globals['maindir']}/editphoto.php?phoedit=$pid" );
    exit;
}

if ( !isset($pdelete) ) $pdelete = null;

if ( $ppaction == "manipulate" )
{
    $queryv = ppmysql_query("SELECT id,user,userid,cat,storecat,bigimage,medsize,watermarked FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
    list( $id, $user, $tuserid, $cat, $storecat, $bigimage, $medsize, $watermarked ) = mysql_fetch_row($queryv);

    $ismod = ( $User['adminedit'] == 1 ? true : false );

    if ( $User['moderator'] == 1 )
    {
        $ismod = is_moderator($cat);
    }

    if ( $ueditpho == 0 && !($User['adminedit'] == 1 || $ismod) )
    {
        forward( "showphoto.php?photo=$pid", $Globals['pp_lang']['noperm'] );
        exit;
    }

    if ( $storecat == 0 )
    {
        $storecat = $cat;
    }

    $thumblink = "{$Globals['datafull']}$storecat/thumbs/$bigimage";
    $medimage = "{$Globals['datafull']}$storecat/medium/$bigimage";
    $imagelink = "{$Globals['origfull']}$storecat/$bigimage";
    $bigimage = "$bigimage";

    if ( $dowhat != "rebuildthumb" )
    {
        $imagewidth = 0; $imageheight = 0; $imagesize = 0;
        $medwidth = 0; $medheight = 0; $medimgsize = 0;

        @unlink( $thumblink );

        if ( $Globals['usegd'] != 0 )
        {
            if ( $dowhat == "rotateccw" ) gd_rotate_jpeg($imagelink, 270);
            elseif ( $dowhat == "rotatecw" ) gd_rotate_jpeg($imagelink, 90);
            elseif ( $dowhat == "flip" ) gd_rotate_jpeg($imagelink, "flip");
            else gd_rotate_jpeg($imagelink, "flop");
        }
        else
        {
            if ( $dowhat == "rotateccw" ) $syscmd = "{$Globals['mogrify_command']} -rotate 270 $imagelink";
            elseif ( $dowhat == "rotatecw" ) $syscmd = "{$Globals['mogrify_command']} -rotate 90 $imagelink";
            elseif ( $dowhat == "flip" ) $syscmd = "{$Globals['mogrify_command']} -flip $imagelink";
            elseif ( $dowhat == "flop" ) $syscmd = "{$Globals['mogrify_command']} -flop $imagelink";
            else {
                diewell( $Globals['pp_lang']['mogrify'] );
            }

            // call ImageMagick mogrify to perform action
            system( $syscmd, $retval );

            if ( $retval != 0 )
            {
                diewell("{$Globals['pp_lang']['erotate']}!<p>{$Globals['pp_lang']['errorcode']}: $retval<br />$syscmd");
            }
        }

        $image_stats = getimagesize( $imagelink );
        $imagewidth = $image_stats[0];
        $imageheight = $image_stats[1];
        $imagesize = filesize( $imagelink );

        if ( $medsize > 0 )
        {
            if ( $Globals['usegd'] != 0 )
            {
                if ( $dowhat == "rotateccw" ) gd_rotate_jpeg($medimage, 270);
                elseif ( $dowhat == "rotatecw" ) gd_rotate_jpeg($medimage, 90);
                elseif ( $dowhat == "flip" ) gd_rotate_jpeg($medimage, "flip");
                else gd_rotate_jpeg($medimage, "flop");
            }
            else
            {
                if ( $dowhat == "rotateccw" ) $syscmd = "{$Globals['mogrify_command']} -rotate 270 $medimage";
                elseif ( $dowhat == "rotatecw" ) $syscmd = "{$Globals['mogrify_command']} -rotate 90 $medimage";
                elseif ( $dowhat == "flip" ) $syscmd = "{$Globals['mogrify_command']} -flip $medimage";
                elseif ( $dowhat == "flop" ) $syscmd = "{$Globals['mogrify_command']} -flop $medimage";
                else
                {
                    diewell( $Globals['pp_lang']['mogrify'] );
                }

                // call ImageMagick mogrify to perform action
                system( $syscmd, $retval );

                if ( $retval != 0 )
                {
                    diewell( "{$Globals['pp_lang']['erotatemed']}<p>{$Globals['pp_lang']['errorcode']}: $retval<br />$syscmd" );
                }
            }

            $image_stats = getimagesize( $medimage );
            $medwidth = $image_stats[0];
            $medheight = $image_stats[1];
            $medimgsize = filesize( $medimage );
        }
    }

    $holduserid = $User['userid'];
    $User['userid'] = $tuserid;
    $thumbsize = create_thumb( $bigimage, $imagelink, $storecat, "rebuildthumbnail" );
    $User['userid'] = $holduserid;

    if ( $dowhat != "rebuildthumb" )
    {
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET width=$imagewidth, height=$imageheight, filesize=$imagesize, medwidth=$medwidth, medheight=$medheight, medsize=$medimgsize WHERE id=$pid", $link);
    }

    if ( $dowhat == "rotateccw" ) $msg = $Globals['pp_lang']['rotatedccw'];
    elseif ( $dowhat == "rotatecw" ) $msg = $Globals['pp_lang']['rotatedcw'];
    elseif ( $dowhat == "flip" ) $msg = $Globals['pp_lang']['flipped'];
    elseif ( $dowhat == "flop" ) $msg = $Globals['pp_lang']['flopped'];
    else $msg = $Globals['pp_lang']['thumbdone'];

    forward("editphoto.php?phoedit=$pid", $msg);
}

if ( $ppaction == "movedel" )
{
    $resulta = ppmysql_query("SELECT userid,cat,storecat,storeid,bigimage,medsize,title FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
    list( $puserid, $thecat, $storecat, $storeid, $filename, $medsize, $ptitle ) = mysql_fetch_row($resulta);

    $ismod = ( $User['adminedit'] == 1 ? true : false );

    if ( $User['moderator'] == 1 )
    {
        $ismod = is_moderator($thecat);
    }

    if ($pdelete == "yes")
    {
        if ( ($User['userid'] == $puserid && $Globals['userdel'] == "yes") || $ismod )
        {
            // if an original, then we have to move it to another cat and update those copies
            // count number of "copies"
            $result2a = ppmysql_query("SELECT id,cat FROM {$Globals['pp_db_prefix']}photos WHERE storeid=$pid", $link);

            // if any, then we need to move this image to one of the copies
            if ( mysql_num_rows($result2a) > 0 )
            {
                // move the image to the next cat
                list( $nextid, $nextcat ) = mysql_fetch_row($result2a);
                move_image_cat( $pid, $nextcat, "no" );

                // update all copies to point to new location and make this one the new pointer
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=$nextcat,storeid=$nextid WHERE storeid=$pid", $link);
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=0,storeid=0 WHERE id=$nextid", $link);
            }
            else
            {
                // if none, just remove the image
                remove_all_files( $filename, $medsize, $puserid, $thecat );
            }

            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$pid", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE photo=$pid", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$pid", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photoextras WHERE photo=$pid", $link);

            // Update if last photo is set to this photo
            $resulta = ppmysql_query("SELECT lastphoto FROM {$pp_db_prefix}users WHERE userid=$puserid LIMIT 1", $link);
            list( $lastphoto ) = mysql_fetch_row($resulta);

            if ( $lastphoto == $pid )
            {
                ppmysql_query("UPDATE {$pp_db_prefix}users SET lastphoto=0,lastdate=0 WHERE userid=$puserid LIMIT 1", $link);
                $resultb = ppmysql_query("SELECT id,date FROM {$pp_db_prefix}photos WHERE userid=$puserid ORDER BY date DESC LIMIT 1", $link);

                while ( list($pid, $pdate) = mysql_fetch_row($resultb) )
                {
                    if ( $pid )
                    {
                        ppmysql_query("UPDATE {$pp_db_prefix}users SET lastphoto=$pid,lastdate=$pdate WHERE userid=$puserid", $link);
                    }
                }
            }

            adminlog( "Photo Deleted: $filename (#$pid) $ptitle" );

            upgradecategories($thecat);

            // Force refresh of cache
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

            if ($Globals['ppostcount'] == "yes")
            {
                inc_user_posts( "minus", $puserid );
            }

            if ( $Globals['useemail'] == "yes" && ($User['adminedit'] == 1 && $User['userid'] != $puserid) )
            {
                admin_email( 'delete', $pid, $puserid, $ptitle );
            }

            if ( $thecat == 500 || $thecat == MOBILE_CAT )
            {
                forward("showgallery.php?cat=$thecat&ppuser=$puserid&page=$page&sort=$sort", $Globals['pp_lang']['deleted']);
            }
            else
            {
                forward("showgallery.php?cat=$thecat&page=$page&sort=$sort", $Globals['pp_lang']['deleted']);
            }
        }
        else
        {
            diewell( $Globals['pp_lang']['noperm'] );
        }
    }

    if ( empty($catmove) )
    {
        diewell( $Globals['pp_lang']['badmove'] );
    }
    else
    {
        if ( ($User['userid'] == $puserid && $Globals['usermove'] == "yes") || $ismod )
        {
            if ( $origcat != $catmove )
            {
                move_image_cat( $pid, $catmove );

                upgradecategories( $origcat );
                upgradecategories( $catmove );

                // Force refresh of cache
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);
            }

            forward("showphoto.php?photo=$pid", $Globals['pp_lang']['noneed']);
        }
        else
        {
            diewell( $Globals['pp_lang']['noperm'] );
        }
    }
}

?>
