<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

define( 'THIS_SCRIPT', "admmisc" );
require_once "adm-inc.php";

typecast( $_REQUEST, array('copyimages' => STRING,'delimages' => STRING,'revert' => STRING,'newpath' => STRING,'newurl' => STRING,
                           'admact' => STRING, 'photo' => INT, 'cat' => STRING, 'sub' => INT, 'thumb' => INT,'ppaction' => STRING,
                           'sort' => INT, 'sl' => STRING, 's' => STRING, 'si' => STRING,'cat' => STRING, 'page' => INT,'ppuser' => INT,
                           'perpage' => INT, 'defdel' => INT, 'defapp' => INT,'defhol' => INT,'pid' => INT,'origcat' => INT,
                           'catmove' => INT, 'okay' => STRING, 'fixthumbs' => STRING, 'allthumbs' => STRING, 'allmedium' => STRING,
                           'watermark' => STRING, 'counts' => STRING, 'scanexif' => STRING, 'start' => INT, 'updateowner' => STRING,
                           'cleanup' => STRING, 'category' => STRING, 'template' => STRING, 'final' => STRING, 'body' => STRING,
                           'stylesheet' => STRING, 'section' => INT, 'thecount' => INT, 'do' => STRING, 'approve' => STRING,
                           'remove' => INT, 'clear' => STRING, 'table' => STRING, 'whichfile' => STRING, 'usergroupid' => INT,
                           'groupid' => INT, 'usergroup' => STRING, 'lastphoto' => STRING, 'catavatar' => STRING,
  			               'subid' => INT, 'subname' => STRING, 'subdesc' => STRING, 'subduration' => STRING,
                           'subdays' => INT, 'subactive' => STRING, 'subprice' => INT, 'subgroup' => INT));
typecast( $_POST, array('catname' => STRING, 'catdesc' => STRING, 'photoage' => INT, 'submit' => STRING) );
typecast( $_COOKIE, array('ppperpage' => INT) );
typecast_wc("new", STRING);

if ( isset($perpage) && is_numeric($perpage) )
{
    if ( $perpage != $ppperpage )
    {
        @setcookie( "ppperpage", $perpage, time()+2592000 );
        $page = 1;
    }
}

//
// PHP INFO
//

if ( $admact == "phpi" )
{
    if ( $User['adminedit'] == 0 )
    {
        diewell( "You are not a valid administrator!" );
    }

    echo phpinfo();
}

//
// Admin Photo Approval
//

if ( $admact == "approve" )
{
    $PATH_INFO = findenv("PATH_INFO");
    if ( isset($PATH_INFO) && $Globals['spider'] == "spider" )
    {
        $test = explode('/', substr($PATH_INFO,1));
        for($i = 0; $i < count($test); $i++)
        {
            if( $i % 2 == 0 )
            {
                $_REQUEST[$test[$i]] = $test[$i+1];
            }
        }
    }

    if ( $User['adminedit'] == 0 && $User['moderator'] == 0 )
    {
        diewell( "You are not a valid administrator or moderator!" );
    }

    $modcats = null;

    if ( $User['adminedit'] == 0 )
    {
        $modcats = get_modcats();
        if ( !empty($modcats) )
        {
            $modcats = "AND cat IN ($modcats)";
        }
    }

    if ( empty($sort) )
    {
        $sortparam = 1;
    }
    else
    {
        $sortparam = $sort;
    }

    if ( empty($ppaction) )
    {
        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort", $link);

        if ( !isset($sort) || empty($sort) )
        {
            $sort = 2;
        }

        $sortoptions = null;
        $sortcode= null;
        $posternav= null;

        while ( list($sortid, $sortname, $sortc) = mysql_fetch_row($resultc) )
        {
            if ($sortparam != $sortid)
            {
                $sortoptions .= "<option value = $sortid>$sortname</option>";
            }
            else
            {
                $sortdefault = "<option selected value=\"$sortid\">$sortname</option>";
                $sortcode = str_replace("disporder,", "", $sortc);
            }
        }
        ppmysql_free_result($resultc);

        if ( empty($sortdefault) )
        {
            $sortdefault = "<option selected>Date (newest first)</option>";
        }

        $sortselect = "<select onchange=\"submit();\" name=\"sort\" class=\"bginput\">$sortdefault$sortoptions</select>";
        // end sort box //

        if ( isset($page) && $page > 0 )
        {
            $startnumb = ($page*$perpage)-$perpage+1;
        }
        else
        {
            $page=1;
            $startnumb=1;
        }

        $catdefault = null;
        if ( $cat == "notcat" )
        {
            $cat=0;
            $notcat=1;
        }

        if ( !empty($cat) && is_numeric($cat) )
        {
            $resultb = ppmysql_query("SELECT id,catname,thumbs,cattype FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat LIMIT 1", $link);
            while ( list( $subid, $subcatname, $subthumbs, $cattype ) = mysql_fetch_row($resultb) )
            {
                if ( $cattype == "c" )
                {
                    if ( $CatPerms['ugcat'][$subid] != 1 )
                    {
                        $catdefault = "<option selected value=\"$subid\">$subcatname</option>";
                    }
                }
            }
        }
        else {
            //$cat = 0;
            if ( $CatPerms['ugcat'][500] != 1 )
            {
                $resultb = ppmysql_query("SELECT id,catname,thumbs FROM {$Globals['pp_db_prefix']}categories WHERE id=500 LIMIT 1", $link);
                list( $subid, $subcatname, $subthumbs ) = mysql_fetch_row($resultb);
                $catdefault = "<option selected value=\"$subid\">$subcatname</option>";
            }
        }

        if ( $cat == "hidden" )
        {
            $catdisp = "<select onChange=\"submit();\" name=\"cat\"><option value=\"0\">Approve Queue</option><option selected value=\"hidden\">Hidden Images</option>";
        }
        elseif ( $cat == 0 )
        {
            $catdisp = "<select onChange=\"submit();\" name=\"cat\"><option selected value=\"0\">Approve Queue</option><option value=\"hidden\">Hidden Images</option>";
        }
        else
        {
            $catdisp = "<select onChange=\"submit();\" name=\"cat\"><option selected value=\"0\">Approve Queue</option><option value=\"hidden\">Hidden Images</option>";
        }

        $selected = $cat;
        catmoveopt(0);
        $catdisp .= $catoptions;

        if (!isset($s))
        {
            $s = null;
        }

        $perpage1x = $Globals['thumbcols'];
        $perpage3x = ($perpage1x * 3);
        $perpage4x = ($perpage1x * 4);
        $perpage5x = ($perpage1x * 5);
        $perpage6x = ($perpage1x * 6);

        if ( isset($perpage) )
        {
            if ($perpage > $perpage6x)
            {
                $perpage = $perpage6x;
            }

            if ($perpage < $perpage1x)
            {
                $perpage = $perpage1x;
            }

            if ( $perpage != $defperpage )
            {
                @setcookie( "defperpage", $perpage, time()+2592000, $Globals['cookie_path'] );
            }
        }
        else
        {
            if ( isset($defperpage) )
            {
                $perpage = $defperpage;
            }
            else
            {
                $perpage = $perpage3x;
            }
        }

        adminheader( 0, "PhotoPost Admin" );

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\"><tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\" width=\"100%\">
            <tr>
            <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\">
            <span class=\"{$Style['large']}\"><b>PhotoPost Admin Photo Approval Interface</b></span>
            </td></tr>
            <tr>
            <td class=\"{$Style['tddetails']}\" colspan=\"4\"><table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
            <form method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\"><input type=\"hidden\" name=\"admact\" value=\"approve\">
            <table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
            <tr><td class=\"{$Style['tddetails']}\" align=\"left\"><b>Category:</b> $catdisp</select></td><td>
            <div align=\"center\"><b>Sort by:</b> $sortselect</div></td>
            <td class=\"{$Style['tddetails']}\" align=\"right\" nowrap=\"nowrap\"><b>Per Page:</b></span>
            <select onChange=\"submit();\" name=\"perpage\" class=\"bginput\">
            <option selected=\"selected\">$perpage</option><option>$perpage3x</option><option>$perpage4x</option><option>$perpage5x</option><option>$perpage6x</option></select>
            </td></tr></table></form></td></tr></table></tr></td></table><br />

            <form name=\"modform\" method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\">
            <input type=\"hidden\" value=\"dochanges\" name=\"ppaction\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\"><tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\" width=\"100%\">
            <tr><td class=\"{$Style['menubar']}\" align=\"center\">THUMBNAIL</td><td class=\"{$Style['menubar']}\" align=\"center\">INFO / CATEGORY</td>";

        if ( $cat == "hidden" )
        {
            $output .= "<td class=\"{$Style['menubar']}\" align=\"center\"><a href=\"javascript:switchAll('d');\">DELETE</a></td>
                        <td class=\"{$Style['menubar']}\" align=\"center\"><a href=\"javascript:switchAll('a');\">UNHIDE</a></td>";
        }
        elseif ( $cat == 0 )
        {
            $output .= "<td class=\"{$Style['menubar']}\" align=\"center\"><a href=\"javascript:switchAll('d');\">DELETE</a></td>
                        <td class=\"{$Style['menubar']}\" align=\"center\"><a href=\"javascript:switchAll('a');\">APPROVE</a></td>
                        <td class=\"{$Style['menubar']}\" align=\"center\"><a href=\"javascript:switchAll('h');\">HOLD</a></td>";
        }
        else
        {
            $output .= "<td class=\"{$Style['menubar']}\" align=\"center\"><a href=\"javascript:switchAll('d');\">DELETE</a></td>
                        <td class=\"{$Style['menubar']}\" align=\"center\"><a href=\"javascript:switchAll('h');\">LEAVE</a></td>";
        }

        $count = 0;
        $photocount = 0;
        $cntresults = 0;

        if ( $cat == "hidden" )
        {
            $query = "SELECT id,user,userid,cat,storecat,date,title,description,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved FROM {$Globals['pp_db_prefix']}photos WHERE approved=2 $modcats $sortcode";
        }
        elseif ( $cat == 0 )
        {
            $query = "SELECT id,user,userid,cat,storecat,date,title,description,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved FROM {$Globals['pp_db_prefix']}photos WHERE approved=0 AND storecat=0 $modcats $sortcode";
        }
        else
        {
            $query = "SELECT id,user,userid,cat,storecat,date,title,description,keywords,bigimage,width,height,filesize,views,medwidth,medheight,medsize,approved FROM {$Globals['pp_db_prefix']}photos WHERE cat=$cat AND approved=1 $sortcode";
        }

        $queryz = ppmysql_query($query, $link);
        $rowcnt = mysql_num_rows($queryz);
        admpages( $rowcnt );

        $ismod = ( $User['adminedit'] == 1 ? true : false );

        while ( list($id,$tuser,$tuserid,$tcat,$tstorecat,$date,$title,$desc,$keywords,$bigimage,$width,$height,$filesize,$views,$medwidth,$medheight,$medsize,$approved) = mysql_fetch_row($queryz))
        {
            if ( !$ismod )
            {
                $ismod = is_moderator($tcat);

                if ( !$ismod )
                {
                    $posternav = null;
                    break;
                }
            }

            $cntresults++;
            $filesize = $filesize/1024;
            $filesize = sprintf("%1.1f", $filesize);
            $filesize = $filesize."k";

            if ($cntresults >= $startnumb)
            {
                if ($cntresults < ($startnumb+$perpage))
                {
                    $photocount++;
                    $count++;
                    $storecat = ( $tstorecat != 0 ? $tstorecat : $tcat );

                    $extracat = null;
                    $result2 = ppmysql_query("SELECT p.id,c.catname FROM {$Globals['pp_db_prefix']}photos p
                               LEFT JOIN {$Globals['pp_db_prefix']}categories c ON c.id=p.cat
                               WHERE p.storeid=$id", $link);

                    while ( list( $exid, $excat ) = mysql_fetch_row($result2) )
                    {
                        $extracat .= "$excat<br />";
                    }

                    $theext = get_ext( $bigimage );
                    $filename = str_replace( $theext, "", $bigimage );

                    $ppdate = formatppdate( $date );

                    if ($Globals['bigsave'] == "yes")
                    {
                        if ( !empty($filesize) )
                        {
                            if ($medsize > 0)
                            {
                                $medsize = $medsize/1024;
                                $medsize = sprintf("%1.1f", $medsize);
                                $medsize = $medsize."k";
                                $ilink = "{$Globals['datadir']}/$storecat/medium/$bigimage";
                                $biglink = "{$Globals['datadir']}/$storecat/$bigimage";
                                $fsizedisp = "<a href=\"{$Globals['datadir']}/$storecat/medium/$bigimage\">$medsize</a>, <a
                                    href=\"{$Globals['datadir']}/$storecat/$bigimage\">$filesize</a>";
                            }
                            else
                            {
                                $ilink = "{$Globals['origdir']}/$storecat/$bigimage";
                                $fsizedisp = "<a href=\"{$Globals['origdir']}/$storecat/$bigimage\">$filesize</a>";
                            }
                        }
                    }
                    else
                    {
                        $fsizedisp = "n/a";
                    }

                    $imgtag = get_imagethumb( $bigimage, $storecat, $tuserid, 1 );

                    $output .= "<tr><td class=\"{$Style['tddetails']}\" valign=\"middle\" align=\"center\" width=\"125\">";
                    $output .= "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$id&amp;cat=$cat\" target=\"_blank\">$imgtag</a>";

                    $result = ppmysql_query("SELECT id,catname,thumbs FROM {$Globals['pp_db_prefix']}categories WHERE id='$tcat' LIMIT 1", $link);
                    list( $subid, $subcatname, $subthumbs ) = mysql_fetch_row($result);

                    $catdefhide = "<input type=\"hidden\" name=\"catdef$photocount\" value=\"$subid\">";
                    $catoptions = null;
                    $selected = $subid;

                    catmoveopt(0);

                    $output .= "<br /><span class=\"{$Style['small']}\">$title</span></td>
                        <td class=\"{$Style['tddetails']}\" align=\"center\">$tuser<br />$ppdate<br />$fsizedisp</span><br /><br />
                        <select name=\"category$photocount\" class=\"bginput\">$catoptions</select>
                        ";

                    if ( $extracat != "" )
                     {
                        $output .= "<br />Extra Categories:<br /><span class=\"{$Style['small']}\">$extracat</span>";
                    }

                    $output .= "</td><td class=\"{$Style['tddetails']}\" align=\"center\">
                        <input type=\"hidden\" name=\"theimage$photocount\" value=\"$bigimage\">
                        <input type=\"hidden\" name=\"id$photocount\" value=\"$id\">
                        <input type=\"hidden\" name=\"origcat$photocount\" value=\"$subid\">
                        <input type=\"hidden\" name=\"tuserid$photocount\" value=\"$tuserid\">";

                    $deletecheck = null;
                    $approvecheck = null;
                    $holdcheck = null;

                    if ( isset($defdel) )
                    {
                        $deletecheck = "checked=\"checked\"";
                        $approvecheck = null;
                    }
                    elseif ( isset($defapp) )
                    {
                        $approvecheck = "checked=\"checked\"";
                    }
                    else
                    {
                        $holdcheck = "checked=\"checked\"";
                        $approvecheck = null;
                    }

                    if ( $cat == "hidden" )
                    {
                        $output .= "<input name=\"approve$photocount\" value=\"delete\" $deletecheck type=\"radio\"></td>
                            <td class=\"{$Style['tddetails']}\" align=\"center\"><input name=\"approve$photocount\" value=\"approve\" $approvecheck type=\"radio\"></td>";
                    }
                    elseif ( $cat == 0 )
                    {
                        $output .= "<input name=\"approve$photocount\" value=\"delete\" $deletecheck type=\"radio\"></td>
                            <td class=\"{$Style['tddetails']}\" align=\"center\"><input name=\"approve$photocount\" value=\"approve\" $approvecheck type=\"radio\"></td>
                            <td class=\"{$Style['tddetails']}\" align=\"center\"><input name=\"approve$photocount\" value=\"hold\" $holdcheck type=\"radio\"></td>";
                    }
                    else
                    {
                        $output .= "<input name=\"approve$photocount\" value=\"delete\" $deletecheck type=\"radio\"></td>
                            <td class=\"{$Style['tddetails']}\" align=\"center\"><input name=\"approve$photocount\" $holdcheck value=\"approve\" type=\"radio\"></td>";
                    }

                    $output .= "$catdefhide</td></tr>";
                }
            }
        }

        ppmysql_free_result( $queryz );

        if ($cntresults == 0 && $cat == "hidden")
        {
            $noresults = "<br />No photos are hidden at this time.<br /><br />";
        }
        elseif ($cntresults == 0 )
        {
            $noresults = "<br />No photos need approval at this time.<br /><br />";
        }
        elseif ($notcat == 1)
        {
            $noresults = "<br />You selected a category which does not contain thumbnails.<br /><br />";
        }
        else
        {
            $noresults = null;
        }

        $output .= "<tr><td class=\"{$Style['tddetails']}\" colspan=\"8\"><div align=\"center\">
            <input type=\"hidden\" name=\"thecount\" value=\"$photocount\">
            <input type=\"hidden\" name=\"cat\" value=\"$cat\">
            <input type=\"hidden\" name=\"page\" value=\"$page\">
            <input type=\"hidden\" name=\"sort\" value=\"$sort\">
            <input type=\"hidden\" name=\"perpage\" value=\"$perpage\">
            <input type=\"hidden\" name=\"admact\" value=\"approve\">
            <input type=\"hidden\" name=\"s\" value=\"$s\">

            $noresults</span>";

        if ( empty($noresults) )
        {
            $output .= "<input type=\"submit\" value=\"Submit Changes\">";
        }

        if ( !empty($posternav) )
        {
            $posternav = "<br />$posternav<br /><br />";
        }

        $output .= "</td></tr></table></td></tr><tr><td class=\"{$Style['tddetails']}\" align=\"center\">$posternav</td></tr></table></form>";

        print $output;
        adminfooter();
    //// end thumbnail page section ////
    }

    if ($_POST['ppaction'] == "dochanges")
    {
        typecast_wc('approve', STRING);
        typecast_wc('category', INT);
        typecast_wc('catdef', INT);
        typecast_wc('origcat', INT);
        typecast_wc('tuserid', INT);
        typecast_wc('theimage', STRING);
        typecast_wc('id', INT);

        $totalphotos=$thecount;

        for ( $i = 1; $i <= $totalphotos; $i++ )
        {
            unset($appkey);

            $tappkey = "approve$i";
            $catkey = "category$i";
            $catdefkey = "catdef$i";
            $origcat = "origcat$i";
            $tuserid = "tuserid$i";
            $theimage = "theimage$i";
            $tpid = "id$i";
            $pid = ${$tpid};
            $appkey = ${$tappkey};

            if ( $pid > 0 )
            {
                if ($appkey == "approve")
                {
                    $newcatid=${$catkey};
                    $catdef=${$catdefkey};
                    $origcat=${$origcat};
                    $tuserid=${$tuserid};
                    $theimage=${$theimage};

                    if ($newcatid == "notcat")
                    {
                        diewell("The category you chose for photo #$i can't contain photos.");
                    }

                    if ( $origcat != $newcatid )
                    {
                        move_image( $origcat, $newcatid, $tuserid, $theimage );

                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET cat=$newcatid WHERE id=$pid", $link);
                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}comments SET cat=$newcatid WHERE photo=$pid", $link);

                        upgradecategories($origcat);
                        $origcat = $newcatid;
                    }

                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET approved=1 WHERE id=$pid OR storeid=$pid", $link);

                    $thedate = ppmysql_query("SELECT date FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid LIMIT 1", $link);
                    list ( $pdate ) = mysql_fetch_row($thedate);

                    ppmysql_query("INSERT IGNORE INTO {$Globals['pp_db_prefix']}users (userid,lastphoto,lastdate) VALUES ($tuserid,0,0)", $link);
                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}users SET lastphoto=$pid,lastdate=$pdate WHERE userid=$tuserid", $link);

                    if ( $Globals['useemail'] == "yes" )
                    {
                        if ( $cat == 0 )
                        {
                            admin_email( "approve", $pid );
                        }

                        if ( $catdef != $newcatid )
                        {
                            admin_email( "moved", $pid );
                        }
                    }

                    $ctitleq = ppmysql_query("SELECT thumbnail FROM {$Globals['pp_db_prefix']}categories WHERE id=$origcat", $link);
                    list( $catnail ) = mysql_fetch_row($ctitleq);

                    $morestuff = "";
                    if ( $catnail == 0 )
                    {
                        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET thumbnail=$pid WHERE id=$origcat", $link);
                    }

                    // Now notify any subscribers
                    $resulta = ppmysql_query("SELECT userid FROM {$Globals['pp_db_prefix']}notify WHERE photo=$origcat AND type=1", $link);
                    while ( list($nuserid) = mysql_fetch_row($resulta) )
                    {
                        if ( $nuserid > 0 )
                        {
        		            $result = ppmysql_query("SELECT id,userid,cat,title,description,bigimage FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
        		            list( $lastphotoid, $notifyuser, $thecat, $title, $desc, $realname ) = mysql_fetch_row($result);

                            list( $tuserid, $tusername, $tmail ) = get_userinfo( "", $nuserid);

                            include "{$Globals['PP_PATH']}/languages/{$Globals['pplang']}.php";
                            $letter = $Globals['pp_lang']['subnotify'];
                            $subject = $Globals['pp_lang']['emsubscr'];

                            $send_to = $tmail;
                            $from_email = "From: {$Globals['adminemail']}";
                            mail( $send_to, $subject, $letter, $from_email );
                        }
                    }

                    upgradecategories($origcat);
                }
                elseif ($appkey == "delete")
                {
                    $resulta = ppmysql_query("SELECT userid,cat,title,bigimage,medsize FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
                    list( $uid, $dcat, $title, $filename, $medsize ) = mysql_fetch_row($resulta);

                    if ( is_numeric($uid) )
                    {
                        remove_all_files( $filename, $medsize, $uid, $dcat );
                    }
                    else
                    {
                        diewell("No pic to delete.");
                    }

                    inc_user_posts( "minus", $uid );

                    if ($Globals['useemail'] == "yes")
                    {
                        admin_email( 'delete', $pid, $uid, $title );
                    }

                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE storeid=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE photo=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$pid", $link);
                    ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photoextras WHERE photo=$pid", $link);

                    upgradecategories($dcat);
                }
            }
        }

        // Force refresh of cache
        ppmysql_query("UPDATE {$Globals['pp_db_prefix']}cache SET timestamp=0 WHERE id=1", $link);

        // Let's update the category cache
        update_catcache();

        adminlog( "Moderated Images" );

        forward( "adm-misc.php?admact=approve&s=$s&cat=$cat&page=$page&perpage=$perpage&sort=$sort", "Processing completed! Returning to Approval Page." );
    }

    exit;
}

//
// Usergroups
//

if ( $admact == "usergroups" )
{
    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ( !isset($ppaction) )
    {
        $ppaction = "usergroups";
    }

    if ($ppaction == "usergroups")
    {
        if ($do == "add")
        {
            $resulta = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}usergroups (groupid,groupname,uploads,comments,diskspace,uploadsize) values(NULL,'Default','0','0','0','0')", $link);
            forward( "adm-misc.php?admact=usergroups" );
        }

        if ( $do == "delete" )
        {
            if ($Globals['vbversion'] == "photopost")
            {
                if ($usergroupid < 6)
                {
                    diewell("You can't delete this usergroup.");
                }
            }

            if (empty($okay))
            {
                $okay = "no";
            }

            if ($okay != "yes")
            {
                adminheader( 0, "PhotoPost User Groups" );

                $output = "<div align=\"center\">

                    <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
                    align=\"center\"><tr><td>
                    <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
                    <tr>
                    <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Add a Usergroup</b></span>
                    </span></td>
                    </tr><tr>
                    <td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
                    <span class=\"{$Style['medium']}\">You are about to delete the <b>\"$usergroup\"</b> usergroup.<br /><br />Please note that if you have
                    any users that are set to this usergroup, you should change those users to a different group BEFORE you delete this one or they will be unable to
                    login to upload photos or post comments.<br /><br />

                    <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"POST\">
                    <input type=\"hidden\" name=\"usergroupid\" value=\"$usergroupid\">
                    <input type=\"hidden\" name=\"do\" value=\"delete\">
                    <input type=\"hidden\" name=\"okay\" value=\"yes\">
                    <input type=\"hidden\" name=\"ppaction\" value=\"usergroups\">
                    <input type=\"hidden\" name=\"admact\" value=\"usergroups\">
                    <input type=\"submit\" value=\"Go ahead and delete this usergroup.\">
                    </form></td></tr></table></td></tr></table>";

                print $output;
                exit;
            }
            else
            {
                $resulta = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}usergroups WHERE groupid=$usergroupid", $link);
                adminlog( "Deleted Usergroup: $usergroupid" );
                forward( "adm-misc.php?admact=usergroups", "Processing complete!" );
            }
        }

        if ($do == "refresh-vb")
        {
            if ( empty($okay) )
            {
                $okay = "no";
            }

            if ($okay != "yes")
            {
                adminheader( 0, "PhotoPost User Groups" );

                $output = "<div align=\"center\">

                    <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
                    align=\"center\"><tr><td>
                    <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
                    <tr>
                    <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Refresh Usergroups</b></span>
                    </span></td>
                    </tr><tr>
                    <td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
                    <span class=\"{$Style['medium']}\">You are about to refresh your forum usergroups.  This is necessary whenever you
                    add or delete usergroups within your forum software.<br /><br />After you refresh, <b>please double-check your PhotoPost usergroup
                    settings</b> to ensure that they are correct!<br /><br />

                    <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"POST\">
                    <input type=\"hidden\" name=\"do\" value=\"refresh-vb\">
                    <input type=\"hidden\" name=\"okay\" value=\"yes\">
                    <input type=\"hidden\" name=\"ppaction\" value=\"usergroups\">
                    <input type=\"hidden\" name=\"admact\" value=\"usergroups\">
                    <input type=\"submit\" value=\"Go ahead and refresh usergroups.\"></form></td></tr></table></td></tr></table>";

                print "$output<p><p>";
                adminfooter();
                exit;
            }
            else
            {
                import_user_groups();
                adminlog( "Refreshed Usergroups" );
                forward( "adm-misc.php?admact=usergroups", "Processing complete!");
            }
        }

        if ($do == "process")
        {
            // Save input usergroups form to DB
            $admincheck=0;

            foreach($_POST as $id=>$setting)
            {
                $name = explode("-", $id);
                $dbid = $name[1];

                if ($name[0] == "cpaccess")
                {
                    if ($setting == 1)
                    {
                        $admincheck = 1;
                    }
                }
            }

            if ($admincheck == 0)
            {
                diewell("At least one usergroup must have Admin Access.");
            }

            foreach($_POST as $id=>$setting)
            {
                $name = explode("-", $id);
                $dbid = $name[1];
                $setting = (ini_get("magic_quotes_gpc")) ? addslashes(stripslashes(trim($setting))) : addslashes(trim($setting));

                if ($dbid != "")
                {
                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}usergroups SET ".$name[0]."='$setting' WHERE groupid=$dbid", $link);
                }
            }

            adminlog( "Modified Usergroups" );
            forward( "adm-misc.php?admact=usergroups", "Processing complete!" );
        }

        adminheader( 0, "PhotoPost User Groups" );

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\"><tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr>
            <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost UserGroup Editor</b></span></td></tr>
            <form method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\">
            <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />

            <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"{$Style['tableborders']}\">
            <tr><td>
            <table border=\"0\" cellpadding=\"5\" cellspacing=\"1\">";

        $resulta = ppmysql_query("SELECT groupid,groupname,cpaccess,modaccess,uploads,uplimit,comments,diskspace,uploadsize,editpho,editposts,useralbums,reqmod,canassign FROM {$Globals['pp_db_prefix']}usergroups ORDER BY groupid", $link);

        while ( list($uggroupid,$uggroupname,$ugcpaccess,$ugmodaccess,$uguploads,$uplimit,$ugcomments,$ugdiskspace,$uguploadsize,$editpho,$editposts,$useralbums,$ugreqmod,$ucanassign) = mysql_fetch_row($resulta) )
        {
            if ($ugcpaccess == "1")
            {
                $cpaccess_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $cpaccess_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($ugmodaccess == "1")
            {
                $modaccess_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $modaccess_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($editpho == "1")
            {
                $editpho_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $editpho_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($editposts == "1")
            {
                $editposts_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $editposts_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($uguploads == "1")
            {
                $uploads_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $uploads_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($ugcomments == "1")
            {
                $comments_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $comments_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($useralbums == "1")
            {
                $album_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $album_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($ugreqmod == "1")
            {
                $ugmod_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $ugmod_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($ucanassign == "1")
            {
                $ucana_opts= "<option selected value=\"1\">yes</option><option value=\"0\">no</option>";
            }
            else
            {
                $ucana_opts= "<option selected value=\"0\">no</option><option value=\"1\">yes</option>";
            }

            if ($Globals['vbversion'] == "photopost" )
            {
                $addhtml = "<b>(<a href=\"{$Globals['maindir']}/adm-misc.php?admact=usergroups&amp;do=add\">Add a New
                    Usergroup</a>)</b></span>";
            }
            else
            {
                $addhtml = "<span class=\"{$Style['medium']}\"><b>(<a
                    href=\"{$Globals['maindir']}/adm-misc.php?admact=usergroups&amp;do=refresh-vb\">Refresh usergroups from your forum software?</a>)</b></span>";
            }

            $output .= "<tr><td class=\"{$Style['menubar']}\">Usergroup name</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Admin Access?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Mod Access?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Allow Uploads?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Allow comments?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Require Moderation?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Allow edit own photos?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Allow edit own posts?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Allow albums?</td>
                <td class=\"{$Style['menubar']}\" align=\"center\">Assign Albums to Cats?</td></tr>
                <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\">
                <input type=\"text\" size=\"25\" maxlength=\"25\" value=\"$uggroupname\" name=\"groupname-$uggroupid\" class=\"bginput\">";

            if ($Globals['vbversion'] == "photopost")
            {
                if ($uggroupid > 5)
                {
                    $output .= "<br />(<span class=\"{$Style['small']}\"><a
                        href=\"{$Globals['maindir']}/adm-misc.php?admact=usergroups&amp;usergroupid=$uggroupid&amp;do=delete&amp;usergroup=$uggroupname\">delete</a>)";
                }
            }

            $output .= "</td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"cpaccess-$uggroupid\">$cpaccess_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"modaccess-$uggroupid\">$modaccess_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"uploads-$uggroupid\">$uploads_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"comments-$uggroupid\">$comments_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"reqmod-$uggroupid\">$ugmod_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"editpho-$uggroupid\">$editpho_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"editposts-$uggroupid\">$editposts_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"useralbums-$uggroupid\">$album_opts</select></td>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><select name=\"canassign-$uggroupid\">$ucana_opts</select></td>
                </tr><tr>
                <td class=\"{$Style['tddetails']}\" align=\"center\"><span size=\"{$Style['small']}\">(0 means 'unlimited')</span></td>
                <td class=\"{$Style['tddetails']}\" colspan=\"3\" align=\"center\">Disk Space Limit (kB)<br /><input type=\"text\" size=\"8\" value=\"$ugdiskspace\" name=\"diskspace-$uggroupid\" class=\"bginput\"></td>
                <td class=\"{$Style['tddetails']}\" colspan=\"3\" align=\"center\">Upload File Size Limit (kB)<br /><input type=\"text\" size=\"8\" value=\"$uguploadsize\" name=\"uploadsize-$uggroupid\" class=\"bginput\"></td>
                <td class=\"{$Style['tddetails']}\" colspan=\"3\" align=\"center\">Daily Upload Limit (# of files)<br /><input type=\"text\" size=\"5\" value=\"$uplimit\" name=\"uplimit-$uggroupid\" class=\"bginput\"></td>
                </tr><tr>
                <td class=\"{$Style['menubar']}\" colspan=\"10\" height=\"3\"><img height=\"1\" width=\"1\" src=\"{$Globals['idir']}/spacer.gif\"></td>
                </tr>";
        }

        $output .= "</table></td></tr></table><p><div align=\"center\">
            <input type=\"hidden\" value=\"usergroups\" name=\"ppaction\">
            <input type=\"hidden\" value=\"process\" name=\"do\">
            <input type=\"hidden\" name=\"admact\" value=\"usergroups\">
            $addhtml<p>
            <input value=\"Save Changes\" type=\"submit\">
            </td></tr></table></td></tr></table>";

        print "$output<p><p>";
        adminfooter();
        exit;
    }

    diewell("Usergroups called improperly!");

}

if ( $admact == "sidemenu" )
{
    adminheader( 0, "PhotoPost Administration Menu" );
    $logout = "<a href=\"{$Globals['maindir']}/misc.php?action=logout\" target=\"_top\">Logout</a>";

    $userhtml= null;

    if ($Globals['vbversion'] == "photopost")
    {
        $userhtml= "<a href=\"{$Globals['maindir']}/adm-users.php?ppaction=users\" target=\"mainFrame\">Edit Users</a><br />";
    }

$adminmenu = <<<ADMPRINT
<table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}" width="98%" align="center">
<tr><td>
<table cellpadding="2" cellspacing="2" border="0"  width="100%">
<tr>
<td align="left" class="{$Style['menubar']}">
General</span>
</td></tr>
<tr><td class="{$Style['tddetails']}"><span class="{$Style['small']}">
    <a href="{$Globals['maindir']}/adm-misc.php?admact=mainmenu" target="mainFrame">Statistics</a><br />
    <a href="{$Globals['maindir']}/adm-misc.php?admact=approve" target="mainFrame">Approve Photos</a><br />
    <a href="{$Globals['maindir']}/adm-misc.php?admact=approve&cat=500" target="mainFrame">Bulk Actions</a><br />
    <a href="{$Globals['maindir']}/adm-misc.php?admact=modcom" target="mainFrame">Moderate Comments</a><br />
    <a href="{$Globals['maindir']}/adm-misc.php?admact=order" target="mainFrame">Order Images</a><br />
ADMPRINT;

    if ( $User['adminedit'] == 1 )
    {
        $adminmenu .= "$userhtml<a href=\"{$Globals['maindir']}/adm-misc.php?admact=move\" target=\"mainFrame\">Bulk Move</a><br />
            <a href=\"{$Globals['maindir']}/adm-misc.php?admact=albums\" target=\"mainFrame\">Manage Albums</a><br />";
    }

$adminmenu .= <<<ADMPRINT
    <br /><a href="{$Globals['maindir']}/index.php" target="_top">Back to User Index</a><br />
    <br />$logout</span></td></tr></table></td></tr></table>
ADMPRINT;

    if ( $User['adminedit'] == 1 )
    {
$adminmenu .= <<<ADMPRINT
<br /><table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}" width="98%" align="center">
<tr><td>
<table cellpadding="2" cellspacing="2" border="0"  width="100%">
<tr>
<td align="left" class="{$Style['menubar']}">
Edit Settings</span>
</td></tr>
<tr><td class="{$Style['tddetails']}" nowrap="nowrap"><span class="{$Style['small']}">
<a href="{$Globals['maindir']}/adm-misc.php?admact=options&amp;ppaction=options" target="mainFrame">All Options</a><br />
ADMPRINT;

    $getadm = mysql_query("SELECT id,name FROM {$Globals['pp_db_prefix']}admingroups ORDER BY id", $link);

    while ( list($id, $name) = mysql_fetch_row($getadm))
    {
        $adminmenu .= "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=options&amp;ppaction=options&amp;section=$id\" target=\"mainFrame\">$name</a><br />";
    }

$adminmenu .= <<<ADMPRINT
</span></td></tr></table></td></tr></table><br />
<table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}" width="98%" align="center">
<tr><td>
<table cellpadding="2" cellspacing="2" border="0"  width="100%">
<tr>
<td align="left" class="{$Style['menubar']}">
Administration</span>
</td></tr>
<tr><td class="{$Style['tddetails']}"><span class="{$Style['small']}">
<a href="{$Globals['maindir']}/adm-misc.php?admact=config" target="mainFrame">Edit Config</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=editint" target="mainFrame">Edit Integration</a><br /><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=style" target="mainFrame">Edit Stylesheet</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=tmpl" target="mainFrame">Edit Templates</a><br /><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=editfile&amp;whichfile=header" target="mainFrame">Edit Header</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=editfile&amp;whichfile=headtags" target="mainFrame">Edit Headtags</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=editfile&amp;whichfile=footer" target="mainFrame">Edit Footer</a><br /><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=usergroups" target="mainFrame">Edit Usergroups</a><br />
<a href="{$Globals['maindir']}/adm-cats.php?ppaction=cats&amp;start=1" target="mainFrame">Edit Categories</a><br /><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=phpi" target="mainFrame">Show PHP Info</a><br />
</span></td></tr></table></td></tr></table></td></tr></table>
<br />
<table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}" width="98%" align="center">
<tr><td>
<table cellpadding="2" cellspacing="1" border="0"  width="100%">
<tr>
<td align="left" class="{$Style['menubar']}">
<span class="{$Style['medium']}">Subscriptions</span>
</td></tr>
<tr><td class="{$Style['tddetails']}"><span class="{$Style['small']}">
<a href="{$Globals['maindir']}/adm-misc.php?admact=admsubscribe&amp;ppaction=subscriptions" target="mainFrame">Add/Edit Subscriptions</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=admsubscribe&amp;ppaction=listsubs" target="mainFrame">List Subscribers</a><br />
</span></td></tr></table></td></tr></table>
<br />
<table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}" width="98%" align="center">
<tr><td>
<table cellpadding="2" cellspacing="2" border="0" width="100%">
<tr>
<td align="left" class="{$Style['menubar']}">
Database</span>
</td></tr>
<tr><td class="{$Style['tddetails']}"><span class="{$Style['small']}">
<a href="{$Globals['maindir']}/adm-misc.php?admact=dbops" target="_top">Scan Database</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=backup" target="_top">Backup Database</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=purge" target="mainFrame">Purge Old Photos</a><br />
</span></td></tr></table></td></tr></table>
<br />
<table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}" width="98%" align="center">
<tr><td>
<table cellpadding="2" cellspacing="2" border="0" width="100%">
<tr>
<td align="left" class="{$Style['menubar']}">
Image Protection</span>
</td></tr>
<tr><td class="{$Style['tddetails']}"><span class="{$Style['small']}">
<a href="{$Globals['maindir']}/adm-misc.php?admact=options&amp;ppaction=options&amp;section=ips" target="mainFrame">Options</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=editfile&amp;whichfile=htaccess" target="mainFrame">Edit data .htaccess</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=editfile&amp;whichfile=origaccess" target="mainFrame">Edit fullsized .htaccess</a><br />
<a href="{$Globals['maindir']}/adm-misc.php?admact=storage" target="mainFrame">Storage Options</a><br />
</span></td></tr></table></td></tr></table>
<br />
ADMPRINT;
    }

    print $adminmenu;
    print "</body></html>";
}

//
// MAIN INDEX PAGE
//

if ( $admact == "mainmenu" )
{
    if ( $User['adminedit'] == 0 && $User['moderator'] == 0 )
    {
        diewell( "You are not a valid administrator or moderator!" );
    }

    if ( $usegd != 0 )
    {
        if ( !extension_loaded('gd')) {
            if (!dl('gd.so'))
            {
                diewell( "GD support enabled; but not installed on your server.<br />Please contact System Administrator." );
            }
        }
    }

    $usertotal = get_totalusers();

    $totalv = ppmysql_query("SELECT COUNT(*), SUM(views) AS fsize FROM {$Globals['pp_db_prefix']}photos", $link);
    list( $totalphotos, $totalviews ) = mysql_fetch_row($totalv);

    // Don't count copies
    $totalv = ppmysql_query("SELECT SUM(filesize) AS fsize FROM {$Globals['pp_db_prefix']}photos WHERE storecat=0", $link);
    list( $diskuse ) = mysql_fetch_row($totalv);

    $totalm = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}photos WHERE approved=0", $link);
    list( $waiting ) = mysql_fetch_row($totalm);

    $totala = ppmysql_query("SELECT COUNT(*), SUM(photos), SUM(posts) AS nposts FROM {$Globals['pp_db_prefix']}categories WHERE cattype='a'", $link);
    list( $totalalbums, $albumphotos, $albumposts ) = mysql_fetch_row($totala);

    $totalc = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}comments", $link);
    list( $posttotal ) = mysql_fetch_row($totalc);

    // Remove any expired ecards
    list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();
    $mon = $mon + 1;
    $year = $year + 1900;

    $mday2 = $mday - $Globals['cardage'];
    $mday3 = $mday - $Globals['cardexpire'];
    $mday4 = $mday - 14;

    $expiredate = mktime($hour,$min,$sec,$mon,$mday2,$year);
    $expiredate2 = mktime($hour,$min,$sec,$mon,$mday3,$year);
    $expiredate3 = mktime($hour,$min,$sec,$mon,$mday4,$year);

    // Remove expired eCards
    $queryq = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}ecards WHERE (readdate > 0 AND readdate < $expiredate) OR date < $expiredate2", $link);

    // Remove unverified user accounts (Internal only)
    if ( $Globals['vbversion'] == "photopost" )
    {
        $queryq = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}users WHERE joindate < $expiredate3 AND usergroupid=3", $link);
    }

    $totale = ppmysql_query("SELECT COUNT(*) FROM {$Globals['pp_db_prefix']}ecards", $link);
    list( $totalecards ) = mysql_fetch_row($totale);

    $totalviews = number_format( $totalviews );
    $totalphotos = number_format( $totalphotos );
    $usertotal = number_format( $usertotal );
    $posttotal = number_format( $posttotal );

    $diskspace = $diskuse/1048576;
    $diskspace = number_format( $diskspace, 1 );
    $diskspace = "$diskspace mb";

    $datadirlen = dirsize($Globals['datafull']);
    if ( $Globals['datafull'] != $Globals['origfull'] )
    {
        $datadirlen += dirsize($Globals['origfull']);
    }
    $datadirlen = number_format( ($datadirlen/1048576), 2 );

    adminheader( 0, "PhotoPost Administration" );

    $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\">
        <span class=\"{$Style['large']}\"><b>PhotoPost Administration</span>
        </td>
        </tr>
        <tr><td class=\"{$Style['tdbackground']}\"><div align=\"center\"><br />";

    $output .= "<table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"90%\">
        <tr><td class=\"{$Style['menubar']}\" align=\"center\" colspan=\"4\">
        <span class=\"{$Style['medium']}\">PhotoPost News</span></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" align=\"center\">
        <iframe src=\"http://www.anonym.to/?http://www.photopost.com/ppnews.php\" width=\"100%\" height=\"100\">
        </iframe>
        </td></tr></table><br />";

    $output .= "<table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"90%\">
        <tr><td class=\"{$Style['menubar']}\" align=\"center\" colspan=\"4\">
        <span class=\"{$Style['medium']}\">Database Statistics</span></td></tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"50%\" colspan=\"2\">Current Version</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"50%\" colspan=\"2\">7.1</td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Registered Users</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$usertotal</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Comments/Ratings</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$posttotal</td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Image Space Used</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$diskspace</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Total Photos</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$totalphotos</td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\" colspan=\"2\">Total disk space used by the DATA directory</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" colspan=\"2\">$datadirlen mb</td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Number of Albums</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$totalalbums</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Photos in Albums</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$albumphotos</td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Posts in Albums</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$albumposts</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">ECards in Queue</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$totalecards</td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Awaiting Approval</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$waiting</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">Total Views</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$totalviews</td>
        </tr>
        </table>
        <br />";

    $output .= "<table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"90%\">
        <tr><td class=\"{$Style['menubar']}\" align=\"center\" colspan=\"4\">
        <span class=\"{$Style['medium']}\">Online Users</span></td></tr>";

    $ousers = ppmysql_query("SELECT userid,ipaddr,date,what FROM {$Globals['pp_db_prefix']}iponline ORDER BY date ASC", $link);

    while ( list( $ouser, $oip, $odate, $owhat ) = mysql_fetch_row($ousers) )
    {
        $odate = $odate + ($User['offset'] * 3600) + ($Globals['gmtoffset'] * 3600);

        if ( strstr($owhat, "adm-") )
        {
            $owhat = "Administrative Pages";
        }

        $output .= "<tr>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$ouser</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$oip</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">".date("F j, Y, g:i a",$odate)."</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$owhat</td>
            </tr>";
    }
    $output .= "</table><br />";

    $output .= "<table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"90%\">
        <tr><td class=\"{$Style['menubar']}\" align=\"center\" colspan=\"4\">
        <span class=\"{$Style['medium']}\">Last 20 Actions in Admin Log</span></td></tr>";

    $admlog = ppmysql_query("SELECT adminuser,ip,datestamp,description FROM {$Globals['pp_db_prefix']}admlog ORDER BY datestamp DESC LIMIT 20", $link);

    while ( list( $ouser, $oip, $odate, $owhat ) = mysql_fetch_row($admlog) )
    {
        $odate = $odate + ($User['offset'] * 3600) + ($Globals['gmtoffset'] * 3600);

        $output .= "<tr>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$ouser</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$oip</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">".date("F j, Y, g:i a",$odate)."</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$owhat</td>
            </tr>";
    }

    $output .= "</table><br /><a href=\"{$Globals['maindir']}/adm-misc.php?admact=admlog\">Click here to see the whole Admin Log!</a><br />";

    if ( $User['adminedit'] == 1 )
    {
        $output .= "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=admlog&amp;clear=yes\">Clear Admin Log!</a><br />";
    }

    $output .= "<br /></td></tr></table></td></tr></table>";
    print "$output<p><p>";

    adminfooter();
}

//
// ADM-DB
//

if ( $admact == "dbops" )
{
    // because this script can take a long time, we need to disable compression
    $disableforadmin = 1;

    require "image-inc.php";

    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ( !isset($okay) ) $okay = "no";
    if ( !isset($ppaction) ) $ppaction = null;
    if ( !isset($start) ) $start = 0;
    if ( !isset($watermark) ) $watermark = "no";
    if ( !isset($counts) ) $counts = "no";
    if ( !isset($fixthumbs) ) $fixthumbs = "no";
    if ( !isset($scanexif) ) $scanexif = "no";
    if ( !isset($allthumbs) ) $allthumbs = "no";
    if ( !isset($allmedium) ) $allmedium = "no";
    if ( !isset($cleanup) ) $cleanup = "no";
    if ( !isset($updateowner) ) $updateowner = "no";
    if ( !isset($lastphoto) ) $lastphoto = "no";
    if ( !isset($category) ) $category= null;

    if ($okay != "yes")
    {
        catmoveopt(0);

        adminheader( 0, "PhotoPost Database" );

echo<<<PPPRINT
            <div align="center">
            <table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}" width="{$Globals['tablewidth']}" align="center">
            <tr><td>
            <table cellpadding="2" cellspacing="1" border="0"  width="100%">
            <tr>
            <td colspan="4" align="left" class="{$Style['menubar']}">
            <span class="{$Style['large']}"><b>PhotoPost Database Administration</span>
            </td>
            </tr><tr>
            <td class="{$Style['tddetails']}"><div align="center"><br />

            Any work on your database and directory should involve a backup.<br />
            Many actions performed here cannot be undone (watermarking especially).<br /><br /><a href="{$Globals['maindir']}/adm-misc.php?admact=backup">Click here to backup your database!</a><br /><br />

            <form action="{$Globals['maindir']}/adm-misc.php" method="POST">
            <table cellpadding="2" cellspacing="1" border="1">
            <tr><td class="{$Style['menubar']}" align="center" width="50">
            Options</span></td>
            <td class="{$Style['menubar']}" align="center">Description<br />
            </span></td></tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="fixthumbs"></td>
            <td class="{$Style['tddetails']}" align="center">Check for and create missing thumbnails.</span></td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="allthumbs"></td>
            <td class="{$Style['tddetails']}" align="center">Rebuild all thumbnails.</span></td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="allmedium"></td>
            <td class="{$Style['tddetails']}" align="center">Rebuild all medium images.</span></td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="watermark"></td>
            <td class="{$Style['tddetails']}" align="center">Check here to watermark unwatermarked files.<br />
            <b>This action cannot be undone - backup your data directory and photos database!</b></td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="counts"></td>
            <td class="{$Style['tddetails']}" align="center">Check here to recalculate photos/posts numbers and check children.</td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="scanexif"></td>
            <td class="{$Style['tddetails']}" align="center">Check here to rescan photos and save EXIF information.</td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="cleanup"></td>
            <td class="{$Style['tddetails']}" align="center">Check here to scan for duplicate entries for same photo.</td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="updateowner"></td>
            <td class="{$Style['tddetails']}" align="center">Check here to resync photo/comments usernames/update comments counts.</td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="lastphoto"></td>
            <td class="{$Style['tddetails']}" align="center">Check here to update your user table last photo field.</td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" width="50">
            <input type="checkbox" value="yes" name="catavatar"></td>
            <td class="{$Style['tddetails']}" align="center">Reset your category avatars to the first photo uploaded in the catgeory.</td>
            </tr>
            <tr>
            <td class="{$Style['tddetails']}" align="center" colspan="2"><span class="{$Style['small']}">Actions can be applied to select categories or all<br />
                <select name="category"><option value="all">all categories</option><option value="albums">albums only</option>$catoptions</select>
            </td>
            </tr>
            </table><br /><br />
            <input type="hidden" name="okay" value="yes">
            <input type="hidden" name="ppaction" value="scandb">
            <input type="hidden" name="admact" value="dbops">
            <input type="submit" value="Perform Tasks"></form></td></tr></table></td></tr></table>
PPPRINT;

        exit;
    }

    $count = 0;
    $tname = array();

    if ( $ppaction == "scandb" )
    {
        // We dont want formatted error pages
        $Globals['texterrors'] = 1;
        adminheader( 0, "PhotoPost Database" );

        print "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\" width=\"{$Globals['tablewidth']}\" align=\"center\">
            <tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr><td class=\"{$Style['tddetails']}\">
            Processing may take a while... please be patient and wait the for FINISHED message...<br /><br />";

        flush();

        $extracat = null;

        if ( $category > 0 )
        {
            $extracat = "AND p.cat=$category";
        }
        elseif ( $category == "albums" )
        {
            $extracat = "AND c.cattype='a'";
        }

        if ( $fixthumbs == "yes" || $allthumbs == "yes" || $watermark == "yes" || $scanexif == "yes" || $allmedium == "yes" || $updateowner == "yes" )
        {
            $queryv = ppmysql_query("SELECT p.id,p.user,p.userid,p.cat,p.bigimage,p.medsize,p.storecat,p.watermarked FROM {$Globals['pp_db_prefix']}photos p LEFT JOIN {$Globals['pp_db_prefix']}categories c ON c.id=p.cat WHERE p.id > $start $extracat ORDER BY p.id", $link);
            $stoponerror = 0;
            $maxcount = 200;

            while ( list( $id, $user, $tuserid, $cat, $bigimage, $medsize, $storecat, $wmarked ) = mysql_fetch_row($queryv) )
            {
                print "Checking photo #$id: ";

                if ( $storecat != 0 )
                {
                    $cat = $storecat;
                }

                if ( !is_dir("{$Globals['datafull']}$cat/thumbs") )
                {
                    @mkdir( "{$Globals['datafull']}$cat/thumbs" );
                    @chmod( "{$Globals['datafull']}$cat/thumbs", 0777 );
                    $fd = fopen( "{$Globals['datafull']}$cat/thumbs/index.htm", "w+" );
                    fclose($fd);
                }

                if ( !is_dir("{$Globals['datafull']}$cat/medium") )
                {
                    @mkdir( "{$Globals['datafull']}$cat/medium" );
                    @chmod( "{$Globals['datafull']}$cat/medium", 0777 );
                    $fd = fopen( "{$Globals['datafull']}$cat/medium/index.htm", "w+" );
                    fclose($fd);
                }

                if ( !is_dir("{$Globals['datafull']}$cat/mini") )
                {
                    @mkdir( "{$Globals['datafull']}$cat/mini" );
                    @chmod( "{$Globals['datafull']}$cat/mini", 0777 );
                    $fd = fopen( "{$Globals['datafull']}$cat/mini/index.htm", "w+" );
                    fclose($fd);
                }

                $newthumblink = "{$Globals['datafull']}$cat/thumbs/$bigimage";
                $imagelink = "{$Globals['origfull']}$cat/$bigimage";
                $bigimage = "$bigimage";

                $fullsize = @filesize( $imagelink );
                $thumbsize = @filesize( $newthumblink );

                // lets make sure permissions are set
                if ( !file_exists( $imagelink ) )
                {
                    print "image $imagelink not found, removing from database...";

                    $queryi = "DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$id";
                    $queryid = ppmysql_query($queryi, $link);
                }
                else
                {
                    @chmod ($imagelink, 0666);

                    if ( $fixthumbs == "yes" || $allthumbs == "yes" )
                    {
                        // if rebuilding all thumbs, remove them to force a new one
                        if ( $allthumbs == "yes" )
                        {
                            @unlink( $newthumblink );
                        }

                        if ( !file_exists( $newthumblink ) )
                        {
                            if ( !is_multimedia($newthumblink) )
                            {
                                if ( file_exists( $imagelink ) )
                                {
                                    print "rebuilding $newthumblink from $imagelink ...";
                                    $maxcount = 25;

                                    // create thumbnail
                                    $holduserid = $User['userid'];
                                    $User['userid'] = $tuserid;

                                    $thumbsize = create_thumb( $bigimage, $imagelink, $cat, "rebuildthumbnail" );

                                    if ( !file_exists( $newthumblink ) )
                                    {
                                        print " <b>failed!</b> ";
                                        $stoponerror = 1;
                                    }
                                    else
                                    {
                                        print " completed! ";
                                    }

                                    $count++;
                                    $User['userid'] = $holduserid;
                                }
                                else
                                {
                                    print "- removing database entry with no image: $imagelink";
                                    $querydr = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos where id=$id", $link);
                                    continue;
                                }
                            }
                            else
                            {
                                if ( file_exists($Globals['ffmpeg']) )
                                {
                                    $vidwidth = $Globals['previewwidth'];
                                    $vidheight1 = ( $Globals['previewwidth'] / 4 );
                                    $vidheight2 = round( $vidheight1 * 3 );
                                    $vidheight3 = $vidheight2;

                                    if ($vidheight2 % 2)
                                    {
                                        $vidheight3 = $vidheight2 + 1;
                                    }
			            else
			            {
			    	        $vidheight3 = $vidheight2;
			   	    }

                                    $filenoext = get_filename( $newthumblink );
                                    $thumbnail = "{$filenoext}.jpg";
                                    $outthumb = "{$Globals['datafull']}$cat/thumbs/$thumbnail";
                                    $syscmd = "\"{$Globals['ffmpeg']}\" -i $filepath -t 0.001 -ss 4 -vframes 1 -f mjpeg -s {$vidwidth}x{$vidheight3} $outthumb";
                                    $status = exec($syscmd);
                                }
                            }
                        }
                    }

                    if ( $allmedium == "yes" )
                    {
                        print "checking medium... ";
                        $medfile = "{$Globals['datafull']}$cat/medium/$bigimage";

                        //#// create a medium sized graphic if the graphic is too big or if not exist###
                        $createmed = 0;
                        $biggraphic = $Globals['biggraphic'];

                        $image_stats = getimagesize( $imagelink );
                        $imagewidth = $image_stats[0];
                        $imageheight = $image_stats[1];

                        if ( $Globals['bigsave'] == "yes" && $biggraphic > 0 )
                        {
                            if ( $imagewidth > $biggraphic || $imageheight > $biggraphic )
                            {
                                $createmed = 1;
                            }
                        }

                        if ( $createmed == 1 )
                        {
                            print "creating... ";
                            $maxcount = 25;

                            if ( $imageheight > $imagewidth )
                            {
                                $scaleFactor = $imageheight / $biggraphic;
                                $medwidth = round( $imagewidth / $scaleFactor );
                                $medheight = $biggraphic;
                            }
                            else
                            {
                                $scaleFactor = $imagewidth / $biggraphic;
                                $medheight = round( $imageheight / $scaleFactor );
                                $medwidth = $biggraphic;
                            }

                            if ( $Globals['usegd'] != 0 )
                            {
                                $resize_worked = resize_jpeg($imagelink, $medfile, $medwidth, $medheight);
                            }
                            else {
                                @unlink($medfile);
                                copy( $imagelink, $medfile );
                                @chmod ($medfile, 0666);

                                if( !stristr(PHP_OS, "win") )
                                {
                                    $shellmed = escapeshellarg($medfile);
                                }
                                else
                                {
                                    $shellmed = $medfile;
                                }

                                $syscmd = "\"{$Globals['mogrify_command']}\" -quality {$Globals['imgquality']} -geometry {$medwidth}x{$medheight} $shellmed";
                                // call ImageMagick mogrify to create the {$Style['medium']} image
                                $retval = fs_exec($syscmd);

                                if ( $retval != 0  )
                                {
                                    print "failed...";
                                }
                                else
                                {
                                    print "completed...";
                                }
                            }

                            $count++;

                            // Update medium image size in db
                            $medsize = @filesize( $medfile );
                            $queryid = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET medwidth='$medwidth',medheight='$medheight',medsize='$medsize' where id=$id", $link);
                        }
                        else
                        {
                            if ( $medsize > 0 )
                            {
                                @unlink($medfile);
                                $queryid = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET medsize=0 where id=$id", $link);
                            }

                            print "not needed...";
                        }
                    }


                    // watermarks?
                    if ( $watermark == "yes" && $wmarked == "no" )
                    {
                        if ( is_image($imagelink) )
                        {
                            $maxcount = 25;

                            print " watermarking: $imagelink<br />";

                            watermark( $imagelink, $cat, "" );

                            $medwater = "{$Globals['datafull']}$cat/medium/$bigimage";

                            if ( file_exists( $medwater ) )
                            {
                                print " - watermarking: $medwater ";
                                watermark( $medwater, $cat, "" );
                            }

                            $watermarked = 1;
                            $count++;
                        }
                    }

                    if ( $scanexif == "yes" )
                    {
                        $exifinfo = null;
                        $maxcount = 25;

                        $exifinfo = readexifinfo( $imagelink, $filename );

                        print " - checking for exif";

                        if ( $exifinfo )
                        {
                            if ( count($exifinfo) > 6 )
                            {
                                $storeexif = addslashes(serialize($exifinfo));
                                print " - exif info added";
                                $resultc = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}exif values( $id, '$storeexif' )", $link);
                            }
                            else
                            {
                                print " (none)";
                            }
                        }
                        else
                        {
                            print " (none)";
                        }
                        $count++;
                    }

                    // now lets make sure we have the right username for the photo
                    if ( !isset($tname[$tuserid]) )
                    {
                        if ( $tuserid != 0 )
                        {
                           list( $tid, $tmpname, $tmail ) = get_userinfo("", $tuserid);
                           $tname[$tuserid] = addslashes($tmpname);
                        }
                        else
                        {
                           $tname[$tuserid] = addslashes($Globals['pp_lang']['unreg']);
                        }
                    }

                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET user='{$tname[$tuserid]}', watermarked='$watermarked' WHERE id=$id", $link);
                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}comments SET username='{$tname[$tuserid]}' WHERE userid=$tuserid", $link);

                    // Get the last comment data
                    if ( $Globals['dispempty'] == "yes" )
                    {
                        $querya = "SELECT id,username,date FROM {$Globals['pp_db_prefix']}comments WHERE photo=$id ORDER BY date DESC";
                    }
                    else
                    {
                        $querya = "SELECT id,username,date FROM {$Globals['pp_db_prefix']}comments WHERE photo=$id AND LENGTH(comment) > 1 ORDER BY date DESC";
                    }

                    $queryz = ppmysql_query($querya, $link);
                    list( $lastid, $lastposter, $lastdate ) = mysql_fetch_row($queryz);

                    $comcount = mysql_num_rows($queryz);
                    $lastposter = addslashes($lastposter);

                    $queryid = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET numcom='$comcount', lastposter='$lastposter', lastpost='$lastdate', lastpid='$lastid' WHERE id=$id", $link);
                }

                // To prevent timeouts only allow 25 system calls/imaging calls per page (200 otherwise)
                if ( $count > $maxcount )
                {
                    $fwdlink = "{$Globals['maindir']}/adm-misc.php?ppaction=scandb&admact=dbops&okay=yes&fixthumbs=$fixthumbs&allthumbs=$allthumbs&allmedium=$allmedium&watermark=$watermark&counts=$counts&scanexif=$scanexif&start=$id&category=$category";

                    echo "<br /> <a href=\"$fwdlink\">Click here</a> if the page does not refresh or to continue after reviewing errors.";

                    if ( $stoponerror == 0 )
                    {
                        echo "<script language=\"javascript\">window.location=\"$fwdlink\";</script>";
                    }

                    echo "</td></tr></table></td></tr></table>";
                    exit;
                }

                print " done.<br />";
            }

            ppmysql_free_result( $queryv );
        }

        if ( $counts == "yes" )
        {
            print "<br />Preparing to update categories with photo and posts information...<br />";
            upgradecategories(0);

            print "<p>Preparing to update personal albums with photo and posts information...<br />";
            upgradealbums(0);
            @flush();
        }

        if ( $catavatar == "yes" )
        {
            $ecatonly = null;

            if ( $category > 0 )
            {
                $ecatonly = "WHERE cat=$category";
            }
            elseif ( $category == "albums" )
            {
                $ecatonly = "WHERE cattype='a'";
            }

            $resulta = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}categories $ecatonly", $link);
            while ( list( $cid ) = mysql_fetch_row($resulta) )
            {
                $resultb = ppmysql_query("SELECT id FROM {$Globals['pp_db_prefix']}photos WHERE cat=$cid ORDER BY date ASC LIMIT 1", $link);
                list( $firsth ) = mysql_fetch_row($resultb);

                if ( $firsth )
                {
                    ppmysql_query("UPDATE {$pp_db_prefix}categories SET thumbnail=$firsth WHERE id=$cid", $link);
                }
            }
        }

        if ( $cleanup == "yes" )
        {
            $dqueryv = ppmysql_query("SELECT p.id,p.user,p.userid,p.cat,p.bigimage FROM {$Globals['pp_db_prefix']}photos p LEFT JOIN {$Globals['pp_db_prefix']}categories c ON c.id=p.cat WHERE p.storecat=0 $extracat ORDER BY p.userid,p.bigimage,p.id", $link);

            $lastimg = null;
            $lastuser = 0;

            while ( list( $id, $user, $tuserid, $cat, $bigimage ) = mysql_fetch_row($dqueryv) )
            {
                if ( !strcmp($lastimg, $bigimage) && $userid == $lastuser )
                {
                    echo "Removing matched entry: $bigimage [$id:<b>$previd</b>]<br>";
                    $ddquery = "DELETE from {$Globals['pp_db_prefix']}photos WHERE id='$id'";
                    $ddqueryv = ppmysql_query($ddquery, $link);
                }

                $lastimg = $bigimage;
                $lastuser = $userid;
                $previd = $id;
            }
        }

        if ( $lastphoto == "yes" )
        {
            ppmysql_query("UPDATE {$pp_db_prefix}users SET lastphoto=0,lastdate=0", $link);

            $resulta = ppmysql_query("SELECT userid FROM {$pp_db_prefix}photos WHERE userid > 0", $link);
            while ( list( $puser ) = mysql_fetch_row($resulta) )
            {
                $resultb = ppmysql_query("SELECT id,user,date FROM {$pp_db_prefix}photos WHERE userid=$puser ORDER BY date DESC LIMIT 1", $link);

                while ( list( $pid, $pname, $pdate) = mysql_fetch_row($resultb) )
                {
                    $resultc = ppmysql_query("SELECT userid FROM {$pp_db_prefix}users WHERE userid=$puser LIMIT 1", $link);
                    list ( $checkid ) = mysql_fetch_row($resultc);

                    if ( $checkid )
                    {
                        $resultd = ppmysql_query("UPDATE {$pp_db_prefix}users SET lastphoto=$pid,lastdate=$pdate WHERE userid=$puser", $link);
                    }
                    else
                    {
                        $pname = addslashes($pname);
                        $resultd = ppmysql_query("INSERT INTO {$pp_db_prefix}users (userid,username,lastphoto,lastdate) VALUES ($puser,'$pname',$pid,$pdate)", $link);
                    }
                }
            }
        }

        adminlog( "Ran a Scan DB" );

        print "<br /><b>Finished!<br /><br /><a href=\"{$Globals['maindir']}/adm-index.php\">click here</a> to return to admin</b></td></tr></table></td></tr></table>";
    }
    exit;
}


//
// ADM-MOVE
//

if ( $admact == "move" )
{
    if ( $User['adminedit'] == 0 && $User['moderator'] == 0 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ($_POST['ppaction'] == "move")
    {
        if ( !is_numeric($origcat) || !is_numeric($catmove) || $origcat == $catmove )
        {
            diewell( "Categories not selected properly. Please go back and try again." );
        }

        // Just to be safe, dont want it to timeout
        ini_set("max_execution_time", 0);

        $images_moved = 0;
        $resulta = ppmysql_query("SELECT id,userid,cat,bigimage FROM {$Globals['pp_db_prefix']}photos WHERE cat=$origcat", $link);

        while ( list( $pid, $puserid, $thecat, $filename ) = mysql_fetch_row($resulta) )
        {
            move_image_cat( $pid, $catmove, "no" );
            $images_moved++;
        }

        $from_cat = get_catname( $origcat );
        $to_cat = get_catname( $catmove );

        $ipaddr = findenv("REMOTE_ADDR");
        $date = time();
        $what = "$images_moved images moved from '$from_cat' to '$to_cat'";
        $what = addslashes($what);
        $username = addslashes($User['username']);
        $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}admlog (adminuser,ip,datestamp,description) VALUES ('$username','$ipaddr','$date','$what')", $link);

        upgradecategories($origcat);
        upgradecategories($catmove);

        forward( "adm-misc.php?admact=mainmenu", "$images_moved images moved from '$from_cat' to '$to_cat'" );
    }

    catmoveopt(0);
    adminheader( 0, "PhotoPost Bulk Move" );

    print "<div align=\"center\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
        align=\"center\"><tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Bulk Move Images</b></span></td>
        </tr><tr>
        <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">$adminmenu</span></td></tr>
        <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
        You are about to move all images from one category to another. This will move all images and update your database. Use carefully!<br /><br />
        <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\">
        Category you wish to move? <select name=\"origcat\" style=\"font-size: 9pt; background: FFFFFF;\">
        <option selected=\"selected\"></option>$catoptions</select>
        <br /><br />Category you wish to move to?
        <select name=\"catmove\" style=\"font-size: 9pt; background: FFFFFF;\">
        <option selected=\"selected\"></option>$catoptions</select>
        <input type=\"hidden\" name=\"ppaction\" value=\"move\">
        <input type=\"hidden\" name=\"admact\" value=\"move\">
        <br /><input type=\"submit\" value=\"Select options and click to move photos.\"></form>
        </div></td></tr></table></td></tr></table><br /><br />";

    adminfooter();
    exit;
}

//
// ADM-BACKUP
//

if ( $admact == "backup" )
{
    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    // Generate the edit categories HTML form
    adminheader( 0, "PhotoPost Backup Admin" );

    print "<div align=\"center\">
        <br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Database Backup</b></span></td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"left\">";

    if ( !isset($table) )
    {
        print "<table width=\"80%\" align=\"center\"><tr><td colspan=\"2\">";
        print "You can backup tables individually or all of them at one. You should set your gallery to <b>CLOSED</b> in your config-inc.php file while doing a backup.<br /><br />Note: Backup uses the mysqldump command, so make sure that the path to this command is set properly below (this is set in the config file). {$Style['large']} databases may timeout if you do them all at once and you may need to backup tables individually. MySQL 4.x requires that the database user that your gallery is using has LOCK TABLES permissions.<br /><br />";

        print "Path to mysqldump: <i>{$Globals['mysqldumppath']}</i><br />";
        print "Directory to store backups: <i>{$Globals['backupdir']}</i><br /><br />";
        print "</td></tr>";

        $link = mysql_connect("$host:3306", "$mysql_user", "$mysql_password") or die ("I cannot connect to the PhotoPost database. [$php_errormsg]");
        mysql_select_db("$database", $link)or die("Could not connect to PhotoPost database". mysql_error() );

        $tables = mysql_list_tables($database);

        while (list($table) = mysql_fetch_array($tables))
        {
            print "<tr><td width=\"15%\">$table</td>";
            print "<td><a href=\"{$Globals['maindir']}/adm-misc.php?admact=backup&amp;table=$table\">Backup</a></td></tr>";
        }
        print "<tr><td colspan=\"2\"><br /><a href=\"{$Globals['maindir']}/adm-misc.php?admact=backup&amp;table=all\">Backup ALL tables</a></td></tr></table>";
    }
    else
    {
        print "<br />";

        if ( $table != "all" )
        {
            $tables[0] = $table;
        }
        else
        {
            $i = 0;

            $link = mysql_connect("$host:3306", "$mysql_user", "$mysql_password") or die ("I cannot connect to the PhotoPost database. [$php_errormsg]");
            mysql_select_db("$database", $link)or die("Could not connect to PhotoPost database". mysql_error() );

            $dbtables = mysql_list_tables($database);
            while(list($table) = mysql_fetch_array($dbtables))
            {
                $tables[$i] = $table;
                $i++;
            }
        }

        $dumpcmd = "{$Globals['mysqldumppath']} --opt -h $host -u$mysql_user -p$mysql_password $database";

        print "Command being used to execute dumps (specific tables are executed individually):<br /><br /><i>$dumpcmd</i><br /><br />";
        print "Results:<br /><br />";

        foreach($tables as $tablename)
        {
            $tablename = escapeshellcmd($tablename);
            $thedumpcmd = $dumpcmd . "$tablename > {$Globals['backupdir']}/$tablename.sql";
            system($thedumpcmd);

            $size = filesize("{$Globals['backupdir']}/$tablename.sql");
            if (!$size)
            {
                print "<b>Warning: <b>$tablename.sql</b> is 0 bytes or did not get created.</b>";
            }
            else
            {
                print "<b>$tablename</b> has been backed up.<br>";
            }
        }

        adminlog( "Performed a database backup" );

        print "<br /><br /><i>You should double-check your .sql files to be sure the backup completed successfully.</i>";
    }

    print "</td></tr></table></td></tr></table><br />";
    adminfooter();
    exit;
}

//
// ADM-LOG
//

if ( $admact == "admlog" )
{
    if ( $User['adminedit'] == 0 && $User['moderator'] == 0 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ( isset($clear) && $User['adminedit'] == 1 )
    {
        if ( $clear == "yes" )
        {
            $cleardb = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}admlog", $link);
            adminlog( "Admin Log Reset" );
            forward( "adm-misc.php?admact=mainmenu", "Admin Log Cleared!" );
        }
    }

    adminheader( 0, "PhotoPost Admin Log Administration" );

    $output = "<div align=\"center\">
         <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\">
        <span class=\"{$Style['large']}\"><b>PhotoPost Administration</span>
        </td>
        </tr>
        <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />";

    if ( $User['adminedit'] == 1 )
    {
        $output .= "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=admlog&amp;clear=yes\">Clear Admin Log!</a><br />";
    }

    $output .= "<br /><table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"90%\">
        <tr><td class=\"{$Style['menubar']}\" align=\"center\" colspan=\"4\">
        <span class=\"{$Style['medium']}\">Actions in Admin Log</span></td></tr>";

    $admlog = ppmysql_query("SELECT adminuser,ip,datestamp,description FROM {$Globals['pp_db_prefix']}admlog ORDER BY datestamp DESC", $link);

    while ( list( $ouser, $oip, $odate, $owhat ) = mysql_fetch_row($admlog) )
    {
        $output .= "<tr>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$ouser</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$oip</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">".date("F j, Y, g:i a",$odate)."</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\" width=\"25%\">$owhat</td>
            </tr>";
    }
    $output .= "</table><br />";

    if ( $User['adminedit'] == 1 )
    {
        $output .= "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=admlog&amp;clear=yes\">Clear Admin Log!</a><br />";
    }

    $output .= "<br /></td></tr></table></td></tr></table>";

    print "$output<p><p>";
    adminfooter();

    exit;
}

//
// ADM-PURGE
//

if ( $admact == "purge" )
{
    if ( $User['adminedit'] == 0 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ($_POST['ppaction'] == "purge")
    {
        if ( !isset($cat) )
        {
            $cat=0;
        }

        $images_moved = 0;
        $catq = null;

        if ( !isset($photoage) || !is_numeric($photoage) || !is_numeric($cat) )
        {
            diewell( "No photo age selected or invalid call to purge" );
        }

        if ( $cat != 0 )
        {
            $catq = "AND cat = '$cat'";
        }

        list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();
        $mon = $mon + 1;
        $year = $year + 1900;

        $mday -= $photoage;
        $cutoff = mktime($hour,$min,$sec,$mon,$mday,$year);

        $resulta = ppmysql_query("SELECT id,userid,cat,medsize,bigimage FROM {$Globals['pp_db_prefix']}photos WHERE date < $cutoff $catq", $link);

        while ( list( $pid, $puserid, $thecat, $medsize, $filename ) = mysql_fetch_row($resulta) )
        {
            if ( $filename != "" )
            {
                remove_all_files( $filename, $medsize, $puserid, $thecat );
            }

            $query = "DELETE FROM {$Globals['pp_db_prefix']}photos WHERE id=$pid";
            $resultb = ppmysql_query($query, $link);

            $query = "DELETE FROM {$Globals['pp_db_prefix']}exif WHERE photoid=$pid";
            $resultb = ppmysql_query($query, $link);

            $query = "DELETE FROM {$Globals['pp_db_prefix']}comments WHERE photo=$pid";
            $resultb = ppmysql_query($query, $link);

            $query = "DELETE FROM {$Globals['pp_db_prefix']}notify WHERE photo=$pid";
            $resultb = ppmysql_query($query, $link);

            $images_moved++;
        }

        upgradecategories($thecat);

        $ipaddr = findenv("REMOTE_ADDR");
        $date = time();
        $what = "$images_moved images purged ($photoage)";
        $what = addslashes($what);
        $username = addslashes($User['username']);
        $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}admlog (adminuser,ip,datestamp,description) VALUES ('$username','$ipaddr','$date','$what')", $link);

        forward( "adm-misc.php?admact=mainmenu", "$images_moved images purged" );
    }

    adminheader( 0, "PhotoPost Photo Purge" );

    if ( isset($_POST['confirm']) )
    {
        if ( !isset($photoage) || !is_numeric($photoage) || !is_numeric($cat) )
        {
            diewell( "No photo age selected or invalid call to purge" );
        }

        list($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();
        $mon = $mon + 1;
        $year = $year + 1900;

        $mday -= $photoage;
        $cutoff = mktime($hour,$min,$sec,$mon,$mday,$year);

        $catq = null;

        if ( !isset($cat) )
        {
            diewell( "Script called without a category selected.");
        }

        if ( $cat != 0 )
        {
            $catq = "AND cat = '$cat'";
        }

        $resulta = ppmysql_query("SELECT id,userid,cat,medsize,bigimage FROM {$Globals['pp_db_prefix']}photos WHERE date < $cutoff $catq", $link);
        $effected = mysql_num_rows($resulta);

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
            align=\"center\"><tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr>
            <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Purge Images</b></span></td>
            </tr><tr>
            <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">$adminmenu</span></td></tr>
            <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
            You are about to purge images which were uploaded more than $photoage days ago.<br /><br />
            <b>$effected images will be removed!</b><br /><br />
            <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\">
            To execute this, click SUBMIT below. This action cannot be undone.<br />
            <input type=\"hidden\" name=\"ppaction\" value=\"purge\">
            <input type=\"hidden\" name=\"admact\" value=\"purge\">
            <input type=\"hidden\" name=\"cat\" value=\"$cat\">
            <input type=\"hidden\" name=\"photoage\" value=\"$photoage\">
            <br /><input type=\"submit\" value=\"Purge Those Files!\"></form><br /></span></td></tr></table></td></tr></table>";
    }
    else
    {
        catmoveopt(0);

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
            align=\"center\"><tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr>
            <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Purge Images</b></span></td>
            </tr><tr>
            <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">$adminmenu</span></td></tr>
            <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
            You are about to purge images and related content from your database. Use carefully!<br /><br />Enter the number of days
            from which to keep photos (photos uploaded before this will be removed).<br /><br />
            <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\">
            Number of days to keep? <input type=\"text\" name=\"photoage\"><br /><br />
            Category you wish to purge? <select name=\"cat\" style=\"font-size: 9pt; background: FFFFFF;\">
            <option value=\"0\" selected=\"selected\">All categories</option>$catoptions</select>
            <input type=\"hidden\" name=\"confirm\" value=\"confirm\">
            <input type=\"hidden\" name=\"admact\" value=\"purge\">
            <br /><br /><input type=\"submit\" value=\"Submit\"></form><br /></span></td></tr></table></td></tr></table>";
    }
    print "$output<br /><br />";
    adminfooter();

    exit;
}

//
// ADM-PA
//

if ( $admact == "albums" )
{
    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ( empty($catid) )
    {
        $catid = null;
    }

    // Generate the edit categories HTML form
    adminheader( 0, "PhotoPost Personal Album Admin" );

    $output = "<div align=\"center\">

        <p><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
        align=\"center\"><tr><td class=\"{$Style['tddetails']}\">
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td align=\"left\" class=\"{$Style['menubar']}\" colspan=\"3\"><span class=\"{$Style['large']}\"><b>PhotoPost Personal Album Editor</span></td>
        </tr>";

    $whosup = -1;
    $albums = ppmysql_query("SELECT id,catname,parent FROM {$Globals['pp_db_prefix']}categories WHERE cattype='a' ORDER BY parent", $link);

    while ( list( $id, $albumname, $parent ) = mysql_fetch_row($albums) )
    {
        if ( $parent != $whosup )
        {
            list( $tuserid, $tusername, $temail ) = get_userinfo("", $parent);

            $output .= "<tr><td class=\"{$Style['alternatetable']}\" colspan=\"3\" align=\"left\"><a href=\"mailto:$temail\">$tusername</a></td></tr>";

            $output .= albumli($parent, 1);
            $whosup = $parent;
        }
    }

    $output .= "</table><p><div align=\"center\"></td></tr></table></td></tr></table>";

    print "$output<p><p>";
    adminfooter();
}

//
// ADM-TEMPL
//

if ( $admact == "tmpl" )
{
    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    require"config-int.php";

    $Globals['TMPL_PATH'] = $TMPL_PATH;

    if ( $Globals['vbversion'] == "xenforo" && $Globals['forumstyle'] == "yes" )
    {
            $Globals['TMPL_PATH'] .= "/xenforo";
    }

    if ( VB3_INTEGRATION == "on" )
    {
        if ( defined('SIMPLE_VERSION') && SIMPLE_VERSION >= "400" )
        {
            $Globals['TMPL_PATH'] .= "/vb4enhanced";
        }
        else
        {
            $Globals['TMPL_PATH'] .= "/vb3enhanced";
        }
        if ( is_dir( "{$Globals['TMPL_PATH']}/$styleid" ) )
        {
            $Globals['TMPL_PATH'] = "{$Globals['TMPL_PATH']}/$styleid";
        }
    }

    // Generate the edit categories HTML form
    adminheader( 0, "PhotoPost Template Admin" );

    print "<div align=\"center\">
        <br /><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Edit Template</b></span></td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\">";

    if ( !isset($template) )
    {
        print "<table width=\"80%\" align=\"center\"><tr><td><form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\">";
        print "Select the template you wish to edit.<br /><br />";
        print "<select name=\"template\" class=\"{$Style['formboxes']}\" size=\"15\">";

        $dir = opendir("{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}");

        $filename = array();

        while ($file = readdir($dir))
        {
          if ($file == "." || $file == ".." || !stristr($file,"tmpl") ) { continue; }
          $filename[] = $file;
        }

        sort($filename);
        closedir($dir);
        $numtemp = sizeof($filename);

        for ( $x=0; $x < $numtemp; $x++)
        {
          print "<option>$filename[$x]</option>";
        }

        print "</select><br /><input type=\"hidden\" name=\"admact\" value=\"tmpl\">
               <input type=\"submit\" value=\"Edit Template\"></form>";
        print "<br /></td></tr></table></td></tr></table>";
    }
    else
    {
        if ( !isset($final) )
        {
            $final = "no";
        }

        if ( $final == "yes" )
        {
            $body = (ini_get("magic_quotes_gpc")) ? stripslashes($body) : $body;
            $body = preg_replace("/\r/","",convert_html(stripslashes($body)));
            $bodylines = split("\n",$body);

            $numlines = sizeof($bodylines);
            $newtmpl = null;

            for ($i=0; $i<$numlines; $i++)
            {
                $line = $bodylines[$i];
                $line = str_replace("textareahtml","textarea",$line);
                $line = str_replace("&amp;amp;","&amp;",$line);
                $line = str_replace("&amp;nbsp;","&nbsp;",$line);
                $line = str_replace("[img]","&#091;img&#093;",$line);
                $line = str_replace("[/img]","&#091;/img&#093;",$line);
                $line .="\r\n";
                $newtmpl .= $line;
            }

            if ( strstr($template, "..") )
            {
                print "Error in template format: $template";
                exit;
            }

            $fd = fopen("{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/$template","w");

            if ( !$fd )
            {
                print "<br />Unable to write changes, permissions on $template are not set properly.<br />";
                print "<br /></td></tr></table></td></tr></table>";
                exit;
            }
            fwrite($fd, $newtmpl);
            fclose($fd);

            adminlog( "Edit Template: $template" );

            print "<br />Template $template saved.<br />";
            print "<br /></td></tr></table></td></tr></table>";
        }
        else
        {
            print "Use the box below to edit this template.<br /><br />
            <b>TEXTAREA</b> tags have been renamed <b>TEXTAREAHTML</b> to prevent the edit box from breaking (will be converted back when saved).<br /><br />
            <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\">
            <input type=\"hidden\" name=\"final\" value=\"yes\">
            <input type=\"hidden\" name=\"admact\" value=\"tmpl\">
            <input type=\"hidden\" name=\"template\" value=\"$template\">
            <textarea name=\"body\" cols=\"100\" rows=\"20\" class=\"{$Style['formboxes']}\">";

            $tempfile = file("{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}/$template");
            while (list($linenum,$line) = each($tempfile))
            {
                $line = str_replace("&amp;","&amp;amp;",$line);
                $line = str_replace("&nbsp;","&amp;nbsp;",$line);
                $line = str_replace("textarea","textareahtml",$line);
                print "$line";
            }

            print "</textarea><br /><br /><input type=\"submit\" value=\"Update $template\" class=\"buttons\"></form>";
            print "<br /></td></tr></table></td></tr></table>";
        }
    }

    adminfooter();
    exit;
}

//
// ADM-CFGEDIT
//

if ( $admact == "config" )
{
    if ( $User['adminedit'] == 0 )
     {
        diewell( "You are not a valid administrator!" );
    }

    if ( isset($submit) )
    {
        if ( $submit == "yes" )
        {
            // Write a new config-inc.php

$newconfig = <<<EOF
<?php
//**************** External Header Configuration ****************//
//
// the isset prevents vB headers from being sent during login/logout -
// do not remove this line as it may cause the vB headers to interfere with the login/logout process
//
// To include the file, edit the header-inc.php
//

if ( !isset(\$skip_exheader) ) {
    include "header-inc.php";
}

// PhotoPost Pro Version Number
\$VERSION = "7.1";

// Path to your PhotoPost installation - no end slashes
\$PP_PATH = "$newpp_path";

// All of the .tmpl files are placed into a directory called "templates"; if you wish to change the
// name of the directory to something else to protect your files, you may do so and indicate the name
// of the directory here - this is not a path to the directory, just the directory name; the directory
// cannot be moved from the PhotoPost main directory.
\$TMPL_PATH = "$newtmpl_path";

//**************** MySQL Database Configuration ****************//

// PhotoPost database host address, or leave as localhost
\$host="$newhost";

// PhotoPost's database name
\$database="$newdatabase";

// MySQL username and password to access PhotoPost's database
//
// These two variables are for the userid and password needed to access
// the PhotoPost database named above.
\$mysql_user="$newmysql_user";
\$mysql_password="$newmysql_password";

// User database host address, or leave as localhost
\$host_bb="$newhost_bb";

// If you want to use a prefix for your database, enter it here.
// NOTE: This variable can only be set PRIOR to your first installation of PhotoPost;
// existing databases will not be changed and you will be unable to connect if you change
// this variable after performing a default installation.
\$pp_db_prefix = "$newpp_db_prefix";

// User database MySQL database name
//
// This is the variable for the User Database; if you are using Internal
// as your registration system, then these variables are the same as the
// ones above.  If you are linking to a message board system,
// thse variables should be set to the database, user and password for that
// database.
\$database_bb="$newdatabase_bb";

// MySQL username and password to access user database
//
// These two variables are for the userid and password needed to access
// the PhotoPost or BB database.
\$user_bb="$newuser_bb";
\$password_bb="$newpassword_bb";

//
// VBulletin License Number required for VBulletin integration
// You can find this number by checking your index.php file in your vB3 directory
// The 4th line in the file looks like:
// || # vBulletin 3.0.0 - Licence Number ########
// It is the ######## number you need to place below.
\$vblicense = "$newvblicense";

//
// Xenforo Globalsalt required for xenforo integration
// You can find this number in your xenforo library\XenForo\Application.php file
// Around line 473 line in the file looks like:
// 'globalsalt' => '########################',
// It is the ######################## number you need to place below.
\$globalsalt = "$newglobalsalt";

//**************** Application Configuration ****************//

// Default Language
// This needs to be set to the name of the directory used inside of the languages directory
\$pplang = "$newpplang";

//////////////////////// Application Configuration ////////////////////////////////
// These variables set the path to the UNZIP, MOGRIFY and JHEAD commands on your system
//
// This only needs to be set if you are allowing ZIP uploads. These are full paths,
// including the name of the executable (.exe extensions for windows)
// The -j option for Info-ZIP's UNZIP tells it to ignore paths in ZIP file
//
// This option is only used in the event the internal UNZIP does not work for you
//\$zip_command = "/usr/bin/unzip -j";

// Path to MOGRIFY executable
// There should be no spaces in the directory names, use short names if necessary.
// Examples:
// \$mogrify_command = "c:\progra~1\imagemagick\mogrify.exe";
// \$mogrify_command = "c:\ImageMagick\mogrify.exe";
\$mogrify_command = "$newmogrify_command";

?>
EOF;

            $fd = fopen("$PP_PATH/config-inc.php","w");
            fwrite($fd,$newconfig);
            fclose($fd);

            adminlog( "Changed the config-inc settings." );

            forward( "adm-misc.php?admact=config", "Configuration updated!" );
        }
    }

    adminheader( 0, "PhotoPost Configuration Administration" );

    // Set some defaults if the keys dont exist (mostly effects upgraded versions)
    if ( !isset($pplang) )
    {
        $pplang = "english";
    }

    if ( !isset($vblicense) )
    {
        $vblicense = null;
    }

echo<<<PPPRINT
        <div align="center">
        <table cellpadding="0" cellspacing="0" border="0" width="90%" align="center">
        <tr><td class="{$Style['tdbackground']}"><table cellpadding="2" cellspacing="1" border="0" width="100%">
        <tr>
        <td class="{$Style['menubar']}" colspan="4" align="left">
        <span class="{$Style['large']}"><b>PhotoPost Configuration Administration</span>
        </td>
        </tr>
        <tr><td><div align="center">
        <form method="post" action="{$whoami}">
        <br />Exercise caution when editting these variables.<br /><br />
        <table cellpadding="2" cellspacing="1" border="1" width="90%">
        <tr><td class="{$Style['menubar']}" align="center" colspan="4">
        <b>CONFIG-INC.PHP Variables</b></span></td></tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Path to PhotoPost Installation (must be set properly for script to work)</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="50" value="{$Globals['PP_PATH']}" name="newpp_path" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Name of the PhotoPost <b>templates</b> directory<br />If you change the name of the <b>templates</b> directory, indicate it here</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="50" value="$TMPL_PATH" name="newtmpl_path" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" colspan="2">&nbsp;</td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">PhotoPost Database Host</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$host" name="newhost" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">PhotoPost Database Name</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$database" name="newdatabase" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">PhotoPost Database User</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$mysql_user" name="newmysql_user" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">PhotoPost Database Password</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$mysql_password" name="newmysql_password" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">PhotoPost Database Prefix (cannot be changed once set)</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$pp_db_prefix" name="newpp_db_prefix" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" colspan="2">&nbsp;</td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">User Database Host (enter same info as above if not integrating with a third party forum)</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$host_bb" name="newhost_bb" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">User Database Name</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$database_bb" name="newdatabase_bb" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">User Database User</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$user_bb" name="newuser_bb" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">User Database Password</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$password_bb" name="newpassword_bb" class="bginput"></td>
        </tr>
PPPRINT;

    if ( $Globals['vbversion'] == "vb3" )
    {
echo<<<PPPRINT
        <tr>
        <td bgcolor="#CDCD00" align="left" width="60%">VBulletin License Number (if using VBulletin integration, you must enter your license number here).<br /><br />
        You can find this number by checking your index.php file in your vB3 directory. The 4th line in the file looks like:<br /><br />
        || # vBulletin 3.0.0 - Licence Number ########<br /><br />
        It is the <b>########</b> number you need to enter.
        </td>
        <td bgcolor="#CDCD00" align="left" width="40%"><input type="text" size="35" value="$vblicense" name="newvblicense" class="bginput"></td>
        </tr>
PPPRINT;
        $hidinp = "&nbsp;";
    }
    else
    {
        $hidinp = "<input type=\"hidden\" name=\"newvblicense\" value=\"12345678\">&nbsp;";
    }

echo<<<PPPRINT
        <tr>
        <td class="{$Style['tddetails']}" align="left" colspan="2">$hidinp</td>
        </tr>
        <tr>
        <td bgcolor="#CDCD00" align="left" width="60%">Xenforo Globalsalt required for xenforo integration (if using Xenforo integration, you must enter your globalsalt number here).<br /><br />
        You can find this number in your xenforo library\XenForo\Application.php file. Around line 473 line in the file looks like:  'globalsalt' => '########################',
        It is the ######################## number you need to place here.
        </td>
        <td bgcolor="#CDCD00" align="left" width="40%"><input type="text" size="35" value="$globalsalt" name="newglobalsalt" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Default Gallery Language</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$pplang" name="newpplang" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Path for MOGRIFY executable</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$mogrify_command" name="newmogrify_command" class="bginput"></td>
        </tr>

        </table><br /><br /><input type="hidden" name="submit" value="yes">
        <input type="hidden" name="step" value="config">
        <input type="hidden" name="admact" value="config">
        <input type="submit" value="Save Changes"></form><br /><br />

        </td></tr></table></td></tr></table><br />
PPPRINT;

    adminfooter();
    exit;
}

//
// ADM-MODCOM
//

if ( $admact == "modcom" )
{
    if ( $User['adminedit'] == 0 && $User['moderator'] == 0 )
    {
        diewell( "You are not a valid administrator or moderator!" );
    }

    $modcats = null;

    if ( $User['adminedit'] == 0 )
    {
        $modcats = get_modcats();

        if ( !empty($modcats) )
        {
            $modcats = "AND cat IN ($modcats)";
        }
    }

    if ( isset($approve) )
    {
        if ( $approve == "all" )
        {
            $query = "UPDATE {$Globals['pp_db_prefix']}comments SET approved=1 WHERE approved=0 $modcats";
        }
        else
        {
            if ( !is_numeric($approve) )
            {
                diewell( "Malformed call to modcom.php" );
            }

            $query = "UPDATE {$Globals['pp_db_prefix']}comments SET approved=1 WHERE id='$approve'";
        }
        ppmysql_query($query, $link);

        adminlog( "Approved Comment: $approve" );
    }

    if ( isset($remove) && is_numeric($remove) )
    {
        $queryz = ppmysql_query("SELECT photo,cat FROM {$Globals['pp_db_prefix']}comments WHERE id=$remove", $link);
        list( $photo, $thiscat ) = mysql_fetch_row($queryz);

        if ( $photo )
        {
            $resultb = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE id='$remove'", $link);

            // Get the last comment data
            if ( $Globals['dispempty'] == "yes" )
            {
                $querya = "SELECT id,username,date FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo ORDER BY date DESC";
            }
            else
            {
                $querya = "SELECT id,username,date FROM {$Globals['pp_db_prefix']}comments WHERE photo=$photo AND LENGTH(comment) > 0 ORDER BY date DESC";
            }

            $queryz = ppmysql_query($querya, $link);
            list( $lastid, $lastposter, $lastdate ) = mysql_fetch_row($queryz);
            $comcount = mysql_num_rows($queryz);

            if ( $comcount > 0 )
            {
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET numcom='$comcount', lastposter='".addslashes($lastposter)."', lastpost='$lastdate', lastpid='$lastid' WHERE id=$photo", $link);
            }
            else
            {
                ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET numcom=0, lastposter='', lastpost=0, lastpid=0 WHERE id=$photo", $link);
            }

            $resultb = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET posts=posts-1 WHERE id=$thiscat", $link);
            upgradecategories($thiscat);

            // recalc the rating
            calc_rating( $photo );

            adminlog( "Removed Comment: $remove for photo $photo" );
        }
    }

    adminheader( 0, "PhotoPost Moderate Comments Administration" );

    $output = "<div align=\"center\">

        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\" width=\"100%\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td align=\"left\" class=\"{$Style['menubar']}\">
        <span class=\"{$Style['large']}\"><b>PhotoPost Administration</span>
        </td>
        </tr>
        <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\"><br /><a href=\"{$Globals['maindir']}/adm-misc.php?admact=modcom&amp;approve=all\">Approve All Comments</a><br /><br />";

    $output .= "<table cellpadding=\"2\" cellspacing=\"1\" border=\"1\" width=\"100%\">
        <tr><td class=\"{$Style['menubar']}\" align=\"center\" colspan=\"6\">
        <span class=\"{$Style['medium']}\">Unapproved Comments</span></td></tr>";

    $output .= "<tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\">Poster</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\">Photo</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\">&nbsp;Date&nbsp;</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\">Comment</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\">Rating</td>
        <td class=\"{$Style['tddetails']}\" align=\"center\">Action</td>
        </tr>";

    $admlog = ppmysql_query("SELECT id,username,userid,date,rating,comment,photo,cat FROM {$Globals['pp_db_prefix']}comments WHERE approved=0 $modcats ORDER BY date ASC LIMIT 500", $link);
    while ( list( $cid, $cname, $cuid, $cdate, $crating, $comment, $cphoto, $ccat ) = mysql_fetch_row($admlog) )
    {
        $output .= "<tr>
            <td class=\"{$Style['tddetails']}\" align=\"center\">$cname</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\"><a target=\"_blank\" href=\"{$Globals['maindir']}/showphoto.php?photo=$cphoto\">$cphoto</a></td>
            <td class=\"{$Style['tddetails']}\" align=\"center\">".date("j-m-y G:i",$cdate)."</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\">$comment</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\">$crating</td>
            <td class=\"{$Style['tddetails']}\" align=\"center\"><a href=\"{$Globals['maindir']}/adm-misc.php?admact=modcom&amp;approve=$cid\">approve</a><br /><a href=\"{$Globals['maindir']}/adm-misc.php?admact=modcom&amp;remove=$cid\">remove</a></td>
            </tr>";
    }
    $output .= "</table><br /><br /><a href=\"{$Globals['maindir']}/adm-misc.php?admact=modcom&amp;approve=all\">Approve All Comments</a><br /><br />";

    $output .= "</td></tr></table></td></tr></table>";

    print "$output<p><p>";
    adminfooter();
    exit;
}

//
// ADM-EDITINT
//

if ( $admact == "editint" )
{
    if ( $User['adminedit'] == 0 )
    {
        diewell( "You are not a valid administrator!" );
    }

    require "config-int.php";

    if ( isset($submit) )
    {
        if ( $submit == "yes" )
        {
            // Write a new config-int.php

$newconfig = <<<EOF
<?php
//-----------------------------------------------------------------------------------//
// Forum Integration Configuration File
//
// For users using our forum integration files, there are a few things
// we need to know - like the location of PhotoPost and your forums; this
// prevents us from doing alot of extra processing in these scripts we otherwise
// would have to do.
//
// Follow the guides to set your paths and enable the integration options you
// want.
//-----------------------------------------------------------------------------------//

// We need to know the server paths to both your vB installation and your PhotoPost installation
\$vbpath   = "$newvb_path";
\$pppath   = "$newpp_path";

// We need the URL path to your PhotoPost and vb installation
\$url_path = "$newurlpath";
\$vb_urlpath  = "$newvbpath";

// The URL of your photo dir where your images are stored (with / at end)
\$data_dir = "$newdatadir";

// If your PhotoPost tables have a prefix, put it here
// Example:
// $pp_db_prefix = "pp_";
\$pp_db_prefix = "$newprefix";

// If you use the mobile phone integration, set this variable to the CatID for the gallery
define( MOBILE_CAT, $newmobile );

//------------------------------------- vB3 -----------------------------------------//
// VB3_INTEGRATION is for using vB3 or vB4 headers/footers and styles
// VB3_ENHANCEDINT is for Enhanced vB3 or vB4 Integration (using vB3 or vB4 elements in PhotoPost)
//                 requires that VB3_INTEGRATION also be set to 'on'
// VB3_COMMWYSIWYG is for turning on the WYSIWYG interface on the Post A Comment page
//                 if you set this to 'off' then only the standard input box will appear
//
// Set to 'on' to enable specific integrations
define(VB3_INTEGRATION, '$newvb3int');
define(VB3_ENHANCEDINT, '$newvb3enh');
define(VB3_COMMWYSIWYG, '$newvb3wys');
//-----------------------------------------------------------------------------------//


//------------------------------------- vB2 -----------------------------------------//
// VB2_INTEGRATION is if you are using vB2 and want to use the vB2 integration
define(VB2_INTEGRATION, '$newvb2int');
//-----------------------------------------------------------------------------------//


//---------------------------------- vB2 Portal -------------------------------------//
// To use set path and set flag to 'on'
define(VBP2_INTEGRATION, '$newvbpint');
\$vbportal="$newvbp_path";
//-----------------------------------------------------------------------------------//

?>
EOF;

            $fd = fopen("$PP_PATH/config-int.php","w");
            fwrite($fd,$newconfig);
            fclose($fd);

            adminlog( "Changed the config-int settings." );

            forward( "adm-misc.php?admact=editint", "Configuration updated!" );
        }
    }

    adminheader( 0, "PhotoPost Integration Administration" );
    $mobile_cat = MOBILE_CAT;

echo<<<PPPRINT
        <div align="center">
        <table cellpadding="0" cellspacing="0" border="0" width="90%" align="center">
        <tr><td class="{$Style['tdbackground']}"><table cellpadding="2" cellspacing="1" border="0" width="100%">
        <tr>
        <td class="{$Style['menubar']}" colspan="4" align="left">
        <span class="{$Style['large']}"><b>PhotoPost Integration Administration</span>
        </td>
        </tr>
        <tr><td><div align="center">
        <form method="post" action="adm-misc.php">
        <br />Exercise caution when editting these variables.<br /><br />
        <table cellpadding="2" cellspacing="1" border="1" width="90%">
        <tr><td class="{$Style['menubar']}" align="center" colspan="4">
        <b>CONFIG-INT.PHP Integration Variables</b></span></td></tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Server Path to Forum directory</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="50" value="$vbpath" name="newvb_path" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Server Path to PhotoPost directory</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="50" value="$pppath" name="newpp_path" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" colspan="2">&nbsp;</td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">URL to your forums</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$vb_urlpath" name="newvbpath" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">URL to PhotoPost</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$url_path" name="newurlpath" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">URL to your PhotoPost DATA directory</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$data_dir" name="newdatadir" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">PhotoPost Database Table Prefixes</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$pp_db_prefix" name="newprefix" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['menubar']}" align="left" colspan="2">vB3 or vB4 INTEGRATION</td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Do you want to enable the vB3 or vB4 Integration which uses your vB3 or vB4 headers, footers and styles?</td>
        <td class="{$Style['tddetails']}" align="left" width="40%">
PPPRINT;

    if ( VB3_INTEGRATION == "off" )
    {
        echo "<select name=\"newvb3int\"><option value=\"off\" selected=\"selected\">Off</option><option value=\"on\">On</option></select>";
    }
    else {
        echo "<select name=\"newvb3int\"><option value=\"on\" selected=\"selected\">On</option><option value=\"off\">Off</option></select>";
    }

echo<<<PPPRINT
        </td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Do you want to enable the vB3 or vB4 Enahnced features which use vB3 or vB4 controls in PhotoPost?</td>
        <td class="{$Style['tddetails']}" align="left" width="40%">
PPPRINT;

    if ( VB3_ENHANCEDINT == "off" )
    {
        echo "<select name=\"newvb3enh\"><option value=\"off\" selected=\"selected\">Off</option><option value=\"on\">On</option></select>";
    }
    else {
        echo "<select name=\"newvb3enh\"><option value=\"on\" selected=\"selected\">On</option><option value=\"off\">Off</option></select>";
    }

echo<<<PPPRINT
        </td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">If using the Enhanced option above, do you want to enable the vB3 or vB4 WYSIWYG control in Post Comments?</td>
        <td class="{$Style['tddetails']}" align="left" width="40%">
PPPRINT;

    if ( VB3_COMMWYSIWYG == "off" )
    {
        echo "<select name=\"newvb3wys\"><option value=\"off\" selected=\"selected\">Off</option><option value=\"on\">On</option></select>";
    }
    else {
        echo "<select name=\"newvb3wys\"><option value=\"on\" selected=\"selected\">On</option><option value=\"off\">Off</option></select>";
    }

echo<<<PPPRINT
        </td>
        </tr>

        <tr>
        <td class="{$Style['menubar']}" align="left" colspan="2">vB2 INTEGRATION</td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Do you want to enable the vB2 Integration which uses your vB2 headers and footers?</td>
        <td class="{$Style['tddetails']}" align="left" width="40%">
PPPRINT;

    if ( VB2_INTEGRATION == "off" )
    {
        echo "<select name=\"newvb2int\"><option value=\"off\" selected=\"selected\">Off</option><option value=\"on\">On</option></select>";
    }
    else {
        echo "<select name=\"newvb2int\"><option value=\"on\" selected=\"selected\">On</option><option value=\"off\">Off</option></select>";
    }

echo<<<PPPRINT
        </td>
        </tr>

        <tr>
        <td class="{$Style['menubar']}" align="left" colspan="2">vB2Portal INTEGRATION</td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">Do you want to enable the vB2Portal Integration which uses your vB2 Portal headers and footers?</td>
        <td class="{$Style['tddetails']}" align="left" width="40%">
PPPRINT;

    if ( VBP2_INTEGRATION == "off" )
    {
        echo "<select name=\"newvbpint\"><option value=\"off\" selected=\"selected\">Off</option><option value=\"on\">On</option></select>";
    }
    else {
        echo "<select name=\"newvbpint\"><option value=\"on\" selected=\"selected\">On</option><option value=\"off\">Off</option></select>";
    }

echo<<<PPPRINT
        </td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">If enabled, Server Path to vBPortal directory</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="50" value="$vbportal" name="newvbp_path" class="bginput"></td>
        </tr>

        <tr>
        <td class="{$Style['menubar']}" align="left" colspan="2">MOBILE GALLERY INTEGRATION</td>
        </tr>

        <tr>
        <td class="{$Style['tddetails']}" align="left" width="60%">If you have Mobile Categories enabled, enter the Category ID of the Mobile Gallery here</td>
        <td class="{$Style['tddetails']}" align="left" width="40%"><input type="text" size="35" value="$mobile_cat" name="newmobile" class="bginput"></td>
        </tr>

        </table><br /><br /><input type="hidden" name="submit" value="yes">
        <input type="hidden" name="step" value="forum">
        <input type="hidden" name="admact" value="editint">
        <input type="submit" value="Save Changes"></form><br /><br />

        </td></tr></table></td></tr></table><br />
PPPRINT;

    adminfooter();
    exit;
}

//
// ADM-OPTIONS
//

if ( $admact == "options" )
{
    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ( !isset($section) )
    {
        $section = "all";
    }

    if ($ppaction == "options")
    {
        if ($_POST['do'] == "process")
        {
            foreach($_POST as $id=>$setting)
            {
                $setting = (ini_get("magic_quotes_gpc")) ? addslashes(stripslashes(trim($setting))) : addslashes(trim($setting));
                $setting = str_replace( "\\\\", "/", $setting );

                if ($id == "6")
                {
                    $len = strlen($setting)-1;
                    if( $setting[$len] != "/" )
                    {
                        $setting = "$setting/";
                    }
                }

                if ( is_numeric( $id ) && $id != 41 )
                {
                    $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}settings SET setting='$setting' WHERE id=$id", $link);
                }
            }

            $ipaddr = findenv("REMOTE_ADDR");
            $date = time();
            $what = "Changed Admin Settings";
            $what = addslashes($what);
            $username = addslashes($User['username']);
            $resultb = ppmysql_query("REPLACE INTO {$Globals['pp_db_prefix']}admlog (adminuser,ip,datestamp,description) VALUES ('$username','$ipaddr','$date','$what')", $link);

            forward( "adm-misc.php?admact=options&ppaction=options&section=$section", "Processed changes!");
        }

        adminheader( 0, "PhotoPost Options" );

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
            align=\"center\"><tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr>
            <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Options</span></td>
            </tr>
            <form method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\">
            <tr><td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />";

        $optprnt = 1;
        $newsection = 1;
        $ckcolor = 0;

        $whereset = null;

        if ( is_numeric($section) )
        {
            $whereset = "WHERE s.section=$section ";
        }

        $isips = false;

        if ( $section == "ips" )
        {
            $query = "SELECT s.id,s.title,s.varname,s.description,s.setting,s.optionorder,a.id,a.name
                FROM {$Globals['pp_db_prefix']}settings s
                LEFT JOIN {$Globals['pp_db_prefix']}admingroups a ON s.section=a.id
                WHERE s.id IN (134,175,90,209)
                ORDER BY s.section,s.optionorder";

            $isips = true;

            $output .= "These options allow you to configure your Image Protection System. You must configure
                          your storage variables in the Storage Options sections if you want to have your
                          original images stored in a different location than the default.<br /><br />
                          These options allow you to specify that you want to use the image processing script
                          watermark.php - this script will 'hide' the location of your images by requiring that
                          all image displays go through this script. Of course if you leave your files in the default
                          location, they may still know enough to figure out how to get to them.<br /><br />
                          If you want to use an on-the-fly watermark and have GD2 installed, then enter the
                          server path to the PNG graphic file you wish to use in the proper location.<br /><br />";
        }
        else
        {
            $query = "SELECT s.id,s.title,s.varname,s.description,s.setting,s.optionorder,a.id,a.name
                FROM {$Globals['pp_db_prefix']}settings s
                LEFT JOIN {$Globals['pp_db_prefix']}admingroups a ON s.section=a.id
                $whereset
                ORDER BY s.section,s.optionorder";
        }

        $sets = ppmysql_query($query, $link);
        $fillcolor = 0;

        while ( list($id,$title,$varname,$optdesc,$setting,$optorder,$optsec,$secname) = mysql_fetch_row($sets) )
        {
            $proceed = 1;
            $optset = null;

            if ($Globals['vbversion'] != "photopost")
            {
                if ($varname == "cright" || $varname == "allowregs" || $varname == "coppa" ||
                        $varname == "rules" || $varname == "emailverify" || $varname == "address" ||
                        $varname == "copparules" || $varname == "pversion")
                {
                    $proceed = 0;
                }

            }
            else
            {
                if ($varname == "cright" || $varname == "pversion" || $varname == "dprefix")
                {
                    $proceed = 0;
                }
            }

            if ( $isips )
            {
                $secname = "Image Protection System Options";
                $optsec = 1;
            }
            else {
                if ($varname == "origfull" || $varname == "origdir") {
                    $proceed = 0;
                }
            }

            if ($proceed == 1)
            {
                if ( $fillcolor == 1)
                {
                    $ckcolor = "{$Style['alternatetable']}";
                    $fillcolor=0;
                }
                else
                {
                    $ckcolor = "{$Style['tddetails']}";
                    $fillcolor=1;
                }

                if ($newsection == 1)
                {
                    $newsection = 0;
                    $gnum = $optsec;

                    $output .= "<table width=\"90%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"{$Style['tableborders']}\"><tr><td>
                        <table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"1\"><tr>
                        <td class=\"{$Style['menubar']}\" colspan=\"2\" align=\"left\">
                        <span class=\"{$Style['medium']}\"><b>$secname</td></tr>";
                }

                if ( $gnum != $optsec && $newsection != 1 )
                {
                    $gnum = $optsec;
                    $gname = $secname;
                    $newsection = 0;

                    $output .= "</table></td></tr></table><p><table width=\"90%\" border=\"0\" cellpadding=\"0\"
                        cellspacing=\"0\" class=\"{$Style['tableborders']}\"><tr><td width=\"100%\">
                        <table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"1\"><tr><td
                        class=\"{$Style['menubar']}\" colspan=\"2\" align=\"left\">
                        <span class=\"{$Style['medium']}\"><b>$secname</td></tr>";
                }

                $output .=" <tr><td width=\"65%\" class=\"$ckcolor\" align=\"left\">$title<br /><span class=\"{$Style['small']}\">$optdesc</span></td>";

                if ( $varname == "theme" )
                {
                    $dir_name = "$PP_PATH/stylesheets";
                    $dir = opendir($dir_name);

                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>";

                    while ($file_name = readdir($dir))
                    {
                        if (($file_name != ".") && ($file_name != "..") && ($file_name != "template.css") && (stristr($file_name,".css")))
                        {
                            $file_name = str_replace(".css", "", $file_name);

                            if ( $file_name != $setting )
                            {
                                $output .= "<option value=\"$file_name\">$file_name</option>";
                            }
                        }
                    }

                    $output .= "</select></td></tr>";
                    closedir($dir);

                    $optprnt = 0;
                }

                if ( $varname == "thumbborder" )
                {
                    $dir_name = "{$Globals['PP_PATH']}/{$Globals['TMPL_PATH']}";

                    $dir = opendir($dir_name);
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>";

                    while ($file_name = readdir($dir))
                    {
                        if ( stristr($file_name,"thumbnail") )
                        {
                            $file_name = str_replace(".tmpl", "", $file_name);

                            if ( $file_name != $setting )
                            {
                                $output .= "<option value=\"$file_name\">$file_name</option>";
                            }
                        }
                    }
                    $output .= "</select></td></tr>";
                    closedir($dir);

                    $optprnt=0;
                }

                if ($setting == "yes")
                {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\"><option
                        selected=\"selected\">$setting</option>
                        <option>no</option></select></td></tr>";
                    $optprnt=0;
                }

                if ($setting == "no")
                {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option><option>yes</option></select></td></tr>";
                    $optprnt=0;
                }

                 if ($id == 87)
                 {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>
                        <option>NorthWest</option>
                        <option>North</option>
                        <option>NorthEast</option>
                        <option>West</option>
                        <option>Center</option>
                        <option>East</option>
                        <option>SouthWest</option>
                        <option>South</option>
                        <option>SouthEast</option>
                        </select></td></tr>";
                    $optprnt=0;
                }

                if ($id == 133)
                {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>
                        <option>none</option>
                        <option>spider</option>
                        <option>seo</option>
                        </select></td></tr>";
                    $optprnt=0;
                }

                if ( $id == 174 )
                {
                    if ( $setting == 0 )
                    {
                        $optset .= "<select name=\"$id\"><option value=\"0\" selected=\"selected\">Do nothing</option><option value=\"2\">Display Errors</option><option value=\"1\">EMail Errors</option></select>";
                    }
                    elseif ( $setting == 1 )
                    {
                        $optset .= "<select name=\"$id\"><option value=\"1\" selected=\"selected\">EMail Errors</option><option value=\"0\">Do nothing</option><option value=\"2\">Display Errors</option></select>";
                    }
                    else
                    {
                        $optset .= "<select name=\"$id\"><option value=\"2\" selected=\"selected\">Display Errors</option><option value=\"0\">Do nothing</option><option value=\"1\">EMail Errors</option></select>";
                    }

                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\">$optset</td></tr>";

                    $optprnt=0;
                }

                if ( $id == 181 )
                {
                    if ( $setting == "open" )
                    {
                        $optset .= "<select name=\"$id\"><option value=\"open\" selected=\"selected\">Open</option><option value=\"closed\">Closed</option></select>";
                    }
                    else
                    {
                        $optset .= "<select name=\"$id\"><option value=\"closed\" selected=\"selected\">Closed</option><option value=\"open\">Open</option></select>";
                    }

                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\">$optset</td></tr>";
                    $optprnt=0;
                }

                if ( $id == 176 )
                {
                    if ( $setting == 0 )
                    {
                        $optset .= "<select name=\"$id\"><option value=\"0\" selected=\"selected\">ImageMagick</option><option value=\"2\">GD1</option><option value=\"1\">GD2</option></select>";
                    }
                    elseif ( $setting == 1 )
                    {
                        $optset .= "<select name=\"$id\"><option value=\"1\" selected=\"selected\">GD2</option><option value=\"0\">ImageMagick</option><option value=\"2\">GD1</option></select>";
                    }
                    else
                    {
                        $optset .= "<select name=\"$id\"><option value=\"2\" selected=\"selected\">GD1</option><option value=\"0\">ImageMagick</option><option value=\"1\">GD2</option></select>";
                    }

                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\">$optset</td></tr>";
                    $optprnt=0;
                }

                if ($id == 88)
                {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>
                        <option>10</option>
                        <option>20</option>
                        <option>30</option>
                        <option>40</option>
                        <option>50</option>
                        <option>60</option>
                        <option>70</option>
                        <option>80</option>
                        <option>90</option>
                        <option>100</option>
                        </select></td></tr>";
                    $optprnt=0;
                }

                if ($id == 144 )
                {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>
                        <option>off</option>
                        <option>left</option>
                        <option>right</option>
                        </select></td></tr>";
                    $optprnt=0;
                }

                if ($id == 240 )
                {
                    if ( $setting == "paypal" )
    	            {
    	                $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
    	                    <option value=\"paypal\" selected=\"selected\">Paypal</option>
    	                    <option value=\"authorizenet\">Authorize.net</option>
    	                    <option value=\"moneybookers\">MoneyBookers</option>
    	                    <option value=\"worldpay\">Worldpay</option>
    	                    </select></td></tr>";
                    }
                    elseif ( $setting == "authorizenet" )
    	            {
    	                $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
    	                    <option value=\"authorizenet\" selected=\"selected\">Authorize.net</option>
    	                    <option value=\"paypal\">Paypal</option>
    	                    <option value=\"moneybookers\">MoneyBookers</option>
    	                    <option value=\"worldpay\">Worldpay</option>
    	                    </select></td></tr>";
                    }
                    elseif ( $setting == "moneybookers" )
    	            {
    	                $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
    	                    <option value=\"moneybookers\" selected=\"selected\">MoneyBookers</option>
    	                    <option value=\"paypal\">Paypal</option>
    	                    <option value=\"authorizenet\">Authorize.net</option>
    	                    <option value=\"worldpay\">Worldpay</option>
    	                    </select></td></tr>";
                    }
                    elseif ( $setting == "worldpay" )
    	            {
    	                $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
    	                    <option value=\"worldpay\" selected=\"selected\">Worldpay</option>
    	                    <option value=\"paypal\">Paypal</option>
    	                    <option value=\"authorizenet\">Authorize.net</option>
    	                    <option value=\"moneybookers\">MoneyBookers</option>
    	                    </select></td></tr>";
                    }
                    $optprnt=0;
                }

                if ($id == 251 )
                {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>
                        <option>3</option>
                        <option>1</option>
                        </select></td></tr>";
                    $optprnt=0;
                }

                if ($id == 210 )
                {
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><select name=\"$id\">
                        <option selected=\"selected\">$setting</option>
                        <option>top</option>
                        <option>bottom</option>
                        <option>left</option>
                        <option>right</option>
                        </select></td></tr>";
                    $optprnt=0;
                }

                if ($id == 197 )
    		    {
                    $setting = htmlentities($setting);
                    $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><textarea name=\"$id\" cols=\"30\" rows=\"5\" class=\"{$Style['formboxes']}\">$setting</textarea></td></tr>";
                    $optprnt=0;
                }

                if ( $optprnt == 1 )
                {
                    if ( preg_match( "/\#/", $setting ) )
                    {
                        $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><div align=\"center\">
                            <table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td align=\"left\">
                            <input type=\"text\" size=\"15\" value=\"$setting\" name=\"$id\" class=\"bginput\"></td><td><div align=\"center\"><table width=\"75\"
                            border=\"2\" height=\"17\" cellpadding=\"0\" cellspacing=\"0\"><tr><td
                            bgcolor=\"$setting\" align=\"left\">&nbsp;</td></tr></table></td></tr></table></td></tr>";
                    }
                    else
                    {
                        $output .= "<td width=\"35%\" class=\"$ckcolor\" align=\"left\"><input type=\"text\" size=\"30\"
                            value=\"$setting\" name=\"$id\" class=\"bginput\"></td></tr>";
                    }
                }
                $optprnt=1;
            }
        }
        ppmysql_free_result( $sets );

        $output .= "</table></td></tr></table><input type=\"hidden\" name=\"ppaction\" value=\"options\">
            <br /><input type=\"hidden\" name=\"do\" value=\"process\">
            <input type=\"hidden\" name=\"section\" value=\"$section\">
            <input type=\"hidden\" name=\"admact\" value=\"options\">
            <input type=\"submit\" value=\"Save Changes\"></form>
            </td></tr></table></td></tr></table>";

        print "$output<p><p>";
        adminfooter();
        exit;
    }
}


//
// ADM-ORDER
//

if ( $admact == "order" )
{
    // Override as we don't want spidering of the Page links
    $Globals['spider'] = "none";

    if ( $User['adminedit'] == 0 && $User['moderator'] == 0 )
    {
        diewell( "You are not a valid administrator or moderator!" );
    }

    topmenu();

    if ( !isset($ppaction) )
    {
        $catdefault = null;
        $nocat=0;
        $catdisp = "<select onChange=\"submit();\" name=\"cat\">";

        $selected = $cat;
        $firstcat = catmoveopt(0, 1);

        if ( empty($cat) )
        {
            $cat = 500;
        }

        $catdisp .= $catoptions;

        $resultb = ppmysql_query("SELECT id,catname,thumbs,cattype,parent,thumbnail,sortorder FROM {$Globals['pp_db_prefix']}categories WHERE id=$cat LIMIT 1", $link);
        list( $subid, $subcatname, $subthumbs, $cattype, $catparent, $thumbnail, $catsortorder ) = mysql_fetch_row($resultb);

        if ( empty($sort) )
        {
            $sortparam = ( isset($catsortorder) && $catsortorder > 0 ? $catsortorder : 1 );
        }
        else
        {
            $sortparam = $sort;
        }

        $sortoptions = null;
        $sortcode = null;
        $posternav = null;

        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort", $link);
        while ( list($sortid, $sortname, $sortc) = mysql_fetch_row($resultc) )
        {
            if ($sort != $sortid)
            {
                $sortoptions .= "<option value = $sortid>$sortname</option>";
            }
            else
            {
                $sortdefault = "<option selected value=\"$sortid\">$sortname</option>";
                $sortcode = "$sortc";
            }
        }

        $sortselect = "<select onchange=\"submit();\" name=\"sort\" class=\"bginput\">$sortdefault$sortoptions</select>";
        // end sort box //

        if ( $thumb > 0 )
        {
            if ( $cat > 0 && $thumb != $thumbnail )
            {
                $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET thumbnail=$thumb WHERE id=$cat", $link);
                $thumbnail = $thumb;
            }
        }

        $catdefault = "<option selected value=\"$subid\">$subcatname</option>";

        if (!isset($s))
        {
            $s = null;
        }

        $perpage1x = 4;
        $perpage3x = ($perpage1x * 3);
        $perpage4x = ($perpage1x * 4);
        $perpage5x = ($perpage1x * 5);
        $perpage6x = ($perpage1x * 6);

        if ( isset($perpage) )
        {
            if ($perpage > $perpage6x)
            {
                $perpage = $perpage6x;
            }

            if ($perpage < $perpage1x)
            {
                $perpage = $perpage1x;
            }
        }
        else
        {
            $perpage = $perpage3x;
        }

        if ( isset($page) && $page > 0 )
         {
            $startnumb = ($page*$perpage)-$perpage+1;
        }
        else
        {
            $page = 1;
            $startnumb = 1;
        }

        $numcols = 4;
        $pwidth = 25;

        adminheader( 0, "PhotoPost Photo Order" );

        $output = "<form method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\">
            <input type=\"hidden\" value=\"order\" name=\"admact\">$ppopen
            <tr>
            <td colspan=\"$numcols\" align=\"left\" class=\"{$Style['menubar']}\">
            <span class=\"{$Style['large']}\"><b>PhotoPost Photo Sorting Interface</b></span>
            </td></tr>
            <tr><td class=\"{$Style['tddetails']}\" colspan=\"$numcols\">
            <table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
            <tr><td class=\"{$Style['tddetails']}\" align=\"left\" width=\"25%\"><b>Category:</b> $catdisp</select></td>
            <td align=\"center\" width=\"50%\">
            <b>Sort by:</b> $sortselect</td>
            <td class=\"{$Style['tddetails']}\" align=\"right\" nowrap=\"nowrap\" width=\"25%\"><b>Per Page:</b></span>
            <select onChange=\"submit();\" name=\"perpage\" class=\"bginput\">
            <option selected=\"selected\">$perpage</option><option>$perpage3x</option><option>$perpage4x</option><option>$perpage5x</option><option>$perpage6x</option></select>
            </td></tr></table></form></td></tr>
            <form method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\">
            <input type=\"hidden\" value=\"order\" name=\"admact\">
            <input type=\"hidden\" value=\"dochanges\" name=\"ppaction\">";

        $count = 1;
        $photocount = 0;
        $cntresults = 0;

        $queryz = ppmysql_query("SELECT id,user,userid,cat,storecat,title,bigimage,disporder FROM {$Globals['pp_db_prefix']}photos WHERE cat=$cat $sortcode", $link);
        $rowcnt = mysql_num_rows($queryz);

        miscpages($rowcnt, "order");
        $ismod = ( $User['adminedit'] == 1 ? true : false );

        while ( list($id,$tuser,$tuserid,$tcat,$storecat,$title,$bigimage,$dispo) = mysql_fetch_row($queryz))
        {
            if ( !$ismod )
            {
                $ismod = is_moderator($tcat);

                if ( !$ismod )
                {
                    $posternav = null;
                    break;
                }
            }

            if ( $storecat != 0 )
            {
                $tcat = $storecat;
            }

            $cntresults++;

            if ($cntresults >= $startnumb)
            {
                if ($cntresults < ($startnumb+$perpage))
                {
                    $photocount++;

                    $theext = get_ext( $bigimage );
                    $filename = str_replace( $theext, "", $bigimage );

                    $output .= "<td class=\"{$Style['tdbackground']}\" valign=\"bottom\" width=\"25%\"><div align=\"center\">";

                    $imgtag = get_imagethumb( $bigimage, $tcat, $tuserid, 1 );
                    $output .= "$imgtag";
                    $theimage = "{$Globals['datadir']}/$cat/$filename$theext";

                    if ( $dispo == 99999 )
                    {
                        $dispo = 0;
                    }

                    $output .= "<br /><br />
                        <table cellpadding=\"0\" cellspacing=\"0\" class=\"{$Style['tableborders']}\" width=\"200\"><tr><td>
                        <table cellpadding=\"2\" cellspacing=\"1\" width=\"200\"><tr>
                        <td colspan=\"2\" class=\"{$Style['tddetails']}\"><span class=\"{$Style['medium']}\"><a href=\"$theimage\">$title</a></span></td></tr><tr>
                        <td class=\"{$Style['tddetails']}\">Filename:</span></td>
                        <td class=\"{$Style['tddetails']}\">$filename</span></td>
                        </tr>
                        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"center\">
                        <input type=\"hidden\" name=\"id$photocount\" value=\"$id\">
                        Position&nbsp;<input name=\"order$photocount\" value=\"$dispo\" size=\"3\">
                        </td></tr>
                        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"center\">";

                    if ( $thumbnail == $id )
                    {
                        $output .= "<span class=\"{$Style['small']}\">Current Thumbnail</span>";
                    }
                    else
                    {
                        $output .= "<span class=\"{$Style['small']}\"><a href=\"{$Globals['maindir']}/adm-misc.php?admact=order&amp;cat=$cat&amp;thumb=$id&amp;sort=$sortparam&amp;page=$page\">Make Category Thumbnail</a></span>";
                    }

                    $output .= "</td></tr></table></td></tr></table></div></td>";

                    if ($count == $numcols)
                    {
                        $output .= "</tr><tr>";
                        $count = 0;
                    }

                    $count++;
                }
            }
        }

        if ( $count != $numcols+1 && $count != 1 )
        {
            for ( $z = $count; $z < ($numcols+1); $z++)
            {
$output .= <<<PPPRINT
            <td class="{$Style['tdbackground']}" valign="top" align="left" width="$pwidth%">
                &nbsp;
            </td>
PPPRINT;
            }
        }

        if ( $notcat == 1 )
        {
            $noresults = "<br />Category you selected has no thumbnails.<br /><br />";
        }
        elseif ($cntresults == 0)
        {
            $noresults = "<br />This category contains no photos.<br /><br />";
        }
        else
        {
            $noresults = null;
        }

        $output .= "</tr><tr><td class=\"{$Style['tddetails']}\" colspan=\"$numcols\"><div align=\"center\">
            <input type=\"hidden\" name=\"thecount\" value=\"$photocount\">
            <input type=\"hidden\" name=\"cat\" value=\"$cat\">
            <input type=\"hidden\" name=\"s\" value=\"$s\">
            $noresults";

        if (empty($noresults))
        {
            $output .= "<br />Set Position to 0 to allow user selected sort order.<br />Positions other than 0 override any selected sort order (including on this page).<br /><br /><input type=\"submit\" value=\"Submit Changes\">";
        }

        $output .= "<br /><br />$posternav</td></tr>$ppclose</form><br />";

        print $output;
        adminfooter();
    }

    if ($_POST['ppaction'] == "dochanges")
    {
        typecast_wc("order", INT);
        typecast_wc("id", INT);

        $totalphotos = $thecount;

        list($seconds,$minutes,$hours,$mdays,$mons,$years,$wday,$yday,$isdst) = localtime();
        $mons++;

        for ( $i = 1; $i <= $totalphotos; $i++ )
        {
            unset($appkey);

            $torder = "order$i";
            $tpid = "id$i";
            $pid = ${$tpid};
            $neworder = ${$torder};

            if ( $pid > 0 )
            {
                if ( empty($neworder) )
                {
                    $neworder = 99999;
                }

                $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET disporder='$neworder' WHERE id=$pid", $link);
            }
        }

        forward( "adm-misc.php?admact=order&s=$s&cat=$cat", "Processing completed! Returning to Sorting Page." );
    }
}

//
// ADM-STYLE
//

if ( $admact == "style" )
{
    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ( !isset($ppaction) )
    {
        adminheader( 0, "PhotoPost Stylesheet Editor" );

        $output .= "<div align=\"center\">

            <form name=\"f\" action=\"{$Globals['maindir']}/adm-misc.php\" method=\"POST\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
            <tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\" width=\"100%\">
            <tr>
            <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\">
            <span class=\"{$Style['large']}\"><b>PhotoPost Stylesheet Editor</span>
            </td>
            </tr><tr>
            <td class=\"{$Style['tddetails']}\"><div align=\"center\">";

        if ( !isset($stylesheet) )
        {
            print "$output<table width=\"80%\" align=\"center\"><tr><td class=\"{$Style['tddetails']}\">";
            print "Select the stylesheet you wish to edit.<br /><br />";
            print "<select name=\"stylesheet\" class=\"{$Style['formboxes']}\" size=\"15\">";

            $dir = opendir("$PP_PATH/stylesheets");
            $filename = array();

            while ($file = readdir($dir))
            {
                if ($file == "." || $file == ".." || !stristr($file,"css"))
                {
                    continue;
                }

                $filename[] = $file;
            }

            sort($filename);
            closedir($dir);

            $numtemp = sizeof($filename);

            for ( $x = 0; $x < $numtemp; $x++)
            {
                print "<option>$filename[$x]</option>";
            }

            print "</select><br /><input type=\"hidden\" name=\"admact\" value=\"style\">
                   <input type=\"submit\" value=\"Edit Stylesheet\">
                   <br /></td></tr></table></td></tr></table></form></div>";
            exit;
        }
        else
        {
            if ( $final == "yes" )
            {
                $body = (ini_get("magic_quotes_gpc")) ? stripslashes($body) : $body;
                $body = preg_replace("/\r/","",convert_html(stripslashes($body)));
                $bodyparts = split("\n",$body);

                $size = sizeof($bodyparts);

                for ( $i = 0; $i < $size; $i++)
                {
                    $line = $bodyparts[$i];
                    $line .="\r\n";
                    $newbody .= $line;
                }

                if ( strstr($stylesheet, "..") )
                {
                    print "Error in stylesheet format: $stylesheet";
                    exit;
                }

                $fd = fopen("$PP_PATH/stylesheets/$stylesheet","w");

                if ( !$fd )
                {
                    print "$output<br />Unable to write changes, permissions on $stylesheet are not set properly.<br />";
                    print "<br /></td></tr></table></td></tr></table>";
                    exit;
                }

                fwrite($fd,$newbody);
                fclose($fd);

                adminlog( "Edit Stylesheet: $stylesheet" );

                print "$output<br />Stylesheet $stylesheet saved.<br />";
                print "<br /></td></tr></table></td></tr></table>";
                exit;
            }

            $output .= "<br />
                Using the color selector below you can fill in the fields to match the colors of the style you want for your site.<br /><br />";

            $output .= "<script language=\"javascript\">
                function showColor(val) {
                document.f.{$Style['small']}cal_hexval.value = val;
                }
                </script>

                Color Picker<br />
                <map name=\"colmap\">
                <area shape=\"rect\" coords=\"1,1,7,10\" href=\"javascript:showColor('#00FF00')\">
                <area shape=\"rect\" coords=\"9,1,15,10\" href=\"javascript:showColor('#00FF33')\">
                <area shape=\"rect\" coords=\"17,1,23,10\" href=\"javascript:showColor('#00FF66')\">
                <area shape=\"rect\" coords=\"25,1,31,10\" href=\"javascript:showColor('#00FF99')\">
                <area shape=\"rect\" coords=\"33,1,39,10\" href=\"javascript:showColor('#00FFCC')\">
                <area shape=\"rect\" coords=\"41,1,47,10\" href=\"javascript:showColor('#00FFFF')\">
                <area shape=\"rect\" coords=\"49,1,55,10\" href=\"javascript:showColor('#33FF00')\">
                <area shape=\"rect\" coords=\"57,1,63,10\" href=\"javascript:showColor('#33FF33')\">
                <area shape=\"rect\" coords=\"65,1,71,10\" href=\"javascript:showColor('#33FF66')\">
                <area shape=\"rect\" coords=\"73,1,79,10\" href=\"javascript:showColor('#33FF99')\">
                <area shape=\"rect\" coords=\"81,1,87,10\" href=\"javascript:showColor('#33FFCC')\">
                <area shape=\"rect\" coords=\"89,1,95,10\" href=\"javascript:showColor('#33FFFF')\">
                <area shape=\"rect\" coords=\"97,1,103,10\" href=\"javascript:showColor('#66FF00')\">
                <area shape=\"rect\" coords=\"105,1,111,10\" href=\"javascript:showColor('#66FF33')\">
                <area shape=\"rect\" coords=\"113,1,119,10\" href=\"javascript:showColor('#66FF66')\">
                <area shape=\"rect\" coords=\"121,1,127,10\" href=\"javascript:showColor('#66FF99')\">
                <area shape=\"rect\" coords=\"129,1,135,10\" href=\"javascript:showColor('#66FFCC')\">
                <area shape=\"rect\" coords=\"137,1,143,10\" href=\"javascript:showColor('#66FFFF')\">
                <area shape=\"rect\" coords=\"145,1,151,10\" href=\"javascript:showColor('#99FF00')\">
                <area shape=\"rect\" coords=\"153,1,159,10\" href=\"javascript:showColor('#99FF33')\">
                <area shape=\"rect\" coords=\"161,1,167,10\" href=\"javascript:showColor('#99FF66')\">
                <area shape=\"rect\" coords=\"169,1,175,10\" href=\"javascript:showColor('#99FF99')\">
                <area shape=\"rect\" coords=\"177,1,183,10\" href=\"javascript:showColor('#99FFCC')\">
                <area shape=\"rect\" coords=\"185,1,191,10\" href=\"javascript:showColor('#99FFFF')\">
                <area shape=\"rect\" coords=\"193,1,199,10\" href=\"javascript:showColor('#CCFF00')\">
                <area shape=\"rect\" coords=\"201,1,207,10\" href=\"javascript:showColor('#CCFF33')\">
                <area shape=\"rect\" coords=\"209,1,215,10\" href=\"javascript:showColor('#CCFF66')\">
                <area shape=\"rect\" coords=\"217,1,223,10\" href=\"javascript:showColor('#CCFF99')\">
                <area shape=\"rect\" coords=\"225,1,231,10\" href=\"javascript:showColor('#CCFFCC')\">
                <area shape=\"rect\" coords=\"233,1,239,10\" href=\"javascript:showColor('#CCFFFF')\">
                <area shape=\"rect\" coords=\"241,1,247,10\" href=\"javascript:showColor('#FFFF00')\">
                <area shape=\"rect\" coords=\"249,1,255,10\" href=\"javascript:showColor('#FFFF33')\">
                <area shape=\"rect\" coords=\"257,1,263,10\" href=\"javascript:showColor('#FFFF66')\">
                <area shape=\"rect\" coords=\"265,1,271,10\" href=\"javascript:showColor('#FFFF99')\">
                <area shape=\"rect\" coords=\"273,1,279,10\" href=\"javascript:showColor('#FFFFCC')\">
                <area shape=\"rect\" coords=\"281,1,287,10\" href=\"javascript:showColor('#FFFFFF')\">
                <area shape=\"rect\" coords=\"1,12,7,21\" href=\"javascript:showColor('#00CC00')\">
                <area shape=\"rect\" coords=\"9,12,15,21\" href=\"javascript:showColor('#00CC33')\">
                <area shape=\"rect\" coords=\"17,12,23,21\" href=\"javascript:showColor('#00CC66')\">
                <area shape=\"rect\" coords=\"25,12,31,21\" href=\"javascript:showColor('#00CC99')\">
                <area shape=\"rect\" coords=\"33,12,39,21\" href=\"javascript:showColor('#00CCCC')\">
                <area shape=\"rect\" coords=\"41,12,47,21\" href=\"javascript:showColor('#00CCFF')\">
                <area shape=\"rect\" coords=\"49,12,55,21\" href=\"javascript:showColor('#33CC00')\">
                <area shape=\"rect\" coords=\"57,12,63,21\" href=\"javascript:showColor('#33CC33')\">
                <area shape=\"rect\" coords=\"65,12,71,21\" href=\"javascript:showColor('#33CC66')\">
                <area shape=\"rect\" coords=\"73,12,79,21\" href=\"javascript:showColor('#33CC99')\">
                <area shape=\"rect\" coords=\"81,12,87,21\" href=\"javascript:showColor('#33CCCC')\">
                <area shape=\"rect\" coords=\"89,12,95,21\" href=\"javascript:showColor('#33CCFF')\">
                <area shape=\"rect\" coords=\"97,12,103,21\" href=\"javascript:showColor('#66CC00')\">
                <area shape=\"rect\" coords=\"105,12,111,21\" href=\"javascript:showColor('#66CC33')\">
                <area shape=\"rect\" coords=\"113,12,119,21\" href=\"javascript:showColor('#66CC66')\">
                <area shape=\"rect\" coords=\"121,12,127,21\" href=\"javascript:showColor('#66CC99')\">
                <area shape=\"rect\" coords=\"129,12,135,21\" href=\"javascript:showColor('#66CCCC')\">
                <area shape=\"rect\" coords=\"137,12,143,21\" href=\"javascript:showColor('#66CCFF')\">
                <area shape=\"rect\" coords=\"145,12,151,21\" href=\"javascript:showColor('#99CC00')\">
                <area shape=\"rect\" coords=\"153,12,159,21\" href=\"javascript:showColor('#99CC33')\">
                <area shape=\"rect\" coords=\"161,12,167,21\" href=\"javascript:showColor('#99CC66')\">
                <area shape=\"rect\" coords=\"169,12,175,21\" href=\"javascript:showColor('#99CC99')\">
                <area shape=\"rect\" coords=\"177,12,183,21\" href=\"javascript:showColor('#99CCCC')\">
                <area shape=\"rect\" coords=\"185,12,191,21\" href=\"javascript:showColor('#99CCFF')\">
                <area shape=\"rect\" coords=\"193,12,199,21\" href=\"javascript:showColor('#CCCC00')\">
                <area shape=\"rect\" coords=\"201,12,207,21\" href=\"javascript:showColor('#CCCC33')\">
                <area shape=\"rect\" coords=\"209,12,215,21\" href=\"javascript:showColor('#CCCC66')\">
                <area shape=\"rect\" coords=\"217,12,223,21\" href=\"javascript:showColor('#CCCC99')\">
                <area shape=\"rect\" coords=\"225,12,231,21\" href=\"javascript:showColor('#CCCCCC')\">
                <area shape=\"rect\" coords=\"233,12,239,21\" href=\"javascript:showColor('#CCCCFF')\">
                <area shape=\"rect\" coords=\"241,12,247,21\" href=\"javascript:showColor('#FFCC00')\">
                <area shape=\"rect\" coords=\"249,12,255,21\" href=\"javascript:showColor('#FFCC33')\">
                <area shape=\"rect\" coords=\"257,12,263,21\" href=\"javascript:showColor('#FFCC66')\">
                <area shape=\"rect\" coords=\"265,12,271,21\" href=\"javascript:showColor('#FFCC99')\">
                <area shape=\"rect\" coords=\"273,12,279,21\" href=\"javascript:showColor('#FFCCCC')\">
                <area shape=\"rect\" coords=\"281,12,287,21\" href=\"javascript:showColor('#FFCCFF')\">
                <area shape=\"rect\" coords=\"1,23,7,32\" href=\"javascript:showColor('#009900')\">
                <area shape=\"rect\" coords=\"9,23,15,32\" href=\"javascript:showColor('#009933')\">
                <area shape=\"rect\" coords=\"17,23,23,32\" href=\"javascript:showColor('#009966')\">
                <area shape=\"rect\" coords=\"25,23,31,32\" href=\"javascript:showColor('#009999')\">
                <area shape=\"rect\" coords=\"33,23,39,32\" href=\"javascript:showColor('#0099CC')\">
                <area shape=\"rect\" coords=\"41,23,47,32\" href=\"javascript:showColor('#0099FF')\">
                <area shape=\"rect\" coords=\"49,23,55,32\" href=\"javascript:showColor('#339900')\">
                <area shape=\"rect\" coords=\"57,23,63,32\" href=\"javascript:showColor('#339933')\">
                <area shape=\"rect\" coords=\"65,23,71,32\" href=\"javascript:showColor('#339966')\">
                <area shape=\"rect\" coords=\"73,23,79,32\" href=\"javascript:showColor('#339999')\">
                <area shape=\"rect\" coords=\"81,23,87,32\" href=\"javascript:showColor('#3399CC')\">
                <area shape=\"rect\" coords=\"89,23,95,32\" href=\"javascript:showColor('#3399FF')\">
                <area shape=\"rect\" coords=\"97,23,103,32\" href=\"javascript:showColor('#669900')\">
                <area shape=\"rect\" coords=\"105,23,111,32\" href=\"javascript:showColor('#669933')\">
                <area shape=\"rect\" coords=\"113,23,119,32\" href=\"javascript:showColor('#669966')\">
                <area shape=\"rect\" coords=\"121,23,127,32\" href=\"javascript:showColor('#669999')\">
                <area shape=\"rect\" coords=\"129,23,135,32\" href=\"javascript:showColor('#6699CC')\">
                <area shape=\"rect\" coords=\"137,23,143,32\" href=\"javascript:showColor('#6699FF')\">
                <area shape=\"rect\" coords=\"145,23,151,32\" href=\"javascript:showColor('#999900')\">
                <area shape=\"rect\" coords=\"153,23,159,32\" href=\"javascript:showColor('#999933')\">
                <area shape=\"rect\" coords=\"161,23,167,32\" href=\"javascript:showColor('#999966')\">
                <area shape=\"rect\" coords=\"169,23,175,32\" href=\"javascript:showColor('#999999')\">
                <area shape=\"rect\" coords=\"177,23,183,32\" href=\"javascript:showColor('#9999CC')\">
                <area shape=\"rect\" coords=\"185,23,191,32\" href=\"javascript:showColor('#9999FF')\">
                <area shape=\"rect\" coords=\"193,23,199,32\" href=\"javascript:showColor('#CC9900')\">
                <area shape=\"rect\" coords=\"201,23,207,32\" href=\"javascript:showColor('#CC9933')\">
                <area shape=\"rect\" coords=\"209,23,215,32\" href=\"javascript:showColor('#CC9966')\">
                <area shape=\"rect\" coords=\"217,23,223,32\" href=\"javascript:showColor('#CC9999')\">
                <area shape=\"rect\" coords=\"225,23,231,32\" href=\"javascript:showColor('#CC99CC')\">
                <area shape=\"rect\" coords=\"233,23,239,32\" href=\"javascript:showColor('#CC99FF')\">
                <area shape=\"rect\" coords=\"241,23,247,32\" href=\"javascript:showColor('#FF9900')\">
                <area shape=\"rect\" coords=\"249,23,255,32\" href=\"javascript:showColor('#FF9933')\">
                <area shape=\"rect\" coords=\"257,23,263,32\" href=\"javascript:showColor('#FF9966')\">
                <area shape=\"rect\" coords=\"265,23,271,32\" href=\"javascript:showColor('#FF9999')\">
                <area shape=\"rect\" coords=\"273,23,279,32\" href=\"javascript:showColor('#FF99CC')\">
                <area shape=\"rect\" coords=\"281,23,287,32\" href=\"javascript:showColor('#FF99FF')\">
                <area shape=\"rect\" coords=\"1,34,7,43\" href=\"javascript:showColor('#006600')\">
                <area shape=\"rect\" coords=\"9,34,15,43\" href=\"javascript:showColor('#006633')\">
                <area shape=\"rect\" coords=\"17,34,23,43\" href=\"javascript:showColor('#006666')\">
                <area shape=\"rect\" coords=\"25,34,31,43\" href=\"javascript:showColor('#006699')\">
                <area shape=\"rect\" coords=\"33,34,39,43\" href=\"javascript:showColor('#0066CC')\">
                <area shape=\"rect\" coords=\"41,34,47,43\" href=\"javascript:showColor('#0066FF')\">
                <area shape=\"rect\" coords=\"49,34,55,43\" href=\"javascript:showColor('#336600')\">
                <area shape=\"rect\" coords=\"57,34,63,43\" href=\"javascript:showColor('#336633')\">
                <area shape=\"rect\" coords=\"65,34,71,43\" href=\"javascript:showColor('#336666')\">
                <area shape=\"rect\" coords=\"73,34,79,43\" href=\"javascript:showColor('#336699')\">
                <area shape=\"rect\" coords=\"81,34,87,43\" href=\"javascript:showColor('#3366CC')\">
                <area shape=\"rect\" coords=\"89,34,95,43\" href=\"javascript:showColor('#3366FF')\">
                <area shape=\"rect\" coords=\"97,34,103,43\" href=\"javascript:showColor('#666600')\">
                <area shape=\"rect\" coords=\"105,34,111,43\" href=\"javascript:showColor('#666633')\">
                <area shape=\"rect\" coords=\"113,34,119,43\" href=\"javascript:showColor('#666666')\">
                <area shape=\"rect\" coords=\"121,34,127,43\" href=\"javascript:showColor('#666699')\">
                <area shape=\"rect\" coords=\"129,34,135,43\" href=\"javascript:showColor('#6666CC')\">
                <area shape=\"rect\" coords=\"137,34,143,43\" href=\"javascript:showColor('#6666FF')\">
                <area shape=\"rect\" coords=\"145,34,151,43\" href=\"javascript:showColor('#996600')\">
                <area shape=\"rect\" coords=\"153,34,159,43\" href=\"javascript:showColor('#996633')\">
                <area shape=\"rect\" coords=\"161,34,167,43\" href=\"javascript:showColor('#996666')\">
                <area shape=\"rect\" coords=\"169,34,175,43\" href=\"javascript:showColor('#996699')\">
                <area shape=\"rect\" coords=\"177,34,183,43\" href=\"javascript:showColor('#9966CC')\">
                <area shape=\"rect\" coords=\"185,34,191,43\" href=\"javascript:showColor('#9966FF')\">
                <area shape=\"rect\" coords=\"193,34,199,43\" href=\"javascript:showColor('#CC6600')\">
                <area shape=\"rect\" coords=\"201,34,207,43\" href=\"javascript:showColor('#CC6633')\">
                <area shape=\"rect\" coords=\"209,34,215,43\" href=\"javascript:showColor('#CC6666')\">
                <area shape=\"rect\" coords=\"217,34,223,43\" href=\"javascript:showColor('#CC6699')\">
                <area shape=\"rect\" coords=\"225,34,231,43\" href=\"javascript:showColor('#CC66CC')\">
                <area shape=\"rect\" coords=\"233,34,239,43\" href=\"javascript:showColor('#CC66FF')\">
                <area shape=\"rect\" coords=\"241,34,247,43\" href=\"javascript:showColor('#FF6600')\">
                <area shape=\"rect\" coords=\"249,34,255,43\" href=\"javascript:showColor('#FF6633')\">
                <area shape=\"rect\" coords=\"257,34,263,43\" href=\"javascript:showColor('#FF6666')\">
                <area shape=\"rect\" coords=\"265,34,271,43\" href=\"javascript:showColor('#FF6699')\">
                <area shape=\"rect\" coords=\"273,34,279,43\" href=\"javascript:showColor('#FF66CC')\">
                <area shape=\"rect\" coords=\"281,34,287,43\" href=\"javascript:showColor('#FF66FF')\">
                <area shape=\"rect\" coords=\"1,45,7,54\" href=\"javascript:showColor('#003300')\">
                <area shape=\"rect\" coords=\"9,45,15,54\" href=\"javascript:showColor('#003333')\">
                <area shape=\"rect\" coords=\"17,45,23,54\" href=\"javascript:showColor('#003366')\">
                <area shape=\"rect\" coords=\"25,45,31,54\" href=\"javascript:showColor('#003399')\">
                <area shape=\"rect\" coords=\"33,45,39,54\" href=\"javascript:showColor('#0033CC')\">
                <area shape=\"rect\" coords=\"41,45,47,54\" href=\"javascript:showColor('#0033FF')\">
                <area shape=\"rect\" coords=\"49,45,55,54\" href=\"javascript:showColor('#333300')\">
                <area shape=\"rect\" coords=\"57,45,63,54\" href=\"javascript:showColor('#333333')\">
                <area shape=\"rect\" coords=\"65,45,71,54\" href=\"javascript:showColor('#333366')\">
                <area shape=\"rect\" coords=\"73,45,79,54\" href=\"javascript:showColor('#333399')\">
                <area shape=\"rect\" coords=\"81,45,87,54\" href=\"javascript:showColor('#3333CC')\">
                <area shape=\"rect\" coords=\"89,45,95,54\" href=\"javascript:showColor('#3333FF')\">
                <area shape=\"rect\" coords=\"97,45,103,54\" href=\"javascript:showColor('#663300')\">
                <area shape=\"rect\" coords=\"105,45,111,54\" href=\"javascript:showColor('#663333')\">
                <area shape=\"rect\" coords=\"113,45,119,54\" href=\"javascript:showColor('#663366')\">
                <area shape=\"rect\" coords=\"121,45,127,54\" href=\"javascript:showColor('#663399')\">
                <area shape=\"rect\" coords=\"129,45,135,54\" href=\"javascript:showColor('#6633CC')\">
                <area shape=\"rect\" coords=\"137,45,143,54\" href=\"javascript:showColor('#6633FF')\">
                <area shape=\"rect\" coords=\"145,45,151,54\" href=\"javascript:showColor('#993300')\">
                <area shape=\"rect\" coords=\"153,45,159,54\" href=\"javascript:showColor('#993333')\">
                <area shape=\"rect\" coords=\"161,45,167,54\" href=\"javascript:showColor('#993366')\">
                <area shape=\"rect\" coords=\"169,45,175,54\" href=\"javascript:showColor('#993399')\">
                <area shape=\"rect\" coords=\"177,45,183,54\" href=\"javascript:showColor('#9933CC')\">
                <area shape=\"rect\" coords=\"185,45,191,54\" href=\"javascript:showColor('#9933FF')\">
                <area shape=\"rect\" coords=\"193,45,199,54\" href=\"javascript:showColor('#CC3300')\">
                <area shape=\"rect\" coords=\"201,45,207,54\" href=\"javascript:showColor('#CC3333')\">
                <area shape=\"rect\" coords=\"209,45,215,54\" href=\"javascript:showColor('#CC3366')\">
                <area shape=\"rect\" coords=\"217,45,223,54\" href=\"javascript:showColor('#CC3399')\">
                <area shape=\"rect\" coords=\"225,45,231,54\" href=\"javascript:showColor('#CC33CC')\">
                <area shape=\"rect\" coords=\"233,45,239,54\" href=\"javascript:showColor('#CC33FF')\">
                <area shape=\"rect\" coords=\"241,45,247,54\" href=\"javascript:showColor('#FF3300')\">
                <area shape=\"rect\" coords=\"249,45,255,54\" href=\"javascript:showColor('#FF3333')\">
                <area shape=\"rect\" coords=\"257,45,263,54\" href=\"javascript:showColor('#FF3366')\">
                <area shape=\"rect\" coords=\"265,45,271,54\" href=\"javascript:showColor('#FF3399')\">
                <area shape=\"rect\" coords=\"273,45,279,54\" href=\"javascript:showColor('#FF33CC')\">
                <area shape=\"rect\" coords=\"281,45,287,54\" href=\"javascript:showColor('#FF33FF')\">
                <area shape=\"rect\" coords=\"1,56,7,65\" href=\"javascript:showColor('#000000')\">
                <area shape=\"rect\" coords=\"9,56,15,65\" href=\"javascript:showColor('#000033')\">
                <area shape=\"rect\" coords=\"17,56,23,65\" href=\"javascript:showColor('#000066')\">
                <area shape=\"rect\" coords=\"25,56,31,65\" href=\"javascript:showColor('#000099')\">
                <area shape=\"rect\" coords=\"33,56,39,65\" href=\"javascript:showColor('#0000CC')\">
                <area shape=\"rect\" coords=\"41,56,47,65\" href=\"javascript:showColor('#0000FF')\">
                <area shape=\"rect\" coords=\"49,56,55,65\" href=\"javascript:showColor('#330000')\">
                <area shape=\"rect\" coords=\"57,56,63,65\" href=\"javascript:showColor('#330033')\">
                <area shape=\"rect\" coords=\"65,56,71,65\" href=\"javascript:showColor('#330066')\">
                <area shape=\"rect\" coords=\"73,56,79,65\" href=\"javascript:showColor('#330099')\">
                <area shape=\"rect\" coords=\"81,56,87,65\" href=\"javascript:showColor('#3300CC')\">
                <area shape=\"rect\" coords=\"89,56,95,65\" href=\"javascript:showColor('#3300FF')\">
                <area shape=\"rect\" coords=\"97,56,103,65\" href=\"javascript:showColor('#660000')\">
                <area shape=\"rect\" coords=\"105,56,111,65\" href=\"javascript:showColor('#660033')\">
                <area shape=\"rect\" coords=\"113,56,119,65\" href=\"javascript:showColor('#660066')\">
                <area shape=\"rect\" coords=\"121,56,127,65\" href=\"javascript:showColor('#660099')\">
                <area shape=\"rect\" coords=\"129,56,135,65\" href=\"javascript:showColor('#6600CC')\">
                <area shape=\"rect\" coords=\"137,56,143,65\" href=\"javascript:showColor('#6600FF')\">
                <area shape=\"rect\" coords=\"145,56,151,65\" href=\"javascript:showColor('#990000')\">
                <area shape=\"rect\" coords=\"153,56,159,65\" href=\"javascript:showColor('#990033')\">
                <area shape=\"rect\" coords=\"161,56,167,65\" href=\"javascript:showColor('#990066')\">
                <area shape=\"rect\" coords=\"169,56,175,65\" href=\"javascript:showColor('#990099')\">
                <area shape=\"rect\" coords=\"177,56,183,65\" href=\"javascript:showColor('#9900CC')\">
                <area shape=\"rect\" coords=\"185,56,191,65\" href=\"javascript:showColor('#9900FF')\">
                <area shape=\"rect\" coords=\"193,56,199,65\" href=\"javascript:showColor('#CC0000')\">
                <area shape=\"rect\" coords=\"201,56,207,65\" href=\"javascript:showColor('#CC0033')\">
                <area shape=\"rect\" coords=\"209,56,215,65\" href=\"javascript:showColor('#CC0066')\">
                <area shape=\"rect\" coords=\"217,56,223,65\" href=\"javascript:showColor('#CC0099')\">
                <area shape=\"rect\" coords=\"225,56,231,65\" href=\"javascript:showColor('#CC00CC')\">
                <area shape=\"rect\" coords=\"233,56,239,65\" href=\"javascript:showColor('#CC00FF')\">
                <area shape=\"rect\" coords=\"241,56,247,65\" href=\"javascript:showColor('#FF0000')\">
                <area shape=\"rect\" coords=\"249,56,255,65\" href=\"javascript:showColor('#FF0033')\">
                <area shape=\"rect\" coords=\"257,56,263,65\" href=\"javascript:showColor('#FF0066')\">
                <area shape=\"rect\" coords=\"265,56,271,65\" href=\"javascript:showColor('#FF0099')\">
                <area shape=\"rect\" coords=\"273,56,279,65\" href=\"javascript:showColor('#FF00CC')\">
                <area shape=\"rect\" coords=\"281,56,287,65\" href=\"javascript:showColor('#FF00FF')\">
                </map>
                <a><img usemap=\"#colmap\" src=\"{$Globals['idir']}/colortable.gif\" border=0 width=289 height=67></a>
                <br /><br />Click a box and the hexadecimal color will be shown below. Use these hex values for color box settings.<br><br>
                <b>Hex Value</b><br /><input type=\"text\" name=\"smallcal_hexval\" size=\"10\" readonly><br /><br />";

            $output .= "<br /><table cellpadding=\"2\" cellspacing=\"1\" border=\"1\">";

            $output .= "Use the box below to edit this stylesheet.<br /><br />
            <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\">
            <input type=\"hidden\" name=\"final\" value=\"yes\">
            <input type=\"hidden\" name=\"admact\" value=\"style\">
            <input type=\"hidden\" name=\"stylesheet\" value=\"$stylesheet\">
            <textarea name=\"body\" cols=\"100\" rows=\"20\" class=\"{$Style['formboxes']}\">";

            $tempfile = file("$PP_PATH/stylesheets/$stylesheet");
            while (list($linenum,$line) = each($tempfile))
            {
                $output .= "$line";
            }

            $output .= "</textarea><br /><br /><input type=\"submit\" value=\"Update $stylesheet\" class=\"buttons\"></form>";
            $output .= "<br /></td></tr></table></td></tr></table>";

            print $output;

            adminfooter();
            exit;
        }
    }
}

//
// Edit header file
//

if ( $admact == "editfile" )
{
    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    if ( $whichfile == "header" )
    {
        $infile = $Globals['header'];
        $title = "Header";
    }
    elseif ( $whichfile == "footer" )
    {
        $infile = $Globals['footer'];
        $title = "Footer";
    }
    elseif ( $whichfile == "htaccess" )
    {
        $infile = "{$Globals['datafull']}.htaccess";
        $title = "htaccess";
    }
    elseif ( $whichfile == "origaccess" )
    {
        $infile = "{$Globals['origfull']}.htaccess";
        $title = "htaccess";
    }
    else
    {
        $infile = $Globals['headtags'];
        $title = "Headtags";
    }

    if ( empty( $infile ) )
    {
        diewell( "The path to the $title file is not set in your Admin Global Options." );
    }

    adminheader( 0, "PhotoPost $title Editor" );

    $output .= "<div align=\"center\">
        <form name=\"f\" action=\"{$Globals['maindir']}/adm-misc.php\" method=\"POST\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\" width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\">
        <span class=\"{$Style['large']}\"><b>PhotoPost $title Editor</span>
        </td>
        </tr><tr>
        <td class=\"{$Style['tddetails']}\"><div align=\"center\">";

    if ( $_POST['final'] == "yes" )
    {
        $body = (ini_get("magic_quotes_gpc")) ? stripslashes($body) : $body;
        $body = preg_replace("/\r/","", stripslashes(convert_html($body)));
        $bodyparts = split("\n",$body);

        $size = sizeof($bodyparts);

        for ( $i = 0; $i < $size; $i++ )
        {
            $line = $bodyparts[$i];
            $line .="\r\n";
            $newbody .= $line;
        }

        if ( strstr($infile, "..") )
        {
            print "Error in filename format: $infile";
            exit;
        }

        if ( !file_exists($infile) || !is_writable($infile) )
        {
            $fd = @fopen( $infile, "w+" );
            @fclose($fd);

            if ( !is_writable($infile) )
            {
                diewell( "Unable to create or fix permissions for the file: $infile<br /><br />Correct the permissions or set the file path in the Admin Global Options." );
            }
        }

        $fd = fopen($infile,"w");

        if ( !$fd )
        {
            print "$output<br />Unable to write changes, permissions on {$infile} are not set properly.<br />Please correct and resubmit.<br />";
            print "<br /></td></tr></table></td></tr></table>";
            exit;
        }

        fwrite($fd,$newbody);
        fclose($fd);

        adminlog( "Edited $title" );

        print "$output<br />$title saved.<br />";
        print "<br /></td></tr></table></td></tr></table>";
        exit;
    }

    $output .= "<br />File being edited: $infile<br />";

    if ( !file_exists($infile) || !is_writable($infile) )
    {
        $output .= "<br />Warning: This file does not exist or is not writable; when you submit this form we will attempt
                    to create this file.<br />If we are unable to do so (check your path and permissions), then
                    we will notify you of the error.<br />";
    }

    $output .= "<br /><table cellpadding=\"2\" cellspacing=\"1\" border=\"1\">";

    $output .= "<form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\">
        <input type=\"hidden\" name=\"final\" value=\"yes\">
        <input type=\"hidden\" name=\"admact\" value=\"editfile\">
        <input type=\"hidden\" name=\"whichfile\" value=\"$whichfile\">
        <textarea name=\"body\" cols=\"100\" rows=\"20\" class=\"{$Style['formboxes']}\">";

    $tempfile = @file($infile);

    if ( $tempfile )
    {
        while (list($linenum,$line) = each($tempfile))
        {
            $output .= "$line";
        }
    }

    $output .= "</textarea><br /><br /><input type=\"submit\" value=\"Update $title\" class=\"buttons\"></form>";
    $output .= "<br /></td></tr></table></td></tr></table>";

    print $output;

    adminfooter();
    exit;
}

//
// Edit header file
//

if ( $admact == "storage" )
{
    ini_set("max_execution_time", 0);

    if ( $User['adminedit'] != 1 )
    {
        diewell( "You are not a valid administrator!" );
    }

    adminheader( 0, "PhotoPost Image Protection System" );

    $output .= "<div align=\"center\">
        <form name=\"f\" action=\"{$Globals['maindir']}/adm-misc.php\" method=\"POST\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\" width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\">
        <span class=\"{$Style['large']}\"><b>PhotoPost Image Protection System</span>
        </td>
        </tr><tr>
        <td class=\"{$Style['tddetails']}\"><div align=\"center\">";

    if ( $revert == "yes" )
    {
        ppmysql_query("UPDATE {$pp_db_prefix}settings SET setting='".addslashes($Globals['datadir'])."' WHERE id=207", $link);
        ppmysql_query("UPDATE {$pp_db_prefix}settings SET setting='".addslashes($Globals['datafull'])."' WHERE id=208", $link);
        $final = "no";
    }

    if ( $final == "yes" )
    {

        if ( $delimages == "yes" )
        {
            // Step 4, delete the images from the data directory
            $errors = null;

            $queryv = ppmysql_query("SELECT id,user,userid,cat,storecat,bigimage FROM {$pp_db_prefix}photos ORDER BY id", $link);

            while ( list( $id, $user, $tuserid, $cat, $storecat, $bigimage ) = mysql_fetch_row($queryv) )
            {
                // Ignore copies
                if ( $storecat != 0 )
                {
                    continue;
                }

                $oldfile = "{$Globals['datafull']}$cat/$bigimage";

                if ( !@unlink( $oldfile ) ) {
                    $errors .= "Unable to delete $oldfile<br />";
                }
            }

            if ( $errors )
            {
$output .= <<<PPPRINT
<br /><table cellpadding="2" cellspacing="1" border="1"><tr><td align="center">
We experienced errors during this part of the conversion; however, the conversion has completed.<br /><br />
You will need to manually delete any images which could not be removed:<br /><br />
$errors
<br /></td></tr></table></td></tr></table>
PPPRINT;

                print $output;
                exit;
            }

$output .= <<<PPPRINT
<br /><table cellpadding="2" cellspacing="1" border="1"><tr><td align="center">
The images from your old location have been copied to your new location:<br /><br />
{$Globals['origdir']}<br /><br />
Your galleries should now be updated and working with the originals located in the new location.<br /><br />
Please verify this by <a href="index.php" target="_blank">opening your gallery in another browser window</a> and checking to make sure your images
are all appearing as expected. Once you have verified that your gallery is working as expected, you can continue
by clicking on the button below to remove all the images from their previous location.<br /><br />

If you experienced any problems, you will have to correct them or revert your settings back to the default
values to put the system back the way it was. You can revert your settings by going back to the
<b>Storage Options</b> section and checking the Revert boxes.<br /><br />
<form action="{$Globals['maindir']}/adm-misc.php" method="post">
<input type="hidden" name="final" value="yes" />
<input type="hidden" name="delimages" value="yes" />
<input type="hidden" name="admact" value="storage" />
<br /><br /><input type="submit" value="Remove Images from old location >>>" class="buttons" /></form>
<br /></td></tr></table></td></tr></table>
PPPRINT;

            print $output;
            exit;
        }

        if ( $copyimages == "yes" )
        {
            // Step 3, copy the images
            $errors = null;

            $queryv = ppmysql_query("SELECT id,user,userid,cat,storecat,bigimage FROM {$pp_db_prefix}photos ORDER BY id", $link);

            while ( list( $id, $user, $tuserid, $cat, $storecat, $bigimage ) = mysql_fetch_row($queryv) )
            {
                // Ignore copies
                if ( $storecat != 0 )
                {
                    continue;
                }

                $oldfile = "{$Globals['datafull']}$cat/$bigimage";
                $newfile = "{$Globals['origfull']}$cat/$bigimage";

                if ( file_exists($oldfile) && !file_exists($newfile) )
                {
                    $success = @copy( $oldfile, $newfile );

                    if ( !$success )
                    {
                        $errors .= "Unable to copy $oldfile to new location: $newfile<br />";
                    }

                    @chmod( $newfile, 0666 );
                }
            }

            if ( $errors )
            {
$output .= <<<PPPRINT
<br /><table cellpadding="2" cellspacing="1" border="1"><tr><td align="center">
We experienced errors during this part of the conversion. Your settings were not updated, correct any problems and resubmit.<br /><br />
$errors
<br /></td></tr></table></td></tr></table>
PPPRINT;

                print $output;
                exit;
            }

$output .= <<<PPPRINT
<br /><table cellpadding="2" cellspacing="1" border="1"><tr><td align="center">
The images from your old location have been copied to your new location:<br /><br />
{$Globals['origfull']}<br /><br />
Your galleries should now be updated and working with the originals located in the new location.<br /><br />
Please verify this by opening your gallery in another browser window and checking to make sure your images
are all appearing as expected. Once you have verified that your gallery is working as expected, you can continue
by clicking on the button below to remove all the images from their previous location.<br /><br />
Be careful, once you have removed the files from the default location, it is a manual process to put them
back into place.<br /><br />
If you experienced any problems, you will have to correct them or revert your settings back to the default
values to put the system back the way it was. You can revert your settings by going back to the
<b>Storage Options</b> section and checking the Revert boxes.<br /><br />
<form action="{$Globals['maindir']}/adm-misc.php" method="post">
<input type="hidden" name="final" value="yes" />
<input type="hidden" name="delimages" value="yes" />
<input type="hidden" name="admact" value="storage" />
<br /><br /><input type="submit" value="Remove Images from old location >>>" class="buttons" /></form>
<br /></td></tr></table></td></tr></table>
PPPRINT;

            print $output;
            exit;
        }

        if ( empty($newpath) || empty($newurl) )
        {
            diewell( "You must fill in both values to process this form." );
        }

        if ( $newpath == $Globals['origfull'] )
        {
            diewell( "Values were not changed. No action taken." );
        }

        // Remove final slash (if present)
        $len = strlen($newpath)-1;

        if( $newpath[$len] == "/" )
        {
            $newpath[$len] = " ";
        }

        $newpath = trim($newpath);

        if ( !is_writable($newpath) )
        {
            @mkdir( $newpath );
            @chmod( $newpath, 0777 );

            if ( !is_writable($newpath) )
            {
                diewell("Unable to create/write to $newpath! Check your data directory permissions before continuing.<br /><br />
                         When you have fixed your permissions Refresh this page to try again.");
            }

            // create a blank index.htm file
            $fd = fopen( "$newpath/index.htm", "w+" );
            fclose($fd);
        }

        $newpath = "$newpath/";

        // Create tree if needed
        $resultb = ppmysql_query("SELECT id,catname FROM {$pp_db_prefix}categories", $link);

        while ( list( $thecatid, $thecatname ) = mysql_fetch_row($resultb) )
        {
            $newdir = $newpath."$thecatid/";

            // First, lets see if we need to make it or change permissions
            if ( !is_writable($newdir) )
            {
                mkppdir( $newdir, true );
            }
        }

        ppmysql_query("UPDATE {$pp_db_prefix}settings SET setting='".addslashes($newpath)."' WHERE id=208", $link);
        ppmysql_query("UPDATE {$pp_db_prefix}settings SET setting='".addslashes($newurl)."' WHERE id=207", $link);

        // Tree created, now do we move images?
$output .= <<<PPPRINT
<table cellpadding="2" cellspacing="1" border="1"><tr><td align="center">
The new directory structure has been created for your original images at:<br /><br />
$newpath<br /><br />
If you have not already done so, you will need to copy the original images to this new
location. This can take some time, so please give the script plenty of time to do its work if
you have alot of images.<br />
<script>
function submitonce(theform){
    if (document.all||document.getElementById)
    {
    for ( i=0; i<theform.length; i++)
    {
        var tempobj=theform.elements[i]
        if( tempobj.type.toLowerCase()=="submit" )
            tempobj.disabled=true
        }
    }
}
</script>
<form action="{$Globals['maindir']}/adm-misc.php" method="post" onSubmit="submitonce(this)">
<input type="hidden" name="final" value="yes" />
<input type="hidden" name="copyimages" value="yes" />
<input type="hidden" name="admact" value="storage" />
<br /><br /><input type="submit" value="Copy Images >>>" class="buttons" /></form>
<br /></td></tr></table></td></tr></table>
PPPRINT;

        print $output;
        exit;
    }

    $output .= "<table cellpadding=\"2\" cellspacing=\"1\" border=\"1\"><tr><td align=\"center\">";

$output .= <<<PPPRINT
The PhotoPost Image Protection System (IPS) allows you to configure your image directories such that the
original images are not located in the same directory tree as your thumbnails and medium images. If you want
to protect the original images from anyone except those you give permission to, then you will want to use
this system to relocate your files and establish policies to prevent unauthorized access.<br /><br />
PPPRINT;

if ( $Globals['datafull'] == $Globals['origfull'] )
{
$output .= <<<PPPRINT
By default, PhotoPost stores the original images in a directory with subdirectories for thumbnail and medium
sized images. To change the location of your original images, you need to edit these two variables to reflect
the URL and PATH to the new location.<br /><br />

Only change these values if you want to move the location where your original images are stored. If you
submit this form with changed settings, then we will attempt to create the new directory structure and
copy all original images to this new location. Only after this process has completed will we remove the
images from their previous location. Keep in mind, if you change the location of your orignial images any
links which you have placed which point to these images will no longer be valid.<br /><br />
PPPRINT;
}
else
{
$output .= <<<PPPRINT
<b>It appears you have already moved your images to a new location, so you need to proceed with caution when
changing your settings again.</b><br /><br />
If you have not removed the images from the original location and want to revert to those settings, then
you can click the checkbox below and your system will revert to the default setup.<br /><br />
If you have moved your images and they are no longer in your data directory, then you will have to manually
rename your directory and then enter the new paths here. Once you have done this, you do not need to perform
any of the other steps since there are no images to move you are only updating your paths.<br /><br />
If you moved your images to the new location, but want to revert back to the default setup where the images
are stored in the same directory tree as the thumb/medium images, then you will need to manually copy
the current structure into the current data directory structure - don't worry, none of the thumbnail or medium
images will be lost as long as you copy the files. Once the files have been moved/copied into the data directory
you can revert the settings to have it back the way it was by default.<br /><br />
PPPRINT;
}

$output .= <<<PPPRINT
<table cellpadding="0" cellspacing="0" border="0" class="{$Style['tableborders']}"  width="80%" align="center">
<tr><td>
<table cellpadding="2" cellspacing="1" border="0" width="100%">
<tr>
<td align="center" class="{$Style['menubar']}" colspan="2">
<span class="{$Style['large']}"><b>Current settings</b></span>
</td>
</tr><tr>
<td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
Current PATH setting:
</td><td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
<b>{$Globals['origfull']}</b>
</td></tr><tr>
<td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
Default PATH setting:
</td><td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
{$Globals['datafull']}
</td>
</tr><tr>
<td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
Current URL setting:
</td><td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
<b>{$Globals['origdir']}</b>
</td></tr><tr>
<td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
Default URL setting:
</td><td class="{$Style['tddetails']}" nowrap="nowrap" align="left">
{$Globals['datadir']}
</td></tr></table></td></tr></table>
<br />
If you are sure you want to change these values, enter the new locations below:<br /><br />
<form action="{$Globals['maindir']}/adm-misc.php" method="post">
Enter new PATH setting: <input type="text" size="50" name="newpath" /><br />
Enter new URL setting: <input type="text" size="50" name="newurl" /><br />
<input type="hidden" name="final" value="yes" />
<input type="hidden" name="admact" value="storage" />
<input type="checkbox" name="revert" value="yes" /> check here to revert values back to default

<br /><br /><input type="submit" value="Update Storage Options" class="buttons" /></form>
<br /></td></tr></table></td></tr></table>
PPPRINT;

    print $output;

    adminfooter();
    exit;
}

if ( $admact == "admsubscribe" )
{
    if ( $User['adminedit'] != 1 )
	{
        diewell( "You are not a valid administrator!" );
        exit;
    }

    if ( $Globals['processor'] != "paypal" )
	{
        diewell( "You must set your payment processor to Paypal to use this Feature!" );
        exit;
    }

    if ( empty($subid) ) $subid="";

    if ($ppaction == "delsub")  //# Delete a subscription
	{
        if ($do == "process") //# Process delete cat
		{
            if ($subid != 0 && is_numeric($subid))
            {
                $subq = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}subscriptions WHERE id=$subid", $link);

            }
            else
			{
                diewell("Invalid Subscription ID.");
            }

            adminlog( "Deleted a Subscription: $subid" );

            forward( "adm-misc.php?admact=admsubscribe&ppaction=subscriptions", "Processing complete!" );
            exit;
        }

        //# Generate an 'are you sure' you want to delete? form...

        $listsub = ppmysql_query("SELECT name FROM {$Globals['pp_db_prefix']}subscriptions WHERE id=$subid", $link);
        list( $subname ) = mysql_fetch_row($listsub);

        adminheader( 0, "PhotoPost Subscriptions" );

        $output="<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
            <tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr>
            <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Add a Category</span></td>
            </tr><tr>
            <td class=\"{$Style['tddetails']}\">
            <div align=\"center\"><br />
            You're about to delete the subscription called \"$subname\".<p>
            Are you sure you want to do that?
            <form action=\"{$Globals['maindir']}/adm-misc.php\" method=\"post\"><input type=\"hidden\" name=\"admact\" value=\"admsubscribe\">
            <input type=\"hidden\" name=\"subid\" value=\"$subid\">
            <input type=\"hidden\" name=\"do\" value=\"process\">
            <input type=\"hidden\" name=\"ppaction\" value=\"delsub\">
            <input type=\"submit\"
            value=\"I'm sure, delete the subscription.\"></form></span></td></tr></table></td></tr></table>";

        print "$output<br /><br />";
        adminfooter();
    }

    if ($ppaction == "addsub") //# Add a subscription
    {
	    if ($_POST['do'] == "process")
		{
            // Process a user's subscription submission

            $subname = stripslashes(un_htmlspecialchars($subname));
            $subdesc = stripslashes(un_htmlspecialchars($subdesc));

            $setug = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}subscriptions VALUES (NULL, '$subname', '$subdesc', '$subgroup', '$subduration', '$subdays', '$subprice', '$subactive');", $link);
            $thesubid = mysql_insert_id( $link );

            if ( $thesubid == 0 )
			{
                diewell( "Error adding new subscription to the database. Returned id was 0." );
                exit;
            }

            adminlog( "Added a subscription: $subname" );

            forward("adm-misc.php?admact=admsubscribe&ppaction=subscriptions", "Processing complete!" );
            exit;
        }

        $groupopt = "";

	    $groups = ppmysql_query("SELECT groupid,groupname FROM {$Globals['pp_db_prefix']}usergroups", $link);
	    while ( list( $groupid, $ugusergroup ) = mysql_fetch_row( $groups ) )
	    {
	        $groupopt .= "<option value=\"$groupid\">$ugusergroup</option>";
	    }

		$groupsort = "<select name=\"subgroup\">$groupopt</select>";

        //# Print out the Add a subscription HTML form

        adminheader( 0, "PhotoPost Subscriptions" );

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\" width=\"{$Globals['tablewidth']}\" align=\"center\">
            <tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr align=\"center\">
            <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Add a Subscription</span></td>
            </tr><tr>
            <td class=\"{$Style['tdbackground']}\"><div align=\"center\"><br />

            <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" class=\"{$Style['tableborders']}\">
            <form method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\"><input type=\"hidden\" name=\"admact\" value=\"admsubscribe\">
            <tr><td class=\"{$Style['tddetails']}\">
            <table border=\"0\" cellpadding=\"5\" cellspacing=\"1\">
            <tr><td class=\"{$Style['menubar']}\">Subscription Name</td>
            </tr><tr>
            <td>
            <input type=\"text\" size=\"50\" value=\"\" name=\"subname\" class=\"{$Style['bginput']}\"></td></tr>
            <tr><td class=\"{$Style['menubar']}\">Subscription Description</td>
            </tr><tr>
            <td><textarea name=\"subdesc\" cols=\"30\" rows=\"3\" class=\"{$Style['bginput']}\"></textarea></td></tr>
            <tr><td class=\"{$Style['menubar']}\">Subscription Usergroup</td>
            </tr><tr>
            <td>$groupsort</td></tr>
            <tr><td class=\"{$Style['menubar']}\">Subscription Duration<br /><span class=\"{$Style['small']}\">This is the friendly duration name as in 1 week, 1 month, 1 year etc.</span></td>
            </tr><tr>
            <td>
            <input type=\"text\" size=\"50\" value=\"\" name=\"subduration\" class=\"{$Style['bginput']}\"></td></tr>
            <tr><td class=\"{$Style['menubar']}\">Subscription Length in Days<br /><span class=\"{$Style['small']}\">This is the actual numeric days for the subscriptions IE. 7 for one week, 365 for one year etc.</span></td>
            </tr><tr>
            <td>
            <input type=\"text\" size=\"50\" value=\"\" name=\"subdays\" class=\"{$Style['bginput']}\"></td></tr>
            <tr><td class=\"{$Style['menubar']}\">Subscription Price<br /></td>
            </tr><tr>
            <td>
            <input type=\"text\" size=\"50\" value=\"\" name=\"subprice\" class=\"{$Style['bginput']}\"></td></tr>
            <tr><td class=\"{$Style['menubar']}\">Subscription Active?</td>
            </tr><tr>
            <td>
	        <select name=\"subactive\" class=\"{$Style['bginput']}\"><option selected=\"selected\" value=\"yes\">Yes</option><option value=\"no\">No</option></select>
			</td></tr>
            </table></td></tr></table><p>
            <input type=\"hidden\" name=\"ppaction\" value=\"addsub\">
            <input type=\"hidden\" name=\"do\" value=\"process\">
            <input type=\"submit\" value=\"Add Subscription\"></form></td></tr></table></td></tr></table>";

        print "$output<br /><br />";
        adminfooter();
    }


    //# Edit categories

    if ($ppaction == "editsub")
	{
        adminheader( 0, "PhotoPost Subscriptions" );

        $subs = ppmysql_query("SELECT id,name,description,gid,duration,days,price,isactive FROM {$Globals['pp_db_prefix']}subscriptions WHERE id=$subid", $link);

        while ( list($id,$subname,$subdesc,$subgroup,$subduration,$subdays,$subprice,$subactive) = mysql_fetch_row($subs) ) {

		    $groups = ppmysql_query("SELECT groupid,groupname FROM {$Globals['pp_db_prefix']}usergroups", $link);
		    while ( list( $groupid, $ugusergroup ) = mysql_fetch_row( $groups ) )
		    {
			    if ($subgroup == $groupid )
				{
			        $groupopt .= "<option selected=\"selected\" value=\"$groupid\">$ugusergroup</option>";
			    }
			    else
				{
			        $groupopt .= "<option value=\"$groupid\">$ugusergroup</option>";
	   		    }
		    }

			$groupsort = "<select name=\"gid-$id\">$groupopt</select>";

		    if ($subactive == "yes")
			{
		        $activeopt = "<option selected>yes</option><option>no</option>";
		    }
		    else
			{
		        $activeopt = "<option selected>no</option><option>yes</option>";
		    }

            $subname = htmlentities( $subname, ENT_QUOTES,'utf-8');
            $subdesc = htmlentities( $subdesc, ENT_QUOTES,'utf-8');

            $output = "<div align=\"center\">
                <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
                align=\"center\"><tr><td>
                <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
                <tr align=\"center\">
                <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Subscription Editor</b></span></td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
                <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"{$Style['tableborders']}\">
                <tr><td>
                <form method=\"post\" action=\"{$Globals['maindir']}/adm-misc.php\"><input type=\"hidden\" name=\"admact\" value=\"admsubscribe\"><tr><td>
                <table border=\"0\" cellpadding=\"5\" cellspacing=\"1\">
                <tr>
                <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Subscription Name</td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\" align=\"left\">
                <input type=\"text\" size=\"50\" value=\"$subname\" name=\"name-$id\" class=\"{$Style['bginput']}\"></td>
                </tr>
                <tr>
                <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Subscription Description</td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\">
                <textarea name=\"description-$id\" cols=\"38\" rows=\"3\" class=\"{$Style['bginput']}\">$subdesc</textarea></td></tr>
                </tr>
                <tr>
                <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Subscription Usergroup</td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\">
                $groupsort
                </td></tr>
                <tr>
                <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Subscription Duration</span></td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\" align=\"left\">
                <input type=\"text\" size=\"50\" value=\"$subduration\" name=\"duration-$id\" class=\"{$Style['bginput']}\">
                </td>
                </tr>
                <tr>
                <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Subscription Days</td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\">
                <input type=\"text\" size=\"50\" value=\"$subdays\" name=\"days-$id\" class=\"{$Style['bginput']}\">
                </td></tr>
                <tr>
                <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Subscription Price</td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\">
                <input type=\"text\" size=\"50\" value=\"$subprice\" name=\"price-$id\" class=\"{$Style['bginput']}\">
                </td></tr>
                <tr>
                <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Subscription Active?</td>
                </tr>
                <tr>
                <td class=\"{$Style['tddetails']}\">
    			<select name=\"isactive-$id\" class=\"{$Style['bginput']}\">$activeopt</select>
                </td></tr>";

            $output .= "</table></td></tr></table><br /><br />
                <input type=\"hidden\" name=\"subid\" value=\"$id\">
                <input type=\"hidden\" name=\"ppaction\" value=\"subscriptions\">
                <input type=\"hidden\" name=\"do\" value=\"process\">
                <input type=\"submit\" value=\"Save Changes\"></form></td></tr></table></td></tr></table>";
        }

        print "$output<br /><br />";
        adminfooter();
        exit;
    }

    if ( $ppaction == "subscriptions" )
    {
        if ( $_POST['do'] == "process" )
        {
            typecast($_POST, array('subid' => INT));

            foreach( $_POST as $vid => $setting )
    	    {
                $ugorder = explode("-", $vid);
                $catvar = $ugorder[0];
                $ugid = 0; $query = null;
                $setting = (ini_get("magic_quotes_gpc")) ? addslashes(stripslashes(trim($setting))) : addslashes(trim($setting));

                if ( count($ugorder) > 1 )
                {
                    $ugid = $ugorder[1];
                }

                $query = null;
                if ( !empty($ugid) )
    	        {
                    $query = "UPDATE {$Globals['pp_db_prefix']}subscriptions SET $catvar='$setting' WHERE id=$ugid";
        			$resulta = ppmysql_query($query, $link);
                }
            }

            adminlog( "Edited a subscription: $subid" );

            forward( "adm-misc.php?admact=admsubscribe&ppaction=subscriptions", "Processing complete!" );
            exit;
        }

        //# Generate the edit subcriptions HTML form
        adminheader( 0, "PhotoPost Subscriptions" );

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
            align=\"center\"><tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr align=\"center\">
            <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Subscription Editor</b></span></td>
            </tr>
            <tr>
            <td class=\"{$Style['tddetails']}\" align=\"left\"><br /><br /><a href=\"{$Globals['maindir']}/adm-misc.php?admact=admsubscribe&ppaction=addsub\">Add Subscription</a></font><br />";

        subli(0);

        $output .= "<p></td></tr></table></td></tr></table>";

        print $output;
        adminfooter();
    }

    if ( $ppaction == "listsubs" ) //# Add a subscription
    {
        if ( $do == "delete" ) //# Process delete subscription
		{
            if ( $subid != 0 && is_numeric($subid) )
            {
		        $rows = ppmysql_query("SELECT userid,oldid FROM {$Globals['pp_db_prefix']}paid_subscriptions WHERE id=$subid", $link);
				list( $subuser, $oldgroup ) = mysql_fetch_row($rows);

                $subq = ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}paid_subscriptions WHERE id=$subid", $link);

                upgradesubscriber( $oldgroup, $subuser );
            }
            else
			{
                diewell("Invalid Paid Subscription ID.");
            }

            adminlog( "Deleted a Subscriber: $subusername" );

            forward( "adm-misc.php?admact=admsubscribe&ppaction=listsubs", "Subscriber Deleted" );
            exit;
        }

        //# Print out the subscription list

        adminheader( 0, "PhotoPost Subscriber List" );

        $output = "<div align=\"center\">
            <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\" width=\"{$Globals['tablewidth']}\" align=\"center\">
            <tr><td>
            <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
            <tr align=\"center\">
            <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Subscriber List</span></td>
            </tr><tr>
            <td class=\"{$Style['tdbackground']}\"><div align=\"center\"><br />

            <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" class=\"{$Style['tableborders']}\">
            <tr><td class=\"{$Style['tddetails']}\">
            <table border=\"0\" cellpadding=\"5\" cellspacing=\"1\">
            <tr><td class=\"{$Style['menubar']}\">Subscriber Name</td>
            <td class=\"{$Style['menubar']}\">Subscription Start Date</td>
            <td class=\"{$Style['menubar']}\">Subscription End Date</td>
            <td class=\"{$Style['menubar']}\">Subscription Type</td>
            <td class=\"{$Style['menubar']}\">Action</td>
            </tr>";

        $rows = ppmysql_query("SELECT p.id,p.userid,p.start,p.end,s.name
                  FROM {$Globals['pp_db_prefix']}paid_subscriptions p
                  LEFT JOIN {$Globals['pp_db_prefix']}subscriptions s ON s.id=p.subid", $link);

		while( list( $subid, $subuser, $substart, $subend, $subgroupname ) = mysql_fetch_row($rows) )
        {
	        $substart = formatppdate( $substart );
	        $subend = formatppdate( $subend );
            list( $subchkid, $subusername, $submail ) = get_userinfo( "" , $subuser);

	        $output .= "<tr>
	            <td class=\"{$Style['tddetails']}\">$subusername</td>
	            <td class=\"{$Style['tddetails']}\">$substart</td>
	            <td class=\"{$Style['tddetails']}\">$subend</td>
	            <td class=\"{$Style['tddetails']}\">$subgroupname</td>
	            <td class=\"{$Style['tddetails']}\"><a href=\"{$Globals['maindir']}/adm-misc.php?admact=admsubscribe&amp;ppaction=listsubs&amp;do=delete&amp;subid=$subid\">Delete</a></td></tr>";

        }

        $output .= "</table></td></tr></table><p></td></tr></table></td></tr></table>";

        print "$output<br /><br />";
        adminfooter();
    }
}

?>
