<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

ini_set("max_execution_time", 0);
require "pp-inc.php";

//
// Style references
//

$Style['onbody'] = "onbody";
$Style['tableborders'] = "tableborders";
$Style['tddetails'] = "tddetails";
$Style['tdbackground'] = "tdbackground";
$Style['tdnothumbs'] = "tdnothumbs";
$Style['menubar'] = "menubar";
$Style['menubarnb'] = "menubarnb";
$Style['catcolumn'] = "catcolumn";
$Style['photocol'] = "photocol";
$Style['commentscol'] = "commentscol";
$Style['lastphocol'] = "lastphocol";
$Style['lastcommcol'] = "lastcommcol";
$Style['small'] = "small";
$Style['medium'] = "medium";
$Style['large'] = "large";
$Style['welcome'] = "welcome";
$Style['lighttable'] = "lighttable";
$Style['alternatetable'] = "alternatetable";
$Style['formboxes'] = "formboxes";
$Style['blockquote'] = "blockquote";

function adminheader( $thecat, $titlereplace )
{
    global $Globals, $User, $link, $contentmeta;

    $headtagsopen = $Globals['headtags'];

    print "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dt\">
<html>
<head>
<title>{$titlereplace} - {$Globals['galleryname']} - Powered by PhotoPost</title>
$contentmeta
<!-- no cache headers -->
<meta name=description content='See {$titlereplace} on our {$Globals['galleryname']} picture gallery - {$titlereplace}' />
<meta http-equiv=\"pragma\" content=\"no-cache\" />
<meta http-equiv=\"expires\" content=\"Tue, 21 Nov 2000 05:00:00 GMT\" />
<meta http-equiv=\"cache-control\" content=\"no-cache, must-revalidate\" />
<!-- end no cache headers -->\n
$headtags
<link rel=\"stylesheet\" href=\"{$Globals['maindir']}/stylesheets/{$Globals['theme']}.css\" type=\"text/css\" />


<script type=\"text/javascript\" language=\"javascript\">
function switchAll(s) {
    for (var j = 1; j <= 50; j++) {
        box = eval(\"document.modform.approve\" + j);

        if (box) {
            if (s == 'h') {
                if (box[2]) {
                    box[0].checked = false;
                    box[1].checked = false;
                    box[2].checked = true;
                }
                else {
                    box[0].checked = false;
                    box[1].checked = true;
                }
            }

            if (s == 'd') {
                if (box[2]) {
                    box[0].checked = true;
                    box[1].checked = false;
                    box[2].checked = false;
                }
                else {
                    box[0].checked = true;
                    box[1].checked = false;
                }
            }

            if (s == 'a') {
                if (box[2]) {
                    box[0].checked = false;
                    box[1].checked = true;
                    box[2].checked = false;
                }
                else {
                    box[0].checked = false;
                    box[1].checked = true;
                }
            }
        }
   }
}
//-->
</script>

</head>
<body>";

    //
    // Now lets put them into the Who's Online table
    //

    update_whoonline( "Admin pages" );

    return;
}

function adminfooter()
{
    global $Globals, $User, $ppstarttime;

    // Set this to 1 if you want to see debug information (only prints for admins)
    // Set this to 2 is you want to print out queries and timing info
    $showsqldebug = 0;

    $ppendtime = microtime();
    $starttime = explode(" ", $ppstarttime);
    $endtime = explode(" ", $ppendtime);

    $totaltime = $endtime[0] - $starttime[0] + $endtime[1] - $starttime[1];
    $totaltime = number_format( $totaltime, 5 );

    if ( $showsqldebug > 0 )
    {
        print "<br /><div align=\"center\"><font size=\"1\" color=\"#000000\">Page generated in $totaltime seconds with {$Globals['number_queries']} queries<br />";

        if ( $User['adminedit'] == 1 && $showsqldebug == 2 )
        {
            for ( $x = 1; $x < count($Globals['queries']); $x++ )
            {
                print "$x: {$Globals['queries'][$x]} ({$Globals['timing'][$x]} sec)<br />";
            }
        }
        print "</font></div>";
    }

    print "</body></html>";

    return;
}


function subli( $subid )
{
    global $Globals, $link, $output, $start;

    $subs = array();
    $x = $topsub = 0;

    // First we need to cache the categories
    $boards = ppmysql_query("SELECT id, name FROM {$Globals['pp_db_prefix']}subscriptions ORDER BY id ASC", $link);

    while ( $subscriptions = mysql_fetch_row($boards) )
    {
        $maincats[$x]=$subscriptions;     // count the number of subscriptions
        $x++;

        $whichcat = $subscriptions[0];
        $subcats[$whichcat] = $subscriptions;
    }

    // process the array, not the database
    $catcnt=0; $numsubcats = count($subcats);

    for ( $y=0; $y < $x; $y++ )
    {
        list( $mainid, $mainname ) = $maincats[$y];


        $processcats = explode( ",", $mainid );
        $catcnt++;

        $subcnt = $catcnt;

        $delete = "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=admsubscribe&amp;ppaction=delsub&subid=$mainid\">{$Globals['pp_lang']['delete']}</a>";
        $edit = "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=admsubscribe&amp;ppaction=editsub&subid=$mainid\">{$Globals['pp_lang']['edit']}</a>";

        if (!empty($mainid) )
        {

        $mainname = "<b>$mainname</b> [$edit] [$delete]";
        $output .= "<br />$mainname";

        }
        else
        {
            $output .= "<br />";
        }


    }
    return;
}

function catli( $subcatid )
{
    global $Globals, $CatPerms, $link, $output, $start;

    $maincats = $subcats[] = array();
    $x = $topcat = 0;

    // First we need to cache the categories
    $boards = ppmysql_query("SELECT id, catname, description, catorder, parent, thumbs, children FROM {$Globals['pp_db_prefix']}categories WHERE cattype='c' ORDER BY catorder ASC", $link);

    while ( $categories = mysql_fetch_row($boards) )
    {
        if ( $categories[4] == 0 || $subcatid == $categories[0] )
        {
            if ( $subcatid == 0 || $subcatid == $categories[0] )
            {
                $maincats[$x]=$categories;     // count the number of main categories
                $x++;
            }
        }

        $whichcat = $categories[0];
        $subcats[$whichcat] = $categories;
    }

    // process the array, not the database
    $catcnt=0; $numsubcats = count($subcats);

    for ( $y=0; $y < $x; $y++ )
    {
        list( $mainid, $maincatname, $maincatdesc, $mainorder, $mainparent, $mainthumbs, $mainchildren ) = $maincats[$y];

        if ( $mainchildren != "" )
        {
            if ( $subcatid != 0 )
            {
                $mainchildren = "$mainchildren";
            }
            else
            {
                $mainchildren = "$mainid,$mainchildren";
            }
        }
        else
        {
            $mainchildren = "$mainid";
        }

        $processcats = explode( ",", $mainchildren );
        $catcnt++;

        unset($oldcnt);

        $oldcnt = array();
        $holdindent = 0;
        $subcnt = $catcnt;

        if ( $subcatid != 0 )
        {
            if ( $subid != "500" )
            {
                $delete = "<a href=\"adm-cats.php?ppaction=delcat&amp;catid=$mainid\">{$Globals['pp_lang']['delete']}</a>";
                $addcat = "<a href=\"adm-cats.php?ppaction=addcat&amp;catid=$mainid\">{$Globals['pp_lang']['addsubcat']}</a>";
            }
            else
            {
                $delete = "{$Globals['pp_lang']['delete']}";
                $addcat = "{$Globals['pp_lang']['addsubcat']}";
            }

            $edit = "<a href=\"adm-cats.php?ppaction=editcat&amp;catid=$mainid\">{$Globals['pp_lang']['edit']}</a>";
            $empty = "<a href=\"adm-cats.php?ppaction=emptycat&amp;catid=$mainid\">{$Globals['pp_lang']['empty']}</a>";

            $sort = null;
            if ( $mainchildren )
            {
                $sort = "<a href=\"adm-cats.php?ppaction=cats&amp;catid=$mainid&amp;sort=1\">[Sort Subcats]</a>";
            }

            $mods = "<a href=\"adm-cats.php?ppaction=mods&amp;catid=$mainid\">Moderators</a>";

            $maintree = null;

            if ( $mainparent != 0 )
            {
                $parcheck = $mainparent;

                do
                {
                    $maintree = "&laquo; <a href=\"adm-cats.php?ppaction=cats&amp;catid=$parcheck\">{$CatPerms['catname'][$parcheck]}</a> $maintree";

                    $parcheck = $CatPerms['parent'][$parcheck];
                } while ($parcheck != 0);

                $maintree .= " &laquo;</a> $maincatname";
                $maintree = "<a href=\"adm-cats.php?ppaction=cats\">Top</a> $maintree <br /><br />";

                $maincatname = "<a href=\"adm-cats.php?ppaction=cats&amp;catid=$mainparent\">&laquo;</a> <b>$maincatname</b> [$delete] [$addcat] [$edit] [$empty] $sort [$mods]";
            }
            else
            {
                $maincatname = "<a href=\"adm-cats.php?ppaction=cats\">&laquo;</a> <b>$maincatname</b> [$delete] [$addcat] [$edit] [$empty] $sort [$mods]";
            }

            $output .= "<br />$maintree$maincatname<br /><br />";
        }
        else
        {
            $output .= "<br />";
        }

        while ( list($num, $eachcat) = each($processcats) )
        {
            list( $subid, $subcatname, $subcatdesc, $suborder, $parent, $thumbs, $children ) = $subcats[$eachcat];

            // First thing is to check the indent level
            $chkparent = $parent;
            $catdepth = 0;

            do
            {
                if ( $chkparent == 0 || $chkparent == $subcatid )
                {
                    break;
                }

                $chkparent = $subcats[$chkparent][4];

                $catdepth++;
            } while ( $chkparent != 0 );

            if ( $catdepth > 0 && $numsubcats > 30 )
            {
                continue;
            }

            $indent = ($catdepth*15);

            if ( empty($oldcnt[$indent]) )
            {
                $oldcnt[$indent] = 1;
            }
            elseif ( $indent > $holdindent )
            {
                $oldcnt[$indent] = 1;
            }
            elseif ( $indent < $holdindent )
            {
                $oldcnt[$holdindent] = 1;
            }

            if ( $indent == 0 )
            {
                $topcat++;
                $subcnt = $topcat;
            }
            else
            {
                $subcnt = $oldcnt[$indent];
                $oldcnt[$indent]++;
            }

            if ($subid != "500")
            {
                $delete = "<a href=\"adm-cats.php?ppaction=delcat&amp;catid=$subid\">{$Globals['pp_lang']['delete']}</a>";
                $addcat = "<a href=\"adm-cats.php?ppaction=addcat&amp;catid=$subid\">{$Globals['pp_lang']['addsubcat']}</a>";
            }
            else
            {
                $delete = "{$Globals['pp_lang']['delete']}";
                $addcat = "{$Globals['pp_lang']['addsubcat']}";
            }

            $edit = "<a href=\"adm-cats.php?ppaction=editcat&amp;catid=$subid\">{$Globals['pp_lang']['edit']}</a>";
            $empty = "<a href=\"adm-cats.php?ppaction=emptycat&amp;catid=$subid\">{$Globals['pp_lang']['empty']}</a>";

            $sort = null;
            if ( $children )
            {
                $sort = "<a href=\"adm-cats.php?ppaction=cats&amp;catid=$subid&amp;sort=1\">[Sort Subcats]</a>";
            }

            $mods = "<a href=\"adm-cats.php?ppaction=mods&amp;catid=$subid\">Moderators</a>";

            //$subcatname = htmlentities($subcatname);
            //$subcatdesc = htmlentities($subcatdesc);

            if ( $children )
            {
                $subcatname = "<a href=\"adm-cats.php?ppaction=cats&amp;catid=$subid\">$subcatname</a>";
            }

            $output .= "<img height=\"1\" width=\"$indent\" src=\"{$Globals['idir']}/spacer.gif\">$subcatname ({$Globals['pp_lang']['order']}:
                <input type=\"text\" size=\"5\" value=\"$suborder\" name=\"catorder-$subid\" /> [$delete] [$addcat] [$edit] [$empty] $sort [$mods]<br />";

            $holdindent = $indent;
        }
    }

    return;
}

function upgradeparents( $parent = 0 )
{
    global $Globals, $CatPerms, $link;

    // update children for tree
    //
    if ( $parent == 0 )
    {
        // this is a full recalc - done in scan database
        $query = "SELECT id,catname,description,catorder,parent,thumbs,children,cattype FROM {$Globals['pp_db_prefix']}categories ORDER BY catorder ASC";
    }
    else
    {
        // this is for a cat, so this one and any parents
        $forcats = "$parent";
        $checkpar = $parent;

        while ( $CatPerms['parent'][$checkpar] != 0 )
        {
            $forcats .= ",{$CatPerms['parent'][$checkpar]}";
            $checkpar = $CatPerms['parent'][$checkpar];

            if ( $checkpar == 0 )
            {
                $forcats .= ",$checkpar";
            }
        }

        $query = "SELECT id,catname,description,catorder,parent,thumbs,children,cattype FROM {$Globals['pp_db_prefix']}categories WHERE id IN ($forcats) ORDER BY id DESC";
    }
    $boards = ppmysql_query($query, $link);

    while ( list( $id, $catname, $catdesc, $order, $catparent, $catthumbs, $children, $cattype ) = mysql_fetch_row($boards) )
    {
        catlist($id);
    }

    return;
}


function sortsubcat( $subcatid ) {
    global $Globals, $link, $output;

    $maincat = 0;
    $subcats[] = $laston =  array();

    // First we need to cache the categories
    $boards = ppmysql_query("SELECT id, catname, description, catorder, parent, thumbs, children FROM {$Globals['pp_db_prefix']}categories WHERE cattype='c' AND (parent=$subcatid OR id=$subcatid) ORDER BY catname ASC", $link);

    while ( $categories = mysql_fetch_row($boards) )
    {
        if ( $subcatid == $categories[0] )
        {
            $maincat = $categories;
        }
        else
        {
            $subcats[] = $categories;
        }
    }

    list( $mainid, $maincatname, $maincatdesc, $mainorder, $mainparent, $mainthumbs, $mainchildren ) = $maincat;
    $output .= "<br />Order subcats for: <b>$maincatname</b><br /><br /><table width=\"100%\">";

    for ( $x = 1; $x < count($subcats); $x++ )
    {
        list( $subid, $subcatname, $subcatdesc, $suborder, $parent, $thumbs, $children ) = $subcats[$x];

        $subcatname = str_replace( "\"", "&quot", $subcatname);
        $subcatdesc = str_replace( "\"", "&quot", $subcatdesc);

        $output .= "<tr><td width=\"30%\" align=\"left\"><span class=\"medium\"><b>$subcatname</b></td><td align=\"left\">{$Globals['pp_lang']['order']}:
            <input type=\"text\" size=\"5\" value=\"$x\" name=\"catorder-$subid\" /> (Current position: $suborder)";
        $output .= "</td></tr>";
    }

    $output .= "</table>";

    return;
}

function childcheck( $parid, $nowpar )
{
    global $Globals, $link;

    $rows = ppmysql_query("SELECT id,parent FROM {$Globals['pp_db_prefix']}categories WHERE id=$parid AND cattype='c'", $link);

    while ( list( $tid, $tparent ) = mysql_fetch_row($rows) )
    {
        if ( $tparent == $nowpar )
        {
            diewell("{$Globals['pp_lang']['parenter1']}");
        }

        if ( $tid == $nowpar )
        {
            diewell("{$Globals['pp_lang']['parenter2']}");
        }

        childcheck( $tparent, $nowpar );
    }

    return;
}


function admpages( $rowcnt )
{
    global $Globals, $perpage, $pages, $page, $posternav, $cat, $p, $si, $sort, $sortparam, $ppuser;

    $pageper = ( $pageper == 0 ? $perpage : $pageper );

    // begin pages/nav system //
    $pages = ($rowcnt/$pageper);

    if ((intval($pages)) < $pages)
    {
        $pages = intval($pages)+1;
    }
    else
    {
        $pages = intval($pages);
    }

    if ($page != "")
    {
        $startnumb = ($page*$pageper)-$pageper+1;
    }
    else
    {
        $page = 1;
        $startnumb = 1;
    }

    if ( $pages > 1 )
    {
        $posternav = "<span class=\"{$Style['small']}\">";
        $thestart = 0;

        if ($page < 11)
        {
            $thestart = 1;
        }
        elseif ($page > 10)
        {
            $thestart = $page-5;
        }

        $theend = $thestart+9;

        for ( $p = $thestart; $p <= $pages; $p++ )
        {
            if ( $p != $thestart )
            {
                $posternav .= " &middot; ";
            }
            else
            {
                $posternav .= "<b>{$Globals['pp_lang']['page']}</b> ";
            }

            if ( $p == $thestart && $p != 1 )
            {
                $posternav .= "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=approve&amp;cat=$cat&amp;si=$si&amp;page=1&amp;perpage=$pageper&amp;sort=$sortparam\">1</a> ... ";
            }

            if ( $page != $p )
            {
                $thispage = "$p";
                $posternav .= "<a href=\"{$Globals['maindir']}/adm-misc.php?admact=approve&amp;cat=$cat&amp;si=$si&amp;page=$p&amp;perpage=$pageper&amp;ppuser=$ppuser&amp;sort=$sortparam\">$thispage</a>";
            }

            if ( $p > $theend )
            {
                $posternav .= " ... <a href=\"{$Globals['maindir']}/adm-misc.php?admact=approve&amp;cat=$cat&amp;si=$si&amp;page=$pages&amp;perpage=$pageper&amp;ppuser=$ppuser&amp;sort=$sortparam\">$pages</a>";
                break;
            }

            if ( $page == $p )
            {
                $posternav .= "<b>$p</b>";
            }
        }

        $posternav .= "</span>";
    }

    return $pages;
}

function miscpages( $rowcnt, $action )
{
    global $Globals, $perpage, $pages, $page, $posternav, $cat, $p, $si, $sort, $sortparam, $ppuser;

    $pageper = ( $pageper == 0 ? $perpage : $pageper );

    // begin pages/nav system //
    $pages = ($rowcnt/$pageper);

    if ((intval($pages)) < $pages)
    {
        $pages = intval($pages)+1;
    }
    else
    {
        $pages = intval($pages);
    }

    if ( $page != "" )
    {
        $startnumb = ($page*$pageper)-$pageper+1;
    }
    else
    {
        $page = 1;
        $startnumb = 1;
    }

    if ($pages > 1)
    {
        $posternav = "<span class=\"{$Style['small']}\">";
        $thestart = 0;

        if ($page < 11)
        {
            $thestart = 1;
        }
        elseif ($page > 10)
        {
            $thestart = $page-5;
        }

        $theend = $thestart + 9;

        for ( $p = $thestart; $p <= $pages; $p++ )
        {
            if ( $p != $thestart )
            {
                $posternav .= " &middot; ";
            }
            else
            {
                $posternav .= "<b>{$Globals['pp_lang']['page']}</b> ";
            }

            if ( $p == $thestart && $p != 1 )
            {
                $posternav .= "<a href=\"{$Globals['maindir']}/adm-misc.php?cat=$cat&amp;si=$si&amp;page=1&amp;perpage=$pageper&amp;sort=$sortparam&admact=$action\">1</a> ... ";
            }

            if ( $page != $p )
            {
                $thispage = "$p";
                $posternav .= "<a href=\"{$Globals['maindir']}/adm-misc.php?cat=$cat&amp;si=$si&amp;page=$p&amp;perpage=$pageper&amp;ppuser=$ppuser&amp;sort=$sortparam&admact=$action\">$thispage</a>";
            }

            if ( $p > $theend )
            {
                $posternav .= " ... <a href=\"{$Globals['maindir']}/adm-misc.php?cat=$cat&amp;si=$si&amp;page=$pages&amp;perpage=$pageper&amp;ppuser=$ppuser&amp;sort=$sortparam&admact=$action\">$pages</a>";
                break;
            }

            if ( $page == $p )
            {
                $posternav .= "<b>$p</b>";
            }
        }

        $posternav .= "</span>";
    }

    return $pages;
}

function dirsize($dir)
{
    // calculate the size of files in $dir, (it descends recursively into other dirs)
    $dh = opendir($dir);
    $size = 0;

    while (($file = readdir($dh)) !== false)
    {
       if ($file != "." and $file != "..")
       {
            $path = $dir."/".$file;

            if (is_dir($path))
            {
                $size += dirsize($path);
            }
            elseif (is_file($path))
            {
                $size += filesize($path);
            }
        }
    }

    closedir($dh);

    return( $size );
}

function convert_html($string)
{
    $string = str_replace(array('&lt;', '&gt;', '&quot;', '&amp;'), array('<', '>', '"', '&'), $string);

    return($string);
}

if (!isset($do))
{
    $do = null;
}

authenticate();

if ( $gologin == 1 )
{
    login( "{$Globals['maindir']}/adm-index.php" );
    exit;
}

?>