<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost PHP, a software application by        //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
// Developer: Michael Pierce (http://www.mdpnet.com)                      //
// Contributing Developer: Charles Scannell (omegatron@comcast.net)       //
//            PhotoPost Copyright 2009, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// Just to be safe, dont want it to timeout
ini_set("max_execution_time", 0);

require "adm-inc.php";

if ( $User['adminedit'] != 1 )
{
    diewell( "You are not a valid administrator!" );
}

typecast($_REQUEST, array('sort' => INT, 'catid' => INT, 'ppaction' => STRING, 'customid' => INT, 'uid' => INT, 'delcomments' => STRING,
                          'do' => STRING, 'newextra' => STRING, 'extratype' => STRING, 'extraoptions' => STRING, 'modid' => INT));
typecast($_POST, array('catname' => STRING, 'catdesc' => STRING, 'myheader' => STRING,
                       'myfooter' => STRING, 'mytags' => STRING, 'mypassword' => STRING, 'mywater' => STRING,
                       'ratingtype' => INT, 'thumbtype' => INT, 'ismember' => INT, 'maximages' => INT, 'nextpage' => STRING,
                       'isdelete' => STRING, 'dochildren' => INT, 'backcat' => INT, 'newmod' => STRING));

if ($ppaction == "delcat")
{
    // Delete a category

    if ($_POST['do'] == "process")
    {
        // Process delete cat
        if ($catid != 500 && $catid != 0 && $catid != "")
        {
            delete_cat($catid, "c");
        }
        else
        {
            diewell("Invalid category ID.");
        }

        adminlog( "Deleted a category: $catid" );

        // Let's update the category cache
        update_catcache();
        update_catprops();

        forward( "adm-cats.php?ppaction=cats&catid={$CatPerms['parent'][$catid]}", "Processing complete!" );
    }

    // Generate an 'are you sure' you want to delete? form...

    $catname = $CatPerms['catname'][$catid];

    adminheader( 0, "PhotoPost Categories" );

    $output="<div align=\"center\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Delete a Category</span></td>
        </tr><tr>
        <td class=\"{$Style['tddetails']}\">
        <div align=\"center\"><br />
        You're about to delete the category called \"$catname\", and <b>ALL PHOTOS AND COMMENTS WITHIN THE CATEGORY</B>.<br /><br />
        Are you sure you want to do that?
        <form action=\"{$Globals['maindir']}/adm-cats.php\" method=\"post\">
        <input type=\"hidden\" name=\"catid\" value=\"$catid\">
        <input type=\"hidden\" name=\"do\" value=\"process\">
        <input type=\"hidden\" name=\"ppaction\" value=\"delcat\">
        <input type=\"submit\"
        value=\"I'm sure, delete the category.\"></form></span><br /><br /></td></tr></table></td></tr></table>";

    print "$output<br /><br />";

    adminfooter();
}

if ($ppaction == "addcat")
{
    // Add a category
    $parent = $catid;

    if ($_POST['do'] == "process")
    {
        // Process a user's category submission
        if ( !isset($nextpage) )
        {
            $nextpage = "edit";
        }

        if ($parent == "")
        {
            $parent = 0;
        }

        $catq = ppmysql_query("SELECT catorder FROM {$Globals['pp_db_prefix']}categories WHERE parent=$parent AND cattype='c' ORDER BY catorder DESC LIMIT 1", $link);
        list( $maxcatorder ) = mysql_fetch_row($catq);

        $maxcatorder++;

        $myheader = null;
        $myfooter = null;
        $mytags = null;
        list( $myheader, $myfooter, $mytags, $mypassword, $noview, $noupload, $nopost, $noanno, $mywater, $novote, $defsort, $defframe, $defrating ) = walk_tree_vars($parent);

        $ncatname = convert_html($catname);

        $setug = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}categories (id,catname,description,catorder,thumbs,parent,header,footer,headtags,password,ugnoview,ugnoupload,ugnopost,ugnoanno,ugnovote,watermark,sortorder,frames,maximages,ratingtype,ismember)
            VALUES(NULL,'$ncatname','$catdesc','$maxcatorder','yes',$parent,'$myheader','$myfooter','$mytags','$mypassword', '$noview', '$noupload', '$nopost', '$noanno', '$novote', '$mywater', '$defsort', '$defframe', '$maximages', '$ratingtype', '$ismember')", $link);
        $thecatid = mysql_insert_id( $link );

        if ( $thecatid == 0 )
        {
            diewell( "Error adding new category to the database. Returned id was 0." );
        }

        updateparents( $parent );

        mkppdir( "{$Globals['datafull']}$thecatid" );
        if ( $Globals['datafull'] != $Globals['origfull'] )
        {
            mkppdir( "{$Globals['origfull']}$thecatid" );
        }

        adminlog( "Added a category: $catname" );

        // Let's update the category cache
        update_catcache();
        update_catprops();

        if ( $nextpage == "cats" )
        {
            forward( "adm-cats.php?ppaction=cats&catid=$parent", "Processing complete!" );
        }
        elseif ( $nextpage == "add" )
        {
            forward( "adm-cats.php?ppaction=addcat&catid=$parent", "Processing complete!" );
        }
        else
        {
            forward( "adm-cats.php?ppaction=editcat&catid=$thecatid", "Processing complete!" );
        }
    }

    // Print out the Add a category HTML form

    $partext = null;
    if ( $parent > 0 )
    {
        $parname = $CatPerms['catname'][$parent];
        $partext = "<span class=\"{$Style['large']}\">&nbsp;Create a subcategory for: \"<b>$parname</b>\"<br />";
    }

    adminheader( 0, "PhotoPost Categories" );

    $output = "<div align=\"center\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\" width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Add a Category</span></td>
        </tr><tr>
        <td class=\"{$Style['tdbackground']}\"><div align=\"center\"><br />

        <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" class=\"{$Style['tableborders']}\">
        <form method=\"post\" action=\"{$Globals['maindir']}/adm-cats.php\">
        <tr><td class=\"{$Style['tddetails']}\">$partext
        <table border=\"0\" cellpadding=\"5\" cellspacing=\"1\">
        <tr><td class=\"{$Style['menubar']}\">Category Name</span></th>
        <td class=\"{$Style['menubar']}\">Category Description</span></th></tr><tr>
        <td>
        <input type=\"text\" size=\"50\" value=\"\" name=\"catname\" class=\"bginput\"></td>
        <td><input type=\"text\" size=\"50\" value=\"\" name=\"catdesc\" class=\"bginput\"></td>
        </tr>
        </table>
        <table border=\"0\" cellpadding=\"3\" cellspacing=\"1\">
        <tr><td width=\"40\" align=\"center\" class=\"{$Style['tddetails']}\"><input type=\"radio\" name=\"nextpage\" value=\"edit\" checked=\"checked\"></td>
        <td align=\"left\" class=\"{$Style['tddetails']}\">Add and edit new category properties</td>
        <tr><td width=\"40\" align=\"center\" class=\"{$Style['tddetails']}\"><input type=\"radio\" name=\"nextpage\" value=\"cats\"></td>
        <td align=\"left\" class=\"{$Style['tddetails']}\">Skip edit page and return to categories page</td>
        <tr><td width=\"40\" align=\"center\" class=\"{$Style['tddetails']}\"><input type=\"radio\" name=\"nextpage\" value=\"add\"></td>
        <td align=\"left\" class=\"{$Style['tddetails']}\">Skip edit page and add another subcategory</td>
        </table></td></tr></table><br />
        <input type=\"hidden\" name=\"catid\" value=\"$parent\">
        <input type=\"hidden\" name=\"ppaction\" value=\"addcat\">
        <input type=\"hidden\" name=\"do\" value=\"process\">
        <input type=\"submit\" value=\"Add Category\"></form></td></tr></table></td></tr></table>";

    print "$output<br /><br />";

    adminfooter();
}


// Edit categories

if ($ppaction == "editcat")
{
    adminheader( 0, "PhotoPost Categories" );

    $output = "<div align=\"center\">

        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
        align=\"center\"><tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Category Editor</b></span></td>
        </tr>
        <tr>
        <td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
        <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"{$Style['tableborders']}\">
        <tr><td>
        <form method=\"post\" action=\"{$Globals['maindir']}/adm-cats.php\"><tr><td>
        <table border=\"0\" cellpadding=\"5\" cellspacing=\"1\">
        <tr><td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Display Order</span></th>
        <td class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\">Category Name</span></th>
        <td class=\"{$Style['menubar']}\" width=\"33%\"><span class=\"{$Style['medium']}\">Category Description</span>
        </th></tr>";

    $viewoptions = null;
    $upoptions = null;
    $postoptions = null;
    $annooptions = null;
    $thumbpar = null;

    $boards = ppmysql_query("SELECT c.id,c.catname,c.description,c.catorder,c.parent,c.thumbs,c.header,c.footer,c.password,c.theme,c.catdepth,c.headtags,c.
                     private,c.ugnoview,c.ugnoupload,c.ugnopost,c.ugnovote,c.ugnoanno,c.watermark,c.sortorder,c.thumbtype,c.extra1,c.extra2,c.extra3,c.extra4,
                     c.extra5,c.extra6,c.thumbnail,c.canzip,c.maximages,c.frames,c.intro,c.introtitle,c.introcopy,c.numextra,c.ratingtype,c.ismember,p.bigimage,p.width,p.height,p.userid,p.cat
              FROM {$Globals['pp_db_prefix']}categories c
              LEFT JOIN {$Globals['pp_db_prefix']}photos p ON p.id=c.thumbnail
              WHERE c.id='$catid' LIMIT 1", $link);

    $posts = mysql_num_rows($boards);

    if ( $posts == 0 )
    {
        diewell( "Unable to find category: $catid" );
    }

    list($id,$catname,$catdesc,$catorder,$parent,$thumbs,$cheader,$cfooter,$cpassword,$deftheme,$catdepth,$cheadtags,
         $cprivate,$ugnoview,$ugnoupload,$ugnopost,$ugnovote,$ugnoanno,$watermark,$sortorder,$thumbtype,$extra1,$extra2,$extra3,$extra4,$extra5,
         $extra6,$thumbnail,$canzip,$maximages,$defframes,$intro,$introtitle,$introcopy,$numextra,$ratingtype,$ismember,$bigimage,$imgwidth,$imgheight,$imguser,$imgcat) = mysql_fetch_row($boards);

    if ( !empty($bigimage) )
    {
        $thumbrc = get_imagethumb( $bigimage, $imgcat, $imguser, 1 );
        $thumbrc = "<a href=\"{$Globals['maindir']}/showphoto.php?photo=$thumbnail\" target=\"_blank\">$thumbrc</a>";
    }
    else
    {
        $thumbrc = "None";
    }

    if ( $catid == 500 )
    {
        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sortmemb", $link);
    }
    else
    {
        $resultc = ppmysql_query("SELECT * FROM {$Globals['pp_db_prefix']}sort", $link);
    }

    $sortdefault = null;
    $soptions = null;

    while ( list($sortid, $sortname, $sortc) = mysql_fetch_row($resultc) )
    {
        if ($sortid == $sortorder)
        {
            $sortdefault = "<option selected=\"selected\" value=\"$sortid\">$sortname</option>";
            $sortcode = "$sortc";
        }
        else
        {
            $soptions .= "<option value =\"$sortid\">$sortname</option>";
        }
    }

    $sortoptions = "<select name=\"sortorder-$id\" style=\"font-size: 9pt; background: FFFFFF;\">$sortdefault$soptions</select>";
    // end sort box //

    if ($canzip == "yes")
    {
        $zipoptions = "<select name=\"canzip-$id\"><option selected>yes</option><option>no</option></select>";
    }
    else
    {
        $zipoptions = "<select name=\"canzip-$id\"><option selected>no</option><option>yes</option></select>";
    }

    if ( $ratingtype == 0 )
    {
        $ratetype = "<select name=\"ratingtype-$id\"><option value=\"0\" selected>Ratings</option><option value=\"1\">Contest</option></select>";
    }
    else
    {
        $ratetype = "<select name=\"ratingtype-$id\"><option value=\"0\">Ratings</option><option value=\"1\" selected>Contest</option></select>";
    }

    if ( $thumbtype == 1 )
    {
       $thumbtype = "<select name=\"thumbtype-$id\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\" selected=\"selected\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    elseif( $thumbtype == 2 )
    {
       $thumbtype = "<select name=\"thumbtype-$id\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\" selected=\"selected\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    elseif( $thumbtype == 3 )
    {
       $thumbtype = "<select name=\"thumbtype-$id\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\" selected=\"selected\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    elseif( $thumbtype == 4 )
    {
       $thumbtype = "<select name=\"thumbtype-$id\"><option value=\"0\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\" selected=\"selected\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }
    else
    {
       $thumbtype = "<select name=\"thumbtype-$id\"><option value=\"0\" selected=\"selected\">{$Globals['pp_lang']['gallery']}</option><option value=\"1\">{$Globals['pp_lang']['thumbnail']}</option><option value=\"2\">{$Globals['pp_lang']['withtitles']}</option><option value=\"3\">{$Globals['pp_lang']['groupby']}</option><option value=\"4\">{$Globals['pp_lang']['puzzle']}</option></select>";
    }

    if ( $ismember == 0 )
    {
        $memlayout = "<select name=\"ismember-$id\"><option value=\"0\" selected>Photo Gallery</option><option value=\"1\">Member Gallery</option></select>";
    }
    else
    {
        $memlayout = "<select name=\"ismember-$id\"><option value=\"0\">Photo Gallery</option><option value=\"1\" selected>Member Gallery</option></select>";
    }

    // Do the HTML for the usergroup access
    $ugviewblock = explode( ",", $ugnoview );
    $ugupblock = explode( ",", $ugnoupload );
    $ugpostblock = explode( ",", $ugnopost );
    $ugvoteblock = explode( ",", $ugnovote );
    $ugannoblock = explode( ",", $ugnoanno );

    $resultug = ppmysql_query("SELECT groupid,groupname FROM {$Globals['pp_db_prefix']}usergroups", $link);

    while ( list($groupid,$groupname) = mysql_fetch_row($resultug) )
    {
        $view_checked="CHECKED";
        $up_checked="CHECKED";
        $post_checked="CHECKED";
        $vote_checked="CHECKED";
        $anno_checked="CHECKED";

        reset( $ugviewblock );
        while ( list($ignore,$vgid) = each($ugviewblock) )
        {
            if ($groupid == $vgid)
            {
                $view_checked = null;
            }
        }

        reset( $ugupblock );
        while ( list($ignore,$ugid) = each($ugupblock) )
        {
            if ($groupid == $ugid)
            {
                $up_checked = null;
            }
        }

        reset( $ugpostblock );
        while ( list($ignore,$pgid) = each($ugpostblock) )
        {
            if ($groupid == $pgid)
            {
                $post_checked = null;
            }
        }

        reset( $ugvoteblock );
        while ( list($ignore,$pgid) = each($ugvoteblock) )
        {
            if ($groupid == $pgid)
            {
                $vote_checked = null;
            }
        }

        reset( $ugannoblock );
        while ( list($ignore,$agid) = each($ugannoblock) )
        {
            if ($groupid == $agid)
            {
                $anno_checked = null;
            }
        }

        $viewoptions .= "<input type=\"checkbox\" name=\"view-$groupid\" value=\"1\" $view_checked> $groupname<br />";
        $upoptions .= "<input type=\"checkbox\" name=\"up-$groupid\" value=\"1\" $up_checked> $groupname<br />";
        $postoptions .= "<input type=\"checkbox\" name=\"post-$groupid\" value=\"1\" $post_checked> $groupname<br />";
        $voteoptions .= "<input type=\"checkbox\" name=\"vote-$groupid\" value=\"1\" $vote_checked> $groupname<br />";
        $annooptions .= "<input type=\"checkbox\" name=\"anno-$groupid\" value=\"1\" $anno_checked> $groupname<br />";
    }
    ppmysql_free_result( $resultug );
    // end usergroup access html

    if ($intro == "yes")
    {
        $introopt = "<option selected>yes</option><option>no</option>";
    }
    else
    {
        $introopt = "<option selected>no</option><option>yes</option>";
    }

    if ($id != 500)
    {
        if ($thumbs == "yes")
        {
            $thumbopt = "<option selected>yes</option><option>no</option>";
        }
        else
        {
            $thumbopt = "<option selected>no</option><option>yes</option>";
        }

        if ($cprivate == "yes")
        {
            $privateopt = "<option selected>yes</option><option>no</option>";
        }
        else
        {
            $privateopt = "<option selected>no</option><option>yes</option>";
        }

        $parname = $CatPerms['catname'][$parent];

        if ( $parent != 0 )
        {
            $catoptions = "<option selected value=\"$parent\">$parname</option>";
            catmoveopt(0,1,0,0,false);
            $catoptions .= "<option value=\"0\">None</option>";
        }
        else
        {
            $catoptions = "<option selected value=\"0\">None</option>";
            catmoveopt(0,1,0,0,false);
        }

        $thumbpar = "<tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\"><div align=\"center\">Contains Thumbnails?
            <select name=\"thumbs-$id\">$thumbopt</select></div></span></td>
            <td class=\"{$Style['tddetails']}\" align=\"left\"><div align=\"center\">Parent:
            <select name=\"parent-$id\">$defaultopt$catoptions</select></td></tr>";
    }
    else
    {
        $delete = null;
        $addcat = null;
    }

    //$catname = htmlentities( $catname );
    //$catdesc = htmlentities( $catdesc );
    $introtitle = htmlentities( $introtitle );
    $introcopy = htmlentities( $introcopy );
    $extra1 = htmlentities( $extra1 );
    $extra2 = htmlentities( $extra2 );
    $extra3 = htmlentities( $extra3 );
    $extra4 = htmlentities( $extra4 );
    $extra5 = htmlentities( $extra5 );
    $extra6 = htmlentities( $extra6 );

    $output .= "<tr><td class=\"{$Style['tddetails']}\" align=\"left\"><div align=\"center\">
        <input type=\"text\" size=\"{$Globals['fontlarge']}\" value=\"$catorder\" name=\"catorder-$id\" class=\"bginput\">
        </td><td class=\"{$Style['tddetails']}\" align=\"left\">
        <input type=\"text\" size=\"50\" value=\"$catname\" name=\"catname-$id\" class=\"bginput\">
        </td><td class=\"{$Style['tddetails']}\">
        <input type=\"text\" size=\"50\" value=\"$catdesc\" name=\"description-$id\" class=\"bginput\">
        </td></tr>";

    $output .= "$thumbpar
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Header Include File Path*:
        <br />
        <span class=\"{$Style['small']}\">(leave blank to use admin setting)</span></td>
        <td class=\"{$Style['tddetails']}\">
        <input type=\"text\" name=\"header-$id\" value=\"$cheader\" size=\"50\" class=\"bginput\"></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Headtags Include File Path*:<br />
        <span class=\"{$Style['small']}\">(leave blank to use admin setting)</span></td>
        <td class=\"{$Style['tddetails']}\">
        <input type=\"text\" name=\"headtags-$id\" value=\"$cheadtags\" size=\"50\" class=\"bginput\"></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Footer Include File Path*:<br />
        <span class=\"{$Style['small']}\">(leave blank to use admin setting)</span></td>
        <td class=\"{$Style['tddetails']}\">
        <input type=\"text\" name=\"footer-$id\" value=\"$cfooter\" size=\"50\" class=\"bginput\"></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Password for category:
        <br />
        <span class=\"{$Style['small']}\">(leave blank if category does not require a password to access)</span></td>
        <td class=\"{$Style['tddetails']}\">
        <input type=\"text\" name=\"password-$id\" value=\"$cpassword\" size=\"50\" class=\"bginput\"></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Theme for category*:
        <br />
        <span class=\"{$Style['small']}\">(leave blank to use the default theme)</span></td>
        <td class=\"{$Style['tddetails']}\">";

    $dir_name = "$PP_PATH/stylesheets";
    $dir = opendir($dir_name);

    $output .= "<select name=\"theme-$id\">
        <option selected=\"selected\">$deftheme</option><option value=\"\">Use Admin Default</option>";

    while ($file_name = readdir($dir))
    {
        if (($file_name != ".") && ($file_name != "..") && ($file_name != "template.css") && (stristr($file_name,".css")))
        {
            $file_name = str_replace(".css", "", $file_name);

            if ( $file_name != $setting )
            {
                $output .= "<option value=\"$file_name\">$file_name</option>";
            }
        }
    }

    $output .= "</select>";
    closedir($dir);

    $output .= "</td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Custom frames for category*:
        <br />
        <span class=\"{$Style['small']}\">(leave blank to use the default theme)</span></td>
        <td class=\"{$Style['tddetails']}\">";

    $dir_name = "$PP_PATH/$TMPL_PATH";
    $dir = opendir($dir_name);

    $output .= "<select name=\"frames-$id\">
        <option selected=\"selected\">$defframes</option><option value=\"\">Use Admin Default</option>";

    while ($file_name = readdir($dir))
    {
        if ( stristr($file_name,"thumbnail") )
        {
            $file_name = str_replace(".tmpl", "", $file_name);

            if ( $file_name != $setting )
            {
                $output .= "<option value=\"$file_name\">$file_name</option>";
            }
        }
    }

    $output .= "</select></td></tr>";
    closedir($dir);

    $output .= "<tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Depth of children to display*:
        <br />
        <span class=\"{$Style['small']}\">(leave blank to use forum default)</span></td>
        <td class=\"{$Style['tddetails']}\">
        <input type=\"text\" name=\"catdepth-$id\" value=\"$catdepth\" size=\"10\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Default Sort Order*:</td>
        <td class=\"{$Style['tddetails']}\">$sortoptions</td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Max number of images in category<br />(older files deleted as new ones added; 0 is no limit)</td>
        <td class=\"{$Style['tddetails']}\" align=\"left\">
        <input type=\"text\" name=\"maximages-$id\" value=\"$maximages\" size=\"10\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Path to watermark for this category*:
        <br />
        <span class=\"{$Style['small']}\">(leave blank to use forum default)</span></td>
        <td class=\"{$Style['tddetails']}\">
        <input type=\"text\" name=\"watermark-$id\" value=\"$watermark\" size=\"50\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Allow users to Zip n Download this category?*</td>
        <td class=\"{$Style['tddetails']}\">$zipoptions</td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Category Layout?*<br />
        <span class=\"{$Style['small']}\">PhotoPost standard layout is a Gallery layout which shows all photos
        uploaded to that category. A Member Gallery shows photos grouped by users which then link to a gallery
        page of all that users photos in that category (similiar to the Members Gallery, but category
        specific).</span></td>
        <td class=\"{$Style['tddetails']}\">$memlayout</td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Rating type?*<br />
        <span class=\"{$Style['small']}\">Normally users can rate an image on a scale, the Contest setting
        allows users to 'vote' on image by casting their vote and having those votes added to a total
        number.</span></td>
        <td class=\"{$Style['tddetails']}\">$ratetype</td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Default thumbnail layout?*<br />
        <span class=\"{$Style['small']}\">You can choose from the different thumbnail layouts which will be
        used as a default when the user has not selected their own format.</span></td>
        <td class=\"{$Style['tddetails']}\">$thumbtype</td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Thumbnail for Main Index:</td>
        <td class=\"{$Style['tddetails']}\">$thumbrc</td></tr>

        <tr><td class=\"{$Style['menubar']}\" colspan=\"3\"><b>Additional Fields</b>
        </td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Extra Text Field #1*:</td>
        <td class=\"{$Style['tddetails']}\"><input type=\"text\" name=\"extra1-$id\" value=\"$extra1\" size=\"20\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Extra Text Field #2*:</td>
        <td class=\"{$Style['tddetails']}\"><input type=\"text\" name=\"extra2-$id\" value=\"$extra2\" size=\"20\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Extra Text Field #3*:</td>
        <td class=\"{$Style['tddetails']}\"><input type=\"text\" name=\"extra3-$id\" value=\"$extra3\" size=\"20\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Extra Text Field #4*:</td>
        <td class=\"{$Style['tddetails']}\"><input type=\"text\" name=\"extra4-$id\" value=\"$extra4\" size=\"20\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Extra Text Field #5*:</td>
        <td class=\"{$Style['tddetails']}\"><input type=\"text\" name=\"extra5-$id\" value=\"$extra5\" size=\"20\" class=\"bginput\"></td></tr>

        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Extra Text Field #6*:</td>
        <td class=\"{$Style['tddetails']}\"><input type=\"text\" name=\"extra6-$id\" value=\"$extra6\" size=\"20\" class=\"bginput\"></td></tr>";

    if ( $numextra > 0 )
    {
        $query2 = "SELECT id,fieldname,fieldtype FROM {$Globals['pp_db_prefix']}extrafields WHERE cat=$catid";
        $catextras = ppmysql_query($query2, $link);

        while ( list( $exid, $exname, $extype ) = mysql_fetch_row($catextras) )
        {
            $output .= "<tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Additional field type:</td>
                <td class=\"{$Style['tddetails']}\">";

            $output .= "Name: $exname<br />Type: ";

            if ( $extype == "c" )
            {
                $output .= "Checkbox";
            }
            elseif ( $extype == "d" )
            {
                $output .= "Dropdown";
            }
            elseif ( $extype == "r" )
            {
                $output .= "Radio buttons";
            }
            else
            {
                $output .= "Text";
            }

            $output .= "<br /><span class=\"{$Style['small']}\">[<a href=\"{$Globals['maindir']}/adm-cats.php?ppaction=custom&amp;customid=$exid\">edit</a>]</span><br />";
            $output .= "</td></tr>";
        }
        ppmysql_free_result( $catextras );
    }

    $output .= "<tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Add a new field type:<br />
        <span class=\"{$Style['small']}\"><br />If you would like to add a new additional field, enter the text which
        will be used to present the options, select the type of input you want to use and then enter the default
        text or a list of options. Options are entered using a double-pipe <b>||</b> as a field seperator; to
        enter three options, you would enter: <b>field1||field2||field3</b> as your Options field.</span></td>
        <td class=\"{$Style['tddetails']}\">Name: <input type=\"text\" name=\"newextra\" value=\"\" size=\"20\" class=\"bginput\"><br />
        Type: <select name=\"extratype\"><option value=\"t\">Text box</option><option value=\"c\">Checkbox</option><option value=\"d\">Dropdown</option><option value=\"r\">Radio buttons</option></select><br />
        Options:<br /><textarea name=\"extraoptions\" cols=\"30\" rows=\"3\"></textarea></td></tr>

        <tr><td class=\"{$Style['menubar']}\" colspan=\"3\"><b>Category Introduction</b>
        </td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Enable Catergory Intro?</td>
        <td class=\"{$Style['tddetails']}\"><select name=\"intro-$id\">$introopt</select></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Intro Title:</td>
        <td class=\"{$Style['tddetails']}\"><input type=\"text\" name=\"introtitle-$id\" value=\"$introtitle\" size=\"50\" class=\"bginput\"></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">Intro Text (can contain HTML):</td>
        <td class=\"{$Style['tddetails']}\"><textarea name=\"introcopy-$id\" cols=\"30\" rows=\"10\">$introcopy</textarea></td></tr>

        <tr><td class=\"{$Style['menubar']}\" colspan=\"3\"><b>Usergroup Access
        Permissions*</b><br />
        <span class=\"{$Style['small']}\">Note: If you disable a usergroup's uploads or posts in the Usergroups panel, the category specific settings below won't have an effect for that usergroup.</span>
        </td></tr>
        <tr><td class=\"{$Style['tddetails']}\" valign=\"top\" colspan=\"2\" align=\"left\">These checked usergroups can view images in this category.</td>
        <td class=\"{$Style['tddetails']}\" align=\"left\">$viewoptions</span></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" valign=\"top\" colspan=\"2\" align=\"left\">These checked usergroups can upload to this category,<br />unless a usergroup's overall upload access is disabled.</td>
        <td class=\"{$Style['tddetails']}\" align=\"left\">$upoptions</span></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" valign=\"top\" colspan=\"2\" align=\"left\">These checked usergroups can post to this category,<br />unless a usergroup's overall posting access is disabled.</td>
        <td class=\"{$Style['tddetails']}\" align=\"left\">$postoptions</span></td></tr>";

    if ( $Globals['allowrate'] == "yes" )
    {
        $output .= "<tr><td class=\"{$Style['tddetails']}\" valign=\"top\" colspan=\"2\" align=\"left\">These checked usergroups can vote in this category,<br />unless a usergroup's overall posting access is disabled.</td>
            <td class=\"{$Style['tddetails']}\" align=\"left\">$voteoptions</td></tr>";
    }

    if ( $Globals['annotate'] == "yes" )
    {
        $output .= "<tr><td class=\"{$Style['tddetails']}\" valign=\"top\" colspan=\"2\"><span class=\"{$Style['medium']}\">These checked
            usergroups  will have their photos stamped with your overlay photo.*</td>
            <td class=\"{$Style['tddetails']}\" align=\"left\">$annooptions</td></tr>";
    }

    $output .= "</table></td></tr></table><br /><br />
        *Check box to apply these settings and permissions to all children: <input type=\"checkbox\" name=\"dochildren\" value=\"1\"><br /><br />
        <input type=\"hidden\" name=\"catid\" value=\"$id\">
        <input type=\"hidden\" name=\"ppaction\" value=\"cats\">
        <input type=\"hidden\" name=\"do\" value=\"process\">
        <input type=\"submit\" value=\"Save Changes\"></form></td></tr></table></td></tr></table>";

    ppmysql_free_result( $boards );

    print "$output<br /><br />";

    adminfooter();
    exit;
}

// Edit custom fields
if ( $ppaction == "custom" )
{
    $catextras = ppmysql_query("SELECT id,cat,fieldname,fieldtype,fieldoptions FROM {$Globals['pp_db_prefix']}extrafields WHERE id=$customid", $link);
    list( $exid, $excat, $exname, $extype, $exoptions ) = mysql_fetch_row($catextras);

    if ( !$exid )
    {
        diewell( "Cannot find the custom info for id #$exid" );
    }

    if ($_POST['do'] == "process")
    {
        // Save the changes
        if ( $isdelete == "yes" )
        {
            $query = "DELETE FROM {$Globals['pp_db_prefix']}extrafields WHERE id=$customid";
            $catextras = ppmysql_query($query, $link);

            $query2 = "UPDATE {$Globals['pp_db_prefix']}categories SET numextra=(numextra-1) WHERE id=$customid";
            $catextras = ppmysql_query($query2, $link);

            forward( "adm-cats.php?ppaction=editcat&catid=$catid", "Custom field removed." );
        }

        if ( $newextra && $extratype )
        {
            $query = "REPLACE INTO {$Globals['pp_db_prefix']}extrafields (id,cat,fieldname,fieldtype,fieldoptions)
                VALUES($customid, '$excat', '$newextra', '$extratype', '$extraoptions')";
            $addextra = ppmysql_query($query, $link);

            forward( "adm-cats.php?ppaction=editcat&catid=$catid", "Custom field updated." );
        }
    }

    adminheader( 0, "PhotoPost Category Custom Fields" );

    $sel_t = ( $extype == "t" ? "selected=\"selected\"" : "" );
    $sel_r = ( $extype == "r" ? "selected=\"selected\"" : "" );
    $sel_c = ( $extype == "c" ? "selected=\"selected\"" : "" );
    $sel_d = ( $extype == "d" ? "selected=\"selected\"" : "" );

    $output = "<div align=\"center\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\" width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr><td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>Edit a Custom Field</span></td></tr>
        <tr><td class=\"{$Style['tddetails']}\" colspan=\"2\" align=\"left\">
        <form action=\"{$Globals['maindir']}/adm-cats.php\" method=\"post\">
        <span class=\"{$Style['small']}\"><br />Below you can edit the custom option you have selected.<br /><br />
        Options are entered using a double-pipe <b>||</b> as a field seperator; to
        enter three options, you would enter: <b>field1||field2||field3</b> as your Options field.<br /><br />
        Be careful! If you change the order of the options, then anyone who has selected options using your old
        definitions will find their responses skewed. If you need to add new options, add them onto the end so as
        to not create a problem with fields which have already been selected by users.<br /><br />

        Name: <input type=\"text\" name=\"newextra\" value=\"$exname\" size=\"50\" class=\"bginput\"><br /><br />

        Type: <select name=\"extratype\"><option value=\"t\" $sel_t>Text box</option><option value=\"c\" $sel_c>Checkbox</option><option value=\"d\" $sel_d>Dropdown</option><option value=\"r\" $sel_r>Radio buttons</option></select><br /><br />

        Options:<br /><textarea name=\"extraoptions\" cols=\"50\" rows=\"5\">$exoptions</textarea><br /><br />

        <input type=\"checkbox\" name=\"isdelete\" value=\"yes\" /> Check here to delete this field (be sure before you check)<br /><br />
        <input type=\"hidden\" name=\"catid\" value=\"$excat\" />
        <input type=\"hidden\" name=\"customid\" value=\"$exid\" />
        <input type=\"hidden\" name=\"do\" value=\"process\" />
        <input type=\"hidden\" name=\"ppaction\" value=\"custom\" />
        <input type=\"submit\" value=\"Submit\" /></form></td></tr>
        </table></td></tr></table>";

    print "$output<br /><br />";
    adminfooter();
}


// Empty a category
if ($ppaction == "emptycat")
{
    if ($_POST['do'] == "process")
    {
        if ( is_numeric($catid) )
        {
            $resulta = ppmysql_query("SELECT id,userid,bigimage,medsize,title FROM {$Globals['pp_db_prefix']}photos WHERE cat=$catid", $link);

            while ( list( $phoedit, $uid, $bigimage, $medsize, $title ) = mysql_fetch_row($resulta) )
            {
	            // count number of "copies"
	            $result2a = ppmysql_query("SELECT id,cat FROM {$Globals['pp_db_prefix']}photos WHERE storeid=$phoedit", $link);

	            // if any, then we need to move this image to one of the copies
	            if ( mysql_num_rows($result2a) > 0 )
	            {
	                if ( $storecat == 0 )
	                {
	                    // move the image to the next cat
	                    list( $nextid, $nextcat ) = mysql_fetch_row($result2a);

	                    // move the phyiscal file if an original
	                    move_image( $thecat, $nextcat, $uid, $bigimage );

	                    // update all copies to point to new location and make this one the new pointer
	                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=$nextcat,storeid=$nextid WHERE storeid=$phoedit", $link);
	                    ppmysql_query("UPDATE {$Globals['pp_db_prefix']}photos SET storecat=0,storeid=0 WHERE id=$nextid", $link);
	                }
	            }
	            else
	            {
	                remove_all_files( $bigimage, $medsize, $uid, $catid );
                }
            }

            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE cat=$catid", $link);
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE cat=$catid", $link);
            ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET photos=0, posts=0, lastpost=0, lastphoto=0 WHERE id=$catid", $link);
            adminlog( "Emptied a category: $catid" );

            // Let's update the category cache
            update_catcache();

            forward( "adm-cats.php?ppaction=cats&catid=$catid", "Category has been emptied!" );
        }
        else
        {
            diewell("Invalid category ID.");
        }
    }

    // Generate an 'are you sure' you want to empty? form...

    $catname = $CatPerms['catname'][$catid];
    adminheader( 0, "PhotoPost Categories" );

    $output="<div align=\"center\">

        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
        align=\"center\"><tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Empty a Category</span></td></tr><tr>
        <td class=\"{$Style['tddetails']}\"><div align=\"center\"><br />
        You're about to empty out the category called \"$catname\" of <b>ALL PHOTOS AND COMMENTS</B>.<br /><br />
        Are you sure you want to do that?
        <form action=\"{$Globals['maindir']}/adm-cats.php\" method=\"post\">
        <input type=\"hidden\" name=\"catid\" value=\"$catid\">
        <input type=\"hidden\" name=\"do\" value=\"process\">
        <input type=\"hidden\" name=\"ppaction\" value=\"emptycat\">
        <input type=\"submit\" value=\"I'm sure, empty the category.\"></form></span><br /><br /></td></tr></table></td></tr></table>";

    print "$output<br /><br />";
    adminfooter();
}

//
// Moderators
//

if ($ppaction == "mods")
{
    if ( empty($catid) )
    {
        diewell("Invalid category ID.");
    }

    if ($do == "add")
    {
        list( $newmodid, $tusername, $tmail ) = get_userinfo($newmod);

        if ( $newmodid ) {
            $newmodname = addslashes($tusername);

            $CatPerms['mods'][$catid] .= ( empty($CatPerms['mods'][$catid]) ? "$newmodid||$newmodname" : ",$newmodid||$newmodname" );

            // Record the new list
            $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET moderators='{$CatPerms['mods'][$catid]}' WHERE id=$catid", $link);

            $msg = "Moderator added.";

            // Let's update the category cache
            update_catcache();
            update_catprops();
        }
        else
        {
            $msg = "Unable to find user \"$newmod\"";
        }

        forward( "adm-cats.php?ppaction=mods&catid=$catid", $msg );
    }

    if ($do == "delete")
    {
        if ( $modid )
        {
            $mymods = explode(",", $CatPerms['mods'][$catid] );
            $newmods = null;

            foreach( $mymods as $modrec )
            {
                list( $eachmod, $eachname ) = explode( "||", $modrec );

                if ( $eachmod != $modid )
                {
                    $newmods .= ( empty($newmods) ? "$eachmod||$eachname" : ",$eachmod||$eachname" );
                }
            }

            // Record the new list
            $resulta = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET moderators='$newmods' WHERE id=$catid", $link);
            $msg = "Moderator removed.";

            // Let's update the category cache
            update_catcache();
            update_catprops();
        }
        else
        {
            $msg = "Invalid moderator id passed.";
        }

        forward( "adm-cats.php?ppaction=mods&catid=$catid", $msg );
    }

    // Show them the list of moderators

    adminheader( 0, "PhotoPost Category Moderators" );

    $catname = $CatPerms['catname'][$catid];
    $modlist = null;

    // Category specific moderators
    $mymods = explode(",", $CatPerms['mods'][$catid] );

    foreach ($mymods as $modrec)
    {
        if ( $modrec )
        {
            list( $eachmod, $tusername ) = explode( "||", $modrec );
            $modlist .= "$tusername (<a href=\"{$Globals['maindir']}/adm-cats.php?ppaction=mods&amp;catid=$catid&amp;do=delete&amp;modid=$eachmod\">remove</a>)<br />";
        }
    }

    if ( empty($modlist) )
    {
        $modlist = "There are no moderators assigned to this category.";
    }

    // Inherited moderators
    $moremods = null;

    if ( $CatPerms['parent'][$catid] != 0 )
    {
        $checkcat = $CatPerms['parent'][$catid];

        while ( $checkcat )
        {
            $thiscat = $CatPerms['parent'][$checkcat];
            $mymods = explode(",", $CatPerms['mods'][$checkcat] );

            foreach ($mymods as $modrec)
            {
                list( $eachmod, $tusername ) = explode( "||", $modrec );

                if ( $eachmod )
                {
                    $moremods .= "$tusername (<a href=\"{$Globals['maindir']}/adm-cats.php?ppaction=mods&amp;catid=$checkcat\">{$CatPerms['catname'][$checkcat]}</a>)<br />";
                }
            }

            $checkcat = $CatPerms['parent'][$checkcat];
        }
    }

    if ( empty($moremods) )
    {
        $modlist .= "<br /><br />There are no moderators inherited from its parents.";
    }
    else
    {
        $modlist .= "<br /><br /><b>Moderators inherited by parent categories</b><br /><span class=\"{$Style['small']}\">(must be remove at parent)</span><br /><br />$moremods";
    }

    $output = "<div align=\"center\">

        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
        align=\"center\"><tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Category Moderators</span></td></tr><tr>
        <td class=\"{$Style['tddetails']}\" align=\"center\"><b>Moderator list for $catname</b><br />
            <br />$modlist<br /><br />
            <form action=\"{$Globals['maindir']}/adm-cats.php\" method=\"post\">
            <input type=\"hidden\" name=\"catid\" value=\"$catid\">
            <input type=\"hidden\" name=\"ppaction\" value=\"mods\">
            <input type=\"hidden\" name=\"do\" value=\"add\">
            <input type=\"text\" name=\"newmod\" size=\"30\" class=\"bginput\">&nbsp;<input type=\"submit\" value=\"Add\"></form>
        </td></tr></table>
        </td></tr></table>";

    print "$output<br /><br />";

    adminfooter();
}


//
// ADM-CATS Main
//

if ($ppaction == "cats")
{
    $start = ( isset($start) ? 1 : 0 );

    if ($_POST['do'] == "process")
    {
        typecast($_POST, array('catid' => INT));
        typecast_wc("catorder", INT);

        $children = null;
        $oldparent = 0;

        if ( !empty($catid) )
        {
            $catq = ppmysql_query("SELECT children,parent FROM {$Globals['pp_db_prefix']}categories where id=$catid", $link);
            list( $thesekids, $oldparent ) = mysql_fetch_row($catq);

            $children = null;

            if ( isset($dochildren) && $dochildren == 1 )
            {
                $processcats = explode( ",", $thesekids );

                while ( list($num, $eachcat) = each($processcats) )
                {
                    if ( !empty($eachcat) )
                    {
                        $children .= " OR id='$eachcat'";
                    }
                }
            }
        }

        $doview = null;
        $doupload = null;
        $dopost = null;
        $dovote = null;
        $doanno = null;

        foreach($_POST as $vid=>$setting)
        {
            $ugorder = explode("-", $vid);
            $catvar = $ugorder[0];
            $ugid = 0;
            $query = null;

            $setting = (ini_get("magic_quotes_gpc")) ? addslashes(stripslashes(trim($setting))) : addslashes(trim($setting));

            if ( count($ugorder) > 1 )
            {
                $ugid = $ugorder[1];
            }

            if ($catvar == "view")
            {
                if ($setting == 1)
                {
                    if ( $doview != "" )
                    {
                        $doview .= ",";
                    }

                    $doview .= "$ugid";
                }
            }
            elseif ($catvar == "up")
            {
                if ($setting == 1)
                {
                    if ( $doupload != "" )
                    {
                        $doupload .= ",";
                    }

                    $doupload .= "$ugid";
               }
            }
            elseif ($catvar == "post")
            {
                if ($setting == 1)
                {
                    if ( $dopost != "" )
                    {
                        $dopost .= ",";
                    }

                    $dopost .= "$ugid";
                }
            }
            elseif ($catvar == "vote")
            {
                if ($setting == 1)
                {
                    if ( $dovote != "" )
                    {
                        $dovote .= ",";
                    }

                    $dovote .= "$ugid";
                }
            }
            elseif ($catvar == "anno")
            {
                if ($setting == 1)
                {
                    if ( $doanno != "" )
                    {
                        $doanno .= ",";
                    }

                    $doanno .= "$ugid";
                }
            }
            else {
                $query = null;

                if ( $catvar == "newextra" )
                {
                    if ( !empty($setting) )
                    {
                        // Wants to add a new field to category
                        if ( $newextra && $extratype )
                        {
                            $addextra = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}extrafields (id,cat,fieldname,fieldtype,fieldoptions)
                                VALUES(NULL,'$catid','$newextra','$extratype','$extraoptions')", $link);

                            if ( $dochildren == 1 )
                            {
                                reset($processcats);

                                while ( list($num, $eachcat) = each($processcats) )
                                {
                                    if ( !empty($eachcat) )
                                    {
                                        $addextra = ppmysql_query("INSERT INTO {$Globals['pp_db_prefix']}extrafields (id,cat,fieldname,fieldtype,fieldoptions)
                                            VALUES(NULL,'$eachcat','$newextra','$extratype','$extraoptions')", $link);
                                    }
                                }
                            }

                            $addextra = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET numextra=(numextra+1) WHERE id=$catid", $link);
                        }
                    }
                }

                if ( !empty($ugid) )
                {
                    if ( $catvar == "header" || $catvar == "footer" || $catvar == "headtags" || $catvar == "ugnoview" ||
                         $catvar == "ugnoupload" || $catvar == "ugnopost" || $catvar == "ugnovote" || $catvar == "ugnoanno" || $catvar == "theme" ||
                         $catvar == "catdepth" || $catvar == "frame" || $catvar == "watermark" || $catvar == "sortorder" || $catvar == "canzip" ||
                         $catvar == "maximages" || $catvar == "ratingtype" || $catvar == "thumbtype" || $catvar == "ismember" || strstr($catvar, "extra") )
                    {
                            $ugid .= $children;
                    }

                    if ( $catvar != "private" && $catvar != "thumbs" && $catvar != "parent" && $catvar != "catid" && $catvar != "dochildren" )
                    {
                        $query = "UPDATE {$Globals['pp_db_prefix']}categories SET $catvar='$setting' WHERE id=$ugid";
                    }

                    if ( $ugid != 500 )
                    {
                        if ( $catvar == "private" )
                        {
                            $query = "UPDATE {$Globals['pp_db_prefix']}categories SET private='$setting' WHERE id=$ugid";
                        }
                        elseif ( $catvar == "thumbs" )
                        {
                            $query = "UPDATE {$Globals['pp_db_prefix']}categories SET thumbs='$setting' WHERE id=$ugid";
                        }
                        elseif ( $catvar == "parent" )
                        {
                            childcheck($setting, $ugid);

                            $query = "UPDATE {$Globals['pp_db_prefix']}categories SET parent='$setting' WHERE id=$ugid";
                            $newparent = $setting;
                        }
                    }

                    if ( $query != "" && $catvar != "ppaction" && $catvar != "do" && $catvar != "catid" )
                    {
                        $resulta = ppmysql_query($query, $link);
                        updateparents( $ugid );
                    }
                }
            }
        }

        if ( $catid != 0 )
        {
            $ugviewblock = explode( ",", $doview);
            $ugupblock = explode( ",", $doupload);
            $ugpostblock = explode( ",", $dopost);
            $ugvoteblock = explode( ",", $dovote);
            $ugannoblock = explode( ",", $doanno);

            $catid .= $children;
            $blockview = null;
            $blockup = null;
            $blockpost = null;
            $blockvote = null;
            $blockanno = null;

            $resultg = ppmysql_query("SELECT groupid,groupname FROM {$Globals['pp_db_prefix']}usergroups", $link);

            while ( list($groupid, $groupname) = mysql_fetch_row($resultg) )
             {
                $vthisid=0;
                $uthisid=0;
                $pthisid=0;
                $athisid=0;
                $votethisid=0;

                reset($ugviewblock);
                while ( list($ignore,$vgid) = each($ugviewblock) )
                {
                    if ($groupid == $vgid)
                    {
                        $vthisid="1";
                    }
                }

                reset($ugupblock);
                while ( list($ignore,$ugid) = each($ugupblock) )
                {
                    if ($groupid == $ugid)
                    {
                        $uthisid="1";
                    }
                }

                reset($ugpostblock);
                while ( list($ignore,$pgid) = each($ugpostblock) )
                {
                    if ($groupid == $pgid)
                    {
                        $pthisid="1";
                    }
                }

                reset($ugvoteblock);
                while ( list($ignore,$votegid) = each($ugvoteblock) )
                {
                    if ($groupid == $votegid)
                    {
                        $votethisid="1";
                    }
                }

                reset($ugannoblock);
                while ( list($ignore,$agid) = each($ugannoblock) )
                {
                    if ($groupid == $agid)
                    {
                        $athisid="1";
                    }
                }

                if ($vthisid==0)
                {
                    if ( $blockview != "" )
                    {
                        $blockview .= ",";
                    }

                    $blockview .= "$groupid";
                }

                if ($uthisid==0)
                {
                    if ( $blockup != "" )
                    {
                        $blockup .= ",";
                    }

                    $blockup .= "$groupid";
                }

                if ($pthisid==0)
                {
                    if ( $blockpost != "" )
                    {
                        $blockpost .= ",";
                    }

                    $blockpost .= "$groupid";
                }

                if ($votethisid==0)
                {
                    if ( $blockvote != "" )
                    {
                        $blockvote .= ",";
                    }

                    $blockvote .= "$groupid";
                }

                if ($athisid==0)
                {
                    if ( $blockanno  != "" )
                    {
                        $blockanno .= ",";
                    }

                    $blockanno .= "$groupid";
                }
            }

            $resultc = ppmysql_query("UPDATE {$Globals['pp_db_prefix']}categories SET ugnoview='$blockview',ugnoupload='$blockup',ugnopost='$blockpost',ugnovote='$blockvote',ugnoanno='$blockanno' WHERE id=$catid", $link);
        }

        if ( $oldparent != $newparent )
        {
            updateparents($oldparent);

            if ( is_numeric($newparent) && !empty($newparent) )
            {
                updateparents($newparent);
            }
        }
        else
        {
            if ( $backcat > 0 )
            {
                updateparents($backcat);
            }
        }

        adminlog( "Edited a category: $catid" );

        // Let's update the category cache
        update_catcache();
        update_catprops();

        if ( $backcat > 0 )
        {
            $newparent = $backcat;
        }

        forward( "adm-cats.php?ppaction=cats&catid=$newparent", "Processing complete!" );
    }

    // Generate the edit categories HTML form
    $output = "<div align=\"center\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\"
        align=\"center\"><tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['large']}\"><b>PhotoPost Category Editor</b></span></td>
        </tr>
        <form method=\"post\" action=\"{$Globals['maindir']}/adm-cats.php\">
        <tr>
        <td class=\"{$Style['tddetails']}\" align=\"left\">";

    if ( isset($sort) && $sort == 1 )
    {
        sortsubcat($catid);
    }
    elseif ( !isset($catid) || !is_numeric($catid) )
    {
        $output .= "<br /><a href=\"{$Globals['maindir']}/adm-cats.php?ppaction=addcat\">Add Top Level Category</a></font><br />";

        catli(0);
    }
    else
    {
        catli($catid);
    }

    $output.= "<br /><div align=\"center\">
        <input type=\"hidden\" name=\"ppaction\" value=\"cats\" />
        <input type=\"hidden\" name=\"backcat\" value=\"$catid\" />
        <input type=\"hidden\" name=\"do\" value=\"process\" />
        <input type=\"submit\" value=\"Save Order Changes\" /></form></td></tr></table></td></tr></table>";

    adminheader( 0, "PhotoPost Categories" );
    print "$output<br /><br />";
    adminfooter();
}

if ( $ppaction == "delphotos" )
{
    if ( $_POST['do'] == "process" ) {
        if ( empty($uid) )
        {
            diewell( "Bad uid for delete photos call." );
        }

        $resulta = ppmysql_query("SELECT cat,bigimage,medsize,title,user FROM {$Globals['pp_db_prefix']}photos WHERE userid=$uid", $link);

        while ( list( $thiscat, $bigimage, $medsize, $title, $user ) = mysql_fetch_row($resulta) )
        {
            remove_all_files( $bigimage, $medsize, $uid, $catid );
        }

        // end delete the files //
        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}photos WHERE userid=$uid", $link);
        ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}notify WHERE userid=$uid", $link);

        if ( $delcomments == "yes" )
        {
            ppmysql_query("DELETE FROM {$Globals['pp_db_prefix']}comments WHERE userid=$uid", $link);
        }

        upgradecategories($thiscat);

        adminlog( "Removed user images: $user" );

        // Let's update the category cache
        update_catcache();

        forward( "index.php", "Processing complete!" );
    }

    // Generate an 'are you sure' you want to delete? form...
    list( $userid, $username, $email ) = get_userinfo("", $uid);

    adminheader( 0, "PhotoPost User Admin" );

    $output="<div align=\"center\">
        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"{$Style['tableborders']}\"  width=\"{$Globals['tablewidth']}\" align=\"center\">
        <tr><td>
        <table cellpadding=\"2\" cellspacing=\"1\" border=\"0\"  width=\"100%\">
        <tr>
        <td colspan=\"4\" align=\"left\" class=\"{$Style['menubar']}\"><span class=\"{$Style['medium']}\"><b>PhotoPost Delete Photos By User</span></td>
        </tr><tr>
        <td class=\"{$Style['tddetails']}\">
        <div align=\"center\"><br />
        You're about to delete all the photos posted by the user \"$username\"</b>.<br /><br />
        <input type=\"checkbox\" name=\"delcomments\" value=\"yes\"> Check to delete all comments by this user<br /><br />
        Are you sure you want to do that?<br /><br />
        <form action=\"{$Globals['maindir']}/adm-cats.php\" method=\"post\">
        <input type=\"hidden\" name=\"uid\" value=\"$uid\">
        <input type=\"hidden\" name=\"do\" value=\"process\">
        <input type=\"hidden\" name=\"ppaction\" value=\"delphotos\">
        <input type=\"submit\" value=\"DELETE PHOTOS\"></form></span></td></tr></table></td></tr></table>";

    print "$output<br /><br />";
    adminfooter();
}

?>
