//---  MDM QuickQuote 1.0.8a / vB3.7, vB3.8 ---
function qq_Post_Handler()
{
	this.posts = new Array();
	this.quote = '';
	this.activePost = null;
	this.hover = false;
	this.allowQuote = false;

	this.win = new qq_Popup_Window();
	this.win.button.onclick = qq_PostEntry.prototype.onclick;
}

qq_Post_Handler.prototype.register = function(tpost, postid)
{
	if (tpost && tpost.id || postid)
	{
		postid = postid || (tpost.id != 'post' ? parseInt(tpost.id.substr(4), 10) : '');
		var post = fetch_object('td_post_' + postid);
		if (post)
		{
			post.postid = (postid != '' ? postid : 0);
			var links = username = null;
			if ((username = fetch_object('postmenu_' + postid)) && (links = fetch_tags(username, 'a')))
			{
				for (var i = 0; i < links.length; i++)
				{
					if (links[i].className == 'bigusername')
					{
						this.posts[post.postid] = new qq_PostEntry(post.postid, post, links[i]);
						break;
					}
				}
			}
			if ((typeof this.posts[post.postid] == 'undefined') && username)
			{
				this.posts[post.postid] = new qq_PostEntry(post.postid, post, username);
			}

			if (qq_values['hide_qrbtn'])
			{
				var btn = fetch_object('qr_' + postid);
				if (btn) btn.style.display = 'none';
			}
		}
	}
}

qq_Post_Handler.prototype.check = function(v)
{
	this.quote = PHP.trim(this.selection());
	if (this.quote != '' && qq_values['winpos'] > 0)
	{
		for (var postid in this.posts)
		{
			if (this.posts[postid].post == this.activePost)
			{
				if (qq_values['workmode'] != 2)
				{
					if (qq_values['workmode'] == 1) this.posts[postid].nick.title = vbphrase['qq_nicktitle'];
					if (qq_values['winpos'] == 2 || v)
					{
						if (!this.win.visible || this.win.force)
							this.posts[postid].nick.title = '';
						this.win.force = v;
						var qq_Yahoo = (typeof YAHOO != 'undefined');
						var pos = (qq_Yahoo ? YAHOO.util.Dom.getXY(this.posts[postid].nick) : vB_Popup_Menu.prototype.fetch_offset(this.posts[postid].nick));
						this.win.winX = (qq_Yahoo ? pos[0] : pos['left']);
						this.win.winY = (qq_Yahoo ? pos[1] : pos['top']) + this.posts[postid].nick.offsetHeight;
					}
				}
				this.win.button.postid = postid;
				this.win.set();
				break;
			}
		}
	}
}

qq_Post_Handler.prototype.paste = function(obj, e)
{
	for (var postid in this.posts)
	{
		if (postid == obj.postid)
		{
			var entry = this.posts[postid];
			break;
		}
	}

	this.win.hide();
	if (typeof vBmenu != 'undefined') vBmenu.hide();
	if (typeof entry != 'undefined')
	{
		if (typeof entry.nick.username == 'undefined')
		{
			entry.nick.username = PHP.trim((typeof entry.nick.textContent != 'undefined' ? entry.nick.textContent : entry.nick.innerText).replace(/vbmenu_register\(.+\);/g, ''));
		}

		var edt = vB_Editor[QR_EditorID];
		if (typeof require_click != 'undefined' && require_click && fetch_object('qr_quickreply').disabled) edt.write_editor_contents('');
		var wmode = edt.wysiwyg_mode;
		var content = edt.get_editor_contents();
		var delim = (wmode ? '<br />' : '\n');
		var quote = '';

		var username = wmode ? PHP.htmlspecialchars(entry.nick.username) : entry.nick.username;
		if (this.quote == '' || this.activePost.postid != entry.postid)
		{
			if (username != '')
			{
				if (entry.nick.href && e.shiftKey)
				{
					if (wmode) username = '<a href="' + entry.nick.href + '">' + username + '</a>';
					else username = '[url="' + entry.nick.href + '"]' + username + '[/url]';
				}
				quote = (wmode ? '<b>' : '[b]') + username + (wmode ? '</b>' : '[/b]');

				if (vbphrase['qq_format'].toLowerCase().indexOf('%nick%') != -1)
					quote = vbphrase['qq_format'].replace(/%nick%/i, quote) + ' ';
				else quote += ', ';
			}
			else quote = '';
		}
		else
		{
			if (wmode)
			{
				this.quote = PHP.htmlspecialchars(this.quote);
			}
			quote = '[quote' + (username != '' ? '="' + username + (entry.postid > 0 ? ';' + entry.postid : '') + '"' : '') + ']' + this.quote + '[/quote]' + delim;
		}
		this.quote = '';
		if (wmode) quote = quote.replace(/\n/g, '<br />');
		if (wmode && PHP.in_array(content, ['', '<br />', '<br>', '<P>&nbsp;</P>', '&nbsp;', '<b></b>', '<b></b><br>', '<P></P>']) != -1) content = '';
		if (content == '') delim = '';
		if (entry.postid > 0) qr_activate(entry.postid); else edt.check_focus();
		edt.write_editor_contents((wmode ? ' ' : content + delim + quote), false);
		if (wmode) edt.insert_text(content + delim + quote, false);

		if (!wmode)
		{
			var ewin = edt.editwin, len = ewin.value.length;
			if (ewin.setSelectionRange)
				ewin.setSelectionRange(len, len);
			else if (ewin.createTextRange)
				with (ewin.createTextRange())
				{
					collapse(false);
					select();
				}
			ewin.scrollTop = ewin.scrollHeight;
		}
		this.allowQuote = false;
		return true;
	}
	return false;
}

qq_Post_Handler.prototype.selection = function()
{
	if (window.getSelection) return window.getSelection().toString();
	else if (document.getSelection) return document.getSelection();
	else if (document.selection) return document.selection.createRange().text;
}

qq_Post_Handler.prototype.dohover = function(v, obj)
{
	this.hover = v;
	clearTimeout(this.win.timer);
	if (v)
	{
		if (this.allowQuote && this.activePost && this.activePost.postid == obj.postid)
			this.check(true);
	}
	else
	{
		if (qq_values['workmode'] == 1)
			this.posts[obj.postid].nick.title = vbphrase['qq_nicktitle'];
		if (qq_values['wintime'] > 0)
			this.win.timer = setTimeout("qqPostData.win.hide()", qq_values['wintime'] * 1000);
	}
}

//---  ---
function qq_PostEntry(postid, post, nick)
{
	this.postid = postid;

	this.post = post;
	this.post.onmouseup = this.postmouseup;
	
	this.nick = nick;
	this.nick.postid = postid;
	if (qq_values['workmode'] != 2)
	{
		this.nick.onmouseover = function(){qqPostData.dohover(true, this);};
		this.nick.onmouseout = function(){qqPostData.dohover(false, this);};
	}
	if (qq_values['workmode'] == 1)
	{
		this.nick.onclick = this.onclick;
		this.nick.style.cursor = pointer_cursor;
		this.nick.setAttribute('title', vbphrase['qq_nicktitle']);

		if (this.nick.tagName == 'A' && typeof this.nick.done == 'undefined')
		{
			this.nick.done = true;
			var img = document.createElement('img');
			img.className = 'inlineimg';
			img.style.padding = '4px 2px 4px 6px';
			img.style.cursor = pointer_cursor;
			img.setAttribute('title', vbphrase['qq_usermenu']);
			img.src = qq_values['image_menu'];
			this.nick.parentNode.insertBefore(img, this.nick.nextSibling);
			this.nick.parentNode.style.display = 'inline';
		}
	}
}

qq_PostEntry.prototype.postmouseup = function(e)
{
	e = e || window.event;

	t = (e.target || e.srcElement);
	if (t.tagName == 'TEXTAREA' || t.tagName == 'INPUT' || (t.tagName == 'IMG' && t.src.match(/\/editor\//)))
	{
		return;
	}

	if (e.pageX == null && typeof e.clientX == "number")
	{
		e.pageX = e.clientX + document.documentElement.scrollLeft;
		e.pageY = e.clientY + document.documentElement.scrollTop;
	}
	if (!e.which && e.button)
	{
		if (e.button & 1) e.which = 1;
	}
	if (e.which == 1)
	{
		qqPostData.win.force = false;
		qqPostData.win.winX = e.pageX;
		qqPostData.win.winY = e.pageY;
		qqPostData.activePost = this;
		qqPostData.allowQuote = true;
		setTimeout("qqPostData.check(false);", 0);
	}
}

qq_PostEntry.prototype.onclick = function(e)
{
	e = e || window.event;
	if (qqPostData.paste(this, e) && typeof do_an_e == 'function')
	{
		do_an_e(e);
	}
}

//---  ---
function qq_Popup_Window()
{
	this.visible = false;
	this.force = false;
	this.winX = -1;
	this.winY = -1;

	this.win = document.createElement('div');
	this.win.className = 'vbmenu_popup';
	this.win.id = 'qqwin';
	this.win.style.display = 'none';
	this.win.style.position = 'absolute';
	this.win.style.zIndex = 49;
	this.win.style.padding = '1px';

	this.button = document.createElement('div');
	this.button.postid = 0;
	this.button.innerHTML = '<img src="' + qq_values['image_quote'] + '" alt="" align="absmiddle" />' + vbphrase['qq_title'];
	this.button.className = 'vbmenu_option';
	this.button.style.padding = '2px 4px 2px 0';
	this.button.style.fontWeight = 'bold';
	this.button.onmouseover = function(){this.className = 'vbmenu_option vbmenu_hilite'; qqPostData.dohover(true, this);};
	this.button.onmouseout = function(){this.className = 'vbmenu_option'; qqPostData.dohover(false, this);};

	this.win.appendChild(this.button);
	document.body.appendChild(this.win);
}

qq_Popup_Window.prototype.set = function()
{
	if (!this.visible)
		setTimeout("qqPostData.win.show()", 0);
}

qq_Popup_Window.prototype.show = function()
{
	this.visible = true;
	clearTimeout(this.timer);
	if (typeof vBmenu != 'undefined') vBmenu.hide();
	if (!this.jquery_process('show'))
	{
		this.win.style.display = '';
	}

	var l = this.winX;
	var t = this.winY;
	if (qq_values['winpos'] == 1 && !this.force)
	{
		var l = l - (this.win.offsetWidth / (is_ie ? 1 : 2));
		var t = t + 12;
	}
	this.win.style.left = l + 'px';
	this.win.style.top = t + 'px';
	if (qq_values['wintime'] > 0) this.timer = setTimeout("qqPostData.win.hide()", qq_values['wintime'] * 1000);
}

qq_Popup_Window.prototype.hide = function()
{
	this.visible = this.force = false;
	clearTimeout(this.timer);
	this.jquery_process('hide');
	this.win.style.display = 'none';
}

qq_Popup_Window.prototype.jquery_process = function(mode)
{
	if (!qq_jQuery) return false;
	try
	{
		switch (mode)
		{
			case 'show':
				jQuery('#qqwin').css("opacity", "0");
				jQuery('#qqwin').animate({height: "show", opacity: "1"}, 200);
			break;
			case 'hide':
				jQuery('#qqwin').stop(true, true);
			break;
		}
	}
	catch(e)
	{
		try { jQuery('#qqwin').css("opacity", "1"); } catch(e) {}
		qq_jQuery = false;
		if (window.console) console.warn('QuickQuote Error: ' + e.message);
		return false;
	}
	return true;
}

//---  ---
function qq_init()
{
	var posts = fetch_tags(fetch_object('posts'), 'table');
	if (posts.length == 0) posts.push(fetch_object('post')); // Private Message
	for (var i = 0; i < posts.length; i++)
	{
		if (posts[i] && posts[i].id && posts[i].id.indexOf('post') == 0)
		{
			qqPostData.register(posts[i], 0);
		}
	}

	function qqwin_hide(e)
	{
		if (!qqPostData.hover && qqPostData.win.visible)
		{
			qqPostData.win.hide();
			qqPostData.quote = '';
			qqPostData.allowQuote = false;
		}
	}

	qqPostBit_Init = PostBit_Init;
	PostBit_Init = function(obj, postid)
	{
		qqPostBit_Init(obj, postid);
		qqPostData.register(obj, postid);
	}

	if (window.attachEvent && !is_saf) document.attachEvent('onmousedown', qqwin_hide);
	else if (document.addEventListener && !is_saf) document.addEventListener('mousedown', qqwin_hide, false);
	else window.onmousedown = qqwin_hide;
}
if (qq_values['winpos'] && (qq_values['workmode'] == 2)) qq_values['winpos'] = 1;
var qq_jQuery = (typeof jQuery == 'function' && jQuery.fn.jquery.replace(/\./g, '') >= 130);
var qqPostData = new qq_Post_Handler();
qq_init();
