<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

define ("HAND_NOTHING", 1);
define ("HAND_PAIR", 2);
define ("HAND_TWO_PAIR", 3);
define ("HAND_THREE_OF_A_KIND", 4);
define ("HAND_STRAIGHT", 5);
define ("HAND_FLUSH", 6);
define ("HAND_FULL_HOUSE", 7);
define ("HAND_FOUR_OF_A_KIND", 8);
define ("HAND_STRAIGHT_FLUSH", 9);


class pokerHand
{
	var $bestHand, $hand, $userID, $handName;
	
	function loadHand ($hand)
	{
		$this->hand = $hand;
	}

	function handXML($avatar = false)
	{
		global $user, $poker;
		$output= "";
		$cards = 0;
		foreach ($this->hand as $c)
		{
			$cardInfo = $this->evalCard(abs($c));
			$cardName = $cardInfo['cardName'];
			$cardFile = $cardInfo['cardFile'];
			if($this->userID == $user->userID || $c > 0 )
				$output .= "<card id='" . abs($c) . "' name='$cardName' img='$cardFile'/>";
			else if ($c < 0)
				$output .= "<card  id='0' name='' img='gameroom/images/back-blue-150-1.png'/>";
			else
				$output .= "<card  id='' name='' img=''/>";
			$cards++;
			
		}
		if (($poker->rules == RULES_7CARDSTUD) && ($cards < 7))
		{
			while($cards < 7)
			{
				$output .= "<card  id='' name='' img=''/>";
				$cards++;
			}
		}
		return $output;
	}

	function evalCard($card)
	{
		global $language;
		$card = $card -1;
		
		if (($card === null) || ($card == -1))
		{
			$output = array();
			$output['faceValue'] = 0;
			$output['suit'] = "";
			$output['cardFile'] = "";
			$output['cardName'] = "";
		
			return $output;
			
		}
		$faceValue = $card % 13;
		$suit = floor($card/13);
		
		if($suit==0)
		{
			$cardfile = "gameroom/images/spades-"; 
			$cardname = $language['cards']['Spades']; 
		}
		else if($suit==1)
		{
			$cardfile = "gameroom/images/diamonds-";
			$cardname = $language['cards']['Diamonds'];  
		}
		else if($suit==2)
		{
			$cardfile = "gameroom/images/hearts-";
			$cardname = $language['cards']['Hearts']; 
		}
		else if($suit==3)
		{
			$cardfile = "gameroom/images/clubs-";
			$cardname =$language['cards']['Clubs']; 
		}

		if($faceValue+2<11)
		{
			$cardfile .= ($faceValue+2) . "-150.png";
			$cardname = ($faceValue+2) . $language['cards']['Of']  . $cardname; 
		}
		else if($faceValue+2==11)
		{
			$cardfile .= "j-150.png"; 
			$cardname = $language['cards']['Jack']  . $language['cards']['Of']  . $cardname; 
		}
		else if($faceValue+2==12)
		{
			$cardfile .= "q-150.png"; 
			$cardname = $language['cards']['Queen']  . $language['cards']['Of']  . $cardname; 
		}
		else if($faceValue+2==13)
		{
			$cardfile .= "k-150.png"; 
			$cardname = $language['cards']['King']  . $language['cards']['Of']  . $cardname; 
		}
		else if($faceValue+2==14)
		{
			$cardfile .= "a-150.png"; 
			$cardname = $language['cards']['Ace'] . $language['cards']['Of']  . $cardname; 
		}
		
		$output = array();
		$output['faceValue'] = $faceValue;
		$output['suit'] = $suit;
		$output['cardFile'] = $cardfile;
		$output['cardName'] = $cardname;
		
		return $output;
	}
	
		
	function evalHand($card = NULL)
	{
		
		// 5 = hand type
		// 6 - 10 - cards in descending value of importance
		// only loaded if needed
		// first value that is higher in a comparrison is the better hand
		//
		// full house - [5] -> 7 (hand value) [6] -> face value of 3 of a kind 7 - 10 are not loaded
		// as it is impossible for 2 players to have full houses with the same 3 of a kind. 
		
		
		$f = array(); // face value
		$s = array(); // suit
		
		if(! $card)
			$card = $this->hand;
		
		//$card = explode(",", $card);
		$besthand = $card + array(0,0,0,0,0,0,0,0,0,0,0);
		
		if($card[0] === null)
			return $besthand;
		
		// Get the values 
		for($x = 0; $x < 5; $x++)
		{
			$f[$x] = (abs($card[$x])-1) % 13;
			$s[$x] = floor((abs($card[$x])-1)/13);
		}

		// Reset counters
		$fcount = array();
		$scount = array();
		$pair = array();
		$flush = 0;
		$straight = 0;
		$paircount = $three = $four = 0;
		$handvalue = 0;
		
		// Check the hand compared to the best one so far. 
		
		// Flush
		if(($s[0] == $s[1])&&($s[0] == $s[2])&&($s[0] == $s[3])&&($s[0] == $s[4]))
			$flush = 1;;

		// preload array
		for($i = 0; $i < 13; $i++) 
			$fcount[$i] = 0;
			
		// count matching cards
		for($i = 0; $i < 5; $i++) {
			$f1 = $f[$i];
			$fcount[$f1]++;
		}
		
		// Count pairs
		//Three or Four of a kind?
		for($i = 0; $i < 13; $i++) 
		{
			if($fcount[$i]==2)
			{
				$pair[$paircount] = $i+1;
				$paircount+=1; 
			}
			else if($fcount[$i]==3)
				$three = $i+1;
			else if($fcount[$i]==4)
				$four = $i+1;;
		}
		
		// Straight
		if (($paircount == 0) && ($three == 0) && ($four == 0))
		{
			if ((max($f) - min($f)) == 4) 
			{
				$straight = max($f) + 1;
			}
			else if(max($f) == 12)
			{
				if($f[0] + $f[1] + $f[2] + $f[3] + $f[4] == 18)
				{
					$straight = 5;
				}
			}
		}

		if(($straight) && ($flush))
		{
			// hand type, highest value in straight
			$besthand[5] = HAND_STRAIGHT_FLUSH;
			$besthand[6] = $straight;

		}	
		else if($four)
		{
			$besthand[5] = HAND_FOUR_OF_A_KIND;
			$besthand[6] = $four;
		}	
		else if(($three)&&($paircount))
		{
			$besthand[5] = HAND_FULL_HOUSE;
			$besthand[6] = $three;
			$besthand[7] = max($pair);
		}	
		else if($flush)
		{
			$besthand[5] = HAND_FLUSH;
			$f2 = $f;
			rsort($f2);
			for($i = 0; $i < 5; $i++)
			{
				$j = 6 + $i;
				$besthand[$j] = $f2[$i];
			}
		}	
		else if($straight)
		{
			$besthand[5] = HAND_STRAIGHT;
			$besthand[6] = $straight;
		}	
		else if($three)
		{
			$besthand[5] = HAND_THREE_OF_A_KIND;
			$besthand[6] = $three;
			
			$f2 = $f;
			rsort($f2);
			$j = 7;
			for($i = 0; $i < 5; $i++)
			{
				if($f2[$i] != $three)
				{
					$besthand[$j] = $f2[$i];
					$j++;
				}
			}
			
		}
		else if($paircount == 2)
		{
			$besthand[5] = HAND_TWO_PAIR;
			$besthand[6] = max($pair);
			$besthand[7] = min($pair);

			$f2 = $f;
			rsort($f2);
			$j = 8;
			for($i = 0; $i < 5; $i++)
			{
				if (($f2[$i] != max($pair)) && ($f2[$i] != min($pair)))
				{
					$besthand[$j] = $f2[$i];
					$j++;
				}
			}
						
		}	
		else if($paircount==1)
		{
			$besthand[5] = HAND_PAIR;
			$besthand[6] = max($pair);

			$f2 = $f;
			rsort($f2);
			$j = 7;
			for($i = 0; $i < 5; $i++)
			{
				if($f2[$i] != max($pair))
				{
					$besthand[$j] = $f2[$i];
					$j++;
				}
			}
		}	
		else 
		{
			$besthand[5] = HAND_NOTHING;
			$f2 = $f;
			rsort($f2);
			for($i = 0; $i < 5; $i++)
			{
				$j = 6 + $i;
				$besthand[$j] = $f2[$i];
			}
		}	

		return $besthand;
	}
	
	function findBestHand()
	{
		global $language;
		// Find the best 5-card hand out of 7 cards
		// Texas Hold'em / 7-card stud
		
		$f = array();
		$s = array();
		$this->bestHand = array(0,0,0,0,0,0,0,0,0,0,0);
		// 0 - 4 = cards
		// 5 = hand type
		// 6 = value of cards in hand. 

		// Choose the best 5 of 5 to make a hand. 
	
		for($x=0;$x<7;$x++)
		{
			for($y=$x+1;$y<7;$y++)
			{
				for($a=$y+1;$a<7;$a++)
				{
					for($b=$a+1;$b<7;$b++)
					{
						for($c=$b+1;$c<7;$c++)
						{
							$tempHand = array(abs($this->hand[$x]), abs($this->hand[$y]), abs($this->hand[$a]), abs($this->hand[$b]), abs($this->hand[$c]) );
							$t = $this->evalHand($tempHand);
							$draw = true;
							
							for($i = 5; $i < 10; $i++)
							{
								if($t[$i] > $this->bestHand[$i])
								{
									$this->bestHand = $t;
									$draw = false;
									$i = 11;
								}
								else if($t[$i] < $this->bestHand[$i])
								{
									$draw = false;
									$i = 11;
								}
							}
							
						}
					}
				}
			}
		}
		
		if($this->bestHand[5] == HAND_NOTHING)
			$this->handName = $language['pokerHands']['Nothing']; 
		else if($this->bestHand[5] == HAND_PAIR)
			$this->handName = $language['pokerHands']['Pair'];
		else if($this->bestHand[5] == HAND_TWO_PAIR)
			$this->handName = $language['pokerHands']['Two_Pair'];
		else if($this->bestHand[5] == HAND_THREE_OF_A_KIND)
			$this->handName = $language['pokerHands']['Three_of_a_Kind'];
		else if($this->bestHand[5] == HAND_STRAIGHT)
			$this->handName = $language['pokerHands']['Straight'];
		else if($this->bestHand[5] == HAND_FLUSH)
			$this->handName = $language['pokerHands']['Flush'];
		else if($this->bestHand[5] == HAND_FULL_HOUSE)
			$this->handName = $language['pokerHands']['Full_House'];
		else if($this->bestHand[5] == HAND_FOUR_OF_A_KIND)
			$this->handName = $language['pokerHands']['Four_of_a_Kind'];
		else if($this->bestHand[5] == HAND_STRAIGHT_FLUSH)
			$this->handName = $language['pokerHands']['Straight_Flush'];
			
	}
	
	function getXML()
	{

	}
	
	function drawCard($faceUp = "0", $userID = "")
	{
		global $poker, $db, $user;
		
		if (! $userID)
			$userID = $user->userID;
			
		$query = "
			UPDATE gameroom_poker_dealt
			SET userID = $userID,
				faceUp = $faceUp
			WHERE gameID = $poker->gameID
			AND userID = ". USER_DECK . "
			LIMIT 1
		";
		$db->query_write($query);
	}
	
	function discard($cardID)
	{
		global $poker, $db;
		
		$query = "
			UPDATE gameroom_poker_dealt
			SET userID = " . USER_DISCARD . "
			WHERE gameID = $poker->gameID
			AND userID = $this->userID
			AND cardID = $cardID
			LIMIT 1
		";
		$db->query_write($query);
	}
	
	function raise()
	{
		
	}
	
	function check()
	{
		
	}
	
	function fold()
	{
		
	}
	
	function call()
	{
		
	}
	
	function bet()
	{
		
	}
}
?>