<?php

/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/
	function getTransferLog()
	{
		global $user, $settings, $db, $language;

		if (! $user->isAdmin)
			return false;
			
		$query = "
			SELECT * 
			FROM gameroom_donatelog
			ORDER BY dtime DESC
			LIMIT 100
		";
		$output = "<root>";
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			$from = htmlspecialchars($row['fromuser'], ENT_QUOTES);
			$to = htmlspecialchars($row['touser'], ENT_QUOTES);
			$amount = $row['amount'];
			$time = date("M j, Y g:i a", $row['dtime']);
			$output .= "<donate to='$to' from='$from' amount='$amount' date='$time' />";
		}
		$output .="</root>";
		return $output;
	}

	function transferCash()
	{
		global $user, $settings, $db, $language;

		if (! $settings->allowTransfers)
			return false;
			
		$giveto = addslashes($_GET['user']);	
		$amount = $_GET['amount'] * 1;	
	
		$result = $db->query_read("SELECT userid FROM " . $settings->userTable . " WHERE " . $settings->userNameField . "= '$giveto'");
		if ($row = $db->fetch_array($result))
			$toid = $row['userid'];
		else
			return "<root><status error='" . $language['common']['Invalid_Username'] . "' /></root>";
		
		if(($giveto) && ($amount))
		{	
			if(($amount > $user->cash)|| ($amount < 0))
				return "<root><status error='" . $language['common']['Not_Enough_Cash'] . " - $user->cash' /></root>";
			
			$user->record_cash(0, $amount, $toid);
			$user->record_cash(0, $amount * -1, $user->userID);
		
			$time = time();
			$db->query("INSERT INTO gameroom_donatelog (fromuser, touser, amount, dtime) VALUES ('" . $user->userName . "', '$giveto', $amount, $time)");
			return "<root><status error='' /></root>";
		}
	}
		
?>