<?php
/*
CREATE TABLE gameroom_settings (
id INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
arrayName VARCHAR(32),
setting VARCHAR(32),
value TEXT
);
 */
class gameRoomSettings
{
	var $chips = array();
	var $slots = array();
	var $blackjack = array();
	var $letItRide = array();
	var $videoPoker = array();
	var $roulette = array();
	var $bonuses = array();
	var $chess = array();
	var $reversi = array();
	var $fourInARow = array();
	var $checkers = array();
	
	var $useVB;
	var $userTable, $userIDField, $userNameField, $cashType;
	var $allowedUserTypes, $adminIDs, $modIDs;
	var $themeColor;
	var $usePrintOutput;
	var $userGroupTable, $userGroupIDField, $userGroupNameField;	
	
	var $useLobby;
	var $useSoloGames ;
	var $usePoker;
	var $useBoardGames;
	var $useBetting;
	var $useStats;
	var $logoPath;
	var $allowTransfers;
	var $defaultCash;
	
	var $utSoloGames, $utBetting, $utBoardGames, $utPoker;
	
	function gameRoomSettings()
	{
		global $db;
		include('gameroom/settings.php');
		$this->loadDBSettings();
	}

	function loadDBSettings()
	{
		global $db;
		$chipsCleared = false;
		
		$result = $db->query_read("
			SHOW COLUMNS 
			FROM $this->userTable
			LIKE 'gameroom_cash' 
		");
		$row = $db->fetch_array($result);
		$this->defaultCash = $row['Default'];
		
		$result = $db->query_read("
			SELECT *
			FROM gameroom_settings 
			ORDER BY id
		");
		while ($row = $db->fetch_array($result))
		{
			$arrayName = $row['arrayName'];
			$setting = $row['setting'];
			$value = $row['value'];
			
			if ($value == "true")
				$value = true;
			else if ($value == "false")
				$value = false;
				
			if ($setting == 'chipsUsed')
				$value = explode("," , $value);
			
			if (($setting == 'light_color') || ($setting == 'dark_color') || ($setting == 'themeColor'))
				$value = "0x" . dechex($value);
				
			if ($arrayName == 'bonuses')
				$this->bonuses[$setting] = $value;
			else if ($arrayName == 'chess')
				$this->chess[$setting] = $value;
			else if ($arrayName == 'checkers')
				$this->checkers[$setting] = $value;
			else if ($arrayName == 'reversi')
				$this->reversi[$setting] = $value;
			else if ($arrayName == 'fourInARow')
				$this->fourInARow[$setting] = $value;
			else if ($arrayName == 'slots')
				$this->slots[$setting] = $value;
			else if ($arrayName == 'videoPoker')
				$this->videoPoker[$setting] = $value;
			else if ($arrayName == 'roulette')
				$this->roulette[$setting] = $value;
			else if ($arrayName == 'letItRide')
				$this->letItRide[$setting] = $value;
			else if ($arrayName == 'blackjack')
				$this->blackjack[$setting] = $value;
			else if ($setting == 'themeColor')
				$this->themeColor = $value;
			else if ($setting == 'logoPath')
				$this->logoPath = $value;
			else if ($setting == 'cashType')
				$this->cashType = $value;
			else if ($setting == 'allowedUserTypes')
				$this->allowedUserTypes = explode(",", $value);
			else if ($setting == 'allowTransfers')
				$this->allowTransfers = $value;
			else if ($setting == 'adminIDs')
				$this->adminIDs = explode(",",$value);
			else if ($setting == 'modIDs')
				$this->modIDs = explode(",",$value);
			else if ($setting == 'useLobby')
				$this->useLobby = $value;
			else if ($setting == 'useSoloGames')
				$this->useSoloGames = $value;
			else if ($setting == 'usePoker')
				$this->usePoker = $value;
			else if ($setting == 'useBoardGames')
				$this->useBoardGames = $value;
			else if ($setting == 'useBetting')
				$this->useBetting = $value;
			else if ($setting == 'useStats')
				$this->useStats = $value;
			else if ($setting == 'utSoloGames')
				$this->utSoloGames = $value;
			else if ($setting == 'utPoker')
				$this->utPoker = $value;
			else if ($setting == 'utBetting')
				$this->utBetting = $value;
			else if ($setting == 'utBoardGames')
				$this->utBoardGames = $value;
				
			else if ($arrayName == 'chips')
			{
				if (! $chipsCleared)
				{
					$this->chips = array();
					$chipsCleared = true;
				}
				$this->chips[$setting] = $value;
			}
				
		}
		
	}
	
	function getAllowedTabs()
	{
		global $user, $db, $settings;
		
		$useSoloGames = "0";
		if ($settings->useSoloGames)
		{
			if ($settings->utSoloGames)
			{
				foreach (explode(",", $settings->utSoloGames) as $ut)
				if ($user->memberOf($ut))
				{
					$useSoloGames = "1";
				}
			}
			else
				$useSoloGames = "1";
		}

		$usePoker = "0";
		if ($settings->usePoker)
		{
			if ($settings->utPoker)
			{
				foreach (explode(",", $settings->utPoker) as $ut)
				if ($user->memberOf($ut))
				{
					$usePoker = "1";
				}
			}
			else
				$usePoker = "1";
		}

		$useBoardGames = "0";
		if ($settings->useBoardGames)
		{
			if ($settings->utBoardGames)
			{
				foreach (explode(",", $settings->utBoardGames) as $ut)
				if ($user->memberOf($ut))
				{
					$useBoardGames = "1";
				}
			}
			else
				$useBoardGames = "1";
		}
		
		$useBetting = "0";
		if ($settings->useBetting)
		{
			if ($settings->utBetting)
			{
				foreach (explode(",", $settings->utBetting) as $ut)
				if ($user->memberOf($ut))
				{
					$useBetting = "1";
				}
			}
			else
				$useBetting = "1";
		}
		
		
		$output = "
		useBetting='$useBetting' useLobby='$settings->useLobby' 
	useSoloGames='$useSoloGames' usePoker='$usePoker' useBoardGames='$useBoardGames'
	useStats='$settings->useStats'
		";
		return $output;
	}
	function getSettingsForEdit()
	{
		global $user, $db;
		 
		if ((isset($_GET['value'])) && ($user->isAdmin))
		{
			$setting = htmlspecialchars($_GET['setting'], ENT_QUOTES);
			$value = htmlspecialchars($_GET['value'], ENT_QUOTES);
			$arrayName = htmlspecialchars($_GET['arrayName'], ENT_QUOTES);

			// these can't be blank
			if ((($setting == 'adminIDs') || ($setting == 'modIDs')) && ($value == ''))
			{
				$this->loadDBSettings();
			}
			else if ($setting == 'defaultCash')
			{
				$query = "
					ALTER TABLE $this->userTable
					ALTER COLUMN gameroom_cash
					SET DEFAULT $value
				";
				$db->query_write($query);
				$this->loadDBSettings();
				
			}
			else
			{
				$query = "
					DELETE 
					FROM gameroom_settings
					WHERE arrayName = '$arrayName'
					AND setting = '$setting'
				";
				$db->query_write($query);
				
				$query = "
					INSERT INTO gameroom_settings
						(setting, arrayName, value)
					VALUES
						('$setting', '$arrayName', '$value') 
				";
				$db->query_write($query);
				$this->loadDBSettings();
			}	
		}
		else if (isset($_GET['clear']))
		{
			$db->query_write("DELETE FROM gameroom_settings");
			$db->query_write("INSERT INTO gameroom_settings (setting, arrayName, value) VALUES ('adminIDs', '', $user->userID)");
			$db->query_write("INSERT INTO gameroom_settings (setting, arrayName, value) VALUES ('modIDs', '', $user->userID)");
			include('gameroom/settings.php');
			$this->loadDBSettings();
		}
		else if (isset($_GET['saveChips']))
		{
			$db->query_write("DELETE FROM gameroom_settings WHERE arrayName = 'chips'");
			for ($i=1; $i < 11; $i++)
			{
				if ($i < 10)
					$i2 = "0" . $i;
				else
					$i2 = $i;
				$val = "chip" . $i2 . "v";
				$img = "chip" . $i2 . "image";
				$chipValue = $_GET[$val];
				$chipImage = $_GET[$img];
				$query = "
					INSERT INTO gameroom_settings
						(setting, value, arrayName)
					VALUES
						('$chipValue', '$chipImage', 'chips')
				";
				$db->query_write($query);
			}
			$this->loadDBSettings();
		}
		$output = "<root>\n";
		$output.= "<allowedUserTypes value='" . implode(",", $this->allowedUserTypes) . "' />";
		$output.= "<adminIDs value='" . implode(",", $this->adminIDs) . "' />";
		$output.= "<modIDs value='" . implode(",", $this->modIDs) . "' />";
		$output.= "<themeColor value='$this->themeColor' />";
		$output.= "<logoPath value='$this->logoPath' />";
		$output.= "<allowTransfers value='$this->allowTransfers' />";
		$output.= "<cashType value='$this->cashType' />";

		$output.= "<useLobby value='$this->useLobby' />";
		$output.= "<useSoloGames value='$this->useSoloGames' />";
		$output.= "<usePoker value='$this->usePoker' />";
		$output.= "<useBoardGames value='$this->useBoardGames' />";
		$output.= "<useBetting value='$this->useBetting' />";
		$output.= "<useStats value='$this->useStats' />";
		$output.= "<defaultCash value='$this->defaultCash' />";
		
		$output.= "<utBetting value='$this->utBetting' />";
		$output.= "<utBoardGames value='$this->utBoardGames' />";
		$output.= "<utPoker value='$this->utPoker' />";
		$output.= "<utSoloGames value='$this->utSoloGames' />";
		
		$output.= "<bonuses ";
		foreach ($this->bonuses as $key => $value)
			$output .= "$key='$value' ";
		$output .= " />";
		
		$i = 0;
		foreach ($this->chips as $key => $value)
		{
			$output .= "<chip value='$key' image='$value' />";
			$i++;
		}
		for ($i = $i; $i < 10; $i++)
			$output .= "<chip value='' image='' />";
			
		$output .= "<slots chips='" . implode(",", $this->slots['chipsUsed']) . "' />";
		$output .= "<videoPoker chips='" . implode(",", $this->videoPoker['chipsUsed']) . "' />";
		$output .= "<blackjack chips='" . implode(",", $this->blackjack['chipsUsed']) . "' tableLimit='" . $this->blackjack['tableLimit'] . "' />";
		$output .= "<letitride chips='" . implode(",", $this->letItRide['chipsUsed']) . "' tableLimit='" . $this->letItRide['tableLimit'] . "' />";
		$output .= "<roulette chips='" . implode(",", $this->roulette['chipsUsed']) . "' tableLimit='" . $this->roulette['tableLimit'] . "' />";

		$output .= "<chess lightColor='" . $this->chess['light_color'] . "' darkColor='" . $this->chess['dark_color'] . "' />";
		$output .= "<reversi lightColor='" . $this->reversi['light_color'] . "' darkColor='" . $this->reversi['dark_color'] . "' />";
		$output .= "<fourInARow lightColor='" . $this->fourInARow['light_color'] . "' darkColor='" . $this->fourInARow['dark_color'] . "' />";
		$output .= "<checkers lightColor='" . $this->checkers['light_color'] . "' darkColor='" . $this->checkers['dark_color'] . "' />";
		
		$output .= "</root>";
		return $output;
	}
}
?>