<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

function loadLanguage()
{
	global $language, $user, $settings, $db;

	$query = "
		SELECT * 
		FROM gameroom_language
	";
	
	$result = $db->query_read($query);
	while ($row = $db->fetch_array($result))
	{
		$group = $row['languageGroup'];
		$name = $row['languageName'];
		$language[$group][$name] = $row['phrase'];
	}
	
}

function getLanguage()
{
	global $language, $user, $settings, $db;


	
	$useableTabs = $settings->getAllowedTabs();
	
	$output = "<root>\n";
	$output .= "<status logoPath='$settings->logoPath' allowTransfers='$settings->allowTransfers' 
	userID='$user->userID' userName='$user->userName' themeColor='$settings->themeColor' 
	admin='$user->isAdmin' $useableTabs />";
	$output .= "<language>\n";
		
	foreach ($language AS $group => $phrases)
	{
		$output .= "<$group ";
		foreach ($phrases as $key => $phrase)
		{
			$output .= "$key='$phrase' ";
		}
		$output .= "/>\n";
	}

	$output .= "</language>\n</root>";
	return $output;
	
}


function getLanguageEdit()
{
	global $language, $user, $settings, $db;

	$query = "
		SELECT * 
		FROM gameroom_language
	";
	
	$languageNew = $language;
	include ("gameroom/language.php");
	/*
	$result = $db->query_read($query);
	while ($row = $db->fetch_array($result))
	{
		$group = $row['languageGroup'];
		$name = $row['languageName'];
		if (! isset ($languageNew[$group]))
			$languageNew[$group] =  array();
		
		$languageNew[$group][$name] = $row['phrase'];
	}
*/
	
	$output = "<root>\n";
	$output .= "<status userID='$user->userID' userName='$user->userName' themeColor='$settings->themeColor' admin='$user->isAdmin' />";
		
	foreach ($language AS $group => $phrases)
	{
		foreach ($phrases as $key => $phrase)
		{
			if (isset($languageNew[$group][$key]))
				$newPhrase = $languageNew[$group][$key];
			else 
				$newPhrase = "";
			
			if ((! strpos($key, "_Text")) && ((! strpos($key, "_Rules"))))
				$output .= "<language group='$group' name='$key' phrase='$phrase' newPhrase='$newPhrase'  />\n";
		}
	}

	$output .= "</root>";
	return $output;
	
}

function saveLanguage()
{
	global $user, $db, $settings;
	
	if(!$user->isAdmin) 
		exit();
	
	$group = $_GET['group'];
	$name = $_GET['name'];
	$phrase = htmlspecialchars($_GET['newPhrase'], ENT_QUOTES);

	$query = "DELETE FROM gameroom_language WHERE languageGroup = '$group' and languageName='$name'";
	$db->query_write($query);
	if (strlen($phrase) > 0)
	{
		$query = "INSERT INTO gameroom_language (languageGroup, languageName, phrase) VALUES ('$group', '$name', '$phrase')";
		$db->query_write($query);
	}
	return "<root><done /></root>";
}

function exportLanguage()
{
	global $user, $db, $settings;
	
	if(!$user->isAdmin) 
		exit();

			$query = "
		SELECT * 
		FROM gameroom_language
	";
	$date = date("Y-m-d");
	$contents = "<?php
/*********************************************************************************
 * Gameroom Language File
 * vbgaming.org
 *
 * Generated by " . $user->userName . " on " . $date . "
 *
 * To import this language file upload the file to your forums main folder
 * and navigate to it.  Once completed you can remove the file from your 
 * server.
 *
 * WARNING: Importing a language file will overwrite any exiting language
 * modifications you have made.
 *
 *********************************************************************************/
	 
require(\"./global.php\");

\$db->query_write(\"DELETE FROM gameroom_language\");
";
	$result = $db->query_read($query);
	while ($row = $db->fetch_array($result))
	{
		$group = $row['languageGroup'];
		$name = $row['languageName'];
		$phrase = $row['phrase'];
		$contents .=  "\$db->query_write(\"INSERT INTO gameroom_language (languageGroup, languageName, phrase) VALUES ('$group', '$name', '$phrase')\");\n";
	}
	$contents .= "\n\necho \"Import completed, you may now delete this file from your server.\";\n\n";
	$contents .= "?>";
	
	header("Content-Disposition: attachment; filename=\"importLanguage.php\"");
	echo $contents;
	
}
?>