<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

class stats
{
	function getStats()
	{
		if ($_GET['req']=='toppercent')
			return $this->getTopPercent();
		else if ($_GET['req']=='topprofit')
			return $this->getTopProfit();
		else if ($_GET['req']=='richest')
			return $this->richestPlayers();
		else if ($_GET['req']=='chessranks')
			return $this->topBoardGame(1);
		else if ($_GET['req']=='mybetting')
			return $this->myBetting();
		else if ($_GET['req']=='gamepayouts')
			return $this->gamePayouts();
		else if ($_GET['req']=='reversiranks')
			return $this->topBoardGame(2);
		else if ($_GET['req']=='toppoker')
			return $this->getTopProfit(1);
		else if ($_GET['req']=='fourinarowranks')
			return $this->topBoardGame(3);
		else if ($_GET['req']=='checkersranks')
			return $this->topBoardGame(4);
		else if ($_GET['req']=='pokertournaments')
			return $this->pokerTournaments();
	}
	
	
	function topBoardGame($gameType)
	{
		global $db, $settings;
		
		$query = "
			SELECT " . $settings->userTable . "." . $settings->userNameField . ", gameroom_rank.rank, gameroom_rank.wins, gameroom_rank.loses, gameroom_rank.draws, userName
			FROM " . $settings->userTable . "
			LEFT JOIN gameroom_rank ON gameroom_rank.userID = " . $settings->userTable . ".userID
			WHERE rank IS NOT NULL
			AND gameType = $gameType
			ORDER BY rank DESC
			LIMIT 100
		";
		$result = $db->query_read($query);
		$xml = "<root>";
		while ($row = $db->fetch_array($result))
		{
			$userName = htmlspecialchars($row['userName'], ENT_QUOTES);
			$rank = $row['rank'];
			$wins = $row['wins'];
			$loses = $row['loses'];
			$draws = $row['draws'];
			$gamesPlayed = $wins + $loses + $draws;
			
			$xml .= "<stats name='$userName' rank='$rank' wins='$wins' loses='$loses' draws='$draws' gamesPlayed='$gamesPlayed' />";
		}
		$xml .= "</root>";
		return $xml;
	}
	
	
	function richestPlayers()
	{
		global $db, $settings;
		
		$result = $db->query_read("
			SELECT " .$settings->userTable . "." .$settings->userIDField . " AS userID, " .$settings->userTable . "." . $settings->userNameField . " AS userName, " .$settings->userTable . "." .$settings->cashType . " AS cash 
			FROM " .$settings->userTable . "
			ORDER BY " .$settings->cashType . " DESC
			LIMIT 100
		");
		$xml = "<root>";
		while ($row = $db->fetch_array($result))
		{
			$userName = htmlspecialchars($row['userName'], ENT_QUOTES);
			$cash = $row['cash'];
			$xml .= "<stats name='$userName' cash='$cash' />";
		}
		$xml .= "</root>";
		return $xml;
	}
	
	function getTopProfit( $pokerOnly = false)
	{
		global $db, $settings;
		
		if ($pokerOnly)
			$pokerOnly = "AND gameID IN (" . GAMEID_POKER_TEXAS . ", " . GAMEID_POKER_7CARD .")";
		else
			$pokerOnly = "";
			
		$query = "
			SELECT " .$settings->userTable . "." .$settings->userIDField . " AS userID, 
			" .$settings->userTable . "." . $settings->userNameField . " AS userName,
			SUM(gameroom_bet_stats.bet) AS bet, SUM(gameroom_bet_stats.won) AS won, 
			SUM(gameroom_bet_stats.won) + SUM(gameroom_bet_stats.bet) AS profit 
			FROM " .$settings->userTable . ", gameroom_bet_stats 
			WHERE " .$settings->userTable . "." .$settings->userIDField . " = gameroom_bet_stats.userID 
			AND bet <> 0
			$pokerOnly
			GROUP BY gameroom_bet_stats.userid
			ORDER BY profit DESC
			LIMIT 100		
		";
		
		$result = $db->query_read($query);
		$xml = "<root>";
		while ($row = $db->fetch_array($result))
		{
			$userName = htmlspecialchars($row['userName'], ENT_QUOTES);
			$bet = $row['bet'];
			$won = $row['won'];
			$profit = $row['profit'];
			
			$xml .= "<stats name='$userName' bet='$bet' won='$won' profit='$profit' />";
		}
		$xml .= "</root>";
		return $xml;
		
	}
	
	
	function getTopPercent()
	{
		global $db, $settings;
		
		$query = "
			SELECT " .$settings->userTable . "." .$settings->userIDField . " AS userID, 
			" .$settings->userTable . "." . $settings->userNameField . " AS userName,
			SUM(gameroom_bet_stats.bet) AS bet, SUM(gameroom_bet_stats.won) AS won, 
			ROUND(SUM(gameroom_bet_stats.won) / ABS(SUM(gameroom_bet_stats.bet)) * 100) AS percent			 
			FROM " .$settings->userTable . ", gameroom_bet_stats 
			WHERE " .$settings->userTable . "." .$settings->userIDField . " = gameroom_bet_stats.userid 
			AND bet <> 0
			GROUP BY gameroom_bet_stats.userid
			ORDER BY percent DESC
			LIMIT 100
		";	
		
		$result = $db->query_read($query);
		$xml = "<root>";
		while ($row = $db->fetch_array($result))
		{
			$userName = htmlspecialchars($row['userName'], ENT_QUOTES);
			$bet = $row['bet'];
			$won = $row['won'];
			$percent = $row['percent'];
			
			$xml .= "<stats name='$userName' bet='$bet' won='$won' percent='$percent%' />";
		}
		$xml .= "</root>";
		return $xml;	
	}
	
	
	function myBetting()
	{
		global $db, $settings, $user, $language;
		
		$query = "
			SELECT gameID, SUM(gameroom_bet_stats.bet) AS bet, SUM(gameroom_bet_stats.won) AS won 
			FROM  gameroom_bet_stats 
			WHERE gameroom_bet_stats.userid = $user->userID
			GROUP BY userID, gameID
		";	
		
		$result = $db->query_read($query);
		$xml = "<root>";
		while ($row = $db->fetch_array($result))
		{
			$gameID = $row['gameID'];
			$bet = abs($row['bet']);
			$won = $row['won'];
			$profit = $won - $bet;
			if ($bet)
				$percent = round(($won / abs($bet)*100));
			else
				$percent = 0;
			
				if ($gameID == GAMEID_BARS_AND_SEVENS)
					$gameName = $language['slots']['Bars_And_Sevens'];
				else if ($gameID == GAMEID_BLACKJACK)
					$gameName = $language['blackjack']['Blackjack'];
				else if ($gameID == GAMEID_FRUIT_MACHINE)
					$gameName = $language['slots']['Fruit_Machine'];
				else if ($gameID == GAMEID_LET_IT_RIDE)
					$gameName = $language['letitride']['Let_It_Ride'];
				else if ($gameID == GAMEID_NINJA_SLOTS)
					$gameName = $language['slots']['Ninja_Slots'];
				else if ($gameID == GAMEID_POKER_TEXAS)
					$gameName = $language['poker']['Texas_Holdem'];
				else if ($gameID == GAMEID_POKER_7CARD)
					$gameName = $language['poker']['Seven_Card_Stud'];
				else if ($gameID == GAMEID_ROULETTE)
					$gameName = $language['roulette']['Roulette'];
				else if ($gameID == GAMEID_SPORTS_BETTING)
					$gameName = $language['sportsPool']['Betting_Pool'];
				else if ($gameID == GAMEID_VIDEO_POKER)
					$gameName = $language['poker']['Video_Poker'];
				else
					$gameName = "";
				
				if ($gameName != "")
					$xml .= "<stats gameID='$gameID' gameName='$gameName' bet='$bet' won='$won' percent='$percent' profit='$profit' />";
		}
		$xml .= "</root>";
		return $xml;	
	}

	function gamePayouts()
	{
		global $db, $settings, $user, $language;
		
		$query = "
			SELECT gameID, SUM(gameroom_bet_stats.bet) AS bet, SUM(gameroom_bet_stats.won) AS won 
			FROM  gameroom_bet_stats 
			WHERE gameroom_bet_stats.gameID NOT IN (" . GAMEID_POKER_TEXAS .", " . GAMEID_POKER_7CARD .")
			GROUP BY gameroom_bet_stats.gameID
		";	
		
		$result = $db->query_read($query);
		$xml = "<root>";
		while ($row = $db->fetch_array($result))
		{
			$gameID = $row['gameID'];
			$bet = abs($row['bet']);
			$won = $row['won'];
			$profit = $won - $bet;
			if ($bet)
				$percent = round(($won / abs($bet)*100));
			else
				$percent = 0;
			
				if ($gameID == GAMEID_BARS_AND_SEVENS)
					$gameName = $language['slots']['Bars_And_Sevens'];
				else if ($gameID == GAMEID_BLACKJACK)
					$gameName = $language['blackjack']['Blackjack'];
				else if ($gameID == GAMEID_FRUIT_MACHINE)
					$gameName = $language['slots']['Fruit_Machine'];
				else if ($gameID == GAMEID_LET_IT_RIDE)
					$gameName = $language['letitride']['Let_It_Ride'];
				else if ($gameID == GAMEID_NINJA_SLOTS)
					$gameName = $language['slots']['Ninja_Slots'];
				else if ($gameID == GAMEID_POKER_TEXAS)
					$gameName = $language['poker']['Texas_Holdem'];
				else if ($gameID == GAMEID_POKER_7CARD)
					$gameName = $language['poker']['Seven_Card_Stud'];
				else if ($gameID == GAMEID_ROULETTE)
					$gameName = $language['roulette']['Roulette'];
				else if ($gameID == GAMEID_SPORTS_BETTING)
					$gameName = $language['sportsPool']['Betting_Pool'];
				else if ($gameID == GAMEID_VIDEO_POKER)
					$gameName = $language['poker']['Video_Poker'];
				else
					$gameName = "";
				
				if ($gameName != "")
					
				$xml .= "<stats gameID='$gameID' gameName='$gameName' bet='$bet' won='$won' percent='$percent' profit='$profit' />";
		}
		$xml .= "</root>";
		return $xml;	
	}	

	function pokerTournaments()
	{
		global $db, $settings, $user, $language;
		
		$startTime = time() - (60 * 60 * 24 * 90);
		$query = "
			SELECT gameroom_poker_game.startTime, gameroom_poker_results.position, gameroom_poker_game.name,
				" . $settings->userTable . "." . $settings->userNameField . " AS userName, gameroom_poker_results.amount,
				gameroom_poker_game.gameID
			FROM gameroom_poker_results
			LEFT JOIN $settings->userTable ON " . $settings->userTable . "." . $settings->userIDField . "= gameroom_poker_results.userID
			LEFT JOIN gameroom_poker_game ON  gameroom_poker_results.gameID = gameroom_poker_game.gameID
			WHERE gameroom_poker_game.startTime > $startTime
			ORDER BY gameroom_poker_game.startTime DESC, gameroom_poker_results.position
		";
		$result = $db->query_read($query);
		$xml = "<root>";
		$titleList = array();
		$lastGameID = 0;
		while ($row = $db->fetch_array($result))
		{
			$name = base64_decode($row['name']);
			$userName = htmlspecialchars($row['userName'], ENT_QUOTES);
			$position = $row['position'];
			$amount = $row['amount'];
			$gameID = $row['gameID'];
			$date = date("F j, Y", $row['startTime']);
			$i = 1;
			if ($gameID != $lastGameID)
			{
				$lastGameID = $gameID;
				$title = "$date - $name";
				while (in_array($title, $titleList))
				{
					$i++;
					$title = "$date - $name ($i)";
				}
				$titleList[] = $title;
			}
			$xml .= "<stats gameID='$gameID' title='$title' name='$name' date='$date' userName='$position - $userName' position='$position' amount='$amount' />";
		}
		$xml .= "</root>";
		return $xml;
	}
}
?>