<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/
//chdir ("../vbgaming");
require("./global.php");
//chdir ("../gameroom");
	
	class userInfo
	{
		var $userID, $userName, $cash, $userIDField, $userTable, $userNameField, $cashType, $isAdmin;
		
		function getAvatars($userIDs)
		{
			global $db, $settings;
			$avatarArray = array();
			
			if (! $settings->useVB)
				return $avatarArray;
				
			$query = "
				SELECT " .$settings->userTable . ".userID, avatarPath, " . TABLE_PREFIX . "customavatar.userID AS avatarID, " . TABLE_PREFIX . "customavatar.dateline
				FROM " .$settings->userTable . "
				LEFT JOIN " . TABLE_PREFIX . "avatar ON " . TABLE_PREFIX . "user.avatarID = " . TABLE_PREFIX . "avatar.avatarID
				LEFT JOIN " . TABLE_PREFIX . "customavatar ON " . TABLE_PREFIX . "user.userID = " . TABLE_PREFIX . "customavatar.userID
				WHERE " . TABLE_PREFIX . "user.userID IN ($userIDs)
			";
			$result = $db->query_read($query);
			
			while ($row = $db->fetch_array($result))
			{
				$userID = $row['userID'];
				$avatarPath = $row['avatarPath'];
				$avatarID = $row['avatarID'];
				
				if($avatarID > 0)
				{
					$path = "image.php?u=" . $avatarID . "&amp;dateline=" . $row['dateline'];
				}
				else if (strlen($avatarPath) > 0)
				{
					$path = $avatarPath;
				}
				else
				{
					$path = "";
				}
				$avatarArray[$userID] = $path;
			}
			return $avatarArray;
		}
		
		function memberOf($ut)
		{
			global $vbulletin;
			if (is_member_of($vbulletin->userinfo, $ut))
				return true;
			else
				return false;
			
		}
		function user_info()
		{
			global $db, $settings;
			
			if ($settings->useVB)
			{
				global $vbulletin;
				$this->userName = htmlspecialchars($vbulletin->userinfo['username'], ENT_QUOTES); 
				$this->userID = $vbulletin->userinfo['userid'];

				if (in_array($this->userID, $settings->adminIDs))
					$this->isAdmin = 1;
				else 
					$this->isAdmin = 0;
				
				foreach ($settings->allowedUserTypes as $au) 
					if (is_member_of($vbulletin->userinfo, $au))
					{
						$allowedin = 1;
					}
				
				if(! $allowedin)
					notLoggedIn();		
				
			}
			

			
			$getuserinfo = $db->query_read("
				SELECT $settings->cashType
				FROM  $settings->userTable
				WHERE userid = $this->userID
			");
				
	
			$userinfo = $db->fetch_array($getuserinfo);
			$this->cash = floor($userinfo[$settings->cashType]); 
		}	
		
		function record_cash($gameID, $amount, $userID = -1)
		{
			global $db, $settings, $user;
			if ($userID == -1)
				$this->cash = $this->cash + $amount;

			if($userID == -1)
				$userID = $this->userID;
			
				$query = "
					SELECT $settings->cashType AS cash
					FROM $settings->userTable 
					WHERE userid = $userID
				";
				$result = $db->query_read($query);
				$row = $db->fetch_array($result);
				$cash = $row['cash'];
				
				$cash = $cash + $amount;
				if ($cash < 0)
				{
					$cash = 0;
					$amount = $cash * -1;
				}
			$db->query_write("
				UPDATE $settings->userTable 
				SET $settings->cashType = $settings->cashType + $amount
				WHERE userid = $userID
			");
				
			$this->checkBetStatsExist($userID, $gameID);
			if($amount < 0)
			{
				$db->query_write ("
					UPDATE gameroom_bet_stats
					SET bet = bet + $amount
					WHERE userid = $userID
					AND gameid = $gameID
					LIMIT 1
				");		
			}
			else 
			{
				$db->query_write ("
					UPDATE gameroom_bet_stats
					SET won = won + $amount
					WHERE userid = $userID
					AND gameid = $gameID
					LIMIT 1
				");

			}
			return $amount;
		}
		function checkBetStatsExist($userID, $gameID)
		{
			global $db, $settings, $user;
			
			$query = "
				SELECT COUNT(*) 
				FROM gameroom_bet_stats
				WHERE userID = $userID
				AND gameID = $gameID
			";
			$result = $db->query_read($query);
			if ($row = $db->fetch_array($result))
			{
				if ( $row[0] == 0)
				{
					$query = "INSERT INTO gameroom_bet_stats (gameID, userID, bet, won) VALUES ($gameID, $userID, 0, 0)";
					$db->query_write($query);
				}
			}
		}
	}

	class casinoGame
	{
		var $gameID, $tableLimit, $gameName, $chipsUsed, $permissions;
		var $cashType, $cash, $chipArray, $bet, $hand;
		var $chipsXML;
		var $language;
		var $gameCode;

		
		function initGame()
		{
			global $db;

			//$this->get_language();
			if ($this->chipsUsed)
			{
				$this->get_chips();
				$this->get_bet();
			}
		}
		
		function no_permissions()
		{
			print_no_permission();
			exit();
		}
		
		function get_chips()
		{
			global $settings, $user;
				
			$output = "";
			$i = 0;
			foreach ($this->chipsUsed as $chip)
			{
				if ($chip <= $user->cash)
				{
					$output .= "<chip id=\"$i\" alpha='1' value=\"$chip\" img=\"" . $settings->chips[$chip] . "\" />";
					$i++;
				}
			}
			$this->chipsXML = $output;
			
		}
		
		
		function get_bet()
		{
			global $user;
			
			if ((isset($_GET['bet']) && (is_numeric($_GET['bet']))))
			{
				if (in_array($_GET['bet'], $this->chipsUsed)) 
					$this->bet =  $_GET['bet'];
				else
				{
					$this->bet = 0;
				}
			}
			else
			{
				$this->bet = 0;
			}
			
			if ($this->bet > $user->cash)
			{
				$this->bet = 0;
			}
		}
		
		
		function evalCard($card)
		{
			global $language;
			
			$faceValue = $card % 13;
			$suit = floor($card/13);
			
			if($suit==0)
			{
				$cardfile = "gameroom/images/spades-"; 
				$cardname = $language['cards']['Spades']; 
			}
			else if($suit==1)
			{
				$cardfile = "gameroom/images/diamonds-";
				$cardname = $language['cards']['Diamonds']; 
			}
			else if($suit==2)
			{
				$cardfile = "gameroom/images/hearts-";
				$cardname = $language['cards']['Hearts'];
			}
			else if($suit==3)
			{
				$cardfile = "gameroom/images/clubs-";
				$cardname = $language['cards']['Clubs'];
			}
	
			if($faceValue+2<11)
			{
				$cardfile .= ($faceValue+2) . "-150.png";
				$cardname = ($faceValue+2) . $language['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==11)
			{
				$cardfile .= "j-150.png"; 
				$cardname = $language['cards']['Jack'] . $language['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==12)
			{
				$cardfile .= "q-150.png"; 
				$cardname = $language['cards']['Queen'] . $language['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==13)
			{
				$cardfile .= "k-150.png"; 
				$cardname = $language['cards']['King'] . $language['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==14)
			{
				$cardfile .= "a-150.png"; 
				$cardname = $language['cards']['Ace'] . $language['cards']['Of'] . $cardname; 
			}
			
			$output = array();
			$output['faceValue'] = $faceValue;
			$output['suit'] = $suit;
			$output['cardFile'] = $cardfile;
			$output['cardName'] = $cardname;
			
			return $output;
		}
		
		
	}

	

?>