<?php

/****************************************
 * 			General Settings			*
 ****************************************/

/*
 * VBulletin specific settings, do not alter
 */
$this->useVB = true;
$this->userTable = TABLE_PREFIX . "user";
$this->userIDField = "userid";
$this->userNameField = "username";
$this->userGroupTable = TABLE_PREFIX . "usergroup";
$this->userGroupIDField = "usergroupid";
$this->userGroupNameField = "title";


/*
 * Set this as a path to your logo in order to have it displayed in the lobby.
 * Leave it blank to not use this feature.
 */
$this->logoPath = "images/misc/logo.gif";
/*
 * Set this too false if you are using vbAdvanced or another plugin that manipulates the 
 * content after it is sent to vBulletin's print_output function.
 */

$this->usePrintOutput = false;

/*
 * Column in the user table which is used for cash in betting games
 */
$this->cashType = "gameroom_cash";

/*
 * Usertypes who are allowed access to the Gameroom
 */
$this->allowedUserTypes = array(2, 5, 6, 7);

/*
 * List of UserIDs who have special priveledges.
 * Admin users can 
 * 		- add / settle events in the sports pool
 * 		- use the cash adjuster
 * 		- edit language
 * Too add multiple users seperate by comma:
 * $this->adminIDs = array(1, 2, 3);
 *  
 */
$this->adminIDs = array(1);

/*
 * Set this to false if you want to dissallow users to transfer 
 * cash to other players.
 */
$this->allowTransfers = true;

/*
 * List of UserIDs who have special priveledges.
 * Mod users can 
 * 		- add / settle events in the sports pool
 * Too add multiple users seperate by comma:
 * $this->modIDs = array(1, 2, 3);
 *  
 */
$this->modIDs = array(1);

/*
 * Chips available and associated images.  Each game may use up to 5 denominations.
 * If you are going to alter the images they should be transparent .gif or .png files
 * First value is the chip denomination, second is the image file for the chip
 */
$this->chips = array(
	1 => "gameroom/images/chip-1.gif",
	5 => "gameroom/images/chip-5.gif",
	10 => "gameroom/images/chip-10.gif",
	25 => "gameroom/images/chip-25.gif",
	50 => "gameroom/images/chip-50.gif",
	100 => "gameroom/images/chip-100.gif",
	250 => "gameroom/images/chip-250.gif",
	500 => "gameroom/images/chip-500.gif",
	1000 => "gameroom/images/chip-1000.gif"	
);



/*
 * Theme color is a hex value, 4 sets of numbers.  First 2 shoulf be FF, followed by Red, Green and Blue
 * 0xFF{RR}{GG}{BB}
 * ex: (0xFF00A000 - Green)
 * 
 */
$this->themeColor = "0xFF6046FF";

/****************************************
 * 			Slots Settings				*
 ****************************************/

/*
 * Chips used in game, must match chips array in general settings
 * Maximum 5 values 
 */
$this->slots['chipsUsed'] = array(1, 5, 10, 25);


/****************************************
 * 		Video Poker Settings			*
 ****************************************/

/*
 * Chips used in game, must match chips array in general settings
 * Maximum 5 values 
 */
$this->videoPoker['chipsUsed'] = array(1, 5, 10, 25);

/****************************************
 * 		Blackjack Settings				*
 ****************************************/

/*
 * Chips used in game, must match chips array in general settings
 * Maximum 5 values 
 */
$this->blackjack['chipsUsed'] = array(1, 5, 10, 25);
/*
 * Maximum bet on a single hand 
 */
$this->blackjack['tableLimit'] = 100;


/****************************************
 * 		Let it Ride Settings			*
 ****************************************/

/*
 * Chips used in game, must match chips array in general settings
 * Maximum 5 values 
 */
$this->letItRide['chipsUsed'] = array(1, 5, 10, 25);
/*
 * Maximum bet on a single hand 
 */
$this->letItRide['tableLimit'] = 100;


/****************************************
 * 		Let it Ride Settings			*
 ****************************************/

/*
 * Chips used in game, must match chips array in general settings
 * Maximum 5 values 
 */
$this->roulette['chipsUsed'] = array(1, 5, 10, 25);
/*
 * Maximum bet on a single hand 
 */
$this->roulette['tableLimit'] = 100;


/****************************************
 * 		Cash Bonuses					*
 ****************************************/

/*
 * Bonus recieved for making a post
 */
$this->bonuses['post'] = 5;
/*
 * Bonus recieved for starting a thread
 */
$this->bonuses['thread'] = 5;
/*
 * Bonus recieved for voting on a poll
 */
$this->bonuses['vote'] = 2;
/*
 * Bonus recieved for giving rep
 */
$this->bonuses['giverep'] = 2;
/*
 * Bonus recieved for getting rep
 */
$this->bonuses['getrep'] = 3;
/*
 * Bonus recieved for rating a thread
 */
$this->bonuses['rate_thread'] = 1;
/*
 * Bonus recieved for visiting daily
 */
$this->bonuses['daily'] = 5;
/*
 * Bonus recieved for visiting daily
 */
$this->bonuses['referral'] = 20;



/****************************************
 * 		Chess Settings					*
 ****************************************/

/*
 * Board Color
 */

/*
 * Black and White Board
 */
//$this->chess['light_color'] = "0xE0E0E0";
//$this->chess['dark_color'] = "0xC0C0C0";

/*
 * Brown Board
 */
$this->chess['light_color'] = "0xFFCE9E";
$this->chess['dark_color'] = "0xD18B47";

$this->reversi['light_color'] = "0x60C060";
$this->reversi['dark_color'] = "0x40C040";

$this->fourInARow['light_color'] = "0x303030";
$this->fourInARow['dark_color'] = "0x404040";

/****************************************
 * 		Dissable Sections				*
 ****************************************/

/*
 * Set to false to dissable the module
 */

$this->useLobby = true;
$this->useSoloGames = true;
$this->usePoker = true;
$this->useBoardGames = true;
$this->useBetting = true;
$this->useStats = true;


?>