<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

define (TIMEOUT_MINOR, 15); // time out before game has started, or if game has started show warning
define (TIMEOUT_MAJOR, 30); // time out to disqualify after a game has started

// table rules
define("RULES_TEXASHOLDEM", 1);
define("RULES_5CARDDRAW", 2);
define("RULES_7CARDSTUD", 3);

// table betting structure
define("BETTING_FIXED", 1);
define("BETTING_SET", 2);
define("BETTING_NOLIMIT", 3);
define("BETTING_POT", 4);
define("BETTING_SPREAD", 5);

// userid of cards not belonging to a player
define("USER_DECK", 0);
define("USER_DISCARD", -1);
define("USER_COMMON", -2);

// userid of cards not belonging to a player
define("PLAYER_SITOUT", 0);
define("PLAYER_READY", 1);
define("PLAYER_INGAME", 2);
define("PLAYER_SHOWDOWN", 3);
define("PLAYER_FOLDED", 4);

require("gameroom/class_poker_hand.php");

class poker
{

	var $gameID, $gameType, $rules, $betting, $pot, $round, $dealerSeat, $whosTurn;
	var $turnTimeOut, $ante, $blinds, $maxRaises, $maxPlayers, $maxBet;
	var $betLimit, $useStake, $minStake, $maxStake, $stakeMultiplier;
	var $tournamentGame, $lockPlayers, $gameStarted, $lastRaise, $gameOver = false;
	
	var $canCheck = false, $canRaise = false, $canCall = false, $betSoFar, $topBet, $topRaise; 
	
	var $playerHands;
	
	var $minRaise, $maxRaise, $toCall;
	var $dealBtn, $inBox, $isTurn = 0, $seatID;
	
	var $xml, $playerXML, $gameStatusXML;
	
	var $numPlayers, $activePlayers;
	
	function init()
	{
		global $user, $db, $chatroom, $language;
		
		$this->dropInactivePlayers();
		
		$time = time();
		$this->gameID = $_GET['gameID'] * 1;
		$query = "
			SELECT * 
			FROM gameroom_poker_game
			WHERE gameID = $this->gameID
		";
		$result = $db->query_read($query);
		if($row = $db->fetch_array($result))
		{
			$this->blinds = $row['blinds'];
			$this->betLimit = $row['betLimit'];
			$this->ante = $row['ante'];
			$this->dealerSeat = $row['dealerSeat'];
			$this->whosTurn = $row['whosTurn'];
			$this->maxbet = $row['maxBet'];
			$this->round = $row['round'];
			$this->pot = $row['pot'];
			$this->rules = $row['rules'];
			$this->maxPlayers = $row['maxPlayers'];
			$this->maxStake = $row['maxStake'];
			$this->minStake = $row['minStake'];
			$this->maxRaises = $row['maRaises'];
			$this->useStake = $row['useStake'];
			$this->betting = $row['betting'];
			$this->lastRaise = $row['lastRaise'];
			$this->minRaise = $row['minRaise'];
			$this->topRaise = $row['minRaise'];
			$this->maxRaise = $row['maxRaise'];
			
			
			$dealerProblem = 1;
			$turnProblem = 1;
			$lastRaiseProblem = 1;
			
			if ($this->rules == RULES_TEXASHOLDEM)
			{
				$this->gameType = GAMEID_POKER_TEXAS;
			}
			if ($this->rules == RULES_7CARDSTUD)
			{
				$this->gameType = GAMEID_POKER_7CARD;
			}
			if(($this->rules == RULES_TEXASHOLDEM) && ($this->round == 5))
				$this->gameOver = true;
			if(($this->rules == RULES_7CARDSTUD) && ($this->round == 6))
				$this->gameOver = true;
				
			$chatroom->chatID = $row['chatID'];

			$query = "
				SELECT MAX(bet) AS topBet
				FROM gameroom_poker_players
				WHERE gameID = $this->gameID
			";
			$result = $db->query_read($query);
			$row = $db->fetch_array($result);
			
			if($row['topBet'])
				$this->topBet = $row['topBet'];
			else
				$this->topBet = 0;
				
			// Load users / Check if the player is in the game

			$query = "
				SELECT *
				FROM gameroom_poker_players
				WHERE gameID = $this->gameID
			";
			$result = $db->query_read($query);
			$this->numPlayers = 0;
			$inGame = 0;
			$this->activePlayers = 0;
			while ($row = $db->fetch_array($result))
			{
				$this->numPlayers++;
				if (($row['status'] != PLAYER_SITOUT) && ($row['status'] != PLAYER_FOLDED))
					$this->activePlayers++;
				if($user->userID == $row['userID'])
				{
					$inGame = 1;
					$this->betSoFar = $row['bet'];
					if($this->useStake =="1")
						$user->cash = $row['stake'];
					 if (($user->cash < 1) && ($this->round == 0))
					 	$db->query_write("UPDATE gameroom_poker_players SET status = 0 WHERE userID = $user->userID");
					 	
					$this->seatID = $row['seatID'];
				}
				if(($user->userID == $row['userID']) && ($row['seatID'] == $this->whosTurn))
					$this->isTurn = 1;
				if (($this->whosTurn == $row['seatID']) || ($this->round < 1))
					$turnProblem = 0;
				if ($this->dealerSeat == $row['seatID'])
					$dealerProblem = 0;
				if (($this->lastRaise == $row['seatID']) && ($row['status'] == PLAYER_INGAME))
					$lastRaiseProblem = 0;
					
			}
			
			if (($dealerProblem) && ($this->round == 0))
			{
				//echo "test";
				$this->endHand(true);
			}
			else if (($this->activePlayers == 1) && ($this->round > 0))
			{
				$this->endHand();
			}
			else if ($turnProblem)
			{
				$this->nextPlayer(false, $this->seatID);
			}
			if ($lastRaiseProblem)
			{
				$this->solveLastRaiseProblem();
			}
			
			else if(! $inGame)
				$this->joinGame();
			
			else if (($this->numPlayers == 1) && ($this->round > 0))
				$this->endHand();
				
			// Load player hands
			
			$query = "
				SELECT * 
				FROM gameroom_poker_dealt
				WHERE gameID = $this->gameID
			";
			$result = $db->query_read($query);
			$playerCards = array();
			while ($row = $db->fetch_array($result))
			{
				$uID = $row['userID'];
				if (($row['faceUp'] == 1) || ($this->gameOver == true))
					$playerCards[$uID][] = $row['cardID'] ;
				else
					$playerCards[$uID][] = $row['cardID'] * -1 ;
			}
			$this->playerHands = array();
			foreach ($playerCards as $key => $p)
			{
				$this->playerHands[$key] = new pokerHand;
				$this->playerHands[$key]->userID = $key;
				$cards = array();
				foreach ($p as $card)
					$cards[] = $card;
				$this->playerHands[$key]->loadHand($cards);
			}
			$query = "
				UPDATE gameroom_poker_players
				SET lastUpdate = $time
				WHERE gameID = $this->gameID
				AND userID = $user->userID
			";
			$db->query_write($query);
			
			if($this->isTurn)
			{
				$this->setMinMaxRaises();
				$this->setButtons();
			}
		}
		else
		{
			$this->xml = "<root><status error='" . $language['poker']['Game_No_Longer_Exists'] . "' /></root>";
		}
	}
	
	function doCommands()
	{
		if($_GET['command'] == "deal")
			$this->deal();	
	}
	
	function solveLastRaiseProblem()
	{
		global $db;
		
		$query = "
		UPDATE gameroom_poker_game
		SET lastRaise = (
			 SELECT seatid 
			 FROM gameroom_poker_players 
			 WHERE  gameid = $this->gameID 
			 AND status = " . PLAYER_INGAME . "
			 ORDER BY bet DESC, seatid DESC
			 LIMIT 1
		)
		WHERE gameID = $this->gameID
		 "; 
		$db->query_write($query);
		
	}
	
	function setButtons()
	{
		global $user;
		
		if($this->betSoFar == $this->topBet)
		{
			$this->canCall = false;
			$this->canCheck = true;
		}	
		else
		{
			$this->canCall = true;
			$this->canCheck = false;
		}	
		
		if ($user->cash > ($this->topBet - $this->betSoFar))
		{
			$this->canRaise = true;
			// set min / max allowed raises
		}
		else
			$this->canRaise = false;	
	}
	
	function sitInOut()
	{
		global $user, $db, $language;
		$query = "
			SELECT *
			FROM gameroom_poker_players
			WHERE gameID = $this->gameID
			AND userID = $user->userID
		";
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		if ($row['status'] != PLAYER_INGAME)
		{
		
			if($_GET['status'] == "false")
			{
				if (($this->dealerSeat == $this->seatID) && ($this->activePlayers > 1))
				{
					// Find a new dealer
					$query = "
						(
							SELECT seatID
							FROM gameroom_poker_players
							WHERE gameID = $this->gameID
							AND status NOT IN (" .  PLAYER_SITOUT . ")
							AND seatID > $this->seatID
							ORDER BY seatID
						)
						UNION
						(
							SELECT seatID
							FROM gameroom_poker_players
							WHERE gameID = $this->gameID
							AND status NOT IN (" .  PLAYER_SITOUT . ")
							AND seatID < $this->seatID
							ORDER BY seatID
						)
					";
					$result = $db->query_read($query);
					
					if($row = $db->fetch_array($result))
					{
						$query = "
							UPDATE gameroom_poker_game
							SET dealerSeat = " . $row['seatID'] . "
							WHERE gameID = $this->gameID
						";
						$db->query_write($query);
						
					}
				}
				$query = "
					UPDATE gameroom_poker_players
					SET status = 0
					WHERE gameID = $this->gameID
					AND userID = $user->userID
				";
				$db->query_write($query);
				$this->xml = "<root><status error='' /></root>";
			}
			else if($_GET['status'] == "true")
			{
				if($this->activePlayers == 0)
				{
					$query = "
						UPDATE gameroom_poker_game
						SET dealerSeat = " . $this->seatID . "
						WHERE gameID = $this->gameID
					";
					$db->query_write($query);
				}
				$query = "
					UPDATE gameroom_poker_players
					SET status = 1
					WHERE gameID = $this->gameID
					AND userID = $user->userID
				";
				$db->query_write($query);
				$this->xml = "<root><status error='$query' /></root>";
			}
		}
		else
		{
			$this->xml = "<root><status error='" . $language['poker']['Game_Started'] . "' /></root>";
			
		}
	}
	
	function setMinMaxRaises()
	{
		global $user;
		
		$this->toCall = $this->topBet - $this->betSoFar;
		if ($this->toCall < 0)
			$this->toCall = 0;
		
		if($this->toCall > $user->cash)
			$this->toCall = $user->cash;
			
		if($this->rules == RULES_TEXASHOLDEM)
		{
			if($this->betting == BETTING_NOLIMIT)
			{
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;
				
				$this->maxRaise = $user->cash - $this->toCall;
				
				if($this->maxRaise < $this->minRaise)
					$this->maxRaise = $this->minRaise;
			}
			if($this->betting == BETTING_SPREAD)
			{
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;

				if($this->round > 2)
					$this->maxRaise = $this->maxRaise * 2;
					
					if ($this->maxRaise > $user->cash)
						$this->maxRaise = $user->cash;
			}
			else if($this->betting == BETTING_FIXED)
			{
				if($this->round < 3)
					$this->minRaise = $this->blinds * 2;
				else
					$this->minRaise = $this->blinds * 4;
					
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;
				
				
				$this->maxRaise = $this->minRaise;
					
			}
			else if($this->betting == BETTING_POT)
			{
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;
				
				$this->maxRaise = $this->pot + $this->toCall;
				
				if($this->maxRaise > $user->cash)
					$this->maxRaise = $user->cash;
				
			}
		}
		else if($this->rules == RULES_7CARDSTUD)
		{
			if($this->betting == BETTING_NOLIMIT)
			{
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;
				
				$this->maxRaise = $user->cash - $this->toCall;
				
				if($this->maxRaise < $this->minRaise)
					$this->maxRaise = $this->minRaise;
			}
			if($this->betting == BETTING_SPREAD)
			{
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;
				
				if($this->round > 3)
					$this->maxRaise = $this->maxRaise * 2;
					
					if ($this->maxRaise > $user->cash)
						$this->maxRaise = $user->cash;
			}
			else if($this->betting == BETTING_FIXED)
			{
				if($this->round < 3)
					$this->minRaise = $this->ante * 2;
				else
					$this->minRaise = $this->ante * 4;
					
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;
				
				
				$this->maxRaise = $this->minRaise;
					
			}
			else if($this->betting == BETTING_POT)
			{
				if(($user->cash - $this->toCall) < $this->minRaise)
					$this->minRaise = $user->cash;
				
				$this->maxRaise = $this->pot + $this->toCall;
				
				if($this->maxRaise > $user->cash)
					$this->maxRaise = $user->cash;
				
			}
			
		}
			//			if($row['maxRaises'] > 0)
		
	}
	function getStatusXML()
	{
		global $db, $user, $chatroom;
		
		$hand = new pokerHand;
		
		if ($this->rules == RULES_TEXASHOLDEM)
		{
			if (($this->activePlayers < 2) || (($this->round > 0) && ($this->round < 5)))
			{
				$this->dealBtn = 'false';
			}
		}
		else if ($this->rules == RULES_7CARDSTUD)
		{
			if (($this->activePlayers < 2) || (($this->round > 0) && ($this->round < 6)))
			{
				$this->dealBtn = 'false';
			}
		}

		if ($user->cash == 0)
			$this->inBox = 0;
		$this->gameStatusXML = "<common useStake='$this->useStake' numPlayers='$this->numPlayers' activePlayers='$this->activePlayers' pot='$this->pot' 
								dealBtn='$this->dealBtn' inBox='$this->inBox' round='$this->round' isTurn='$this->isTurn' 
								cash='$user->cash' canRaise='$this->canRaise' canCall='$this->canCall' canCheck='$this->canCheck'
								minRaise='$this->minRaise' maxRaise='$this->maxRaise' toCall='$this->toCall' rules='$this->rules'>";
		
		if($this->round == 2)
			$cardsDrawn = 3;
		else if($this->round == 3)
			$cardsDrawn = 4;
		else if(($this->round == 4) || ($this->round == 5))
			$cardsDrawn = 5;
		else
			$cardsDrawn = 0;
			
		$query = "
			SELECT * 
			FROM gameroom_poker_dealt
			WHERE gameID = $this->gameID
			AND userID = 0
			ORDER BY ID
			LIMIT $cardsDrawn
		";
		$i = 0;
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			$cardID = $row['cardID'];
			$handInfo = $hand->evalCard($cardID);
			$this->gameStatusXML .= "<card id='" . $cardID . "' name='" . $handInfo['cardName'] . "' img='" . $handInfo['cardFile'] . "'/>\n";
			$i++;
		}
		
		for($i = $i; $i < 5; $i++)
			$this->gameStatusXML .= "<card id='' name='' img='gameroom/images/back-blue-150-1.png'/>\n";
			
		$this->gameStatusXML .= "</common>";
		
	}
	
	
	function createGame()
	{
	//req=startgame&rules=1&name=test&blinds=5&maxPlayers=10&maxRaises=0&useStake=1&stake=10&stakeMult=1&password=	
		global $db, $user, $chatroom, $language;
		
		
		$rules = $_GET['rules'] * 1;
		$betting = $_GET['betting'] * 1;
		$name = base64_encode(htmlspecialchars($_GET['name'], ENT_QUOTES));
		$blinds = $_GET['blinds'] * 1;
		$maxPlayers = $_GET['maxPlayers'] * 1;
		$maxRaises = $_GET['maxRaises'] * 1;
		$useStake = $_GET['useStake'] * 1;
		$stake = $_GET['stake'] * 1;
		$stakeMult = $_GET['stakeMult'] * 1;
		$ante = $_GET['ante'] * 1;
		$password = base64_encode($_GET['password']);

		if ($rules == RULES_TEXASHOLDEM)
			$chairs = 10;
		else
			$chairs = 6;
		
		$playerSeat = rand()%$chairs + 1;
		
		
		$query = "
			INSERT INTO gameroom_chat
			 	(name)
			 VALUES
			 	('$name')
		";
		$db->query_write($query);

		
		$query = "
			INSERT INTO gameroom_poker_game
			 	(name, chatID, password, rules, betting, blinds, maxRaises, maxPlayers, useStake, maxStake, stakeMultiplier, dealerSeat, pot, ante)
			 VALUES
			 	('$name', (SELECT MAX(chatID) FROM gameroom_chat WHERE name = '$name'), '$password', '$rules', '$betting', '$blinds', '$maxRaises', '$maxPlayers', '$useStake', '$stake', '$stakeMult', '$playerSeat', 0, '$ante')
		";
		$db->query_write($query);
		
		$query = "
			SELECT gameID, chatID
			FROM gameroom_poker_game
			WHERE name = '$name'
			ORDER BY gameID DESC
			LIMIT 1
		";
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		
		$this->gameID = $row['gameID'];
		$chatroom->chatID = $row['chatID'];
		
		$time = time();
		
		$userStake = $stake;
		if ($user->cash < $userStake)
			$userStake = $user->cash;
			
		if($useStake)
			$userStake = $userStake * $stakeMult;
		else
			$userStake = 0;
		
		if ($rules == RULES_TEXASHOLDEM)
		{
			$gameType = GAMEID_POKER_TEXAS;
		}
		if ($rules == RULES_7CARDSTUD)
		{
			$gameType = GAMEID_POKER_7CARD;
		}	
		$user->record_cash($gameType, ($userStake / $stakeMult) * -1, $user->userID);
		
		$query = "
			INSERT INTO gameroom_poker_players
				(gameID, userID, stake, seatID, lastUpdate, bet)
			VALUES
				($this->gameID, $user->userID, $userStake, $playerSeat, $time, 0)
		";
				
		$db->query_write($query);
		$this->xml = "<root><status gameID='$this->gameID' chatID='$chatroom->chatID'  rules='$rules' error='' /></root>";
	}
	
	function getPlayersXML()
	{
		global $db, $user, $settings;
		
		$query ="
			SELECT gameroom_poker_players.userID AS userID, $settings->userNameField AS userName, $settings->cashType AS cash, gameroom_poker_players.seatID AS seatID, status, stake
			FROM gameroom_poker_players
			LEFT JOIN $settings->userTable ON " . $settings->userTable . "." . $settings->userIDField . " = gameroom_poker_players.userID
			WHERE gameID = $this->gameID
			ORDER BY gameroom_poker_players.seatID
		";
		$result = $db->query_read($query);
		$this->playerXML = "";
		$this->dealBtn = "false";

				if ($this->rules == RULES_TEXASHOLDEM)
					$cardsInHand = 2;
				else if ($this->rules == RULES_7CARDSTUD)
					$cardsInHand = 7;
		
		$players = array();
		$i = 0;
		while ($row = $db->fetch_array($result))
		{
			$i++;
			while ($row['seatID'] > $i)
			{
				$i++;				
				$this->playerXML .= "<player userID='' userName='' cash='' isTurn='0' dealer='0'>";
				for ($j = 0; $j < $cardsInHand; $j++)
					$this->playerXML .= "<card id='' name='' img=''/>";
				$this->playerXML .= "</player>";
			}

				if($this->dealerSeat == $row['seatID'])
					$dealer = 1;
				else
					$dealer = 0;

				if($this->whosTurn == $row['seatID'])
					$isTurn = 1;
				else
					$isTurn = 0;

				if ($this->rules == RULES_TEXASHOLDEM)
				{
					if (($row['userID'] == $user->userID) && (($this->round < 1) || ($this->round == 5)) && ($dealer == 1))
					{
						$this->dealBtn = "true";
					}
				}
				else if ($this->rules == RULES_7CARDSTUD)
				{
					if (($row['userID'] == $user->userID) && (($this->round < 1) || ($this->round == 6)) && ($dealer == 1))
					{
						$this->dealBtn = "true";
					}
				}		
				if ($row['userID'] == $user->userID)
				{
					if($row['status'] > 0)
						$this->inBox = 1;
					else
						$this->inBox = 0;
					
				}
				$cash = floor($row['cash']);
				if($this->useStake == "1")
					$cash = $row['stake'];
			
			$uID = $row['userID'];
			$avatarPath = $user->getAvatars($row['userID']);
			if (($row['status'] == PLAYER_FOLDED) || ($row['status'] == PLAYER_SITOUT))
				$status = 0;
			else
				$status = 1;
			
			$this->playerXML .= "<player avatarPath='" . $avatarPath[$uID] . "' status='$status' userID='" . $row['userID'] . "' userName='" . htmlspecialchars($row['userName'], ENT_QUOTES) ."' cash='" . $cash . "' isTurn='$isTurn' dealer='$dealer'>";
			
			$uID =  $row['userID'];
			if(isset($this->playerHands[$uID]))
				$this->playerXML .= $this->playerHands[$uID]->handXML();
			else
			{
				for ($j = 0; $j < $cardsInHand; $j++)
					$this->playerXML .= "<card id='' name='' img=''/>";
			}
			$this->playerXML .= "</player>";
		}
		
			while ($i < 10)
			{
					
				$this->playerXML .= "<player userID='' userName='' cash='' isTurn='0' dealer='0'>";
				for ($j = 0; $j < $cardsInHand; $j++)
					$this->playerXML .= "<card id='' name='' img=''/>";
				$this->playerXML .= "</player>";
				$i++;				
			}
		
	}
	
	function getActiveGames($html = false)
	{
		global $db, $user, $language;
		
		// drop inactive users on 
		
		$query = "
			SELECT gameroom_poker_game.*, COUNT(gameroom_poker_players.id) AS numPlayers
			FROM gameroom_poker_game 
			LEFT JOIN gameroom_poker_players ON gameroom_poker_players.gameID = gameroom_poker_game.gameID
			WHERE  gameroom_poker_players.id > 0
			GROUP BY gameroom_poker_players.gameID
			ORDER BY numPlayers DESC
		";
		$result = $db->query_read($query);
		if ($html)
			$output = "";
		else
			$output = "<root>";
		
		while($row = $db->fetch_array($result))
		{
			$blinds =  $row['blinds'] . " / " . ($row['blinds'] * 2) ;
			if($row['betting'] == BETTING_NOLIMIT)
				$rules = $language['poker']['No_Limit'];
			else if($row['betting'] == BETTING_FIXED)
				$rules = $language['poker']['Limit'];
			else if($row['betting'] == BETTING_POT)
				$rules = $language['poker']['Pot_Limit'];
			else if($row['betting'] == BETTING_SPREAD)
				$rules = $language['poker']['Spread_Limit'];
			if($row['maxRaises'] > 0)
				$rules .= " (" . $row['maxRaises'] . " " . $language['poker']['Raises_Per_Round'] . ")";
			
			if($row['useStake'] > 0)
				$rules .= " - " .  $language['poker']['Stake'] . ": " . $language['common']['Currency_Marker'] . $row['maxStake'] . " x" . $row['stakeMultiplier'];
				
			if ($row['password'])
				$password = 1;
			else 
				$password = 0;
			$flags = "";
			if ($password)
				$flags .= $language['poker']['Password_Flag'];
			
			if ($row['rules'] == RULES_TEXASHOLDEM)
				$game = $language['poker']['Texas_Holdem']; 
			else if ($row['rules'] == RULES_7CARDSTUD)
				$game = $language['poker']['Seven_Card_Stud']; 
			
				if ($html)
				{
					if ($output == "")
						$output .= base64_decode($row['name']) . " - " . $game . " - (" . $row['numPlayers'] . " / " . $row['maxPlayers'] . ")";
					else 
						$output .= "<br/>" . base64_decode($row['name']) . " - " . $game . " - (" . $row['numPlayers'] . " / " . $row['maxPlayers'] . ")"; 
				}
				else
				{
					$output .= "<game id='" . $row['gameID'] . "' name='" . base64_decode($row['name']) . "' 
						game='" . $game . "' password='$password' flags='$flags'
						numPlayers='" . $row['numPlayers'] . "' maxPlayers='" . $row['maxPlayers'] ."'
						players='" . $row['numPlayers'] . " / " . $row['maxPlayers'] ."' blinds='$blinds' rules='$rules'
						useStake='". $row['useStake'] . "' maxStake='" . $row['maxStake'] . "' stakeMultiplyer='" . $row['stakeMultiplier'] . "' 
					/>";
				}
		}
		if (! $html)
			$output .= "</root>";
			
		return $output;
	}
	
	
	function joinGame()
	{
		global $user, $db, $chatroom, $language;
		$gameID = $_GET['gameID'] * 1;
		$query = "
			SELECT gameroom_poker_game.*, COUNT(gameroom_poker_players.id) AS numPlayers, rules
			FROM gameroom_poker_game 
			LEFT JOIN gameroom_poker_players ON gameroom_poker_players.gameID = gameroom_poker_game.gameID
			WHERE  gameroom_poker_players.id > 0
			AND gameroom_poker_game.gameID = $gameID
			GROUP BY gameroom_poker_players.id
			ORDER BY numPlayers DESC
		";
		$result = $db->query_read($query);
		if($row = $db->fetch_array($result))
		{
			if ($row['rules'] == RULES_TEXASHOLDEM)
				$gameType = GAMEID_POKER_TEXAS;
			if ($row['rules'] == RULES_7CARDSTUD)
				$gameType = GAMEID_POKER_7CARD;
			
			$useStake = $row['useStake'];
			if ($useStake == "1")
			{
				if ($user->cash < ($row['maxStake']*1))
				{
					$userStake = $user->cash * ($row['stakeMultiplier']*1);
					$user->record_cash($gameType, $user->cash * -1, $user->userID );
				}
				else
				{
					$userStake = ($row['maxStake']*1) * ($row['stakeMultiplier']*1);
					$user->record_cash($gameType, $row['maxStake'] * -1, $user->userID );
				}
			}
			$rules = $row['rules'];
			
			if ($row['password'])
			{
				if (base64_encode($_GET['password']) != $row['password'])
				{
					$this->xml = "<root><status error='" . $language['poker']['Bad_Password'] . "' /></root>";
					return 1;
				}
			}
			if ($row['numPlayers'] < $row['maxPlayers'])
			{
				$query = "
					SELECT seatID, userID
					FROM gameroom_poker_players 
					WHERE gameID =$this->gameID
					AND userID > 0
				";
				$result = $db->query_read($query);
				$i = 0;
				$seatsTaken = array();
				while ($row = $db->fetch_array($result))
				{
					$seatsTaken[$i] = $row['seatID'];
					$i++;
					if($row['userID'] == $user->userID)
					{
						// already in
						$this->xml = "<root><status gameID='$this->gameID' chatID='$chatroom->chatID' rules='$rules' error='' /></root>";
						return 1;
					}
				}
				if ($rules == RULES_TEXASHOLDEM)
					$chairs = 10;
				else
					$chairs = 6;
				
				$playerSeat = rand()%$chairs + 1;
				while (in_array($playerSeat, $seatsTaken))
					$playerSeat = rand()% $chairs + 1;
				
				if(! $useStake == "1")
					$userStake = 0;
				$time = time();
				$query = "
					INSERT INTO gameroom_poker_players
						(gameID, userID, stake, seatID, lastUpdate, bet)
					VALUES
						($this->gameID, $user->userID, $userStake, $playerSeat, $time, 0)
				";
						
				$db->query_write($query);
				$this->xml = "<root><status gameID='$this->gameID' chatID='$chatroom->chatID'  rules='$rules' error='' /></root>";
				
			}
			else
			{
				$this->xml = "<root><status error='" . $language['poker']['Game_No_Is_Full'] . "' /></root>";
			}
		}
		else
		{
				$this->xml = "<root><status error='" . $language['poker']['Game_No_Longer_Exists'] . "' /></root>";
		}
		
		
	}
	
	function getSettings()
	{
		global $db, $user;
				
		$this->gameID = $_GET['gameID'] * -1;
		
		$query = "
			SELECT * 
			FROM gameroom_poker_game
			WHERE gameID = $this->gameID
		";	
		$result = $db->query($query);
		if($row = $db->fetch_array($result))
		{
			$this->rules = $row['rules'];
			$this->betting = $row['betting'];
			$this->pot= $row['pot']; 
			$this->round = $row['round'];
			$this->dealerSeat = $row['dealerSeat'];
			$this->whosTurn = $row['whosTurn'];
			$this->turnTimeOut = $row['turnTimeOut'];
			$this->ante = $row['ante'];
			$this->blinds = $row['blinds'];
			$this->maxRaises = $row['maxRaises'];
			$this->maxPlayers = $row['maxPlayers'];
			$this->maxBet = $row['maxBet'];
			$this->betLimit = $row['betLimit'];
			$this->useStake = $row['useStake'];
			$this->minStake = $row['minStake'];
			$this->maxStake = $row['maxStake'];
			$this->stakeMultiplier = $row['stakeMultiplier'];
			$this->tournamentGame = $row['tournamentGame'];
			$this->lockPlayers = $row['lockPlayers'];
			$this->gameStarted = $row['gameStarted'];
			$this->chatID = $row['gameID'];
			
			// Load users / Check if the player is in the game
			$query = "
				SELECT *
				FROM gameroom_poker_players
				WHERE gameID = $this->gameID
			";
			$result = $db->query_read($query);
			$this->numPlayers = 0;
			$this->activePlayers = 0;
			$inGame = 0;
			while ($row = $db->fetch_array($result))
			{
				if($row['status'] != PLAYER_SITOUT)
					$this->activePlayers++;
				$this->numPlayers++;
				if(($user->userID == $row['userID']) && ($user->cash > 0) && (! $this->useStake))
					$inGame = 1;
				else if(($user->userID == $row['userID']) && ($row['stake'] > 0) && ($this->useStake))
					$inGame = 1;
				else if ($user->userID == $row['userID'])
				{
					$db->query_write("UPDATE gameroom_poker_players SET status = 0 WHERE userID = $user->userID AND gameID = $this->gameID");
				}
			}
			if(! $inGame)
				$this->joinGame();
		}
		else
		{
			// Invalid game / game no longer active
		}
		
		$this->gameStatusXML = "<gameStatus numPlayers='$this->numPlayers' pot='$this->pot' />";
	}
	
	function compareHands($hand1, $hand2)
	{
		$besthand = 0;
		
		for($i = 5; $i < 10; $i++)
		{
			if($hand1[$i] > $hand2[$i])
			{
				$besthand = 1;
				$i = 11;
			}
			else if($hand1[$i] < $hand2[$i])
			{
				$besthand = 2;
				$i = 11;
			}
		}

		return $besthand;
	}
	
	
	function getBet()
	{
		
	}


	function deal()
	{
		global $db, $user, $settings, $chatroom, $language;
		
		// shuffle the deck
		for($i = 1; $i < 53; $i++) {
			$card[$i]=$i;
		}
		srand((float)microtime() * 1000000);
		shuffle($card);

		$c = 0;
		$h = 1;
		$s = 2;
		$d = 3;
/*		
		$card[0] = 13 + ($c * 13);
		$card[1] = 13 + ($s * 13);
		$card[2] = 13 + ($c * 13);
		$card[3] = 13 + ($s * 13);
		$card[4] = 4 + ($c * 13);
		$card[5] = 11 + ($c * 13);
		$card[6] = 11 + ($d * 13);
		$card[7] = 6 + ($h * 13);
		$card[8] = 6 + ($c * 13);
*/	
		$query = "
			DELETE FROM gameroom_poker_dealt
			WHERE gameID = $this->gameID
		";
		$db->query_write($query);
		$query ="
			SELECT gameroom_poker_players.userID AS userID, $settings->userNameField AS userName, $settings->cashType AS cash, gameroom_poker_players.seatID AS seatID, status
			FROM gameroom_poker_players
			LEFT JOIN $settings->userTable ON " . $settings->userTable . "." . $settings->userIDField . " = gameroom_poker_players.userID
			WHERE gameID = $this->gameID
			AND status = " . PLAYER_READY . "
			ORDER BY gameroom_poker_players.seatID
		";
		$result = $db->query_read($query);
		
		$i = 0;
		$values = "";
		while ($row = $db->fetch_array($result))
		{
			if($this->rules == RULES_TEXASHOLDEM)
				$cards = 2;
			else if($this->rules == RULES_7CARDSTUD)
				$cards = 3;
			
			// deal two cards to every player
			$j = $i + $cards;
			for($i = $i; $i < $j; $i++)
			{
				$uID = $row['userID'];
				$cardID = $card[$i];

				if($this->rules == RULES_TEXASHOLDEM)
					$faceUp = "false";
				else if($this->rules == RULES_7CARDSTUD)
				{
					if ($j - $i == 1)
						$faceUp = "true";
					else
						$faceUp = "false";
				}
				
				if($values != "")				
					$values .= ",\n($this->gameID, $uID, $cardID, $faceUp)";
				else				
					$values = "($this->gameID, $uID, $cardID, $faceUp)";
			}		
		}
		// Load the rest into the stack (player 0)
		for($i = $i; $i < 52; $i++)
		{
			$uID = $row['userID'];
			$cardID = $card[$i];
			
			$values .= ",\n($this->gameID, 0, $cardID, false)";
		}
		
			$query = "
				INSERT INTO gameroom_poker_dealt
					(gameID, userID, cardID, faceUp)
				VALUES
					$values
			";
		$db->query_write($query);
		
		$query = "
			UPDATE gameroom_poker_players
			SET status = " . PLAYER_INGAME . ",
			bet = 0
			WHERE gameID = $this->gameID 
			AND status NOT IN ( " . PLAYER_SITOUT . ") 
		";
		$db->query_write($query);
		
		if ($this->rules == RULES_TEXASHOLDEM)
			$this->minRaise = $this->blinds * 2;
		else if ($this->rules == RULES_7CARDSTUD)
			$this->minRaise = $this->ante * 2;
		$this->topRaise = $this->minRaise;
		$this->round = 1;
		$query = "
			UPDATE gameroom_poker_game
			SET round = 1,
			pot = 0,
			minRaise = $this->minRaise
			WHERE gameID = $this->gameID
		";
		$this->gameOver = false;
		$db->query_write($query);
		$this->playerHands = null;
		$this->playerXML = null;
		$this->setFirstPlayer();
		
		
		$chatroom->systemMsg("$user->userName " . $language['poker']['Deals'], $language['poker']['Dealer']);
			
	}
	
	function placeBet($bet, $userID = 0)
	{
		global $db, $chatroom, $user, $settings;
		 
		if(! $userID)
			$userID = $user->userID;
		
		$query = "
			SELECT $settings->cashType AS cash
			FROM $settings->userTable 
			WHERE userid = $userID
		";
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		$cash = $row['cash'];
			
		if ($bet > $cash)
			$bet = $cash;
			
		if ($this->toCall < $bet)
			$raise = $bet - $this->toCall;
		if ($raise > $this->topRaise)
			$this->topRaise = $raise;

		if ($this->betting == BETTING_NOLIMIT)
			$minRaise = "minRaise = $this->topRaise";
		else
			$minRaise = "minRaise = $this->minRaise";
		
		$query = "
			UPDATE gameroom_poker_game 
			SET pot = pot + $bet,
			$minRaise
			WHERE gameID = $this->gameID 
		";
		$db->query_write($query);
		
		if($this->useStake)
		{
			$stake = ", stake = stake - $bet ";
		}
		else
		{
			$stake = "";
			$user->record_cash($this->gameType, $bet * -1, $userID);
		}	
		$query = "
			UPDATE gameroom_poker_players
			SET bet = bet + $bet
			$stake
			WHERE userID = $userID
			AND gameID = $this->gameID
		";
		$db->query_write($query);
		if($this->toCall == $bet)
		{
			
		}
		else if ($bet > $this->toCall)
		{
			// was a raise
			$query = "
				UPDATE gameroom_poker_game
				SET lastRaise = (
					SELECT seatID 
					FROM gameroom_poker_players 
					WHERE userID = $userID
					AND gameID = $this->gameID
				)
				WHERE gameID = $this->gameID
			";
			$db->query_write($query);
		}
		
	}
	

	function payout($userID, $bet)
	{
		global $db, $chatroom, $user;
		 
		if($this->useStake)
		{
			$query = "
				UPDATE gameroom_poker_players
				SET stake = stake + $bet
				WHERE userID = $userID
				AND gameID = $this->gameID
			";
			$db->query_write($query);
		}
		else
		{
			$user->record_cash($this->gameType, $bet, $userID);
			
		}
		
	}
	
	
	function check()
	{
		global $db, $chatroom, $user, $language;
		
		if(($this->isTurn) && ($this->canCheck))
		{
			$this->nextPlayer();
			$this->isTurn = 0;
			$chatroom->systemMsg("$user->userName " . $language['poker']['Checks'], $language['poker']['Dealer']);
		}
		
		
	}


	function call()
	{
		global $db, $chatroom, $user, $language;
		
		if(($this->isTurn) && ($this->canCall))
		{
			$this->placeBet($this->toCall);
			$this->nextPlayer();
			$this->isTurn = 0;
			$chatroom->systemMsg("$user->userName " . $language['poker']['Calls'] . " ($this->toCall)", $language['poker']['Dealer']);
		}
		
		
		
	}

	function raise()
	{
		global $db, $chatroom, $user, $language;
		
		$bet = $_GET['bet'] * 1;
		if(($this->isTurn) && ($this->canRaise) && ($bet >= $this->minRaise) && ($bet <= $this->maxRaise))
		{
			
			$this->placeBet($bet + $this->toCall);
			$this->nextPlayer();
			$this->isTurn = 0;
			$raise = $bet - $this->toCall;
			$chatroom->systemMsg("$user->userName " . $language['poker']['Raises'] . " $bet", $language['poker']['Dealer']);
			
		}
		
	}
	
	
	function fold()
	{
		global $db, $chatroom, $user, $language;
		
		if($this->isTurn)
		{
			$query = "
				UPDATE gameroom_poker_players
				SET status = " . PLAYER_FOLDED . "
				WHERE gameID = $this->gameID
				AND userID = $user->userID
			";
			$db->query_write($query);
			
			$query = "
				UPDATE gameroom_poker_dealt
				SET cardID = null
				WHERE gameID = $this->gameID
				AND userID = $user->userID
			";
			$db->query_write($query);
			
			if($this->activePlayers == 2)
				$this->nextPlayer(true);
			else				
				$this->nextPlayer();
				
			$this->isTurn = 0;
			$chatroom->systemMsg("$user->userName " . $language['poker']['Folds'], $language['poker']['Dealer']);
			
		}
		
	}

	
	function nextPlayer($forceEnd = false, $emptySeatID = "")
	{
		global $db, $chatroom, $user, $language;

		// build array of active players
		$playerArray = array();
		$query = "
			SELECT userID, seatID
			FROM gameroom_poker_players
			WHERE gameID = $this->gameID 
			AND status = " . PLAYER_INGAME . "
			ORDER BY seatID
		";
		$result = $db->query_read($query);
		while($row = $db->fetch_array($result))
		{
			$seatID = $row['seatID'];
			$userID = $row['userID'];
			
			$playerArray[$seatID] = $userID;
		}

		if ($_GET['test'] == 1)
		{
			echo "test";
			var_dump($playerArray);
		}
		if ($emptySeatID)
		{
			$doneCycle = 0;
			$i = 0;
			while ((key($playerArray) < $emptySeatID) && ($doneCycle == false) && ($i < 12))
			{
				if(! next($playerArray))
				{
					reset($playerArray);
					$doneCycle = 1;
				}
				$i++;
			}
		}
		else
		{
			// go to current player
			$i = 0;
			while ((current($playerArray) != $user->userID) && ($forceEnd == false) && ($i < 10))
			{
				$i++;
				next($playerArray);
			}
		}
		$i = 0;
		while ($i < 1)
		{
			if(! next($playerArray))
				reset($playerArray);

			$seatID = key($playerArray);
			$i++;
		}
		$query = "
			UPDATE gameroom_poker_game 
			SET whosTurn = $seatID
			WHERE gameID = $this->gameID 
		";
		if ($seatID)
			$db->query_write($query);
		
		// end of betting, go to next round
		if((($this->lastRaise == $seatID) && ($_GET['req'] != 'raise')) || ($forceEnd == true))
		{
			//  Find the seat after the dealer
			$i = 0;
			while ((key($playerArray) != $this->dealerSeat) && ($forceEnd == false) && ($i < 12))
			{
				$i++;
				if(!next($playerArray))
					reset ($playerArray);
			}
			$i = 0;
			while ($i < 1)
			{
				if(! next($playerArray))
					reset($playerArray);
	
				$seatID = key($playerArray);
				$i++;
			}
			
			
			if((($this->round == 4) && ($this->rules == RULES_TEXASHOLDEM)) || (($this->round == 5) && ($this->rules == RULES_7CARDSTUD)) || ($forceEnd == true))
			{
				// End of Hand
				if($forceEnd)
					$this->activePlayers = 1;
					
				$this->endHand();				
				
			}
			else
			{
				$this->minRaise = $this->blinds * 2;
				if ($this->round >= 2)
					$this->minRaise = $this->minRaise * 2;
					
				$query = "
					UPDATE gameroom_poker_game 
					SET round = round + 1,
						whosTurn = $seatID,
						lastRaise = $seatID,
						minRaise = $this->minRaise
					WHERE gameID = $this->gameID 
				";
				if ($seatID)
					$db->query_write($query);
				
				if ($this->rules == RULES_TEXASHOLDEM)
				{
					if ($this->round == 3)
						$chatroom->systemMsg( $language['poker']['The_River'], $language['poker']['Dealer']);
					if ($this->round == 2)
						$chatroom->systemMsg( $language['poker']['The_Turn'], $language['poker']['Dealer']);
					if ($this->round == 1)
						$chatroom->systemMsg( $language['poker']['The_Flop'], $language['poker']['Dealer']);
				}
				else if ($this->rules = RULES_7CARDSTUD)
				{
					if ($this->round == 4 )
						$this->dealSingle("0");
					else
						$this->dealSingle("1");
				}
			}
		}
		
	}
	
	function dealSingle($faceUp)
	{
		global $db, $user, $settings;
		
		$query ="
			SELECT gameroom_poker_players.userID AS userID, $settings->userNameField AS userName, $settings->cashType AS cash, gameroom_poker_players.seatID AS seatID, status
			FROM gameroom_poker_players
			LEFT JOIN $settings->userTable ON " . $settings->userTable . "." . $settings->userIDField . " = gameroom_poker_players.userID
			WHERE gameID = $this->gameID
			AND status = " . PLAYER_INGAME . "
			ORDER BY gameroom_poker_players.seatID
		";
		$result = $db->query_read($query);
		
		$i = 0;
		$values = "";
		while ($row = $db->fetch_array($result))
		{
			$uID = $row['userID'];
			$this->playerHands[$uID]->drawCard($faceUp, $uID);
		}
		
	}

	function findWinner()
	{
		global $db, $chatroom, $user, $settings, $language;
		$query = "
			SELECT * 
			FROM gameroom_poker_dealt
			WHERE gameID = $this->gameID
			AND userID = 0
			ORDER BY id
			LIMIT 5
		";
		$result = $db->query_read($query);
		$playerCards = array();
		$playerCards[0] = array(0,0);
		while ($row = $db->fetch_array($result))
			$playerCards[0][] = $row['cardID'] ;

		// other players left
		if (! $this->playerHands)
		{
			$this->payout($user->userID, $this->pot);
			$query = "
				UPDATE gameroom_poker_game 
				SET round = 0,
					whosTurn = 0,
					lastRaise = 0,
					pot = 0
				WHERE gameID = $this->gameID 
			";
			$db->query_write($query);
			
			return 0;
		}	
		foreach ($this->playerHands as $key => $p)
		{
			if ($this->rules == RULES_TEXASHOLDEM)
				$this->playerHands[$key]->loadHand($this->playerHands[$key]->hand + $playerCards[0]);
			if ($this->rules == RULES_7CARDSTUD)
				$this->playerHands[$key]->loadHand($this->playerHands[$key]->hand);
			$this->playerHands[$key]->findBestHand();
		}

		$query = "
			SELECT * 
			FROM gameroom_poker_players
			WHERE gameID = $this->gameID
			AND status = " . PLAYER_INGAME . " 
		";
		$result = $db->query_read($query);
		$winner = 0;
		$tie = "";
		$winnerHand = new pokerHand;
		
		while ($row = $db->fetch_array($result))
		{
			$userID = $row['userID'];
			if ($winner == 0)
			{
				$winner = $userID;
				$winnerHand = $this->playerHands[$userID];
			}
			else
			{
				$w = $this->compareHands($this->playerHands[$userID]->bestHand, $this->playerHands[$winner]->bestHand);
				
				if($w == 1)
				{
					$winner = $userID;
					$winnerHand = $this->playerHands[$userID];
				}
				else if($w == 0)
				{
					$tie .= "," . $userID;
					$winnerHand = $this->playerHands[$winner];
				}
			}
		}

		$query = "
			SELECT $settings->userNameField AS name
			FROM $settings->userTable
			WHERE $settings->userIDField IN ($winner $tie)
		";
		$result = $db->query_read($query);
		$i = $j = $db->num_rows($result);
		$winnerNames = "";
		while ($row = $db->fetch_array($result))
		{
			if($i == $j)
				$winnerNames = $row['name'];
			else if($i == 1)
				$winnerNames .= " and " . $row['name'];
			else
				$winnerNames .= ", " . $row['name'];
			$i--;
		}
		
		// loop the winners with the players, make sure none of the winners are
		// in with less then anyone else.  If they are refund the difference then pay out the pot
		// - _ajax 163 - 222 
		$query = "
			SELECT * 
			FROM  gameroom_poker_players
			WHERE $settings->userIDField IN ($winner $tie)
			AND gameID = $this->gameID
		";
		$winners = $db->query_read($query);
		
		$query = "
			SELECT * 
			FROM gameroom_poker_players
			WHERE gameID = $this->gameID
		";
		$players = $db->query_read($query);
		$refunds = array();
		$playerWinnings = array();
		while($winnerRow = $db->fetch_array($winners))
		{
			$winnerBet = $winnerRow['bet'];
			$playerID = $winnerRow['userID'];
			$playerWinnings[$playerID] = $this->pot / $j;
			while($playerRow = $db->fetch_array($players))
			{
				if ($winnerBet < $playerRow['bet'])
				{
					$id = $playerRow['userID'];
					if(isset($refunds[$id]))
						$refunds[$id] += $playerRow['bet'] - ($winnerBet / $j);
					else
						$refunds[$id] = $playerRow['bet'] - ($winnerBet / $j);
					
					$playerWinnings[$playerID] -= $playerRow['bet'] - ($winnerBet / $j);
				}
			}
			$db->data_seek($players,0);
		}
		
		foreach ($refunds as $id => $refund)
			$this->payout($id, $refund);
		
		foreach ($playerWinnings as $id => $winnings)
			$this->payout($id, $winnings);

			
		if($this->activePlayers == 1)
			$chatroom->systemMsg("$winnerNames " . $language['poker']['Wins'] . " ($this->pot)", $language['poker']['Dealer']);
		else
			$chatroom->systemMsg("$winnerNames " . $language['poker']['Wins_With'] . " $winnerHand->handName ($this->pot)", $language['poker']['Dealer']);
		
//		foreach ($this->playerHands as $p)
//			$chatroom->systemMsg($p->userID . " $p->handName (" . implode(', ', $p->bestHand) . ")", $language['poker']['Dealer']);
			
	}
	
	function endHand($noWinner = false)
	{
		global $db, $chatroom, $user;

		if ($noWinner == false)
		{
			$this->findWinner();
		}

		$playerArray = array();
		if ($noWinner)
			$ready = ", " . PLAYER_READY;
		else 
			$ready = "";
		
		$query = "
			SELECT userID, seatID
			FROM gameroom_poker_players
			WHERE gameID = $this->gameID 
			AND status IN (" . PLAYER_INGAME . ", " . PLAYER_FOLDED . $ready .")
			ORDER BY seatID
		";
		$result = $db->query_read($query);
		while($row = $db->fetch_array($result))
		{
			$seatID = $row['seatID'];
			$userID = $row['userID'];
			
			$playerArray[$seatID] = $userID;
		}
		
		$dealerKey = array_search($user->userID, $playerArray);
		
		// go to current player
		
		$i = 0;
		while ((key($playerArray) != $this->dealerSeat) && ($i < 12))
		{
			$i++;
			next($playerArray);
		}
		$i = 0;
		while ($i < 1)
		{
			if(! next($playerArray))
				reset($playerArray);

			$newDealer = key($playerArray);
			$i++;
		}
		
		if (! $newDealer)
			return 0;
			
		if($this->activePlayers == 1)
			$query = "
				UPDATE gameroom_poker_game 
				SET round = 0,
					whosTurn = 0,
					lastRaise = 0,
					dealerSeat = $newDealer,
					pot = 0
				WHERE gameID = $this->gameID 
			";
		else if ($noWinner == false)
			$query = "
				UPDATE gameroom_poker_game 
				SET round = round + 1,
					whosTurn = 0,
					lastRaise = 0,
					dealerSeat = $newDealer
				WHERE gameID = $this->gameID 
			";
		else
			$query = "
				UPDATE gameroom_poker_game 
				SET round = 0,
					whosTurn = 0,
					lastRaise = 0,
					dealerSeat = $newDealer
				WHERE gameID = $this->gameID 
			";
		
		$db->query_write($query);
		
		$query = "
			UPDATE gameroom_poker_players
			SET status = " . PLAYER_READY . "
			WHERE gameID = $this->gameID 
			AND status NOT IN (" . PLAYER_SITOUT . ")
		";
		$db->query_write($query);
			
	}

	function setFirstPlayer()
	{
		global $db, $chatroom, $user;
		
		// build array of active players
		$playerArray = array();
		$query = "
			SELECT userID, seatID
			FROM gameroom_poker_players
			WHERE gameID = $this->gameID 
			AND status = " . PLAYER_INGAME . "
			ORDER BY seatID
		";
		$result = $db->query_read($query);
		while($row = $db->fetch_array($result))
		{
			$seatID = $row['seatID'];
			$userID = $row['userID'];
			
			$playerArray[$seatID] = $userID;
		}
		
		$dealerKey = array_search($user->userID, $playerArray);
		
		if (($this->activePlayers == 2) && ($this->rules == RULES_TEXASHOLDEM))
		{
			// heads up rules, dealer is first to act;
			while (current($playerArray) != $user->userID)
			{
				next($playerArray);
			}
			
			// Dealer places small blind
			$this->placeBet($this->blinds, $user->userID);
			
			// opponent places big blind
			if(! next($playerArray))
				reset($playerArray);
			
			$this->placeBet($this->blinds * 2, current($playerArray));
			
			if($this->round == 1)
			{
				$lr = $dealerKey;
				$wt = key($playerArray);
			}
			else
			{
				$lr = key($playerArray);
				$wt = $dealerKey;
			}
			$query = "
				UPDATE gameroom_poker_game 
				SET whosTurn = $lr,
					lastRaise = $lr
				WHERE gameID = $this->gameID 
			";
			$db->query_write($query);
		}
		else if ($this->rules == RULES_TEXASHOLDEM)  
		{
			// 3 past dealer is first to act (small blind, bb, act)
			// go to current player
			while (current($playerArray) != $user->userID)
			{
				next($playerArray);
			}
			
			$i = 1;
			
			while ($i < 4)
			{
				if(! next($playerArray))
					reset($playerArray);

				$lastSeat = $seatID;
				$seatID = key($playerArray);
				
				// bet blinds for first 2 players
				if($i < 3)
					$this->placeBet($this->blinds * $i, current($playerArray));
				$i++;
					
			}
			$query = "
				UPDATE gameroom_poker_game 
				SET whosTurn = $seatID,
					lastRaise = $seatID
				WHERE gameID = $this->gameID 
			";
			$db->query_write($query);
		}
		else if ($this->rules == RULES_7CARDSTUD)
		{
			// go to current
			while (current($playerArray) != $user->userID)
				next($playerArray);

			$lastSeat = key($playerArray);
			
			// first after dealer
			if (! next($playerArray))
				reset($playerArray);
			
			$seatID = key($playerArray);
			
			foreach ($playerArray as $p)
				$this->placeBet($this->ante, $p);
			
			$query = "
				UPDATE gameroom_poker_game 
				SET whosTurn = $seatID,
					lastRaise = $seatID
				WHERE gameID = $this->gameID 
			";
			$db->query_write($query);
			
			
		}
	}

	function dropInactivePlayers()
	{
		global $db, $chatroom, $user;
		$time = time () - (TIMEOUT_MAJOR);
		
		$query = "
			SELECT gameroom_poker_players.id, gameroom_poker_players.userID, gameroom_poker_players.stake,
			gameroom_poker_game.stakeMultiplier, lastUpdate, rules
			FROM gameroom_poker_players
			LEFT JOIN gameroom_poker_game ON gameroom_poker_game.gameID = gameroom_poker_players.gameID
			WHERE lastUpdate < $time
		";
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			$id = $row['id'];
			$userID = $row['userID'];
			$stake = $row['stake'];
			$stakeMultiplier = $row['stakeMultiplier'];
			
			if ($row['rules'] == RULES_TEXASHOLDEM)
				$gameType = GAMEID_POKER_TEXAS;
			if ($row['rules'] == RULES_7CARDSTUD)
				$gameType = GAMEID_POKER_7CARD;
			
			if ($stake)
			{
				$stake = $stake / $stakeMultiplier;
				$user->record_cash($gameType, $stake, $userID);
			}
			$query = "
				DELETE FROM gameroom_poker_players
				WHERE id = $id
			";
			$db->query_write($query);
			
		}
			
	}
	
}
?>