<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

class ranking
{
	var $gameType, $player1, $player2, $result;
	var $player1Rank = -1, $player2Rank = -1;
	var $startRank = 1500;

	function ranking($gameType, $player1, $player2, $result)
	{
		$this->player1 = $player1;
		$this->player2 = $player2;
		$this->result = $result;
		$this->gameType = $gameType;
		$this->getRanks();
	}
	
	function getRanks()
	{
		global $db;
		
		$query = "
			SELECT userID, rank
			FROM gameroom_rank
			WHERE gameType = $this->gameType
			AND userID IN ($this->player1, $this->player2)
		";
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			if ($row['userID'] == $this->player1)
				$this->player1Rank = $row['rank'];
			else if ($row['userID'] == $this->player2)
				$this->player2Rank = $row['rank'];
		}
		$this->checkForNewPlayers();
		
	}
	
	function checkForNewPlayers()
	{
		global $db;
		// not in ranking system, create entries
		if ($this->player1Rank == -1)
		{
			$this->player1Rank = $this->startRank;
			$query = "
				INSERT INTO gameroom_rank
				(userID, gameType, rank, gamesPlayed, wins, loses, draws)
				VALUES
				($this->player1, $this->gameType, $this->player1Rank, 0, 0, 0, 0)
			";
			$db->query_write($query);
		}
		if (($this->player2Rank == -1) && ($this->player1 != $this->player2))
		{
			$this->player2Rank = $this->startRank;
			$query = "
				INSERT INTO gameroom_rank
				(userID, gameType, rank, gamesPlayed, wins, loses, draws)
				VALUES
				($this->player2, $this->gameType, $this->player2Rank, 0, 0, 0, 0)
			";
			$db->query_write($query);
		}
		
	}
	
	function updateRanks()
	{
		if($this->result == 1)
			$result = 1;
		else if($this->result == 2)
			$result = 0;
		else if($this->result == 3)
			$result = 0.5;
			
		$p1elo = new elo ($this->player1Rank, $this->player2Rank, $result);
		$p2elo = new elo ($this->player2Rank, $this->player1Rank, 1-$result);
		
		$this->player1Rank = $p1elo->rank;
		$this->player2Rank = $p2elo->rank;
		$this->saveRanks();
	}
	
	function saveRanks()
	{
		global $db;

		if($this->result == 1)
			$result = "wins = wins + 1";
		else if($this->result == 2)
			$result = "loses = loses + 1";
		else if(($this->result == 3) || ($this->result == 0))
			$result = "draws = draws + 1";
		$query = "
			UPDATE gameroom_rank 
			SET rank = $this->player1Rank,
				gamesPlayed = gamesPlayed + 1,
				$result
			WHERE gameType = $this->gameType
			AND userID = $this->player1
		";
		$db->query_write($query);

		
		if($this->result == 2)
			$result = "wins = wins + 1";
		else if($this->result == 1)
			$result = "loses = loses + 1";
		else if(($this->result == 3) || ($this->result == 0))
			$result = "draws = draws + 1";
		
		$query = "
			UPDATE gameroom_rank 
			SET rank = $this->player2Rank,
				gamesPlayed = gamesPlayed + 1,
				$result
			WHERE gameType = $this->gameType
			AND userID = $this->player2
		";
		$db->query_write($query);
			
	}
}


class elo
{
	var $rank, $opponentRank;
	var $kFactor;
	var $result, $expectedResult;
	
	function elo($rank, $opponentRank, $result)
	{
		$this->rank = $rank;
		$this->opponentRank = $opponentRank;
		$this->result = $result;
		
		$this->setkFactor();
		$this->getExpectedScore();
		$this->calculateRank();
			
		return true;
	}
	
	function setkFactor()
	{
		if ($this->rank < 2100)
			$this->kFactor = 32;
		else if ($this->rank < 2400)
			$this->kFactor = 24;
		else
			$this->kFactor = 16;
	}
	
	function calculateRank()
	{
		$this->rank = $this->rank + $this->kFactor * ($this->result - $this->expectedScore);
		if ($this->rank < 0)
			$this->rank = 0;
	}
	
	function getExpectedScore()
	{
		$e = 1 / (1 + pow(10, ($this->opponentRank - $this->rank) / 400));
		$this->expectedScore = $e;
		return $e;
		
	}
}
?>