<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

class fourInARow
{
	var $myColor, $myTurn, $error = 0, $pageXML, $gameID, $whosTurn;
	var $canMove, $canMove1, $canMove2;
	
	var $numRows = 6;
	var $numCols = 7;

	function init()
	{
		global $user, $db, $game, $language;
		
		$playerList = $game->getPlayerList();
		$x  = $_GET['sx'];
		
		$this->piecenames = array();
		$this->pieceNames[1] = $language['fourinarow']['Red'];
		$this->pieceNames[2] = $language['fourinarow']['Black'];
		
		$this->pieceImages = array();
		$this->pieceImages[1] = 'gameroom/images/fourinarow-r.png';
		$this->pieceImages[2] = 'gameroom/images/fourinarow-b.png';
		
		$this->board= array();
		$query = "SELECT * FROM gameroom_chess_pieces WHERE gameid = $this->gameID ORDER BY boardid";
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			$i = $row['boardID'];
			$this->board[$i] = $row['pieceID'];
		}
	
		if ($this->myColor == $this->whosTurn)
		{
			$this->myTurn = "true";
			if ($x)
			{
				$this->placePiece($x);
				$game->validMoveStatus = false;
			}
		}
		else
			$this->myTurn = "false";
		
		if ((! $game->validMoveStatus) || (($game->winner == null) && ($game->statusFlags == 0)))
		{
			$this->canMove1 = $this->canMove2 = $this->canMove();
			
			$game->statusFlags = 0;
			if ($this->canMove1)
				$game->statusFlags += FLAG_CANMOVE_1;  
			if ($this->canMove2)
				$game->statusFlags += FLAG_CANMOVE_2;
			$db->query_write("
				UPDATE gameroom_board_game 
				SET statusFlags = $game->statusFlags 
				WHERE gameID = $game->gameID
			"); 
				 
		}	
		else
		{
			if ($game->statusFlags & FLAG_CANMOVE_1)
				$this->canMove1 = 1;
			else
				$this->canMove1 = 0;

			if ($game->statusFlags & FLAG_CANMOVE_2)
				$this->canMove2 = 1;
			else
				$this->canMove2 = 0;
				
		}
		if ($this->myColor == 1)
			$this->canMove = $this->canMove1;
		else
			$this->canMove = $this->canMove2;
		
		if (($game->winner === "0") || ($this->winner > 0))
			$this->myTurn = "false";
		$this->drawBoard($playerList);
		
	}
	
	
	function drawBoard($playerList)
	{
		global $user, $db, $game, $language, $settings;
		
		$page = $playerList;
		
		if ($game->winner)
			$game->gameStarted = 2;
			
		$page .= "<Board winner='$game->winner' gameID='$game->gameID' timeControl='$game->timeControl' drawOffer='$game->drawOffer' gameStarted='$game->gameStarted' myTurn='$this->myTurn' myColor='$this->myColor' canMove='$this->canMove' canMove1='$this->canMove1' canMove2='$this->canMove2' noOpponent='$game->gameOverAlone' timeOut='$game->timeOutWarning'>\n";
		
		for ($y = 1; $y <= $this->numRows; $y++)
		{
			for ($x = 1; $x <= $this->numCols; $x++)
			{
				// set cell background
				if((($x % 2) + $y) % 2) 
					$c = $settings->fourInARow['light_color'];
				else 
					$c = $settings->fourInARow['dark_color'];
								
				$v = ($y-1) * $this->numCols + $x;
	
				$s = 0;
				if($this->board[$v] > 0){
					$p = $this->board[$v];
					$pname = $this->pieceNames[$p];
					$pImg = $this->pieceImages[$p];
					
					if(($p % 2 == 1) && ($this->myColor == 2))
						$mine = "1";
					else if(($p % 2 == 0) && ($this->myColor == 1))
						$mine = "1";
					else
						$mine = "0";
					
					$page .= "<grid id='$p' mine='$mine' title='$pname' selected='$s' x='$x' y='" . $y . "' background='$c' backgroundColor='$c' width='68' height='70' img='$pImg' />\n";
				}
	
				else 
					$page .= "<grid title=''  mine='0' selected='$s' x='$x' y='$y' id='$v' background='$c' backgroundColor='$c' width='68' height='70' img='' />\n";
			}
			
		}
		$page .= "</Board>\n";
		
		$this->pageXML = $page;		
	}
	
	
	// done
	function setupBoard()
	{
		global $db, $user;
		$board = array();

		// End starting layout 
		$db->query_write("DELETE FROM gameroom_chess_pieces WHERE gameID = $this->gameID ");
		for($x = 1; $x <= ($this->numCols * $this->numRows); $x++)
		{
			if(! $board[$x]) $board[$x] = 0;
			$query = "INSERT INTO gameroom_chess_pieces (gameID, boardID, pieceID) VALUES ($this->gameID, $x, $board[$x])";
			$db->query_write($query);
		}
		
	}
	
	
	// done
	function checkSquare($x, $y, $board = "")
	{
		if ($board =="" )
			$board = $this->board;		
			
		if(($x < 1)||($x > $this->numCols)||($y < 1)||($y > $this->numRows))
			return -1;
			
		$i = (($y - 1) * $this->numCols) + $x;
		if($board[$i] <> 0)
		{
			return $board[$i];
		}
		return 0;
	}		

	// done?
	function nextTurn()
	{
		global $db, $game;
		
		if ($this->whosTurn == 1)
			$this->whosTurn = 2;
		else
			$this->whosTurn = 1;
		
		$query = "
			UPDATE gameroom_board_game 
			SET move = $this->whosTurn 
			WHERE gameID = $this->gameID
		";
		$db->query_write($query);
		
		$this->canMove1 = $this->canMove2 = $this->canMove();

		$game->statusFlags = 0;
		if ($this->canMove1)
			$game->statusFlags += FLAG_CANMOVE_1;  
		if ($this->canMove2)
			$game->statusFlags += FLAG_CANMOVE_2;
		$db->query_write("
			UPDATE gameroom_board_game 
			SET statusFlags = $game->statusFlags 
			WHERE gameID = $game->gameID
		"); 
		$game->validMoveStatus = true;
		if ($this->myColor == 1)
			$this->canMove = $this->canMove1;
		else
			$this->canMove = $this->canMove2;
		
		if (! $this->canMove1)
			$this->endGame();
	}
	

	function endGame($userID)
	{
		global $db, $game, $language, $user;

		$game->setWinner($userID);
		if ($userID)
			$game->systemMsg($user->userName . " " . $language['boardgame']['Wins'], $language['boardgame']['System_Name']);
		else
			$game->systemMsg($language['boardgame']['Draw'], $language['boardgame']['System_Name']);
			
	}
	
	
	function placePiece($x)
	{
		global $db, $user;

		$y = $this->numRows;
		while ($y >= 1)
		{
			if ($this->checkSquare($x, $y) == 0)
				break;
			$y--;
		}
		if ($y == 0)
			return false;
		
		// place peice at $x, $y
		$i = (($y - 1) * $this->numCols) + $x;
		$this->board[$i] = $this->myColor;
		$query = "
			UPDATE gameroom_chess_pieces
			SET pieceID = $this->myColor
			WHERE boardID = $i
			AND gameID = $this->gameID
		";
		$db->query_write($query);
					
		$emptySpace = false;
		
		for ($x = 1; $x <= $this->numCols; $x++)
			for ($y = 1; $y <= $this->numRows; $y++)
			{
				$p = $this->checkSquare($x, $y);
				if ($p == $this->myColor)
					$wonGame += $this->runWithIt($x, $y, $this->myColor);
				else if ($p == 0)
					$emptySpace = true;
					
				if ($wonGame)
					break 2;
			}
			
		if ($wonGame) 
			$this->endGame($user->userID);
		else if (! $emptySpace)
			$this->endGame(0);
		else
			$this->nextTurn();
		
		return true;
	}

	
	
	function runWithIt($x, $y, $myColor)
	{
		global $db;
		$done = 0;
		$count = 0;
		
		for ($yd = -1; $yd < 2; $yd++)
			for ($xd = -1; $xd < 2; $xd++)
			{
				$s = "";
				if (abs($xd) + abs($yd) > 0)
				{
					$i = 1;
					while (($this->checkSquare($x + ($xd * $i), $y + ($yd * $i)) == $myColor) && ($i < 7))
					{
//						echo "  $x + ($xd * $i)  $y + ($yd * $i)  $myColor <br> ";
						$i++;
					}
				}
				if ($i > 3)
					$done = 1;
				if (isset($_GET['test2']))
					echo "$x, $y - $i ($done)<br>";
			}
				
		return $done;
	}
	
	
	function canMove()
	{
		$move = 0;
		foreach ($this->board as $p)
		{
			if ($p == 0)
				return true;
		}
		return false;
	}
}
?>