<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/



class blackJackHand
{
	var $canSplit = 0, $canDoubleDown = 0, $isDone = 0, $canSurrender = 0;
	var $total = 0, $bet = 0;
	var $handResult, $resultText = "";
	var $handID;
	var $numCards;
	var $blackjack, $bust, $charlie, $showTotal;
	var $cardsXML;
	
	function getHand()
	{
		global $db, $user;
		
	
		// reset all variables
		$this->total = $this->numCards = $this->canSplit = $this->canDoubleDown = $this->isDone = $this->bet = 
			$this->blackjack = $this->bust = $this->charlie = $this->showTotal = $this->canSurrender = 0;
		$this->cardsXML = "";

		$this->getBet();
		
		$query = "
			SELECT * 
			FROM gameroom_blackjack 
			WHERE playerID=$user->userID 
			AND hand = $this->handID 
			ORDER BY cardNum
		";
		$this->handResult = $db->query_read($query);
		$this->numCards = 0;
		while($row = $db->fetch_array($this->handResult)) 
		{
			$this->numCards++;
			if($row['total'])
				$this->isDone = 1;
		}
		$this->getTotal();
		
		if(! $isDone)
		{
			$this->getCanDoubleDown();
			$this->getCanSplit();
			$this->getCanSurrender();
		}
		
	}
	
	function getTotal()
	{
		global $db, $user, $blackjack;

		$total = 0;
		$aces = 0;
		$cards = 0;
		$db->data_seek($this->handResult, 0);
		while($row = $db->fetch_array($this->handResult)) 
		{
			$cards++;
			$s = floor($row['card'] % 13) + 2;

			if($s<11)$total += $s; // # card
			else if($s==11)$total += 10; // Jack
			else if($s==12)$total += 10; //Queen
			else if($s==13)$total += 10; //King
			else if($s==14){$total += 11;$aces++;} //Ace
			
			while (($aces > 0)&&($total > 21))
			{
				$total -= 10;
				$aces--;
			}
		}
		if(($total == 21) && ($cards == 2))
		{
			$this->blackjack = 1;
			$this->isDone = 1;
//			if($this->handID == 1)
				//$this->blackjack->hands[2].stay();
				
		}
		if(($total < 22) && ($cards == 5))
		{
			$this->charlie = 1;
			$this->isDone = 1;
		}
		if($total > 21)
		{
			$this->bust = 1;
			$this->isDone = 1;
		}
		if($total == 21)
		{
			$this->isDone = 1;
		}
		$this->total = $total; 
	}
	
	
	// done
	function getCanSplit()
	{
		global $db, $user;
	
		$i = 0;
		
		$db->data_seek($this->handResult, 0);
		while($row = $db->fetch_array($this->handResult))
		{ 
			$s = ($row['card'] % 13)+2;
			
			if($s < 11)
				$v[$i] = $s; // # card
			else if($s == 11)
				$v[$i] = 10; // Jack
			else if($s == 12)
				$v[$i] = 10; //Queen
			else if($s == 13)
				$v[$i] = 10; //King
			else if($s == 14)
				$v[$i] = 11; //Ace
			$i++;		
		}
		if (($i == 2) && ($v[0] == $v[1]) && ($user->cash >= $this->bet) && ($this->handID > 1) && (! $this->isDone))
			$this->canSplit =  1;
		else
			$this->canSplit =  0;
	}
	
	function getCanDoubleDown()
	{
		global $user;
		if (($this->numCards == 2) && ($user->cash >= $this->bet) && ($this->handID > 1) && (! $this->isDone))
			$this->canDoubleDown = 1;
		else
			$this->canDoubleDown = 0;
		
	}

	function getCanSurrender()
	{
		global $user, $blackjack, $db;
		
		if (($this->numCards == 2)  && ($this->handID > 1) && (! $this->isDone) && ($this->bet > 1))
		{
			$query = "
				SELECT MAX(hand) AS h
				FROM gameroom_blackjack 
				WHERE playerID=$user->userID
			";
			$result = $db->query_read($query);
			$row = $db->fetch_array($result);
			if ($row['h'] > 2)
				$this->canSurrender = 0;
			else
				$this->canSurrender = 1;
		}
		else
			$this->canSurrender = 0;
		
	}
	
	function stay()
	{
		global $db, $user, $blackjack;
		
		$query = "
			UPDATE gameroom_blackjack 
			SET total = $this->total 
			WHERE hand = $this->handID 
			AND playerID = $user->userID
		";		
		$db->query($query);
		$this->isDone = 1;
		$this->getHand();
		$blackjack->getHands();
	}
	
	function surrender()
	{
		global $db, $user, $blackjack;
		$blackjack->didSurrender = true;
		$query = "
			UPDATE gameroom_blackjack 
			SET total = $this->total 
			WHERE hand = $this->handID 
			AND playerID = $user->userID
		";		
		$db->query($query);
		$this->isDone = 1;
		$this->getHand();
		$blackjack->getHands();
	}
	
	function hit()
	{
		global $db, $user;

		$query = "SELECT * FROM gameroom_blackjack WHERE playerID=$user->userID AND hand = 0 ORDER BY cardNum LIMIT 1";
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		
		$card = $row['cardNum'];

		$query = "
			UPDATE gameroom_blackjack 
				SET hand = $this->handID, 
				bet = $this->bet 
			WHERE cardNum = $card 
			AND playerID = $user->userID
		";		
		$db->query_write($query);

		$this->getTotal();
		if(abs($this->total) >= 21)
		{
			$query = "
				UPDATE gameroom_blackjack 
				SET total = $this->total 
				WHERE hand = $this->handID
				AND playerID = $user->userID
			";		
			$db->query_write($query);
			$this->isDone = 1;
		}
		$this->getHand();
	}
	
	function doubleDown()
	{
		global $db, $user, $blackjack;
		
		$query = "SELECT * FROM gameroom_blackjack WHERE playerID=$user->userID AND hand = 0 ORDER BY cardNum LIMIT 1";
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		
		$card = $row['cardNum'];
		$user->bet = $this->bet;
		
		$query = "UPDATE gameroom_blackjack SET hand = $this->handID, bet = bet + $user->bet WHERE cardNum = $card AND playerID = $user->userID";		
		$db->query($query);

		$this->getTotal();
		$query = "UPDATE gameroom_blackjack SET total = $this->total WHERE hand = $this->handID AND playerID = $user->userID";		
		$db->query($query);

		$user->record_cash($blackjack->gameID, $this->bet * -1);		
		$query = "UPDATE gameroom_blackjack SET bet = bet + $user->bet WHERE hand = $this->handID AND playerID = $user->userID";		
		$db->query($query);
		$this->bet = $user->bet * 2;
		
		$this->getHand();
		
		
	}

	function split()
	{
		global $user, $db, $blackjack;

		// Get card # 
		$query = "
			SELECT * 
			FROM gameroom_blackjack 
			WHERE playerID=$user->userID 
			AND hand = $this->handID 
			ORDER BY cardNum DESC 
			LIMIT 1
		";
			
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		
		$card = $row['cardNum'];
		$bet = $row['bet'];
		
		// Get next avail hand #		
		$query = "
			SELECT max(hand) AS hand 
			FROM gameroom_blackjack 
			WHERE playerID=$user->userID 
		";
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		
		$h2 = $row['hand'] +1;
		
		// Move card to new hand
		
		$query = "
			UPDATE gameroom_blackjack 
			SET hand = $h2, bet=$bet 
			WHERE cardNum = $card 
			AND playerID = $user->userID
		";		
		$db->query($query);
		
		// New for first hand 
		$query = "SELECT * FROM gameroom_blackjack WHERE playerID=$user->userID AND hand = 0 ORDER BY cardNum";
		$result = $db->query_read($query);
		$row = $db->fetch_array($result);
		
		$card = $row['cardNum'];
		
		$query = "UPDATE gameroom_blackjack SET hand = $this->handID, bet = $this->bet WHERE cardNum = $card AND playerID = $user->userID";		
		$db->query_write($query);
		
		// New for 2nd hand 
		$row = $db->fetch_array($result);
		$card = $row['cardNum'];
		
		$query = "UPDATE gameroom_blackjack SET hand = $h2, bet = $this->bet WHERE cardNum = $card AND playerID = $user->userID";		
		$db->query_write($query);		

		$user->record_cash($blackjack->gameID, $this->bet * -1);

		// hand has changed, rebuild
		$this->getHand();
	}
	
	function getBet()
	{
		global $user, $db;
				
		$query = "
			SELECT MAX(bet) AS bet 
			FROM gameroom_blackjack 
			WHERE playerID=$user->userID 
			AND hand = $this->handID
		";
		$totals = $db->query_read($query);
		$total = $db->fetch_array($totals);
		$this->bet = $total['bet'];
		
	}
	function getCardsXML()
	{
		global $db, $user, $blackjack;
		$this->cardsXML = "";
		if($this->handID > 1)
			$name = $user->userName;
		else
			$name = "Dealer";
		
		$db->data_seek($this->handResult, 0);
		if((! $this->isDone) && ($this->handID > 1))
			$active = 1;
		else
			$active = 0;
		$deal = 0;
		if(($this->handID == 2) && (($blackjack->hands[1]->isDone)  || ($this->resultText)))
			$deal = 1;
			
		$total = $this->total;
		
		if(($this->handID == 1) && (!$this->isDone))
			$total = "N/A";
		
		if ($deal)
		{
			// dealer blackjack
			$this->canHit = 0;
			$this->canSplit = 0;
			$this->canDoubleDown = 0;
			$this->canSurrender = 0;
			$active = 0;
			$blackjack->isDone = 1;
		}
		$this->cardsXML = "
			<hand id='$this->handID' hit='$active' stay='$active' split='$this->canSplit' doubledown='$this->canDoubleDown' surrender='$this->canSurrender' deal='$deal' name='$name' total='$total' resultText='$this->resultText'>
		";
		$i = 0;
		while($row = $db->fetch_array($this->handResult))
		{
			$card = $blackjack->evalCard($row['card']);
			if(($this->handID == 1) && (!$this->isDone) && ($i == 0))
				$this->cardsXML .= "<card img='gameroom/images/back-blue-150-1.png' name='' />\n";
			else
				$this->cardsXML .= "<card img='" . $card['cardFile'] . "' name='" . $card['cardName'] . "' />\n";
			$i++;
		}
		$this->cardsXML .= "</hand>";
	}

	function autoPlay()
	{
		// dealer
		global $db, $user, $blackjack;
		
		$query = "
			SELECT * 
			FROM gameroom_blackjack WHERE 
			playerID=$user->userID 
			AND hand = 0 
			ORDER BY cardNum 
		";
		$result = $db->query_read($query);

		while ($this->total < 17)
		{
			$row = $db->fetch_array($result);
			$card = $row['cardNum'];
	
			$query = "
				UPDATE gameroom_blackjack 
				SET hand = 1 
				WHERE cardNum = $card 
				AND playerID = $user->userID
			";		
			$db->query($query);
			$this->getHand();
			$this->getTotal();
		}
		//$this->stay();
		$this->isDone = 1;
	}

	function didWin()
	{
		// Ret =  1 if player won, 0 if dealer won, -1 for push 
		global $db, $user, $blackjack, $language;
	
	 
		if($blackjack->didSurrender)
		{
			$ret= 0;
			$this->resultText = $language['blackjack']['Surrender'];
		}
		else if($this->charlie)
		{
			$ret= 1;
			$this->resultText =  $language['blackjack']['Five_Card'];
		}
		else if(($this->blackjack) && (! $blackjack->hands[1]->blackjack))
		{
			$ret= 1;
			$this->resultText = $language['blackjack']['BlackJack'];
		}
		else if(($this->blackjack) && ($blackjack->hands[1]->blackjack))
		{
			$ret= 0;
			$this->resultText = $language['blackjack']['Lose'];
		}
		else if($this->bust)
		{
			$ret= 0;
			$this->resultText = $language['blackjack']['Lose'];
		}
		else if($this->total == $blackjack->hands[1]->total)
		{
			$ret= -1;
			$this->resultText = $language['blackjack']['Push'];
		}
		else if($blackjack->hands[1]->bust)
		{
			$ret= 1;
			$this->resultText = $language['blackjack']['Win'];
		}
		else if($this->total > $blackjack->hands[1]->total)
		{
			$ret= 1;
			$this->resultText = $language['blackjack']['Win'];
		}
		else
		{
			$ret= 0;
			$this->resultText = $language['blackjack']['Lose'];
		}
			
		$w = 0;
		

		if(($ret == 1) && ($this->blackjack)) 
			$w = round($this->bet * 2.5); // Win w/ Blackjack
		else if($ret == 1)
			$w = $this->bet * 2;	//Win 
		else if( $ret == -1) 
			$w = $this->bet;	//Push
		else if ($blackjack->didSurrender)
			$w = floor($this->bet * .5);
		
		if($w > 0)
			$user->record_cash($blackjack->gameID, $w);
	}
	
}


class blackjack extends casinoGame
{
	var $statusXML, $handsXML, $hands, $chips, $isDone, $numHands, $gameID, $didSurrender = false;
	
	function init()
	{
		global $settings;
		$this->gameID = GAMEID_BLACKJACK;
		$this->tableLimit = $settings->blackjack['tableLimit']; 
		$this->gameCode = "blackjack";
		$this->chipsUsed = $settings->blackjack['chipsUsed'];
		
		$this->initGame();		
	}
	
	function deal()
	{
		global $db, $user;
		
		if(is_numeric($_GET['bet']))
			$this->bet = $_GET['bet'] * 1;
				
		if (($this->bet > $user->cash) || ($this->bet > $this->tableLimit) || ($this->bet == 0))
		{
			exit();
		}

		// Prep and Shuffle 6-decks
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		
		
		srand((float)microtime() * 1000000);
		shuffle($card);

		$query = "DELETE FROM gameroom_blackjack WHERE playerID = $user->userID";
		$db->query($query);

		// 2 for the dealer 
		for($i = 0; $i < 2; $i++) {
			$query = "INSERT INTO gameroom_blackjack (playerID, cardNum, card, hand, bet) values ($user->userID, $i, $card[$i], 1, 0)";  
			$db->query($query);
		}
		// 2 for the player
		for($i = 2; $i < 4; $i++) {
			$query = "INSERT INTO gameroom_blackjack (playerID, cardNum, card, hand, bet) values ($user->userID, $i, $card[$i], 2, $this->bet)";  
			$db->query($query);
		}
		// Load the rest into the reserve 
		for($i = 4; $i < 52; $i++) {
			$query = "INSERT INTO gameroom_blackjack (playerID, cardNum, card, hand, bet) values ($user->userID, $i, $card[$i], 0, 0)";  
			$db->query($query);
		}

//Check player BJ
//Check Dealer BJ

		//Remove Bet amount from cash

		$user->record_cash($this->gameID, $this->bet * -1);
		$this->getHands();
	}
	
	function isGameOver()
	{
		global $db, $user;

		

		if ($this->isDone)
		{
			return 0;
		}
		else
		{
			$this->isDone = 1;
			$dealer->autoPlay();
		}
		
	}
	
	function userAction()
	{
		global $user, $db;
			
		$id = $_GET['id'];
		if (($_GET['bet']>0) && ($_GET['action']=="deal"))
		{
			$this->deal();
		}
		else if ($_GET['action']=="hit")
		{
			// Hit 
			$this->hands[$id]->hit();
		}
		else if ($_GET['action']=="stay")
		{
			// Stay
			$this->hands[$id]->stay();
		}
		else if ($_GET['action']=="doubledown")
		{
			// Double Down 
			$this->hands[$id]->doubleDown();
		}
		else if ($_REQUEST['action']=="split")
		{
			// Split 
			//add one to # of hands 
			$this->hands[$id]->split();
		}
		else if ($_REQUEST['action']=="surrender")
		{
			// Split 
			//add one to # of hands 
			$this->hands[$id]->surrender();
		}
		
	}
		function show_status()
		{
			global $user;
			
			$this->statusXML = "<status tableLimit='$this->tableLimit' cash='$user->cash' bet='$this->bet'  resultText='' chips='$this->isDone' />\n";

		}
		
		function getHands()
		{
			global $db, $user;
		
			$this->isDone = 0;
			$this->hands = array();
			$query = "
				SELECT DISTINCT(hand)
				FROM gameroom_blackjack 
				WHERE playerID=$user->userID
				AND hand > 0 
				ORDER BY hand
			";
			$result = $db->query_read($query);
			$i =0 ;
			$this->handsXML ="";
			$notDone  = 0;
			while($row = $db->fetch_array($result))
			{
				$id = $row['hand'];
				$this->hands[$id] = new blackJackHand;
				$this->hands[$id]->handID = $row['hand'];
				$this->hands[$id]->getHand();
				$this->hands[$id]->getCardsXML();
				$this->handsXML .= $this->hands[$id]->cardsXML;
				if(!$this->hands[$id]->isDone && $id > 1)
					$notDone = 1;
				$i++;
			}
			if(! $notDone){
				$this->isDone = 1;
			}
				
			$this->numHands = $i;
			if($i == 0)
				$this->loadBlank();
				
		}
	
		function loadBlank()
		{
			$this->handsXML = "
			<hand id='0' hit='0' stay='0' split='0' doubledown='0' deal='0' name='" . $language['blackjack']['Dealer'] . "'>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			</hand>
			<hand id='0' hit='0' stay='0' split='0' doubledown='0' deal='1' name='" . $language['blackjack']['Player'] . "'>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			</hand>
			";
		}
		
		function settle()
		{
			global $db, $user;
			$this->handsXML = "";

			foreach ($this->hands as $id => $tHand)
			{	
				if($id > 1)
					$this->hands[$id]->didWin();
				else
					$this->hands[$id]->autoPlay();
				
				$this->hands[$id]->getCardsXML(); 
				$this->handsXML .= $this->hands[$id]->cardsXML;
			}
			$query = "
				DELETE FROM gameroom_blackjack 
				WHERE playerID=$user->userID
			";
			$db->query_write($query);
			$this->bet = 0;
		}

		function getCardValuesXML()
		{
			global $language;
			$xml = "<cardValue field1='2' field2='2' />";
			$xml .= "<cardValue field1='3' field2='3' />";
			$xml .= "<cardValue field1='4' field2='4' />";
			$xml .= "<cardValue field1='5' field2='5' />";
			$xml .= "<cardValue field1='6' field2='6' />";
			$xml .= "<cardValue field1='7' field2='7' />";
			$xml .= "<cardValue field1='8' field2='8' />";
			$xml .= "<cardValue field1='9' field2='9' />";
			$xml .= "<cardValue field1='" . $language['cards']['Jack'] . "' field2='10' />";
			$xml .= "<cardValue field1='" . $language['cards']['Queen'] . "' field2='10' />";
			$xml .= "<cardValue field1='" . $language['cards']['King'] . "' field2='10' />";
			$xml .= "<cardValue field1='" . $language['cards']['Ace'] . "' field2='1 / 11' />";
			return $xml;
		}
}



//======================================================



// =====================================================
	$user = new userInfo;
	$user->user_info();
	$blackjack = new blackjack;


	$blackjack->init();
	$blackjack->getHands();
	$blackjack->userAction();
	$blackjack->getHands();
	if(($blackjack->isDone) && ($blackjack->numHands > 0))
		$blackjack->settle();
	
	$blackjack->show_status();
	$blackjack->get_chips();
	
	$output = "
		<root>
			$blackjack->chipsXML
			$blackjack->handsXML
			$blackjack->statusXML
			$blackjack->languageXML
			" . $blackjack->getCardValuesXML() . "
		</root>
	";
	printGameroomOutput( $output);


?>