<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

	// table rules
	define("RULES_TEXASHOLDEM", 1);
	define("RULES_5CARDDRAW", 2);
	define("RULES_7CARDSTUD", 3);
	
	// table betting structure
	define("BETTING_FIXED", 1);
	define("BETTING_SET", 2);
	define("BETTING_NOLIMIT", 3);
	define("BETTING_POT", 4);
	
	define (GAMETYPE_CHESS, 1);
	define (GAMETYPE_REVERSI, 2);
	define (GAMETYPE_CONNECT4, 3);
	
	require("language.php");

	function getFlashBanner()
	{
		global $db, $language;
		eval('$gameroomBanner = "' . fetch_template('gameroom_flash_banner') . '";');
	 	return $gameroomBanner;
	}

	function getBanner()
	{
		global $db, $language;
		$linkTitle =  $language['common']['title'];
		$events = getOpenEvents();
		$callouts = getCallOuts();
		$poker = getPokerGames();
		$boardgames = getBoardGames();
		
	 	if (strlen($callouts) > 3)
	 	{
	 		$numCols++;
	 		$text = $callouts;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}
	 	if (strlen($poker) > 3)
	 	{
	 		$numCols++;
	 		$text = $poker;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}
	 	if (strlen($boardgames) > 3)
	 	{
	 		$numCols++;
	 		$text = $boardgames;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}
	 	if ($events != "0")
	 	{
	 		$numCols++;
	 		$text = $events;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}
	 	
	 	
	 	if ($numCols == 0)
	 	{
	 		if ($language['banner']['Default_Text'])
	 		{
	 			$text = $language['banner']['Default_Message'];
				eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 		}
	 		else 
	 			return "";
	 		
	 	}
	 	
	 	eval('$gameroomBanner = "' . fetch_template('gameroom_html_status_box') . '";');
	 	return $gameroomBanner;
	}
	 	
	function getOpenEvents()
	{
		global $db, $language;
		$time = time() - 60 * 3;
		
		$query = "
			SELECT COUNT(*) AS c
			FROM gameroom_sb_events
			WHERE eventdate > $time
			AND result IS NULL
		";
		$result = $db->query_read($query);
		if ($row = $db->fetch_array($result))
		{
			$output = $row['c'];
			
			if ($output == 1)
				$output = $language['banner']['There_Is'] . " $output " . $language['banner']['Open_Event'];
			else if ($output > 0)
				$output = $language['banner']['There_Are'] . " $output " . $language['banner']['Open_Events'];

			$output = $output;
		}
		else
			$output = "0";
		
		return $output;
	}

	function getCallOuts()
	{
		global $db;
		$time = time() - 60 * 3;
		
		$query = "
			SELECT *
			FROM gameroom_banner_msgs
			WHERE msgtime > $time
			ORDER BY msgTime DESC
			LIMIT 5
		";
		$result = $db->query_read($query);
		$output = "";
			
		while ($row = $db->fetch_array($result))
		{
			if ($output == "")
				$output = $row['msg'];
			else
				$output .= "<br/>" . $row['msg'];
		}
		return $output;
	}
	
	function getPokerGames()
	{
		global $db, $user, $language;
		
		$query = "
			SELECT gameroom_poker_game.*, COUNT(gameroom_poker_players.id) AS numPlayers
			FROM gameroom_poker_game 
			LEFT JOIN gameroom_poker_players ON gameroom_poker_players.gameID = gameroom_poker_game.gameID
			WHERE  gameroom_poker_players.id > 0
			GROUP BY gameroom_poker_players.gameID
			ORDER BY numPlayers DESC
		";
		$result = $db->query_read($query);
		$output = "";
		
		while($row = $db->fetch_array($result))
		{
			if($row['betting'] == BETTING_NOLIMIT)
				$rules = $language['poker']['No_Limit'];
			else if($row['betting'] == BETTING_FIXED)
				$rules = $language['poker']['Limit'];
			else if($row['betting'] == BETTING_POT)
				$rules = $language['poker']['Pot_Limit'];
			
			if ($row['rules'] == RULES_TEXASHOLDEM)
				$game = $language['poker']['Texas_Holdem']; 
			else if ($row['rules'] == RULES_7CARDSTUD)
				$game = $language['poker']['Seven_Card_Stud']; 
			
			if ($output == "")
				$output .= base64_decode($row['name']) . " - " . $rules . " " .  $game . " - (" . $row['numPlayers'] . " / " . $row['maxPlayers'] . ")";
			else 
				$output .= "<br/>" . base64_decode($row['name']) . " - " . $rules . " " . $game . " - (" . $row['numPlayers'] . " / " . $row['maxPlayers'] . ")"; 
		}
		return $output;
	}

	function getBoardGames()
	{
		global $user, $db, $language;

		$query = "
			SELECT gameroom_board_game.gameID, chatID, gameName, gameroom_board_game.maxPlayers, playerName, timeControl, timeRules, ranked, rank, password, gameroom_board_game.gameType
			FROM gameroom_board_game
			LEFT JOIN gameroom_board_game_players ON gameroom_board_game.gameID = gameroom_board_game_players.gameID
			LEFT JOIN gameroom_rank ON gameroom_rank.gameType = gameroom_board_game.gameType AND gameroom_rank.userID = gameroom_board_game_players.playerID
			WHERE gameroom_board_game.winner IS NULL
		";
		$result = $db->query_read($query);
		
		$output = "";

		$lastID = 0;
		while ($row = $db->fetch_array($result))
		{
			if (($row['gameID'] == $lastID) && ($numPlayers > 0))
			{
				$numPlayers++;
				$playerNames .= " vs " . $row['playerName'];
			}
			else
			{
				if ($lastID > 0)
				{
					if ($gameType == GAMETYPE_CHESS)
						$gameName = $language['chess']['nameChess'];
					else if ($gameType == GAMETYPE_REVERSI)
						$gameName = $language['reversi']['Reversi'];
					else if ($gameType == GAMETYPE_CONNECT4)
						$gameName = $language['fourinarow']['Four_In_A_Row'];
						
					$players = $numPlayers . " / " . $maxPlayers;
					if ($output == "")
						$output .= $name . " - " . $gameName . " - (" . $players . ")";
					else
						$output .= "<br/>" . $name . " - " . $gameName . " - (" . $players . ")";
				}
				if ($row['playerName'] != null)
					$numPlayers = 1;
				else $numPlayers = 0;
						
				$lastID = $row['gameID'];
				$maxPlayers = $row['maxPlayers'];
				$name = $row['gameName'];
 				$gameType = $row['gameType'];
			}
		}
		$players =  $numPlayers . " / " . $maxPlayers;
		if ($lastID)
		{
			if ($gameType == GAMETYPE_CHESS)
				$gameName = $language['chess']['Chess'];
			else if ($gameType == GAMETYPE_REVERSI)
				$gameName = $language['reversi']['Reversi'];
			else if ($gameType == GAMETYPE_CONNECT4)
				$gameName = $language['fourinarow']['Four_In_A_Row'];
				
			if ($output == "")
				$output .= $name . " - " . $gameName . " - (" . $players . ")";
			else
				$output .= "<br/>" . $name . " - " . $gameName . " - (" . $players . ")";
		}
		return $output;		
	}

	
?>