<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

class banner
{
	function getBanner()
	{
		global $language;
		$output = $this->getPokerGames();
		$output .= $this->getBoardGames();
		$output .= $this->getCallOuts();
		$output .= $this->getOpenEvents();
		$themeColour = $this->getThemeColour();
		return "<root title='" . $language['banner']['Title']  . "' themeColor='$themeColour'>" . $output . "</root>";
	}
	
	function getThemeColour()
	{
		global $db;
		
		$query = "
			SELECT value
			FROM gameroom_settings
			WHERE setting = 'themeColor'
		";
		$result = $db->query_read($query);
		if ($row = $db->fetch_array($result))
			return $row['value'];
		else
			return 10066329;
		
	}
		
	function getBannerHTML()
	{
		global $language;
		$poker = $this->getPokerGames(1);
		$boardGames .= $this->getBoardGames(1);
		$callouts .= $this->getCallOuts(1);
		$events = $this->getOpenEvents(1);

		$linkTitle =  $language['common']['title'];
	 	$numCols = 0;
	 	$bannerCells = "";
	 	if (strlen($callouts) > 3)
	 	{
	 		$numCols++;
	 		$text = $callouts;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}
	 	if (strlen($poker) > 3)
	 	{
	 		$numCols++;
	 		$text = $poker;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}
	 	if (strlen($boardGames) > 3)
	 	{
	 		$numCols++;
	 		$text = $boardGames;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}
	 	if ($events != "0")
	 	{
	 		$numCols++;
	 		$text = $events;
			eval('$bannerCells .= "' . fetch_template('gameroom_html_status_box_cell') . '";');
	 	}

	 	if ($numCols == 0)
	 		return "";
	 	
	 	eval('$banner = "' . fetch_template('gameroom_html_status_box') . '";');
		return $banner;
	}
	
	function getPokerGames($html=false)
	{
		require_once('gameroom/class_poker.php');
		$poker = new poker;
		$poker->dropInactivePlayers();
		$output = $poker->getActiveGames(1);
		if ($html)
			return $output;
		else
		{
			$output = substr($output, 6, strlen($output) - 13);
			return "<poker>" . $output . "</poker>";
		}
	}
	
	function getBoardGames($html=false)
	{
		require_once('gameroom/class_boardgame.php');
		$boardGames = new boardGame;
		$output = $boardGames->getGames($html);
		if (! $html)
		{
			$output = substr($output, 6, strlen($output) - 13);
			return "<boardGame>" . $output ."</boardGame>\n";
		}
		else
			return $output;
	}
	
	function getCallOuts($html=false)
	{
		global $db;
		$time = time() - 60 * 3;
		
		$query = "
			SELECT *
			FROM gameroom_banner_msgs
			WHERE msgtime > $time
			ORDER BY msgTime DESC
			LIMIT 5
		";
		$result = $db->query_read($query);
		if ($html)
			$output = "";
		else
			$output = "<callouts>\n";
			
		while ($row = $db->fetch_array($result))
		{
			if ($html)
			{
				if ($output == "")
					$output = $row['msg'];
				else
					$output .= "<br/>" . $row['msg'];
			}
			else
				$output .= "<callout msg='" . $row['msg'] . "' />\n";
		}
		if (! $html)
			$output .="</callouts>\n";
		return $output;
	}
	
	function getOpenEvents($html=false)
	{
		global $db, $language;
		$time = time() - 60 * 3;
		
		$query = "
			SELECT COUNT(*) AS c
			FROM gameroom_sb_events
			WHERE eventdate > $time
			AND result IS NULL
		";
		$result = $db->query_read($query);
		if ($row = $db->fetch_array($result))
		{
			$output = $row['c'];
			
			if ($output == 1)
				$output = $language['banner']['There_Is'] . " $output " . $language['banner']['Open_Event'];
			else if ($output > 0)
				$output = $language['banner']['There_Are'] . " $output " . $language['banner']['Open_Events'];

			if ($html)
				$output = $output;
			else
				$output = "<events openEvents='$output' />";
		}
		else
			$output = "0";
		
		return $output;
	}
}
?>