<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/


define(ERROR_INCHECK, 1);
define(FLAG_CASTLE_LEFT, 1);
define(FLAG_CASTLE_RIGHT, 2);
define(FLAG_CASTLE_BOTH, 3);

class chessGame
{
	var $myColor, $myTurn, $error = 0, $pageXML, $gameID, $whosTurn;
	var $check1, $check2, $canMove1, $canMove2;
	
	var $parent;
	
	function init()
	{
		global $user, $db, $game, $language, $settings;
		
		$page .= $game->getPlayerList();
		
		
		$selectedx  = $_GET['sx'];
		$selectedy  = $_GET['sy'];
	
		$destx  = $_GET['dx'];
		$desty  = $_GET['dy'];
	
		if ($this->myColor == 2)
		{
			$selectedx  = 9 - $selectedx;
			$selectedy  = 9 - $selectedy;
	
			$destx  = 9 - $destx;
			$desty  = 9 - $desty;
		}
	
		$this->piecenames = array();
	
		$this->pieceNames[1] = $language['chess']['Black'] . "  " . $language['chess']['Pawn'];
		$this->pieceNames[2] = $language['chess']['White'] . "  " . $language['chess']['Pawn'];
		$this->pieceNames[3] = $language['chess']['Black'] . "  " . $language['chess']['Rook'];
		$this->pieceNames[4] = $language['chess']['White'] . "  " . $language['chess']['Rook'];
		$this->pieceNames[5] = $language['chess']['Black'] . "  " . $language['chess']['Knight'];
		$this->pieceNames[6] = $language['chess']['White'] . "  " . $language['chess']['Knight'];
		$this->pieceNames[7] = $language['chess']['Black'] . "  " . $language['chess']['Bishop'];
		$this->pieceNames[8] = $language['chess']['White'] . "  " . $language['chess']['Bishop'];
		$this->pieceNames[9] = $language['chess']['Black'] . "  " . $language['chess']['Queen'];
		$this->pieceNames[10] = $language['chess']['White'] . "  " . $language['chess']['Queen'];
		$this->pieceNames[11] = $language['chess']['Black'] . "  " . $language['chess']['King'];
		$this->pieceNames[12] = $language['chess']['White'] . "  " . $language['chess']['King'];
		
		$this->pieceImages = array();
	
		$this->pieceImages[1] = 'gameroom/images/pawn-b.png';
		$this->pieceImages[2] = 'gameroom/images/pawn-w.png';
		$this->pieceImages[3] = 'gameroom/images/rook-b.png';
		$this->pieceImages[4] = 'gameroom/images/rook-w.png';
		$this->pieceImages[5] = 'gameroom/images/knight-b.png';
		$this->pieceImages[6] = 'gameroom/images/knight-w.png';
		$this->pieceImages[7] = 'gameroom/images/bishop-b.png';
		$this->pieceImages[8] = 'gameroom/images/bishop-w.png';
		$this->pieceImages[9] = 'gameroom/images/queen-b.png';
		$this->pieceImages[10] = 'gameroom/images/queen-w.png';
		$this->pieceImages[11] = 'gameroom/images/king-b.png';
		$this->pieceImages[12] = 'gameroom/images/king-w.png';
		
	
	
		$this->board= array();
		
		$query = "SELECT * FROM gameroom_chess_pieces WHERE gameid = $this->gameID ORDER BY boardid";
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			$i = $row['boardID'];
			$this->board[$i] = $row['pieceID'];
		}
	
		if ($this->myColor == $this->whosTurn)
		{
			$this->myTurn = "true";
			if  (($selectedx != $destx) || ($selectedy != $desty))
			{
				$game->validMoveStatus = false;
				$this->allowedMoves($selectedx, $selectedy, $destx, $desty);
			}
		}
		else
			$this->myTurn = "false";
		
		if ((! $game->validMoveStatus) || (($game->winner == null) && ($game->statusFlags == 0)))
		{
			$this->check1 = $this->inCheck(1, $this->board);
			$this->check2 = $this->inCheck(2, $this->board);
			$this->canMove1 = $this->canMove(1);
			$this->canMove2 = $this->canMove(2);
			
			// log move status
			$game->validMoveStatus = 0;
			if ($this->canMove1)
				$game->validMoveStatus += FLAG_CANMOVE_1;
			if ($this->canMove2)
				$game->validMoveStatus += FLAG_CANMOVE_2;
			if ($this->check1)
				$game->validMoveStatus += FLAG_INCHECK_1;
			if ($this->check2)
				$game->validMoveStatus += FLAG_INCHECK_1;
			$db->query_write("
				UPDATE gameroom_board_game 
				SET statusFlags = $game->statusFlags 
				WHERE gameID = $game->gameID
			"); 
			$game->validMoveStatus = true;
			// end move status
			
			$db->query_write("
				UPDATE gameroom_board_game 
				SET statusFlags = $game->statusFlags 
				WHERE gameID = $game->gameID
			"); 
			
		}
		else
		{
			if ($game->statusFlags & FLAG_CANMOVE_1)
				$this->canMove1 = 1;
			else
				$this->canMove1 = 0;
			if ($game->statusFlags & FLAG_CANMOVE_2)
				$this->canMove2 = 1;
			else
				$this->canMove2 = 0;
			if ($game->statusFlags & FLAG_INCHECK_1)
				$this->check1 = 1;
			else
				$this->check1 = 0;
			if ($game->statusFlags & FLAG_INCHECK_2)
				$this->check2 = 1;
			else
				$this->check2 = 0;
		}
		
		
		if ($this->myColor == 1)
		{
			$this->canMove = $this->canMove1;
			$this->check =$this->check1;
		}
		else
		{
			$this->canMove = $this->canMove2;
			$this->check =$this->check2;
		}
		
		
		//$page = "<h2>Check = $this->check<br/>Can Move = $this->canMove</h2>";
		
		//$page .= "$selectedx x $selectedy to $destx x $desty";
		if (($game->winner === "0") || ($this->winner > 0))
			$this->myTurn = "false";
		$threeFold =  $this->threeFoldRepetition();
		
		if ((($threeFold) || ($game->counter >= 50)) && ($_GET['req'] == 'draw'))
		{
			if ($threeFold)
				$game->systemMsg("Claims draw based on Threefold repetition rule.", $user->userName);
			else 
				$game->systemMsg("Claims draw based on 50-move rule.", $user->userName);
			$query = "
				UPDATE gameroom_board_game_players
				SET drawOffer = NULL 
				WHERE gameID = $game->gameID
			";
			$db->query_write($query);
			$game->setWinner(0);
		}
		else if (($threeFold) || ($game->counter >= 50))
			$forceDraw = 1;
		else 
			$forceDraw = 0;
		
		if ($game->winner)
			$game->gameStarted = 2;
		$page .= "<Board gameID='$game->gameID' forceDraw='$forceDraw' lastCap='$game->counter' threeFoldRep='$threeFold' timeControl='$game->timeControl' drawOffer='$game->drawOffer' gameStarted='$game->gameStarted' myTurn='$this->myTurn' myColor='$this->myColor' canMove='$this->canMove' canMove1='$this->canMove1' canMove2='$this->canMove2' check='$this->check' check1='$this->check1' check2='$this->check2' noOpponent='$game->gameOverAlone' timeOut='$game->timeOutWarning'>\n";
	//	$page .= "<gridRow>\n";
		
		for ($y = 1; $y < 9; $y++)
		{
			for ($x = 1; $x < 9; $x++)
			{
				// set cell background
				if((($x % 2) + $y) % 2) 
					$c = $settings->chess['dark_color'];
				else 
					$c = $settings->chess['light_color'];
				
				$v = ($y-1) * 8 + $x;
	
				if($this->myColor == 2)
					$v = 65 - $v;
					
				$s = 0;
				if($this->board[$v] > 0){
					$p = $this->board[$v];
					$pname = $this->pieceNames[$p];
					$pImg = $this->pieceImages[$p];
					
					if(($p % 2 == 1) && ($this->myColor == 2))
						$mine = "1";
					else if(($p % 2 == 0) && ($this->myColor == 1))
						$mine = "1";
					else
						$mine = "0";
					
					$page .= "<grid id='$p' mine='$mine' title='$pname' selected='$s' x='$x' y='$y' background='$c' backgroundColor='$c' width='59' height='53' img='$pImg' />\n";
				}
	
				else 
					$page .= "<grid title=''  mine='0' selected='$s' x='$x' y='$y' id='g$x$y' background='$c' backgroundColor='$c' width='59' height='53' img='' />\n";
			}
	//		$page .= "</gridRow>\n";
	//		if ($y < 8)
	//			$page .= "<gridRow>\n";
			
		}
		$page .= "</Board>\n";
		
		$this->pageXML = $page;
	}
	
	

	function setupBoard()
	{
		global $db, $user;
		$board = array();
		$board[1] = 3;
		$board[2] = 5;
		$board[3] = 7;
		$board[4] = 9;
		$board[5] = 11;
		$board[6] = 7;
		$board[7] = 5;
		$board[8] = 3;
		
		for($x = 9; $x < 17; $x++)
			$board[$x] = 1;
		
		for($x = 49; $x < 57; $x++)
			$board[$x] = 2;
		
		$board[57] = 4;
		$board[58] = 6;
		$board[59] = 8;
		$board[60] = 10;
		$board[61] = 12;
		$board[62] = 8;
		$board[63] = 6;
		$board[64] = 4;
		// End starting layout 
		
		$db->query_write("DELETE FROM gameroom_chess_pieces WHERE gameID = $this->gameID ");
		for($x=1;$x<65;$x++)
		{
			if(! $board[$x]) $board[$x] = 0;
			$query = "INSERT INTO gameroom_chess_pieces (gameID, boardID, pieceID) VALUES ($this->gameID, $x, $board[$x])";
			$db->query_write($query);
		}
		
	}
	
	function allowedMoves($x, $y, $x2, $y2)
	{
				
		$p = $this->checkSquare($x, $y);
		if(($p > 0) && (($p - 1) % 2 == $this->myColor % 2))
		{
			// What type of piece (if it is owned) 
			$p = floor(($p - 1) / 2) + 1;
		}
		else 
		{
			// Cannot move from a square you do not occupy 
			//echo "test ($p) ";
			return -1;
		}
	
		
		$dest = $this->checkSquare($x2, $y2);
		if(($dest > 0) && (($dest - 1) % 2 == $this->myColor % 2))
		{
			// Cannot move to a place you occupy 
			return -1;
		}
	
		switch($p)
		{
			case 1: // pawn
				$this->movePawn($p, $x, $y, $x2, $y2); 
			break;
				
			case 2: // Rook
				$this->moveRook($p, $x, $y, $x2, $y2); 
			break;
	
			case 3 : // Knight
				$this->moveKnight($p, $x, $y, $x2, $y2); 
			break;
	
			case 4: // Bishop
				$this->moveBishop($p, $x, $y, $x2, $y2); 
			break; 
							
			case 5: // Queen
				$this->moveQueen($p, $x, $y, $x2, $y2); 
			break;
							
			case 6: // King
				$this->moveKing($p, $x, $y, $x2, $y2); 
			break;
		}
	
	}
	
	function checkSquare($x, $y, $board = "")
	{
		if ($board =="" )
			$board = $this->board;
			
		if(($x <1)||($x >8)||($y <1)||($y >8))
			return -1;
			
		$i = (($y-1) * 8) + $x;
		if($board[$i] <> 0)
		{
			return $board[$i];
		}
		return 0;
	}								

		
	function nextTurn()
	{
		global $user, $db, $game, $language; 
		$game->closeTimeControl();
		
		$this->check1 = $this->inCheck(1, $this->board);
		$this->check2 = $this->inCheck(2, $this->board);
		$this->canMove1 = $this->canMove(1);
		$this->canMove2 = $this->canMove(2);

		// log move status
		$game->validMoveStatus = 0;
		if ($this->canMove1)
			$game->validMoveStatus += FLAG_CANMOVE_1;
		if ($this->canMove2)
			$game->validMoveStatus += FLAG_CANMOVE_2;
		if ($this->check1)
			$game->validMoveStatus += FLAG_INCHECK_1;
		if ($this->check2)
			$game->validMoveStatus += FLAG_INCHECK_1;
		$db->query_write("
			UPDATE gameroom_board_game 
			SET statusFlags = $game->statusFlags 
			WHERE gameID = $game->gameID
		"); 
		$game->validMoveStatus = true;
		// end move status
		
		if(($this->check1) && (! $this->canMove1))
		{
			$game->systemMsg($language['chess']['Checkmate'], $game->player2Name);
			$game->setWinner($game->player2ID);
		}
		else if($this->check1)
		{
			$game->systemMsg($language['chess']['Check'], $game->player2Name, 'check.mp3');
		}

		else if(($this->check2) && (! $this->canMove2))
		{
			$game->systemMsg($language['chess']['Checkmate'], $game->player1Name);
			$game->setWinner($game->player1ID);
		}
		else if($this->check2)
		{
			$game->systemMsg($language['chess']['Check'], $game->player1Name, 'check.mp3');
		}
		else if (($this->myColor == 1) && (!$this->canMove2))
		{
			$game->systemMsg($language['chess']['Stalemate'], $game->player2Name);
			$game->setWinner(0);
		}
		else if (($this->myColor == 2) && (!$this->canMove1))
		{
			$game->systemMsg($language['chess']['Stalemate'], $game->player1Name);
			$game->setWinner(0);
		}
		else if ($this->cannotMate())
		{
			$game->systemMsg($language['chess']['Draw'], $user->userName);
			$game->setWinner(0);
		}
		$game->counter++;
		if($this->myColor == 1)
			$db->query_read("UPDATE gameroom_board_game SET move = 2, counter = $game->counter WHERE gameid = $this->gameID");
		else							
			$db->query_read("UPDATE gameroom_board_game SET move = 1, counter = $game->counter WHERE gameid = $this->gameID");
			
		$boardCSV = implode(",", $this->board);
	
		$time = time();
		if (!$game->flags)
			$game->flags = 0;
		$query = "
			INSERT INTO gameroom_board_game_log
				(gameID, gameType, playerID, tstamp, csv, flags)
			VALUES
				($game->gameID, $game->gameType, $user->userID, $time, '$boardCSV', $game->flags) 
		";
		$db->query_write($query);
	}
	
	function movePawn($p, $x, $y, $x2, $y2)
	{
		global $user, $db, $game; 
		$tempBoard = $this->board;
		
		$tempBoard = array();
		$tempBoard = $this->board;
		
		if($this->myColor==2)
			$forward = 1;
		else
			$forward = -1;
	
		if($x == $x2)
		{
			// Same column, forward move
			if($y + $forward == $y2)
			{
				// one space forward
				if($this->checkSquare($x2, $y2) == 0)
				{
					// Can only move into unoccupied spaces
					$pid = $this->board[($y - 1) * 8 + $x];
					$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
					$this->board[($y - 1) * 8 + $x] = 0; 
					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$this->clearEnPassant();
						if (($y2 == 1) || ($y2 == 8))
						{
							if ($_GET['promote'] == 'r')
								$pid += 2;
							else if ($_GET['promote'] == 'k')
								$pid += 4;
							else if ($_GET['promote'] == 'b')
								$pid += 6;
							else if ($_GET['promote'] == 'q')
								$pid += 8;
							$this->board[($y2 - 1) * 8 + $x2] = $pid;
						}
						$game->counter = -1;
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameid = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameid = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						$this->nextTurn();
					}
				}
			} 
			else if (($y + ($forward * 2) == $y2) && ((($y == 7)&& ($forward==-1)) || (($y == 2)&& ($forward==1))))
			{
				// First move, two spaces forward 
				if(($this->checkSquare($x2, $y2) == 0)&&($this->checkSquare($x2, $y2-$forward) == 0))
				{
					// Can only move into unoccupied spaces 
					$pid = $this->board[($y - 1) * 8 + $x];
					$y3 = $y + (($y2 - $y) / 2);
					$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
					$this->board[($y3 - 1) * 8 + $x] = -1 * $this->board[($y - 1) * 8 + $x]; 
					$this->board[($y - 1) * 8 + $x] = 0; 
					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$game->counter = -1;
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = -$pid WHERE gameID = $this->gameID AND boardid = ($y3 - 1) * 8 + $x");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						$this->nextTurn();
					}
				}
				
			}
		} 
		if((abs($x - $x2) == 1) && ($y2 == $y + $forward)) 
		{
		// angled move, takes piece
			$s = $this->checkSquare($x2, $y2);
			if ((($s>0) && (($s - 1) % 2 != $this->myColor)) || ($s < 0))
			{
				// Can only move into opponent occupied spaces 
				$pid = $this->board[($y - 1) * 8 + $x];
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
				$this->board[($y - 1) * 8 + $x] = 0; 
				if($this->inCheck($this->myColor, $this->board))
				{
					// move places user in check, undo
					$this->board = $tempBoard;
					$this->error += ERROR_INCHECK; 
				}
				else
				{
						$this->clearEnPassant();
						if ($s < 0)
							$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x2");
					$game->counter = -1;
					$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
					$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
					$this->nextTurn();
				}
			}
		}
	}	
	
	
	function moveKnight($p, $x, $y, $x2, $y2)
	{
		global $user, $db, $game; 
		$tempBoard = $this->board;
		
		if(((abs($x - $x2) == 1) && (abs($y - $y2) == 2)) || ((abs($x - $x2) == 2) && (abs($y - $y2) == 1)))
		{
			// 2 spaces one way, one space the other.
			if ((($this->checkSquare($x2, $y2) - 1) % 2 != $this->myColor) ||(($this->checkSquare($x2, $y2) - 1) % 2 == 0))
			{
				$pid = $this->board[($y - 1) * 8 + $x];
				if ($this->board[($y2 - 1) * 8 + $x2] != 0)
					$capture = 1;
				else 
					$capture = 0;
				
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
				$this->board[($y - 1) * 8 + $x] = 0; 
					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$this->clearEnPassant();
						if($capture)
							$game->counter = -1;
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						$this->nextTurn();
					}			
			} 
		} 
	}
	
	function moveKing($p, $x, $y, $x2, $y2)
	{
		global $user, $db, $game; 
		if ($this->board[($y2 - 1) * 8 + $x2] != 0)
			$capture = 1;
		else 
			$capture = 0;

		$tempBoard = $this->board;
		if ((abs($x - $x2) < 2) && (abs($y - $y2) < 2))
		{
			// 1 space, any direction 
			if ((($this->checkSquare($x2, $y2) - 1) % 2 != $this->myColor) ||(($this->checkSquare($x2, $y2) - 1) % 2 == 0))
			{
				$pid = $this->board[($y - 1) * 8 + $x];
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
				$this->board[($y - 1) * 8 + $x] = 0;
					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$game->setFlag(FLAG_CASTLE_BOTH);
						$this->clearEnPassant();
						if($capture)
							$game->counter = -1;
						
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						$this->nextTurn();
					}
			} 
		} 
		else if (($x - $x2 == -2) && (abs($y - $y2) == 0) && (! ($game->flags & FLAG_CASTLE_RIGHT)) && (! $this->inCheck($this->myColor, $this->board)))
		{
			$nope = 0;
			for ($x3 = $x + 1; $x3 < 8; $x3++)
				if ($this->checkSquare($x3, $y2) > 0)
					$nope = 1;
			if (! $nope)
			{
				$pid = $this->board[($y - 1) * 8 + $x];
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x];
				$rookID = $this->board[($y - 1) * 8 + 8]; 
				$this->board[($y2 - 1) * 8 + $x2 -1] = $this->board[($y - 1) * 8 + 8];
				 
				$this->board[($y - 1) * 8 + $x] = 0;
				$this->board[($y - 1) * 8 + 8] = 0;
				if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$game->setFlag(FLAG_CASTLE_BOTH);
						$this->clearEnPassant();
						if($capture)
							$game->counter = -1;
						
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $rookID WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2 - 1");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + 8");
						
						$this->nextTurn();
					}
			} 
		}
		else if (($x - $x2 == 2) && (abs($y - $y2) == 0) && (! ($game->flags & FLAG_CASTLE_LEFT)) && (! $this->inCheck($this->myColor, $this->board)))
		{
			$nope = 0;
			for ($x3 = $x - 1; $x3 > 1; $x3--)
			{
				if (($this->checkSquare($x3, $y2) - 1) > 0)
				{
					$nope = 1;
				}
			}
			if (! $nope)
			{
				$pid = $this->board[($y - 1) * 8 + $x];
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
				$rookID = $this->board[($y - 1) * 8 + 1]; 
				$this->board[($y - 1) * 8 + $x2+1] = $this->board[($y - 1) * 8 + 1];
				$this->board[($y - 1) * 8 + $x] = 0;
				$this->board[($y - 1) * 8 + 1] = 0;
				
					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$game->setFlag(FLAG_CASTLE_BOTH);
						$this->clearEnPassant();
						if($capture)
							$game->counter = -1;
						
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = $rookID WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2 + 1");
						$db->query_write("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + 1");
						$this->nextTurn();
					}
			} 
		}
	}
	
	function moveRook($p, $x, $y, $x2, $y2)
	{
		
		global $user, $db, $game; 
		$tempBoard = $this->board;
		if ($this->board[($y2 - 1) * 8 + $x2] != 0)
			$capture = 1;
		else 
			$capture = 0;
		
		if(($x == $x2) || ($y == $y2))
		{
			$X3 = $y3 = 0;
			if($x != $x2)
				$x3 = ($x2 - $x) / abs($x2 - $x);
			if($y != $y2)
				$y3 = ($y2 - $y) / abs($y2 - $y);
				
			for($i = 1; $i < abs($x2-$x) + abs($y2-$y); $i++)		
				if($this->checkSquare($x + $x3 * $i, $y + $y3 * $i))
				{
					return -1;
				}
		
			if ((($this->checkSquare($x2, $y2) - 1) % 2 != $this->myColor % 2) ||($this->checkSquare($x2, $y2) == 0))
			{
				$pid = $this->board[($y - 1) * 8 + $x];
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
				$this->board[($y - 1) * 8 + $x] = 0; 
					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						if ($x > 5)
							$game->setFlag(FLAG_CASTLE_RIGHT);
						else if ($x < 5)
							$game->setFlag(FLAG_CASTLE_LEFT);
						$this->clearEnPassant();
						if($capture)
							$game->counter = -1;
						
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						$this->nextTurn();
					}
			} 
		}
	}
	
	
	function moveBishop($p, $x, $y, $x2, $y2)
	{
		global $user, $db; 
		$tempBoard = $this->board;
		if ($this->board[($y2 - 1) * 8 + $x2] != 0)
			$capture = 1;
		else 
			$capture = 0;

		if (abs($x - $x2) == abs($y - $y2))
		{
			$X3 = $y3 = 0;
			if($x != $x2)
				$x3 = ($x2 - $x) / abs($x2 - $x);
			if($y != $y2)
				$y3 = ($y2 - $y) / abs($y2 - $y);
				
			for($i = 1; $i < abs($x2-$x); $i++)		
				if($this->checkSquare($x + $x3 * $i, $y + $y3 * $i))
				{
					return -1;
				}
		
			if ((($this->checkSquare($x2, $y2) - 1) % 2 != $this->myColor) ||(($this->checkSquare($x2, $y2) - 1) % 2 == 0))
			{
				$pid = $this->board[($y - 1) * 8 + $x];
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
				$this->board[($y - 1) * 8 + $x] = 0; 
					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$this->clearEnPassant();
						if($capture)
							$game->counter = -1;
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						$this->nextTurn();
					}
			} 
		}
	}
	
	function moveQueen($p, $x, $y, $x2, $y2)
	{
		global $user, $db; 
		$tempBoard = $this->board;
		if ($this->board[($y2 - 1) * 8 + $x2] != 0)
			$capture = 1;
		else 
			$capture = 0;
		
		if ((abs($x - $x2) == abs($y - $y2))||($x==$x2)||($y==$y2))
		{
			$X3 = $y3 = 0;
			if($x != $x2)
				$x3 = ($x2 - $x) / abs($x2 - $x);
			if($y != $y2)
				$y3 = ($y2 - $y) / abs($y2 - $y);
			
			$z = abs($x2-$x);
			if ( abs($y2-$y) > $z)
				$z = abs($y2-$y);
			
			for($i = 1; $i < $z; $i++)		
				if($this->checkSquare($x + $x3 * $i, $y + $y3 * $i))
				{
					return -1;
				}
		
			if ((($this->checkSquare($x2, $y2) - 1) % 2 != $this->myColor) ||(($this->checkSquare($x2, $y2) - 1) % 2 == 0))
			{
				$pid = $this->board[($y - 1) * 8 + $x];
				$this->board[($y2 - 1) * 8 + $x2] = $this->board[($y - 1) * 8 + $x]; 
				$this->board[($y - 1) * 8 + $x] = 0; 

					if($this->inCheck($this->myColor, $this->board))
					{
						// move places user in check, undo
						$this->board = $tempBoard;
						$this->error += ERROR_INCHECK; 
					}
					else
					{
						$this->clearEnPassant();
						if($capture)
							$game->counter = -1;
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = $pid WHERE gameID = $this->gameID AND boardid = ($y2 - 1) * 8 + $x2");
						$db->query_read("UPDATE gameroom_chess_pieces SET pieceid = 0 WHERE gameID = $this->gameID AND boardid = ($y - 1) * 8 + $x");
						$this->nextTurn();
					}
			} 
		}
	}
	
	
	function clearEnPassant()
	{
		global $db;
		$query = "
			UPDATE gameroom_chess_pieces 
			SET pieceID = 0
			WHERE pieceID < 0
			AND gameID = $this->gameID
		";
		$db->query_write($query);
	}
	
	
	function inCheck($p, $board)
	{
		global $db;
		
		//global $this->board;
	
	//p = 1;
	
		if($p == 2)
			$forward = 1;
		else
			$forward = -1;
	
	
	// if($p==1) $p = 2;
	// else $p = 1;
		
		if($p == 2)
		{
			$king = 11;
			$offset = 1;
		}
		else
		{
			$king = 12;
			$offset = 0;
		}
		$kingid = array_search($king, $board);
	
		$kingx = (($kingid-1) % 8)+1; 	
		$kingy = floor(($kingid-1) / 8) + 1;
		$check = 0;
	
	// Knights	http://localhost/vbgaming/index.phps->
		if(($this->checkSquare($kingx+2, $kingy+1, $board)) == (($offset)+5))
			$check = 1;
		else if(($this->checkSquare($kingx+2, $kingy-1, $board)) == (($offset)+5))
			$check = 1;
		else if(($this->checkSquare($kingx+1, $kingy+2, $board)) == (($offset)+5))
			$check = 1;
		else if(($this->checkSquare($kingx+1, $kingy-2, $board)) == (($offset)+5))
			$check = 1;
		else if(($this->checkSquare($kingx-1, $kingy+2, $board)) == (($offset)+5))
			$check = 1;
		else if(($this->checkSquare($kingx-1, $kingy-2, $board)) == (($offset)+5))
			$check = 1;
		else if(($this->checkSquare($kingx-2, $kingy+1, $board)) == (($offset)+5))
			$check = 1;
		else if(($this->checkSquare($kingx-2, $kingy-1, $board)) == (($offset)+5))
			$check = 1;
	
	//Pawns
		else if(($this->checkSquare($kingx+1, $kingy+$forward, $board)) == (($offset)+1))
			$check = 2;
		else if(($this->checkSquare($kingx-1, $kingy+$forward, $board)) == (($offset)+1))
			$check = 2;
	
		for($x2 = -1; $x2 < 2; $x2++)
		{
			for($y2 = -1; $y2 < 2; $y2++)
			{
				// 8 possible directions
				$x = $kingx;
				$y = $kingy;
				while((($x > 0)&&($y > 0)&&($x < 9)&&($y < 9))&&(($x2!=0)||($y2!=0)))
				{
					$x = $x + $x2;
					$y = $y + $y2;
					if(($this->checkSquare($x, $y, $board)) == (($offset)+9))// queen
						$check = 3;				
					else if((($this->checkSquare($x, $y, $board)) == (($offset)+11))&&((abs($kingx - $x)<2)&& (abs($kingy - $y)<2) )) // king
						$check = 4;				
					else if( (($x2==0)||($y2==0)) && (($this->checkSquare($x, $y, $board)) == (($offset)+3))) //Rook
						$check = 5;				
					else if((($x2!=0)&&($y2!=0)) && (($this->checkSquare($x, $y, $board)) == (($offset)+7))) // Bishop
						$check = 6;				
					else if($this->checkSquare($x, $y, $board) > 0)
						$x = -1;
				} 
			}
		}
			
		return $check; 	
	}
	
	function canMove($p)
	{
		$canMove = 0;
		for($i = 1; $i < 65; $i++)
		{
			if(($this->board[$i] > 0) && ($this->board[$i] % 2 != $p % 2))
			{
				$p2 = $this->board[$i] ;//floor(($this->board[$i] - 1) / 2) + 1;
	
				$x = (($i-1) % 8)+1; 	
				$y = floor(($i-1) / 8) + 1;
	
				switch($p2)
				{
					case 1: // pawn
						$canMove = $this->canMovePawn($p, $x, $y, $this->board);
					break;
					case 2: // pawn
						$canMove = $this->canMovePawn($p, $x, $y, $this->board);
					break;
					
					case 3: // Rook
						$canMove = $this->canMoveLine($p, $x, $y, $this->board, 2); 
					break;
					case 4: // Rook
						$canMove = $this->canMoveLine($p, $x, $y, $this->board, 2); 
					break;
					
					case 5 : // Knight
						$canMove = $this->canMoveKnight($p, $x, $y, $this->board); 
					break;
					case 6 : // Knight
						$canMove = $this->canMoveKnight($p, $x, $y, $this->board); 
					break;
					
					case 7: // Bishop
						$canMove = $this->canMoveLine($p, $x, $y, $this->board, 3); 
					break; 
					case 8: // Bishop
						$canMove = $this->canMoveLine($p, $x, $y, $this->board, 3); 
					break; 
					
					case 9: // Queen
						$canMove = $this->canMoveLine($p, $x, $y, $this->board, 1); 
					break;
					case 10: // Queen
						$canMove = $this->canMoveLine($p, $x, $y, $this->board, 1); 
					break;
					
					case 11: // King
						$canMove = $this->canMoveKing($p, $x, $y, $this->board); 
					break;
					case 12: // King
						$canMove = $this->canMoveKing($p, $x, $y, $this->board); 
					break;
				}
			}
			if($canMove) return $canMove;
		}
		return 0;
	}
	
	function canMovePawn($p, $x, $y, $board)
	{
		$board2 = array();
		if($p==2)
			$forward = 1;
		else
			$forward = -1;
	
		// Same column, forward move
		// one space forward
		if($this->checkSquare($x, $y+$forward) == 0)
		{
			// Can only move into unoccupied spaces
			$pid = $this->board[($y - 1) * 8 + $x];
			$board2 = $this->board; 
			$board2[($y + $forward - 1) * 8 + $x] = $this->board[($y - 1) * 8 + $x]; 
			$board2[($y - 1) * 8 + $x] = 0;
			if (! $this->inCheck($p, $board2))
				return 1;
		}
	
		if ((($y == 7)&& ($forward==-1)) || (($y == 2)&& ($forward==1)))
		{
			// First move, two spaces forward 
			if(($this->checkSquare($x, $y+$forward) == 0)&&($this->checkSquare($x, $y+($forward*2)) == 0))
			{
				// Can only move into unoccupied spaces 
				$pid = $this->board[($y - 1) * 8 + $x];
				$board2 = $this->board; 
				$board2[($y + ($forward*2) - 1) * 8 + $x] = $this->board[($y - 1) * 8 + $x]; 
				$board2[($y - 1) * 8 + $x] = 0;
				if (! $this->inCheck($p, $board2))
					return 2;
	 		}
		}
	
		// angled move, takes piece
		if($x < 8) $s = $this->checkSquare($x + 1, $y + $forward);
		else $s = 0;
		if(($s>0) && (($s - 1) % 2 != $p % 2))
		{
			// Can only move into opponent occupied spaces
	//		echo "test $x $y ==<br/> "; 
			$pid = $this->board[($y - 1) * 8 + $x];
			$board2 = $this->board; 
			$board2[($y + $forward - 1) * 8 + $x + 1] = $this->board[($y - 1) * 8 + $x]; 
			$board2[($y - 1) * 8 + $x] = 0; 
			if (! $this->inCheck($p, $board2))
				return 3;
		}
		if($x > 1) $s = $this->checkSquare($x - 1, $y + $forward);
		else $s = 0;
		if(($s>0) && (($s - 1) % 2 != $p % 2))
		{
			// Can only move into opponent occupied spaces
	//		echo "test $x $y ==<br/> "; 
			$pid = $this->board[($y - 1) * 8 + $x];
			$board2 = $this->board; 
			$board2[($y + $forward - 1) * 8 + $x - 1] = $this->board[($y - 1) * 8 + $x]; 
			$board2[($y - 1) * 8 + $x] = 0; 
			if (! $this->inCheck($p, $board2))
				return 3;
		}
		return 0;
	}
	
	function canMoveKing($p, $x, $y, $board)
	{
		$board2 = array();
	
		if($x > 1)
			$startX = -1;
		else
			$startX = 0;
		
		if($x < 8) 
			$endX = 1;
		else
			$endX = 0;
			
		if($y > 1)
			$startY = -1;
		else
			$startY = 0;
		
		if($y < 8) 
			$endY = 1;
		else
			$endY = 0;
		
			
		for($x2 = $startX; $x2 < $endX +1; $x2++)
		{
			for($y2 = $startY; $y2 < $endY +1; $y2++)
			{	
				$s = $this->checkSquare($x+$x2, $y+$y2) ;
			//	echo "$p: $x2 x $y2 ($s): $x $y<hr>";
				if((($s == 0) || (($s - 1) % 2 != $p % 2)) && ((abs($x2) > 0) ||(abs($y2) > 0)))
				{
					//echo "x";   
//					echo ($y + $y2 - 1) * 8 + $x + $x2 . "($s) - ";
					//if ((($y + $y2 - 1) * 8 + $x + $x2 > 0) && (($y + $y2 - 1) * 8 + $x + $x2 < 65))
					if(($x + $x2 > 0)&&($x + $x2 < 9)&&($y + $y2 > 0)&&($y + $y2 < 9))
					{
						// Can only move into unoccupied spaces
						$pid = $this->board[($y - 1) * 8 + $x];
						$board2 = $this->board; 
						$board2[($y + $y2 - 1) * 8 + $x + $x2] = $this->board[($y - 1) * 8 + $x]; 
						$board2[($y - 1) * 8 + $x] = 0;
						if (!$this->inCheck($p, $board2))
						{
							return "4 $x2 x $y2";
							//echo "$p: $x2, $y2 = $c<br>";
						}
					}
				}
			}
		}
		//exit();
		return 0;
	}
	
	function canMoveKnight($p, $x, $y, $board)
	{
		$board2 = array();
	
		for($x2 = -2; $x2 < 3; $x2++)
		{
			for($y2 = -2; $y2 < 3; $y2++)
			{
				if(abs($x2) + abs($y2) == 3)
				{
					if(($x + $x2 > 0)&&($x + $x2 < 9)&&($y + $y2 > 0)&&($y + $y2 < 9))
					{
					 
						$s = $this->checkSquare($x+$x2, $y+$y2);
						if(($s == 0)||(($s - 1) % 2 != $p % 2))
						{
							// Can only move into unoccupied spaces
							$pid = $this->board[($y - 1) * 8 + $x];
							$board2 = $this->board; 
							$board2[($y + $y2 - 1) * 8 + $x + $x2] = $this->board[($y - 1) * 8 + $x]; 
							$board2[($y + $y2 - 1) * 8 + $x + $x2] = 0;
							if (! $this->inCheck($p, $board2))
								return "6";
							}
					}
				}
			}
		}
		return 0;
	}
	
	function canMoveLine($p, $x, $y, $board, $t)
	{
		$board2 = array();
	
		for($x2 = -1; $x2 < 2; $x2++)
		{
			for($y2 = -1; $y2 < 2; $y2++)
			{
				$x3 = $x;
				$y3 = $y;
				
				if(($t == 1)||((abs($x2) + abs($y2) == 1)&&($t == 2))||((abs($x2) + abs($y2) == 2)&&($t == 3))) 
					while(($x3 + $x2 > 0) && ($x3 + $x2 < 9) && ($y3 + $y2 > 0) && ($y3 + $y2 < 9) && (abs($x2) + abs($y2) > 0))
					{
						$x3 += $x2;
						$y3 += $y2;
										
						$s = $this->checkSquare($x3, $y3);
						if((($s == 0)||(($s - 1) % 2 != $p % 2)))
						{
							// Can only move into unoccupied spaces
							$pid = $this->board[($y - 1) * 8 + $x];
							$board2 = $this->board; 
							$board2[($y3 - 1) * 8 + $x3] = $this->board[($y - 1) * 8 + $x]; 
							$board2[($y - 1) * 8 + $x] = 0;
							if (! $this->inCheck($p, $board2))
								return "10 $t ($x $y) -> ($x3, $y3) " . $this->checkSquare($x, $y, $board);
						}
						if($s > 0) $x3 = -1;
					}
			}
		}
		return 0;
	}
	
	
	/*
	 * Allow Draw
	 */
	function cannotMate()
	{
		
		$p1Count = 0;
		$p2Count = 0;
		foreach ($this->board as $p)
		{
			if (($p == 5) || ($p == 7))
				$p1Count++;	
			else if (($p == 6) || ($p == 8))
				$p1Count++;	
			else if (($p == 1) || ($p == 3) || ($p == 9))
				$p1Count += 2;
			else if (($p == 2) || ($p == 4) || ($p == 10))
				$p2Count += 2;
		}
		if (($p1Count < 2) && ($p2Count < 2))
			return true;
		else 
			return false;
	}
	
	function threeFoldRepetition()
	{
		global $db, $user, $game;
		$query = "
			SELECT playerID, csv, flags
			FROM gameroom_board_game_log
			WHERE gameID = $this->gameID
			ORDER BY id DESC
			LIMIT 1
		";
		$result = $db->query_read($query);
		if($row = $db->fetch_array($result))
		{
			$query = "
				SELECT COUNT(id) AS c
				FROM gameroom_board_game_log
				WHERE gameID = $this->gameID
				AND playerID = " . $row['playerID'] . "
				AND csv = '" . $row['csv'] . "'
				AND flags = " . $row['flags'] . "
			";
		}
		$result = $db->query_read($query);
		if($row = $db->fetch_array($result))
		{
			if ($row['c'] >= 3)
				return true;
		}
		return false;
	}
}	
?>