<?php

/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

	
class chatRoom
{
	var $chatID, $lastID;
	var $chatXML = "", $statusXML, $userList;
	var $xml;
	var $message = false;
	
	
	function init()
	{
		if(is_numeric($_GET['lastID']))
			$this->lastID = $_GET['lastID'] * 1;
		else 
			$this->lastID = 0;

		// chatID will be set by game if it is within a game, if not then grab the chat id
		if(! $this->chatID)
			if(is_numeric($_GET['chatID']))
				$this->chatID = $_GET['chatID'] * 1;
			else 
				$this->chatID = 1;

		if($_GET['msg'])
			$this->handleMsg();
		
	}
	
	function handleCommand($msg)
	{
		global $user, $db;
		$time = time();
		if (substr($msg, 0, 8) == "/callout")
		{
			$this->systemMsg(trim(substr($msg, 8)),$user->userName);
			$msg = $user->userName . " - " . trim(substr($msg, 8));
			$query = "
				INSERT INTO gameroom_banner_msgs (msg, msgTime) VALUES ('$msg', $time)
			";
				$db->query_write($query);
			return "";
			
		}
		else if (substr($msg, 0, 6) == "/buzz")
		{
			$this->systemMsg("BUZZ!" ,$user->userName, 'buzzer.mp3');
			return "";
		}
		return $msg;
	}
	
	function systemMsg($msg, $userName, $sfx = "")
	{
		global $db, $user;
		
		$msgColor = "000000";

		$msg = "\x3Cb>" . $msg . "\x3C/b>";
		$time = time();
		$query = "
			INSERT INTO gameroom_chatlog
				(chatID, userID, userName, msgTime, msgColor, msg, soundFX)
			VALUES
				($this->chatID, 0, '" . htmlspecialchars($userName, ENT_QUOTES) . "', $time, '$msgColor', '$msg', '$sfx')
		";
		$db->query_write($query);
		
	}
	
	function handleMsg()
	{
		global $db, $user;
		$this->message = true;
		$msg = addslashes(htmlspecialchars(trim($_GET[msg]),ENT_QUOTES));
		$msgColor = addslashes(htmlspecialchars(trim($_GET[msgColor]),ENT_QUOTES));
		
		
		if(strlen($msgColor) > 6)
			$msgColor = "000000";

		while (strlen($msgColor) < 6)
		{
			$msgColor = "0" . $msgColor;
		}
		if(substr($msg,0,1) == "/")
			$msg = $this->handleCommand($msg);
			
		
		if(strlen($msg) > 0)
		{
			$time = time();
			$query = "
				INSERT INTO gameroom_chatlog
					(chatID, userID, userName, msgTime, msgColor, msg, soundfx)
				VALUES
					($this->chatID, $user->userID, '" . htmlspecialchars($user->userName, ENT_QUOTES) . "', $time, '$msgColor', '$msg', '')
			";
			$db->query_write($query);
		}
	}
	
	
	function getMessages()
	{
		global $db, $user, $language;
		
		//If they are first entering, show messages from last 3 minutes;
		
		if($this->lastID == 0)
			$timeReq = "AND msgTime > " . (time() - 60 * 3);
		else 
			$timeReq = "";
		
		$limit = 10;
		if ($this->message)
		{
			$query = "
				SELECT * 
				FROM gameroom_chatlog
				WHERE chatID = $this->chatID
				AND userID = $user->userID
				ORDER BY id DESC
				LIMIT 1,1
			";
			$result = $db->query_read($query);
			if ($row = $db->fetch_array($result))
			{
				// prevent grabbing twice if a send msg request is outstanding
				if ($row['id']  > $this->lastID)
					$this->lastID = $row['id'];
			}
		}	
		$query = "
			SELECT * 
			FROM gameroom_chatlog
			WHERE chatID = $this->chatID
			AND ID > $this->lastID
			$timeReq
			ORDER BY id DESC
			LIMIT $limit
		";
		
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			if($row['id'] > $this->lastID)
				$this->lastID = $row['id'];
			
			$id = $row['id'];
			$msg = htmlspecialchars($row['msg'] , ENT_QUOTES) ;
			$userName = htmlspecialchars($row['userName'] , ENT_QUOTES) ;
			$userID = htmlspecialchars($row['userID'] , ENT_QUOTES) ;
			$color = htmlspecialchars($row['msgColor'] , ENT_QUOTES) ;
			$msgTime = htmlspecialchars($row['msgTime'] , ENT_QUOTES) ;
			if ($timeReq == "")
				$sfx = $row['soundfx'];
			else
				$sfx = "";
			$this->chatXML = "<msg id='$id' userID='$userID' userName='$userName' msg='$msg' color='$color' msgTime='$msgTime' sfx='" . $sfx ."' />" . $this->chatXML;
		}

		$time = time();
		
		if(! $color)
			$color = "000000";
		
		$query = "
			SELECT id 
			FROM gameroom_chat_users
			WHERE userID = $user->userID
			AND chatID = $this->chatID
		";
		$result = $db->query_read($query);
		if ($row = $db->fetch_array($result))
		{
			$query = "
				UPDATE gameroom_chat_users
				SET lastUpdate = $time, 
					color = '$color',
					userName = '$user->userName'
				WHERE userID = $user->userID
				AND chatID = $this->chatID
			";
			$db->query_write($query);
		}
		else
		{
			$query = "
				INSERT INTO gameroom_chat_users
					(chatID, userID, userName, color, lastUpdate)
				VALUES
					($this->chatID, $user->userID, '" . htmlspecialchars($user->userName, ENT_QUOTES) . "', '$color', $time)
			";
			$db->query_write($query);
			$this->systemMsg(htmlspecialchars($user->userName, ENT_QUOTES) . $language['common']['Has_Entered_The_Room'], $language['common']['Lobby'], "enterRoom.mp3");				
		}
	}
	
	function getUsers()
	{
		global $db, $user, $language;
		
		// time out users after 1 minute
		$timeOut = time() - (20);
		$this->userList = "";

				
		$query = "
			SELECT * 
			FROM gameroom_chat_users
			WHERE chatID = $this->chatID
			and lastUpdate < $timeOut
		";
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			$this->systemMsg(htmlspecialchars($row['userName'], ENT_QUOTES) . $language['common']['Has_Left_The_Room'], $language['common']['Lobby']);
		}
		
		$query = "
			DELETE 
			FROM gameroom_chat_users
			WHERE chatID = $this->chatID
			AND lastUpdate < $timeOut
		";
		$db->query_write($query);
		
		$query = "
			SELECT * 
			FROM gameroom_chat_users
			WHERE chatID = $this->chatID
			and lastUpdate > $timeOut
		";
		$result = $db->query_read($query);
		while ($row = $db->fetch_array($result))
		{
			$this->userList .= "<user userID='" . $row['userID'] . "' userName='" . htmlspecialchars($row['userName'], ENT_QUOTES) . "' color='" . $row['color'] . "' />";
		}
		
		
	}
	
	function getStatus()
	{
		$this->getUsers();
		$this->statusXML = "<status lastID='$this->lastID' />";
		$this->statusXML .= "<userList>" . $this->userList . "</userList>";
	}
	
	function getXML()
	{
		$this->getStatus();
		$this->xml = "<root>" . $this->statusXML . $this->chatXML . "</root>";
	}
	
	function getXMLNoRoot()
	{
		$this->getStatus();
		$this->xml = $this->statusXML . $this->chatXML;
	}
	
}

	
?>