<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

	error_reporting(E_ALL & ~E_NOTICE);
	define('NO_REGISTER_GLOBALS', 1);
	define('THIS_SCRIPT', 'gameroom'); // change this depending on your filename

if (! isset($_GET['do']))
{
	
	// vbulletin page gen
	
	$globaltemplates = array(
		'gameroom',
		'gameroom_html_status_box',
		'gameroom_html_status_box_cell'
	);

	require("./global.php");
	     
	$navbits = array(); 
	$navbits[$parent] = 'Gameroom';
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
		
	eval('print_output("' . fetch_template('gameroom') . '");');	
}
else
{
	header("Pragma: bogus");
	header("Cache-Control: no-cache");
	
	$globaltemplates = array(
		'gameroom',
	);
	require('gameroom/functions_language.php');
	require("gameroom/class_main.php");
	
	require('gameroom/language.php');
	
	
	loadLanguage();
	
	require('gameroom/class_settings.php');
	require("gameroom/constants.php");
	$settings = new gameRoomSettings();
	
	$do = htmlspecialchars($_GET['do'],ENT_QUOTES);
	
	if(! preg_match("/^[a-zA-Z0-9]*$/", $do)){
		notLoggedIn();
		exit();
	}
	
	
	switch($do)
	{
		case "test":
			var_dump($settings);
			var_dump($language);
			exit();
			break;
		case "blackjackf":
			require('gameroom/blackjack_dealf.php');
		break;
		
		case "slotsf":
			require('gameroom/slots_ajaxf.php');
		break;

		case "videopokerf":
			require('gameroom/vidpokf_redeal.php');
		break;

		case "letemridef":
			require('gameroom/letemridef_deal.php');
		break;

		case "roulette":
			require('gameroom/roulette.php');
		break;

		case "sportspoolf":
			require('gameroom/sportspoolf.php');
		break;

		case "chatroom":
			require('gameroom/chatroom.php');
			$user = new userInfo;
			$user->user_info();
		
			$lobby = new chatRoom;
		
			$lobby->init();
			$lobby->getMessages();
			$lobby->getXML();
			
			printGameroomOutput( $lobby->xml);
			
		break;
		
		case "poker":
			require('gameroom/poker.php');
		break;
		
		case "boardgame":
			$user = new userInfo;
			$user->user_info();
			require('gameroom/class_boardgame.php');
			$game = new boardGame;
			$game->init();
			$game->runGame();
			
			//require_once('gameroom/chess.php');
		break;
		
		case "getLanguage":
			$user = new userInfo;
			$user->user_info();
			printGameroomOutput( getLanguage());
		break;	
		
		case "exportLanguage":
			$user = new userInfo;
			$user->user_info();
			exportLanguage();
		break;	
		
		case "getLanguageEdit":
			$user = new userInfo;
			$user->user_info();
			printGameroomOutput( getLanguageEdit());
		break;	
		
		case "saveLanguage":
			$user = new userInfo;
			$user->user_info();
			printGameroomOutput( saveLanguage());
		break;	
		
		case "stats":
			$user = new userInfo;
			$user->user_info();
			
			require("gameroom/class_stats.php");
			$stats = new stats;
			printGameroomOutput( $stats->getStats());
		break;	
		
		case "adjust":
			$user = new userInfo;
			$user->user_info();
			require("gameroom/class_adjust.php");
			$adjust = new adjust();
			printGameroomOutput( $adjust->adjustCash());
		break;
		
		case "banner":
			$user = new userInfo;
			$user->user_info();
			require("gameroom/class_banner.php");
			$banner = new banner();
			echo $banner->getBanner();
		break;
		
		case "bannerHTML":
			$user = new userInfo;
			$user->user_info();
			require("gameroom/class_banner.php");
			$banner = new banner();
			echo $banner->getBannerHTML();
		break;
		
		case "transfer":
			require("gameroom/functions_transfer.php");
			$user = new userInfo;
			$user->user_info();
			printGameroomOutput(transferCash());
		break;
		
		case "transferlog":
			require("gameroom/functions_transfer.php");
			$user = new userInfo;
			$user->user_info();
			printGameroomOutput(getTransferLog());
		break;
		
		case "getSettingsEdit":
			$user = new userInfo;
			$user->user_info();
			printGameroomOutput($settings->getSettingsForEdit());
		break;
		
		case "clearStats":
			$user = new userInfo;
			$user->user_info();
			if($user->isAdmin)
			{
				$db->query_write("DELETE FROM gameroom_bet_stats");
				printGameroomOutput("<root><done /></root>");
			}
		break;

		case "updatecash":
			$user = new userInfo;
			$user->user_info();
			printGameroomOutput("<root><data cash='$user->cash' /></root>");
		break;
		
	}
}	
	function notLoggedIn()
	{
		global $language;
		printGameroomOutput("<root><status userID='' msg='" . $language['common']['Not_Logged_In'] . "'/></root>");
		exit();
		
	}

	function printGameroomOutput($output)
	{
		global $settings;
		
		if($settings->usePrintOutput)
			print_output($output);
		else
		{
			header("Content-type: text/xml");
			echo $output;
			exec_shut_down();
		}
	}


?>
