<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/


	$gameroomUser = new userInfo;
	$gameroomUser->user_info();
	
		
	$videoPoker = new videoPoker;
	$videoPoker->init();
	$videoPoker->get_hand();
	$videoPoker->get_status();
	$videoPoker->get_chips();
	
	$output = "
		<root>
			$videoPoker->chipsXML
			$videoPoker->cardsXML
			$videoPoker->statusXML
			" . $videoPoker->getPayoutsXML() . "
		</root>
	";
	printGameroomOutput($output);

	class videoPoker
	{
		var $gameID, $tableLimit, $gameName, $chipsUsed, $permissions;
		var $cashType, $cash, $chipArray, $bet, $hand;
		var $chipsXML, $cardsXML, $statusXML;
		var $pair, $paircount, $three, $four, $flush, $straight;
		var $buttonDiscard, $buttonDeal;
		var $winnings;

		function init()
		{
			global $gameroomDB;
			$this->gameID = GAMEID_VIDEO_POKER;

			//$this->user_info();
			$this->get_chips();
			$this->get_bet();
		}
		
		function get_status()
		{
			global $gameroomUser;
			$this->statusXML = "<status cash=\"$gameroomUser->cash\" discard=\"$this->buttonDiscard\" deal=\"$this->buttonDeal\" resultText=\"$this->hand\" />";
		}		

		function no_permissions()
		{
			print_no_permission();
			exit();
		}
		
		function get_chips()
		{
			global $gameroomSettings, $gameroomUser;
			
			$output = "";
			$i = 0;
			foreach ($gameroomSettings->videoPoker['chipsUsed'] as $chip)
			{
				if ($chip <= $gameroomUser->cash)
				{
					$output .= "<chip id=\"$i\" alpha='1' value=\"$chip\" img=\"" . $gameroomSettings->chips[$chip] . "\" />";
					$i++;
				}
			}
			$this->chipsXML = $output;
		}
		
		
		function get_bet()
		{
			global $gameroomUser, $gameroomSettings;
			
			if (is_numeric($_GET['bet']))
			{
				if ((in_array($_GET['bet'], $gameroomSettings->videoPoker['chipsUsed'])) || ($_GET['bet'] == 1))
					$this->bet =  $_GET['bet'];
				else
				{
					$this->bet = 0;
				}
			}
			else
			{
				$this->bet = 0;
			}
			
			if ($this->bet > $gameroomUser->cash)
			{
				$this->bet = 0;
			}
			
			// If > cash....
		}

		
		function deal_cards()
		{
			global $gameroomDB, $gameroomUser;
			
			for($i = 0; $i < 52; $i++) {
				$card[$i]=$i;
			}
			srand((float)microtime() * 1000000);
			shuffle($card);
			
			$query = "
				DELETE FROM gameroom_video_poker 
				WHERE playerid = $gameroomUser->userID
			";
			$gameroomDB->query($query);

			$query = "INSERT INTO gameroom_video_poker (playerID, cardNum, card, discarded) values ($gameroomUser->userID, 0, $this->bet, 0)";  
			//echo $query;
			$gameroomDB->query($query);

			for($i = 1; $i < 11; $i++) {
				$query = "INSERT INTO gameroom_video_poker (playerID, cardNum, card, discarded) values ($gameroomUser->userID, $i, $card[$i], 0)";  
				$gameroomDB->query($query);
			}		
		
		}
		
		function get_hand()
		{
			global $gameroomDB, $gameroomLanguage, $gameroomUser;


			$endHand = 0;
			if (($this->bet > 0) && (isset($_REQUEST['card1'])) && (isset($_REQUEST['card2'])) && (isset($_REQUEST['card3'])) && (isset($_REQUEST['card4'])) && (isset($_REQUEST['card0'])))
			{
				$this->discard();
				$endHand = 1;
			}

				
			$query = "
				SELECT * 
				FROM gameroom_video_poker 
				WHERE playerID=$gameroomUser->userID 
				AND discarded = 0 
				ORDER BY cardNum 
				LIMIT 6
			";
			$result = $gameroomDB->query_read($query);

			// First entry is the bet amount
			if($row = $gameroomDB->fetch_array($result))
				$this->bet = $row['card'];
			
			//echo "##" . $this->bet;

			$fcount = array();
			$scount = array();
			$this->flush = 0;
			$this->straight = 0;
			$pair = array();
			$this->paircount = 0;
			$this->three = 0;
			$this->four = 0;

			$i = 0;
			$this->cardsXML = "";
			while($row=$gameroomDB->fetch_array($result)) 
			{
				$f[$i] = $row['card'] % 13;
				$s[$i] = floor($row['card']/13);
				$f2 = $f[$i];
				$s2 = $s[$i];
				$fcount[$f2]++;
				$scount[$s2]++;
				if($s2==0)
				{
					$cardFile = "gameroom/images/spades-"; 
					$cardName = $gameroomLanguage['cards']['Spades']; //$vbphrase[casino_spades]; 
				}
				else if($s2==1)
				{
					$cardFile = "gameroom/images/diamonds-";
					$cardName = $gameroomLanguage['cards']['Diamonds']; //
				}
				else if($s2==2)
				{
					$cardFile = "gameroom/images/hearts-";
					$cardName = $gameroomLanguage['cards']['Hearts']; //$vbphrase[casino_hearts]; 
				}
				else if($s2==3)
				{
					$cardFile = "gameroom/images/clubs-";
					$cardName = $gameroomLanguage['cards']['Clubs']; //$vbphrase[casino_clubs]; 
				}
	
				if($f2+2 < 11)
				{
					$cardFile .= ($f2+2) . "-150.png";
					$cardName = ($f2+2) . $gameroomLanguage['cards']['Of'] . $cardName; 
				}
				else if($f2+2==11)
				{
					$cardFile .= "j-150.png"; 
					$cardName = $gameroomLanguage['cards']['Jack'] . $gameroomLanguage['cards']['Of'] . $cardName; 
				}
				else if($f2+2==12)
				{
					$cardFile .= "q-150.png"; 
					$cardName = $gameroomLanguage['cards']['Queen'] . $gameroomLanguage['cards']['Of'] . $cardName; 
				}
				else if($f2+2==13)
				{
					$cardFile .= "k-150.png"; 
					$cardName = $gameroomLanguage['cards']['King'] . $gameroomLanguage['cards']['Of'] . $cardName; 
				}
				else if($f2+2==14)
				{
					$cardFile .= "a-150.png"; 
					$cardName = $gameroomLanguage['cards']['Ace'] . $gameroomLanguage['cards']['Of'] . $cardName; 
				}

				$this->cardsXML .= "<card id=\"$i\" name=\"$cardName\" img=\"$cardFile\" />";
				$i++;
			}
			if($i < 4)
			{
				if($this->bet > 0)
				{

					$gameroomUser->record_cash($this->gameID, $this->bet * -1);

					$this->deal_cards();
					$this->get_hand();
				}
				else 
				{
				
					$this->cardsXML = "";
					$cardFile = "gameroom/images/back-blue-150-1.png";
					$cardName = "";
					for($i = 0; $i < 5; $i++)
						$this->cardsXML .= "<card id=\"$i\" name=\"$cardName\" img=\"$cardFile\" />";
					$this->buttonDiscard = 0;
					$this->buttonDeal = 1;
				}
			}
			else
			{
				if(! $endHand)
				{
					$this->buttonDiscard = 1;
					$this->buttonDeal = 0;
				}
				else 
				{
					$this->buttonDiscard = 0;
					$this->buttonDeal = 1;
				}
				
				
				for($i = 0; $i < 4; $i++) 
				{
					if($scount[$i]==5)
						$this->flush = $i + 1;
				} 

				for($i = 0; $i < 13; $i++) {
					if($fcount[$i] == 2){
						$this->pair[$this->paircount] = $i + 1;
						$this->paircount += 1; 
					}
					else if($fcount[$i]==3)
						$this->three = $i + 1;
					else if($fcount[$i]==4)
						$this->four = $i + 1;;
				}
				if (($this->paircount==0) && ($this->three==0) && ($this->four==0))
				{
					if ((max($f) - min($f)) == 4) 
						$this->straight = max($f)+1;
					else if ((max($f) == 12) && (min($f) == 0) && (in_array(1, $f)) && (in_array(2, $f))&& (in_array(3, $f))){
						$this->straight = 4;
					} 
				}
				if($endHand)
					$this->end_hand();
			}

		}
		
		function discard()
		{
			global $gameroomDB, $gameroomUser;
			
			if($_REQUEST['card0'] == "true")
				$gameroomDB->query("UPDATE gameroom_video_poker SET discarded = 1 WHERE playerID = $gameroomUser->userID AND cardnum = 1");
			if($_REQUEST['card1'] == "true")
				$gameroomDB->query("UPDATE gameroom_video_poker SET discarded = 1 WHERE playerID = $gameroomUser->userID AND cardnum = 2");
			if($_REQUEST['card2'] == "true")
				$gameroomDB->query("UPDATE gameroom_video_poker SET discarded = 1 WHERE playerID = $gameroomUser->userID AND cardnum = 3");
			if($_REQUEST['card3'] == "true")
				$gameroomDB->query("UPDATE gameroom_video_poker SET discarded = 1 WHERE playerID = $gameroomUser->userID AND cardnum = 4");
			if($_REQUEST['card4'] == "true")
				$gameroomDB->query("UPDATE gameroom_video_poker SET discarded = 1 WHERE playerID = $gameroomUser->userID AND cardnum = 5");
		}
		
		function end_hand()
		{
			global $gameroomDB, $gameroomLanguage, $gameroomUser;
		
			$cash = 0;
			if ($this->flush && $this->straight==13) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Royal_Flush']; //$vbphrase[casino_royalflush];
				$cash = 1000; 
			}
			else if ($this->flush>0 && $this->straight>0) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Straight_Flush']; //$vbphrase[casino_straightflush];
				$cash = 100; 
			}
			else if($this->flush>0) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Flush']; //$vbphrase[casino_flush];
				$cash = 6; 
			}
			else if($this->straight>0) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Straight']; //$vbphrase[casino_straight]; 
				$cash = 4; 
			}
			else if($this->four>0) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Four of a Kind']; //$vbphrase[casino_4ofakind]; 
				$cash = 35; 
			}
			else if(($this->three>0)&&($this->paircount>0)) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Full_House']; //$vbphrase[casino_fullhouse]; 
				$cash = 10; 
			}
			else if($this->three>0) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Three_of_a_Kind']; //$vbphrase[casino_3ofakind]; 
				$cash = 3; 
			}
			else if($this->paircount>1) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Two_Pair']; //$vbphrase[casino_2pair]; 
				$cash = 2; 
			}
			else if($this->paircount>0 && $this->pair[0] > 9) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['High_Pair']; //$vbphrase[casino_highpair]; 
				$cash = 1; 
			}
			else if($this->paircount>0) 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Pair']; //$vbphrase[casino_pair]; 
				$cash = 0; 
			}
			else 
			{
				$this->hand =  $gameroomLanguage['pokerHands']['Nothing']; //$vbphrase[casino_nothing]; 
				$cash = 0; 
			}

			if($cash > 0)
			{
				$cash = ($cash * $this->bet);
				$this->hand .= " (" . $gameroomLanguage['common']['Currency_Marker'] . $cash . ")";
			}
			$this->winnings = $cash;
			
			$gameroomDB->query("DELETE FROM gameroom_video_poker WHERE playerID = $gameroomUser->userID");
			
			$gameroomUser->record_cash($this->gameID, $cash);

		}
		
		
		function getPayoutsXML()
		{
			global $gameroomLanguage;
			$xml = "<payout field1='" . $gameroomLanguage['pokerHands']['Royal_Flush'] . "' field2='1000' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Straight_Flush'] . "' field2='100' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Four_of_a_Kind'] . "' field2='35' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Full_House'] . "' field2='10' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Flush'] . "' field2='6' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Straight'] . "' field2='4' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Three_of_a_Kind'] . "' field2='3' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Two_Pair'] . "' field2='2' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Pair_Jacks_Or_Better'] . "' field2='1' />";
			return $xml;
		}				
	}

	


?>