<?php
require_once('./global.php');

$db->hide_errors();

$db->query_write("ALTER TABLE " . TABLE_PREFIX ."user 
	ADD COLUMN gameroom_cash INTEGER DEFAULT 500
");

$db->query_write("CREATE TABLE gameroom_video_poker (
	dealtID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	playerID INTEGER, 
	cardNum INTEGER, 
	card INTEGER, 
	discarded INTEGER
)");

$db->query_write("CREATE TABLE gameroom_blackjack (
	dealtID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	playerID INTEGER, 
	cardNum INTEGER, 
	card INTEGER, 
	hand INTEGER, 
	bet INTEGER, 
	total INTEGER
)");
$db->query_write("CREATE TABLE gameroom_letitride (
	dealtID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	playerID INTEGER, 
	cardNum INTEGER, 
	card INTEGER, 
	status INTEGER
)");

$db->query_write("CREATE TABLE gameroom_bet_stats (
	statsID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	userID INTEGER, 
	gameID INTEGER, 
	bet INTEGER, 
	won INTEGER
)");


$db->query_write("CREATE TABLE gameroom_sb_groups (
	groupid INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	groupname TEXT
)");

$db->query_write("CREATE TABLE gameroom_sb_events (
	eventid INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	groupid INTEGER,
	eventname TEXT, 
	eventdate varchar(255), 
	result INTEGER
)");

$db->query_write("CREATE TABLE gameroom_sb_outcomes (
	outcomeid INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	eventid INTEGER, 
	outcomename TEXT, 
	totalbets INTEGER
)");

$db->query_write("CREATE TABLE gameroom_sb_bets (
	betid INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	userid INTEGER, 
	outcomeid INTEGER, 
	betamount INTEGER, 
	winings INTEGER
)");


$db->query_write("CREATE TABLE gameroom_chess_pieces (
	chessPieceID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT, 
	boardID INTEGER, 
	gameID INTEGER, 
	pieceID INTEGER
)");


$db->query_write("CREATE TABLE gameroom_board_game (
	gameID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	gameName TEXT,
	maxPlayers INTEGER,
	move INTEGER, 
	startTime INTEGER, 
	endTime INTEGER,
	ranked BOOLEAN,
	password TEXT, 
	locked BOOLEAN,
	chatID INTEGER,
	winner INTEGER, 
	gameTypeID INTEGER,
	gameStarted BOOLEAN,
	drawOffer INTEGER,
	gameType INTEGER,
	timeControl SMALLINT,
	timeRules VARCHAR(64),
	counter INTEGER
)");

$db->query_write("CREATE TABLE gameroom_board_game_players (
	gamePlayerID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	gameID INTEGER,
	playerID INTEGER, 
	seatID INTEGER,
	lastUpdate INTEGER,
	playerName TEXT, 
	flags INTEGER,
	ready BOOLEAN,
	turn INTEGER,
	timeRemaining INTEGER,
	turnStartTime INTEGER
)");

$db->query_write("CREATE TABLE gameroom_rank(
	id INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
	gameType INTEGER,
	userID INTEGER,
	rank INTEGER,
	gamesPlayed INTEGER,
	wins INTEGER,
	loses INTEGER, 
	draws INTEGER
)");

$db->query_write("CREATE TABLE gameroom_board_game_log (
	id INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
	gameID INTEGER,
	gameType INTEGER,
	playerID INTEGER,
	tstamp INTEGER,
	csv TEXT,
	flags INTEGER
)");


$db->query_write("CREATE TABLE gameroom_chat (
	chatID INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	gameID INTEGER,
	name TEXT
)");
	

$db->query_write("CREATE TABLE gameroom_chatlog (
	id INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	chatID INTEGER,
	userID INTEGER,
	userName TEXT,
	msgTime INTEGER,
	msgColor CHAR(6),
	msg TEXT
)");
	
$db->query_write("CREATE TABLE gameroom_chat_users (
	id INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	chatID INTEGER,
	userID INTEGER,
	userName TEXT,
	color CHAR(6),
	lastUpdate INTEGER
)");

$db->query_write("CREATE TABLE gameroom_poker_game (
	gameID INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT,
	chatID INTEGER,
	name TEXT,
	password TEXT,
	rules INTEGER,
	betting INTEGER,
	pot INTEGER,
	round INTEGER,
	dealerSeat INTEGER,
	whosTurn INTEGER,
	turnTimeOut INTEGER,
	ante INTEGER,
	blinds INTEGER,
	maxRaises INTEGER,
	maxPlayers INTEGER,
	maxBet INTEGER,
	betLimit INTEGER,
	useStake BOOLEAN,
	minStake INTEGER,
	maxStake INTEGER,
	stakeMultiplier INTEGER,
	tournamentGame BOOLEAN,
	lockPlayers BOOLEAN,
	gameStarted BOOLEAN,
	lastRaise INTEGER,
	minRaise INTEGER
)");
		
$db->query_write("CREATE TABLE gameroom_poker_players (
	id INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT,
	gameID INTEGER,
	userID INTEGER,
	stake INTEGER,
	seatID INTEGER,
	bet INTEGER,
	lastUpdate INTEGER,
	status INTEGER DEFAULT 0
)");
	

$db->query_write("CREATE TABLE gameroom_poker_dealt (
	id INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT,
	gameID INTEGER,
	userID INTEGER,
	cardID INTEGER,
	faceUp BOOLEAN
)");

$db->query_write("
	CREATE TABLE gameroom_language (
	id INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT,
	languageGroup TEXT,
	languageName TEXT,
	phrase TEXT
)");

$db->query_write("
	CREATE TABLE gameroom_banner_msgs (
	id INTEGER PRIMARY KEY NOT NULL AUTO_INCREMENT,
	msgTime int,
	msg TEXT
)");

$db->query_write("ALTER TABLE gameroom_board_game ADD COLUMN nextGameID INTEGER");

$db->query_write("ALTER TABLE gameroom_sb_outcomes ADD COLUMN moneyline INTEGER");

$db->query_write("
	CREATE TABLE gameroom_donatelog (
	donateid INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
	fromuser TEXT, 
	touser TEXT, 
	amount INTEGER, 
	dtime INTEGER
)");

$db->query_write("ALTER TABLE gameroom_poker_game ADD COLUMN maxRaise INTEGER");

?>