<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/


	class letItRide extends casinoGame
	{
		var $cardFile, $cardName, $f, $s, $fcount, $scount, $finished, $raises;
		var $statusXML, $cardsXML;
		
		function init()
		{
			global $gameroomSettings;
			$this->gameID = GAMEID_LET_IT_RIDE;
			$this->tableLimit = $gameroomSettings->letItRide['tableLimit']; 
			$this->gameCode = "letemride";
			$this->chipsUsed = $gameroomSettings->letItRide['chipsUsed'];
			
			$this->initGame();		
			
		}
		

		function raise()
		{
			global $gameroomDB, $gameroomUser;
			
			if ($gameroomUser->cash >= $this->bet)
			{
				$this->gameStatus ++;
				$query = "UPDATE gameroom_letitride SET status = status + 1 WHERE playerID = $gameroomUser->userID AND cardNum = 0";
				$gameroomDB->query($query);
	
				$query = "UPDATE gameroom_letitride SET status = status + 1 WHERE playerID = $gameroomUser->userID AND cardNum = 1";
				$gameroomDB->query($query);
	
				if ($this->bet <= $gameroomUser->cash)
				{
					$gameroomUser->record_cash($this->gameID, $this->bet * -1);
				}
			}
		}
		
		function check()
		{
			global $gameroomDB, $gameroomUser;

			$bet = $row['bet'];
			// Check 
			$this->gameStatus ++;
			$query = "UPDATE gameroom_letitride SET status = status + 1  WHERE playerID = $gameroomUser->userID AND cardNum = 0";
			$gameroomDB->query($query);
		}
		
		function deal()
		{
			global $gameroomDB, $gameroomUser;
		
			if (($this->bet > $gameroomUser->cash) || ($this->bet > $this->tableLimit))
			{
				$this->bet = 0;
			}
		
			for($i = 0; $i < 52; $i++) {
				$card[$i]=$i;
			}
			srand((float)microtime() * 1000000);
			shuffle($card);
			$query = "DELETE FROM gameroom_letitride WHERE playerID = $gameroomUser->userID";
			$gameroomDB->query($query);

			$query = "INSERT INTO gameroom_letitride (playerID, cardNum, card, status) values ($gameroomUser->userID, 0, $this->bet, 1)";  
			$gameroomDB->query($query);

			for($i = 1; $i < 11; $i++) {
				$query = "INSERT INTO gameroom_letitride (playerID, cardNum, card, status) values ($gameroomUser->userID, $i, $card[$i], 0)";  
				$gameroomDB->query($query);
			}		
			$gameroomUser->record_cash($this->gameID, $this->bet * -1);		
			$this->gameStatus = 1;
		}
		
		
	
		function get_hand()
		{
			
			global $gameroomDB, $gameroomUser;
			
			$this->fcount = array();
			$this->scount = array();
			$this->f = array();
			$this->s = array();

			$i = 0;
			$this->cardfile = array();
			$this->cardname = array();
			
			$query = "SELECT * FROM gameroom_letitride WHERE playerID=$gameroomUser->userID ORDER BY cardNum LIMIT 6";
			$result = $gameroomDB->query_read($query);

			// First entry is the bet amount
			if ($row = $gameroomDB->fetch_array($result))
			{
				//$this->bet = $row['card'];
				$this->gameStatus  = $row['status']; 

				$this->bet = $row['card'];
				
				if($gameroomUser->cash >= $this->bet)
				{
					$this->canRaise = 1;
					$this->canCheck = 1;
				}
				else
				{
					$this->canCheck = 1;
				}

				// Loop through cards
				while($row=$gameroomDB->fetch_array($result)) {
				//	echo $row['card'] . " ";

					$cardArray = $this->evalCard($row['card']);
					$this->cardfile[$i] = $cardArray['cardFile'];
					$this->cardname[$i] = $cardArray['cardName'];
					$this->f[$i] = $cardArray['faceValue'];
					$this->s[$i] = $cardArray['suit'];
					
					$temp = $this->f[$i];
					$this->fcount[$temp]++;
					$temp = $this->s[$i];
					$this->scount[$temp]++;
					
					$i++;
				}
				
			}
			else 
			{
				$this->gameStatus = -1;
			}
		}
	

		function eval_hand()
		{
			global $gameroomDB, $gameroomUser, $gameroomLanguage;
			
			$flush = 0;
			$straight = 0;
			$pair = array();
			$paircount = 0;
			$three = 0;
			$four = 0;
			
			for($i = 0; $i < 4; $i++) {
				if($this->scount[$i]==5)$flush = $i+1;
			} 

			for($i = 0; $i < 13; $i++) {
				if($this->fcount[$i]==2){
					$pair[$paircount] = $i+1;
					$paircount+=1; 
				}
				else if($this->fcount[$i]==3)$three = $i+1;
				else if($this->fcount[$i]==4)$four = $i+1;;
			}
			if (($paircount==0) && ($three==0) && ($four==0))
			{
				if ((max($this->f) - min($this->f)) == 4) 
					$straight = max($this->f)+1;
				else if ((max($this->f) == 12) && (min($this->f) == 0) && (in_array(1, $this->f)) && (in_array(2, $this->f))&& (in_array(3, $this->f))){
				 	$straight = 4;
				} 
			}
			
			$query = "SELECT card, status FROM gameroom_letitride WHERE playerID = $gameroomUser->userID AND cardNum IN (0, 1) ORDER BY cardNum";
			$result = $gameroomDB->query_read($query);
			
			$row = $gameroomDB->fetch_array($result);
			$this->bet = $row['card'];
			
			$row = $gameroomDB->fetch_array($result);
			$raises = $row['status'];
			
			$query = "DELETE FROM gameroom_letitride WHERE playerID = $gameroomUser->userID";
			$gameroomDB->query($query);

			if ($flush && $straight==13) 
			{
				$this->resultText = $gameroomLanguage['pokerHands']['Royal_Flush'];
				$betMult = 1000; 
			}
			else if($flush>0 && $straight>0) 
			{
				$this->resultText = $gameroomLanguage['pokerHands']['Straight_Flush'];
				$betMult = 200; 
			}
			else if($flush>0) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['Flush'];
				$betMult = 8; 
			}
			else if($straight>0) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['Straight'];
				$betMult = 5; 
			}
			else if($four>0) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['Four_of_a_Kind'];
				$betMult = 50; 
			}
			else if(($three>0)&&($paircount>0)) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['Full_House'];
				$betMult = 11; 
			}
			else if($three>0) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['Three_of_a_Kind']; 
				$betMult = 3; 
			}
			else if($paircount>1) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['Two_Pair']; 
				$betMult = 2; 
			}
			else if($paircount>0 && $pair[0] > 8) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['High_Pair'];
				$betMult = 1; 
			}
			else if($paircount>0) 
			{
				$this->resultText =  $gameroomLanguage['pokerHands']['Pair']; 
				$betMult = 0; 
			}
			else 
			{
				$this->resultText = $gameroomLanguage['pokerHands']['Nothing']; 
				$betMult = 0; 
			}


			$this->bet = $this->bet * $raises + $this->bet;

			// Bet, times winning multiplyer plus initial bet gets returned
			if($betMult > 0)	
				$betMult = ($betMult * $this->bet) + $this->bet;

			$query = "DELETE FROM gameroom_letitride WHERE playerID = $gameroomUser->userID";
			$gameroomDB->query($query);

			
			if ($betMult>0){ 
				$gameroomUser->record_cash($this->gameID, $betMult);
				$this->resultText .= " ($betMult)";
			}
		}
	
	 
		function user_action()
		{
		
			if(is_numeric($_GET['bet']))
				$this->bet = $_GET['bet'] *1;
				
			if(($_GET['action'] == 1) && $this->bet > 0)
			{
				// Raise
				$this->deal();
			}	
			else if($_GET['action'] == 2)
			{
				$this->raise();

			}	
			else if($_GET['action'] == 3)
			{
				$this->check();

			}	
			//echo "$this->gameStatus ";
			
			if ($this->gameStatus  == 1)
			{
				$this->revealed = 1;
			}
			else if ($this->gameStatus  == 2)
			{
				$this->revealed = 2;
				$this->finished = 1;
				$isdone = 1;
			}
			
		}

		
		function show_status()
		{
			global $gameroomUser;
			
			for ($i = 0; $i < 5; $i++)
			{
				if ((($i > 1 + $this->gameStatus) || ($this->gameStatus < 1)))
				{
					$this->cardfile[$i] = "gameroom/images/back-blue-150-1.png";
					$this->cardname[$i] = "";
				}
				$this->cardsXML .= "<card img='" . $this->cardfile[$i] . "' name='" . $this->cardname[$i] . "' />\n";
			}
			if($this->gameStatus == 3)
			{
				$this->eval_hand();
			}
			$this->statusXML = "<status cash='$gameroomUser->cash' tableLimit='$this->tableLimit' bet='$this->bet' round='$this->gameStatus' resultText='$this->resultText' />\n";

		}
		
		function getPayoutsXML()
		{
			global $gameroomLanguage;
			$xml = "<payout field1='" . $gameroomLanguage['pokerHands']['Royal_Flush'] . "' field2='1000:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Straight_Flush'] . "' field2='200:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Four_of_a_Kind'] . "' field2='50:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Full_House'] . "' field2='11:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Flush'] . "' field2='8:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Straight'] . "' field2='5:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Three_of_a_Kind'] . "' field2='3:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Two_Pair'] . "' field2='2:1' />";
			$xml .= "<payout field1='" . $gameroomLanguage['pokerHands']['Pair_10s_Or_Better'] . "' field2='1:1' />";
			return $xml;
		}		

	}


	$gameroomUser = new userInfo;
	$gameroomUser->user_info();
	$letItRide = new letItRide;


	$letItRide->init();
	$letItRide->user_action();
	$letItRide->get_hand();
	$letItRide->show_status();
	$letItRide->get_chips();
	
	$output = "
		<root>
			$letItRide->chipsXML
			$letItRide->cardsXML
			$letItRide->statusXML
			$letItRide->languageXML
			" . $letItRide->getPayoutsXML() ."
		</root>
	";
	printGameroomOutput( $output);



	
?>