<?php

/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

define("FLAG_DID_RESET", 1);
	
class chatRoom
{
	var $chatID, $lastID;
	var $chatXML = "", $statusXML, $gameroomUserList;
	var $xml;
	var $message = false;
	var $flag = "";
	
	
	function init()
	{
		global $gameroomLanguage, $gameroomUser, $gameroomSettings, $gameroomDB;
		
		if(is_numeric($_GET['lastID']))
			$this->lastID = $_GET['lastID'] * 1;
		else 
			$this->lastID = 0;

		// chatID will be set by game if it is within a game, if not then grab the chat id
		if(! $this->chatID)
			if(is_numeric($_GET['chatID']))
				$this->chatID = $_GET['chatID'] * 1;
			else 
				$this->chatID = 1;

		if (($this->chatID == 1) && ($gameroomUser->cash < 1) && ($gameroomSettings->allowReset))
		{
			$gameroomUser->resetCash();
			$this->flag = $gameroomLanguage['common']['Cash_Was_Reset'] . " " . $gameroomLanguage['common']['Currency_Marker'] . $gameroomSettings->defaultCash;
		}
		if($_GET['msg'])
			$this->handleMsg();
		
	}
	
	function handleCommand($msg)
	{
		global $gameroomUser, $gameroomDB;
		$time = time();
		if (substr($msg, 0, 8) == "/callout")
		{
			$this->systemMsg(trim(substr($msg, 8)),$gameroomUser->userName);
			$msg = $gameroomUser->userName . " - " . trim(substr($msg, 8));
			$query = "
				INSERT INTO gameroom_banner_msgs (msg, msgTime) VALUES ('$msg', $time)
			";
				$gameroomDB->query_write($query);
			return "";
			
		}
		else if (substr($msg, 0, 6) == "/buzz")
		{
			$this->systemMsg("BUZZ!" ,$gameroomUser->userName, 'buzzer.mp3');
			return "";
		}
		return $msg;
	}
	
	function systemMsg($msg, $gameroomUserName, $sfx = "", $gameroomUserID = 0)
	{
		global $gameroomDB, $gameroomUser;
		
		$msgColor = "000000";

		$msg = "\x3Cb>" . $msg . "\x3C/b>";
		$time = time();
		$query = "
			INSERT INTO gameroom_chatlog
				(chatID, userID, userName, msgTime, msgColor, msg, soundFX)
			VALUES
				($this->chatID, $gameroomUserID, '" . htmlspecialchars($gameroomUserName, ENT_QUOTES) . "', $time, '$msgColor', '$msg', '$sfx')
		";
		$gameroomDB->query_write($query);
		
	}
	
	function handleMsg()
	{
		global $gameroomDB, $gameroomUser;
		$this->message = true;
		$msg = addslashes(htmlspecialchars(trim($_GET[msg]),ENT_QUOTES));
		$msgColor = addslashes(htmlspecialchars(trim($_GET[msgColor]),ENT_QUOTES));
		
		
		if(strlen($msgColor) > 6)
			$msgColor = "000000";

		while (strlen($msgColor) < 6)
		{
			$msgColor = "0" . $msgColor;
		}
		if(substr($msg,0,1) == "/")
			$msg = $this->handleCommand($msg);
			
		
		if(strlen($msg) > 0)
		{
			$time = time();
			$query = "
				INSERT INTO gameroom_chatlog
					(chatID, userID, userName, msgTime, msgColor, msg, soundfx)
				VALUES
					($this->chatID, $gameroomUser->userID, '" . htmlspecialchars($gameroomUser->userName, ENT_QUOTES) . "', $time, '$msgColor', '$msg', 'message.mp3')
			";
			$gameroomDB->query_write($query);
		}
	}
	
	
	function getMessages()
	{
		global $gameroomDB, $gameroomUser, $gameroomLanguage;
		
		//If they are first entering, show messages from last 3 minutes;
		
		if($this->lastID == 0)
			$timeReq = "AND msgTime > " . (time() - 60 * 3);
		else 
			$timeReq = "";
		
		$limit = 10;
		if ($this->message)
		{
			$query = "
				SELECT * 
				FROM gameroom_chatlog
				WHERE chatID = $this->chatID
				AND userID = $gameroomUser->userID
				ORDER BY id DESC
				LIMIT 1,1
			";
			$result = $gameroomDB->query_read($query);
			if ($row = $gameroomDB->fetch_array($result))
			{
				// prevent grabbing twice if a send msg request is outstanding
				if ($row['id']  > $this->lastID)
					$this->lastID = $row['id'];
			}
		}	
		$query = "
			SELECT * 
			FROM gameroom_chatlog
			WHERE chatID = $this->chatID
			AND ID > $this->lastID
			$timeReq
			ORDER BY id DESC
			LIMIT $limit
		";
		
		$result = $gameroomDB->query_read($query);
		while ($row = $gameroomDB->fetch_array($result))
		{
			if($row['id'] > $this->lastID)
				$this->lastID = $row['id'];
			
			$id = $row['id'];
			$msg = htmlspecialchars($row['msg'] , ENT_QUOTES) ;
			$gameroomUserName = htmlspecialchars($row['userName'] , ENT_QUOTES) ;
			$gameroomUserID = htmlspecialchars($row['userID'] , ENT_QUOTES) ;
			$color = htmlspecialchars($row['msgColor'] , ENT_QUOTES) ;
			$msgTime = htmlspecialchars($row['msgTime'] , ENT_QUOTES) ;
			if ($timeReq == "")
				$sfx = $row['soundfx'];
			else
				$sfx = "";
			$this->chatXML = "<msg id='$id' userID='$gameroomUserID' userName='$gameroomUserName' msg='$msg' color='$color' msgTime='$msgTime' sfx='" . $sfx ."' />" . $this->chatXML;
		}

		$time = time();
		$color = htmlspecialchars($_GET['msgColor'] , ENT_QUOTES) ;
		
		
		if(! $color)
			$color = "000000";
		
		$query = "
			SELECT id 
			FROM gameroom_chat_users
			WHERE userID = $gameroomUser->userID
			AND chatID = $this->chatID
		";
		$result = $gameroomDB->query_read($query);
		if ($row = $gameroomDB->fetch_array($result))
		{
			$query = "
				UPDATE gameroom_chat_users
				SET lastUpdate = $time, 
					color = '$color',
					userName = '$gameroomUser->userName'
				WHERE userID = $gameroomUser->userID
				AND chatID = $this->chatID
			";
			$gameroomDB->query_write($query);
		}
		else
		{
			$query = "
				INSERT INTO gameroom_chat_users
					(chatID, userID, userName, color, lastUpdate)
				VALUES
					($this->chatID, $gameroomUser->userID, '" . htmlspecialchars($gameroomUser->userName, ENT_QUOTES) . "', '$color', $time)
			";
			$gameroomDB->query_write($query);
			$this->systemMsg(htmlspecialchars($gameroomUser->userName, ENT_QUOTES) . $gameroomLanguage['common']['Has_Entered_The_Room'], $gameroomLanguage['common']['Lobby'], "enterRoom.mp3");				
		}
	}
	
	function getUsers()
	{
		global $gameroomDB, $gameroomUser, $gameroomLanguage;
		
		// time out users after 1 minute
		$timeOut = time() - (20);
		$this->userList = "";

				
		$query = "
			SELECT * 
			FROM gameroom_chat_users
			WHERE chatID = $this->chatID
			and lastUpdate < $timeOut
		";
		$result = $gameroomDB->query_read($query);
		while ($row = $gameroomDB->fetch_array($result))
		{
			$this->systemMsg(htmlspecialchars($row['userName'], ENT_QUOTES) . $gameroomLanguage['common']['Has_Left_The_Room'], $gameroomLanguage['common']['Lobby']);
		}
		
		$query = "
			DELETE 
			FROM gameroom_chat_users
			WHERE chatID = $this->chatID
			AND lastUpdate < $timeOut
		";
		$gameroomDB->query_write($query);
		
		$query = "
			SELECT * 
			FROM gameroom_chat_users
			WHERE chatID = $this->chatID
			and lastUpdate > $timeOut
		";
		$result = $gameroomDB->query_read($query);
		while ($row = $gameroomDB->fetch_array($result))
		{
			$this->userList .= "<user userID='" . $row['userID'] . "' userName='" . htmlspecialchars($row['userName'], ENT_QUOTES) . "' color='" . $row['color'] . "' />";
		}
		
		
	}
	
	function getStatus()
	{
		$this->getUsers();
		$this->statusXML = "<status lastID='$this->lastID' flag='$this->flag' />";
		$this->statusXML .= "<userList>" . $this->userList . "</userList>";
	}
	
	function getXML()
	{
		$this->getStatus();
		$this->xml = "<root>" . $this->statusXML . $this->chatXML . "</root>";
	}
	
	function getXMLNoRoot()
	{
		$this->getStatus();
		$this->xml = $this->statusXML . $this->chatXML;
	}
	
}

	
?>