<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/



class blackJackHand
{
	var $canSplit = 0, $canDoubleDown = 0, $isDone = 0, $canSurrender = 0;
	var $total = 0, $bet = 0;
	var $handResult, $resultText = "";
	var $handID;
	var $numCards;
	var $blackjack, $bust, $charlie, $showTotal;
	var $cardsXML;
	
	function getHand()
	{
		global $gameroomDB, $gameroomUser;
		
	
		// reset all variables
		$this->total = $this->numCards = $this->canSplit = $this->canDoubleDown = $this->isDone = $this->bet = 
			$this->blackjack = $this->bust = $this->charlie = $this->showTotal = $this->canSurrender = 0;
		$this->cardsXML = "";

		$this->getBet();
		
		$query = "
			SELECT * 
			FROM gameroom_blackjack 
			WHERE playerID=$gameroomUser->userID 
			AND hand = $this->handID 
			ORDER BY cardNum
		";
		$this->handResult = $gameroomDB->query_read($query);
		$this->numCards = 0;
		while($row = $gameroomDB->fetch_array($this->handResult)) 
		{
			$this->numCards++;
			if($row['total'])
				$this->isDone = 1;
		}
		$this->getTotal();
		
		if(! $isDone)
		{
			$this->getCanDoubleDown();
			$this->getCanSplit();
			$this->getCanSurrender();
		}
		
	}
	
	function getTotal()
	{
		global $gameroomDB, $gameroomUser, $blackjack;

		$total = 0;
		$aces = 0;
		$cards = 0;
		$gameroomDB->data_seek($this->handResult, 0);
		while($row = $gameroomDB->fetch_array($this->handResult)) 
		{
			$cards++;
			$s = floor($row['card'] % 13) + 2;

			if($s<11)$total += $s; // # card
			else if($s==11)$total += 10; // Jack
			else if($s==12)$total += 10; //Queen
			else if($s==13)$total += 10; //King
			else if($s==14){$total += 11;$aces++;} //Ace
			
			while (($aces > 0)&&($total > 21))
			{
				$total -= 10;
				$aces--;
			}
		}
		if(($total == 21) && ($cards == 2))
		{
			$this->blackjack = 1;
			$this->isDone = 1;
//			if($this->handID == 1)
				//$this->blackjack->hands[2].stay();
				
		}
		if(($total < 22) && ($cards == 5))
		{
			$this->charlie = 1;
			$this->isDone = 1;
		}
		if($total > 21)
		{
			$this->bust = 1;
			$this->isDone = 1;
		}
		if($total == 21)
		{
			$this->isDone = 1;
		}
		$this->total = $total; 
	}
	
	
	// done
	function getCanSplit()
	{
		global $gameroomDB, $gameroomUser;
	
		$i = 0;
		
		$gameroomDB->data_seek($this->handResult, 0);
		while($row = $gameroomDB->fetch_array($this->handResult))
		{ 
			$s = ($row['card'] % 13)+2;
			
			if($s < 11)
				$v[$i] = $s; // # card
			else if($s == 11)
				$v[$i] = 10; // Jack
			else if($s == 12)
				$v[$i] = 10; //Queen
			else if($s == 13)
				$v[$i] = 10; //King
			else if($s == 14)
				$v[$i] = 11; //Ace
			$i++;		
		}
		if (($i == 2) && ($v[0] == $v[1]) && ($gameroomUser->cash >= $this->bet) && ($this->handID > 1) && (! $this->isDone))
			$this->canSplit =  1;
		else
			$this->canSplit =  0;
	}
	
	function getCanDoubleDown()
	{
		global $gameroomUser;
		if (($this->numCards == 2) && ($gameroomUser->cash >= $this->bet) && ($this->handID > 1) && (! $this->isDone))
			$this->canDoubleDown = 1;
		else
			$this->canDoubleDown = 0;
		
	}

	function getCanSurrender()
	{
		global $gameroomUser, $blackjack, $gameroomDB;
		
		if (($this->numCards == 2)  && ($this->handID > 1) && (! $this->isDone) && ($this->bet > 1))
		{
			$query = "
				SELECT MAX(hand) AS h
				FROM gameroom_blackjack 
				WHERE playerID=$gameroomUser->userID
			";
			$result = $gameroomDB->query_read($query);
			$row = $gameroomDB->fetch_array($result);
			if ($row['h'] > 2)
				$this->canSurrender = 0;
			else
				$this->canSurrender = 1;
		}
		else
			$this->canSurrender = 0;
		
	}
	
	function stay()
	{
		global $gameroomDB, $gameroomUser, $blackjack;
		
		$query = "
			UPDATE gameroom_blackjack 
			SET total = $this->total 
			WHERE hand = $this->handID 
			AND playerID = $gameroomUser->userID
		";		
		$gameroomDB->query($query);
		$this->isDone = 1;
		$this->getHand();
		$blackjack->getHands();
	}
	
	function surrender()
	{
		global $gameroomDB, $gameroomUser, $blackjack;
		$blackjack->didSurrender = true;
		$query = "
			UPDATE gameroom_blackjack 
			SET total = $this->total 
			WHERE hand = $this->handID 
			AND playerID = $gameroomUser->userID
		";		
		$gameroomDB->query($query);
		$this->isDone = 1;
		$this->getHand();
		$blackjack->getHands();
	}
	
	function hit()
	{
		global $gameroomDB, $gameroomUser;

		$query = "SELECT * FROM gameroom_blackjack WHERE playerID=$gameroomUser->userID AND hand = 0 ORDER BY cardNum LIMIT 1";
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		
		$card = $row['cardNum'];

		$query = "
			UPDATE gameroom_blackjack 
				SET hand = $this->handID, 
				bet = $this->bet 
			WHERE cardNum = $card 
			AND playerID = $gameroomUser->userID
		";		
		$gameroomDB->query_write($query);

		$this->getTotal();
		if(abs($this->total) >= 21)
		{
			$query = "
				UPDATE gameroom_blackjack 
				SET total = $this->total 
				WHERE hand = $this->handID
				AND playerID = $gameroomUser->userID
			";		
			$gameroomDB->query_write($query);
			$this->isDone = 1;
		}
		$this->getHand();
	}
	
	function doubleDown()
	{
		global $gameroomDB, $gameroomUser, $blackjack;
		
		$query = "SELECT * FROM gameroom_blackjack WHERE playerID=$gameroomUser->userID AND hand = 0 ORDER BY cardNum LIMIT 1";
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		
		$card = $row['cardNum'];
		$gameroomUser->bet = $this->bet;
		
		$query = "UPDATE gameroom_blackjack SET hand = $this->handID, bet = bet + $gameroomUser->bet WHERE cardNum = $card AND playerID = $gameroomUser->userID";		
		$gameroomDB->query($query);

		$this->getTotal();
		$query = "UPDATE gameroom_blackjack SET total = $this->total WHERE hand = $this->handID AND playerID = $gameroomUser->userID";		
		$gameroomDB->query($query);

		$gameroomUser->record_cash($blackjack->gameID, $this->bet * -1);		
		$query = "UPDATE gameroom_blackjack SET bet = bet + $gameroomUser->bet WHERE hand = $this->handID AND playerID = $gameroomUser->userID";		
		$gameroomDB->query($query);
		$this->bet = $gameroomUser->bet * 2;
		
		$this->getHand();
		
		
	}

	function split()
	{
		global $gameroomUser, $gameroomDB, $blackjack;

		// Get card # 
		$query = "
			SELECT * 
			FROM gameroom_blackjack 
			WHERE playerID=$gameroomUser->userID 
			AND hand = $this->handID 
			ORDER BY cardNum DESC 
			LIMIT 1
		";
			
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		
		$card = $row['cardNum'];
		$bet = $row['bet'];
		
		// Get next avail hand #		
		$query = "
			SELECT max(hand) AS hand 
			FROM gameroom_blackjack 
			WHERE playerID=$gameroomUser->userID 
		";
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		
		$h2 = $row['hand'] +1;
		
		// Move card to new hand
		
		$query = "
			UPDATE gameroom_blackjack 
			SET hand = $h2, bet=$bet 
			WHERE cardNum = $card 
			AND playerID = $gameroomUser->userID
		";		
		$gameroomDB->query($query);
		
		// New for first hand 
		$query = "SELECT * FROM gameroom_blackjack WHERE playerID=$gameroomUser->userID AND hand = 0 ORDER BY cardNum";
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		
		$card = $row['cardNum'];
		
		$query = "UPDATE gameroom_blackjack SET hand = $this->handID, bet = $this->bet WHERE cardNum = $card AND playerID = $gameroomUser->userID";		
		$gameroomDB->query_write($query);
		
		// New for 2nd hand 
		$row = $gameroomDB->fetch_array($result);
		$card = $row['cardNum'];
		
		$query = "UPDATE gameroom_blackjack SET hand = $h2, bet = $this->bet WHERE cardNum = $card AND playerID = $gameroomUser->userID";		
		$gameroomDB->query_write($query);		

		$gameroomUser->record_cash($blackjack->gameID, $this->bet * -1);

		// hand has changed, rebuild
		$this->getHand();
	}
	
	function getBet()
	{
		global $gameroomUser, $gameroomDB;
				
		$query = "
			SELECT MAX(bet) AS bet 
			FROM gameroom_blackjack 
			WHERE playerID=$gameroomUser->userID 
			AND hand = $this->handID
		";
		$totals = $gameroomDB->query_read($query);
		$total = $gameroomDB->fetch_array($totals);
		$this->bet = $total['bet'];
		
	}
	function getCardsXML()
	{
		global $gameroomDB, $gameroomUser, $blackjack;
		$this->cardsXML = "";
		if($this->handID > 1)
			$name = $gameroomUser->userName;
		else
			$name = "Dealer";
		
		$gameroomDB->data_seek($this->handResult, 0);
		if((! $this->isDone) && ($this->handID > 1))
			$active = 1;
		else
			$active = 0;
		$deal = 0;
		if(($this->handID == 2) && (($blackjack->hands[1]->isDone)  || ($this->resultText)))
			$deal = 1;
			
		$total = $this->total;
		
		if(($this->handID == 1) && (!$this->isDone))
			$total = "N/A";
		
		if ($deal)
		{
			// dealer blackjack
			$this->canHit = 0;
			$this->canSplit = 0;
			$this->canDoubleDown = 0;
			$this->canSurrender = 0;
			$active = 0;
			$blackjack->isDone = 1;
		}
		$this->cardsXML = "
			<hand id='$this->handID' hit='$active' stay='$active' split='$this->canSplit' doubledown='$this->canDoubleDown' surrender='$this->canSurrender' deal='$deal' name='$name' total='$total' resultText='$this->resultText'>
		";
		$i = 0;
		while($row = $gameroomDB->fetch_array($this->handResult))
		{
			$card = $blackjack->evalCard($row['card']);
			if(($this->handID == 1) && (!$this->isDone) && ($i == 0))
				$this->cardsXML .= "<card img='gameroom/images/back-blue-150-1.png' name='' />\n";
			else
				$this->cardsXML .= "<card img='" . $card['cardFile'] . "' name='" . $card['cardName'] . "' />\n";
			$i++;
		}
		$this->cardsXML .= "</hand>";
	}

	function autoPlay()
	{
		// dealer
		global $gameroomDB, $gameroomUser, $blackjack;
		
		$query = "
			SELECT * 
			FROM gameroom_blackjack WHERE 
			playerID=$gameroomUser->userID 
			AND hand = 0 
			ORDER BY cardNum 
		";
		$result = $gameroomDB->query_read($query);

		while ($this->total < 17)
		{
			$row = $gameroomDB->fetch_array($result);
			$card = $row['cardNum'];
	
			$query = "
				UPDATE gameroom_blackjack 
				SET hand = 1 
				WHERE cardNum = $card 
				AND playerID = $gameroomUser->userID
			";		
			$gameroomDB->query($query);
			$this->getHand();
			$this->getTotal();
		}
		//$this->stay();
		$this->isDone = 1;
	}

	function didWin()
	{
		// Ret =  1 if player won, 0 if dealer won, -1 for push 
		global $gameroomDB, $gameroomUser, $blackjack, $gameroomLanguage;
	
	 
		if($blackjack->didSurrender)
		{
			$ret= 0;
			$this->resultText = $gameroomLanguage['blackjack']['Surrender'];
		}
		else if($this->charlie)
		{
			$ret= 1;
			$this->resultText =  $gameroomLanguage['blackjack']['Five_Card'];
		}
		else if(($this->blackjack) && (! $blackjack->hands[1]->blackjack))
		{
			$ret= 1;
			$this->resultText = $gameroomLanguage['blackjack']['Blackjack'];
		}
		else if(($this->blackjack) && ($blackjack->hands[1]->blackjack))
		{
			$ret= -1;
			$this->resultText = $gameroomLanguage['blackjack']['Push'];
		}
		else if(($blackjack->hands[1]->blackjack))
		{
			$ret= 0;
			$this->resultText = $gameroomLanguage['blackjack']['Lose'];
		}
		else if($this->bust)
		{
			$ret= 0;
			$this->resultText = $gameroomLanguage['blackjack']['Lose'];
		}
		else if($this->total == $blackjack->hands[1]->total)
		{
			$ret= -1;
			$this->resultText = $gameroomLanguage['blackjack']['Push'];
		}
		else if($blackjack->hands[1]->bust)
		{
			$ret= 1;
			$this->resultText = $gameroomLanguage['blackjack']['Win'];
		}
		else if($this->total > $blackjack->hands[1]->total)
		{
			$ret= 1;
			$this->resultText = $gameroomLanguage['blackjack']['Win'];
		}
		else
		{
			$ret= 0;
			$this->resultText = $gameroomLanguage['blackjack']['Lose'];
		}
			
		$w = 0;
		

		if(($ret == 1) && ($this->blackjack)) 
			$w = round($this->bet * 2.5); // Win w/ Blackjack
		else if($ret == 1)
			$w = $this->bet * 2;	//Win 
		else if( $ret == -1) 
			$w = $this->bet;	//Push
		else if ($blackjack->didSurrender)
			$w = floor($this->bet * .5);
		
		if($w > 0)
			$gameroomUser->record_cash($blackjack->gameID, $w);
	}
	
}


class blackjack extends casinoGame
{
	var $statusXML, $handsXML, $hands, $chips, $isDone, $numHands, $gameID, $didSurrender = false;
	
	function init()
	{
		global $gameroomSettings;
		$this->gameID = GAMEID_BLACKJACK;
		$this->tableLimit = $gameroomSettings->blackjack['tableLimit']; 
		$this->gameCode = "blackjack";
		$this->chipsUsed = $gameroomSettings->blackjack['chipsUsed'];
		
		$this->initGame();		
	}
	
	function deal()
	{
		global $gameroomDB, $gameroomUser;
		
		if(is_numeric($_GET['bet']))
			$this->bet = $_GET['bet'] * 1;
				
		if (($this->bet > $gameroomUser->cash) || ($this->bet > $this->tableLimit) || ($this->bet == 0))
		{
			exit();
		}

		// Prep and Shuffle 6-decks
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		for($i = 0; $i < 52; $i++) {
			$card[]=$i;
		}
		
		
		srand((float)microtime() * 1000000);
		shuffle($card);

		$query = "DELETE FROM gameroom_blackjack WHERE playerID = $gameroomUser->userID";
		$gameroomDB->query($query);

		// 2 for the dealer 
		for($i = 0; $i < 2; $i++) {
			$query = "INSERT INTO gameroom_blackjack (playerID, cardNum, card, hand, bet) values ($gameroomUser->userID, $i, $card[$i], 1, 0)";  
			$gameroomDB->query($query);
		}
		// 2 for the player
		for($i = 2; $i < 4; $i++) {
			$query = "INSERT INTO gameroom_blackjack (playerID, cardNum, card, hand, bet) values ($gameroomUser->userID, $i, $card[$i], 2, $this->bet)";  
			$gameroomDB->query($query);
		}
		// Load the rest into the reserve 
		for($i = 4; $i < 52; $i++) {
			$query = "INSERT INTO gameroom_blackjack (playerID, cardNum, card, hand, bet) values ($gameroomUser->userID, $i, $card[$i], 0, 0)";  
			$gameroomDB->query($query);
		}

//Check player BJ
//Check Dealer BJ

		//Remove Bet amount from cash

		$gameroomUser->record_cash($this->gameID, $this->bet * -1);
		$this->getHands();
	}
	
	function isGameOver()
	{
		global $gameroomDB, $gameroomUser;

		

		if ($this->isDone)
		{
			return 0;
		}
		else
		{
			$this->isDone = 1;
			$dealer->autoPlay();
		}
		
	}
	
	function userAction()
	{
		global $gameroomUser, $gameroomDB;
			
		$id = $_GET['id'];
		if (($_GET['bet']>0) && ($_GET['action']=="deal"))
		{
			$this->deal();
		}
		else if ($_GET['action']=="hit")
		{
			// Hit 
			$this->hands[$id]->hit();
		}
		else if ($_GET['action']=="stay")
		{
			// Stay
			$this->hands[$id]->stay();
		}
		else if ($_GET['action']=="doubledown")
		{
			// Double Down 
			$this->hands[$id]->doubleDown();
		}
		else if ($_REQUEST['action']=="split")
		{
			// Split 
			//add one to # of hands 
			$this->hands[$id]->split();
		}
		else if ($_REQUEST['action']=="surrender")
		{
			// Split 
			//add one to # of hands 
			$this->hands[$id]->surrender();
		}
		
	}
		function show_status()
		{
			global $gameroomUser;
			
			$this->statusXML = "<status tableLimit='$this->tableLimit' cash='$gameroomUser->cash' bet='$this->bet'  resultText='' chips='$this->isDone' />\n";

		}
		
		function getHands()
		{
			global $gameroomDB, $gameroomUser;
		
			$this->isDone = 0;
			$this->hands = array();
			$query = "
				SELECT DISTINCT(hand)
				FROM gameroom_blackjack 
				WHERE playerID=$gameroomUser->userID
				AND hand > 0 
				ORDER BY hand
			";
			$result = $gameroomDB->query_read($query);
			$i =0 ;
			$this->handsXML ="";
			$notDone  = 0;
			while($row = $gameroomDB->fetch_array($result))
			{
				$id = $row['hand'];
				$this->hands[$id] = new blackJackHand;
				$this->hands[$id]->handID = $row['hand'];
				$this->hands[$id]->getHand();
				$this->hands[$id]->getCardsXML();
				$this->handsXML .= $this->hands[$id]->cardsXML;
				if(!$this->hands[$id]->isDone && $id > 1)
					$notDone = 1;
				$i++;
			}
			if(! $notDone){
				$this->isDone = 1;
			}
				
			$this->numHands = $i;
			if($i == 0)
				$this->loadBlank();
				
		}
	
		function loadBlank()
		{
			$this->handsXML = "
			<hand id='0' hit='0' stay='0' split='0' doubledown='0' deal='0' name='" . $gameroomLanguage['blackjack']['Dealer'] . "'>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			</hand>
			<hand id='0' hit='0' stay='0' split='0' doubledown='0' deal='1' name='" . $gameroomLanguage['blackjack']['Player'] . "'>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			<card img=\"gameroom/images/back-blue-150-1.png\" name=\"\"/>
			</hand>
			";
		}
		
		function settle()
		{
			global $gameroomDB, $gameroomUser;
			$this->handsXML = "";

			foreach ($this->hands as $id => $tHand)
			{	
				if($id > 1)
					$this->hands[$id]->didWin();
				else
					$this->hands[$id]->autoPlay();
				
				$this->hands[$id]->getCardsXML(); 
				$this->handsXML .= $this->hands[$id]->cardsXML;
			}
			$query = "
				DELETE FROM gameroom_blackjack 
				WHERE playerID=$gameroomUser->userID
			";
			$gameroomDB->query_write($query);
			$this->bet = 0;
		}

		function getCardValuesXML()
		{
			global $gameroomLanguage;
			$xml = "<cardValue field1='2' field2='2' />";
			$xml .= "<cardValue field1='3' field2='3' />";
			$xml .= "<cardValue field1='4' field2='4' />";
			$xml .= "<cardValue field1='5' field2='5' />";
			$xml .= "<cardValue field1='6' field2='6' />";
			$xml .= "<cardValue field1='7' field2='7' />";
			$xml .= "<cardValue field1='8' field2='8' />";
			$xml .= "<cardValue field1='9' field2='9' />";
			$xml .= "<cardValue field1='" . $gameroomLanguage['cards']['Jack'] . "' field2='10' />";
			$xml .= "<cardValue field1='" . $gameroomLanguage['cards']['Queen'] . "' field2='10' />";
			$xml .= "<cardValue field1='" . $gameroomLanguage['cards']['King'] . "' field2='10' />";
			$xml .= "<cardValue field1='" . $gameroomLanguage['cards']['Ace'] . "' field2='1 / 11' />";
			return $xml;
		}
}



//======================================================



// =====================================================
	$gameroomUser = new userInfo;
	$gameroomUser->user_info();
	$blackjack = new blackjack;


	$blackjack->init();
	$blackjack->getHands();
	$blackjack->userAction();
	$blackjack->getHands();
	if(($blackjack->isDone) && ($blackjack->numHands > 0))
		$blackjack->settle();
	
	$blackjack->show_status();
	$blackjack->get_chips();
	
	$output = "
		<root>
			$blackjack->chipsXML
			$blackjack->handsXML
			$blackjack->statusXML
			$blackjack->languageXML
			" . $blackjack->getCardValuesXML() . "
		</root>
	";
	printGameroomOutput( $output);


?>