<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/


	$gameroomUser = new userInfo;
	$gameroomUser->user_info();
	
		
	$slots = new slots;
	$slots->init();
	$slots->spin_wheel();
	$slots->eval_spin();
	//$videoPoker->get_status();
	$slots->get_chips();
	$output = "
		<root>
			$slots->chipsXML
			$slots->slotsXML
			" . $slots->getPayoutsXML() . "
		</root>
	";
	printGameroomOutput($output);
	

	class slots
	{
		var $gameID;	
		function init()
		{
			global $gameroomDB;
			
			$this->slotsgame = $_GET['game'];

			if ($this->slotsgame == 1)
				$this->gameID = GAMEID_FRUIT_MACHINE;
			else if ($this->slotsgame == 2) 
				$this->gameID = GAMEID_NINJA_SLOTS;
			else if ($this->slotsgame == 3)
				$this->gameID = GAMEID_BARS_AND_SEVENS;
			else
				exit();

			$this->get_chips();
			$this->get_bet();
		}
		
		function get_chips()
		{
			global $gameroomSettings, $gameroomUser;
			
			$output = "";
			$i = 0;
			foreach ($gameroomSettings->slots['chipsUsed'] as $chip)
			{
				if ($chip <= $gameroomUser->cash)
				{
					$output .= "<chip id=\"$i\" alpha='1' value=\"$chip\" img=\"" . $gameroomSettings->chips[$chip] . "\" />";
					$i++;
				}
			}
			$this->chipsXML = $output;
			
		}
		
		function get_bet()
		{
			global $gameroomUser, $gameroomSettings;
			
			if (is_numeric($_GET['bet']))
			{
				if ((in_array($_GET['bet'], $gameroomSettings->slots['chipsUsed'])) || ($_GET['bet'] == 1))
					$this->bet =  $_GET['bet'];
				else
				{
					$this->bet = 0;
				}
			}
			else
			{
				$this->bet = 0;
			}
			
			if ($this->bet > $gameroomUser->cash)
			{
				$this->bet = 0;
			}
			
			
			// If > cash....
		}

		function spin_wheel()
		{
			if($this->slotsgame == 1)
			{
				// Fruit game setup
				$this->payouts = array(10,1000,200,50,20,3); 
				
				$wheel1 = array(
				1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
				2,2,
				3,3,
				4,4,4,4,
				5,5,5,5,5,5,5,5,
				6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6
				);
				$wheel2 = array(
				1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
				2,
				3,3,3,
				4,4,4,4,
				5,5,5,5,5,5,5,5,
				6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6
				);
				$wheel3 = array(
				1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
				2,
				3,3,3,
				4,4,4,4,
				5,5,5,5,5,5,5,5,
				6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6
				);
				// End Fruit game setup
			}
			else if($this->slotsgame == 2)
			{
				$this->payouts = array(10,15,20,35,250,1); 

				$wheel1 = array(
				1,1,1,1,1,1,1,1,1,1,1,1,
				2,2,2,2,2,2,2,2,2,2,
				3,3,3,3,3,3,3,3,
				4,4,4,4,4,4,
				5,5,
				6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6
				);
				$wheel2 = array(
				1,1,1,1,1,1,1,1,1,1,1,1,
				2,2,2,2,2,2,2,2,2,2,
				3,3,3,3,3,3,3,3,
				4,4,4,4,4,4,
				5,5,
				6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6
				);
				$wheel3 = array(
				1,1,1,1,1,1,1,1,1,1,1,1,
				2,2,2,2,2,2,2,2,2,2,
				3,3,3,3,3,3,3,3,
				4,4,4,4,4,4,
				5,5,
				6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6
				);
			
			}
			else if($this->slotsgame == 3)
			{
				$this->payouts = array(15,5,250,20,15,100,2); 
			
				$wheel1 = array(
				1,1,1,1,1,
				2,2,2,2,2,2,2,2,2,2,2,2,
				3,3,3,
				4,4,4,4,4,4,4,4,
				5,5,5,5,5,5,5,5,5,5,
				6,6,6,6,6,
				7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
				);
				$wheel2 = array(
				1,1,1,1,1,
				2,2,2,2,2,2,2,2,2,2,2,2,
				3,3,3,
				4,4,4,4,4,4,4,4,
				5,5,5,5,5,5,5,5,5,5,
				6,6,6,6,6,
				7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
				);
				$wheel3 = array(
				1,1,1,1,1,
				2,2,2,2,2,2,2,2,2,2,2,2,
				3,3,3,
				4,4,4,4,4,4,4,4,
				5,5,5,5,5,5,5,5,5,5,
				6,6,6,6,6,
				7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
				);
			}
			srand((float)microtime() * 1000000);
			$a = (rand() % 64);
			$this->a = $wheel1[$a];
			$b= (rand() % 64);
			$this->b = $wheel2[$b];
			$c = (rand() % 64);
			$this->c = $wheel3[$c];
		}
		
		
		function eval_spin()
		{
			global $gameroomUser;
			$output = 0;

			// 3 of same
			if(($this->a== $this->b) && ($this->a== $this->c))
			{
				$aa = $this->a-1;
				$output = $this->payouts[$aa];
			}
			else
			{
				// Fruit bonus payouts
				if($this->slotsgame == 1)
				{
					$cherry = 0; 
					if ($this->a== 1){
						$cherry++;
						if ($this->b== 1) $cherry++;
					}
	
					if($cherry == 1) $output = 1;
					if($cherry == 2) $output = 3;
					// End Fruit bonus payouts
				} 
				if($this->slotsgame == 2)
				{
					// Ninja slots 
					$stars = 0; 
					if ($this->a== 1) $stars++;
					if ($this->b== 1) $stars++; 
					if ($this->c == 1) $stars++; 
		
					if($stars == 1) $output = 1;
					if($stars == 2) $output = 2;
		
					// any 3 ninjas 
					if ( (($this->a> 1)&&($this->a< 6)) && (($this->b> 1)&&($this->b< 6)) && (($this->c > 1)&&($this->c < 6)) )
						$output = 3;
				}
				else if($this->slotsgame == 3)
				{
					// bars and 7's 
					$cherry = 0; 
					if ($this->a== 1)
						$cherry++;
					if ($this->b== 1) 
						$cherry++;
					if ($this->c == 1) 
						$cherry++;
		
					if($cherry == 1) $output = 1;
					if($cherry == 2) $output = 2;
			
					// Any 3 7's
					if ( (($this->a== 3)||($this->a== 5) ||($this->a== 6)) && (($this->b== 3)||($this->b== 5) ||($this->b== 6)) && (($this->c == 3)||($this->c == 5) ||($this->c == 6)))
						$output = 3;
					// Any 3 Bars
					if ( (($this->a== 2)||($this->a== 4) ||($this->a== 7)) && (($this->b== 2)||($this->b== 4) ||($this->b== 7)) && (($this->c == 2)||($this->c == 4) ||($this->c == 7)))
						$output = 1;
					// Any 3 Red
					if ( (($this->a== 2)||($this->a== 6)) && (($this->b== 2)||($this->b== 6)) && (($this->c == 2)||($this->c == 6)))
						$output = 2;
					// Any 3 Blue
					if ( (($this->a== 5)||($this->a== 7)) && (($this->b== 5)||($this->b== 7)) && (($this->c == 5)||($this->c == 7)))
						$output = 1;
					// Any 3 Gold
					if ( (($this->a== 3)||($this->a== 4)) && (($this->b== 3)||($this->b== 4)) && (($this->c == 3)||($this->c == 4)))
						$output = 3;
			
					// End Fruit bonus payouts
				} 
			}


			if($output > 0)
				$output = ($output * $this->bet);
			else $output = 0;
			
			$gameroomUser->record_cash($this->gameID, $this->bet * -1);
			$c1 = $gameroomUser->cash;
			$gameroomUser->record_cash($this->gameID, $output );
			$c2 = $gameroomUser->cash;

			$this->slotsXML =  "<slots stop1=\"$this->a\" stop2=\"$this->b\" stop3=\"$this->c\" cashAlpha=\"$c1\" cash=\"$c2\" result=\"$output\" />";
		}
		
		function getPayoutsXML()
		{
			global $gameroomLanguage;

			if ($this->slotsgame == 1)
			{
				$xml = "<payout field1='3 x " . $gameroomLanguage['slots']['Apples'] . "' field2='1000' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Grapes'] . "' field2='200' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Lemons'] . "' field2='50' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Oranges'] . "' field2='20' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Cherries'] . "' field2='10' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Strawberries'] . "' field2='3' />";
				$xml .= "<payout field1='2 x " . $gameroomLanguage['slots']['Cherries'] . "*' field2='3' />";
				$xml .= "<payout field1='1 x " . $gameroomLanguage['slots']['Cherry'] . "*' field2='1' />";
			}
			if ($this->slotsgame == 2)
			{
				$xml = "<payout field1='3 x " . $gameroomLanguage['slots']['Ninja_black'] . " " . $gameroomLanguage['slots']['Ninja_Ninjas'] . "' field2='250' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Ninja_Blue'] . " " . $gameroomLanguage['slots']['Ninja_Ninjas'] . "' field2='35' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Ninja_Green'] . " " . $gameroomLanguage['slots']['Ninja_Ninjas'] . "' field2='20' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Ninja_Red'] . " " . $gameroomLanguage['slots']['Ninja_Ninjas'] . "' field2='15' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Ninja_Stars'] . "' field2='10' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Ninja_Ninjas'] . "' field2='3' />";
				$xml .= "<payout field1='2 x " . $gameroomLanguage['slots']['Ninja_Stars'] . "' field2='2' />";
				$xml .= "<payout field1='1 x " . $gameroomLanguage['slots']['Ninja_Star'] . "' field2='1' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Ninja_Blanks'] . "' field2='1' />";
			}
			if ($this->slotsgame == 3)
			{
				$xml = "<payout field1='3 x " . $gameroomLanguage['slots']['Gold'] . " " . $gameroomLanguage['slots']['Seven_Digit'] . "' field2='250' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Red'] . " " . $gameroomLanguage['slots']['Seven_Digit'] . "' field2='100' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Gold'] . " " . $gameroomLanguage['slots']['Bars'] . "' field2='20' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Blue'] . " " . $gameroomLanguage['slots']['Seven_Digit'] . "' field2='15' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Bars_Cherry'] . "' field2='15' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Red'] . " " . $gameroomLanguage['slots']['Bars'] . "' field2='5' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Seven_Digit'] . "' field2='3' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Gold'] . "' field2='3' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Blue'] . " " . $gameroomLanguage['slots']['Bars'] . "' field2='2' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Red'] . "' field2='2' />";
				$xml .= "<payout field1='2 x " . $gameroomLanguage['slots']['Cherry'] . "' field2='2' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Bar'] . "' field2='1' />";
				$xml .= "<payout field1='3 x " . $gameroomLanguage['slots']['Blue'] . "' field2='1' />";
				$xml .= "<payout field1='1 x " . $gameroomLanguage['slots']['Cherry'] . "' field2='1' />";
			}
			return $xml;
		}		
		
	}
	
		