<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

function loadLanguage()
{
	global $gameroomLanguage, $gameroomUser, $gameroomSettings, $gameroomDB;

	$query = "
		SELECT * 
		FROM gameroom_language
	";
	
	$result = $gameroomDB->query_read($query);
	while ($row = $gameroomDB->fetch_array($result))
	{
		$group = $row['languageGroup'];
		$name = $row['languageName'];
		$gameroomLanguage[$group][$name] = $row['phrase'];
	}
	
}

function getLanguage()
{
	global $gameroomLanguage, $gameroomUser, $gameroomSettings, $gameroomDB;

	$useableTabs = $gameroomSettings->getAllowedTabs();
		
	$output = "<root>\n";
	$output .= "<status logoPath='$gameroomSettings->logoPath' allowTransfers='$gameroomSettings->allowTransfers' 
	userID='$gameroomUser->userID' userName='$gameroomUser->userName' themeColor='$gameroomSettings->themeColor' 
	admin='$gameroomUser->isAdmin' $useableTabs  />";
	$output .= "<language>\n";
		
	foreach ($gameroomLanguage AS $group => $phrases)
	{
		$output .= "<$group ";
		foreach ($phrases as $key => $phrase)
		{
			$output .= "$key='$phrase' ";
		}
		$output .= "/>\n";
	}

	$output .= "</language>\n</root>";
	return $output;
	
}


function getLanguageEdit()
{
	global $gameroomLanguage, $gameroomUser, $gameroomSettings, $gameroomDB;

	$query = "
		SELECT * 
		FROM gameroom_language
	";
	
	$gameroomLanguageNew = $gameroomLanguage;
	include ("gameroom/language.php");
	/*
	$result = $gameroomDB->query_read($query);
	while ($row = $gameroomDB->fetch_array($result))
	{
		$group = $row['languageGroup'];
		$name = $row['languageName'];
		if (! isset ($gameroomLanguageNew[$group]))
			$gameroomLanguageNew[$group] =  array();
		
		$gameroomLanguageNew[$group][$name] = $row['phrase'];
	}
*/
	
	$output = "<root>\n";
	$output .= "<status userID='$gameroomUser->userID' userName='$gameroomUser->userName' themeColor='$gameroomSettings->themeColor' admin='$gameroomUser->isAdmin' />";
		
	foreach ($gameroomLanguage AS $group => $phrases)
	{
		foreach ($phrases as $key => $phrase)
		{
			if (isset($gameroomLanguageNew[$group][$key]))
				$newPhrase = $gameroomLanguageNew[$group][$key];
			else 
				$newPhrase = "";
			
			if ((! strpos($key, "_Text")) && ((! strpos($key, "_Rules"))))
				$output .= "<language group='$group' name='$key' phrase='$phrase' newPhrase='$newPhrase'  />\n";
		}
	}

	$output .= "</root>";
	return $output;
	
}

function saveLanguage()
{
	global $gameroomUser, $gameroomDB, $gameroomSettings;
	
	if(!$gameroomUser->isAdmin) 
		exit();
	
	$group = $_GET['group'];
	$name = $_GET['name'];
	$phrase = htmlspecialchars($_GET['newPhrase'], ENT_QUOTES);

	$query = "DELETE FROM gameroom_language WHERE languageGroup = '$group' and languageName='$name'";
	$gameroomDB->query_write($query);
	if (strlen($phrase) > 0)
	{
		$query = "INSERT INTO gameroom_language (languageGroup, languageName, phrase) VALUES ('$group', '$name', '$phrase')";
		$gameroomDB->query_write($query);
	}
	return "<root><done /></root>";
}

function exportLanguage()
{
	global $gameroomUser, $gameroomDB, $gameroomSettings;
	
	if(!$gameroomUser->isAdmin) 
		exit();

			$query = "
		SELECT * 
		FROM gameroom_language
	";
	$date = date("Y-m-d");
	$contents = "<?php
/*********************************************************************************
 * Gameroom Language File
 * vbgaming.org
 *
 * Generated by " . $gameroomUser->userName . " on " . $date . "
 *
 * To import this language file upload the file to your forums main folder
 * and navigate to it.  Once completed you can remove the file from your 
 * server.
 *
 * WARNING: Importing a language file will overwrite any exiting language
 * modifications you have made.
 *
 *********************************************************************************/
	 
require(\"./global.php\");

\$gameroomDB->query_write(\"DELETE FROM gameroom_language\");
";
	$result = $gameroomDB->query_read($query);
	while ($row = $gameroomDB->fetch_array($result))
	{
		$group = $row['languageGroup'];
		$name = $row['languageName'];
		$phrase = $row['phrase'];
		$contents .=  "\$gameroomDB->query_write(\"INSERT INTO gameroom_language (languageGroup, languageName, phrase) VALUES ('$group', '$name', '$phrase')\");\n";
	}
	$contents .= "\n\necho \"Import completed, you may now delete this file from your server.\";\n\n";
	$contents .= "?>";
	
	header("Content-Disposition: attachment; filename=\"importLanguage.php\"");
	echo $contents;
	
}
?>