<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/
//chdir ("../vbgaming");
require("./global.php");
//chdir ("../Gameroom");
	
require("class_db.php");
$gameroomDB = new gameroomDB();

	class userInfo
	{
		var $userID, $userName, $cash, $userIDField, $uUserTable, $userNameField, $cashType, $isAdmin;
		
		function getAvatars($gameroomUserIDs)
		{
			global $gameroomDB, $gameroomSettings;
			$avatarArray = array();
			
			if (! $gameroomSettings->useVB)
				return $avatarArray;
				
			$query = "
				SELECT " .$gameroomSettings->userTable . ".userID, avatarPath, " . TABLE_PREFIX . "customavatar.userID AS avatarID, " . TABLE_PREFIX . "customavatar.dateline
				FROM " .$gameroomSettings->userTable . "
				LEFT JOIN " . TABLE_PREFIX . "avatar ON " . TABLE_PREFIX . "user.avatarID = " . TABLE_PREFIX . "avatar.avatarID
				LEFT JOIN " . TABLE_PREFIX . "customavatar ON " . TABLE_PREFIX . "user.userID = " . TABLE_PREFIX . "customavatar.userID
				WHERE " . TABLE_PREFIX . "user.userID IN ($gameroomUserIDs)
			";
			$result = $gameroomDB->query_read($query);
			
			while ($row = $gameroomDB->fetch_array($result))
			{
				$gameroomUserID = $row['userID'];
				$avatarPath = $row['avatarPath'];
				$avatarID = $row['avatarID'];
				
				if($avatarID > 0)
				{
					$path = "image.php?u=" . $avatarID . "&amp;dateline=" . $row['dateline'];
				}
				else if (strlen($avatarPath) > 0)
				{
					$path = $avatarPath;
				}
				else
				{
					$path = "";
				}
				$avatarArray[$gameroomUserID] = $path;
			}
			return $avatarArray;
		}
		
		function memberOf($ut)
		{
			global $vbulletin;
			if (is_member_of($vbulletin->userinfo, $ut))
				return true;
			else
				return false;
			
		}
		function user_info()
		{
			global $gameroomDB, $gameroomSettings;
			
			if ($gameroomSettings->useVB)
			{
				global $vbulletin;
				$this->userName = htmlspecialchars($vbulletin->userinfo['username'], ENT_QUOTES); 
				$this->userID = $vbulletin->userinfo['userid'];

				if (in_array($this->userID, $gameroomSettings->adminIDs))
					$this->isAdmin = 1;
				else 
					$this->isAdmin = 0;
				
				foreach ($gameroomSettings->allowedUserTypes as $au) 
					if (is_member_of($vbulletin->userinfo, $au))
					{
						$allowedin = 1;
					}
				
				if(! $allowedin)
					notLoggedIn();		
				
			}
			

			
			$getuserinfo = $gameroomDB->query_read("
				SELECT $gameroomSettings->cashType
				FROM  $gameroomSettings->userTable
				WHERE $gameroomSettings->userIDField = $this->userID
			");
				
	
			$gameroomUserinfo = $gameroomDB->fetch_array($getuserinfo);
			$this->cash = floor($gameroomUserinfo[$gameroomSettings->cashType]); 
		}	
		
		function resetCash()
		{
			global $gameroomDB, $gameroomSettings;
			$query = "
				UPDATE $gameroomSettings->userTable
				SET $gameroomSettings->cashType = $gameroomSettings->defaultCash
				WHERE $gameroomSettings->userIDField = $this->userID
			";
			$gameroomDB->query_write($query);
			
		}
		
		function record_cash($gameID, $amount, $gameroomUserID = -1)
		{
			global $gameroomDB, $gameroomSettings;
			if ($gameroomUserID == -1)
				$this->cash = $this->cash + $amount;

			if($gameroomUserID == -1)
				$gameroomUserID = $this->userID;
			
				$query = "
					SELECT $gameroomSettings->cashType AS cash
					FROM $gameroomSettings->userTable 
					WHERE $gameroomSettings->userIDField = $gameroomUserID
				";
				$result = $gameroomDB->query_read($query);
				$row = $gameroomDB->fetch_array($result);
				$cash = $row['cash'];
				
				$cash = $cash + $amount;
				if ($cash < 0)
				{
					$cash = 0;
					$amount = $cash * -1;
				}
			$gameroomDB->query_write("
				UPDATE $gameroomSettings->userTable 
				SET $gameroomSettings->cashType = $gameroomSettings->cashType + $amount
				WHERE $gameroomSettings->userIDField = $gameroomUserID
			");
				
			$this->checkBetStatsExist($gameroomUserID, $gameID);
			if($amount < 0)
			{
				$gameroomDB->query_write ("
					UPDATE gameroom_bet_stats
					SET bet = bet + $amount
					WHERE userid = $gameroomUserID
					AND gameid = $gameID
					LIMIT 1
				");		
			}
			else 
			{
				$gameroomDB->query_write ("
					UPDATE gameroom_bet_stats
					SET won = won + $amount
					WHERE userid = $gameroomUserID
					AND gameid = $gameID
					LIMIT 1
				");

			}
			return $amount;
		}
		function checkBetStatsExist($gameroomUserID, $gameID)
		{
			global $gameroomDB, $gameroomSettings, $gameroomUser;
			
			$query = "
				SELECT COUNT(*) 
				FROM gameroom_bet_stats
				WHERE userID = $gameroomUserID
				AND gameID = $gameID
			";
			$result = $gameroomDB->query_read($query);
			if ($row = $gameroomDB->fetch_array($result))
			{
				if ( $row[0] == 0)
				{
					$query = "INSERT INTO gameroom_bet_stats (gameID, userID, bet, won) VALUES ($gameID, $gameroomUserID, 0, 0)";
					$gameroomDB->query_write($query);
				}
			}
		}
	}

	class casinoGame
	{
		var $gameID, $tableLimit, $gameName, $chipsUsed, $permissions;
		var $cashType, $cash, $chipArray, $bet, $hand;
		var $chipsXML;
		var $gameroomLanguage;
		var $gameCode;

		
		function initGame()
		{
			global $gameroomDB;

			//$this->get_language();
			if ($this->chipsUsed)
			{
				$this->get_chips();
				$this->get_bet();
			}
		}
		
		function no_permissions()
		{
			print_no_permission();
			exit();
		}
		
		function get_chips()
		{
			global $gameroomSettings, $gameroomUser;
				
			$output = "";
			$i = 0;
			foreach ($this->chipsUsed as $chip)
			{
				if ($chip <= $gameroomUser->cash)
				{
					$output .= "<chip id=\"$i\" alpha='1' value=\"$chip\" img=\"" . $gameroomSettings->chips[$chip] . "\" />";
					$i++;
				}
			}
			$this->chipsXML = $output;
			
		}
		
		
		function get_bet()
		{
			global $gameroomUser;
			
			if ((isset($_GET['bet']) && (is_numeric($_GET['bet']))))
			{
				if (in_array($_GET['bet'], $this->chipsUsed)) 
					$this->bet =  $_GET['bet'];
				else
				{
					$this->bet = 0;
				}
			}
			else
			{
				$this->bet = 0;
			}
			
			if ($this->bet > $gameroomUser->cash)
			{
				$this->bet = 0;
			}
		}
		
		
		function evalCard($card)
		{
			global $gameroomLanguage;
			
			$faceValue = $card % 13;
			$suit = floor($card/13);
			
			if($suit==0)
			{
				$cardfile = "gameroom/images/spades-"; 
				$cardname = $gameroomLanguage['cards']['Spades']; 
			}
			else if($suit==1)
			{
				$cardfile = "gameroom/images/diamonds-";
				$cardname = $gameroomLanguage['cards']['Diamonds']; 
			}
			else if($suit==2)
			{
				$cardfile = "gameroom/images/hearts-";
				$cardname = $gameroomLanguage['cards']['Hearts'];
			}
			else if($suit==3)
			{
				$cardfile = "gameroom/images/clubs-";
				$cardname = $gameroomLanguage['cards']['Clubs'];
			}
	
			if($faceValue+2<11)
			{
				$cardfile .= ($faceValue+2) . "-150.png";
				$cardname = ($faceValue+2) . $gameroomLanguage['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==11)
			{
				$cardfile .= "j-150.png"; 
				$cardname = $gameroomLanguage['cards']['Jack'] . $gameroomLanguage['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==12)
			{
				$cardfile .= "q-150.png"; 
				$cardname = $gameroomLanguage['cards']['Queen'] . $gameroomLanguage['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==13)
			{
				$cardfile .= "k-150.png"; 
				$cardname = $gameroomLanguage['cards']['King'] . $gameroomLanguage['cards']['Of'] . $cardname; 
			}
			else if($faceValue+2==14)
			{
				$cardfile .= "a-150.png"; 
				$cardname = $gameroomLanguage['cards']['Ace'] . $gameroomLanguage['cards']['Of'] . $cardname; 
			}
			
			$output = array();
			$output['faceValue'] = $faceValue;
			$output['suit'] = $suit;
			$output['cardFile'] = $cardfile;
			$output['cardName'] = $cardname;
			
			return $output;
		}
		
		
	}

	

?>