<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

require ("gameroom/chatroom.php");
require ("gameroom/chess.php");
require ("gameroom/reversi.php");
//require ("gameroom/class_4inarow.php");
//require ("gameroom/boardgame_checkers.php");
//require ("gameroom/class_battleship.php");

define (GAMETYPE_CHESS, 1);
define (GAMETYPE_REVERSI, 2);
define (GAMETYPE_CONNECT4, 3);
define (GAMETYPE_CHECKERS, 4);
define (GAMETYPE_BATTLESHIP, 5);
define (TIMEOUT_MINOR, 15); // time out before game has started, or if game has started show warning
define (TIMEOUT_MAJOR, 60); // time out to disqualify after a game has started
define (TIMECONTROL_NONE, 0);
define (TIMECONTROL_BLITZ, 1);
define (TIMECONTROL_STANDARD, 2);
define (TIMECONTROL_INCREMENT, 3);

define (FLAG_CANMOVE_1, 1);
define (FLAG_CANMOVE_2, 2);
define (FLAG_INCHECK_1, 4);
define (FLAG_INCHECK_2, 8);

class boardGame
{
	var $gameID, $chatID, $maxPlayers, $numPlayers, $locked, $mySeat, $gameroomChatroom, $turn, $ranked;
	var $gameStarted = false;
	var $drawOffer = 0;
	var $winner = null, $gameOverAlone = 0;
	var $player1ID, $player2ID, $player1Name, $player2Name;
	var $timeOutWarning;
	var $timeControl, $timeRules;
	var $lastUpdate;
	var $gameType;
	var $flags, $counter;
	var $board;
	
	var $validMoveStatus = true;
	var $statusFlags;
	
	function makeSenseOfTimeControl($type, $timeRules)
	{
		global $gameroomLanguage;
		if ($type == TIMECONTROL_NONE)
		{
			return $gameroomLanguage['boardgame']['None'];
		}
		else if ($type == TIMECONTROL_BLITZ)
		{
			return $type = $gameroomLanguage['boardgame']['Blitz'] ." (" . $timeRules . " " .$gameroomLanguage['boardgame']['Mins'] . ")";
		}
		else if ($type == TIMECONTROL_STANDARD)
		{
			$t = explode(",",$timeRules);
			return $type = $gameroomLanguage['boardgame']['Standard'] ." (" . $t[0] . "/" . $t[1] . ", " . $t[2] . "/" . $gameroomLanguage['boardgame']['Mins'] . ")";
		}
		else if ($type == TIMECONTROL_INCREMENT)
		{
			$t = explode (",",$timeRules);
			return $type = $gameroomLanguage['boardgame']['Increment'] . " (" . $t[0] . "" . $gameroomLanguage['boardgame']['Mins'] . ", " . $t[1] . "" . $gameroomLanguage['boardgame']['sec'] . " " . $gameroomLanguage['boardgame']['Inc'] . ")";
		}
	}
	function getChat()
	{
		global $gameroomUser, $gameroomDB;

		$query = "
			SELECT lastUpdate
			FROM gameroom_board_game_players
			WHERE gameID = $this->gameID
			AND playerID = $gameroomUser->userID
		";
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		$this->lastUpdate = $row['lastUpdate'];
		
		$this->chatroom = new chatRoom;
		$this->chatroom->init();
		$this->chatroom->getMessages();

		$this->chatroom->getXMLNoRoot();
		
		$ready = "";
		if (isset($_GET['startgame']))
		{
			if ($_GET['startgame'] == "1")
				$ready = ",	ready = 1";
			else if ((! $this->gameStarted) && ($_GET['startgame'] == "0"))
				$ready = ",	ready = 0";
		}	
		$time = time();
		$query = "
			UPDATE gameroom_board_game_players
			SET lastUpdate = $time 
				$ready
			WHERE gameID = $this->gameID
			AND playerID = $gameroomUser->userID
		";
		$gameroomDB->query_write($query);
	}
	
	function systemMsg($msg, $gameroomUserName)
	{
		global $gameroomDB, $gameroomUser;
		
		$msgColor = "000000";

		$msg = "\x3Cb>" . $msg . "\x3C/b>";
		$time = time();
		$query = "
			INSERT INTO gameroom_chatlog
				(chatID, userID, userName, msgTime, msgColor, msg)
			VALUES
				($this->chatID, 0, '$gameroomUserName', $time, '$msgColor', '$msg')
		";
		$gameroomDB->query_write($query);
		
	}
	
	/*
	 * Drop games where everyone has timed out (abandoned games)
	 */
	function dropDeadGames()
	{
		global $gameroomUser, $gameroomDB;
		$timeOut = time() - TIMEOUT_MINOR;

		$query = "
			SELECT gameroom_board_game.gameID
			FROM gameroom_board_game
			LEFT JOIN gameroom_board_game_players ON gameroom_board_game.gameID = gameroom_board_game_players.gameID
			WHERE winner is NULL
			GROUP BY gameroom_board_game.gameID 
			HAVING MAX(lastUpdate) < $timeOut
		";
		$result = $gameroomDB->query_read($query);
		$deadPlayers = array();
		while($row = $gameroomDB->fetch_array($result))
		{
			$deadPlayers[] = $row['gameID'];
		}
		$deadPlayers = implode(",", $deadPlayers);
		$query = "
			DELETE FROM gameroom_board_game_players
			WHERE gameID IN	($deadPlayers)
		";
		if ($deadPlayers)
			$gameroomDB->query_write($query);


		$query = "
			SELECT gameroom_board_game.gameID
			FROM gameroom_board_game
			LEFT JOIN gameroom_board_game_players ON gameroom_board_game.gameID = gameroom_board_game_players.gameID
			WHERE playerID IS NULL
		";
		$result = $gameroomDB->query_read($query);
		$deadGames = array();
		while($row = $gameroomDB->fetch_array($result))
		{
			$deadGames[] = $row['gameID'];
		}
		$deadGames = implode(",", $deadGames);
					
		$query = "
			DELETE FROM gameroom_board_game
			WHERE gameID IN	($deadGames)
			AND winner is NULL
		";
		if ($deadGames)
			$gameroomDB->query_write($query);
	}
	
	function getGames($html = false)
	{
		global $gameroomUser, $gameroomDB, $gameroomLanguage;
		$this->dropDeadGames();
		$query = "
			SELECT gameroom_board_game.gameID, chatID, gameName, gameroom_board_game.maxPlayers, playerName, timeControl, timeRules, ranked, rank, password, gameroom_board_game.gameType
			FROM gameroom_board_game
			LEFT JOIN gameroom_board_game_players ON gameroom_board_game.gameID = gameroom_board_game_players.gameID
			LEFT JOIN gameroom_rank ON gameroom_rank.gameType = gameroom_board_game.gameType AND gameroom_rank.userID = gameroom_board_game_players.playerID
			WHERE gameroom_board_game.winner IS NULL
		";
		$result = $gameroomDB->query_read($query);
		
		if($html)
			$output = "";
		else
			$output = "<root>";
		$lastID = 0;
		while ($row = $gameroomDB->fetch_array($result))
		{
			if (($row['gameID'] == $lastID) && ($numPlayers > 0))
			{
				$numPlayers++;
				$playerNames .= " vs " . htmlspecialchars($row['playerName'], ENT_QUOTES);
				if ($row['ranked'])
					$playerNames .= " (" . $row['rank'] . ")";	
			}
			else
			{
				if ($lastID > 0)
				{
					if ($gameType == GAMETYPE_CHESS)
						$gameName = $gameroomLanguage['chess']['nameChess'];
					else if ($gameType == GAMETYPE_REVERSI)
						$gameName = $gameroomLanguage['reversi']['Reversi'];
					else if ($gameType == GAMETYPE_CONNECT4)
						$gameName = $gameroomLanguage['fourinarow']['Four_In_A_Row'];
					else if ($gameType == GAMETYPE_CHECKERS)
						$gameName = $gameroomLanguage['checkers']['Checkers'];
					else if ($gameType == GAMETYPE_BATTLESHIP)
						$gameName = $gameroomLanguage['battleship']['Battleship'];
											
					$players = $numPlayers . " / " . $maxPlayers;
					if ($html)
					{
						if ($output == "")
							$output .= $name . " - " . $gameName . " - (" . $players . ")";
						else
							$output .= "<br/>" . $name . " - " . $gameName . " - (" . $players . ")";
					}
					else
						$output .= "<game gameType='$gameType' id='" . $lastID . "' chatID='" . $chatID . "' name='" . $gameName . "' gameName='" . $name . "' numPlayers='" . $numPlayers . "' maxPlayers='" . $maxPlayers . "' players='$players' playerNames=\"$playerNames\" timeControl='$timeControl' ranked='$ranked' password='$password' flags='$flags' />";
				}
				if ($row['playerName'] != null)
					$numPlayers = 1;
				else $numPlayers = 0;
				$playerNames =  htmlspecialchars($row['playerName'], ENT_QUOTES);
				if ($row['ranked'])
					$playerNames .= " (" . $row['rank'] . ")";
						
				$lastID = $row['gameID'];
				$maxPlayers = $row['maxPlayers'];
				$name = $row['gameName'];
 				$gameType = $row['gameType'];
 				$chatID = $row['chatID'];
 				$ranked = $row['ranked'];
 				if ($row['password'])
 					$password = 1;
 				else 
 					$password = "0";
 				$flags = "";
 				if ($ranked)
 					$flags .= $gameroomLanguage['boardgame']['Ranked_Flag'];
 				if ($password)
 					$flags .= $gameroomLanguage['boardgame']['Password_Flag'];;
 					
 				$timeControl = $this->makeSenseOfTimeControl($row['timeControl'], $row['timeRules']);
			}
		}
		$players =  $numPlayers . " / " . $maxPlayers;
		if ($lastID)
		{
			if ($gameType == GAMETYPE_CHESS)
				$gameName = $gameroomLanguage['chess']['Chess'];
			else if ($gameType == GAMETYPE_REVERSI)
				$gameName = $gameroomLanguage['reversi']['Reversi'];
			else if ($gameType == GAMETYPE_CONNECT4)
				$gameName = $gameroomLanguage['fourinarow']['Four_In_A_Row'];
			else if ($gameType == GAMETYPE_CHECKERS)
				$gameName = $gameroomLanguage['checkers']['Checkers'];
			else if ($gameType == GAMETYPE_BATTLESHIP)
				$gameName = $gameroomLanguage['battleship']['Battleship'];
				
			if ($html)
			{
				if ($output == "")
					$output .= $name . " - " . $gameName . " - (" . $players . ")";
				else
					$output .= "<br/>" . $name . " - " . $gameName . " - (" . $players . ")";
			}
			else
				$output .= "<game gameType='$gameType' id='" . $lastID . "' chatID='" . $chatID . "' name='" . $gameName . "' gameName='" . $name . "' numPlayers='" . $numPlayers . "' maxPlayers='" . $maxPlayers . "' players='$players' playerNames=\"$playerNames\" timeControl='$timeControl' ranked='$ranked' password='$password' flags='$flags' />";
		}
		if (! $html)
			$output .= "</root>";
		return $output;		
	}

	function init()
	{
		global $gameroomUser, $gameroomDB, $gameroomLanguage;
		
		if ($_GET['req'] == 'getgames')
		{
			$output = $this->getGames();
			printGameroomOutput( $output);
			exit();				
		}
		else if ($_GET['req'] == 'startgame')
		{
			$output = $this->createGame();
			printGameroomOutput( $output);
			exit();				
		}
		else if ($_GET['req'] == 'joingame')
		{
			//$output = "<root error='1'></root>";
			$this->joinGame();
			printGameroomOutput( $this->xml);
			exit();				
		}
		$this->gameID = $_GET['gameID'] * 1;
		
		
		$query = "
			SELECT * 
			FROM gameroom_board_game_players
			LEFT JOIN gameroom_board_game ON gameroom_board_game_players.gameID = gameroom_board_game.gameID
			WHERE gameroom_board_game.gameID = $this->gameID
			AND playerID = $gameroomUser->userID
		";
		$result = $gameroomDB->query_read($query);
		
		if ($row = $gameroomDB->fetch_array($result))
		{
			if ($row['nextGameID'])
			{
				// moved to a new game, update.
				$this->gameID = $row['nextGameID'];
				$query = "
					SELECT * 
					FROM gameroom_board_game_players
					LEFT JOIN gameroom_board_game ON gameroom_board_game_players.gameID = gameroom_board_game.gameID
					WHERE gameroom_board_game.gameID = $this->gameID
					AND playerID = $gameroomUser->userID
				";
				$result = $gameroomDB->query_read($query);
				$row = $gameroomDB->fetch_array($result);	
			}
			$this->gameType = $row['gameType'];
			$this->gameStarted = $row['gameStarted'];
			$this->gameID = $row['gameID'];
			$this->maxPlayers = $row['maxPlayers'];
			$this->numPlayers = $row['numPlayers'];
			$this->mySeat = $row['seatID'];
			$this->locked = $row['locked'];
			$this->chatID = $row['chatID'];
			$this->turn = $row['move'];
			$this->counter = $row['counter'];
			$this->winner = $row['winner'];
			$this->ranked = $row['ranked'];
			$this->timeControl = $row['timeControl'];
			$this->timeRules = $row['timeRules'];
			$this->flags = $row['flags'];
			$this->statusFlags = $row['statusFlags'];
			
			if (($row['drawOffer'] > 0) && ($row['drawOffer'] != $gameroomUser->userID) && ( $this->winner == null))
			{
				$this->drawOffer = 1;
				if ($_GET['req'] == 'draw')
				{
					// draw was accepted
					$this->setWinner("0");
					$this->systemMsg($gameroomLanguage['boardgame']['Draw_Accepted'], $gameroomUser->userName);
					$this->drawOffer = 0;
					
				}
			}	
				
			if ((!$this->gameStarted) || ($this->winner == "0")|| ($this->winner > 0))
				$this->checkGameStart();
			if (isset($_GET['test']))
			{
				echo "((!$this->gameStarted) || (!$this->winner === null))";
				if ((!$this->gameStarted) || (!$this->winner === null))
					echo "true";
				exit();
			}
			
		}
		else
		{
			$this->xml = "<root><status error='" . $gameroomLanguage['boardgame']['Game_No_Longer_Exists'] . "' /></root>";
			printGameroomOutput($this->xml);
			exit();
		}
		$this->checkDroppedPlayers();
		if (($this->gameID) && ($_GET['req'] == 'draw'))
		{
			$query = "
				UPDATE gameroom_board_game
				SET drawOffer = $gameroomUser->userID
				WHERE gameroom_board_game.gameID = $this->gameID
			";
			$result = $gameroomDB->query_write($query);
		}
		else if (($this->gameID) && ($_GET['req'] == 'nodraw'))
		{
			$this->drawOffer = 0;
			$this->systemMsg($gameroomLanguage['boardgame']['Draw_Rejected'], $gameroomUser->userName);
			$query = "
				UPDATE gameroom_board_game
				SET drawOffer = NULL
				WHERE gameroom_board_game.gameID = $this->gameID
			";
			$result = $gameroomDB->query_write($query);
		}

		if (($this->gameID) && ($_GET['req'] == 'surrender'))
		{
			$this->surrender();
		}
		
		
	}

	function checkDroppedPlayers()
	{
		global $gameroomDB, $gameroomUser, $gameroomLanguage;
		// game hasn't started, just delete them
		if (! $this->winner)
		{
			
			if (! $this->gameStarted)
			{
				$timeout = time() - TIMEOUT_MINOR;
				$query = "
					DELETE FROM gameroom_board_game_players
					WHERE gameID = $this->gameID
					AND lastUpdate < $timeout
				";
				$gameroomDB->query_write($query);
			}	
			else if ($this->winner == null)
			{
				// game has started, offer timeout to win or draw
				$timeout = time() - TIMEOUT_MAJOR;
				$query = "
					SELECT *
					FROM gameroom_board_game_players
					WHERE gameID = $this->gameID
					AND lastUpdate < $timeout
				";
				$result = $gameroomDB->query_write($query);
				if ($row = $gameroomDB->fetch_array($result))
				{
					// player is gone, remove them from game
					$this->systemMsg($gameroomLanguage['boardgame']['Opponent_Has_Left'], $gameroomLanguage['boardgame']['System_Name']);
					$this->setWinner($gameroomUser->userID);
				}
				
				
				$timeout = time() - TIMEOUT_MINOR;
				$query = "
					SELECT *
					FROM gameroom_board_game_players
					WHERE gameID = $this->gameID
					AND lastUpdate < $timeout
				";
				$result = $gameroomDB->query_write($query);
				if ($row = $gameroomDB->fetch_array($result))
				{
					// player appears dropped, warn other player
					//$this->timeOutWarning['name'] = $row['playerName'];
					$this->timeOutWarning = TIMEOUT_MAJOR - (time() - $row['lastUpdate']);
				}
				
			}
		}
		else if ( $this->winner)
		{
			$timeout = time() - TIMEOUT_MINOR;
			$query = "
				SELECT *
				FROM gameroom_board_game_players
				WHERE gameID = $this->gameID
				AND lastUpdate < $timeout
			";
			$result = $gameroomDB->query_write($query);
			if ($row = $gameroomDB->fetch_array($result))
			{
				// opponent is gone, sitting here alone...
				$this->gameOverAlone = 1;
			}			
		}
			
	}
	function checkGameStart()
	{
		global $gameroomDB, $gameroomUser;
		// game hasn't started, just delete them
		$query = "
			SELECT COUNT(playerID) AS playersReady, winner, gameName, password, ranked, timeControl, timeRules
			FROM gameroom_board_game_players
			LEFT JOIN gameroom_board_game ON gameroom_board_game_players.gameID = gameroom_board_game.gameID
			WHERE gameroom_board_game_players.gameID = $this->gameID
			AND ready = 1
			GROUP BY gameroom_board_game_players.gameID
		";
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		if ($row['playersReady'] == $this->maxPlayers)
		{
			if ($row['winner'] === null)
			{
				$this->gameStarted = true;
				$time = time();
				$query = "
					UPDATE gameroom_board_game
					SET gameStarted = 1,
						startTime = $time
					WHERE gameID = $this->gameID
				";
				$gameroomDB->query_write($query);
				$this->startTimeControl();
				$game->validMoveStatus = false;
			}
			else
			{
				//Is this a new game ontop of a completed one?
				//addGame($gameType, $name, $password, $ranked, $timeControl, $time)
				$this->addGame($this->gameType, $row['gameName'], $row['password'], $row['ranked'], $row['timeControl'], $row['timeRules'],$this->chatID, $this->gameID);
				$this->startTimeControl();
				$game->validMoveStatus = false;
			}
		}
		// game has started, offer timeout to win or draw
		
	}
	
	function startTimeControl()
	{
		global $gameroomDB, $gameroomUser;
		$time = time();
		if ($this->timeControl == TIMECONTROL_BLITZ)
		{
			$timeRemaining = $this->timeRules * 60;
			$query = "
				UPDATE gameroom_board_game_players
				SET timeRemaining = $timeRemaining,
					turn = 0
				WHERE gameID = $this->gameID
			";
			$gameroomDB->query_write($query);
		}
		else if ($this->timeControl == TIMECONTROL_STANDARD)
		{
			$t = explode(",",$this->timeRules);
			$timeRemaining = $t[1] * 60;
			
			$query = "
				UPDATE gameroom_board_game_players
				SET timeRemaining = $timeRemaining,
					turn = 0
				WHERE gameID = $this->gameID
			";
			$gameroomDB->query_write($query);
		}
		else if ($this->timeControl == TIMECONTROL_INCREMENT)
		{
			$t = explode(",", $this->timeRules);
			$timeRemaining = $t[0] * 60;
			
			$query = "
				UPDATE gameroom_board_game_players
				SET timeRemaining = $timeRemaining,
					turn = 0,
					turnStartTime = $time
				WHERE gameID = $this->gameID
			";
			$gameroomDB->query_write($query);
		}
		$time = time();
		$query = "
				UPDATE gameroom_board_game_players
				SET turnStartTime = $time
				WHERE gameID = $this->gameID
				AND seatID = 1
		";
		$gameroomDB->query_write($query);
		
	}
	
	function runGame()
	{
		global $gameroomChatroom;
		$this->getChat();
		if($this->gameType == GAMETYPE_CHESS)
		{
			$chess = new chessGame();
			$chess->gameID = $this->gameID;
			$chess->chatID = $this->chatroom->chatID;
			$chess->whosTurn = $this->turn;
			$chess->myColor = $this->mySeat;
			$chess->init();
			$this->pageXML = "<root>\n";
			$this->pageXML .= $chess->pageXML;
			$this->pageXML .= $this->chatroom->xml;
			$this->pageXML .= "</root>";
		}
		else if($this->gameType == GAMETYPE_REVERSI)
		{
			$reversi = new reversiGame();
			$reversi->gameID = $this->gameID;
			$reversi->chatID = $this->chatroom->chatID;
			$reversi->whosTurn = $this->turn;
			$reversi->myColor = $this->mySeat;
			$reversi->init();
			$this->pageXML = "<root>\n";
			$this->pageXML .= $reversi->pageXML;
			$this->pageXML .= $this->chatroom->xml;
			$this->pageXML .= "</root>";
		}
		else if($this->gameType == GAMETYPE_CONNECT4)
		{
			$connect4 = new fourInARow();
			$connect4->gameID = $this->gameID;
			$connect4->chatID = $this->chatroom->chatID;
			$connect4->whosTurn = $this->turn;
			$connect4->myColor = $this->mySeat;
			$connect4->init();
			$this->pageXML = "<root>\n";
			$this->pageXML .= $connect4->pageXML;
			$this->pageXML .= $this->chatroom->xml;
			$this->pageXML .= "</root>";
		}
		else if($this->gameType == GAMETYPE_CHECKERS)
		{
			$checkers = new checkers();
			$checkers->gameID = $this->gameID;
			$checkers->chatID = $this->chatroom->chatID;
			$checkers->whosTurn = $this->turn;
			$checkers->myColor = $this->mySeat;
			$checkers->init();
			$this->pageXML = "<root>\n";
			$this->pageXML .= $checkers->pageXML;
			$this->pageXML .= $this->chatroom->xml;
			$this->pageXML .= "</root>";
		}
		else if($this->gameType == GAMETYPE_BATTLESHIP)
		{
			$connect4 = new battleship();
			$connect4->gameID = $this->gameID;
			$connect4->chatID = $this->chatroom->chatID;
			$connect4->whosTurn = $this->turn;
			$connect4->myColor = $this->mySeat;
			$connect4->init();
			$this->pageXML = "<root>\n";
			$this->pageXML .= $connect4->pageXML;
			$this->pageXML .= $this->chatroom->xml;
			$this->pageXML .= "</root>";
		}
		printGameroomOutput( $this->pageXML);
		
	}
	
	function createGame()
	{
		global $gameroomUser, $gameroomDB;
		$gameType = $_GET['gameType'];
		
		if (($gameType == GAMETYPE_CHESS) || ($gameType == GAMETYPE_REVERSI) || ($gameType == GAMETYPE_CONNECT4) || ($gameType == GAMETYPE_CHECKERS) || ($gameType == GAMETYPE_BATTLESHIP))
		{
			$name = htmlspecialchars($_GET['name'], ENT_QUOTES);
			$password = htmlspecialchars($_GET['password'], ENT_QUOTES);
			$ranked = $_GET['ranked'];
			$timeControl = $_GET['timecontrol'] * 1;
			if($timeControl == 1)
				$time = $_GET['time'];
			else if($timeControl == 2)
				$time = explode(",", $_GET['time']);
			else if($timeControl == 3)
				$time = explode(",", $_GET['time']);
			else $time = null;
			
			$valid = $this->validateSettings($gameType, $name, $password, $ranked, $timeControl, $time);

			if($valid)
			{
				$output = $this->addGame($gameType, $name, $password, $ranked, $timeControl, $time);
				return $output;
			}
			else
			{
				return "<root error='1'></root>";
			}
		}
		else
			return "<root error='2'></root>";
		
	}
	
	function validateSettings($gameType, $name, $password, $ranked, $timeControl, $time)
	{
		if ((strlen($name) < 4))
			return 0;
		if (!(($ranked == 1) || ($ranked == 0)))
			return 0;
		if (!(($timeControl == 1) || ($timeControl == 0) || ($timeControl == 2) || ($timeControl == 3)))
			return 0;
		if (($timeControl == 1) && ((! is_numeric($time[0]) || ($time[0] == 0))))
			return 0;
		if (($timeControl == 2) && ((! is_numeric($time[0]) || ($time[0] == 0))) && ((! is_numeric($time[1]) || ($time[1] == 0))) && ((! is_numeric($time[2]) || ($time[2] == 0))))
			return 0;
		if (($timeControl == 3) && ((! is_numeric($time[0]) || ($time[0] == 0))) && ((! is_numeric($time[1]) || ($time[1] == 0))))
			return 0;
		if (($password) && (strlen($password) < 4) || (strlen($password) > 20))
			return 0;
			
		return 1;
	}

	function addGame($gameType, $name, $password, $ranked, $timeControl, $time, $chatID = 0, $lastGameID = 0)
	{
		global $gameroomDB, $gameroomUser, $gameroomChatroom;

		require_once('gameroom/class_elo.php');
		$elo = new ranking($gameType,$gameroomUser->userID, $gameroomUser->userID, 0);
		
		if ($chatID == 0)
		{
			$query = "
				INSERT INTO gameroom_chat
				 	(name)
				 VALUES
				 	('$name')
			";
			$gameroomDB->query_write($query);
//			$chatID = "(SELECT MAX(chatID) FROM gameroom_chat WHERE name = '$name')";
			$query = "SELECT MAX(chatID) AS chatID FROM gameroom_chat WHERE name = '$name'";
			$result = $gameroomDB->query_read($query);
			$row = $gameroomDB->fetch_array($result);
			$chatID = $row['chatID'];
		}
		if (is_array($time))
			$time = implode(',',$time);
		else
			$time = $time;
		$password = base64_encode($password);
		
		$query = "
			INSERT INTO gameroom_board_game
				(gameName, maxPlayers, move, ranked, password, chatID, gameType, timeControl, timeRules)	
			VALUES
				('$name', 2, 1, $ranked, '$password', $chatID, $gameType, $timeControl, '" . $time ."')	
		";
		$gameroomDB->query_write($query);
		
		$query = "
			SELECT gameID, chatID
			FROM gameroom_board_game
			WHERE gameName = '$name'
			ORDER BY gameID DESC
			LIMIT 1
		";
		$result = $gameroomDB->query_read($query);
		$row = $gameroomDB->fetch_array($result);
		
		$this->gameID = $row['gameID'];
		$gameroomChatroom->chatID = $row['chatID'];

		$time = time();
		
		if ($lastGameID == 0)
		{
			$query = "
				INSERT INTO gameroom_board_game_players
					(gameID, playerID, seatID, lastUpdate, playerName)
				VALUES
					($this->gameID, $gameroomUser->userID, 1, $time, '$gameroomUser->userName')
			";
			$gameroomDB->query_write($query);
		}
		else
		{
			$query = "
				UPDATE gameroom_board_game
				SET nextGameID = $this->gameID
				WHERE gameID = $lastGameID
			";
			$gameroomDB->query_write($query);
			
			$query = "
				INSERT INTO gameroom_board_game_players
					(gameID, playerID, seatID, lastUpdate, playerName, ready)
				SELECT $this->gameID, playerID, if(seatID = 1, 2, 1), lastUpdate, playerName, 1
				FROM gameroom_board_game_players
				WHERE gameID = $lastGameID
			";
			$gameroomDB->query_write($query);
		}
		
		
		if ($gameType == GAMETYPE_CHESS)
		{
				$chess = new chessGame();
				$chess->gameID = $this->gameID;
				$chess->setupBoard();
		}
		else if ($gameType == GAMETYPE_REVERSI)
		{
				$reversi = new reversiGame();
				$reversi->gameID = $this->gameID;
				$reversi->setupBoard();
		} 
		else if ($gameType == GAMETYPE_CONNECT4)
		{
				$connect4 = new fourInARow();
				$connect4->gameID = $this->gameID;
				$connect4->setupBoard();
		} 
		else if ($gameType == GAMETYPE_CHECKERS)
		{
				$checkers = new checkers();
				$checkers->gameID = $this->gameID;
				$checkers->setupBoard();
		} 
		else if ($gameType == GAMETYPE_BATTLESHIP)
		{
				$battleship = new battleship();
				$battleship->gameID = $this->gameID;
				$battleship->setupBoard();
		} 
		if ($lastGameID == 0) 
			return "<root error=''><status gameID='$this->gameID' chatID='$gameroomChatroom->chatID' gameType='$gameType' /></root>";
		else
			return $this->gameID;
		
	}
	
	
	function joinGame()
	{
		global $gameroomUser, $gameroomDB, $gameroomLanguage;
		
		$gameID = $_GET['gameID'] * 1;
		
		
		$query = "
			SELECT gameroom_board_game.*
			FROM gameroom_board_game
			LEFT JOIN gameroom_board_game_players ON gameroom_board_game.gameID = gameroom_board_game_players.gameID  
			WHERE gameroom_board_game.gameID = $gameID
			AND playerID = $gameroomUser->userID
		";
		$result = $gameroomDB->query_read($query);
		if($row = $gameroomDB->fetch_array($result))
		{
			// already in game
			$ranked = $row['ranked'];
			$chatID = $row['chatID'];
			$this->gameType = $row['gameType'];
			$this->xml = "<root><status gameID='$gameID' chatID='$chatID' error='' gameType='$this->gameType' /></root>";
			return 0;
		}
		
		$query = "
			SELECT gameroom_board_game.*, COUNT(gameroom_board_game_players.playerID) AS numPlayers
			FROM gameroom_board_game 
			LEFT JOIN gameroom_board_game_players ON gameroom_board_game_players.gameID = gameroom_board_game.gameID
			WHERE gameroom_board_game.gameID = $gameID
			GROUP BY gameroom_board_game.gameID
			ORDER BY numPlayers DESC
		";
		$result = $gameroomDB->query_read($query);
		if($row = $gameroomDB->fetch_array($result))
		{
			$chatID = $row['chatID'];
			$this->gameType = $row['gameType'];
			require_once('gameroom/class_elo.php');
			$elo = new ranking($row['gameType'],$gameroomUser->userID, $gameroomUser->userID, 0);
			if ($row['password'])
			{
				if (base64_encode($_GET['password']) != $row['password'])
				{
					$this->xml = "<root><status error='Invalid Password.' /></root>";
					return 1;
				}
			}
			
			if ($row['numPlayers'] < $row['maxPlayers'])
			{
				$query = "
					SELECT seatID, playerID
					FROM gameroom_board_game_players 
					WHERE gameID =$gameID
					AND playerID > 0
				";
				$maxPlayers = $row['maxPlayers'];
				$result = $gameroomDB->query_read($query);
				$i = 0;
				$seatsTaken = array();
				while ($row = $gameroomDB->fetch_array($result))
				{
					$seatsTaken[$i] = $row['seatID'];
					$i++;
					if($row['playerID'] == $gameroomUser->userID)
					{
						// already in
						$this->xml = "<root><status gameID='$this->gameID' chatID='$chatID' gameType='$this->gameType' error='' /></root>";
						return 1;
					}
				}
				$playerSeat = rand() % $maxPlayers + 1;
				while (in_array($playerSeat, $seatsTaken))
					$playerSeat = rand() % $maxPlayers + 1;
				
				if(! $useStake == "1")
					$gameroomUserStake = 0;
				$time = time();
				$query = "
					INSERT INTO gameroom_board_game_players
						(gameID, playerID, playerName, seatID, lastUpdate)
					VALUES
						($gameID, $gameroomUser->userID, '$gameroomUser->userName', $playerSeat, $time)
				";
				
				$gameroomDB->query_write($query);
				$this->gameID = $gameID;
				$this->xml = "<root><status gameID='$this->gameID' chatID='$chatID' error='' gameType='$this->gameType' /></root>";
				
			}
			else
			{
				$this->xml = "<root><status error='" . $gameroomLanguage['boardgame']['Game_Is_Full'] . "' /></root>";
			}
		}
		else
		{
				$this->xml = "<root><status error='" . $gameroomLanguage['boardgame']['Game_No_Longer_Exists'] . "' /></root>";
		}
		
		
	}
	
	
	function surrender($reason = "Surrenders")
	{
		global $gameroomUser, $gameroomDB, $gameroomLanguage;
		$this->systemMsg("$gameroomUser->userName $reason", $gameroomLanguage['boardgame']['System_Name']);
		$query = "
			SELECT playerID 
			FROM gameroom_board_game_players
			WHERE gameID = $this->gameID 
			AND playerID <> $gameroomUser->userID
		";
		$result = $gameroomDB->query_read($query);
		
		if ($row = $gameroomDB->fetch_array($result))
		{
			$this->setWinner($row['playerID']);
		}
		
		
		
	}
	/*
	 * Set the winner, 0 for a draw / stalemate
	 */
	function setWinner($gameroomUserID)
	{
		global $gameroomUser, $gameroomDB;
		
		if ($this->winner)
			return 0;
			
		$this->winner = $gameroomUserID;
		$query = "
			UPDATE gameroom_board_game
			SET winner = $this->winner
			WHERE gameID = $this->gameID
		";
		$gameroomDB->query_write ($query);
		
		$this->getPlayerList();
		
		if ($this->ranked)
		{
			// 	*** if ranked do ELO stuff here
			require_once('gameroom/class_elo.php');
			if ($gameroomUserID == 0)
				$winnerSeat = 0;
			else if ($gameroomUserID == $this->player1ID)
				$winnerSeat = 1;
			else if ($gameroomUserID == $this->player2ID)
				$winnerSeat = 2;
			
			$elo = new ranking($this->gameType,$this->player1ID,$this->player2ID, $winnerSeat);
			$elo->updateRanks();			
		}
		
		$query = "
			UPDATE gameroom_board_game_players
			SET ready = 0
			WHERE gameID = $this->gameID
		";
		$gameroomDB->query_write ($query);	
	}
	
	function reduceTime()
	{
		global $gameroomDB, $gameroomUser;
		$t = time() - $this->lastUpdate;
		$query = "
			UPDATE gameroom_board_game_players
			SET timeRemaining = timeRemaining - $t
			WHERE gameID = $this->gameID
			AND playerID = $gameroomUser->userID 
		";
		$gameroomDB->query_write($query);
		return $t;
	}
	
	function getPlayerList($ignoreTime = false)
	{
		global $gameroomDB, $gameroomUser, $gameroomLanguage;
		
		$query = "
			SELECT *
			FROM gameroom_board_game_players
			LEFT JOIN gameroom_rank ON gameroom_rank.userID = gameroom_board_game_players.playerID
			WHERE gameroom_rank.gameType = $this->gameType 
			AND gameroom_board_game_players.gameID = $this->gameID
			ORDER BY seatID
		";
		$result = $gameroomDB->query_read($query);
		$xml = "<players>";
		$p = 0;
		while($row = $gameroomDB->fetch_array($result))
		{
			$p++;
			if (($this->turn == $row['seatID']) && ($this->winner == null))
				$isTurn = "true";
			else
				$isTurn = "false";
			
			$timeRemaining = $row['timeRemaining'];
				
			if ((! $ignoreTime) && ($this->timeControl > 0) && ($this->gameStarted) && ($this->winner === null) && ($isTurn == "true") && ($row['playerID'] == $gameroomUser->userID))
			{
				$timeRemaining -= $this->reduceTime();
				if ($timeRemaining <= 0)
					$this->surrender( $gameroomLanguage['boardgame']['Runs_Out_Of_Time'] );
			}
			$s =  $timeRemaining % 60;
			while(strlen($s) < 2)
				$s = "0" . $s;
			
			
			$timeRemaining = floor($timeRemaining / 60) . ":" . $s;
			if ($s == -1)
				$timeRemaining = "0:00";
			if ($this->ranked)
				$toolTip = $gameroomLanguage['boardgame']['Rank'] . ": " . $row['rank'];
			else
				$toolTip = "";
				
			if ($this->winner == $row['playerID'])
				$gameroomUserName = $row['playerName'] . " (W)";
			else if ($this->winner > 0 )
				$gameroomUserName = $row['playerName'] . " (L)";
			else if ($this->winner == "0" )
				$gameroomUserName = $row['playerName'] . " (D)";
			else
				$gameroomUserName = $row['playerName'] ;
			
			$gameroomUserName = htmlspecialchars($gameroomUserName, ENT_QUOTES);	
			$xml .= "<player seatID='" . $row['seatID'] . "' userID='" . $row['playerID'] . "' username='" . $gameroomUserName . "' isTurn='$isTurn' timeRemaining='$timeRemaining' toolTip='$toolTip' />";
			
			if ($row['seatID'] == 1)
			{
				$this->player1Name = htmlspecialchars($row['playerName'], ENT_QUOTES);	
				//$this->player1Name = $row['playerName'];
				$this->player1ID = $row['playerID'];
			}
			else
			{
				$this->player2Name = htmlspecialchars($row['playerName'], ENT_QUOTES);	
				//$this->player2Name = $row['playerName'];
				$this->player2ID = $row['playerID'];
			}
			
			
		}
		for ($p; $p < 2; $p++)
			$xml .= "<player q='' seatID='$p' userID='' username='" . $gameroomLanguage['boardgame']['Empty'] . "' isTurn='' toolTip='' />";
			
		$xml .= "</players>";
		return $xml;
	}
	function closeTimeControl()
	{
		global $gameroomUser, $gameroomDB, $game; 

		$t = 0;
		if ($game->timeControl == TIMECONTROL_INCREMENT)
		{
			$t = explode(",", $game->timeRules);
			$t = $t[1];
		}
		else if ($game->timeControl == TIMECONTROL_STANDARD)
		{
			$t = explode(",", $game->timeRules);
			$turn = $t[0];
			$t = $t[2] * 60;
			$query = "
				UPDATE gameroom_board_game_players
				SET timeRemaining = timeRemaining + $t, flags=$turn
				WHERE gameID = $game->gameID
				AND playerID = $gameroomUser->userID
				AND turn = $turn - 1 
			";
			$gameroomDB->query_write($query);
			$t = 0; 
		}
		$query = "
			UPDATE gameroom_board_game_players
			SET timeRemaining = timeRemaining + $t,
				turn = turn + 1
			WHERE gameID = $game->gameID
			AND playerID = $gameroomUser->userID 
		";
		$gameroomDB->query_write($query);
		
	}
	
	function setFlag($flag)
	{
		global $gameroomDB, $gameroomUser;
		
		if (!($this->flags & $flag))
		{
			$this->flags += $flag;
		
			$query = "
				UPDATE gameroom_board_game_players
				SET flags = $this->flags
				WHERE gameID = $this->gameID
				AND playerID = $gameroomUser->userID
			";
			$gameroomDB->query_write($query);
		}
	}
}
?>