<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

	error_reporting(E_ALL & ~E_NOTICE);
	define('NO_REGISTER_GLOBALS', 1);
	define('THIS_SCRIPT', 'gameroom'); // change this depending on your filename

if (! isset($_GET['do']))
{
	
	// vbulletin page gen
	
	$globaltemplates = array(
		'gameroom',
		'gameroom_html_status_box',
		'gameroom_html_status_box_cell'
	);

	require("./global.php");
	     
	$navbits = array(); 
	$navbits[$parent] = 'Gameroom';

	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('gameroom');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	print_output($templater->render());

}
else
{
	header("Pragma: bogus");
	header("Cache-Control: no-cache");
	
	$globaltemplates = array(
		'gameroom',
	);
	define('DISABLE_HOOKS', true);
	require('gameroom/functions_language.php');
	require("gameroom/class_main.php");
	
	include('gameroom/language.php');
	
	
	loadLanguage();
	
	require('gameroom/class_settings.php');
	require("gameroom/constants.php");
	$gameroomSettings = new gameRoomSettings();
	
	$do = htmlspecialchars($_GET['do'],ENT_QUOTES);
	
	if(! preg_match("/^[a-zA-Z0-9]*$/", $do)){
		notLoggedIn();
		exit();
	}
	
	
	switch($do)
	{
		case "test":
			var_dump($gameroomSettings);
			var_dump($gameroomLanguage);
			exit();
			break;
		case "blackjackf":
			require('gameroom/blackjack_dealf.php');
		break;
		
		case "slotsf":
			require('gameroom/slots_ajaxf.php');
		break;

		case "videopokerf":
			require('gameroom/vidpokf_redeal.php');
		break;

		case "letemridef":
			require('gameroom/letemridef_deal.php');
		break;

		case "roulette":
			require('gameroom/roulette.php');
		break;

		case "sportspoolf":
			require('gameroom/sportspoolf.php');
		break;

		case "chatroom":
			require('gameroom/chatroom.php');
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
		
			$lobby = new chatRoom;
		
			$lobby->init();
			$lobby->getMessages();
			$lobby->getXML();
			
			printGameroomOutput( $lobby->xml);
			
		break;
		
		case "poker":
			require('gameroom/poker.php');
		break;
		
		case "boardgame":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			require('gameroom/class_boardgame.php');
			$game = new boardGame;
			$game->init();
			$game->runGame();
			
			//require_once('gameroom/chess.php');
		break;
		
		case "getLanguage":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			printGameroomOutput( getLanguage());
		break;	
		
		case "exportLanguage":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			exportLanguage();
		break;	
		
		case "getLanguageEdit":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			printGameroomOutput( getLanguageEdit());
		break;	
		
		case "saveLanguage":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			printGameroomOutput( saveLanguage());
		break;	
		
		case "stats":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			
			require("gameroom/class_stats.php");
			$stats = new stats;
			printGameroomOutput( $stats->getStats());
		break;	
		
		case "adjust":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			require("gameroom/class_adjust.php");
			$adjust = new adjust();
			printGameroomOutput( $adjust->adjustCash());
		break;
		
		case "banner":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			require("gameroom/class_banner.php");
			$banner = new banner();
			echo $banner->getBanner();
		break;
		
		case "bannerHTML":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			require("gameroom/class_banner.php");
			$banner = new banner();
			echo $banner->getBannerHTML();
		break;
		
		case "transfer":
			require("gameroom/functions_transfer.php");
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			printGameroomOutput(transferCash());
		break;
		
		case "transferlog":
			require("gameroom/functions_transfer.php");
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			printGameroomOutput(getTransferLog());
		break;
		
		case "getSettingsEdit":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			printGameroomOutput($gameroomSettings->getSettingsForEdit());
		break;
		
		case "clearStats":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			if($gameroomUser->isAdmin)
			{
				$gameroomDB->query_write("DELETE FROM gameroom_bet_stats");
				printGameroomOutput("<root><done /></root>");
			}
		break;

		case "updatecash":
			$gameroomUser = new userInfo;
			$gameroomUser->user_info();
			printGameroomOutput("<root><data cash='$gameroomUser->cash' /></root>");
		break;
		
	}
}	
	function notLoggedIn()
	{
		global $gameroomLanguage;
		printGameroomOutput("<root><status userID='' msg='" . $gameroomLanguage['common']['Not_Logged_In'] . "'/></root>");
		exit();
		
	}
	function printGameroomOutput($output)
	{
		global $gameroomSettings;
		
		if($gameroomSettings->usePrintOutput)
			print_output($output);
		else
		{
			header("Content-type: text/xml");
			echo $output;
			exec_shut_down();
		}
	}


?>
