<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/


	class sportsPool extends casinoGame
	{
		var $isAdmin = 0;
		
		function init()
		{
			global $gameroomSettings, $gameroomUser;
			$this->gameID = GAMEID_SPORTS_BETTING;
			if ((in_array($gameroomUser->userID, $gameroomSettings->adminIDs)) || ((in_array($gameroomUser->userID, $gameroomSettings->modIDs))))
				$this->isAdmin = 1;
				
			$this->gameCode = "sportspool";
			$this->initGame();
		}
		
		function getMoneyLineReturn($odds, $bet)
		{
			if ($odds > 0)
				$return = ($odds / 100) + 1;
			else
				$return = (100 / abs($odds)) + 1;
			$return = $return * $bet;
			
			return $return;
		}
		
		function addEvent()
		{
			global $gameroomDB, $gameroomUser, $gameroomLanguage;
			
			if (! $this->isAdmin)
				return false;
				
			$eventDate = $_GET['eventDate'];
			$eventTime = $_GET['eventTime'];
			
			if (!get_magic_quotes_gpc()) 
			{
				$eventName = addslashes(htmlspecialchars($_GET['eventName'],ENT_QUOTES));
			} else 
			{
				$eventName = htmlspecialchars($_GET['eventName'],ENT_QUOTES);
			}
			
			if((strlen($eventName) < 4) || (! $_GET['outcome1']) || (! $_GET['outcome2']))
				exit();
				
			$groupID = $_GET['groupID'] * 1;
			
			if($groupID < 1)
				return "<root><error msg='" . $gameroomLanguage['sportsPool']['No_Group'] . "' /></root>'";
				
			$year = substr($eventDate, 0, 4) * 1;
			$month = substr($eventDate, 5, 2) * 1;
			$day = substr($eventDate, 8, 2) * 1;
			$hour = substr($eventTime, 0, 2) * 1;
			$minute = substr($eventTime, 2, 2) * 1;
			
			$eventDate = mktime($hour, $minute, 0, $month, $day, $year);
			
			$query = "
				INSERT INTO gameroom_sb_events
					(groupID, eventName, eventDate)
				VALUES
					($groupID, '$eventName', $eventDate)
			";
			$gameroomDB->query_write($query);
			
			$query = "
				SELECT MAX(eventID) AS id
				FROM gameroom_sb_events
				WHERE eventName = '$eventName'
				AND eventDate = $eventDate
			";
			$result = $gameroomDB->query_read($query);
			if($row = $gameroomDB->fetch_array($result))
				$eventID = $row['id'];
			else
				return "<root><error msg='" . $gameroomLanguage['sportsPool']['Unable_To_Add_Event'] . "' /></root>";

				
			for($i = 1; $i < 19; $i++)
			{
				$v = "outcome" . $i;
				$m = "moneyline" . $i;
				if (!get_magic_quotes_gpc()) 
				{
					$outcomeName = addslashes(htmlspecialchars($_GET[$v],ENT_QUOTES));
				} else 
				{
					$outcomeName = htmlspecialchars($_GET[$v],ENT_QUOTES);
				}
				$moneyline = $_GET[$m] * 1;
				if(strlen($outcomeName) > 0)
				{
					$query = "
						INSERT INTO gameroom_sb_outcomes
							(eventID, outcomeName, moneyline, totalbets)
						VALUES
							($eventID, '$outcomeName', $moneyline, 0)
					";
					$gameroomDB->query_write($query);
				}
			}
			return "<root><done /></root>";
		}
		function getGroups()
		{
			global $gameroomDB, $gameroomUser;
			
			$query = "
				SELECT groupID, groupName
				FROM gameroom_sb_groups
				ORDER BY groupName
			";
			$result = $gameroomDB->query_read($query);
			$output = "<root timeZone='" . date("T") . "'>";
			$output .= "<group id='' name='' />";
			while($row = $gameroomDB->fetch_array($result))
			{
				$output .= "<group id='" . $row['groupID'] . "' name='" . $row['groupName'] . "' />";
			}
			$output .= "</root>";
			return $output;
		}
		
		function addGroup()
		{
			global $gameroomDB, $gameroomUser;
			
			if (! $this->isAdmin)
				return false;
			
			if (!get_magic_quotes_gpc()) 
			{
				$newgroup = addslashes(htmlspecialchars($_GET['newgroup'],ENT_QUOTES));
			} else 
			{
				$newgroup = htmlspecialchars($_GET['newgroup'],ENT_QUOTES);
			}
	
			$query = "
				SELECT * 
				FROM gameroom_sb_groups
				WHERE groupName = '" . $newGroup . "' 
			";
			$result = $gameroomDB->query_read($query);
			if (strlen($newgroup) < 3)
			{
				$error = $gameroomLanguage['sportsPool']['Group_Name_Length'];
				
				return "<root><status error='1' msg='$error' /></root>";
			}
			else if($row  = $gameroomDB->fetch_array($result))
			{
				$error = $gameroomLanguage['sportsPool']['Group_Name_Exists'];
				return "<root><status error='1' msg='$error' /></root>";
				
			}
			else
			{
				$query = "
					INSERT INTO gameroom_sb_groups 
						(groupname) 
					VALUES 
						('$newgroup')				
				";
				$gameroomDB->query($query);
				return "<root><status error='0' /></root>";
			}
		}
						
		function placeBet()
		{
			global $gameroomDB, $gameroomUser;
			
			$outcomeID = $_GET['outcomeID'];
			$this->bet = $_GET['bet'];
			
			if((! is_numeric($this->bet)) || (! is_numeric($outcomeID)) || ($this->bet < 1))
			{
				$output = "<root><status error='1' /></root>";
			}
			if($this->bet > $gameroomUser->cash)
			{
				$output = "<root><status error='2' /></root>";
			}
			else
			{
				$time = time();
				$query = "
					SELECT gameroom_sb_events.eventid AS eventid, outcomeid, totalbets 
					FROM gameroom_sb_events, gameroom_sb_outcomes 
					WHERE gameroom_sb_events.eventid = gameroom_sb_outcomes.eventid   
					AND outcomeID = $outcomeID
					AND eventdate > $time
				";
				
				$events = $gameroomDB->query_read($query);
			
				if (($event = $gameroomDB->fetch_array($events) && $this->bet > 0))
				{

					$gameroomUser->record_cash($this->gameID, $this->bet * -1);
					
					$query = "SELECT * FROM gameroom_sb_bets WHERE userid = $gameroomUser->userID AND outcomeid = $outcomeID";
					$result = $gameroomDB->query_read($query); 
					if ($row =  $gameroomDB->fetch_array($result))
					{
						$query = "UPDATE gameroom_sb_bets SET betamount = betamount + $this->bet WHERE userid = $gameroomUser->userID AND outcomeid = $outcomeID";
						$gameroomDB->query_write($query);
					}
					else 
					{
						$query = "INSERT INTO gameroom_sb_bets (userid, outcomeid, betamount) VALUES ($gameroomUser->userID, $outcomeID, $this->bet)";
						$gameroomDB->query_write($query);
					}
					$query = "UPDATE gameroom_sb_outcomes SET totalbets = totalbets + $this->bet WHERE outcomeid = $outcomeID";
					$gameroomDB->query_write($query);
					$output = "<root><status error='0' /></root>";
				}
				else
				{
					$output = "<root><status error='3' /></root>";
				}
			}			
			return $output;					
		}
		
		
		function getEventDetails()
		{
			global $gameroomDB, $gameroomUser;
			
			$eventID = $_GET['eventID'];
			if(!is_numeric($eventID))
				exit();
			
			$query = "
				SELECT gameroom_sb_outcomes.outcomeid, outcomename, totalbet, userBet, eventdate, result, moneyline
				FROM gameroom_sb_events
				LEFT JOIN gameroom_sb_outcomes ON gameroom_sb_events.eventid = gameroom_sb_outcomes.eventid
				LEFT JOIN (
					SELECT sum(betamount) AS totalbet, outcomeid
					FROM gameroom_sb_bets
					GROUP BY outcomeid
				) outcomes on outcomes.outcomeid = gameroom_sb_outcomes.outcomeid
				LEFT JOIN (
					SELECT sum(betamount) AS userBet, sum(winings) AS winings, outcomeid
					FROM gameroom_sb_bets
					WHERE userid = $gameroomUser->userID
					GROUP BY outcomeid
				) bet on bet.outcomeid = gameroom_sb_outcomes.outcomeid
				WHERE gameroom_sb_events.eventid = $eventID
			";
			
			$output = "";
			$events = $gameroomDB->query_read($query);
			while($row = $gameroomDB->fetch_array($events))
			{
				if ($output == "" )
				{
					$endDate = date("M. d, Y", $row['eventdate']);
					$endTime = date("g:ia", $row['eventdate']);
	  				$status = "<status endDate='$endDate' endTime='$endTime' eventID='$eventID'";
										
				}
				if($row['outcomeid'] == $row['result'])
					$won = $row['outcomename'];
				if($row['result'] == -1)
					$won = "Draw / Cancelled";
					
				$output .= "<outcome id='" . $row['outcomeid'] . "' name='" . $row['outcomename'] . "' totalBet='" . $row['totalbet'] . "' bet='" . $row['userBet'] . "' winings='" . $row['winings'] . "' moneyline='" . $row['moneyline'] . "' />";
			}
				
			$status .= " result='$won' />";
		 	$output = "<root>"  . $status . $output . "</root>";
  			
  			return $output;
		}
		
		
		function getEvents($eventType)
		{
			global $gameroomDB, $gameroomUser;
			
			
			$time = time();
			if($eventType == "recent")
				$query = "
					SELECT *
					FROM gameroom_sb_events
					LEFT JOIN gameroom_sb_groups ON gameroom_sb_events.groupid = gameroom_sb_groups.groupid
					WHERE eventdate < $time
					AND eventdate > $time - (60*60*24*30)
					ORDER BY groupname
				";
			else if($eventType == "all")
				$query = "
					SELECT *
					FROM gameroom_sb_events
					LEFT JOIN gameroom_sb_groups ON gameroom_sb_events.groupid = gameroom_sb_groups.groupid
					WHERE eventdate < $time
					ORDER BY groupname asc, eventdate desc
				";
			else if($eventType == "settle")
			{
				if (! $this->isAdmin)
					return false;
				
				$query = "
					SELECT *
					FROM gameroom_sb_events
					LEFT JOIN gameroom_sb_groups ON gameroom_sb_events.groupid = gameroom_sb_groups.groupid
					WHERE eventdate < $time
					AND result IS NULL
					ORDER BY groupname asc, eventdate desc
				";
			}
			else
				$query = "
					SELECT *
					FROM gameroom_sb_events
					LEFT JOIN gameroom_sb_groups ON gameroom_sb_events.groupid = gameroom_sb_groups.groupid
					WHERE eventdate > $time
					AND result IS NULL
					ORDER BY groupname asc, eventdate desc
				";
			
			$events = $gameroomDB->query_read($query);
			$eventTree = array();
			$output = "";
			
			while($row = $gameroomDB->fetch_array($events))
			{			
				if((isset($groupName)) && ($groupName != $row['groupname']))
				{
					$output .= "</cat>\n";
					$groupName = $row['groupname'];
					$output .= "<cat title='$groupName'>\n";
				}
				else if (! isset($groupName))
				{
					$groupName = $row['groupname'];
					$output = "<cat title='$groupName'>\n";
				}
				
				$eventID = $row['eventid'];
				$eventName = $row['eventname'];
				$output .= "<event id='$eventID' name='$eventName' />\n";
				
			}
			
			
			if(strlen($output) > 2)
				$output = "<root cash='$gameroomUser->cash' isAdmin='$this->isAdmin'>". $output . "</cat>\n</root>";
			else
				$output = "<root cash='$gameroomUser->cash' isAdmin='$this->isAdmin'><cat />\n</root>";
			
			return $output;
		}
		
		function deleteEvent()
		{
			global $gameroomUser;
			global $gameroomDB;
			global $gameid;
			
			if (! $this->isAdmin)
				return false;
			
			$eventID = $_GET['eventID'] * 1;
			$query = "
				DELETE FROM gameroom_sb_events 
				WHERE eventid = $eventID
			";
			$gameroomDB->query_write($query);
			return 1;
			
		}
		function closebets()
		{
			global $gameroomUser;
			global $gameroomDB;
			global $gameid;
			
			if (! $this->isAdmin)
				return false;
			
			$eventID = $_GET['eventID'] * 1;
		
			$time = floor(time() / 1800) * 1800 ;
			
			$query = "
				UPDATE gameroom_sb_events 
				SET eventDate='$time' 
				WHERE eventid = $eventID
			";
			$gameroomDB->query_write($query);
			return 1;
		}
		
		function settlebets()
		{
			global $gameroomUser;
			global $gameroomDB;
			global $gameid;
			
			if (! $this->isAdmin)
				return false;
			
			$eventID = $_GET['eventID'];
			$outcomeID = $_GET['outcomeID'];
			
			if((!is_numeric($eventID)) || (! is_numeric($outcomeID)))
				exit();
			
			$time = time();		
			$query = "
				SELECT * 
				FROM gameroom_sb_events 
				WHERE eventid = $eventID
				AND result IS NULL
			";
			$events = $gameroomDB->query_read($query);
			if($event = $gameroomDB->fetch_array($events))
			{
				$eventName = $event['eventname'];
	
				if($outcomeID == -1)
				{
					// no winner, return cash
					$query = "
						UPDATE gameroom_sb_events 
						SET result = -1 
						WHERE eventid=$eventID
					";
					$gameroomDB->query_write($query);				
	
					$query = "
						SELECT * 
						FROM gameroom_sb_outcomes 
						WHERE eventid=$eventID
					";
					$outcomes = $gameroomDB->query_read($query);
					while ($outcome = $gameroomDB->fetch_array($outcomes))
					{
						$result = $outcome['outcomeid'];
						$query = "
							SELECT * 
							FROM gameroom_sb_bets 
							WHERE outcomeid=$result
						";
						$bets = $gameroomDB->query_read($query);
						while ($bet = $gameroomDB->fetch_array($bets))
						{
							$betid = $bet['betid'];
							$u = $bet['userid'];
							$b = $bet['betamount'];
							$query = "
								UPDATE gameroom_sb_bets 
								SET winings = $b 
								WHERE betid = $betid
							";
	
							$gameroomDB->query($query);
	
							$gameroomUser->record_cash($this->gameID, $b, $u);
						}
					}
				}
				if($outcomeID > 0)
				{
					$query = "
						UPDATE gameroom_sb_events 
						SET result = $outcomeID 
						WHERE eventid=$eventID
					";
					$gameroomDB->query($query);
	
					$query = "
						SELECT * 
						FROM gameroom_sb_outcomes 
						WHERE eventid=$eventID
					";
					$outcomes = $gameroomDB->query_read($query);
	
					$total = 0; // Total bet on event
					$share = 0; // Total Bet on winning outcome
					while ($outcome = $gameroomDB->fetch_array($outcomes))
					{
						if($outcomeID == $outcome['outcomeid'])
							$share = $outcome['totalbets'];
						$total += $outcome['totalbets'];
					}
					
					$query = "
						SELECT gameroom_sb_bets.* , moneyline
						FROM gameroom_sb_bets 
						LEFT JOIN gameroom_sb_outcomes ON gameroom_sb_outcomes.outcomeid =gameroom_sb_bets.outcomeid 
						WHERE gameroom_sb_bets.outcomeid=$outcomeID
					";
					$bets = $gameroomDB->query_read($query);
					while ($bet = $gameroomDB->fetch_array($bets))
					{
						$betid = $bet['betid'];
						$u = $bet['userid'];
						$b = $bet['betamount'];
						if ($bet['moneyline'] != 0)
						{
							$moneyline = $bet['moneyline'];
							$w = $this->getMoneyLineReturn($moneyline, $b);
							$query = "
								UPDATE gameroom_sb_bets 
								SET winings = $w 
								WHERE betid = $betid
							";
							$gameroomDB->query_write($query);
							$gameroomUser->record_cash($this->gameID, $w, $u);
						}
						else 
						{
							if($share > 0)
								$w = round(($b / $share) * $total);
							else 
								$w = 0;
							$query = "
								UPDATE gameroom_sb_bets 
								SET winings = $w 
								WHERE betid = $betid
							";
							$gameroomDB->query_write($query);
							$gameroomUser->record_cash($this->gameID, $w, $u);
						}
					}
				}
			}
		}
}

	
	// End Class 
	$gameroomUser = new userInfo;
	$gameroomUser->user_info();
	
	$sp = new sportsPool;
	
	$sp->init();
	
	
	if($_GET['req'] == "getEvent")
		$output =  $sp->getEventDetails();
	else if($_GET['req'] == "placeBet")
		$output =  $sp->placeBet();
	else if($_GET['req'] == "settle")
	{
		$sp->settlebets();
		if (isset($_GET['open']))
			$output = $sp->getEvents("open");
		else
			$output = $sp->getEvents("settle");
	}
	else if($_GET['req'] == "close")
	{
		$sp->closebets();
			$output = $sp->getEvents("open");
	}
	else if ($_GET['req'] == "getGroups")
		$output = $sp->getGroups();
	else if ($_GET['req'] == "addGroup")
		$output = $sp->addGroup();
	else if($_GET['eventType'] == "all")
		$output = $sp->getEvents("all");
	else if($_GET['eventType'] == "recent")
		$output = $sp->getEvents("recent");
	else if($_GET['eventType'] == "settle")
		$output = $sp->getEvents("settle");
	else if($_GET['req'] == "addEvent")
		$output = $sp->addEvent();
	else if($_GET['req'] == "delete")
	{
		$sp->deleteEvent();
		$output = $sp->getEvents("all");
	}
	else
		$output = $sp->getEvents("open");
		
	printGameroomOutput( $output);

?>