<?php
/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/

class reversiGame
{
	var $myColor, $myTurn, $error = 0, $pageXML, $gameID, $whosTurn;
	var $canMove, $canMove1, $canMove2;
	

	function init()
	{
		global $gameroomUser, $gameroomDB, $game, $gameroomLanguage;
		
		$playerList = $game->getPlayerList();
		$x  = $_GET['sx'];
		$y  = $_GET['sy'];
		if ($this->myColor == 2)
		{
			$x  = 9 - $x;
			$y  = 9 - $y;
		}
		
		$this->piecenames = array();
		$this->pieceNames[1] = $gameroomLanguage['chess']['White'];
		$this->pieceNames[2] = $gameroomLanguage['chess']['Black'];
		
		$this->pieceImages = array();
		$this->pieceImages[1] = 'gameroom/images/reversi-w.png';
		$this->pieceImages[2] = 'gameroom/images/reversi-b.png';
		
		$this->board= array();
		$query = "SELECT * FROM gameroom_chess_pieces WHERE gameid = $this->gameID ORDER BY boardid";
		$result = $gameroomDB->query_read($query);
		while ($row = $gameroomDB->fetch_array($result))
		{
			$i = $row['boardID'];
			$this->board[$i] = $row['pieceID'];
		}
	
		if ($this->myColor == $this->whosTurn)
		{
			$this->myTurn = "true";
			if ($x && $y)
			{
				$this->placePiece($x, $y);
				$game->validMoveStatus = false;
			}
		}
		else
			$this->myTurn = "false";
		
		if ((! $game->validMoveStatus) || (($game->winner == null) && ($game->statusFlags == 0)))
		{
			$this->canMove1 = $this->canMove(1);
			$this->canMove2 = $this->canMove(2);
			
			$game->statusFlags = 0;
			if ($this->canMove1)
				$game->statusFlags += FLAG_CANMOVE_1;  
			if ($this->canMove2)
				$game->statusFlags += FLAG_CANMOVE_2;
			$gameroomDB->query_write("
				UPDATE gameroom_board_game 
				SET statusFlags = $game->statusFlags 
				WHERE gameID = $game->gameID
			"); 
				 
		}	
		else
		{
			if ($game->statusFlags & FLAG_CANMOVE_1)
				$this->canMove1 = 1;
			else
				$this->canMove1 = 0;

			if ($game->statusFlags & FLAG_CANMOVE_2)
				$this->canMove2 = 1;
			else
				$this->canMove2 = 0;
				
		}
		if ($this->myColor == 1)
			$this->canMove = $this->canMove1;
		else
			$this->canMove = $this->canMove2;
		
		if (($game->winner === "0") || ($this->winner > 0))
			$this->myTurn = "false";
		$this->drawBoard($playerList);
		
	}
	
	
	function drawBoard($playerList)
	{
		global $gameroomUser, $gameroomDB, $game, $gameroomLanguage, $gameroomSettings;
		
		$page = $playerList;
		if ($game->winner)
			$game->gameStarted = 2;
		$page .= "<Board winner='$game->winner' gameID='$game->gameID' timeControl='$game->timeControl' drawOffer='$game->drawOffer' gameStarted='$game->gameStarted' myTurn='$this->myTurn' myColor='$this->myColor' canMove='$this->canMove' canMove1='$this->canMove1' canMove2='$this->canMove2' noOpponent='$game->gameOverAlone' timeOut='$game->timeOutWarning'>\n";
		
		for ($y = 1; $y < 9; $y++)
		{
			for ($x = 1; $x < 9; $x++)
			{
				// set cell background
				if((($x % 2) + $y) % 2) 
					$c = $gameroomSettings->reversi['light_color'];
				else 
					$c = $gameroomSettings->reversi['dark_color'];
								
				$v = ($y-1) * 8 + $x;
	
				if($this->myColor == 2)
					$v = 65 - $v;
					
				$s = 0;
				if($this->board[$v] > 0){
					$p = $this->board[$v];
					$pname = $this->pieceNames[$p];
					$pImg = $this->pieceImages[$p];
					
					if(($p % 2 == 1) && ($this->myColor == 2))
						$mine = "1";
					else if(($p % 2 == 0) && ($this->myColor == 1))
						$mine = "1";
					else
						$mine = "0";
					
					$page .= "<grid id='$p' mine='$mine' title='$pname' selected='$s' x='$x' y='$y' background='$c' backgroundColor='$c' width='59' height='53' img='$pImg' />\n";
				}
	
				else 
					$page .= "<grid title=''  mine='0' selected='$s' x='$x' y='$y' id='g$x$y' background='$c' backgroundColor='$c' width='59' height='53' img='' />\n";
			}
			
		}
		$page .= "</Board>\n";
		
		$this->pageXML = $page;		
	}
	
	
	function setupBoard()
	{
		global $gameroomDB, $gameroomUser;
		$board = array();
		$board[28] = 1;
		$board[29] = 2;
		$board[36] = 2;
		$board[37] = 1;
		
		// End starting layout 
		$gameroomDB->query_write("DELETE FROM gameroom_chess_pieces WHERE gameID = $this->gameID ");
		for($x=1;$x<65;$x++)
		{
			if(! $board[$x]) $board[$x] = 0;
			$query = "INSERT INTO gameroom_chess_pieces (gameID, boardID, pieceID) VALUES ($this->gameID, $x, $board[$x])";
			$gameroomDB->query_write($query);
		}
		
	}
	
	function checkSquare($x, $y, $board = "")
	{
		if ($board =="" )
			$board = $this->board;	
			
		if(($x <1)||($x >8)||($y <1)||($y >8))
			return -1;
			
		$i = (($y-1) * 8) + $x;
		if($board[$i] <> 0)
		{
			return $board[$i];
		}
		return 0;
	}		

	function nextTurn()
	{
		global $gameroomDB, $game;
		
		if ($this->whosTurn == 1)
			$this->whosTurn = 2;
		else
			$this->whosTurn = 1;
		
		$query = "
			UPDATE gameroom_board_game 
			SET move = $this->whosTurn 
			WHERE gameID = $this->gameID
		";
		$gameroomDB->query_write($query);
		
		$this->canMove1 = $this->canMove(1);
		$this->canMove2 = $this->canMove(2);

		$game->statusFlags = 0;
		if ($this->canMove1)
			$game->statusFlags += FLAG_CANMOVE_1;  
		if ($this->canMove2)
			$game->statusFlags += FLAG_CANMOVE_2;
		$gameroomDB->query_write("
			UPDATE gameroom_board_game 
			SET statusFlags = $game->statusFlags 
			WHERE gameID = $game->gameID
		"); 
		$game->validMoveStatus = true;
		if ($this->myColor == 1)
			$this->canMove = $this->canMove1;
		else
			$this->canMove = $this->canMove2;
		
		if ((! $this->canMove1) && (! $this->canMove2))
			$this->endGame();
		else if ((! $this->canMove1) && ($this->whosTurn == 1))
			$this->nextTurn();
		else if ((! $this->canMove2) && ($this->whosTurn == 2))
			$this->nextTurn();
	}
	
	function endGame()
	{
		global $gameroomDB, $game, $gameroomLanguage;
		
		$black = 0;
		$white = 0;
		
		foreach ($this->board as $p)
		{
			if ($p == 1)
				$white++;
			else if ($p == 2)
				$black++;
		}
		
		if ($black == $white)
			$game->setWinner(0);
		else
		{
			if ($black > $white)
				$query = "
					SELECT playerID
					FROM gameroom_board_game_players
					WHERE gameID = $this->gameID
					AND seatID = 2
				";
			else
				$query = "
					SELECT playerID
					FROM gameroom_board_game_players
					WHERE gameID = $this->gameID
					AND seatID = 1
				";
			$result = $gameroomDB->query_read($query);
			if ($row = $gameroomDB->fetch_array($result))
			{
				$game->setWinner($row['playerID']);
				$game->systemMsg($gameroomLanguage['reversi']['Final_Score'] . ": " . $gameroomLanguage['reversi']['Black'] . " " . $black . " / " . $gameroomLanguage['reversi']['White'] . " " . $white, $gameroomLanguage['boardgame']['System_Name']);
				
			}
		}
		
	}
	
	
	function placePiece($x, $y, $test = false, $myColor = false)
	{
		
		global $gameroomDB;
		if (! $myColor)
			$myColor = $this->myColor;
			
		if ($this->checkSquare($x, $y) > 0)
			return 0;
			
		$flipped = 0;
		for ($xd = -1; $xd < 2; $xd++)
			for ($yd = -1; $yd < 2; $yd++)
				if ((($xd != 0) || ($yd != 0)) && ($x + $xd > 0) && ($x + $xd < 9) && ($y + $yd> 0) && ($y + $yd < 9))
				{
					$color = $this->checkSquare($x + $xd, $y + $yd);
					if ((isset($_GET['test1'])) && (! $test))
						echo "$x, $y | $xd, $yd  (c = $color, $this->myColor) <br/>";
						
					if (($color > 0) && ($color != $myColor))
					{
						
						$flipped += $this->runWithIt($x, $y, $xd, $yd, $test, $myColor);
					}
				}
		
		if (($flipped > 0) && (! $test))
		{ 
			$i = (($y-1) * 8) + $x;
			$this->board[$i] = $myColor;
			$query = "
				UPDATE gameroom_chess_pieces
				SET pieceID = $myColor
				WHERE boardID = $i
				AND gameID = $this->gameID
			";
			//echo $query;
			$gameroomDB->query_write($query);
			
			$this->nextTurn();
		}
		return $flipped;
	}
	
	
	function runWithIt($x, $y, $xd, $yd, $test, $myColor)
	{
		global $gameroomDB;
		$done = false;
		$x2 = $x + $xd;
		$y2 = $y + $yd;
		$doFlip = false;
		$count = 0;
		
		while (($x2 > 0) && ($y2 > 0) && ($x2 < 9) && ($y2 < 9) && (! $done))
		{
			$p = $this->checkSquare($x2, $y2);
			if ($p == 0)
				$done = true;
			else if ($p == $myColor)
			{
				$done = true;
				$doFlip = true;
			}
			$x2 += $xd;
			$y2 += $yd;
		}
		$x2 = $x + $xd;
		$y2 = $y + $yd;
		$done = false;
		if (($doFlip) && (! $test))
		{
			while (($x2 > 0) && ($y2 > 0) && ($x2 < 9) && ($y2 < 9) && (! $done))
			{
				if ((isset($_GET['test1'])) && (! $test))
					echo "<br/># $x2, $y2 $done<br/>";
			
				$p = $this->checkSquare($x2, $y2);
				if ($p == $myColor)
					$done = true;
				else
				{
					$count++;
					$i = (($y2-1) * 8) + $x2;
					$this->board[$i] = $myColor;
					$query = "
						UPDATE gameroom_chess_pieces
						SET pieceID = $myColor
						WHERE boardID = $i
						AND gameID = $this->gameID
					";
					$gameroomDB->query_write($query);
				}
				$x2 += $xd;
				$y2 += $yd;
			}
			
		}
		if ($test)
			return $doFlip;
		else
			return $count;
	}
	
	
	function canMove($color)
	{
		$move = 0;
		for ($x = 1; $x < 9; $x++)
			for ($y = 1; $y < 9; $y++)
			{
				if ($this->checkSquare($x, $y) == 0)
				{
					$move += $this->placePiece($x, $y, true, $color);
				}
			}
		return $move;
	}
}
?>