<?php

/***********************************************************
 * The Gameroom                                            *
 * http://vbgaming.org                                     *
 * (c) 2009 Andrew Green                                   *
 * This file may not be redistributed without permission   *
 ***********************************************************/
	function getTransferLog()
	{
		global $gameroomUser, $gameroomSettings, $gameroomDB, $gameroomLanguage;

		if (! $gameroomUser->isAdmin)
			return false;
			
		$query = "
			SELECT * 
			FROM gameroom_donatelog
			ORDER BY dtime DESC
			LIMIT 100
		";
		$output = "<root>";
		$result = $gameroomDB->query_read($query);
		while ($row = $gameroomDB->fetch_array($result))
		{
			$from = htmlspecialchars($row['fromuser'], ENT_QUOTES);
			$to = htmlspecialchars($row['touser'], ENT_QUOTES);
			$amount = $row['amount'];
			$time = date("M j, Y g:i a", $row['dtime']);
			$output .= "<donate to='$to' from='$from' amount='$amount' date='$time' />";
		}
		$output .="</root>";
		return $output;
	}

	function transferCash()
	{
		global $gameroomUser, $gameroomSettings, $gameroomDB, $gameroomLanguage;

		if (! $gameroomSettings->allowTransfers)
			return false;
			
		$giveto = addslashes($_GET['user']);	
		$amount = $_GET['amount'] * 1;	
	
		$result = $gameroomDB->query_read("SELECT userid FROM " . $gameroomSettings->userTable . " WHERE " . $gameroomSettings->userNameField . "= '$giveto'");
		if ($row = $gameroomDB->fetch_array($result))
			$toid = $row['userid'];
		else
			return "<root><status error='" . $gameroomLanguage['common']['Invalid_Username'] . "' /></root>";
		
		if(($giveto) && ($amount))
		{	
			if(($amount > $gameroomUser->cash)|| ($amount < 0))
				return "<root><status error='" . $gameroomLanguage['common']['Not_Enough_Cash'] . " - $gameroomUser->cash' /></root>";
			
			$gameroomUser->record_cash(0, $amount, $toid);
			$gameroomUser->record_cash(0, $amount * -1, $gameroomUser->userID);
		
			$time = time();
			$gameroomDB->query("INSERT INTO gameroom_donatelog (fromuser, touser, amount, dtime) VALUES ('" . $gameroomUser->userName . "', '$giveto', $amount, $time)");
			return "<root><status error='' /></root>";
		}
	}
		
?>